window.addEventListener("load", (event) => {

	let input = document.createElement("input");
	input.id = "filter-grid";
	input.type = "text";
	input.placeholder = "Busca Dinâmica";
	input.classList.add("css_toolbar_obj_text");
	input.style.border = "none";

	let quicksearchAll = document.querySelector("#quicksearchph_top");
	quicksearchAll.innerHTML = '';
	quicksearchAll.appendChild(input);

	let table = document.querySelector('[id*="sc-ui-grid-body"]');

	//Criando busca dinamica
	input.addEventListener("keyup", (event) => {

		let linhas = table.querySelectorAll('[id*="SC_ancor"]');
		let busca = input.value.toLowerCase();


		for (let i = 0; i < linhas.length; i++) {
			let span = linhas[i].querySelector('[id*="id_sc_field_nome_1100"]');

			if (span) {
				let nome = span.innerText;

				if (nome.toLowerCase().indexOf(busca) > -1) {
					linhas[i].style.display = "";

					// Coloca em destaque o texto buscado
					span.innerHTML = nome.replace(
						new RegExp(busca, "gi"),
						(match) => "<span style='color: red;'>" + match + "</span>"
					);
				} else {
					linhas[i].style.display = "none";
				}
			}
		}


	});


});