function renderSimpleChart(renderAt, data, chartConfig, width="100%", height="300", chartType="column2d") {
			
		let config = {
			type: chartType,
			renderAt: renderAt,
			width: width,
			height: height,
			dataFormat: 'json',
			dataSource: {
				"chart": {
					"showValues": "1",
					"theme": "fusion",
					"paletteColors": "#8b8fd7, #9e78d0, #c660c5, #df8492, #fbcc8a, #e9ec80, #b0e17a, #87e2bb, #8aeaec, #5967ea",
					"plottooltext": `<b>${chartConfig.xAxisName}:</b> $label<br/><b>Total:</b> $value`,
					...chartConfig,
					
				},
				"data": data
			}
		};

		FusionCharts.ready(function () {
			var fusioncharts = new FusionCharts(config);
			fusioncharts.render();
		});
}