let categories = null;
let dataset = null;
let chartType = "mscolumn2d";


//Funções do Chart
function renderChart(categories, dataset, chartType) {
	const chartConfigs = {
		type: chartType,
		renderAt: "chart-container",
		showValues: "1",
		width: "100%",
		height: "400",
		dataFormat: "json",
		dataSource: {
			"chart": {
				"drawAnchors": "1",
				"theme": "fusion",
				"paletteColors": "#8b8fd7, #9e78d0, #c660c5, #df8492, #fbcc8a, #e9ec80, #b0e17a, #87e2bb, #8aeaec, #5967ea",
			},
			"categories": [
				{
					"category": categories
				}
			],
			"dataset": dataset
		}
	};

	FusionCharts.ready(function () {
		var fusioncharts = new FusionCharts(chartConfigs);
		fusioncharts.render();
	});

}


let enviarRequisicao = async () => {

	let dimensoes = document.querySelectorAll("#target>.item");

	let dimensoesSelecionadas = Array.from(dimensoes).map((c) => c.dataset.value);
	
	let chartName = document.getElementById("chart-name").dataset.value;	
	
	let bodyRequisicao = {
		"chartName": chartName,
		"dimensoesSelecionadas": dimensoesSelecionadas
	}

	let url = "../get_data_chart_personalizado/get_data_chart_personalizado.php";

	let opcoes = {
		method: 'POST',
		headers: {
			'Content-Type': 'application/json'
		},
		body: JSON.stringify(bodyRequisicao)
	};

    let response = await fetch(url, opcoes);

    if (!response.ok) {
        throw new Error('HTTP error: ' + response.status);
    }

    let data = await response.json();

    categories = data.categories;
    dataset = data.dataset;

    renderChart(categories, dataset, chartType);



}


function main(){
    //Funções do drag and drop
    const containers = document.querySelectorAll('.container');
    let draggedItem = null;

    document.querySelectorAll('.item').forEach(item => {
        item.addEventListener('dragstart', () => {
            draggedItem = item;
            item.classList.add('dragging');
        });

        item.addEventListener('dragend', () => {
            item.classList.remove('dragging');
            draggedItem = null;
        });
    });

    containers.forEach(container => {
        container.addEventListener('dragover', (e) => {
            e.preventDefault();
        });

        container.addEventListener('drop', (e) => {
            e.preventDefault();
            if (!draggedItem) {
                return;
            }

            if (container.id == "target" && container.childElementCount >= 2) {
                alert("Só é possível selecionar até 2 dimensões");
                return;
            }

            container.appendChild(draggedItem);
            enviarRequisicao();
        });
    });

    enviarRequisicao();


    // Alterar gráfico
    const graficosMultiserie = [
        { tipo: "radar", nome: "Radar" },
        { tipo: "msline", nome: "Linha" },
        { tipo: "msarea", nome: "Área" },
        { tipo: "mscolumn2d", nome: "Coluna 2D" },
        { tipo: "mscolumn3d", nome: "Coluna 3D" },
        { tipo: "msbar2d", nome: "Barra 2D" },
        { tipo: "msbar3d", nome: "Barra 3D" },
        { tipo: "stackedarea2d", nome: "Área Empilhada 2D" },
        { tipo: "mscombi2d", nome: "Combinado 2D" },
        { tipo: "mscombi3d", nome: "Combinado 3D" },
        { tipo: "mscolumnline3d", nome: "Coluna + Linha 3D" }
    ];

    let chartTypes = document.getElementById("chart-type");

    graficosMultiserie.forEach((g) => {
        let opt = document.createElement("option");
        opt.value = g.tipo;
        opt.innerText = g.nome;

        chartTypes.appendChild(opt);
    });

    chartTypes.addEventListener("change", (e) => {
        chartType = chartTypes.value;
        renderChart(categories, dataset, chartType);
    });

    //Botão configurações do gráfico
    let btnConfig = document.getElementById("btn-config");
    btnConfig.addEventListener("click", () => {
        document.getElementById("chart-config").classList.toggle("visibility");
    });
}



window.onload = main;

