export class DraggablePanel {
  constructor(container) {
    this.organizationGraphContainer = container;
    this.isDragging = false;
    this.startX = 0;
    this.startY = 0;

    this.initDragEvents();
  }

  initDragEvents() {
    this.organizationGraphContainer.addEventListener('mousedown', (e) => this.startDrag(e));
    document.addEventListener('mousemove', (e) => this.drag(e));
    document.addEventListener('mouseup', () => this.stopDrag());
    document.addEventListener('mouseleave', () => this.stopDrag());
  }

  startDrag(e) {
    this.isDragging = true;
    this.startX = e.clientX;
    this.startY = e.clientY;
    this.organizationGraphContainer.style.cursor = 'grabbing';
  }

  drag(e) {
    if (!this.isDragging) return;

    // Calcula a diferença de posição do mouse
    const horizontalChange = this.startX - e.clientX;
    const verticalChange = this.startY - e.clientY;

    // Usa scrollBy para mover o conteúdo
    this.organizationGraphContainer.scrollBy(horizontalChange, verticalChange);

    // Atualiza as coordenadas de início
    this.startX = e.clientX;
    this.startY = e.clientY;
  }

  stopDrag() {
    this.isDragging = false;
    this.organizationGraphContainer.style.cursor = 'grab';
  }
}
