export const dataOrganizationalData = {
  chart: {
    container: '#organizationGraphContainer',

    connectors: {
      type: 'step',
      style: {
        'stroke-width': 2,
        stroke: '#665B57'
      },
      stackIndent: 15
    },
    padding: 10,
    levelSeparation: 40,
    siblingSeparation: 100,
    animateOnInitDelay: 0,

    node: {
      HTMLclass: 'default-style-node',
      collapsable: true,

      link: {
        target: '_blank'
      }
    },
    callback: {
      onTreeLoaded: function (rootTreeNode) {
        document.querySelector('#loader').style.display = 'none';
        const organizationGraphContainer = document.getElementById('organizationGraphContainer');
        const rootModule = document.getElementById('rootModule');
        
        if (organizationGraphContainer && rootModule) {
          const graphContainer = organizationGraphContainer;
          const graphContainerPos = graphContainer.getBoundingClientRect();
          const node_rect = rootModule.getBoundingClientRect();

          // Calcula o deslocamento para rolar até o nó
          const offsetX = node_rect.left - graphContainerPos.left + node_rect.width / 2 - graphContainerPos.width / 2;
          const offsetY = node_rect.top - graphContainerPos.top + node_rect.height / 2 - graphContainerPos.height / 2;

          // Rolagem suave para centralizar o nó
          graphContainer.scrollBy(offsetX, offsetY);
        }
      },
      onBeforeClickCollapseSwitch: function (nodeSwitch, event) {
        document.querySelector('#loader').style.display = 'flex';
      },
      onToggleCollapseFinished: function (treeNode, bIsCollapsed) {
        const organizationGraphContainer = document.getElementById('organizationGraphContainer');
        const rootModule = document.getElementById(treeNode.nodeDOM.id);
        document.querySelector('#loader').style.display = 'none';

        if (organizationGraphContainer && rootModule) {
          const graphContainer = organizationGraphContainer;
          const graphContainerPos = graphContainer.getBoundingClientRect();
          const node_rect = rootModule.getBoundingClientRect();

          // Calcula o deslocamento para rolar até o nó
          const offsetX = node_rect.left - graphContainerPos.left + node_rect.width / 2 - graphContainerPos.width / 2;
          const offsetY = node_rect.top - graphContainerPos.top + node_rect.height / 2 - graphContainerPos.height / 2;

          // Rolagem suave para centralizar o nó
          graphContainer.scrollBy(offsetX, offsetY);
        }
      }
    },
    animation: {
      connectorsSpeed: 200
    }
  }
}