import { Sidebar } from "./Sidebar.js";
const side = new Sidebar();

const require = {
  sideDropdownBtn: document.querySelectorAll(".button-drop"),
  headerMain: document.querySelectorAll("[header-main]"),
  icones: document.querySelectorAll("[icon-withoud-dropdown]"),
  dropdowns: document.querySelectorAll(".dropdown-container"),
  iconMenu: document.querySelector(".container-icon > img"),
  sideDropdowns: document.querySelectorAll(".sub-menu-drop"),
  btnDropdown: document.querySelectorAll("[dropdown-button]"),
  containerItem: document.querySelectorAll(".container-item"),
  sidebar: document.querySelector(".sidebar-dropdown"),
  arrows: document.querySelectorAll(".container-dropdown > img "),
  options: document.querySelectorAll("[options]"),
  retract: document.querySelector(".recolher"),
  retractImg: document.querySelector(".recolher > a > img"),
};
require.retract.addEventListener("click", () => {
  side.toggleSideBar(require.sidebar, require.headerMain, require.retractImg, require.dropdowns, require.arrows, require.sideDropdowns);
});

require.sidebar.addEventListener("mouseleave", () => {
  side.closeSideBarOnMouseLeave(require.sidebar, require.headerMain, require.retractImg, require.dropdowns, require.arrows, require.sideDropdowns);
});

addEventListener("load", () => {
  side.dropdown(
    require.btnDropdown,
    require.containerItem,
    require.arrows,
    require.sideDropdowns,
    require.sidebar,
    require.headerMain,
    require.retractImg
  );

  side.openSidebarByIconsWithoudDropdown(
    require.icones,
    require.sidebar,
    require.headerMain,
    require.dropdowns,
    require.arrows,
    require.sideDropdowns,
    require.retractImg
  );

  side.sideDropdown(require.sideDropdownBtn);

  side.closeSideDropdownByOptions(require.options, require.sideDropdowns);
});
