let styleElement = null;

function createKeyframes(start, end) {
  if (!styleElement) {
    styleElement = document.createElement('style');
    document.head.appendChild(styleElement);
  }

  styleElement.innerHTML = `
  @keyframes move {
    from {
      transform: translateX(${start}%);
    }
    to {
      transform: translateX(${end}%);
    }
  }
`;
}

const buttonNext = document.querySelectorAll('.next-button');
const buttonBack = document.querySelectorAll('.back-button');
const fieldsets = Array.from(document.querySelectorAll('fieldset'));

const addClassElement = (element, className) => element.classList.add(className);
const removeClassElement = (element, className) => element.classList.remove(className);
let currentStep = 0;

// Atualiza a posição dos fieldsets dinamicamente
const updateStep = (newStep, status) => {
  if (newStep >= 0 && newStep < fieldsets.length) {
    if (status == 1) {
      fieldsets.forEach((fieldset, index) => {
        if (index > 0) {
          fieldset.addEventListener('animationend', () => {
            fieldset.style.transform = `translateX(${newStep * -100}%)`;
          });
        }
        fieldset.addEventListener('animationend', () => {
          fieldset.style.animation = '';
        });
      });
    } else {
      fieldsets.forEach((fieldset) => {
        fieldset.addEventListener('animationend', () => {
          fieldset.style.transform = `translateX(${newStep * -100}%)`;
        });
      });
    }
    currentStep = newStep;
  }
};

// Configura os botões de avançar
buttonNext.forEach((button) => {
  button.addEventListener('click', () => {
    createKeyframes((currentStep + 1 - 1) * -100, (currentStep + 1) * -100);
    fieldsets.forEach((fieldset) => {
      fieldset.style.animation = 'move 600ms ease-in-out';
    });

    updateStep(currentStep + 1, 1);
  });
});

// Configura os botões de voltar
buttonBack.forEach((button) => {
  button.addEventListener('click', () => {
    createKeyframes(currentStep * -100, (currentStep - 1) * -100);
    fieldsets.forEach((fieldset) => {
      fieldset.style.animation = 'move 600ms ease-in-out';
    });
    updateStep(currentStep - 1, 2);
  });
});
