import { showErrorPopup } from './popupSetts.js';

const items = document.querySelectorAll('.item');
const sortableList = document.querySelector('.sortable-list');

let initialOrder = [];
if (sortableList) {
  const getCurrentOrder = () => {
    return [...sortableList.querySelectorAll('.item')].map((item, index) => ({
      id: item.id.replace('item_id_', ''),
      order: index + 1
    }));
  };

  const sendData = async (ordination) => {
    if (ordination.length === 0) return;

    const params = {
      method: 'POST',
      headers: {
        'Content-Type': 'application/json'
      },
      body: JSON.stringify(ordination)
    };

    try {
      const fetchInformation = await fetch('../order_adjust_questions/index.php', params);
      const response = await fetchInformation.json();
	  
      if (response.status === 'error') {
        showErrorPopup(response.message);
      }
    } catch (error) {
      showErrorPopup('Não foi possível realizar a requisição. Tente novamente mais tarde.');
    }
  };

  const updateOrder = () => {
    const newOrder = getCurrentOrder();
    const changedItems = newOrder.filter((newItem, index) => {
      return initialOrder[index] && initialOrder[index].id !== newItem.id;
    });

    sendData(changedItems);
  };

  items.forEach((item) => {
    item.addEventListener('dragstart', () => {
      initialOrder = getCurrentOrder(); // Salva a ordem antes de começar a arrastar
      setTimeout(() => {
        item.classList.add('dragging');
      }, 0);
    });

    item.addEventListener('dragend', () => {
      item.classList.remove('dragging');
      updateOrder();
    });
  });

  const initSortableList = (e) => {
    e.preventDefault();
    const draggingItem = document.querySelector('.dragging');
    const siblings = [...sortableList.querySelectorAll('.item:not(.dragging)')];

    let nextSibling = siblings.find((sibling) => {
      return e.clientY <= sibling.getBoundingClientRect().top + sibling.offsetHeight / 2;
    });

    sortableList.insertBefore(draggingItem, nextSibling);

    const listRect = sortableList.getBoundingClientRect();
    const distanceFromBottom = listRect.bottom - e.clientY;
    const distanceFromTop = e.clientY - listRect.top;

    if (distanceFromBottom < 50 && sortableList.scrollTop + sortableList.clientHeight < sortableList.scrollHeight) {
      sortableList.scrollTop += 20;
    } else if (distanceFromTop < 50 && sortableList.scrollTop > 0) {
      sortableList.scrollTop -= 20;
    }
  };

  sortableList.addEventListener('dragover', initSortableList);
  sortableList.addEventListener('dragenter', (e) => e.preventDefault());
}
