<?php
class MYPDF extends TCPDF {
    var $grid = false;

    function DrawGrid()
    {
        if($this->grid===true){
            $spacing = 5;
        } else {
            $spacing = $this->grid;
        }
        $this->SetDrawColor(204,255,255);
        $this->SetLineWidth(0.35);
        for($i=0;$i<$this->w;$i+=$spacing){
            $this->Line($i,0,$i,$this->h);
        }
        for($i=0;$i<$this->h;$i+=$spacing){
            $this->Line(0,$i,$this->w,$i);
        }
        $this->SetDrawColor(0,0,0);

        $x = $this->GetX();
        $y = $this->GetY();
        $this->SetTextColor(204,204,204);
        for($i=20;$i<$this->h;$i+=20){
            $this->SetXY(1,$i-3);
            $this->Write(4,$i);
        }
        for($i=20;$i<(($this->w)-($this->rMargin)-10);$i+=20){
            $this->SetXY($i-1,1);
            $this->Write(4,$i);
        }
        $this->SetXY($x,$y);
    }

	public function setIdHeader($titulo){
      $this->IdHeader = $titulo;
    }
	
    function Header()
    {
		
		
        if($this->grid)
            $this->DrawGrid();
		
		//$this->Image('../_lib/libraries/grp/report_pdf/logo.png', 40, 0,0, 0, 'PNG', '', '', true, 200, '', false, false, 0, false, 10, 10); // logo

		// Tipo de fonte
		$this->SetFont('helvetica', 'B', 11);

		// Titulo
		//$this->Ln(15);
		//$this->Cell(0, 15, utf8_decode('PMT - Prefeitura Municipal de Teresina'),0, false, 'C', 0, '', 0, false, 'M', 'M'); Titulo
		//$this->Ln(5);

		
		// Tipo de fonte
		$this->SetFont('helvetica', 'B', 14);

		
    }

    //Rodape
    public function Footer()
    {
        // Posicionado a 15mm do final da p&#65533;gina
        $this->SetY(-15);
        // Tipo de fonte
        $this->SetFont('helvetica', 'I', 8);
        // Numero da Pagina
        $this->Cell(0, 10, 'Page '.$this->getAliasNumPage().'/'.$this->getAliasNbPages(), 0, false, 'R', 0, '', 0, false, 'T', 'M');
    }
	
}
?>