document.addEventListener('DOMContentLoaded', () => {
	const cnpjInput = document.querySelector('#id_sc_field_cnpj_terceiro_field');

	const formatCNPJ = (textInput) =>
	  textInput
		.replace(/(\d{2})(\d)/, '$1.$2')
		.replace(/(\d{3})(\d)/, '$1.$2')
		.replace(/(\d{3})(\d)/, '$1/$2')
		.replace(/(\d{4})(\d)/, '$1-$2')
		.replace(/(-\d{2})\d+?$/, '$1');

	cnpjInput.addEventListener('input', () => {
	  cnpjInput.value = cnpjInput.value.replace(/\D/g, '');
	  if (cnpjInput.value.length <= 18) cnpjInput.value = formatCNPJ(cnpjInput.value);
	});
});