import { Sidebar } from "./Sidebar.js";
const side = new Sidebar();

const require = {
  sideDropdownBtn: document.querySelectorAll(".button-drop"),
  headerMain: document.querySelectorAll("[header-main]"),
  icones: document.querySelectorAll("[icon-withoud-dropdown]"),
  dropdowns: document.querySelectorAll(".dropdown-container"),
  iconMenu: document.querySelector(".container-icon > img"),
  sideDropdowns: document.querySelectorAll(".sub-menu-drop"),
  btnDropdown: document.querySelectorAll("[dropdown-button]"),
  containerItem: document.querySelectorAll(".container-item"),
  sidebar: document.querySelector(".sidebar-dropdown"),
  options: document.querySelectorAll("[options]"),
  retract: document.querySelector(".recolher"),
  retractImg: document.querySelector(".recolher > div > img"),
  modulesLink: document.querySelectorAll("li a[options]:not(.help, .container-icon-pcp)"),
  homeButton: document.querySelector('.container-icon-pcp')
};

require.retract.addEventListener("click", () => {
  side.toggleSideBar(require.sidebar, require.headerMain, require.retractImg, require.dropdowns, require.sideDropdowns);
});

require.sidebar.addEventListener("mouseleave", () => {
  side.closeSideBarOnMouseLeave(require.sidebar, require.headerMain, require.retractImg, require.dropdowns, require.sideDropdowns);
});


require.homeButton.addEventListener("click", () => {
	side.clearLastModuleAccessed();
});

addEventListener("load", () => {
  side.dropdown(
    require.btnDropdown,
    require.containerItem,
    require.sideDropdowns,
    require.sidebar,
    require.headerMain,
    require.retractImg
  );

  side.openSidebarByIconsWithoudDropdown(
    require.icones,
    require.sidebar,
    require.headerMain,
    require.dropdowns,
    require.sideDropdowns,
    require.retractImg
  );

  side.sideDropdown(require.sideDropdownBtn);

  side.closeSideDropdownByOptions(require.options, require.sideDropdowns);
  side.marksLastModuleAccessed(require.modulesLink);
});
