function toggleBehaviorControll() {
	let versionHeader = document.getElementsByClassName("version-header");

	for (let i = 0; i < versionHeader.length; i++) {
		if (i == 0) {
			let firstHeader = versionHeader[i];
			firstHeader.classList.toggle("header-active");

			let firstContent = firstHeader.nextElementSibling
			firstContent.style.maxHeight = firstContent.scrollHeight + "px"
		}

		versionHeader[i].addEventListener("click", function() {


			this.classList.toggle("header-active");

			let content = this.nextElementSibling;

			if (content.style.maxHeight) {
				content.style.maxHeight = null;

			} else {
				content.style.maxHeight = content.scrollHeight + "px";

				versionHeader = this;

				setTimeout(function() {
					versionHeader.scrollIntoView({behavior: "smooth", block: "start"});
				}, 200)


			}
		})
	}
}

function newVersion(version, date) {
	console.log(version);
	let container = document.getElementById("container");

	//Criando o cabeçalho da versão
	let versionHeader = document.createElement("div");
	versionHeader.className = "version-header";

	//Criando o conteúdo do cabeçalho
	let versionTitle = document.createElement("h3");
	versionTitle.className = "version-title";
	versionTitle.textContent = "V." + version;

	let versionDateRelease = document.createElement("p");
	versionDateRelease.className = "version-date-release";
	versionDateRelease.textContent = date;

	let versionHeaderDecription = document.createElement("div");
	versionHeaderDecription.className = "version-header-description";

	//Adicionando o conteúdo ao cabeçalho
	versionHeaderDecription.appendChild(versionTitle);
	versionHeaderDecription.appendChild(versionDateRelease);

	versionHeader.appendChild(versionHeaderDecription);

	//Adicionando o cabeçalho ao container
	container.appendChild(versionHeader);

	//Criando o elemento que vai guardar posteriormente o conteúdo relacionado a esta versão
	let versionContent = document.createElement("div");
	versionContent.className = "version-content";


	//Adicionando a caixa do conteúdo da versão ao container
	container.appendChild(versionContent);

	/*Exemplo do código html:
	 *
	 *	<div class="version-header">
	 *      <div class="version-header-description">
	 *          <h3 class="version-title">vx.x.x</h3>
	 *			<p class="version-date-release">dd/mm/yyyy</p>
	 *      </div>
	 *	</div>
	 *	<div class="version-content">
	 *	</div>
	 */
}

function newType(typeLabel, typeIconName) {
	//Pega a última caixa de conteúdo de versão na página
	let versionContent = document.getElementsByClassName("version-content");
	versionContent = versionContent[versionContent.length - 1];

	//Criando a caixa que guardará todo o conteúdo do novo tipo
	let type = document.createElement("div");
	type.className = "type";

	//Criando a caixa para guardar o nome e o ícone referente ao tipo
	let typeHeader = document.createElement("div");
	typeHeader.className = "type-header";

	//O tipo "Novidades" deve ser apresentado na cor verde
	if (typeIconName === "star") {
		typeHeader.style.color = " #188d2a";
	}

	//Criando o elemento do ícone do tipo
	let typeIcon = document.createElement("i");
	typeIcon.className = "type-icon fa-solid fa-" + typeIconName;

	//Criando o elemento com o título do tipo
	let typeTitle = document.createElement("p");
	typeTitle.className = "type-title";
	typeTitle.textContent = typeLabel;

	//Inserindo os conteúdos no cabeçalho do tipo
	typeHeader.appendChild(typeIcon);
	typeHeader.appendChild(typeTitle);

	//Inserindo o cabeçalho na caixa do tipo
	type.appendChild(typeHeader);

	//Criando a caixa que vai guardar posteriormente o conteúdo deste tipo
	let typeContent = document.createElement("ul");
	typeContent.className = "type-content";

	//Inserindo a caixa vazia de conteúdo na caixa do tipo
	type.appendChild(typeContent);

	//inserindo a caiza do tipo na caixa da versão
	versionContent.appendChild(type);

	/*Exemplo do código html:
	 *
	 *	<div class="version-content">
	 *		<div class="type">
	 *			<div class="type-header">
	 *				<i class="type-icon fa-solid fa-star"></i>
	 *				<p class="type-title">Novidades</p>
	 *			</div>
	 *			<ul class="type-content">
	 *			</ul>
	 *		</div>
	 *	</div>
	 */

}

function addContentLine(desc, func) {

	let typeContent = document.getElementsByClassName("type-content");
	typeContent = typeContent[typeContent.length - 1];

	let contentLine = document.createElement("li");
	contentLine.className = "content-line";
	contentLine.innerHTML = "";

	//Add func if not null
	if(func !== null && func !== undefined){
		contentLine.innerHTML = "<p class='content-header'>" + func + "</p> ";
	}

	//Add desc
	contentLine.innerHTML += "<p>" + desc + "</p>";
	typeContent.appendChild(contentLine);
}

function main() {
	let releases = <?= json_encode({release_notes}) ?>;

	let version_ant = "";
	let type_ant = "";
	let func_ant = "";

	let releaseTypes = {
		"Melhoria": {
			"label": "Melhorias",
			"icon": "rotate"
		},
		"Novidade": {
			"label": "Novidades",
			"icon": "star"
		},
		"Correção": {
			"label": "Correções",
			"icon": "screwdriver-wrench"
		}
	};

	for (let i = 0; i < releases.length; i++) {
		let version = releases[i][0];
		let type = releases[i][1];


		if (version !== version_ant) {
			let dataFormatada = new Date(releases[i][4]);
			dataFormatada = dataFormatada.toLocaleDateString('pt-BR', {
				'timeZone': 'UTC'
			});

			newVersion(version, dataFormatada);

			version_ant = version;
		}

		if (type !== type_ant) {

			newType(releaseTypes[type]['label'], releaseTypes[type]['icon']);

			type_ant = type;

			//Limpa a func para garantir que ao gerar um novo conteudo ele gere o titulo mesmo que o anterior seja igual
			func_ant = "";
		}

		let func = releases[i][2];
		let desc = releases[i][3];

		if(func !== func_ant){

			addContentLine(desc, func);
			func_ant = func;
		}else{
			addContentLine(desc);
		}

		/*Exemplo do código html:
		 *	<ul class="type-content">
		 *      <li class="content-line">
		 *          <span class="content-header">Funcionalidade</span>
		 *          <p>Descrição</p>
		 *       </li>
		 *    </ul>
		 */

	}
}

main();

toggleBehaviorControll();