<?php
header('Content-Type: application/json');

require_once __DIR__ . '/../src/Logger.php';
use Src\Logger;

set_exception_handler(function($e){
    Logger::log("❌ ERRO FATAL: " . $e->getMessage());
    http_response_code(500);
    echo json_encode(['erro'=>'fatal','mensagem'=>$e->getMessage()]);
    exit;
});
set_error_handler(function($no,$msg,$file,$line){
    Logger::log("❌ ERRO PHP: $msg @ $file:$line");
    http_response_code(500);
    echo json_encode(['erro'=>'php','mensagem'=>"$msg @ $file:$line"]);
    exit;
});


$host = '132.226.240.8';
$usuario = 'omnis_saas_prod';
$senha = 'uhnYcx89np!ex';
$TOKEN_ESPERADO = 'xwPP5ZgPV7CR3RoURIzKhVT8h35EpjMU';

  
/*
$host = 'localhost';
$usuario = 'root';
$senha = '';
$TOKEN_ESPERADO = 'MEU_TOKEN_SECRETO';
*/

// VALIDA BEARER TOKEN
$headers = getallheaders();
$authHeader = $headers['Authorization'] ?? '';

if (!preg_match('/Bearer\s(\S+)/', $authHeader, $matches)) {
    http_response_code(401);
    echo json_encode(['erro' => 'Token ausente ou inválido']);
    exit;
}

$tokenRecebido = $matches[1];
if ($tokenRecebido !== $TOKEN_ESPERADO) {
    http_response_code(403);
    echo json_encode(['erro' => 'Token inválido']);
    exit;
}

// RECEBENDO OS DADOS
$input = json_decode(file_get_contents('php://input'), true);


if (!is_array($input)) {
    http_response_code(400);
    echo json_encode(['erro'=>'JSON inválido']);
    exit;
}


$nomeBanco = $input['database'] ?? '';
$arquivoUnico = isset($input['sql_file']) ? basename($input['sql_file']) : null;
$sqlInline    = $input['sql_inline'] ?? null;   // <<<<<<






if (!$nomeBanco) {
    http_response_code(400);
    echo json_encode(['erro' => 'Nome do banco ausente']);
    exit;
}

// CONECTA SEM BANCO DEFINIDO
$conn = new mysqli($host, $usuario, $senha);
if ($conn->connect_error) {
    http_response_code(500);
    echo json_encode(['erro' => 'Erro de conexão: ' . $conn->connect_error]);
    exit;
}

// VERIFICA SE BANCO EXISTE
$verifica = $conn->query("SHOW DATABASES LIKE '$nomeBanco'");
if ($verifica && $verifica->num_rows > 0) {
    http_response_code(409);
    echo json_encode(['erro' => "Banco '$nomeBanco' já existe."]);
    exit;
}

// CRIA O BANCO
$conn->query("CREATE DATABASE `$nomeBanco`");
$conn->select_db($nomeBanco);
Logger::log("✅ Banco '$nomeBanco' criado com sucesso");




if ($sqlInline) {
    // roda o SQL enviado no payload
    // if ($conn->multi_query($sqlInline)) {
    //     do { if ($result = $conn->store_result()) $result->free(); }
    //     while ($conn->more_results() && $conn->next_result());
    //     $executados[] = '__inline__';
    // } else {
    //     $falhas[] = '__inline__: ' . $conn->error;
    // }
    if ($conn->multi_query($sqlInline)) {
        do {
            if ($result = $conn->store_result()) {
                $result->free();
            }
            
            // Verifica erro ANTES de avançar
            if ($conn->errno) {
                $erroMsg = '__inline__: ' . $conn->error;
                $falhas[] = $erroMsg;
                Logger::log("❌ ERRO SQL INLINE: " . $conn->error);
                break;
            }
        } while ($conn->more_results() && $conn->next_result());
        
        // Verifica erro após o último next_result()
        if ($conn->errno) {
            $erroMsg = '__inline__: ' . $conn->error;
            $falhas[] = $erroMsg;
            Logger::log("❌ ERRO SQL INLINE (final): " . $conn->error);
        } else {
            $executados[] = '__inline__';
            Logger::log("✅ SQL inline executado com sucesso");
        }
    } else {
        $erroMsg = '__inline__: ' . $conn->error;
        $falhas[] = $erroMsg;
        Logger::log("❌ ERRO ao iniciar multi_query: " . $conn->error);
    }
} else {









// DETERMINA QUAIS SQLs EXECUTAR
$sqlDir = __DIR__ . '/sql/';
$arquivosSQL = [];

if ($arquivoUnico) {
    $caminho = $sqlDir . $arquivoUnico;
    if (!file_exists($caminho)) {
        http_response_code(400);
        echo json_encode(['erro' => "Arquivo SQL não encontrado: $arquivoUnico"]);
        exit;
    }
    $arquivosSQL[] = $caminho;
} else {
    // Pega todos os arquivos .sql do diretório
    $todosArquivos = glob($sqlDir . '*.sql');
    sort($todosArquivos); // ordena por nome
    $arquivosSQL = $todosArquivos;
    if (empty($arquivosSQL)) {
        http_response_code(400);
        echo json_encode(['erro' => 'Nenhum arquivo SQL encontrado no diretório.']);
        exit;
    }
}

// EXECUTA CADA ARQUIVO
$executados = [];
$falhas = [];

foreach ($arquivosSQL as $arquivoSQL) {
    

    $sql = file_get_contents($arquivoSQL);
    $sql = preg_replace('/(^|[\r\n])\s*;+\s*(?=[\r\n]|$)/', '$1', $sql);
    if (!$sql) {
        $falhas[] = basename($arquivoSQL) . ' (erro ao ler)';
        continue;
    }



    // --- SANITIZADOR: remove DEFINER e força INVOKER ---
    // normaliza quebras de linha (opcional)
    $sql = str_replace("\r\n", "\n", $sql);

    // remove blocos versionados que trazem DEFINER (ex.: /*!50013 DEFINER=`user`@`%` SQL SECURITY DEFINER */)
    $sql = preg_replace('/\/\*!\d+\s+DEFINER=`[^`]+`@`[^`]+`\s+SQL SECURITY DEFINER\s*\*\//i', '', $sql);

    // remove cláusulas "DEFINER=`...`@`...`" em CREATE VIEW / TRIGGER / FUNCTION / PROCEDURE / EVENT
    $sql = preg_replace('/\sDEFINER=`[^`]+`@`[^`]+`\s*/i', ' ', $sql);

    // troca "SQL SECURITY DEFINER" por "SQL SECURITY INVOKER"
    $sql = preg_replace('/SQL SECURITY\s+DEFINER/i', 'SQL SECURITY INVOKER', $sql);

    // (opcional) limpa ; “soltos” em linhas vazias
    $sql = preg_replace('/(^|[\r\n])\s*;+\s*(?=[\r\n]|$)/', '$1', $sql);
    // --- FIM SANITIZADOR ---


    if ($conn->multi_query($sql)) {
        do {
            if ($result = $conn->store_result()) {
                $result->free();
            }
        } while ($conn->more_results() && $conn->next_result());

        $executados[] = basename($arquivoSQL);
        Logger::log("✅ Arquivo executado: " . basename($arquivoSQL));
    } else {
        $erroMsg = basename($arquivoSQL) . ': ' . $conn->error;
        $falhas[] = $erroMsg;
        Logger::log("❌ ERRO no arquivo " . basename($arquivoSQL) . ": " . $conn->error);
    }
}

$conn->close();

// RESPOSTA FINAL
Logger::log("📊 Resultado final - Banco: $nomeBanco | Executados: " . count($executados) . " | Falhas: " . count($falhas));
if (!empty($falhas)) {
    Logger::log("⚠️ Detalhes das falhas: " . json_encode($falhas));
}

echo json_encode([
    'banco' => $nomeBanco,
    'executados' => $executados,
    'falhas' => $falhas
]);
}