-- MySQL dump 10.13  Distrib 8.0.36, for Win64 (x86_64)
--
-- Host: 132.226.240.8    Database: lgpd_model
-- ------------------------------------------------------
-- Server version	8.0.41-u6-cloud

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!50503 SET NAMES utf8 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Table structure for table `CMP_0100_faixas`
--

DROP TABLE IF EXISTS `CMP_0100_faixas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `CMP_0100_faixas` (
  `id_faixa_0100` int NOT NULL AUTO_INCREMENT,
  `valor_ini_0100` int NOT NULL,
  `valor_fim_0100` int NOT NULL,
  PRIMARY KEY (`id_faixa_0100`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `CMP_0100_faixas`
--

-- -- LOCK TABLES `CMP_0100_faixas` WRITE;
-- /*!40000 ALTER TABLE `CMP_0100_faixas` DISABLE KEYS */;
-- /*!40000 ALTER TABLE `CMP_0100_faixas` ENABLE KEYS */;
-- -- UNLOCK TABLES;

--
-- Table structure for table `CMP_1000_mecanismos`
--

DROP TABLE IF EXISTS `CMP_1000_mecanismos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `CMP_1000_mecanismos` (
  `id_mecanismo_1000` int NOT NULL AUTO_INCREMENT,
  `desc_mecanismo_1000` varchar(200) NOT NULL,
  `id_controlador_1000` int NOT NULL,
  PRIMARY KEY (`id_mecanismo_1000`),
  KEY `FK_1000_controlador_idx` (`id_controlador_1000`),
  CONSTRAINT `FK_1000_controlador` FOREIGN KEY (`id_controlador_1000`) REFERENCES `LGPD_1000_controlador` (`id_controlador_1000`) ON DELETE RESTRICT ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=15 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `CMP_1000_mecanismos`
--

-- LOCK TABLES `CMP_1000_mecanismos` WRITE;
/*!40000 ALTER TABLE `CMP_1000_mecanismos` DISABLE KEYS */;
/*!40000 ALTER TABLE `CMP_1000_mecanismos` ENABLE KEYS */;
-- UNLOCK TABLES;

--
-- Table structure for table `CMP_1100_componentes`
--

DROP TABLE IF EXISTS `CMP_1100_componentes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `CMP_1100_componentes` (
  `id_componente_1100` int NOT NULL AUTO_INCREMENT,
  `id_mecanismo_1000` int NOT NULL,
  `desc_componente_1100` varchar(200) NOT NULL,
  `id_controlador_1000` int NOT NULL,
  PRIMARY KEY (`id_componente_1100`),
  KEY `FK_1000_mecanismo_idx` (`id_mecanismo_1000`),
  KEY `FK_1000_controlador_idx` (`id_controlador_1000`),
  CONSTRAINT `FK_1000_mecanismo` FOREIGN KEY (`id_mecanismo_1000`) REFERENCES `CMP_1000_mecanismos` (`id_mecanismo_1000`) ON DELETE RESTRICT ON UPDATE CASCADE,
  CONSTRAINT `FK_1100_controlador` FOREIGN KEY (`id_controlador_1000`) REFERENCES `LGPD_1000_controlador` (`id_controlador_1000`) ON DELETE RESTRICT ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=22 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `CMP_1100_componentes`
--

-- -- LOCK TABLES `CMP_1100_componentes` WRITE;
/*!40000 ALTER TABLE `CMP_1100_componentes` DISABLE KEYS */;
/*!40000 ALTER TABLE `CMP_1100_componentes` ENABLE KEYS */;
-- UNLOCK TABLES;

--
-- Table structure for table `CMP_1200_questoes`
--

DROP TABLE IF EXISTS `CMP_1200_questoes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `CMP_1200_questoes` (
  `id_questao_1200` int NOT NULL AUTO_INCREMENT,
  `questao_1200` varchar(500) NOT NULL,
  `id_mecanismo_1000` int NOT NULL,
  `id_componente_1100` int NOT NULL,
  `ind_mult_escolha_1200` tinyint NOT NULL,
  `peso_1200` int NOT NULL,
  `id_controlador_1000` int NOT NULL,
  PRIMARY KEY (`id_questao_1200`),
  KEY `FK_1200_mecanismo_idx` (`id_mecanismo_1000`),
  KEY `FK_1200_componente_idx` (`id_componente_1100`),
  KEY `FK_1200_controlador_idx` (`id_controlador_1000`),
  CONSTRAINT `FK_1200_componente` FOREIGN KEY (`id_componente_1100`) REFERENCES `CMP_1100_componentes` (`id_componente_1100`) ON DELETE RESTRICT ON UPDATE CASCADE,
  CONSTRAINT `FK_1200_controlador` FOREIGN KEY (`id_controlador_1000`) REFERENCES `LGPD_1000_controlador` (`id_controlador_1000`) ON DELETE RESTRICT ON UPDATE CASCADE,
  CONSTRAINT `FK_1200_mecanismo` FOREIGN KEY (`id_mecanismo_1000`) REFERENCES `CMP_1000_mecanismos` (`id_mecanismo_1000`) ON DELETE RESTRICT ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=24 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `CMP_1200_questoes`
--

-- LOCK TABLES `CMP_1200_questoes` WRITE;
/*!40000 ALTER TABLE `CMP_1200_questoes` DISABLE KEYS */;
/*!40000 ALTER TABLE `CMP_1200_questoes` ENABLE KEYS */;
-- UNLOCK TABLES;

--
-- Table structure for table `CMP_1300_formularios`
--

DROP TABLE IF EXISTS `CMP_1300_formularios`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `CMP_1300_formularios` (
  `id_formularios_1300` int NOT NULL AUTO_INCREMENT,
  `nome_formulario_1300` varchar(200) DEFAULT NULL,
  `id_mecanismo_1000` int NOT NULL,
  `id_controlador_1000` int NOT NULL,
  PRIMARY KEY (`id_formularios_1300`),
  KEY `FK_1300_mecanismo_idx` (`id_mecanismo_1000`),
  KEY `FK_1000_controlador_idx` (`id_controlador_1000`),
  CONSTRAINT `FK_1300_controlador` FOREIGN KEY (`id_controlador_1000`) REFERENCES `LGPD_1000_controlador` (`id_controlador_1000`) ON DELETE RESTRICT ON UPDATE CASCADE,
  CONSTRAINT `FK_1300_mecanismo` FOREIGN KEY (`id_mecanismo_1000`) REFERENCES `CMP_1000_mecanismos` (`id_mecanismo_1000`) ON DELETE RESTRICT ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=18 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `CMP_1300_formularios`
--

-- LOCK TABLES `CMP_1300_formularios` WRITE;
/*!40000 ALTER TABLE `CMP_1300_formularios` DISABLE KEYS */;
/*!40000 ALTER TABLE `CMP_1300_formularios` ENABLE KEYS */;
-- UNLOCK TABLES;

--
-- Table structure for table `CMP_1310_formulario_det`
--

DROP TABLE IF EXISTS `CMP_1310_formulario_det`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `CMP_1310_formulario_det` (
  `id_formulario_det_1310` int NOT NULL AUTO_INCREMENT,
  `id_questao_1200` int NOT NULL,
  `id_formulario_1300` int NOT NULL,
  PRIMARY KEY (`id_formulario_det_1310`),
  KEY `fk_1310_questao_idx` (`id_questao_1200`),
  KEY `fk_1310_formulario_idx` (`id_formulario_1300`),
  CONSTRAINT `fk_1310_formulario` FOREIGN KEY (`id_formulario_1300`) REFERENCES `CMP_1300_formularios` (`id_formularios_1300`) ON DELETE RESTRICT ON UPDATE CASCADE,
  CONSTRAINT `fk_1310_questao` FOREIGN KEY (`id_questao_1200`) REFERENCES `CMP_1200_questoes` (`id_questao_1200`)
) ENGINE=InnoDB AUTO_INCREMENT=67 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `CMP_1310_formulario_det`
--

-- LOCK TABLES `CMP_1310_formulario_det` WRITE;
/*!40000 ALTER TABLE `CMP_1310_formulario_det` DISABLE KEYS */;
/*!40000 ALTER TABLE `CMP_1310_formulario_det` ENABLE KEYS */;
-- UNLOCK TABLES;

--
-- Table structure for table `CMP_1400_formulas_mestre`
--

DROP TABLE IF EXISTS `CMP_1400_formulas_mestre`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `CMP_1400_formulas_mestre` (
  `id_formulas_1400` int NOT NULL AUTO_INCREMENT,
  `desc_setup_1400` varchar(200) NOT NULL,
  `id_controlador_1000` int NOT NULL,
  `ativo_1400` tinyint NOT NULL,
  PRIMARY KEY (`id_formulas_1400`),
  KEY `FK_1400_controlador_idx` (`id_controlador_1000`),
  CONSTRAINT `FK_1400_controlador` FOREIGN KEY (`id_controlador_1000`) REFERENCES `LGPD_1000_controlador` (`id_controlador_1000`) ON DELETE RESTRICT ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=25 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `CMP_1400_formulas_mestre`
--

-- LOCK TABLES `CMP_1400_formulas_mestre` WRITE;
/*!40000 ALTER TABLE `CMP_1400_formulas_mestre` DISABLE KEYS */;
/*!40000 ALTER TABLE `CMP_1400_formulas_mestre` ENABLE KEYS */;
-- UNLOCK TABLES;

--
-- Table structure for table `CMP_1410_formulas_det_mec`
--

DROP TABLE IF EXISTS `CMP_1410_formulas_det_mec`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `CMP_1410_formulas_det_mec` (
  `id_formulas_det_1410` int NOT NULL AUTO_INCREMENT,
  `id_formulas_1400` int NOT NULL,
  `id_mecanismo_1000` int NOT NULL,
  `id_formulario_1300` int DEFAULT NULL,
  `perc_minimo_1410` int DEFAULT NULL,
  PRIMARY KEY (`id_formulas_det_1410`),
  KEY `fk_1410_mecanismo_idx` (`id_mecanismo_1000`),
  KEY `fk_1410_formulario_idx` (`id_formulario_1300`),
  CONSTRAINT `fk_1410_formulario` FOREIGN KEY (`id_formulario_1300`) REFERENCES `CMP_1300_formularios` (`id_formularios_1300`) ON DELETE RESTRICT ON UPDATE CASCADE,
  CONSTRAINT `fk_1410_mecanismo` FOREIGN KEY (`id_mecanismo_1000`) REFERENCES `CMP_1000_mecanismos` (`id_mecanismo_1000`) ON DELETE RESTRICT ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=89 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `CMP_1410_formulas_det_mec`
--

-- LOCK TABLES `CMP_1410_formulas_det_mec` WRITE;
/*!40000 ALTER TABLE `CMP_1410_formulas_det_mec` DISABLE KEYS */;
/*!40000 ALTER TABLE `CMP_1410_formulas_det_mec` ENABLE KEYS */;
-- UNLOCK TABLES;

--
-- Table structure for table `CMP_1420_formulas_det_niv_ad`
--

DROP TABLE IF EXISTS `CMP_1420_formulas_det_niv_ad`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `CMP_1420_formulas_det_niv_ad` (
  `id_formulas_det_niv_ad_1420` int NOT NULL AUTO_INCREMENT,
  `id_formulas_1400` int NOT NULL,
  `desc_niv_ad_1400` varchar(45) NOT NULL,
  `score_min_1400` int DEFAULT NULL,
  `score_max_1400` int DEFAULT NULL,
  PRIMARY KEY (`id_formulas_det_niv_ad_1420`),
  KEY `fk_1420_formula_idx` (`id_formulas_1400`),
  CONSTRAINT `fk_1420_formula` FOREIGN KEY (`id_formulas_1400`) REFERENCES `CMP_1400_formulas_mestre` (`id_formulas_1400`) ON DELETE RESTRICT ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=61 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `CMP_1420_formulas_det_niv_ad`
--

-- LOCK TABLES `CMP_1420_formulas_det_niv_ad` WRITE;
/*!40000 ALTER TABLE `CMP_1420_formulas_det_niv_ad` DISABLE KEYS */;
/*!40000 ALTER TABLE `CMP_1420_formulas_det_niv_ad` ENABLE KEYS */;
-- UNLOCK TABLES;

--
-- Table structure for table `CMP_1430_formulas_det_lim`
--

DROP TABLE IF EXISTS `CMP_1430_formulas_det_lim`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `CMP_1430_formulas_det_lim` (
  `id_formulas_det_lim_1430` int NOT NULL AUTO_INCREMENT,
  `id_formulas_1400` int NOT NULL,
  `id_faixa_0100` int NOT NULL,
  `ader_esp_1430` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`id_formulas_det_lim_1430`),
  KEY `fk_1430_formula_idx` (`id_formulas_1400`),
  CONSTRAINT `fk_1430_formula` FOREIGN KEY (`id_formulas_1400`) REFERENCES `CMP_1400_formulas_mestre` (`id_formulas_1400`) ON DELETE RESTRICT ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=88 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `CMP_1430_formulas_det_lim`
--

-- LOCK TABLES `CMP_1430_formulas_det_lim` WRITE;
/*!40000 ALTER TABLE `CMP_1430_formulas_det_lim` DISABLE KEYS */;
/*!40000 ALTER TABLE `CMP_1430_formulas_det_lim` ENABLE KEYS */;
-- UNLOCK TABLES;

--
-- Table structure for table `CMP_1500_acao`
--

DROP TABLE IF EXISTS `CMP_1500_acao`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `CMP_1500_acao` (
  `id_1500_acao` int NOT NULL AUTO_INCREMENT,
  `id_questao_1200` int NOT NULL,
  `acao_1500` longtext NOT NULL,
  `id_controlador_1000` int NOT NULL,
  PRIMARY KEY (`id_1500_acao`),
  KEY `fk_1500_controlador_idx` (`id_controlador_1000`),
  CONSTRAINT `fk_1500_controlador` FOREIGN KEY (`id_controlador_1000`) REFERENCES `LGPD_1000_controlador` (`id_controlador_1000`) ON DELETE RESTRICT ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=17 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `CMP_1500_acao`
--

-- LOCK TABLES `CMP_1500_acao` WRITE;
/*!40000 ALTER TABLE `CMP_1500_acao` DISABLE KEYS */;
/*!40000 ALTER TABLE `CMP_1500_acao` ENABLE KEYS */;
-- UNLOCK TABLES;

--
-- Table structure for table `CMP_1550_ger_acao`
--

DROP TABLE IF EXISTS `CMP_1550_ger_acao`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `CMP_1550_ger_acao` (
  `id_ger_acao_1550` int NOT NULL AUTO_INCREMENT,
  `id_ciclos_2000` int NOT NULL,
  `id_questao_1200` int NOT NULL,
  `id_1500_acao` int NOT NULL,
  `id_organograma_1050` int NOT NULL,
  `dt_ger_acao_1050` date DEFAULT NULL,
  PRIMARY KEY (`id_ger_acao_1550`)
) ENGINE=InnoDB AUTO_INCREMENT=31 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `CMP_1550_ger_acao`
--

-- LOCK TABLES `CMP_1550_ger_acao` WRITE;
/*!40000 ALTER TABLE `CMP_1550_ger_acao` DISABLE KEYS */;
/*!40000 ALTER TABLE `CMP_1550_ger_acao` ENABLE KEYS */;
-- UNLOCK TABLES;

--
-- Table structure for table `CMP_1600_OL`
--

DROP TABLE IF EXISTS `CMP_1600_OL`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `CMP_1600_OL` (
  `id_ol_1600` int NOT NULL AUTO_INCREMENT,
  `tipo_ol_1600` int NOT NULL,
  `desc_ol_1600` varchar(200) NOT NULL,
  `resp_ol_1600` int NOT NULL,
  `perdiodicidade_ol_1600` int NOT NULL,
  `dia_ol_1600` int DEFAULT NULL,
  `id_controlador_1000` int NOT NULL,
  `ano_ol_1600` int NOT NULL,
  `id_organograma_1050` int DEFAULT NULL,
  `id_tp_fund_leg_2065` int DEFAULT NULL,
  `mes_ol_1600` varchar(45) DEFAULT NULL,
  `dia_semana_ol_1600` varchar(45) DEFAULT NULL,
  `tp_regra_agenda_ol_1600` varchar(45) NOT NULL,
  `desc_penalidade_ol_1600` longtext,
  `user_insert_1600` varchar(45) DEFAULT NULL,
  `dt_insert_1600` date DEFAULT NULL,
  `user_update_1600` varchar(45) DEFAULT NULL,
  `dt_ult_update_1600` date DEFAULT NULL,
  PRIMARY KEY (`id_ol_1600`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci COMMENT='Cadastro de obrigações legais ';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `CMP_1600_OL`
--

-- LOCK TABLES `CMP_1600_OL` WRITE;
/*!40000 ALTER TABLE `CMP_1600_OL` DISABLE KEYS */;
/*!40000 ALTER TABLE `CMP_1600_OL` ENABLE KEYS */;
-- UNLOCK TABLES;

--
-- Table structure for table `CMP_1610_ol_agenda`
--

DROP TABLE IF EXISTS `CMP_1610_ol_agenda`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `CMP_1610_ol_agenda` (
  `id_CMP_1610_ol_agenda` int NOT NULL AUTO_INCREMENT,
  `id_ol_1600` int NOT NULL,
  `data_ol_1610` date NOT NULL,
  `finalizada_ol_1610` tinyint NOT NULL,
  `anexo1_ol_1610` varchar(45) DEFAULT NULL,
  `anexo2_ol_1610` varchar(45) DEFAULT NULL,
  `obs_ol_1610` longtext,
  PRIMARY KEY (`id_CMP_1610_ol_agenda`)
) ENGINE=InnoDB AUTO_INCREMENT=314 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `CMP_1610_ol_agenda`
--

-- LOCK TABLES `CMP_1610_ol_agenda` WRITE;
/*!40000 ALTER TABLE `CMP_1610_ol_agenda` DISABLE KEYS */;
/*!40000 ALTER TABLE `CMP_1610_ol_agenda` ENABLE KEYS */;
-- UNLOCK TABLES;

--
-- Table structure for table `CMP_2000_ciclos`
--

DROP TABLE IF EXISTS `CMP_2000_ciclos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `CMP_2000_ciclos` (
  `id_ciclos_2000` int NOT NULL AUTO_INCREMENT,
  `nome_ciclo_2000` varchar(200) NOT NULL,
  `stauts_ciclo_2000` int NOT NULL,
  `dt_ini_ciclo_2000` date NOT NULL,
  `dt_fim_ciclo_2000` date DEFAULT NULL,
  `resp_ciclo_2000` int DEFAULT NULL,
  `id_formulas_1400` int NOT NULL,
  `id_controlador_1000` int NOT NULL,
  `ciclo_ativo_2000` tinyint NOT NULL,
  PRIMARY KEY (`id_ciclos_2000`),
  KEY `fk_2000_resp_idx` (`resp_ciclo_2000`),
  KEY `fk_2000_formula_idx` (`id_formulas_1400`),
  KEY `fk_2000_controlador_idx` (`id_controlador_1000`),
  KEY `fk_2000_status_idx` (`stauts_ciclo_2000`),
  CONSTRAINT `fk_2000_controlador` FOREIGN KEY (`id_controlador_1000`) REFERENCES `LGPD_1000_controlador` (`id_controlador_1000`),
  CONSTRAINT `fk_2000_formula` FOREIGN KEY (`id_formulas_1400`) REFERENCES `CMP_1400_formulas_mestre` (`id_formulas_1400`),
  CONSTRAINT `fk_2000_resp` FOREIGN KEY (`resp_ciclo_2000`) REFERENCES `LGPD_1100_equipe` (`cod_pessoa_1100`),
  CONSTRAINT `fk_2000_status` FOREIGN KEY (`stauts_ciclo_2000`) REFERENCES `DOM_status_ciclo_2000` (`id_status_ciclo_2000`)
) ENGINE=InnoDB AUTO_INCREMENT=77 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `CMP_2000_ciclos`
--

-- LOCK TABLES `CMP_2000_ciclos` WRITE;
/*!40000 ALTER TABLE `CMP_2000_ciclos` DISABLE KEYS */;
/*!40000 ALTER TABLE `CMP_2000_ciclos` ENABLE KEYS */;
-- UNLOCK TABLES;

--
-- Table structure for table `CMP_2100_assoc_mec_ciclo`
--

DROP TABLE IF EXISTS `CMP_2100_assoc_mec_ciclo`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `CMP_2100_assoc_mec_ciclo` (
  `id_assoc_mec_ciclo_2100` int NOT NULL AUTO_INCREMENT,
  `id_ciclo_2000` int NOT NULL,
  `id_mecanismo_1000` int NOT NULL,
  PRIMARY KEY (`id_assoc_mec_ciclo_2100`),
  KEY `fk_2100_mecanismo_idx` (`id_mecanismo_1000`),
  CONSTRAINT `fk_2100_mecanismo` FOREIGN KEY (`id_mecanismo_1000`) REFERENCES `CMP_1000_mecanismos` (`id_mecanismo_1000`)
) ENGINE=InnoDB AUTO_INCREMENT=120 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `CMP_2100_assoc_mec_ciclo`
--

-- LOCK TABLES `CMP_2100_assoc_mec_ciclo` WRITE;
/*!40000 ALTER TABLE `CMP_2100_assoc_mec_ciclo` DISABLE KEYS */;
/*!40000 ALTER TABLE `CMP_2100_assoc_mec_ciclo` ENABLE KEYS */;
-- UNLOCK TABLES;

--
-- Table structure for table `CMP_2200_assoc_dep_ciclo`
--

DROP TABLE IF EXISTS `CMP_2200_assoc_dep_ciclo`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `CMP_2200_assoc_dep_ciclo` (
  `id_assoc_dep_ciclo_2200` int NOT NULL AUTO_INCREMENT,
  `id_ciclo_2000` int NOT NULL,
  `id_organograma_1050` int DEFAULT NULL,
  PRIMARY KEY (`id_assoc_dep_ciclo_2200`),
  KEY `fk_2200_organograma_idx` (`id_organograma_1050`),
  CONSTRAINT `fk_2200_organograma` FOREIGN KEY (`id_organograma_1050`) REFERENCES `LGPD_1050_organograma` (`id_organograma_1050`)
) ENGINE=InnoDB AUTO_INCREMENT=107 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `CMP_2200_assoc_dep_ciclo`
--

-- LOCK TABLES `CMP_2200_assoc_dep_ciclo` WRITE;
/*!40000 ALTER TABLE `CMP_2200_assoc_dep_ciclo` DISABLE KEYS */;
/*!40000 ALTER TABLE `CMP_2200_assoc_dep_ciclo` ENABLE KEYS */;
-- UNLOCK TABLES;

--
-- Table structure for table `CMP_2500_conf_entrevistados`
--

DROP TABLE IF EXISTS `CMP_2500_conf_entrevistados`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `CMP_2500_conf_entrevistados` (
  `id_conf_entrevista_2500` int NOT NULL AUTO_INCREMENT,
  `id_ciclo_2000` int NOT NULL,
  `id_organograma_1050` int NOT NULL,
  `id_controlador_1000` int NOT NULL,
  PRIMARY KEY (`id_conf_entrevista_2500`),
  KEY `fk_2500_organograma_idx` (`id_organograma_1050`),
  KEY `fk_2500_controlador_idx` (`id_controlador_1000`),
  CONSTRAINT `fk_2500_controlador` FOREIGN KEY (`id_controlador_1000`) REFERENCES `LGPD_1000_controlador` (`id_controlador_1000`),
  CONSTRAINT `fk_2500_organograma` FOREIGN KEY (`id_organograma_1050`) REFERENCES `LGPD_1050_organograma` (`id_organograma_1050`)
) ENGINE=InnoDB AUTO_INCREMENT=113 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `CMP_2500_conf_entrevistados`
--

-- LOCK TABLES `CMP_2500_conf_entrevistados` WRITE;
/*!40000 ALTER TABLE `CMP_2500_conf_entrevistados` DISABLE KEYS */;
/*!40000 ALTER TABLE `CMP_2500_conf_entrevistados` ENABLE KEYS */;
-- UNLOCK TABLES;

--
-- Table structure for table `CMP_2510_det_conf_entrevistados`
--

DROP TABLE IF EXISTS `CMP_2510_det_conf_entrevistados`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `CMP_2510_det_conf_entrevistados` (
  `id_det_conf_entrevista_2510` int NOT NULL AUTO_INCREMENT,
  `cod_pessoa_1100` int NOT NULL,
  `id_conf_entrevista_2500` int NOT NULL,
  PRIMARY KEY (`id_det_conf_entrevista_2510`),
  KEY `fk_2510_pessoa_idx` (`cod_pessoa_1100`),
  CONSTRAINT `fk_2510_pessoa` FOREIGN KEY (`cod_pessoa_1100`) REFERENCES `LGPD_1100_equipe` (`cod_pessoa_1100`)
) ENGINE=InnoDB AUTO_INCREMENT=105 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `CMP_2510_det_conf_entrevistados`
--

-- LOCK TABLES `CMP_2510_det_conf_entrevistados` WRITE;
/*!40000 ALTER TABLE `CMP_2510_det_conf_entrevistados` DISABLE KEYS */;
/*!40000 ALTER TABLE `CMP_2510_det_conf_entrevistados` ENABLE KEYS */;
-- UNLOCK TABLES;

--
-- Table structure for table `CMP_3000_aplic_pesq`
--

DROP TABLE IF EXISTS `CMP_3000_aplic_pesq`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `CMP_3000_aplic_pesq` (
  `id_aplic_pesq_3000` int NOT NULL AUTO_INCREMENT,
  `id_ciclo_2000` int NOT NULL,
  `dt_inicio_3000` date NOT NULL,
  `aplic_pesq_disp_3000` tinyint DEFAULT NULL,
  PRIMARY KEY (`id_aplic_pesq_3000`)
) ENGINE=InnoDB AUTO_INCREMENT=95 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci COMMENT='Tabela de aplicação de pesquisas contendo o ciclo e o setup, data de inicio da pesquisa , status e flag de disparo.';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `CMP_3000_aplic_pesq`
--

-- LOCK TABLES `CMP_3000_aplic_pesq` WRITE;
/*!40000 ALTER TABLE `CMP_3000_aplic_pesq` DISABLE KEYS */;
/*!40000 ALTER TABLE `CMP_3000_aplic_pesq` ENABLE KEYS */;
-- UNLOCK TABLES;

--
-- Table structure for table `CMP_4000_respostas_mestre`
--

DROP TABLE IF EXISTS `CMP_4000_respostas_mestre`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `CMP_4000_respostas_mestre` (
  `id_respostas_4000` int NOT NULL AUTO_INCREMENT,
  `id_ciclos_2000` int NOT NULL,
  `id_formulario_1300` int NOT NULL,
  `cod_pessoa_1000` int NOT NULL,
  `ind_form_resp` tinyint DEFAULT NULL,
  `dt_form_resp` date DEFAULT NULL,
  `token_form_4000` varchar(10) NOT NULL,
  `id_status_4000` int NOT NULL,
  `ind_ger_action` tinyint DEFAULT NULL,
  PRIMARY KEY (`id_respostas_4000`),
  KEY `fk_4000_resposta_status` (`id_status_4000`),
  CONSTRAINT `fk_4000_resposta_status` FOREIGN KEY (`id_status_4000`) REFERENCES `DOM_status_resp_4000` (`id_status_4000`)
) ENGINE=InnoDB AUTO_INCREMENT=180 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `CMP_4000_respostas_mestre`
--

-- LOCK TABLES `CMP_4000_respostas_mestre` WRITE;
/*!40000 ALTER TABLE `CMP_4000_respostas_mestre` DISABLE KEYS */;
/*!40000 ALTER TABLE `CMP_4000_respostas_mestre` ENABLE KEYS */;
-- UNLOCK TABLES;

--
-- Table structure for table `CMP_4100_resp_det`
--

DROP TABLE IF EXISTS `CMP_4100_resp_det`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `CMP_4100_resp_det` (
  `id_resp_det_4100` int NOT NULL AUTO_INCREMENT,
  `id_respostas_4000` int NOT NULL,
  `id_questão_1200` int NOT NULL,
  `resposta_4100` text,
  PRIMARY KEY (`id_resp_det_4100`)
) ENGINE=InnoDB AUTO_INCREMENT=429 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `CMP_4100_resp_det`
--

-- LOCK TABLES `CMP_4100_resp_det` WRITE;
/*!40000 ALTER TABLE `CMP_4100_resp_det` DISABLE KEYS */;
/*!40000 ALTER TABLE `CMP_4100_resp_det` ENABLE KEYS */;
-- UNLOCK TABLES;

--
-- Temporary view structure for view `CMP_VIEW_1600`
--

DROP TABLE IF EXISTS `CMP_VIEW_1600`;
/*!50001 DROP VIEW IF EXISTS `CMP_VIEW_1600`*/;
SET @saved_cs_client     = @@character_set_client;
/*!50503 SET character_set_client = utf8mb4 */;
/*!50001 CREATE VIEW `CMP_VIEW_1600` AS SELECT 
 1 AS `id_CMP_1610_ol_agenda`,
 1 AS `email_1100`,
 1 AS `data_ol_1610`,
 1 AS `desc_ol_1600`,
 1 AS `ano_ol_1600`,
 1 AS `desc_penalidade_ol_1600`,
 1 AS `dia_ol_1600`,
 1 AS `dia_semana_ol_1600`,
 1 AS `titulo_fund_leg_2065`,
 1 AS `mes_ol_1600`,
 1 AS `desc_tp_ol_1600`,
 1 AS `desc_per_ol_1600`*/;
SET character_set_client = @saved_cs_client;

--
-- Table structure for table `DEN_1000_registro`
--

DROP TABLE IF EXISTS `DEN_1000_registro`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `DEN_1000_registro` (
  `id_1000` int NOT NULL AUTO_INCREMENT,
  `id_1100_cat_den` int DEFAULT NULL,
  `dt_den_1000` date DEFAULT NULL,
  `desc_den_1000` text,
  `den_anonima_1000` tinyint(1) DEFAULT NULL,
  `nome_inf_den_1000` text,
  `tel_inf_den_1000` char(20) DEFAULT NULL,
  `dt_ini_inv_den_1000` date DEFAULT NULL,
  `and_inv_den_1000` text,
  `conclusão_inv_den_1000` text,
  `email_inf_den_1000` char(250) DEFAULT NULL,
  `id_status_den_1000` int NOT NULL,
  `id_den_vinculo_1000` int NOT NULL,
  `nome_alvo_1000` char(250) DEFAULT NULL,
  `existe_testemunha_1000` tinyint(1) DEFAULT NULL,
  `id_den_grau_certeza_1000` int NOT NULL,
  `id_den_cadencia_1000` int NOT NULL,
  `senha_den_1000` varchar(45) NOT NULL,
  `anexo_den_img1_1000` varchar(200) DEFAULT NULL,
  `anexo_den_img2_1000` varchar(200) DEFAULT NULL,
  `anexo_den_doc1_1000` varchar(200) DEFAULT NULL,
  `anexo_den_doc2_1000` varchar(200) DEFAULT NULL,
  `id_controlador_1000` int DEFAULT NULL,
  PRIMARY KEY (`id_1000`),
  KEY `fk_den_1000` (`id_status_den_1000`),
  KEY `fk_den_vinculo_1000` (`id_den_vinculo_1000`),
  KEY `fk_den_grau_certeza_1000` (`id_den_grau_certeza_1000`),
  KEY `fk_den_cadencia_1000` (`id_den_cadencia_1000`),
  CONSTRAINT `fk_den_1000` FOREIGN KEY (`id_status_den_1000`) REFERENCES `DOM_status_den_1000` (`id_status_den_1000`),
  CONSTRAINT `fk_den_cadencia_1000` FOREIGN KEY (`id_den_cadencia_1000`) REFERENCES `DOM_den_cadencia_1000` (`id_den_cadencia_1000`),
  CONSTRAINT `fk_den_grau_certeza_1000` FOREIGN KEY (`id_den_grau_certeza_1000`) REFERENCES `DOM_den_grau_certeza_1000` (`id_den_grau_certeza_1000`),
  CONSTRAINT `fk_den_vinculo_1000` FOREIGN KEY (`id_den_vinculo_1000`) REFERENCES `DOM_den_vinculo_1000` (`id_den_vinculo_1000`)
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `DEN_1000_registro`
--

-- LOCK TABLES `DEN_1000_registro` WRITE;
/*!40000 ALTER TABLE `DEN_1000_registro` DISABLE KEYS */;
/*!40000 ALTER TABLE `DEN_1000_registro` ENABLE KEYS */;
-- UNLOCK TABLES;

--
-- Table structure for table `DEN_1100_cat`
--

DROP TABLE IF EXISTS `DEN_1100_cat`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `DEN_1100_cat` (
  `id_1100_cat_den` int NOT NULL AUTO_INCREMENT,
  `titulo_cat_den_1100` text,
  `id_controlador_1000` int DEFAULT NULL,
  PRIMARY KEY (`id_1100_cat_den`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `DEN_1100_cat`
--

-- LOCK TABLES `DEN_1100_cat` WRITE;
/*!40000 ALTER TABLE `DEN_1100_cat` DISABLE KEYS */;
/*!40000 ALTER TABLE `DEN_1100_cat` ENABLE KEYS */;
-- UNLOCK TABLES;

--
-- Table structure for table `DEN_2000_andamento`
--

DROP TABLE IF EXISTS `DEN_2000_andamento`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `DEN_2000_andamento` (
  `id_andamento_2000` int NOT NULL AUTO_INCREMENT,
  `dt_andamento_2000` date NOT NULL,
  `tp_andamento_2000` int NOT NULL,
  `desc_andamento_2000` longtext NOT NULL,
  `id_1000` int NOT NULL,
  `origem_andamento_2000` varchar(45) NOT NULL,
  `anexo_img_2000` varchar(200) DEFAULT NULL,
  `anexo_doc_2000` varchar(200) DEFAULT NULL,
  PRIMARY KEY (`id_andamento_2000`)
) ENGINE=InnoDB AUTO_INCREMENT=30 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `DEN_2000_andamento`
--

-- LOCK TABLES `DEN_2000_andamento` WRITE;
/*!40000 ALTER TABLE `DEN_2000_andamento` DISABLE KEYS */;
/*!40000 ALTER TABLE `DEN_2000_andamento` ENABLE KEYS */;
-- UNLOCK TABLES;

--
-- Table structure for table `DOM_area_atua_contr_1000`
--

DROP TABLE IF EXISTS `DOM_area_atua_contr_1000`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `DOM_area_atua_contr_1000` (
  `id_area_atua_contr_1000` int NOT NULL AUTO_INCREMENT,
  `desc_area_atua_contr_1000` varchar(45) NOT NULL,
  PRIMARY KEY (`id_area_atua_contr_1000`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `DOM_area_atua_contr_1000`
--

-- LOCK TABLES `DOM_area_atua_contr_1000` WRITE;
/*!40000 ALTER TABLE `DOM_area_atua_contr_1000` DISABLE KEYS */;
INSERT INTO `DOM_area_atua_contr_1000` VALUES (1,'Alimentação'),(2,'Comércio'),(3,'Contábil'),(4,'Hospitalar'),(5,'Indústria'),(6,'Jurídica'),(7,'Serviço'),(8,'Tecnologia');
/*!40000 ALTER TABLE `DOM_area_atua_contr_1000` ENABLE KEYS */;
-- UNLOCK TABLES;

--
-- Table structure for table `DOM_atuacao_contr_2085`
--

DROP TABLE IF EXISTS `DOM_atuacao_contr_2085`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `DOM_atuacao_contr_2085` (
  `id_atuacao_contr_2085` int NOT NULL AUTO_INCREMENT,
  `desc_atuacao_contr_2085` varchar(45) NOT NULL,
  PRIMARY KEY (`id_atuacao_contr_2085`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `DOM_atuacao_contr_2085`
--

-- LOCK TABLES `DOM_atuacao_contr_2085` WRITE;
/*!40000 ALTER TABLE `DOM_atuacao_contr_2085` DISABLE KEYS */;
INSERT INTO `DOM_atuacao_contr_2085` VALUES (1,'Controlador'),(2,'Operador');
/*!40000 ALTER TABLE `DOM_atuacao_contr_2085` ENABLE KEYS */;
-- UNLOCK TABLES;

--
-- Table structure for table `DOM_categoria_risc_3000`
--

DROP TABLE IF EXISTS `DOM_categoria_risc_3000`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `DOM_categoria_risc_3000` (
  `id_categoria_risc_3000` int NOT NULL AUTO_INCREMENT,
  `desc_categoria_risc_3000` varchar(45) NOT NULL,
  PRIMARY KEY (`id_categoria_risc_3000`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `DOM_categoria_risc_3000`
--

-- LOCK TABLES `DOM_categoria_risc_3000` WRITE;
/*!40000 ALTER TABLE `DOM_categoria_risc_3000` DISABLE KEYS */;
INSERT INTO `DOM_categoria_risc_3000` VALUES (1,'Estratégico'),(2,'Operacional'),(3,'Financeiro');
/*!40000 ALTER TABLE `DOM_categoria_risc_3000` ENABLE KEYS */;
-- UNLOCK TABLES;

--
-- Table structure for table `DOM_categoria_terc_2090`
--

DROP TABLE IF EXISTS `DOM_categoria_terc_2090`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `DOM_categoria_terc_2090` (
  `id_categoria_terc_2090` int NOT NULL AUTO_INCREMENT,
  `desc_categoria_terc_2090` varchar(45) NOT NULL,
  PRIMARY KEY (`id_categoria_terc_2090`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `DOM_categoria_terc_2090`
--

-- LOCK TABLES `DOM_categoria_terc_2090` WRITE;
/*!40000 ALTER TABLE `DOM_categoria_terc_2090` DISABLE KEYS */;
INSERT INTO `DOM_categoria_terc_2090` VALUES (1,'Cliente'),(2,'Fornecedor'),(3,'Operador'),(4,'Controlador'),(5,'Parceiro');
/*!40000 ALTER TABLE `DOM_categoria_terc_2090` ENABLE KEYS */;
-- UNLOCK TABLES;

--
-- Table structure for table `DOM_classif_terc_2090`
--

DROP TABLE IF EXISTS `DOM_classif_terc_2090`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `DOM_classif_terc_2090` (
  `id_classif_terc_2090` int NOT NULL AUTO_INCREMENT,
  `desc_classif_terc_2090` varchar(45) NOT NULL,
  PRIMARY KEY (`id_classif_terc_2090`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `DOM_classif_terc_2090`
--

-- LOCK TABLES `DOM_classif_terc_2090` WRITE;
/*!40000 ALTER TABLE `DOM_classif_terc_2090` DISABLE KEYS */;
INSERT INTO `DOM_classif_terc_2090` VALUES (1,'Estratégico'),(2,'Tático'),(3,'Operacional');
/*!40000 ALTER TABLE `DOM_classif_terc_2090` ENABLE KEYS */;
-- UNLOCK TABLES;

--
-- Table structure for table `DOM_clsf_gen_nivel_9999`
--

DROP TABLE IF EXISTS `DOM_clsf_gen_nivel_9999`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `DOM_clsf_gen_nivel_9999` (
  `id_clsf_gen_nivel_9999` int NOT NULL AUTO_INCREMENT,
  `desc_clsf_gen_nivel_9999` varchar(45) NOT NULL,
  PRIMARY KEY (`id_clsf_gen_nivel_9999`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `DOM_clsf_gen_nivel_9999`
--

-- LOCK TABLES `DOM_clsf_gen_nivel_9999` WRITE;
/*!40000 ALTER TABLE `DOM_clsf_gen_nivel_9999` DISABLE KEYS */;
INSERT INTO `DOM_clsf_gen_nivel_9999` VALUES (1,'Baixo'),(2,'Médio'),(3,'Alto');
/*!40000 ALTER TABLE `DOM_clsf_gen_nivel_9999` ENABLE KEYS */;
-- UNLOCK TABLES;

--
-- Table structure for table `DOM_den_cadencia_1000`
--

DROP TABLE IF EXISTS `DOM_den_cadencia_1000`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `DOM_den_cadencia_1000` (
  `id_den_cadencia_1000` int NOT NULL AUTO_INCREMENT,
  `desc_den_cadencia_1000` varchar(45) NOT NULL,
  PRIMARY KEY (`id_den_cadencia_1000`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `DOM_den_cadencia_1000`
--

-- LOCK TABLES `DOM_den_cadencia_1000` WRITE;
/*!40000 ALTER TABLE `DOM_den_cadencia_1000` DISABLE KEYS */;
INSERT INTO `DOM_den_cadencia_1000` VALUES (1,'Talvez'),(2,'Não'),(3,'Sim');
/*!40000 ALTER TABLE `DOM_den_cadencia_1000` ENABLE KEYS */;
-- UNLOCK TABLES;

--
-- Table structure for table `DOM_den_grau_certeza_1000`
--

DROP TABLE IF EXISTS `DOM_den_grau_certeza_1000`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `DOM_den_grau_certeza_1000` (
  `id_den_grau_certeza_1000` int NOT NULL AUTO_INCREMENT,
  `desc_den_grau_certeza_1000` varchar(45) NOT NULL,
  PRIMARY KEY (`id_den_grau_certeza_1000`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `DOM_den_grau_certeza_1000`
--

-- LOCK TABLES `DOM_den_grau_certeza_1000` WRITE;
/*!40000 ALTER TABLE `DOM_den_grau_certeza_1000` DISABLE KEYS */;
INSERT INTO `DOM_den_grau_certeza_1000` VALUES (1,'Ouvi dizer'),(2,'Tenho Certeza'),(3,'Tenho suspeitas');
/*!40000 ALTER TABLE `DOM_den_grau_certeza_1000` ENABLE KEYS */;
-- UNLOCK TABLES;

--
-- Table structure for table `DOM_den_vinculo_1000`
--

DROP TABLE IF EXISTS `DOM_den_vinculo_1000`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `DOM_den_vinculo_1000` (
  `id_den_vinculo_1000` int NOT NULL AUTO_INCREMENT,
  `desc_den_vinculo_1000col` varchar(45) NOT NULL,
  PRIMARY KEY (`id_den_vinculo_1000`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `DOM_den_vinculo_1000`
--

-- LOCK TABLES `DOM_den_vinculo_1000` WRITE;
/*!40000 ALTER TABLE `DOM_den_vinculo_1000` DISABLE KEYS */;
INSERT INTO `DOM_den_vinculo_1000` VALUES (1,'Sócio'),(2,'Colaborador'),(3,'Prestador de Serviço'),(4,'Cliente'),(5,'Fornecedor'),(6,'Outro');
/*!40000 ALTER TABLE `DOM_den_vinculo_1000` ENABLE KEYS */;
-- UNLOCK TABLES;

--
-- Table structure for table `DOM_frq_fin_2070`
--

DROP TABLE IF EXISTS `DOM_frq_fin_2070`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `DOM_frq_fin_2070` (
  `id_frq_fin_2070` int NOT NULL AUTO_INCREMENT,
  `desc_frq_fin_2070col` varchar(100) NOT NULL,
  PRIMARY KEY (`id_frq_fin_2070`)
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `DOM_frq_fin_2070`
--

-- LOCK TABLES `DOM_frq_fin_2070` WRITE;
/*!40000 ALTER TABLE `DOM_frq_fin_2070` DISABLE KEYS */;
INSERT INTO `DOM_frq_fin_2070` VALUES (5,'Muito baixa (> 30 dias de intervalo entre tratamentos)'),(6,'Muito alta (várias vezes por dia)'),(7,'Alta (diariamente)'),(8,'Média (semanalmente)'),(9,'Baixa (mensalmente)'),(10,'Baixa (mensalmente)'),(11,'Muito baixa (> 30 dias de intervalo entre tratamentos)');
/*!40000 ALTER TABLE `DOM_frq_fin_2070` ENABLE KEYS */;
-- UNLOCK TABLES;

--
-- Table structure for table `DOM_hipt_trat_fin_2070`
--

DROP TABLE IF EXISTS `DOM_hipt_trat_fin_2070`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `DOM_hipt_trat_fin_2070` (
  `id_hipt_trat_fin_2070` int NOT NULL AUTO_INCREMENT,
  `desc_hipt_trat_fin_2070` varchar(100) NOT NULL,
  PRIMARY KEY (`id_hipt_trat_fin_2070`)
) ENGINE=InnoDB AUTO_INCREMENT=19 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `DOM_hipt_trat_fin_2070`
--

-- LOCK TABLES `DOM_hipt_trat_fin_2070` WRITE;
/*!40000 ALTER TABLE `DOM_hipt_trat_fin_2070` DISABLE KEYS */;
INSERT INTO `DOM_hipt_trat_fin_2070` VALUES (1,'Art. 7º, I - Consentimento do Titular'),(2,'Art. 7º, II - Obrigação Legal ou Regulatória'),(3,'Art. 7º, III - Execução de políticas públicas'),(4,'Art. 7º, IV - Realização de Estudos'),(5,'Art. 7º, V - Execução de Contratos'),(6,'Art. 7º, VI - Direito em Processo Judicial, Adm ou Arbitral'),(7,'Art. 7º, VII - Proteção da vida do Titular ou Terceiro '),(8,'Art. 7º, VIII - Tutela de Saúde'),(9,'Art. 7º, IX - Legítimo interesse do controlador'),(10,'Art. 7º, X - Proteção de Crédito'),(11,'Art. 11º, I - Consentimento do titular'),(12,'Art. 11º, II a - Obrigação legal ou regulatória'),(13,'Art. 11º, II b - Execução de políticas públicas'),(14,'Art. 11º, II c - Realização de estudos'),(15,'Art. 11º, II d - Processo judicial, administrativo ou abitral '),(16,'Art. 11º, II e - Proteção da vida'),(17,'Art. 11º, II f - Tutela da saúde'),(18,'Art. 11º, II g - Prev. à fraude no cadastro de sist. elet.');
/*!40000 ALTER TABLE `DOM_hipt_trat_fin_2070` ENABLE KEYS */;
-- UNLOCK TABLES;

--
-- Table structure for table `DOM_metodo_env_not_4000`
--

DROP TABLE IF EXISTS `DOM_metodo_env_not_4000`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `DOM_metodo_env_not_4000` (
  `id_metodo_env_not_4000` int NOT NULL AUTO_INCREMENT,
  `desc_metodo_env_not_4000` varchar(45) NOT NULL,
  PRIMARY KEY (`id_metodo_env_not_4000`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `DOM_metodo_env_not_4000`
--

-- LOCK TABLES `DOM_metodo_env_not_4000` WRITE;
/*!40000 ALTER TABLE `DOM_metodo_env_not_4000` DISABLE KEYS */;
INSERT INTO `DOM_metodo_env_not_4000` VALUES (1,'E-mail'),(2,'Correio');
/*!40000 ALTER TABLE `DOM_metodo_env_not_4000` ENABLE KEYS */;
-- UNLOCK TABLES;

--
-- Table structure for table `DOM_nivel_crit_2000`
--

DROP TABLE IF EXISTS `DOM_nivel_crit_2000`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `DOM_nivel_crit_2000` (
  `id_nivel_crit_2000` int NOT NULL AUTO_INCREMENT,
  `desc_nivel_crit_2000` varchar(45) NOT NULL,
  PRIMARY KEY (`id_nivel_crit_2000`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `DOM_nivel_crit_2000`
--

-- LOCK TABLES `DOM_nivel_crit_2000` WRITE;
/*!40000 ALTER TABLE `DOM_nivel_crit_2000` DISABLE KEYS */;
INSERT INTO `DOM_nivel_crit_2000` VALUES (1,'Baixa'),(2,'Moderada'),(3,'Urgente');
/*!40000 ALTER TABLE `DOM_nivel_crit_2000` ENABLE KEYS */;
-- UNLOCK TABLES;

--
-- Table structure for table `DOM_origem_not_4000`
--

DROP TABLE IF EXISTS `DOM_origem_not_4000`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `DOM_origem_not_4000` (
  `id_origem_not_4000` int NOT NULL AUTO_INCREMENT,
  `desc_origem_not_4000` varchar(45) NOT NULL,
  PRIMARY KEY (`id_origem_not_4000`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `DOM_origem_not_4000`
--

-- LOCK TABLES `DOM_origem_not_4000` WRITE;
/*!40000 ALTER TABLE `DOM_origem_not_4000` DISABLE KEYS */;
INSERT INTO `DOM_origem_not_4000` VALUES (1,'Manual'),(2,'Incidente');
/*!40000 ALTER TABLE `DOM_origem_not_4000` ENABLE KEYS */;
-- UNLOCK TABLES;

--
-- Table structure for table `DOM_pac_1100_status`
--

DROP TABLE IF EXISTS `DOM_pac_1100_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `DOM_pac_1100_status` (
  `id_pac_1100_status` int NOT NULL AUTO_INCREMENT,
  `desc_pac_1100_status` varchar(100) NOT NULL,
  PRIMARY KEY (`id_pac_1100_status`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `DOM_pac_1100_status`
--

-- LOCK TABLES `DOM_pac_1100_status` WRITE;
/*!40000 ALTER TABLE `DOM_pac_1100_status` DISABLE KEYS */;
INSERT INTO `DOM_pac_1100_status` VALUES (1,'Aberta'),(2,'Em análise'),(3,'Em andamento'),(4,'Aguardando solicitante (informções adicionais)'),(5,'Finalizada');
/*!40000 ALTER TABLE `DOM_pac_1100_status` ENABLE KEYS */;
-- UNLOCK TABLES;

--
-- Table structure for table `DOM_paises_1100`
--

DROP TABLE IF EXISTS `DOM_paises_1100`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `DOM_paises_1100` (
  `id_paises_1100` int NOT NULL AUTO_INCREMENT,
  `sigla_pais_1100` varchar(5) DEFAULT NULL,
  `nm_pais_1100` varchar(150) DEFAULT NULL,
  PRIMARY KEY (`id_paises_1100`)
) ENGINE=InnoDB AUTO_INCREMENT=242 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `DOM_paises_1100`
--

-- LOCK TABLES `DOM_paises_1100` WRITE;
/*!40000 ALTER TABLE `DOM_paises_1100` DISABLE KEYS */;
/*!40000 ALTER TABLE `DOM_paises_1100` ENABLE KEYS */;
-- UNLOCK TABLES;

--
-- Table structure for table `DOM_papel_ent_2070`
--

DROP TABLE IF EXISTS `DOM_papel_ent_2070`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `DOM_papel_ent_2070` (
  `id_papel_ent_2070` int NOT NULL AUTO_INCREMENT,
  `desc_papel_ent_2070col` varchar(45) NOT NULL,
  PRIMARY KEY (`id_papel_ent_2070`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `DOM_papel_ent_2070`
--

-- LOCK TABLES `DOM_papel_ent_2070` WRITE;
/*!40000 ALTER TABLE `DOM_papel_ent_2070` DISABLE KEYS */;
INSERT INTO `DOM_papel_ent_2070` VALUES (1,'Controlador'),(2,'Operador');
/*!40000 ALTER TABLE `DOM_papel_ent_2070` ENABLE KEYS */;
-- UNLOCK TABLES;

--
-- Table structure for table `DOM_per_ol_1600`
--

DROP TABLE IF EXISTS `DOM_per_ol_1600`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `DOM_per_ol_1600` (
  `id_per_ol_1600` int NOT NULL AUTO_INCREMENT,
  `desc_per_ol_1600` varchar(45) NOT NULL,
  PRIMARY KEY (`id_per_ol_1600`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci COMMENT='Periocidades das obrighações legais';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `DOM_per_ol_1600`
--

-- LOCK TABLES `DOM_per_ol_1600` WRITE;
/*!40000 ALTER TABLE `DOM_per_ol_1600` DISABLE KEYS */;
INSERT INTO `DOM_per_ol_1600` VALUES (1,'Diária'),(2,'Semanal'),(3,'Mensal'),(4,'Anual');
/*!40000 ALTER TABLE `DOM_per_ol_1600` ENABLE KEYS */;
-- UNLOCK TABLES;

--
-- Table structure for table `DOM_product_unit_price`
--

DROP TABLE IF EXISTS `DOM_product_unit_price`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `DOM_product_unit_price` (
  `id_product_unit_price` int NOT NULL AUTO_INCREMENT,
  `desc_product_unit_price` varchar(45) NOT NULL,
  PRIMARY KEY (`id_product_unit_price`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `DOM_product_unit_price`
--

-- LOCK TABLES `DOM_product_unit_price` WRITE;
/*!40000 ALTER TABLE `DOM_product_unit_price` DISABLE KEYS */;
INSERT INTO `DOM_product_unit_price` VALUES (1,'Anuidade'),(2,'Mensalidade'),(3,'Vitálicia');
/*!40000 ALTER TABLE `DOM_product_unit_price` ENABLE KEYS */;
-- UNLOCK TABLES;

--
-- Table structure for table `DOM_relac_tit_2020`
--

DROP TABLE IF EXISTS `DOM_relac_tit_2020`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `DOM_relac_tit_2020` (
  `id_relac_tit_2020` int NOT NULL AUTO_INCREMENT,
  `desc_relac_tit_2020` varchar(45) NOT NULL,
  PRIMARY KEY (`id_relac_tit_2020`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `DOM_relac_tit_2020`
--

-- LOCK TABLES `DOM_relac_tit_2020` WRITE;
/*!40000 ALTER TABLE `DOM_relac_tit_2020` DISABLE KEYS */;
INSERT INTO `DOM_relac_tit_2020` VALUES (1,'Candidato'),(2,'Cliente'),(3,'Colaborador'),(4,'Dependente'),(5,'Fornecedor'),(6,'Sócio'),(7,'Visitante');
/*!40000 ALTER TABLE `DOM_relac_tit_2020` ENABLE KEYS */;
-- UNLOCK TABLES;

--
-- Table structure for table `DOM_resp_tit_3200`
--

DROP TABLE IF EXISTS `DOM_resp_tit_3200`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `DOM_resp_tit_3200` (
  `id_resp_tit_3200` int NOT NULL AUTO_INCREMENT,
  `desc_resp_tit_3200` varchar(45) NOT NULL,
  PRIMARY KEY (`id_resp_tit_3200`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `DOM_resp_tit_3200`
--

-- LOCK TABLES `DOM_resp_tit_3200` WRITE;
/*!40000 ALTER TABLE `DOM_resp_tit_3200` DISABLE KEYS */;
INSERT INTO `DOM_resp_tit_3200` VALUES (1,'Em aberto'),(2,'Negado'),(3,'Aceito');
/*!40000 ALTER TABLE `DOM_resp_tit_3200` ENABLE KEYS */;
-- UNLOCK TABLES;

--
-- Table structure for table `DOM_service_unit_price`
--

DROP TABLE IF EXISTS `DOM_service_unit_price`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `DOM_service_unit_price` (
  `id_service_unit_price` int NOT NULL AUTO_INCREMENT,
  `desc_service_unit_price` varchar(45) NOT NULL,
  PRIMARY KEY (`id_service_unit_price`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `DOM_service_unit_price`
--

-- LOCK TABLES `DOM_service_unit_price` WRITE;
/*!40000 ALTER TABLE `DOM_service_unit_price` DISABLE KEYS */;
INSERT INTO `DOM_service_unit_price` VALUES (1,'Anuidade'),(2,'Hora'),(3,'Mensalidade');
/*!40000 ALTER TABLE `DOM_service_unit_price` ENABLE KEYS */;
-- UNLOCK TABLES;

--
-- Table structure for table `DOM_status_6500`
--

DROP TABLE IF EXISTS `DOM_status_6500`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `DOM_status_6500` (
  `id_status_6500` int NOT NULL AUTO_INCREMENT,
  `desc_status_6500col` varchar(45) NOT NULL,
  PRIMARY KEY (`id_status_6500`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `DOM_status_6500`
--

-- LOCK TABLES `DOM_status_6500` WRITE;
/*!40000 ALTER TABLE `DOM_status_6500` DISABLE KEYS */;
INSERT INTO `DOM_status_6500` VALUES (1,'Não revisar'),(2,'Em planejamento'),(3,'Em revisão'),(4,'Revisão finalizada');
/*!40000 ALTER TABLE `DOM_status_6500` ENABLE KEYS */;
-- UNLOCK TABLES;

--
-- Table structure for table `DOM_status_ciclo_2000`
--

DROP TABLE IF EXISTS `DOM_status_ciclo_2000`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `DOM_status_ciclo_2000` (
  `id_status_ciclo_2000` int NOT NULL AUTO_INCREMENT,
  `desc_status_ciclo_2000` varchar(45) NOT NULL,
  PRIMARY KEY (`id_status_ciclo_2000`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `DOM_status_ciclo_2000`
--

-- LOCK TABLES `DOM_status_ciclo_2000` WRITE;
/*!40000 ALTER TABLE `DOM_status_ciclo_2000` DISABLE KEYS */;
INSERT INTO `DOM_status_ciclo_2000` VALUES (1,'Planejado'),(2,'Em execução'),(3,'Encerrado'),(4,'Finalizado');
/*!40000 ALTER TABLE `DOM_status_ciclo_2000` ENABLE KEYS */;
-- UNLOCK TABLES;

--
-- Table structure for table `DOM_status_cid_2010`
--

DROP TABLE IF EXISTS `DOM_status_cid_2010`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `DOM_status_cid_2010` (
  `id_status_cid_2010` int NOT NULL AUTO_INCREMENT,
  `desc_status_cid_2010` varchar(45) NOT NULL,
  PRIMARY KEY (`id_status_cid_2010`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `DOM_status_cid_2010`
--

-- LOCK TABLES `DOM_status_cid_2010` WRITE;
/*!40000 ALTER TABLE `DOM_status_cid_2010` DISABLE KEYS */;
INSERT INTO `DOM_status_cid_2010` VALUES (1,'Baixo'),(2,'Médio'),(3,'Alto');
/*!40000 ALTER TABLE `DOM_status_cid_2010` ENABLE KEYS */;
-- UNLOCK TABLES;

--
-- Table structure for table `DOM_status_contr_2085`
--

DROP TABLE IF EXISTS `DOM_status_contr_2085`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `DOM_status_contr_2085` (
  `id_status_contr_2085` int NOT NULL AUTO_INCREMENT,
  `desc_status_contr_2085` varchar(45) NOT NULL,
  PRIMARY KEY (`id_status_contr_2085`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `DOM_status_contr_2085`
--

-- LOCK TABLES `DOM_status_contr_2085` WRITE;
/*!40000 ALTER TABLE `DOM_status_contr_2085` DISABLE KEYS */;
INSERT INTO `DOM_status_contr_2085` VALUES (1,'Em elaboração'),(2,'Finalizado');
/*!40000 ALTER TABLE `DOM_status_contr_2085` ENABLE KEYS */;
-- UNLOCK TABLES;

--
-- Table structure for table `DOM_status_den_1000`
--

DROP TABLE IF EXISTS `DOM_status_den_1000`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `DOM_status_den_1000` (
  `id_status_den_1000` int NOT NULL AUTO_INCREMENT,
  `desc_status_den_1000` varchar(45) NOT NULL,
  PRIMARY KEY (`id_status_den_1000`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `DOM_status_den_1000`
--

-- LOCK TABLES `DOM_status_den_1000` WRITE;
/*!40000 ALTER TABLE `DOM_status_den_1000` DISABLE KEYS */;
INSERT INTO `DOM_status_den_1000` VALUES (1,'Aberta'),(2,'Em análise'),(3,'Em investigação'),(4,'Rejeitada'),(5,'Encerrada');
/*!40000 ALTER TABLE `DOM_status_den_1000` ENABLE KEYS */;
-- UNLOCK TABLES;

--
-- Table structure for table `DOM_status_etapa_0400`
--

DROP TABLE IF EXISTS `DOM_status_etapa_0400`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `DOM_status_etapa_0400` (
  `id_status_etapa_0400` int NOT NULL AUTO_INCREMENT,
  `desc_status_etapa_0400` varchar(45) NOT NULL,
  PRIMARY KEY (`id_status_etapa_0400`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `DOM_status_etapa_0400`
--

-- LOCK TABLES `DOM_status_etapa_0400` WRITE;
/*!40000 ALTER TABLE `DOM_status_etapa_0400` DISABLE KEYS */;
INSERT INTO `DOM_status_etapa_0400` VALUES (1,'Em Planejamento'),(2,'Em Andamento'),(3,'Encerrada');
/*!40000 ALTER TABLE `DOM_status_etapa_0400` ENABLE KEYS */;
-- UNLOCK TABLES;

--
-- Table structure for table `DOM_status_inc_2000`
--

DROP TABLE IF EXISTS `DOM_status_inc_2000`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `DOM_status_inc_2000` (
  `id_status_inc_2000` int NOT NULL AUTO_INCREMENT,
  `desc_status_inc_2000` varchar(45) NOT NULL,
  PRIMARY KEY (`id_status_inc_2000`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `DOM_status_inc_2000`
--

-- LOCK TABLES `DOM_status_inc_2000` WRITE;
/*!40000 ALTER TABLE `DOM_status_inc_2000` DISABLE KEYS */;
INSERT INTO `DOM_status_inc_2000` VALUES (1,'Gerado'),(2,'Em tratamento'),(3,'Encerrado'),(4,'Cancelado'),(5,'Aberto');
/*!40000 ALTER TABLE `DOM_status_inc_2000` ENABLE KEYS */;
-- UNLOCK TABLES;

--
-- Table structure for table `DOM_status_not_4000`
--

DROP TABLE IF EXISTS `DOM_status_not_4000`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `DOM_status_not_4000` (
  `id_status_not_4000` int NOT NULL AUTO_INCREMENT,
  `desc_status_not_4000` varchar(45) NOT NULL,
  PRIMARY KEY (`id_status_not_4000`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `DOM_status_not_4000`
--

-- LOCK TABLES `DOM_status_not_4000` WRITE;
/*!40000 ALTER TABLE `DOM_status_not_4000` DISABLE KEYS */;
INSERT INTO `DOM_status_not_4000` VALUES (1,'Cadastrada'),(2,'Enviada'),(3,'Retornada'),(4,'Encerrada'),(5,'Cancelada'),(6,'Gerada');
/*!40000 ALTER TABLE `DOM_status_not_4000` ENABLE KEYS */;
-- UNLOCK TABLES;

--
-- Table structure for table `DOM_status_pdca_6000`
--

DROP TABLE IF EXISTS `DOM_status_pdca_6000`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `DOM_status_pdca_6000` (
  `id_status_pdca_6000` int NOT NULL AUTO_INCREMENT,
  `desc_status_pdca_6000` varchar(45) NOT NULL,
  PRIMARY KEY (`id_status_pdca_6000`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `DOM_status_pdca_6000`
--

-- LOCK TABLES `DOM_status_pdca_6000` WRITE;
/*!40000 ALTER TABLE `DOM_status_pdca_6000` DISABLE KEYS */;
INSERT INTO `DOM_status_pdca_6000` VALUES (1,'Em planejamento'),(2,'Em andamento'),(3,'Pausado'),(4,'Finalizado');
/*!40000 ALTER TABLE `DOM_status_pdca_6000` ENABLE KEYS */;
-- UNLOCK TABLES;

--
-- Table structure for table `DOM_status_plan_4500`
--

DROP TABLE IF EXISTS `DOM_status_plan_4500`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `DOM_status_plan_4500` (
  `id_status_plan_4500` int NOT NULL AUTO_INCREMENT,
  `desc_status_plan_4500` varchar(45) NOT NULL,
  PRIMARY KEY (`id_status_plan_4500`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `DOM_status_plan_4500`
--

-- LOCK TABLES `DOM_status_plan_4500` WRITE;
/*!40000 ALTER TABLE `DOM_status_plan_4500` DISABLE KEYS */;
INSERT INTO `DOM_status_plan_4500` VALUES (1,'Em elaboração'),(2,'Em aprovação'),(3,'Aprovado'),(4,'Publicado'),(5,'Rejeitado');
/*!40000 ALTER TABLE `DOM_status_plan_4500` ENABLE KEYS */;
-- UNLOCK TABLES;

--
-- Table structure for table `DOM_status_pol_2080`
--

DROP TABLE IF EXISTS `DOM_status_pol_2080`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `DOM_status_pol_2080` (
  `id_status_pol_2080` int NOT NULL AUTO_INCREMENT,
  `desc_status_pol_2080` varchar(45) NOT NULL,
  PRIMARY KEY (`id_status_pol_2080`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `DOM_status_pol_2080`
--

-- LOCK TABLES `DOM_status_pol_2080` WRITE;
/*!40000 ALTER TABLE `DOM_status_pol_2080` DISABLE KEYS */;
INSERT INTO `DOM_status_pol_2080` VALUES (1,'Levantada'),(2,'Em Análise'),(3,'Analisada');
/*!40000 ALTER TABLE `DOM_status_pol_2080` ENABLE KEYS */;
-- UNLOCK TABLES;

--
-- Table structure for table `DOM_status_prc_2000`
--

DROP TABLE IF EXISTS `DOM_status_prc_2000`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `DOM_status_prc_2000` (
  `id_status_prc_2000` int NOT NULL AUTO_INCREMENT,
  `desc_status_prc_2000` varchar(45) NOT NULL,
  PRIMARY KEY (`id_status_prc_2000`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `DOM_status_prc_2000`
--

-- LOCK TABLES `DOM_status_prc_2000` WRITE;
/*!40000 ALTER TABLE `DOM_status_prc_2000` DISABLE KEYS */;
INSERT INTO `DOM_status_prc_2000` VALUES (1,'Em análise'),(2,'Em aprovação'),(3,'Aprovado'),(4,'Reprovado'),(5,'Aposentado');
/*!40000 ALTER TABLE `DOM_status_prc_2000` ENABLE KEYS */;
-- UNLOCK TABLES;

--
-- Table structure for table `DOM_status_resp_4000`
--

DROP TABLE IF EXISTS `DOM_status_resp_4000`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `DOM_status_resp_4000` (
  `id_status_4000` int NOT NULL AUTO_INCREMENT,
  `desc_status_4000` varchar(50) NOT NULL,
  PRIMARY KEY (`id_status_4000`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `DOM_status_resp_4000`
--

-- LOCK TABLES `DOM_status_resp_4000` WRITE;
/*!40000 ALTER TABLE `DOM_status_resp_4000` DISABLE KEYS */;
INSERT INTO `DOM_status_resp_4000` VALUES (1,'Planejado'),(2,'Em execução'),(3,'Encerrado'),(4,'Bloqueado');
/*!40000 ALTER TABLE `DOM_status_resp_4000` ENABLE KEYS */;
-- UNLOCK TABLES;

--
-- Table structure for table `DOM_status_risc_3000`
--

DROP TABLE IF EXISTS `DOM_status_risc_3000`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `DOM_status_risc_3000` (
  `id_status_risc_3000` int NOT NULL AUTO_INCREMENT,
  `desc_status_risc_3000` varchar(45) NOT NULL,
  PRIMARY KEY (`id_status_risc_3000`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `DOM_status_risc_3000`
--

-- LOCK TABLES `DOM_status_risc_3000` WRITE;
/*!40000 ALTER TABLE `DOM_status_risc_3000` DISABLE KEYS */;
INSERT INTO `DOM_status_risc_3000` VALUES (1,'Encontrado'),(2,'Controlado'),(3,'Disparado'),(4,'Encerrado');
/*!40000 ALTER TABLE `DOM_status_risc_3000` ENABLE KEYS */;
-- UNLOCK TABLES;

--
-- Table structure for table `DOM_subtipo_not_4000`
--

DROP TABLE IF EXISTS `DOM_subtipo_not_4000`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `DOM_subtipo_not_4000` (
  `id_subtipo_not_4000` int NOT NULL AUTO_INCREMENT,
  `desc_subtipo_not_4000` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`id_subtipo_not_4000`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `DOM_subtipo_not_4000`
--

-- LOCK TABLES `DOM_subtipo_not_4000` WRITE;
/*!40000 ALTER TABLE `DOM_subtipo_not_4000` DISABLE KEYS */;
INSERT INTO `DOM_subtipo_not_4000` VALUES (1,'Complementar'),(2,'Parcial');
/*!40000 ALTER TABLE `DOM_subtipo_not_4000` ENABLE KEYS */;
-- UNLOCK TABLES;

--
-- Table structure for table `DOM_tema_atv_4000`
--

DROP TABLE IF EXISTS `DOM_tema_atv_4000`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `DOM_tema_atv_4000` (
  `id_tema_atv_4000` int NOT NULL AUTO_INCREMENT,
  `desc_tema_atv_4000` varchar(60) NOT NULL,
  PRIMARY KEY (`id_tema_atv_4000`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `DOM_tema_atv_4000`
--

-- LOCK TABLES `DOM_tema_atv_4000` WRITE;
/*!40000 ALTER TABLE `DOM_tema_atv_4000` DISABLE KEYS */;
INSERT INTO `DOM_tema_atv_4000` VALUES (1,'Aspectos operacionais e administrativos'),(2,'Aspectos tecnológicos'),(3,'Aspectos jurídicos'),(4,'Aspectos evolutivos'),(5,'Aspectos de compliance'),(6,'Aspectos gerais'),(7,'Outros');
/*!40000 ALTER TABLE `DOM_tema_atv_4000` ENABLE KEYS */;
-- UNLOCK TABLES;

--
-- Table structure for table `DOM_tipificacao_dad_2030`
--

DROP TABLE IF EXISTS `DOM_tipificacao_dad_2030`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `DOM_tipificacao_dad_2030` (
  `id_tipificacao_dad_2030` int NOT NULL AUTO_INCREMENT,
  `desc_tipificacao_dad_2030` varchar(45) NOT NULL,
  PRIMARY KEY (`id_tipificacao_dad_2030`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `DOM_tipificacao_dad_2030`
--

-- LOCK TABLES `DOM_tipificacao_dad_2030` WRITE;
/*!40000 ALTER TABLE `DOM_tipificacao_dad_2030` DISABLE KEYS */;
INSERT INTO `DOM_tipificacao_dad_2030` VALUES (1,'Direto'),(2,'Indireto');
/*!40000 ALTER TABLE `DOM_tipificacao_dad_2030` ENABLE KEYS */;
-- UNLOCK TABLES;

--
-- Table structure for table `DOM_tipo_atv_2010`
--

DROP TABLE IF EXISTS `DOM_tipo_atv_2010`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `DOM_tipo_atv_2010` (
  `id_tipo_atv_2010` int NOT NULL AUTO_INCREMENT,
  `desc_tipo_atv_2010` varchar(45) NOT NULL,
  PRIMARY KEY (`id_tipo_atv_2010`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `DOM_tipo_atv_2010`
--

-- LOCK TABLES `DOM_tipo_atv_2010` WRITE;
/*!40000 ALTER TABLE `DOM_tipo_atv_2010` DISABLE KEYS */;
INSERT INTO `DOM_tipo_atv_2010` VALUES (1,'Eletrônico'),(2,'Físico');
/*!40000 ALTER TABLE `DOM_tipo_atv_2010` ENABLE KEYS */;
-- UNLOCK TABLES;

--
-- Table structure for table `DOM_tipo_dad_2030`
--

DROP TABLE IF EXISTS `DOM_tipo_dad_2030`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `DOM_tipo_dad_2030` (
  `id_tipo_dad_2030` int NOT NULL AUTO_INCREMENT,
  `desc_tipo_dad_2030` varchar(45) NOT NULL,
  PRIMARY KEY (`id_tipo_dad_2030`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `DOM_tipo_dad_2030`
--

-- LOCK TABLES `DOM_tipo_dad_2030` WRITE;
/*!40000 ALTER TABLE `DOM_tipo_dad_2030` DISABLE KEYS */;
INSERT INTO `DOM_tipo_dad_2030` VALUES (1,'Biográfico'),(2,'Cadastral'),(3,'Biográfico Sensível'),(4,'Biométrico Sensível'),(5,'Genético Sensível'),(6,'Dado Sensível de Saúde');
/*!40000 ALTER TABLE `DOM_tipo_dad_2030` ENABLE KEYS */;
-- UNLOCK TABLES;

--
-- Table structure for table `DOM_topicos_3500`
--

DROP TABLE IF EXISTS `DOM_topicos_3500`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `DOM_topicos_3500` (
  `id_topico_3500` int NOT NULL AUTO_INCREMENT,
  `desc_topicos_3500` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`id_topico_3500`)
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci COMMENT='tabela de dominio para a coluna de topicos , tulizada na tabela LGPD_3500_checklist_risk_padrao';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `DOM_topicos_3500`
--

-- LOCK TABLES `DOM_topicos_3500` WRITE;
/*!40000 ALTER TABLE `DOM_topicos_3500` DISABLE KEYS */;
INSERT INTO `DOM_topicos_3500` VALUES (1,'Abrangência do SGPD'),(2,'Papéis e responsabilidades'),(3,'Website corporativo'),(4,'Medidas adminstrativas de segurança'),(5,'Medidas técnicas de segurança'),(6,'Cadastro de terceiros e contratos'),(7,'Gestão de consentimentos'),(8,'Processos LGPD e capacitações'),(9,'Finalidades de tratamento de dados');
/*!40000 ALTER TABLE `DOM_topicos_3500` ENABLE KEYS */;
-- UNLOCK TABLES;

--
-- Table structure for table `DOM_topicos_3600`
--

DROP TABLE IF EXISTS `DOM_topicos_3600`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `DOM_topicos_3600` (
  `id_topico_3600` int NOT NULL AUTO_INCREMENT,
  `desc_topicos_3600` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`id_topico_3600`)
) ENGINE=InnoDB AUTO_INCREMENT=17 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci COMMENT='tabela de dominio para a coluna de topicos , tulizada na tabela LGPD_3600_checklist_risk_area';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `DOM_topicos_3600`
--

-- LOCK TABLES `DOM_topicos_3600` WRITE;
/*!40000 ALTER TABLE `DOM_topicos_3600` DISABLE KEYS */;
INSERT INTO `DOM_topicos_3600` VALUES (1,'Controle de acesso'),(2,'Gerenciamento de senhas'),(3,'Política de mesa limpa'),(4,'Dispositívos corporativos'),(5,'Dispositivos móveis e particulares'),(6,'Transferências de informações'),(7,'Descarte de informações');
/*!40000 ALTER TABLE `DOM_topicos_3600` ENABLE KEYS */;
-- UNLOCK TABLES;

--
-- Table structure for table `DOM_tp_artefato_2020`
--

DROP TABLE IF EXISTS `DOM_tp_artefato_2020`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `DOM_tp_artefato_2020` (
  `id_tp_artefato_2020` int NOT NULL AUTO_INCREMENT,
  `desc_tp_artefato_2020` varchar(45) NOT NULL,
  PRIMARY KEY (`id_tp_artefato_2020`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `DOM_tp_artefato_2020`
--

-- LOCK TABLES `DOM_tp_artefato_2020` WRITE;
/*!40000 ALTER TABLE `DOM_tp_artefato_2020` DISABLE KEYS */;
INSERT INTO `DOM_tp_artefato_2020` VALUES (1,'Eletrônico'),(2,'Físico'),(3,'Eletrônico/Físico');
/*!40000 ALTER TABLE `DOM_tp_artefato_2020` ENABLE KEYS */;
-- UNLOCK TABLES;

--
-- Table structure for table `DOM_tp_atu_terc_2090`
--

DROP TABLE IF EXISTS `DOM_tp_atu_terc_2090`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `DOM_tp_atu_terc_2090` (
  `id_tp_atu_terc_2090` int NOT NULL AUTO_INCREMENT,
  `desc_tp_atu_terc_2090` varchar(45) NOT NULL,
  PRIMARY KEY (`id_tp_atu_terc_2090`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `DOM_tp_atu_terc_2090`
--

-- LOCK TABLES `DOM_tp_atu_terc_2090` WRITE;
/*!40000 ALTER TABLE `DOM_tp_atu_terc_2090` DISABLE KEYS */;
INSERT INTO `DOM_tp_atu_terc_2090` VALUES (1,'Privada'),(2,'Pública'),(3,'Economia Mista');
/*!40000 ALTER TABLE `DOM_tp_atu_terc_2090` ENABLE KEYS */;
-- UNLOCK TABLES;

--
-- Table structure for table `DOM_tp_atua_contr_1000`
--

DROP TABLE IF EXISTS `DOM_tp_atua_contr_1000`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `DOM_tp_atua_contr_1000` (
  `id_tp_atua_contr_1000` int NOT NULL AUTO_INCREMENT,
  `desc_tp_atua_contr_1000` varchar(45) NOT NULL,
  PRIMARY KEY (`id_tp_atua_contr_1000`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `DOM_tp_atua_contr_1000`
--

-- LOCK TABLES `DOM_tp_atua_contr_1000` WRITE;
/*!40000 ALTER TABLE `DOM_tp_atua_contr_1000` DISABLE KEYS */;
INSERT INTO `DOM_tp_atua_contr_1000` VALUES (1,'Economia Mista'),(2,'Pública'),(3,'Privada');
/*!40000 ALTER TABLE `DOM_tp_atua_contr_1000` ENABLE KEYS */;
-- UNLOCK TABLES;

--
-- Table structure for table `DOM_tp_atv_den_2000`
--

DROP TABLE IF EXISTS `DOM_tp_atv_den_2000`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `DOM_tp_atv_den_2000` (
  `id_tp_atv_den_2000` int NOT NULL AUTO_INCREMENT,
  `desc_tp_atvden_2000` varchar(200) NOT NULL,
  `origem_2000` varchar(45) NOT NULL,
  PRIMARY KEY (`id_tp_atv_den_2000`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `DOM_tp_atv_den_2000`
--

-- LOCK TABLES `DOM_tp_atv_den_2000` WRITE;
/*!40000 ALTER TABLE `DOM_tp_atv_den_2000` DISABLE KEYS */;
INSERT INTO `DOM_tp_atv_den_2000` VALUES (1,'Solicitação de Informação adicional','Controlador'),(2,'Resposta ao denunciante','Controlador'),(3,'Andamento da investigação','Controlador'),(4,'Resultado da inverstigação','Controlador'),(5,'Resposta ao controlador','Denunciante'),(6,'Pergunta ao controlador','Denunciante'),(7,'Envio de novas informações','Denunciante');
/*!40000 ALTER TABLE `DOM_tp_atv_den_2000` ENABLE KEYS */;
-- UNLOCK TABLES;

--
-- Table structure for table `DOM_tp_disc_atv_4000`
--

DROP TABLE IF EXISTS `DOM_tp_disc_atv_4000`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `DOM_tp_disc_atv_4000` (
  `id_tp_disc_atv_4000` int NOT NULL AUTO_INCREMENT,
  `desc_tp_disc_atv_4000` varchar(45) NOT NULL,
  PRIMARY KEY (`id_tp_disc_atv_4000`)
) ENGINE=InnoDB AUTO_INCREMENT=14 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `DOM_tp_disc_atv_4000`
--

-- LOCK TABLES `DOM_tp_disc_atv_4000` WRITE;
/*!40000 ALTER TABLE `DOM_tp_disc_atv_4000` DISABLE KEYS */;
INSERT INTO `DOM_tp_disc_atv_4000` VALUES (1,'Gestão'),(2,'Definição'),(3,'Inventário ou cadastro'),(4,'Aprovação'),(5,'Comunicação'),(6,'Capacitação'),(7,'Reunião'),(8,'Ajuste operacional'),(9,'Elaboração de documento'),(10,'Análise ou implementação jurídica'),(11,'Análise ou implementação técnica'),(12,'Auditoria'),(13,'Outro');
/*!40000 ALTER TABLE `DOM_tp_disc_atv_4000` ENABLE KEYS */;
-- UNLOCK TABLES;

--
-- Table structure for table `DOM_tp_est_risc_3000`
--

DROP TABLE IF EXISTS `DOM_tp_est_risc_3000`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `DOM_tp_est_risc_3000` (
  `id_tp_est_risc_3000` int NOT NULL AUTO_INCREMENT,
  `desc_tp_est_risc_3000` varchar(45) NOT NULL,
  PRIMARY KEY (`id_tp_est_risc_3000`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `DOM_tp_est_risc_3000`
--

-- LOCK TABLES `DOM_tp_est_risc_3000` WRITE;
/*!40000 ALTER TABLE `DOM_tp_est_risc_3000` DISABLE KEYS */;
INSERT INTO `DOM_tp_est_risc_3000` VALUES (1,'Evitar'),(2,'Mitigar'),(3,'Compartilhar/Transferir'),(4,'Aceitar');
/*!40000 ALTER TABLE `DOM_tp_est_risc_3000` ENABLE KEYS */;
-- UNLOCK TABLES;

--
-- Table structure for table `DOM_tp_fund_legal_2065`
--

DROP TABLE IF EXISTS `DOM_tp_fund_legal_2065`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `DOM_tp_fund_legal_2065` (
  `id_tp_fund_legal_2065` int NOT NULL AUTO_INCREMENT,
  `desc_tp_fund_legal_2065` varchar(45) NOT NULL,
  PRIMARY KEY (`id_tp_fund_legal_2065`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `DOM_tp_fund_legal_2065`
--

-- LOCK TABLES `DOM_tp_fund_legal_2065` WRITE;
/*!40000 ALTER TABLE `DOM_tp_fund_legal_2065` DISABLE KEYS */;
INSERT INTO `DOM_tp_fund_legal_2065` VALUES (1,'Lei/Decreto Federal'),(2,'Lei/Decreto Estadual'),(3,'Lei/Decreto Municipal'),(4,'Regulamento'),(5,'Padrão de Qualidade');
/*!40000 ALTER TABLE `DOM_tp_fund_legal_2065` ENABLE KEYS */;
-- UNLOCK TABLES;

--
-- Table structure for table `DOM_tp_inc_2000`
--

DROP TABLE IF EXISTS `DOM_tp_inc_2000`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `DOM_tp_inc_2000` (
  `id_tp_inc_2000` int NOT NULL AUTO_INCREMENT,
  `desc_tp_inc_2000` varchar(45) NOT NULL,
  PRIMARY KEY (`id_tp_inc_2000`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `DOM_tp_inc_2000`
--

-- LOCK TABLES `DOM_tp_inc_2000` WRITE;
/*!40000 ALTER TABLE `DOM_tp_inc_2000` DISABLE KEYS */;
INSERT INTO `DOM_tp_inc_2000` VALUES (1,'Segurança da informação'),(2,'Violaçao de dados');
/*!40000 ALTER TABLE `DOM_tp_inc_2000` ENABLE KEYS */;
-- UNLOCK TABLES;

--
-- Table structure for table `DOM_tp_not_4000`
--

DROP TABLE IF EXISTS `DOM_tp_not_4000`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `DOM_tp_not_4000` (
  `id_tp_not_4000` int NOT NULL AUTO_INCREMENT,
  `desc_tp_not_4000` varchar(45) NOT NULL,
  PRIMARY KEY (`id_tp_not_4000`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `DOM_tp_not_4000`
--

-- LOCK TABLES `DOM_tp_not_4000` WRITE;
/*!40000 ALTER TABLE `DOM_tp_not_4000` DISABLE KEYS */;
INSERT INTO `DOM_tp_not_4000` VALUES (1,'Completa'),(2,'Parcial');
/*!40000 ALTER TABLE `DOM_tp_not_4000` ENABLE KEYS */;
-- UNLOCK TABLES;

--
-- Table structure for table `DOM_tp_ocorr_2093`
--

DROP TABLE IF EXISTS `DOM_tp_ocorr_2093`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `DOM_tp_ocorr_2093` (
  `id_tp_ocorr_2093` int NOT NULL AUTO_INCREMENT,
  `desc_tp_ocorr_2093` varchar(45) NOT NULL,
  PRIMARY KEY (`id_tp_ocorr_2093`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `DOM_tp_ocorr_2093`
--

-- LOCK TABLES `DOM_tp_ocorr_2093` WRITE;
/*!40000 ALTER TABLE `DOM_tp_ocorr_2093` DISABLE KEYS */;
INSERT INTO `DOM_tp_ocorr_2093` VALUES (1,'Violação de dados'),(2,'Vazamento de dados'),(3,'Denúncia de fraude'),(4,'Envolvimento em corrupção'),(5,'Descumprimento de contrato'),(6,'Notícia negativa em imprensa');
/*!40000 ALTER TABLE `DOM_tp_ocorr_2093` ENABLE KEYS */;
-- UNLOCK TABLES;

--
-- Table structure for table `DOM_tp_ol_1600`
--

DROP TABLE IF EXISTS `DOM_tp_ol_1600`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `DOM_tp_ol_1600` (
  `id_tp_ol_1600` int NOT NULL AUTO_INCREMENT,
  `desc_tp_ol_1600` varchar(45) NOT NULL,
  PRIMARY KEY (`id_tp_ol_1600`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci COMMENT='Tipo das obrigações legais';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `DOM_tp_ol_1600`
--

-- LOCK TABLES `DOM_tp_ol_1600` WRITE;
/*!40000 ALTER TABLE `DOM_tp_ol_1600` DISABLE KEYS */;
INSERT INTO `DOM_tp_ol_1600` VALUES (1,'Impostos'),(2,'Envios'),(3,'Retenções'),(4,'Pagamentos'),(5,'Emissões'),(6,'DCTF');
/*!40000 ALTER TABLE `DOM_tp_ol_1600` ENABLE KEYS */;
-- UNLOCK TABLES;

--
-- Table structure for table `DOM_tp_prc_2000`
--

DROP TABLE IF EXISTS `DOM_tp_prc_2000`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `DOM_tp_prc_2000` (
  `id_tp_prc_2000` int NOT NULL AUTO_INCREMENT,
  `desc_tp_prc_2000` varchar(45) NOT NULL,
  PRIMARY KEY (`id_tp_prc_2000`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `DOM_tp_prc_2000`
--

-- LOCK TABLES `DOM_tp_prc_2000` WRITE;
/*!40000 ALTER TABLE `DOM_tp_prc_2000` DISABLE KEYS */;
INSERT INTO `DOM_tp_prc_2000` VALUES (1,'LGPD'),(2,'Negócio'),(3,'Consentimento'),(4,'Compartilhamento'),(5,'Gestão medidas administrativas'),(6,'Descartes');
/*!40000 ALTER TABLE `DOM_tp_prc_2000` ENABLE KEYS */;
-- UNLOCK TABLES;

--
-- Table structure for table `DOM_tp_resp_7100`
--

DROP TABLE IF EXISTS `DOM_tp_resp_7100`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `DOM_tp_resp_7100` (
  `id_tp_resp_7100` int NOT NULL AUTO_INCREMENT,
  `desc_tp_resp_7100` varchar(45) NOT NULL,
  PRIMARY KEY (`id_tp_resp_7100`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `DOM_tp_resp_7100`
--

-- LOCK TABLES `DOM_tp_resp_7100` WRITE;
/*!40000 ALTER TABLE `DOM_tp_resp_7100` DISABLE KEYS */;
INSERT INTO `DOM_tp_resp_7100` VALUES (1,'Sim/Não'),(2,'Opções - Resposta Única'),(3,'Texto Livre'),(4,'Opções - Respostas Múltiplas');
/*!40000 ALTER TABLE `DOM_tp_resp_7100` ENABLE KEYS */;
-- UNLOCK TABLES;

--
-- Table structure for table `DOM_tp_terc_2090`
--

DROP TABLE IF EXISTS `DOM_tp_terc_2090`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `DOM_tp_terc_2090` (
  `id_tp_terc_2090` int NOT NULL AUTO_INCREMENT,
  `desc_tp_terc_2090` varchar(45) NOT NULL,
  PRIMARY KEY (`id_tp_terc_2090`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `DOM_tp_terc_2090`
--

-- LOCK TABLES `DOM_tp_terc_2090` WRITE;
/*!40000 ALTER TABLE `DOM_tp_terc_2090` DISABLE KEYS */;
INSERT INTO `DOM_tp_terc_2090` VALUES (1,'Pessoal física'),(2,'Pessoa jurídica');
/*!40000 ALTER TABLE `DOM_tp_terc_2090` ENABLE KEYS */;
-- UNLOCK TABLES;

--
-- Table structure for table `DOM_vlm_reg_fin_2070`
--

DROP TABLE IF EXISTS `DOM_vlm_reg_fin_2070`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `DOM_vlm_reg_fin_2070` (
  `id_vlm_reg_fin_2070` int NOT NULL AUTO_INCREMENT,
  `desc_vlm_reg_fin_2070` varchar(45) NOT NULL,
  PRIMARY KEY (`id_vlm_reg_fin_2070`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `DOM_vlm_reg_fin_2070`
--

-- LOCK TABLES `DOM_vlm_reg_fin_2070` WRITE;
/*!40000 ALTER TABLE `DOM_vlm_reg_fin_2070` DISABLE KEYS */;
INSERT INTO `DOM_vlm_reg_fin_2070` VALUES (1,'Muito alto (10.000+)'),(2,'Alto (1000 - 10000)'),(3,'Médio (500 - 999)'),(4,'Baixo (100 - 499)'),(5,'Muito baixo (1 - 99)');
/*!40000 ALTER TABLE `DOM_vlm_reg_fin_2070` ENABLE KEYS */;
-- UNLOCK TABLES;

--
-- Table structure for table `LGPD_0001_tenant`
--

DROP TABLE IF EXISTS `LGPD_0001_tenant`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `LGPD_0001_tenant` (
  `cnpj_0001` char(20) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `LGPD_0001_tenant`
--

-- LOCK TABLES `LGPD_0001_tenant` WRITE;
/*!40000 ALTER TABLE `LGPD_0001_tenant` DISABLE KEYS */;
INSERT INTO `LGPD_0001_tenant` VALUES ('01199345000189');
/*!40000 ALTER TABLE `LGPD_0001_tenant` ENABLE KEYS */;
-- UNLOCK TABLES;

--
-- Table structure for table `LGPD_0002_conf_smpt`
--

DROP TABLE IF EXISTS `LGPD_0002_conf_smpt`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `LGPD_0002_conf_smpt` (
  `id_controlador_1000` int NOT NULL,
  `url_0002` varchar(200) DEFAULT NULL,
  `mail_smtp_server_0002` varchar(200) DEFAULT NULL,
  `mail_smtp_user_0002` varchar(200) DEFAULT NULL,
  `mail_smtp_pass_0002` varchar(45) DEFAULT NULL,
  `mail_smtp_from_0002` varchar(200) DEFAULT NULL,
  `url_portal_acesso_0002` varchar(200) DEFAULT NULL,
  `url_recover_portal_titular_0002` varchar(200) DEFAULT NULL,
  `url_register_portal_titular_0002` varchar(200) DEFAULT NULL,
  `porta_smtp` int DEFAULT NULL,
  PRIMARY KEY (`id_controlador_1000`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `LGPD_0002_conf_smpt`
--

-- LOCK TABLES `LGPD_0002_conf_smpt` WRITE;
/*!40000 ALTER TABLE `LGPD_0002_conf_smpt` DISABLE KEYS */;
/*!40000 ALTER TABLE `LGPD_0002_conf_smpt` ENABLE KEYS */;
-- UNLOCK TABLES;

--
-- Table structure for table `LGPD_0100_diagnostico`
--

DROP TABLE IF EXISTS `LGPD_0100_diagnostico`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `LGPD_0100_diagnostico` (
  `dt_inicio_0100` date DEFAULT NULL,
  `dt_fim_0100` date DEFAULT NULL,
  `ativa_0100` tinyint(1) DEFAULT NULL,
  `resp_0100` int DEFAULT NULL,
  `id_0100` int NOT NULL AUTO_INCREMENT,
  `id_controlador_1000` int DEFAULT NULL,
  PRIMARY KEY (`id_0100`),
  KEY `fki_p` (`id_controlador_1000`),
  CONSTRAINT `fk_id_controlador_1000_3` FOREIGN KEY (`id_controlador_1000`) REFERENCES `LGPD_1000_controlador` (`id_controlador_1000`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `LGPD_0100_diagnostico`
--

-- LOCK TABLES `LGPD_0100_diagnostico` WRITE;
/*!40000 ALTER TABLE `LGPD_0100_diagnostico` DISABLE KEYS */;
/*!40000 ALTER TABLE `LGPD_0100_diagnostico` ENABLE KEYS */;
-- UNLOCK TABLES;

--
-- Table structure for table `LGPD_0200_implement`
--

DROP TABLE IF EXISTS `LGPD_0200_implement`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `LGPD_0200_implement` (
  `dt_inicio_0200` date DEFAULT NULL,
  `dt_fim_0200` date DEFAULT NULL,
  `ativa_0200` tinyint(1) DEFAULT NULL,
  `resp_0200` int DEFAULT NULL,
  `id_0200` int NOT NULL AUTO_INCREMENT,
  `id_controlador_1000` int DEFAULT NULL,
  PRIMARY KEY (`id_0200`),
  KEY `fk_id_controlador_1000_4` (`id_controlador_1000`),
  CONSTRAINT `fk_id_controlador_1000_4` FOREIGN KEY (`id_controlador_1000`) REFERENCES `LGPD_1000_controlador` (`id_controlador_1000`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `LGPD_0200_implement`
--

-- LOCK TABLES `LGPD_0200_implement` WRITE;
/*!40000 ALTER TABLE `LGPD_0200_implement` DISABLE KEYS */;
/*!40000 ALTER TABLE `LGPD_0200_implement` ENABLE KEYS */;
-- UNLOCK TABLES;

--
-- Table structure for table `LGPD_0300_operacao`
--

DROP TABLE IF EXISTS `LGPD_0300_operacao`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `LGPD_0300_operacao` (
  `dt_inicio_0300` date DEFAULT NULL,
  `dt_fim_0300` date DEFAULT NULL,
  `ativa_0300` tinyint(1) DEFAULT NULL,
  `resp_0300` int DEFAULT NULL,
  `id_0300` int NOT NULL AUTO_INCREMENT,
  `id_controlador_1000` int DEFAULT NULL,
  PRIMARY KEY (`id_0300`),
  KEY `fki_g` (`id_controlador_1000`),
  CONSTRAINT `fk_id_controlador_1000_5` FOREIGN KEY (`id_controlador_1000`) REFERENCES `LGPD_1000_controlador` (`id_controlador_1000`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `LGPD_0300_operacao`
--

-- LOCK TABLES `LGPD_0300_operacao` WRITE;
/*!40000 ALTER TABLE `LGPD_0300_operacao` DISABLE KEYS */;
/*!40000 ALTER TABLE `LGPD_0300_operacao` ENABLE KEYS */;
-- UNLOCK TABLES;

--
-- Table structure for table `LGPD_0400_etapas`
--

DROP TABLE IF EXISTS `LGPD_0400_etapas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `LGPD_0400_etapas` (
  `id_etapa_4000` int NOT NULL AUTO_INCREMENT,
  `dt_inicio_0400` date DEFAULT NULL,
  `dt_fim_0400` date DEFAULT NULL,
  `id_status_etapa_0400` int DEFAULT NULL,
  `obs_0400` text,
  `titulo_0400` text NOT NULL,
  `id_controlador_1000` int NOT NULL,
  `ordem_exec_0400` int NOT NULL COMMENT 'Ordem de execução das etapas conforme framework omnisblue',
  PRIMARY KEY (`id_etapa_4000`),
  KEY `fk_status_etapa_0400` (`id_status_etapa_0400`),
  KEY `fk_id_controlador_1000_6` (`id_controlador_1000`),
  CONSTRAINT `fk_id_controlador_1000_6` FOREIGN KEY (`id_controlador_1000`) REFERENCES `LGPD_1000_controlador` (`id_controlador_1000`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `LGPD_0400_etapas`
--

-- LOCK TABLES `LGPD_0400_etapas` WRITE;
/*!40000 ALTER TABLE `LGPD_0400_etapas` DISABLE KEYS */;
/*!40000 ALTER TABLE `LGPD_0400_etapas` ENABLE KEYS */;
-- UNLOCK TABLES;

--
-- Table structure for table `LGPD_1000_controlador`
--

DROP TABLE IF EXISTS `LGPD_1000_controlador`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `LGPD_1000_controlador` (
  `nome_1000` char(250) NOT NULL,
  `CEP_1000` text NOT NULL,
  `web_site_1000` char(250) DEFAULT NULL,
  `logo_1000` longblob,
  `telefone_1000` char(14) DEFAULT NULL,
  `cnpj_1000` char(14) NOT NULL,
  `id_controlador_1000` int NOT NULL AUTO_INCREMENT,
  `id_tp_atua_contr_1000` int NOT NULL,
  `id_area_atua_contr_1000` int NOT NULL,
  `dpo_1000` int DEFAULT NULL,
  `atv_1000` tinyint(1) DEFAULT NULL,
  `logradouro_1000` varchar(100) DEFAULT NULL,
  `bairro_1000` varchar(60) DEFAULT NULL,
  `uf_1000` varchar(2) DEFAULT NULL,
  `cidade_1000` varchar(100) DEFAULT NULL,
  `número_logr_1000` int DEFAULT NULL,
  `compl_logr_1000` varchar(100) DEFAULT NULL,
  `tipo_logr_1000` varchar(10) DEFAULT NULL,
  `tipo_dpo_1000` varchar(45) DEFAULT NULL,
  `dpo_externo_2090` int DEFAULT NULL,
  `resp_dpo_ext_1000` varchar(250) DEFAULT NULL,
  `email_resp_dpo_ext_1000` varchar(250) DEFAULT NULL,
  `tel_resp_dpo_ext_1000` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`id_controlador_1000`),
  KEY `fk_tp_atua_contr_1000` (`id_tp_atua_contr_1000`),
  KEY `fk_area_atua_contr_1000` (`id_area_atua_contr_1000`),
  CONSTRAINT `fk_area_atua_contr_1000` FOREIGN KEY (`id_area_atua_contr_1000`) REFERENCES `DOM_area_atua_contr_1000` (`id_area_atua_contr_1000`),
  CONSTRAINT `fk_tp_atua_contr_1000` FOREIGN KEY (`id_tp_atua_contr_1000`) REFERENCES `DOM_tp_atua_contr_1000` (`id_tp_atua_contr_1000`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `LGPD_1000_controlador`
--

-- LOCK TABLES `LGPD_1000_controlador` WRITE;
/*!40000 ALTER TABLE `LGPD_1000_controlador` DISABLE KEYS */;
INSERT INTO `LGPD_1000_controlador` VALUES ('Empresa modelo','06850040','www.google.com',_binary '�\��\�\0JFIF\0\0\0\0\0\0�\�@ICC_PROFILE\0\0\00ADBE\0\0mntrRGB XYZ \�\0\0\0\03\0;acspAPPL\0\0\0\0none\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0�\�\0\0\0\0\0\�-ADBE\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\ncprt\0\0\0�\0\0\02desc\0\00\0\0\0kwtpt\0\0�\0\0\0bkpt\0\0�\0\0\0rTRC\0\0\�\0\0\0gTRC\0\0\�\0\0\0bTRC\0\0\�\0\0\0rXYZ\0\0�\0\0\0gXYZ\0\0\0\0\0bXYZ\0\0\0\0\0text\0\0\0\0Copyright 2000 Adobe Systems Incorporated\0\0\0desc\0\0\0\0\0\0\0Adobe RGB (1998)\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0XYZ \0\0\0\0\0\0�Q\0\0\0\0\�XYZ \0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0curv\0\0\0\0\0\0\03\0\0curv\0\0\0\0\0\0\03\0\0curv\0\0\0\0\0\0\03\0\0XYZ \0\0\0\0\0\0�\0\0O�\0\0�XYZ \0\0\0\0\0\04�\0\0�,\0\0�XYZ \0\0\0\0\0\0&1\0\0/\0\0���\�\0C\0\n\n\n		\n\Z%\Z# , #&\')*)-0-(0%()(�\�\0C\n\n\n\n(\Z\Z((((((((((((((((((((((((((((((((((((((((((((((((((�\�\0�\"\0�\�\0\0\0\0\0\0\0\0\0\0\0\0\0\0�\�\0\0\0\0\0\0\0\0\0\0\0\0\0\0�\�\0\0\0\0�湍\"P\'Ƹ�-�/-\�\�D^�\Z��O�/m\��*i�\��(�:���w�z8\�\��7�y\�Z\�)7k�#%\"���9�M{c�\"�LA�)\0�24䆧 jr� jp\0��V\��\�Nrɭ[2\�4�\��!V\�L�\�\rnMXS@8\0	�\�[\�/\">�\�Q�����;�\�l�^[�a��\�2�\\\�.�l�U\�F\�3ۺ��\�Y�=@�\�oA~Zy\�~�\�K͗�S\�y{[���H\�I4��	��R$�\�88^�徧\�<ȥ\�\�\�\�H\��/�\�[<Ɨ���\�\�{�j�4:\�\�\�M���\�\�x\�\�zo�\�֓�\"Z��\0���L3�s3܀@)F�\Z�nqQC	\�\Z��\�\�\rN\0��\rHjr� iD��YM[���Ȩ\�4)\�|�\�v\�\��x�s\�\�\�*=&O1U�\�\�Mi�ͣ2�އ\�b�\0L�0��*��s�\��{�\Z�\�\�ǜ<76^Q*~\�U��\�\�oF�9`e\�w�\��\Z�%\�;�FL\�N�\�H5�Z\�\�5\�>[\�~[\�\�\n<\�Nk\�\�\n���mq\�M��\�\�䦰\�\�\�uby�=5a\\\�mUN��A��=)<\�\�<\��5����\0D\Zsg+#��\�(p\�\�\��\�\�\�\� \�-}hy�L: )�P66v�JP���F��iN\�Hj(��9��\��TdƸ\"���U���\�i�7s��\'\�\���ϐ�N\�<\�l\�\Zc\����RO5\�\�\�j_iQUQ�\��US\���\�;Zʫ&pqk�C\�[\�M7Z�>\�ʵ*�^;���\�W�-r\�X���AA 1\�\��\��0��\0-\�\�zi\�ꑏbyF\�ұ�gg�\�k�\�\�vsQk��c�\�\�ѩ�\�m�\�\�f���\�\'�/Z�\�\�>�������9�\"Wr�Y��#:H�i��P�$\�j\�z+\�A�eE\�K\�\n��f֍p\�\�f���:&v�+�L\�F%Ccfh���`�7�s�\�u�)gn�F�\�\�����I\�\�\�=夭\�\�\�\�K�e�e�?K\�\�\�\�\���qQ\���\04\�\���$񖷸ӧ\�\�Ť�zRHH:#�*H��\�$k\�Y\�[\�^U\�\�\"c��eim���\0\�\Z��,|\�>�K~kj��^/�\�ifN��ŀ\�f��܁\�d�\��\�\�(\�1 \�g�.\ZB\�e�\�c�Saa�5 �\nD�\�X\�C\�\Z�I���.�p\Z*\��=g�oD�,��˘�\�:�\�i\�\��YZ\�\�RX<\Zk\0�\��[\�\�z7\���6\�5\�v�\��\�\�\��S\�}Sʬ+3\�2W>\�E\"�\�<nˣ����\Z�\0����\�-2 �\"\0�תyW�yWO*EsuH\�5�${�=\�\�C�\�\�{8)��拗M[ņ\�\n;\�^C\��e\��\�% {\�\�\�xg�\�3T��\�\���<�e�5-%\rrp6~Wy�@�BG�D�\�0u\\vR2πq\"�i%� c��xQ\�V\�\�Y\�\�ql\�uhrM��08&ׇa\�\r%��6���iT\�{<�V~�\�5>�Ɇ\�f��>�\�\�u��IL󍕇\rN!8qv59QA<]Qҁ\�(�K��E\�i�\�\�\����6X\�\�Y\�m.��8[\�Y�b\��+����5�e׮�[�\�E\�\'�-���\�KLO\0�h_�st_>u�	茼�l���\��\�\�\ZyN7�}�\�<p@�م\�j\�&jӮ�\\j��l#t\�8\�\�4�\\�B.�\�\�.M�R~~���\��\ri\�\n��]Fn�0\�\Z���Sk\�\�xCICbr�\�\rN\0\�\�\0=�@\�\�\rN*�4�����$SB\�|nM\�	�t$O\rA!kYԹ\�\�SX\�S>�4\�\'MՒw8���y����\�H�Ϥ\r�{���u�u��g�\0\�ɣ\�B\�㎠\�<�\�i\�*:awȦft\�\Z\�\�w�{�Z�O)j	�jp���O=�կ���z�3�\�Q\�\�R�Z��@຾\�\�\��ni\�[ES{SD\�)ϧ\�\��y\�֛�5\�>�.\�\�a\�\�t� �\�\r�\�\�o\�5��j\�T3LjmNChx\0\��\rN@\�䆢�\�O5�Ʉ\�%#^\�\�	$\�Rd��6�	�!�$ \�\����)��ǰr&�\�J\'��RO{�ƹ�k�BmFSSxѶ��\�혊\�\��\�%�x\�\�\�z���\�R\Z�n=��\�ȯ+*`\�\�-\\\�{,#_.3×de\�60����Ŷ_S�Cڴ$/D�͍\��,\�f����-\"\��\�e�I\�����@\��Њ�gf\�\�\�\�>�<��w\�b�\��qu����2n��C��ͧ,7br\�4\�c\�B@\�#��99�&\����=pI\�_ͤ��|{���\�.5��\�\r�\�K�q萪��iy5�\�*��܃�=��N\0%\�C�eL(�O�\�\�Y�\0W֑\�D��Pm1�5�1�=^cp\�\�gu�xe\�|���\Z����\�S\�Q�z�\�\�\�\�\�\�\�1�\��N����N\'��\�ӟZ�$Lߏ8j�E�\�\Z~Z��\\w,\�C��<�z97^�y�{�UX�4�ʨ�\�8�TSQ�۰\��i�9t�\�؊\�H\�\�[� �H\�9�R�\�Q�\�RAæVHƁD`�H\�\�\�\"��޻li��M�� ���\�z3�\��F�\�C�\�jE��S���h\�\�3:�\�5\�U��hH\�\��YcQOPQI�e�\�J\�\�?o\r�D�;��;�\�:��\�	\�\�Px\�l�w�w9�\�is$�ҴH>�滽9\��[\Z��sҹ�v>�?@(�l\"\�s�\�r\�Οo4\�\�Cϯ��V\�Y�-�\�v_F\�y!k�J�f\�f�M\�Ɲ\�rVa\�\�Vw3�]�zhjg�#Iй��\�^�\�\���],jC�{\�멷ݏ;\�\�\�E\�+�Z\��@\�G/�\�1\���\�\�!.H(��\�:+\n&�\�\�2��KC�yQ5¬�%d�A�\�\�Vx\�KѮD��\�\�����\��tq\�\\����\�\���CY�f�\'\�\�I-.H\�b�\�\�f\�7�\�	��a��_;ꬤ�\�E�M��H\�\�\���\�J\\\�FRJ4x{zl�\�ro?OJr�Ȧ2ܞ\�JH\�]3W��\�t�\�[|��\�8��pݨ��N~�2��=0�R\�+\"pp�C\��C\��y�G��VH\�@��\�:ޢ\�L�\�=gʴ\�9�ݢʿ��\���׼�~X�#9�Rb,(�45}??EaA\"\�z�4ܺ�\0?~�KP:H�i��v�g�MOW �\�\�\�\�X\�}\�\�\�\'\�%ewg?A��rJ��?!jQ����ͶcW�&\"�:0�0��\�>P}\�y\�N\�\�az5\�o�\�s\�,���i_����c�͘\�=t9��\�5�\�\�+!��yvk���\�j�;yK��Eg�A��1ɸ$Ӥ�FF\�^�\�ޣ\��<ģ\�\�+$e Q@p,7}R\�Ϫ�\�眃T2\�)\�q(m|�Ҳ\�a�\\\\��\���S\�\�\�3���\�Ɓ�Gz���\0I�8pzK��!\�d5\�,�I\�p51\�\�_.�K��\�;\n��\Z盖ڶ�\�o�Q�p�\�\�\�g�*N\�\�6��qJ	\Z4���\��\rᄾ�\�\\�\�V\�]\'\�ϠH	v�I�&�+Ο��FY��ؿ\Z�m)5���\�b\�l#ʹ�H�p�H�Wqb<rxâ4Pp�\�φ�\�r\nA��)\�1�\�^_\��]\�\��\�\�\�;\�I\"��kK�\�zWO�\���<�8*\�zy���\�g\\�kG�]�usu*x-�.k�\�a̪㑕��\�6��\�\��\�(��\rz\�\"���\�jP�\�\�\�XTu����h�\"�he�\"��-�\�v��D\�8\"l\�C���j-3�,\�H\0hSR�8\\\�j\�\�9\�\�=*I�$j��T�\�\�\�Is�:0\�%n�n[:b١�n\�4�V�\�ƒ4�\��!ҋxӬ��\�KO@�RY\�\��c��\��\�\�\�-$\�\\�\�^�\�\���]Q�T�\�H�,\�z?��WO��s�\�\�K_U��\�2�\�벳x�ޣ5>��3:M\�\�\�䕭d\�\�n,\'U\�\"\�\���\�\\] �6F\�\�u\�=l\�NU�\\�\�Q�\�V\�sK<�\�\�\��Z�\�\�u\�\�C\�5\�Pz�B;r\�v\�y�\�}ܝ��\�\�3��\�u:�\�\����\�\�\�[�\�\�<}u�v�L\�Os+(#Ӧ��֐\�\r�f0\�\�cμ5�~�m��J\�v��ݭg;�H��	s���ds\�\�\"�M#\"{\\ר�w��G2p<�31줈 �\"\��O��OW�١�s�\�=C��\n���WU�W����~�)M\�gԠ	z�\�I�\�\�g8z��RΣ�� \�!�9=vC^�ɮ\�B��\�\�\�}\�\�\�0����K����5�(�\�{\�g�\r��`\�&\�I��#&� �k�8,)X\�i��8:;�rt�|�6�g�\�\�\�u\\�\�]3\�T\���y�y�Xj\�Ŝ�U\�$X�9�&�@Ah$��95\�@:4yN��h�h\�؊��\�胟P\�\�I��\�p�C\��C\��y�G��h\�e$�@(����5���9�V�sכ\��k���\�\�f�\�w�o\�$����\�\�)�\�B\�>\�\�4�;�-X>��6f�T�\�(�\�rϢX�ye����\����	[S�\�\�tZg�\�\�;U:.W�M-��){�\�\�\\wsS{ziG��Ɗ=\�;�Z\��\�Z	#�O?A8��>\�b6C\�{\�a�-�ÆnF(\�b�6�\� \�7$CV\�\�\r3sn\rhH^2��j\�ԋW�t\�MZ�%[\�s\�K� �\�b��sשy��G3�O?L\�s)҂Z\�jf\�\��sZ\Z��5.JB��H\�\�\���� A�-,��\�r϶F\�De\�y�PX�\ZVrT\�\�l\�d5\�.�:;l\��3\���V\��О���G���,\�\"�\�\�Ce�,弪s4tv4�؟L��ns���H����\�Y[\'\�!\�k�@�-X��A\�7��4/��f�bDi�Xr͸ġm�$�j�mf\�b�m)\�cl�1Ξ�L\�]u�\�\�R\�\�|8\��B\�Hc3\���tQ�/L���Yz���2ܺ\�T\�\�^w�\�]y�\�\��7oUDo@�]����\Z��M\�\�,k��ԍK2ξ\�*��\�f���7�<�\�\Z\�@�2!\�a\�\�\�y���m��d\�KU�㾈B~;r\r<��\�\�\��-\�Wj\�ۂVY\�\�m9\�\�\�Q\�[q\�p%?��&\�\�\�\�瞓\�c-�t�+vx+bx�\��L\�\����ҵ_-\�\��\�\�1O\�$�n\�>�Ik\�Y�A�Z��ȷ`�\02\�\�\�U\�h�VZ\�A<8h\�!c����Q�\�Q���K�\�֝\\WUi�ڦ\���) o3��NtQc�\Z�e	�\�M�mNʏ��8vY+�\�\��Κ\�H���[�\�ooV}�n}\rD�NL\r���\"9\��X�Ɍ�~\�\���0\�=}=�\�2�ԝ���)3{Lm;��<�M9<Nbxl8h\�\�kr���=�\�ֲ\�\�\�7�W�(\�\�ܘ\�l\rg�~��ͪ$�d�bن�\�\�ᙼjxY6\����\r؀\�zz\�&d��Qj@�j\�FX�@A\'_Dh\�&A\r:H\�c\�����OQ^^C\���=-y�K^h\���\�\��9r=y\�B^zC\�ن��\����c���!�!�\�r��\�ɞ\�0�\"i�\�I Ǘ�^�\���â�\0\�\�;d��\�{m(\�\�h\�\�\\D�\�\�\�r�E�Twp��4\�֕\�>��\���v}|�7��\�H\��{Ez\�i�\����\�R��\�Q��<��6#�\�\�p�Oˮ��\�5.^�g\�\��E\'5\�\0R\0�@\�@\�)\�{*����\�N%�\r	c\�(!:H䡅���jV=��q�8\"{P�\�̅�ԥ�>�5��\�4J����3!\�\���S�go!k������\�\�5\�v�{s\����\�\��7eaBԻ�,\�X\�\�%���{\\*U�X\�c˗iZ~���\�TΖ\�\�\�揦6\�\\י\�\�}�\�\�8�V9\�n\�\�=�\�\�\Z\�j7\�\��]\\:����,\�l�DRجs�8�͠ƹ��p�k,�iFz��-\\�)5l�;\�w)GJ\�L\�w,�Hy\�\']Ri<F\�F�\�t\�4KC �GQ d߭��ZۼXc�{X\�?Dk<��\n���\�\0�\�)o;�TK-\'Q ��\r=F�%��͞+ѫ�\��\�\�;d�(1�d� ͠,mPb�\�#ώ\�E\�\�\�ItHT�YEK�\�Eӛ��\�X\�n�\�߼\�l��4�T�ѹ�h�2U\����\�t*ל�[\�\�aW��:A\�\�\0�w\���\�ۆA���س$\�\�\�\���x�[�\�\�P\�AE�C4Y\�!ɠP�\��1���gm|���r̤���\ZH���m	Ȩ\�jFM%\�zk��k^�H����gM\�[L�\\\�*\�\�`�X;�S1\�7\�%�\\��%\0�sR�)5�\�͹#\Z͘Q�[B<J\� \���\�\��mc)d`s�˴~z$�]x�R\�k\������I��e�\�M�\�iX\�e��qat\�{�n\�\�:gd�\�\�q\�r6Y\�\�7��e��Գ+E\'/Neڮ�95��\�7E��n	o�0gr\�\�I��3=v�\�_;՞�\�<9�\�SH�\�\�8=K˽C˺yuϤk\�G����?֝yD��CȬ�\�\r�-Ğ}&vM0\�ڕX\�w�����[\�\��?�R���#��a��\�4�O=pM\�;\�\�,萘\�\��	n\\���Ͷ#nc�@�\"\�\�7Z��5�2�PP\�laf\�պs��&�] ��X\�j7����\�\�kE�J\�^�\�\'\�sz\�X՘�N\��xzA�iY\�C\�\�\�<�CZ(�:�\�\�7Rrio\�	�0xY�#1-\�#��H�Z�B���WK�yyzJjM�I4摸s\�s�\�ޣ\��<�/H�Gې�L\nHD��5e�i\�\�\�KRX\�>?\�>Lu�u\�[�\��\�\"��Y(ǲ�\rNE�]tGn\�$\Z�y: �*\�l\�\r+�&��?-\�T/�\�o�\�bKB\�Œ��N.�=ܒJO\�%�	E�[�\����)\�9�۲jXy�p�\��\�vg��v\�ft����7������\�Z�\�=\�x3<�\��kIy�z:[��I\�̧\�7��~>\�X\�4PHp\0X�\�=�9\�V�\rQw[viy�.b(��\�Ѩ\�\"��E\Z	LOi:2�\��\�\�<����H\�J�\�\�\�c�5V��0�I\�Jf��eKZHh�wVV|�,\�#]\nC��\�9�Ԟ�^)�\�曗.�����ԹH\��V�+_oLS}ϑ;\�Do�cϔI蠤C�\�\�ks\��ZP�Pˣp\0n\0ښ���3�\�\�GGY\�^�\�;Br:�\�J\�){\�QS5�\�E�\�+�jب\�͜)\�\'�\�\�\�\�\���\�\�;\�z��R\�Ǘ驹����9��s�[O5�������\��� ����i�9��\�ޣ\�\���\��i�f�N[�\�[\�-\�\�3�~]y<k�ֳ��\"M\�\�\�\��aZ^�\��\�\�\�ī\�쒫�\�n�\�K��\Z���\\xu_�*��sKP3(5����\�\�NU۳�\r~[�f\�Qe5�#H\n\0���R�\��\n�i$k24\�mi�\��vU�\�yzDwu^\�}����HI���?>\�\��WOv�\�Ce.z1�P�K�\�@���\�r\�\�\�\�5h�\�4��\'�H\�\�\�@��\��\�\�\n \�\�5\�p�G˽C˺�v~�\����)�e\\��6	W4��p�\�uq\�\�\�\'\�HI9�c�\�\�W\�/��fJ��/����y�#�8\�[\�t�D��\r{B�Ͼ�z���<HZ�\�(���6u\�r��f�\Z�\�?2E�Y�\ZV\�\�98s\���H\�\�4ً\� 3\�ޛ\�;\�y�S\�ki\�k�5�e\�z/�st$Z��I�K\�\��\�̭�UF\rz$��\��@k\�:6\�\�\�\�\���.P\�ρ��\�ۤ\\�sZ pH�\�5\��.�0\�\�\��?��.��\"�;\r_4�噁WZឿ]>{\�s�R�e^�\��W��G?<\�\��n\�}/?�k}�ls\�\nn�~y\�y��\�\�7&�x\0�ʗ=|���S\\�)!  pj	Z\0�&�  %�0��C�\0z�5���H)�\��_צF\�W�\�\�\��n��>�� o$�x\�\�[\�=��l��\"j듁M\�Q\r\'�5Ȼ�*j���Rݳ>n;*hפ��3\rod�\'!\�%19���\�<�\�<���\�z3�\�\�pw�/��Ds�>�s.\�R\�=�2\�2[\��+\r����\�0\n�\�\\\�\\\��\�?7A\�\�\�M@�\0;K�p�\�\�\�:~J;��V�\�e6Pkl�\Z�ZD,\�\�g�\�\�O��\\=\�<!�Y`\Z���\�@�84\�\�\0\n		�H��*m��\�Ϭ�tsyg�w\��\�F��=x�\�8��c\�\�\\S\�A\�JWE��4���.\�\�\�쳽\�^y\�\�\�k=H\�\�HI $k�g�yw��wO-�]��i^�O���w\�c���K\��.5{ή����\�z�0�\�1�of�\��+�k�\�sJPH@|_\�<Z:柟��\�Kc��PSP9\0M KHI]9�\�Hs 4\�P!\�p\�%�nM@B%�duX9�WW58�\�\�n1\�\�ijp��\���/��O\�aǦS�t\�\��Y*��\�p*o,�mfw��*\��bj���h�\�к��Mna\�(\�D3\�*ώ� �A&�@�@�@��$�I	�\nA\�^�W.\�\�\�\�E*\�E )$a�ϻӊW��@�H�ƒ�\�R�J��H��B�d��Y\�ǯ6�\�t���R\0�M$�$�CI A!$�\�rB�\�J�\�IkJ4���\�N��\\5�+\�bRu\�\"\\ݜU\�Eq�$=\"[f\�\�Z\��jI$$	$	$	$	$	$	$	$	$	$	$�\�\04\0\0\0\0\0 !152A\"034%B#E$6F@C�\�\0\0W9cQ�8��%�1ן�\�\�S\\�DY\�\��Ô��)T\� \�\�I��$\�m\�\�F6��,���м����\�\�.�\0y�/�X����ƪ�\�\�R\\c\n�LS���O\�nd�\�u�h	��\�=Y��}D}#Hd��\�92\�\�y\�0��(�9]~#�\"�\�8�fFqg���(!\npdW\�_9cP�8��%ސ�`��k\�\�*Ӗ\�c���I$Im\�\�Tfx\�0B��\�V[�\�ة6L\��E�eL[\n�����I\�\�{\�Ru��֥\r\�3���\�E\�.\�ħ!���~�P��9N����N)Z��%��>n�_1S�7*=\��f8�� �JmI�+JCQڐ�(̨C�*#�0�Ǐ	�0�;\ni\�gL*㺕\Z\\\�\�,>j\'�>�E\"94��>��F\�dRMj[ʇQV�a5���(\�!.�Ԩ\��\�åL��f�/Z\�kl\����\�(g���m�t��Q���\�O�d��S\�\\yU��\�G�Կ�G`�r\r\�f�7\��&�cSI|m\�ׂ\�0\�A)R\�\�#,3������W:M�̕1�e�)�ĩ��hؖ�\�g#�JJ�GPqd���\�1!\�;��\��\�$e2\�,>j\'�>�C�����XF��S\��]F)�#D[rr���=k�N�SM�\"�)\rL�����F\��\���\���\�.C\�!�e0I<ܧ\�d��4dNW\�V�\��/\�!&�9\nB��Q!\�\�\��\� ��J\Z�k\�OK|*�a\��\�<�\�}\0Ф\���o8k��\�(%jH�+��\'�L	�w��\�S��*�)\�m�\�Q�\�dҾr\�\�\�qG��\�\�C-:S$�|թ�\�e�$\�d\�\�\�d5UtF�\�\�UGPym5W���7�I�^���=M\�\�4?+\�&^\�_����\\g\�	\�\�.:�X��e1c\��O���|S\�%�BTGw\��/\�S�\0z�Uz$ک7.��s/\�K\�$7Q��\�rJB+\�`�p\\�>I�\�]9F���|�2\�GR\�\�5$����)N��5Ņ����,>j>\'{��Z~\�)�I7\�9!܎Q�=8��S�ܤ\�r�M)\�>\�u��\�Fu�ۛM�)څ#WՈ\�\��s\n���/o/��AT��Q0��Ԅ\�\�(�\�ZZ��LX\�0��>a\�\\ԅ�\�̆ca�\�2�2\�/w\'��=-���\�(T�\�j�\�H\\(�$�K�\�?v�\�;T���NB�7!�,��� \�z\\(�E�FS����e9O�\�iJ�l5�EB6�D8N\�\'\�H`�\�:Ju�)��MZ*\���8\�8\ZS\�\�R\r3\�$9\����1\�taa`������e:�Lٹ�\�<�T2��,�\0\�+�\�o�}�Lr�+kRj�­��<\�d9Zq\�uJR�����#�S\�G��(�~_�t@�N\'ӂ=؞	y\�T\�n\�k�P\'i�\nn������\�P]*jB\�\�32�\\} �\�\�c)\��w}\�Uf�&� z�&\�(�&\�֟nD\�n�$\�nc�͸\�8\�}E|P�D\�_S�\��J�\�R[\�U�\0ߠ��%:�\�ϽOqS]��NU\"Us���9\�KF˼�s�5�=\�}n.=\�%�n\�xv�N.�?ă�\�g\�Z6\�֎\�\�{!̔\�J��CMf\n�\�̖\�\�>~:�B��`�L�f!|)�I\�T�\�\r%rM�uA�\">�\�x)��:���\�\r\�@\�XX\�R\�8T���\�Q쯘]&rC�\�df1��\�}\"\��\�1cƅ1**�%C��$<\�1)\�\n[��X\�\�3�\�a&\\�\�N�Җ�/��Z�\0\�\��\0N��*��e\�|�\�ΣViD�\�VW4WT\�����+������[�pC\�2��?�JvQ�i\�DcL̇���Ɲ\"��\0�4��\�S\�R\�\�1\�U2Vh\�h��.�����\�(>S\�^L\���;\nl$8��\�KQ\\k|�\�\�:�\�nc\�\�|��H}%If��U�\0�S\�1�\�\�\��\�ή��\�R^\n�\�X_���JH].Z\�<�i2���h����!\�\\�7�\�M:bi\�0\�?*%�=\���\��\�+�\�\�\�|N\r����\"\�*4	o�Z	8�큇ME%�n��S#*Gԩ��	��䃗�}�ze%qB��DDg�\�4\ZA\�\��\06\n��o���\��\��\��gw��r\"}\��Zf\�q�6�S\�\�>�\�RMd�\"�5!�\��*�zK\�n�:Bd\�\�\�e$.�%L:�c N,��M\�\�|\��W+��\�G\�\�q�\�����\�(�6N6G3\�J!@nDv!\�S\�)h}s�\�9�;Є��\�?{�\�t�XP�����\�W+\\\Z�W�\09\�\�p]�X\���t�@�\�*��\�[\�\�|��\�]����Dԅ��4�}܇\�w\��.\�yԄT% \"�)!�k�(n�Jk�\�p\�CA�\�\� �L��A��l�Bǂ}\�\�\�\�\�r�5�~\�\�\��0\�?O1�	=\�4\�\�:l֗:�\�s\�R8	u�Qw\�c��K\�\�u��yOQy.��}��u�\�؂l�[��U��\�(��u�Ɛ\��\r�p).����6\�UZB�SR�%$��<�ȟ\'\�d<���\�=\�2}��\�w\��.���A2�HENRB+O�MpZ*Ƣ�\�\��p*9��\0Dr�\�\�\�A��q m8B\���~_��$�>�����R_\�%�uI�;6l�Rߧ\�ΌC���\�[)\�|��_t��a\�\�k/�\�?�\\n�;�\\U��\�p�v\n�2\r:\�T��\�V�@���I���\rcSGpp\�\r��\�:L+\�\�\�\�\�\�K�!)�?2\�zsH�\�!�\�]�<K�9��uć[�\�M\� \�\�c)�.Vkd�m�U������zƎ��t�JC`¨TB��H*�,�\�\�\�\���)�\�Wu�\�U(\�Tg\�\�H�D��\�\��\0VS%aB�\�\�/$\n\�X�($\�\�\�f$\'�^\�U�\�¬*�\0�\�0w\���M�v\�Q�^HENbCu���_�\�1�\�\�j+�\�t91L�X��ի4��\'\����\'\�\�\�}\�\�c1�\�3�\�\�*���/\�\�\�Dc\"G6ݕ�W�\0)4��gJ ����֥My�P*�@�P\�7\nb\�jK�IJX:L�\�Y0~�0�O�D�AT��3�%)6֐d�\�P��nu�P\�JM��(>\�{��\0=�}�V�\�c\"*��\�\�p�������Wh�ݒ���\r\�5!t\�c�u*C$f�k\ZN�&Y{�=�\�T7\�Q\�c\��c̨F8���\�;\\;�\�{m-�t(\�\�\�\�dQ�$.�-!Q\�HRTG�w\�?�\�~{r�\�3;\�0j3/���_\�\�7�\�{�[/\��3���Ri�\�IbjM5\�d\���P�z�`�\�I�Tt9Wy��=nW3\'�+I#�\0?�<\�K�\�c\�v���\0狰0dW\�\�Mm�\\\\x�\�\�Q�\"�\���ԩ�ȇ\�\�:�#���\�\�7�\�^9D�`I�\�ԸLki\�\�+\nZǩ�M�8���r\n�1�\�\�	���@�U�J\Z�S��Kpm�TCh¨*\n�H �T��A��l8@\�d\�ܱ,S\�׼�⢱|��\��\�:���\\���}H���f��2(�e+� �\�<\�+\�/�\�c��\�\�\�X�+M;�\�i\�Y���\rq\�v4��J�\�j\�V�\"\�d��\�\�%ح�\�;��M\��K��ٿO���K\�F�\�\�B�Qڳ�ȾDt4<\�͒����	�\� �\�V�1�BX\�Ӝ\Zj{�\�qTF@UaT�\�:AD|��\��\��r��O;^�\�\�����V\�+\���~��r�� \�R_��Or?�FYTer\�\�\��U�\�\Z&\�!%� ��΋\�P4�\�Jl��q�8|)\�r\��d$*Q\\�`\�\�\���Y9rq7q�:[��~�\0�|�\�a\�\Z\�mU\Z{�e!\�L�t\"�\n�j\�PZ�/��ܗ�)D!\�ϒ����	�:\n�@��\�k!,\�pT\�G���0X��\r\�\rM�	�tW�\�$�M6JT�RH\�3\�8n�\�c2�\�l:[�c�~�;ߨ\�b��r���Af�沯r\�\�\�\�RH�\�o\�*>fPΠk1�fH�--�(茨�\Zi!h�%J(<w�\�\�By�H�\'%T�\�\�.C\�S�\0{ԾO\�\�\�|Ʈ�\�E_h\��CWJX\�Hpm\�Ճ�EPU!T��H*ZMP$�8\�6\�B܆}p/�Nx��%�e\�\�X,Q\�	n)�iU��*̂[x7\\Q��@�l��E1�AP\�Ӕ?�X\�\�T6�z�\��\�Z@0t�\�\�]TyyUK�CA%&q�\"R�佝G\\Řuʡ\�\�\�.UY]�\0�\�%\�<NF�\�\�q>J2�O7����#%�e;2��H\���A�8��\� g\���\�b�-��,���,|��J�\�*�-!Q$$-��\�J2	��Bj�V�A�W*󀫨X�����f�84����DPU�\n�Q^J��p$8�\�@\�|�\�&���{�2{aP�8�\�Wp\\���\�[P\�\Zf�@�R�ZY�,�U\�A5��^�1�47�j�-eƣ,p\�JR\ZE���\'8,\�U\��\0�\�V\�o�\n��\��)�i[q�SH��\�bƎ\�S\Z4\Z\�f<�Q5.\�!>Ĵ\�t�+��\0\��\'�\�r����\�\�-ج&�,�k\�z�C|ln�5�ŏ\�V4tō��\�\�0t.��:E�@\�R�	$+\�\r���\�q�I�\�Q�A5Y\n�\�*��2c]C�c�	`\�\�PM9�]k�\�\�nyLe0db\�\�#���\�\�z��h�\�x�GQ��z�\�	I\�\�\�\��\���߭\�6C\�:\�Ը�N(�VMӔ��e^\��+r7�G\�b|����r\�f���۟\"{1c�?\�hԴ\�\0�Z�xt\�\�\�\�%q\�\�E?��I俱[�\�_��\���K2B�\\��\r,�n=:\Z���7L���+�	��Td�EZPMa\�U�\r\�#v�7*Jz\�Ɔ\Z�\�\�:B\�\�%\�\n�>\�#\�8O\�\�MjR\����\�3%\�3�f!P�_H�E�\Z\"\�i\�eLe1�\�H\�2_\�N\�ЃMi�\�>S��\�䴶L��S�\�\�,�\���M5\n�}4��&ས\�LDa%j�\�o�\n��\��)kulJrr_rL�	Q&I:�s��\�/&{G%� LU�dEN`y��\�?�AN��ԞK�&�\��\"��p\�35	����R�3)-�S�:\�nB�L<�џ�4\�p䋘�ܻ���\'@�:@��A5\�Q\�VX*���b�.�aa`�rıGl*\'�}\�\�\�q<W��\0z�\�qw+��J��\"~q\\�v�{�\�;\�但:gM�ۏ���t\'�?�F�\0 �xlO��\�g�4�3�1S\�\�\�A�S�΍�f�%�\�\'�\0t�bl��\'0\�e+�\�\����\�E�A\�\�.;\�\�TQ��P:s\n����}@\�/��ZF\�=*r$�%n\nL\�q�+�e<�Q�ۥȰ�\��\�X�(\�>j\'��\�\�\�K����;�\�|@^Y�}p\�DJ+f�e>�\0%|��}Y�0�_r���V��9�f1�_�K����\��{�x{�)�I��,x+�ژ\"��\�lD��r\�%\�p%f��L�y�?�IQ-!\n�\�HGg��q\�g���3&ܝG[\�DF��QL�@�R�ZY�J U\��WV[I�\�9��BP\�\�\�/NP\�\�\�40�6\�\��ك��,)\�t\��\�\�!�|�\�t��\�ȡ�\�\�Y�ǃ\�\�\���x�Z���-+�g��21\�u�[\�\�����\�\�]\�\�,�(\�6;n>��(�~O����\�C\�\�xu0g\�:��,�TvP�����.LeR]��\\�\�S\�*M�)\�	.���1[\n\�z��z\�M\�Q\�C�ή��������h)\�L3D`�В�`\�N��HD�3�\�A���8kQ\�!\�p�Ix�M|�T$��\n�\�*��\�Cshk\�\�D0NýQĺ�\��r��F5�\�>�w\�is	\�=��#\"!\�\�m�5\�s���S\��\�!\�r?#\\I*�����!�\�o�\n��\��$~:5�5\�`\�S�a>��\�D0\r\r8L�n�֥,줱\�\�0��\Z�s뗨�\�]\�3V\�\�1��\�.C\�?�\�x�H�\�$\�Q��9c\"̢gH�\�*TƉ5	�T�G�Hä\n�`�\��&7�5��q���#\Z(�6\�\�6��\�@\�F��t\�AӞ�����\��;aP�8|3\�W~F\Zf,f\�dJ:\�b\�E\Z�F8��\�tԻ�E4i���\�8�>���Ҁ^\�h�\�k~A?�qU%\�\�R��r7\���<��,��KӴ\�5,�㨌l�\�G��4�\n��� �WB�	>�3 �����}�ޤ�\�\�1X|\�SkYN���\�5%\��\�κ\�Z5p\�\�\�\�R\�\�\�e\�\�.!\��� ܒ\�	\�\�/��f1\�X\'\�\Z��\�\�n�\�\��S61���\�X���>��\��F\�2s1��(:TC<@th�U�jb78\�p�\�.�.�^\�h\�$T�~A?�QU%ɲ��|r7�C\�\�x�Ԑ�r�MZ�a\�rm\nK�)��D)\\yИ�!����t岲\�\�\�YGL���ޢ�=s&\��NҽP�)O*�4\�\�\�\�\�\�\\)�\��K\�\�)\�}�\��)AU�TPj�\�<�!��s\�\�\�F\�\��u\"@�Ga�P�8|3\�W�o\��\�\�Z����\�lq[����>7��G:X��!\�\nO��_sO\���K�d��\�㑿\�*`騛Q(ΑF�Y�I��\0�ƞkLRvAB�!\�d5 ܈�FĂ\�0fv똮>�u?{\�~F\�QXt�A\�t����[*Ա�I\�\�e^po�7\�\r偻E0UJ\Z�\njy�ӌp\�\�4�Lh��\�\�\�KlmIH:R�\�\�:[�mx=�p_	\�q^\rGt���l;(g�(f�T3¡\�B\�.�ճ�[�#\�H\�*�\�\���\0Y�\�\�\�p���JHz��$�ޙl\�U�:Y��Ğb�%\rO��.N/\�2\�2J\�\'ۑ�x�\�10\�\�n�\�zs�ԍ<x\��eRi�Py�9\�\�\�m�\�#U��S�h[N4\�H��B\��\�\�)�\�z�ۗL\�}D��\�:�\�Ԥ\�.�<� *�&�4�t�@\�R�\�$�\�$i Q�#6�\Z�S1\�fP\�,q�\Z�F�\�|k\�P|nO\r\���,n�7B\�8x=܅���\�T<N,�Ͼ&*ߊ7\�\��f\�\r��T$%\�\�;��Q~���\�Vk�W,\�\�\\�\�\�Ne�\�~9M90�H��aqqq~�!r@ݳ��GA\�t�ģ�\�\ZR��ޮtMPy�^\\t<\�t�7)ٗQ�kT%�\�Gq�#M-��fѝ�\��\�z�\�����\\\���Ie¸\�\�a�2V\�iIUB[j\�%���J \�V[�r�-�a\�UwlUen\��\�\�\�\�\�)�lC\Z�F8Ќf�b\�Lp\�\�\�1��4Q��8ۙkclH�\���v5�\�>��\����\0Y�Ʋ%\"UXN�#\�_�\'\�b\�c\�7GL\�\�^$MO\�\��\�o�	�#�-M8�i\�\'�t\�`��e)�gYe��\�\�p\��\�N\\b}Y*\�\�a\�\ZS1[u�Ԉ\�\�\�\�\�\�\�Ϧʆ�\��\�w?w\�^E%u3��ap\��P~�k/\�x\�h��o7C}M4���f	O�\�a!䴈�ҕ�}��\�\r\�al,��#1�C:\��\�p4��\�\Zx=\�\���x�Z��݉��\����\0Y�Ģ�b\�d7P��\�J�ؚ3\�3�(�\�\�}Am��)\'H�<�n���II\��r7\��DH�Jq\�m\�\�\�e�\�8\�gj�2#\�\�0\�\�!\�V��u,ꀦ唦Y���\"K�\�\�	j6��\�\�r$�Y\�ӑ��\�L�t���\�z�W�]/\�=��\��\�\r�Ly3J%\�p\�=(�\'�\��\�gvj\�K�M\�[}IF�\�uf㜧�\�8h�V+=��\���cP�%�\�>��bb�����\�5�ۮ�wcP��\�x���RW�Ľ�]8�f\�k�\�>����U^\�)C��Q��F�\����㼽�*�\�a\�\�FX�8\�:�\�Qڔ\�	�㳸\�6j�\�r�-ͺ\Z��/�\�g%��06��\�N�0��\�=\�\�\Z\�Ƀ�W\\�\�\�\�i�B�ۉ�\�u�M4q\�NS\�V�$ic�M\np\�SƖ\�\�\ZcAm�F\�m�\r��t\�\�ց��miX\�\�\�ck1��m�b\�t\�ʿ\�<\�X,#��\�^�w\�\�[�\��~Q~���{q����\�-oK��^\���+�\\q�~�?\�z{�-\�s���\�}/���J�\�\�Kϥ��\�\�\�i\"*f�\Z�����R`.R�,ʋ32#KRڍ��\�JSIC�\�G�\�=\�V�\Z}�\�\�,\�\�~Դ�E�TI�\�\�M��\��\�\�\�\\\�e\�E�qc�\�\�88\�C�R\�)N�[\�V�\�<5�\rs�\�T\�{�bX�\Z��ůz��LIɃ�\�Mo�\��c}1��\�A\�,U\n�\�\�Í�{q��Py�M�eU��\��sP��9r���7��\0\�\�fN5CB挖�\�\�R�����J��\0�\��\�)Fy[2$�,�\"#K3JV�\�ؔ��M�����N=\�7\��N��j��\�\� ��J�P\�ސ7�\��\�Ua�=\�8*�s�a�E�C�A�D\Z�c]ka�d!��50��\�\�hC�g�3B�?\��b\�\�Xc$AP�M�=ܰ>Dv¡\�p�gޯw$iNG	�\\ncr�\rĆ\�CqHT�\�q�Z\�\��/icJ�U�\�?PN`Y��=���\0U���\�9\�u\�3r\��\�C\�ўC᭘\�Cd\�\�\�Ɛӊ(\�\�WMԭhKp\�7���g\�8Ԧ�ǩJ�v�\��ٞ���/2��\��\0�\�n\'Ї$:M䌴��-��VI/\�\�\��\0n�\�=���y+\��\�L��\�\�\�49NB�:{Y�NJ0�B��o[�.�	��{�ۀ�<ܦ�.\�\�y�q�f�`�\�0�x�\�0m�,�mf���a�N�*�wQ\�ǘf�U\�j?��\\Æ\�U\�y�K���a�\0%\�nFdd�\"�e^K��%\�\��/ѕY-�J�	!8�\0��0�Q�Gj=6R[l�;M\nj�[��R���`�t�\�)i<ɧ�ѻ�\��,�;#E��\�VI��Dg��*o���4\�n;��\��\0!r?�\�.B\n[m�\�7������\�zFyT4�9�ʒìn,8�OA�Cl��ZyO��w=\�]����\'�㝟��l\�B\��	\�l*$AcQ*|\�\"��ܖ\"Ӕ�K���ۤ�\��0\�r^vۙ\�\ntbN�r�?L4�\�0\�a�wO�D\���Q]4�Ҽw�\�z0C��& �PI�\��;r�/\�W�n%�\'8,�O=���\0]\�8Fp���\�y\�y\�\���H\�D��<�K\")�\�D\��\�78�EB�ˌR�#��\�<�7�\�\�\�e�2L!�j\�95M\�E5Լm-�=�\0a�[zd!-#�̨\�:h\�X��\0�~\�	gD�j%�dP\�\�Έv؁Q\�6d��#hH:2�V\�\�\�\�\�Ih�\�\�\�\�cCldm������6\�\��\�㍾8\�G\Z\�0\�Ue��\�\��1�x�Ip��Zae*8\�\�V\�L\�Tک�S�\�C��\�Mu�B)��\�d�\����\�$\����\"\�Ye\�N#j��\�x��\Z\�qk㻪�R���-�\�7M�r�.U\�\�r\��\'&_�*�Yy.\�AV��~�\�b���C٤�E^�̴\�*�$\�K\�RVL��Ga)\\z��h5չ\�-�\�.Vt�J����CY�js[(֑\"\�	N�W%JiOf��z��\�B=��\�8�\�<5>\��\�y\�q�y��gw\�,���\�88\���\�X\�,�\�3�fX̱�b\��?\�?\�,\�3Y;\��rıOl*$|�Vq(z�\�\�-A\�\�*�\�\�~Z\�d\�8q^�\�\\Ǖ#u�a�o���	�O���g��\�F\�e\�K\�,���m�Sg�<�/�O\�i9N ݜ�7��\\\�\�:����7\�^ӽ�{��\\#0Nk}V<\�<�^aU�\�Nu\�`TV�@GT\�[�z\"�T�jt\�	y\�4uK8�Ӑa\�.�EB\�\'u�	G=�&v	%\�%�DRQ	-;���:\�L\�\�:���\���!��TA�\�l t�#A\0h�\�IN\Zjp\�Ӈ�8tђ�C�\��`�4f�,ǀ5F�\�C\Z�c[k��ta��7\�p`n,�̥\�{�``�Ol&3����\�O\�<j)\�UO\Z�x\�\�ƾ�7r�78Cu�7hcw�7�\�y��\��\�\�\�\��C|\�\�}P\�V7\�F���\�/�\�ڮ\�\��V�N\\�NUe��\�yD\�\�\�\�.�\�%%ӕ.�LD�R��x����4\�j\�\'-G�ٓHҜ\�u1Ԓja ��\�H\�TI\ni�\�M\�?�\�\�=\�#߇�Q^�,��됙0\�727Kt\�Hr#ͷ�N��)Ĕ�m\�{s���8I_!��d����M?�\�\�\��~\Z���*9\�\�\�/o)���(#NUeU��A>޶<\�<\�Va?\��iǡ\'�`2�\�R�)LU)4�8	\�J�\�\�ˮ%�\��\r�\�\�\�D4�\Z\'\�.�7 u�u�\�\�!H}���ѷ\�?����L#߇�Q]I�h��\0k�lJq\�:��Nq����F��z�JG�\r%\n�ٻ�e\"��\\N\�\'���2����{�2y\���~T�\�\�^\�R�j͟\�河_������U��Hn\�Z���\�qĴ�\n�#)\�ԗZz42\"�7�\"Za\�LQ0\�ᤲ�C)�\�3D�w��E{�STI\Z�\�\�/�� ���J\�Kɫ�w� њ\�@�lْ)s�f\�\\g�>���<��Ywu3\�F�X:t\�=�`\�傣J�\� l�\r���(\�hH\�[[#m�6��Ei!�<\"($-�\��\�BxcU�E��\�w,)\�\�\�,b\�#\�i;\�1�C\"�E�	B�\rC�c�c�c�8aI�r\�C*E�,�D�}\�@�\�Ӓ\�\Z���4^\�)!\nHJ�.o�J\�;�\�uQ\�/�\'9Ȳ#\�iI\�a�\�S\�\�FMn��\�!�T���\� UZ�\�#\r�8:�$�\0�F�^�Iz�\�~�t��]>��e�\0 �\�	��˪\���G����S5�K[\�:ꂫ�\�\r\��\�\n�ʾ�,^X\�%��JP\�%\rt���5o�C��\�73�]b\�\'AGxi^\Z7ƅ�iL��o�#2Fr\�g!\�	X\� \�\�\�\�(6�5\Z\�|\�\�3\�b\�b�\���\�/o){\�dy��\����\��\�l}�M��򫰸��3^�\0Vb%����id�\�\�3E:Y\�&);D�\n�)���A\�?\�\r��K\\��KG�fTY#d|ln��\�a!��\n��\�mpHh)\�4�\�*i\�qi\�5PHka\�b�\�8\�Y�\�@\�\�wPݖ7WC���TF�`\�rıN)�����F\�$2Hn�$��I1�\�E�\n��\�\��4%�\r��Ɓ�26h\�h�6\�Co�\�R\�pi$-H!��C�I!���\�)�&Bjls\�a>�Vʬ�V[�7,�9Brۥ��Y�\�\n�s)[\Z�\�Cel&1\r�\r0���C�G {9%���C[L!�S\�VV\�$o\�#�\0��\�0~��\n�$\��(oR�\�\�X\�\�-�=��\�Cd\�rA֥�K\n�˾\�(BHi\��M`j^�\\\�\�Q��1�\�]�?�N|\�~��K�;ܱ,S\��Q\�\��7Ղ��fu��֤\r\�Pݥ�K��S\�\�I)�\�xq\\\�.a^\�Bؗl M\\7gDn{=�}��\�>ʽ���A9�f�g2\r�\�\�\Z\�\��\�\�\�\ZUn�4�heۥ�\�\�]\Zj��\�3/O\�\�ׇ�u`�#dd�\��\�O �\�\�v\Z`G�3Kyƴ\�\���F���\�&V���Ӣ��\�a�(%�jR&%<I\�v��\�NBP�꿯�w��3ɕC���ti�1#\��k�`\�~d\�P�!\r\Zˀ͔\�VO+I��C�$3���\�2�)ʒ�څ)\�\�\�S$�:u���4��\�o-��EQ/`�������\��\'-��N���B(|*9\�q�\�5T��8�\����\r��*�\�:\�\�\�rA֥��L\n�\�S��L\ZɆ5�q��\�:Z\���\�{�\�і\\�I{�R[�@l\�<�*	R�.�Dz�\�\�F\�Iq�2\�5f�egn<\�\' \�x��F\n�(\r�\Z�QF\�\�\�XlB\Z8?�H\�@!��Cq�Ct`n̓��:��rC�;ܰ>D\�P�B�\�d\r�0*\\b\�4\�~AG@�8g#t.�e!b(����JI�6w��\��\0\�R�L\\�x`�P\�6!��@�.Ѽ�{\��\�e\Z�Dv����	\��\�#\�*^	#Z�è\r!N�\�G\�R\�\�bq\��0�+�H�>\�W\�B\"�\�OB�\���\�k�*����t�_�}C\�\n|mK�	Ix��\�D���jᢦ$p�)\�)\Z�ZF\�N!�\� u�u \�7\�Lm�u� \�LFI�� �\�x�B�X̳�(��(6H*T�HxCh��c\�\��\�ơ\�E�\�\�dH\�B\�z���s9�\��\�+���?��\�\�\�H���r\�c\�e^�\0!	�6�����xK��1O���\0E�3\�a�\�8mƈ��B\\6�j̈\'�\0vDԵ!���\�\�\�\�\�4\�\�u\��Iߩ�������b�\��>���\�ۆ\n3\�\n�d�H�`���ho�(li4r\\2\Z*zG\n���������C uh\��\�:\�:\��\�\�U|JA�������\�gF�Ѳ\�w.d\�P�B��y�Aރ����I��W\��TK����u\n�g��+ʘ�ӤmR��yf6ICe|�if����c� \�=\�K�\�b��\�Z�l���nQ%��-\�u��\�K�n�0IF�,\�\�$\��}\�H�\�$8`�\�P*|�(Tى�\�?&!x�?\��Ne�ѐ5t�\rҜ�u��\�`\�\�~x\�\�ܤ�ʼĄ\�\�:�d\�H\�LY��������\�\'\rk��;�\'\Z�����^z�\0z\�\�\�\�3�8�d��\0f\�\�F:�2X�@\�q��\�7��K�\05-|\Z�\�\�7=U�fV��r��T\�fKy�3Q\�O����\�QKN�\�/..,f\�\�\n��M0T��6Y�\n�$�\�\0٣$:�����Z��Ǣ�B��\�b$o\�\��\�\�\�u��$\�rC��\���봌\�;�eeL3f�1�g\�Mim72Tq����JR��2BאN��S\�$��0邈���\�0T�\n��f��9]��.\�\�:�\�..\�aqP�W��ʎ��\�a�u�\��7�\���%r\�6��K:@9n���\� n6��\�\�o�ώ5\n\Z��\�q�E��+�\�W\�V���\�_kX�Yd\�\�L\�!\�\��]IHݠ�o�$+\���UvY��L\n�\�0��\��\�\�O��\�~#�\"�ҝ�\��n��7��\�AԽ(\�6��#�\�یuG2�Py\�.�!`�\�R�\�Y\�\�(&�,\�h�\r�T%�� m�m\�R8\��\�\rl��E u��ց֖Wxªo�9\�q\�8�\�,j$6�T\�d\�B\�c�\�\�gP��\�W�T8kӄC\�\Z/���/�\0�X�}��\�\�E\\��B\�\�>S\�>D��>1�\�ʖ�NR\\1E�\�9�gI�\�&MI���\�\n�#n��p�(zR\�O@ޣ:�\�\�]|«2L*�(�ϒ`\�<`\�p\�֠L:�P�*d�	�\�0�+����\�\�b$i��U!�\�N5,f2(!�\�m�<̶�FVFF\�\�6,c\"��\�H\�\�i\�\�IQ0t~\nxmK6$4	��yGJ#MF�\�럶N̚4�T9�dtm�$h��\�SZ�A� L!M9a\�[�ŭeH�6�t�2`|�ې�\�\�\�)��2�~!�����A��3\�\�jSm��0ªr\�.d�3y\��<,fê	�%A4�f\n�,\�h/��*$6�I\ZJj\�\Z\�zբ�m�\n�UmЪ��R�`\�`\�:`\�Y���J\'QQ���5!4�PT�&HxK�)�8��\�lp�i:\"In\r�ȑT��\�*\\�T� �\�Q���J�<\n$r\�D2�e�KR��ԥHD\�*V�K\�\�\�Ec��\�^��\Zqi�1\�2\�\�vCH�\�>S1�C)�\"H�E\�WRcHPM>j�Rg�\�$��$40�p)i��Gz�te�fj<F��O�\��y@�\r\� �h\�M�\�5���\�HU}��P(u�\n�\�0���\n� ��\�Z�_\�\����\��|\�C\�\n\��\�\�\�\n��B�@��C��_\"#��ne�9?�J�>j�硭EQ��q�XuV?;\�a)<\�LXX�w�\�,�1�4��$,\�bKP*d�T�t\�\�F!���-#�LH9��nm�n\�\�&���0¥\�P7�>1�\��+2ދU9���\�Z�\�\�\�\�\�\���ɵ�LW\�N���D�	�:\n�@�1\�\"6�Zu?��\����/\�\�\��\�\�\�\��T�\�\��\�{�|��\"\�\�}#\�H�\�1�\�3خ\�\����:��:����\�K��n)@�O�>\�O�a�nOR~�T�\��\�\�x����\�Qtډ\�M�\�a\�PM2Z�h��&�\�M	$\n�#CO@�5����ux\�\n��*���\�\�R�aS0o�c:��|\�C\�\n\�\��z\�\�q�\�\"E�0\�Q��uȀ뭃���\�%UVhUNa�NgU\�z�ɗ��\�fTY�;\��}��%ߓ\��.K�Єr0���d2\�Wά\�2\�p\�/��:C�a>�x �\�4T�\�jScq� n9W«�UfI�T��*[\�\�\�f?�L�f�r\�\�\�(}\�C��r\Z s��:�RY��ШK\�&��\�I\�%�UFY�N�`\����\�@\�h8\�z��K�\�t�1~J\'���/oَ�*,�\�\��6֒\�?�]�>��{\\B\�\��\�x\�4\�\�)����A^�PUzI�Vf(*�)AR^P5�\��\�$\�&;�И�\�DTS��I��S㑙�yKb��8�L�d,,C�\�.B\�\�0\�**\�H�9�َ+C���\Z��C�N-D��\�\�.�\�:2\�>1��_P�2\��������\�fj\�\�C&K��\�Z�%�\"�9Ce�Cki#KM@�!!`G7V�\\/�\0�YqA0$�:ښ\\FC\�ѣ�*|4Ǌ�\� \�\�:u��,d\�R\r���\�.B\rIef�\�t\�s_&\�\\\�C\�b��\�5�<&�FC\�$�LK1�tȐhz=+T�����p�f��0�L&�8\�\�4��\�}C\��\�.�\�\�鎡�ʖ֠�\�G�chx�\�\�F����JF����2��>AU�\��KXS\�(_��\�6�\���\����\�\r\0����!KZJ�R\�b!�#���_��K>D4���m<�[C0f��9��\�I(�\ZA��G�E5\�O���A\\\�\�C\�[I�L�\�x?\�g��Q�\ZeB�.������L4B�N��d\�H�`��\n�5�GIT�\�\�\�\�T��?+\�)����%>n�Ғe*��u&�n\�UZr�\�\�PRԬn/\�����(-����Q�^�>�U\�@h\"��\�i�MJQk\Z�ӝ�\"\r#PD��]mE�\"rM#2�w\��S%PY��\�C��!��:�uru�T\�\�.�!As_P\�cQ�\�?�P�B�Ws)a-�;%GFd&��i�+m!�A�\�\�~9_�J�>j�\��_P�O��]�o��pDg�K��*�\"+-\�\\R\�\�\�S���T\�\��5-cI~�\�\�Ӣ�>\�G \�^\�\�\�d\�l��m�4I:f]e�u\�\�$\�~:_UN��N�U\���a3\�@\�:@\�Y�\0��\�T<P�~NP\n\�\�s�\���W\��U?=\���\�|s\\_\��\�F\\�r��l&&���\�,�a��fD�\��\�V�8�Ԅ\�\�\�\�i�rC,�5$1>ET\�PUvI�\�\�(*l��-Ft�xS\n�MO�L9�E��T.�)AO8�\\�\0�_�\�\0/\0\0\0\0\0\01Q !A2R\"#0aC�3Bb@q�\�\0?\�\�t}]�IԴ�\�ʎX\�\�n\'}E\'c�\�\�\��o\��8��2\�\���3\�1Ob2\�\�R�]�\�����9\�h\�M$\�Bw0ʜ\�#9\�=O{�����yDx�1N/G�Y\�\��+�2RcP}Ӱ\��6:[D\��!�)J2�\�G�_�\�i�U�Ė#�M�=4|3ZH�\��gTZ\��1�V�2i=\�l\�\�\�>xb\�\�ܕ*�H\�X\�\�\�\�\�,\�t}��݌��B�&T\�\�����ݔ\��(�\�\�����.��ylb{эn_�\�8��r�f�\��H�%O|J\�\�WW#U\�V�\�V\�|mvfGr\�(\�\�\�\�>\ZO%푆��fUZ\��;�2SWCWV=*�\�e\�\�\��*�JU���F�Wy.\�\�FZ#m��������\'/�\"�Zt\�Fa{�Qylb~Q��\�\�\'~��QR������*S\��#	E\�hTݝ\�\�ܗ�Q7�/�U\�\�)U\�о\�Kx��\��k\�ė|:w\�U\'��vܓRV�Q]��G�\\\�>݈�+.�u\�1�\�S\�\�ɒ\�F\Z\�Ɏ�\��Z\�Ϧ�Fe),72��ُ�ٔi8k\�S\�\�\�\��j\�Ɖ\�k\"6Q\�2\n2�ma+v\��o\�O&\�k���\�\�f|ȿ\"k���\�(��\r�:P~\���\�\�2�-$}�fUZ\��\��s��/\�\�]�z���\�wG����{�\�\�r��\\�\�mH\�x0���O�\\\�x:�\��c�_�*+���H\�Q��Lu��\�\�HTR5)�x�Y~L&\\_�\"��\�dm#*~$a���x\�W\�gO\�A�T��\��.u=\�._���\�=ַ�MKNv*E��$]\�\�&�(�\�ě\�$�aӔ\�\�Yy/Y��=E��\�b*�~ER;�E�\0\���\�\�S\�%!ț\��\�\�Γ\�\�\�/k){:\����M*�\�:��q\�\�\�c.;�6=4L���Qi\"՗�e\�Ο���wg\�t\�Ug\�3\�e\�ͩ�3\��=O\��P=M3>��\�\�\��T�\�=WC\�\\\�.�{YGع\�q���0�̗\�F]O-Yy/Yx3j|OP�\��1:��w.�T�$S�(�\�t�>�\�\�ͤ%Nz0\����=4N�%�,�\�\�\�:�:\'�\�n\�\�\'\�..\��\�\�e/b\�U\'8�T�8�\�\�Dɧ\��\n��H\�Wr���Wc6^bf�11\�\��,\�Ks.>$e\�ĈG\n�%\�\�h�y\��#\�#\���E\���R��7\�K\r[.W\'\�z��bV4\��\0Bп)�YKعԆ$:�~�^�M]\\�2�e��\�\���\r����\��_�\�\�}5=�\�4|��8O=?\�7\�~:\'�\�U\�H�\�*i9,X���}��J�-\�\�~bg\�\�3ilb�}�`���\�\�F\\�H�Sr\�w/T\�Wc2\�vХ\�\�xm/<\�\'$\�QEJ��1\�:��(}Ą\�\�\�\��\��\�]ݗD�]*۲<�(GVX\�\"Z2��s�\�QeY��îg\�Ԍ����*~QR��!�)\�e\�\�a��j�9\��\\\�O�\�\�]��fOr�IcJ\�-\�Z���!+tOU\�&��\�,]\�~\��=�����s�T��j���6G\��/%��w\�\�Č�{\�ω�:t73#��;�qj\�/j\�\�\�}5���B�����KފZscmL\�\'�\"��\�U\�U#S\�ӗ$\�\�\n�4#5-9\�\�\�^\�\\�U\�\�D�E\����\����\�\�c����\�̗\�\�3�L\��Lp\�\�Ob��\"�K��e\�i\�\�h�y\�[؏dũKފzr\\�VibϦz���M����c�{�X]�.Wi�#\�[��\�v%\�e7�.u{Z[#�\�\n��JQ\'	]\�P��\�W����Y�k��%�O\r�\�\�\\\�R����\�/Fs\��i\�E�q}I���$\�^\�qw&�2\�\�\�s&;�+s%|��ٕ�\0FS�o\�e\�\�e\�\�`�\�\n��jna����\�XcnKN�G\�*~-s+�L��2�č;wQ#.��^�\�j\��Emnw����+>\�{\'a�Ի;��!;ҹOڹͩ\�\"p�YjF\ZFw#\Zr2\"d#!s!nd~̏ٓ�2c��\�N��-:xm9\�ሪ[\�f\�\�\'Yv\�:\�D͉�5S3�ri��Q�������\0/U�U]\�U�$\'\�\�>��\�A).Ȟ���c\�\�%�)�\0��\�\\�lNc\�̓\�ϴ\'KqN��\'qW��>|���3\�g\�ψ\�E���r]<6��Z�8�3�\�\�M\�\�̧s.IX\�f_c)��\�r}\�hpz\��o$vEޯ]MbV_Z.;w5\�8\�\�B\��}�\��2��r��u53a��\r�\�lgGc6;�c9|L\��3?\�\��\0�1�L\��1���_T\��.kN�K�=7\��߳\�-\�L�=4OM\�@��=<O\��ȁ�0�]\�]mbq��o\"wEMF�DZv�_\�qnP�ȧ\�\\�x*{\�Tvfd�VW%6�ɐ�ܻ�}sI���W%�\��n.��\�U�\�$J�G\�tek!Ш̙\�\�\�\�=4�=,�\��_\�\�die\��){Qb~	\�/Sb�>\'\�~�Z�j\�\Zۘ*\�e\��s�r��e�������#*ܒ,X�c\�nf\�s:�\�u=\��{���\� z��\'�[�\0�9�L\\��\�l͉�5�c3�f=�\�|Ls��\�|LUv/Ty���ʧ��\��K\�>\�jۖ�{b0TZ\�T\��\0\�ȗ\�\�##�zu�\�\�zx2a�:Iw�	bW\�hR�\�ٓI\n�=��leCa\��xl,,\�\�:$j)�\�.\�/	`\�|�%L\�љ�1���_�ؽM��}\�\r]\�5>F\\�C�$�\�>�D���5>\�dӄ��&�\�\�Z���8_B1�i�1Q�\�gCs>����\�\�\�Η\�̩�1U~\nq\�>K��ѕ\�\��\n��R\�R\�X�_�j\�=�\�<ܟrZ�Mhc�\�ۑ��\�|�km\�\�c1�W�c3$Eɵ~R����	b�߂��\�����FG��̪[�ha\�\�fS\�͏���\�L\��LUv>�\�ܧ\�BwW\�\�tg\�\��z8eݒ����=��\�P�����\�\�s�Z�她\�.ϕMc\�ؼ71\�\�̦gD\�^��D\�/���\�y���CVT�V���\�RK\�b�I�+\�/Ix1\�\�\�T[I�\�8�f\�rU�k}���ѕ8|n\�G�G����\�ɉ��QE�$�(�e�.���\�C�&T62㱅�\�D�\�$VO���\�\�r2�{�tH�/1\�J~ b���\�~FT�\�\�^de\��\"\�Tv#*m\�ź�\�\�\�VQvb\�#s\Z1�u>��\�\����$*�\�J��!\�5�\�U�\��C�0K\�e�\��c��Z[�\�ํ�\�\�Fg茥wdBIJ1\�\�@͢�Fz�:^\"fU��|\�Y�2�?�=;�#\�D�\�le\�c\n*�J%\'x���\�\�\�\'\�\�.\���VO^|/��nW\�?\�Y�\�-#�0�\��-q\���s��\�U\'8�M(\�\�~�SƯ\�\�\��yOs\�\��\�LڏH��\�5��&oY�n�\�\�\'\�X�-��\�F/*ǧ�\�Y\�JT0�>祈�x\�F���\�\�L�r2���ӕ�-H\�\n\�V�=53��y����F\n\�����dze勆��OaS��Yr�C�W�\Z�\"SQWX�\'�\�\�tc��0#0��1!;�.�\�\�\���E\'d7�\�⥩��=\�\'}9\�\�dLf\'�y\�}f\�e�\�(�\�P\�|b\�|T����ky3j?$��r4\�%qS�D�y_�\�X�n�FU��V\�z�>)�*w125�c>g7\'ܞ��Oq�\�\�\��`F�]NqZ�ՂW���I\��N�B\��G�\�\�:�m{�s��r�\��\�Ԛ��ձ*u\'؏/#\�\�sҧ�&\n)~>Fq>���\0���Ԟ��Oq�\�\�\�f9	�mr�Dݞ�\��{��\Z]�N+�%��\�s./�E�\��\�\0-\0\0\0\0\0\01Q !A\"2a0B#3@Rq��\�\0?\�G�\�ta\�\�\��j�\�ue\"�m%SUT�L��\�R\�\\{JDq�D!q�\��8��4\����Z4��\Z�P��?R����q�N�4\��\�E?B=N\��$�\�\�#W\'*\nk�I��\�SQ\�E2�\�_�|��jI\Z\�Ջ\�\�\�(=����Ǉ�kbGqz�P�V�#\��CǏj�\�Ò\�S\nR�~�#�}(�;��)�\�jE�n\�\Z��Ĕq;�\�O5B9�\0=4\�N�\�Q=�6Y\"+\�\�?��\�����hʦ��(\�l��C�$7��5\�\�`�ѧ��g\�WfN���u?/c�\�>�S�\����\�J9h��#�YVbIS��+�\�E�hP�L�P���{1\�*\��sU6�(˵K��\n�\0����}ƄiCO:��p\�\�t=�\�w].���\���\�}\�\��\�>����驪\�E�\\7\�\r�4��i\�l\�1�\�\�O��\�ت{ta\�.��B=N\�\�\�\�q%[�WC�\�z?��1.��)�{y(�ߦ�5%ȱ\�k�X=\��,\�\�{3�f��%^���)�\�\��hG\�?�<h\�ӗR�z�q\�{�Nn]?\�q|\�Wb��k&���\0B��\�s�W˓RF��Vj}.\n\���E��G\�iL\�}�*8q\�Q?\'ڌ�\�J�N�\nÃ\�\�cɥ�h�JF��-�\��\��G\'\Z�\nfȡ\'=q\�8 \�\�_\�\�4\�5%ȱd,vkr�HyEp�n�h�\�\�`\�Uf�\��Î\��\��iǓIrh�,\�f�,e��~�f�vT\�\�E�\�].�E\�\�\na�p\�\�Ofh3FF��9pZ\�R�1#l��\�4#\�n���\�\�\�%|w/e켼�cT\��\\d�Ssn٭Ǿq؂r)>\n\�x;�6�\�\na�\�ri�\�~l�?л��y����&\�u\�\�D&cҫ;a�[\�\"�c6�\�>2Q)�D�K*�-\�n<\�\�$\�\���#\�\��1d��gL�˙�#VDg�C�2{\�c\��\�\�,��1�\��%\��$�۶s}�	*-ǜUKK_%%\�\�=\�e�Yp]�\\�.�`{aɧE��1~Y=�B1�\�\�p��6\�R~G��(�\'\�]�\�+KD�\�}؎\�nI�*�E�Ÿ�\�\ZMw\n4~\�A\�ɦ�4\�N藚��\�|x+�,���7�hG�\�/\�s�)#���,\�n��\�JU#�^\�\�ϣ\��]���_��\0\�6���#�ܰ\�,f�,e�,�$\�O�Or�$T\�ܩ^\�\�s�+�E�剕H�\���r�D�L\\�[o�9$4!P\�4�lE���������JK��\�\�\�딷\�\�\�/\�s�Ź,����r.],r�\�\� ��wc�[n-\�dȐt]\�DjE���r\�Q�\�VB]��Tt\�[\�z�����\n�O:3�vl�\��|��T�YK��:w\�~��..EQU�tx.�a�X\�&\�\�\�5��\�/ܟz��\'���\'a��K�.�]F=\�UX�\�^H.�蠕KYl�1�\"���P\�5\rCW\�\����\rS�M�*TL���U]!¿NU�7�\rԲE�p(\�S��K�U	�ǿK*&>\�jWq|�Er��r+&VT�\�\�$X\�c4٦\�&iHXL\��d�\�\�\�i\�\�	�v\�(^��5qr\\�/\�\�tyg���]\�\�k\�(�,|�>K~\�~\�~\�~\�%��÷�\��\�e�F�Ѭk\Z\�\�f�5ˋ��\��Gq\����G�\�\"!ܲ#\�T#\�8Â�l�\�i��,����PI�eB�\nt4>\�+��\�\�\\\\)}>[��\"\�\�\�MrV%`V\�e\�.��\�p_�^�\0�_/��K�)\\\�}ʕeYl�,�d\�9�r4\�i�\�X\�J\�R�J�+�b��\�g\"U=�����Z	\�\�K��\rU��k\Z\�֑�#ZD1j\�\"j\�L�����\�2\�\�Ց�\"2�).I\\�\�ao��]K�U*T�K;\n�rb\�*�\�A�w+��7�\�99F�4\�iHґ�#E�?f�y4\�\�n�bJ\�Ud�\���?���)I\�R�ؖ�T�\�\�]�]�\�ctD\�e輾\\O��=\�1g\�c\�\�_�,�%�\\�\�]����;D}�d�\�e\�7D~+��]b[\�\��J��\�\"�gc�\�-�$6\"\�;\�,��N|�O�\�}�m:T�M�\�ҟpf�L�L�h��8�#Y\Z\�\�5{\�\�5Y�\�&ˤ]\"\�T����)l��U ��{P��\��	9��\�\�E�\�\��\0\"�>\rX����D���Ÿܒ�\"U�\�9>�z�\�\Z��&�4\�{�\�P�뱤8S�\�̢(�y�TT��_\�B\�\�ѥڤ�QU\��lߓM�f�\�������V\Z\�\�?%��3^|��佘8�21�&\�\�G��C೩��Ka\����(S5�J�*T�R�\�\�Y\\\�\�C�\�xf,,\�Т߃J|g\�H�u\�Xky�E�+���I\��W\'ЏS�!�E3��EȽ����D^9\��zW)W(N\�ĩ�;\�ze\�|\Z���\�\��#Z|��\�\�E�a\��4\�[H\�:u\��E�J��;�b��j3RE�dX\��1ŚD��4\�\n*�\�]J\�\\\�\�;��\�ʿ�N{\�}�\�Ǒzgwѥ\�Q\\�,HŤ<X&G\�Ɲ\�ˈ�_J=N\�\Z�3M\Z�m�L�=���,�?MJ�+\�k$\�)\Z,x�\�P�\�b�B+��\�\�S\r\np�}\�\�`~Tx?-�?S3^|�r~R=N\�\��.��\0\"\�\���<O��~\�P�l�\�䯴��\�I\Z�~H�q�\'i|�ܫ�\��\�\0E\0\0\0!\"123AQ #Baq��0r�Rb��4@C��$s��\�\�PSc��D��\�\0\0?�^�����?R���り\��p\�}\�E�pE�s�g\�I��\�\�%@\��9^�ƈ\�\�4\�V�+��5��C&\���\�\'y\�!��\�K�T����?\�vq�7\�\�}x~ \n\�\�X��K����\0\�z\�\�\�l\�a�B\�\�\n� �/X\��=� G�\��\�\�U\�w�L�D`\�۲	\�-!ż��1\�|����20�74IY/4�X\�}H\�:3\"b��	\'23oM�\�,!�@D\�@3��\��\0\��l����\�\�6�y�\�^�t\�Nj$��2T\'��~+�ˌ�Se�\'�\��\"\���մ�Ǘ\�\�6{_e�O4l\�\��i��g*8qL�C�\�\�B�\�Rs�`\'���|�\�h�\�5\�Q~v.\��|�\�:=��c�\�L\�\�\�\��CX\�\�K��\�\�\�G��\\�Ar\�\�N�$��3�\�8�!ř.\��A�i�x�D2�&Q}�\�<���/JRF	a�yb��DZ5e5�\�N#\"H�$:��l��95Ӓ�WKL\�A�\�\�B\�yO�<�e�\�!�oo\��Nuֶ\�!G��\�3�.U]��\��_\�l\�`�[[M�_�L6�\Z�\�+e\Zt0$^�5Ȱ�;4\�\��5\�>	\�d�gԢ1\�>\"]hQ\'\�\"�>47���\�fCl��Q`��귗�\�\�!5˵�V \�\�$�7�\�\�\�FX\\\�-\���(n������\�_9\�h\�A\�m\�)��#>kT\�R��+dd�\�$�&aHd�b\�2�2h�\�1Ԓ\�U\�UU�e��>(\�2�_���T\�G�-�\�u��&ĞS��+���\�h6\�\�W�J\��\�\�C��FFI�[NS2N��!�u\�q��\\d^\�\�\�O�����[���a{�u~�h	�A�k�\�qY�\�@�\��\�\n1\�`ū\\>����P_\�\��\�\�og汵�]���y��\��]�E�\�3U�UZz0��\\K��>�8�\�\�;P�hAO.lÑ\r�Y\'m(��Qbb\���>8v`\�ƓP���!5\n\�f\�\�y\�0\�7?�p�v\�\�y�\�\�\�\�z�\��\�d�\�Cپ\��\�T\�D\�/bJv�&r_�`���\0p��GV\�Bc\�\�\�\�/�\�@O��`\�{�\�Ac��mAf�Ҹ�\�ad�\�٭b���\0\�\�w�:�x\�ײ�8FC\�\�\�?#%~\��\�\��UH�\�b�\�\�AX\�/E��*�����\\p�X^�0�H.\0��|�\�Co�D�s-P\�\\ی\�\�Gs0ݓj�\�x��\�\Z�l�jvS䠋#�s��V\��Q\�c\�x#�q��V�=\�\"/��D1\\{5?��nx\��j&\�y�HV(dմ�t��\0 ��\�vvvkyM�`�;2�g\�R\��\0Z��d�45\�~΀~S%[,x#\�Lx;&�/\�\�$�7���\�U�?ҫ(��j\�sZB\\V��e�T=���c\�]��_8]���U���ZG���8E���5g�YGez���gk�Gk�6ne\�rGf˭�1x�Ʊ;F`��$@\�\�0%�5}\�̕)�\�I�#sN\�pS{)\�\�\�\"�T��HSX\�\�\�wVj\�՛Ik�~�/�\�hos\\Ȕ��8G�\\Ĕf\�u\�\ZQ܉Vx\0\�h@*O���\�^m�\�>2(�\�Z�f)%d��\�\Z\�mҢY��5\��\�\��܊d8�#;\�\�,N\'̡\�z5\�\":\�,c��3SЁg;+4��H\�`��NT��֫�l�40�o\��s�\�X��\��h]�Z!�̚\�h@?0!vo�别gw�V8Q�Vk�ZBȡR�|^<��w:�ѐ�\�\�+��\'�K]4bB3l�8�t�ű\�\�㒎\�E\�	F�D7SO,\�q�(L�\�+Gk,���\�p\�h���o�\n\�\��qo��|���\�\�Zd溊$8\"�5�ni�gP�:�)\�x�\�I\�w\�=>_��\0\�[�3�x�r\�D���V��DȚdN��\�\�C%��\"\�3��k=�\�\�j�䬖{׋qJk/H!9���\�U��U�\�\�fsL\�]�)0�.)\�\�6���\�\'�YpM\�\�\�gefn\�\nvvf\�gAF�V�H��X��r��\�Ϋ�d�3m�>�h�YcC�_5KLx3We�B	���eO�\��w%\�\�{<\�G�\�Y���M�\�V;L\�op\�=2�\��NsWP\�mY\�9�2�2�\�13#\�C����%Ft\�A�w\�\�\�/��6\�\��A4|��C�\�\�Z5�y�G�\�r�ȭ�e5��rYG.�\�桿��\�\�8\�}ƹ��F\�\�\�\�9��(�ݧ)t��rPmP�\r\�Q[4]R\���q;7��>5\��S�\�q�:\�k�X&S��\�\�\��V�K��բ4v\��\r\�S�\�+.	���\�/\�|P�h��j�>학�/Ƴ���D4\��e\�4\�U\Z��\��C�\�/�:0F�\�\'#\n\��E����pզ�w1�r\nc4\�\�\�8q�\�֏6�/`�r\�\��0�T�V\�P�\�Gd�7\�KhMgU~&��\�^k�0�I\�,(\�^g4\�p\�H\�5\n,��(�m��ʉ\�}p��\0\���\�M��$Ay�Dӡ=�B}ANc\�_fvG��\0�~\��.\�\�\�3�*\�,Nf���6B}P�Xp@s\�Y\���:e�\�\�\�o��E5z�Uz&�g�(�(R�My�W�rw�ɴ\���\�qG\�3N�rw�5\��x/E�Q�_u>\�\���^�\�NG\�\�$,1\��\�\�@X\�\�\�w�\�\�EX\"�XeU�d��h��L�ǚ���P\"�(\"�ڞ\�$׉�r(\�\�`\�r\";��8IѬ�=��k�ڜIMC�@\�ԼgDͬw7�e\"�Vh��\�f܍\ZZ�rNtG^r\�\\S��T\n�?\�E�B�UϠ������\�I�M�x�̝\�YU:��\�H�Q:�ӂ9\�{�\\�\�o��I�\�{.�c(�{\�\�\�ȬP\"{)8|�\�\�\�R1�U�V8@�\�X��������\�VUaYt�N�EPG�<	�	��z��;(\�|3\�qX\�Q�Y-2�L�g�@����c\�\r�4\��oٌ���կmŋ\'Yݢj�NM�ϊr�M��N\'�(�(Y�M��\�$\n�?�\�7�1\\V�(\�v	�\�Ybܿ@%9#���]��_\����,��\�\�\����\0�7#�\�*l\�\�\�\'Ȃ�\��J\�\�<\��l�̩h�Q��\��\��4$*E�\�5��\�X\�/E\�T-Sk�08u�fJ�ܪ\�{tPEz�lrC\n\�@;Xyׂk�eai�Hm 6)*\���[��\�6��Z;�J��I���M�\�uh�S�|j���\�O\�!\�^(��,�\�ORf\�<WI\�2v)U;�K<)\�x\'S�vy#^\�F��\�\�h�\�5���Bl\'zIc��\��\�\���+�\�\��\0�G\\�p]����]���V�Ϻ��\�\'!8�3X�\��T�bC2sP�Y\��t�\0\�(�{�n\'��\�\����*�T*\�]\�\�T?U�!�Xb�D\n�J\��U`�V���+��@L�i.|1I5G��ǉ��\�w\��Z�e�1�\��\�䚳\�T\�\�E�\�\�?\�E�t-\\j��v)�D�\0�&��4�@���\�v)\�l\�謼��W�v.\�8{�G>��ux*Q`�~b�hw�P\�w�V(Pϸ]����ke���7��\0\�\�no\0W�\�\'C�[\�o�s\�Uf�袣��C�rָX`�PV(%b��X�\�ҿ��\���1O\�X-a�=����\��\�\�U`\�ϒ\�\�E\���P$��\��4\��N\�\�>�\��\0r	��6�\�\�Ru{\�\�|�\�P�����v�� \�\0�\�\�o���珂l8��\�\r.\�\�\�ͳ�\�\�0��M�\�D 3fc\�\ZtK�R���\���{ØB\�e�WK���\�ӑT3�\�\��rP�\�k/� N]�r�\��,.iZ[�*\���?��\�j�x\"�+�x�����l�N�GT\�F��w#\�O\�	��Q��Wif?EXЄHwX\�\�ED�\r\�̐FZd�D&\�(\�8�T�\0܂l�C\�d5\'`\�6�Q3଼��\�\�ռ\�v6\�\��\0�\�\�\�+�fg\�F19�%�B[�ޜ�<�\���g\�B\���\�N�\�,\�6��C\��\0/k\�B�424YpF�PS�F�W٢\�\�ȧÇ�1\�\�G�\�\�i�\��^Eh�ņ\����e\�\�\�\�$� �\��\�\���s\�Z\�E�O�\�gX\�\�\Z=�V�P�ZV�XeU�U�s�B=��=\r�zj�O�L\�$<��\�\�q��M\�\�2�\�n�_O1w��qN��\�C�3�?yW$n欀��6�2a\�y\�י?�\�Gk�A�\��S\�Ya��t�#81y?� �mZ\�#.NL�#�	o9�m����[K�\�\nqR�K>>+:�\�e\�Y��\�\�/U��.�<XX�\�\�|\�3�\0�9�6\��S����Dg~d\�\�L�(�{�Fr\�O\�T4�P�8Ebo\�wUV,1�IiUaUaY|S�XӤ��^�\�95e\�:��Hg�}V|1,%f��P��\0\�m;\�&z��\�1Tr\�\�C��2\�ߪ\�.>\�\��!��6��(\�\�VG��������㙻�Q�bz?�Qx~\�n\�\'�>�&��\�\�4<%\�Bvf\�2w\�L좷NO�4\�8\�\�\��\�C�\�]&D\n�K�K.+O5�\�z�5���\�Yt\�\�\���W�\�%���\n#\�\�\�\�\�R,l\�S$��bxz;F:b��Nw?�GuH��[\����,P\�&}d���=ថ\��j���\�*�n��O�Uc��G��%6�\�\rO�mV|S�V\\S�(k�j%V�ꇉ\n�N�Q0�2�j�eY&��PtY|\�F��.\�K}����uks�h\�\�\�k��\��K{V�V�,)\�-0?T��\�(��\�\�_t\�\�):|�B\�\��֓l\�4/�nc8�Y\�<+\�}\�JR\�@��5\�l�vXU�]�a(M��\�.:��5��ᚳ��N\�Yq\\rY��rMdHW\�\�k��pO\�X�\�\�՜0��~��*\�a�J\�5�*��\�\�{.?\�\�\�\"\���M�\Z\�fV�\"\�Xj�ʫ>��\�\Z���U\�a�}\�\�a��T�\�eC�.4\�\�;���;;\�`\�\�6�\�7\�j\�U\��Zx�O´�T:&\�>�5u��a�ē\'\�\�_1�#\�}\�\�p���Q!�G�\�}\�\��p�\0l_��M$\�GuE,�A�q\�.H܊8\��!X��ޟ{�o��\�͞j�M�\���wTo��\0d+\�F��\�\��YwW\�\n\��b\��χFK%����Z�\�XN�U�}�[\�G8z�F�\�\�x��iX��	X�eV�e\�T-X\\�\�Xb*8.B\�UXVG��h|#\�\�\�=b��9\�\�\�+�Дw�ە�M7�Q�XP���V�7�\�\�\�X�B3k<+6T\��J�\�3Z��\�Z�w�g\�<S�qQ0����\�U�_1�k\�M̓|×<�\�\�\�\�\�T\�\'\�B\�\�/�����q5ƀ	�\0\�5f\�$譴2\�t�-9\�B\��c��\�eح:r�\�\�\�&\�ا©\�\�\\0\�\�q!�\Z#��Yw�ϊ\�\�Y�Vj�\01;\��kOǂ\�\�{tY�Jk6�EV1b�=\�8/��G\�]\�G7\�a��Xb��*�\�\�-\�U�\�V9w��G��E+Z��X(j�U��\n�9�\�\��z}:��z��2�\�\�ը��n\�\�Ni1=5j\�TگT�,�&��n]�+m��\�:wTJ\�wT,\�qw���Q1}rU�\0ڇU�_1�,�\0,t)�y^F���\��WŚ\�\��&C�\�6a�Rsb�\�.��O��j/8�f\\\n\�\����)�]�7��e\���9s�q@k�z4�}\�3ҍNAj\�!��\�d��5?��N\�^��K5�f�+*�1\�V��0��\�*E ͼ�\"�\�8ҟT\�|I�l8S}\�*\��+�4�����ޕ�PXa,P���˺���\n�T����\�Ҵ����\�\��\�zusY�J\'=!V�R�=���\�y+ͨ\�\�8d�D\�,���y!^*%V}\�\�K얌mu�\0\n48fm\�#��T<?L�pw��N�R�\0\�C�ދ/��f\�.�)�\n5�\�\�\�\��\0\�u�N�/¬R��.&\�r[�Xj�\��\"\�Y�p�&����\�s?\�$\�mƙe\�a\�\�\�p�%�9�u$\�O�HbnH\�4Oy<֓�q\���\��\�\0Z��C%�d�Y#-#17j\�\�h�g\'�#8\�Ky(�\�c\�\�\��L\�\�|�\�JlHb\�\�&�F\�qb�\'\0P�\�\�<�\�QD�\�U�9�Ekr\�V��U��Ub��3\�\��\�\�j�\0�,i\�\rS�-23\�]vc5y�\�A>��\�i�\0D\�$0�Q(�\�T�Pe=_\�|�j\�X�\�\�C�ދ/��\�\�mu�}\��p���bb^\�������\�#zBx��n�N]��7�B\�?ě��{ks/Ągnl�9�\�6F\�E\�;�\�@�֙B�\���5x&��R�\�Z��3�h����\��Yr\\x�<i�!��2$W��\\\�\����1T��*=���W�>w� \�0\�>\nng\���g�e�\�&�d�\�~\��ꞷ\�)�]��N��\�D\��(�1g\�>���-\\S�/D\���3\��Q�<!h\�\�쥒ϣ�9o��ZVK�\�Vj\�\���FK%�A{_t\��䢖�(\�8�h\�z#z,&\�M\�\�\�Bs�.L��^�]����\0�t����\0�\�i!\�]�\�\�\�4ą\\50�\�\�\�\�	��\Z\��3	\�I8\�L�\�;��N��k��+Ox+8��\���qԳ9��\�\�f�Y,��\�\"D��\�{��[�컅U�+\�b�}�a�C}�uf\�GH��\"*=f:4�AZ\n\�VJ̛��O�T��*/A)�EA�M�Qi\�6�O�&S�\�Q3_�C��^��(إ�-t�\\���\�:�\��u�Nc� ��j\�O�d}�\�m�L\�\�B�>@ﳶ\�\�,6�M�\�0\�)�g�\�C�+\�(:ArM\Z�j�7?�ߟ9�#Oi���\�\�\��S�/\�J8x�}\ns\\t.:��T\��a>+1�\�V�KJ���1��\���\�Ts=\��~��/\�R2�eH�Q\�Y�d��+v\�w�\�}�EfV�-\�[ũpUU��\�X�ՐS�>\��Ꞵ��oKS�\Z�Md�\�\�6�>)\�K.)�V�ꇇ��\ZK�(��Ћ��uO�\�u[\�e��7S&\�T�	`qC.]��3F=�\�\�x5F�h�\���䍫m64��Pk\����ՙ�49���\��\���`�H7\� \'\�H\�\��3�w5�i\\5f\�x�3Bˊ\�r+.K#\�{tYS{Q����\\\�z�B�r�D;\'U�\�\�\���W��\\�	\�5z�$/_�UX\�XAV�5V}Z�.0�\�G�=Q\�Z�d\��\�O�T�[\�\�\�v���B��QV\�lʰ\n=�@�\�U9�\'V�＄8�\\sOLp(� \�\��\'���wa�S�!\�%�ԇU�_O��[0V�[۔\��N�*�}�\�\�.\�.\�tF¸\�n�\�ͪ\�\�\�ټ���\�\��\�/m9���m�\�=���\�]~���)69C`�C̦\��5B\�4.��\�\�ZN��\�;\��\�@\\u-G\"�rZ��\��A�\�\nZ�}�X\�]\�ʎ��s�w\�^<�H/\�n\�͝\�}\�x��2�\�\�S\"���&��% \�1�\�&:XZ\�!\"A�T�e$Z*>���u��kZ\�p[F\�\n���uOV\���%�o�\�7\�n��An��\��[HD\�\�EX�;Y%i\�TG�\�\�\�\��d(��ܗ٬Ԁ\�?{�u[\�e�\�}\�\�\�\�\�?(Vv\��\�Y>6�\nN\�M�q�k�d\�wTx{E��1,\�$\�a08\0\�\��؆\�\"��V�A\���n���\�J4:B9\�B��\�t�]\�ؿ��Y`1�\�\�W!\�i\��W�v~idc���\\2��K\�L\�J4�\\\�=�¯yJ\�\��\�<���vb\\B-\�\'\Z��\�Qp�\�r\�\�\��N�\�پU\�L�akXZ\�\�\�\�<Ն�֮)\�4\�+>�* \� �\�&ѣS�/�Y)f~�H귢\�\�\�%�rg2e\� �h���� �\�\�#\�m��\0����N\�\�J#�7�\�j,K���!��\�d��ow������&�9\�>\�lI&\�\�\�ӻ�8\�Af5!��\�\�Y\rAY��\01?������\��\\x�<g�\�\�6 �9���\�(kCa7\�V\�V���-\�\�i\� ���\�{�_UG�U��x��kPY��d��+Bd\�sC\��\�z,�K.�j\��~J\'�n�\���\�5�pp�@�VU�4\�\�0�52Q3�@�0�0\�\�?ҞܢHK�OW[�\�\�K\�M\�\�\�\�V�Y�:��A;`	/����%?\�\r\�kF�/(_\Z\�\��c_eǼ���N�^ݐ�\�q\�E���JQ\�s��\"ftB�3�ߋ�g{c6e��!\�Z>�\���g\�4G�\�����)���s\��=\�|\�\�gR�S\��\\֡�fv\�W�o[췌�Y�w���\��[��\�u�r\�9nܷnZ촟e�\\W�Z\�\��+Zֵ.�\�-+BЯ|#\�\��\�*�\�y&�(�n`+�B|(|á�2�K\�e\�>��\��*&�Z{�$\�\�DlAWh)�\�i��gg\�5���dë\�p\\Ad�Y,�K/��*\�踮+4$]k7`�d�f\�\�l3ے�_.�n\�f��\�\��\�$�Yv҉Z37U��y,\�p�\�[b�\��\�K �m\�ވZ%\�h\�403��\����E��\�F\����Ni���\�r�\�\\\�\�\�v#�\�\�v!Ez�h 6��q!GZn>%�a�\�5f�\�\'\�Z\����\�\�iVm��<�k$\�3[\r�\�\�H�\�t�}�\�%Weu�8�)DcB\�\�=��T\�AU��Kv�-+ ������0�-KZֵ��z}>�\�P��O$\�$C�WH\�3.����\�\�\�\��TLKWuCġ2$�#��Q\Z\�!7qN\��\�zt�\�{(�\�\�([W�V}\�N\�\�`ܡ޻?c��ǎT���L	�UY0\�/\n(/Ǵ��s�䭱�쉿)rࣳ�\�4�\�C�v��\�\�K\�9�.h�)˒�8μ1U����\�&���P,�n\�9ͩьv��&�2�N�\�Ca�Oem&\�oy�\"7�W���w�}�!��p�$p���a�b}\'�#L�\0,�\�+\�׺��\�L�\�\�\"\�]2\�2h�[6\�|\�\�w��F\�Z$\�\�ht=i�f\�hȔ\��Q�JY���2W�������\�\�V���u\�\�-?��uOV\��~J\'�o�!�]��\�:�+\'�R�J\�J����)\�?\�G��r�M7<H#\�d�r@�\�oE�\�]�\�NAD����\�B\�A血\Z\��d�͚�1\�\��snTࡱ��X\�mp��Å;3gC,)� �*�\�&��>	�tC�k�&�@\�\r��S\n\�D9�����[#\0�׫\�F��b\�W���X�\�\�[\�ܠ\�\�bN$F�	�O{�\�i���nku\�� ſP�\�A�\�KfV\��d˄�58/�<j�\�T\�\�W�E\Z�A@3\�\"q���⍒\�\"�(y����]~fh�>�1Qw\�\r4�-q\"�rD�^#�\�۲�\�D�E�@�e1��f��O�.<�a\��G�Ӫz�o�C�Nh̄�f\�\�r\�zk	\�I\�o̬~�C\�L\�)\�\�w�\�F�g�-���<L�{>�%�\�(��`)\�2i��[\�f�V�6�I\�6�\�\�VSL6�+\�\�%�Z�׮��&8/\�ú\���3b-�\�ilf�\�8\\�|��ge��\�_c[\"ܛ.\�\�5�{�V�Fl(b$(��̈́�&WlC	�qs[_5	�WAi�i�H�B&gͪ%�b\�\r\�-5\�@\':$168\�ϑM\"\��\��\"���\�\�\�3�A\�5	\�g�vdU�3\�\�t�\�\�(��\�WZ��I\�I�if?%���io�\�\��,����mZ�\�uGu�{�U�\��V�귋x��x��x��Zֵ�kRԚg�C\��O�f�T?/�ߙY=z���騭���\�J?�M\�\�Q1��\\���.Ӻx�]�\�5�>�\�e�V�0��6\�%I+>\��\�7I\�d�}���ٺ|�Ľp�\\�V��\��2�[K\�;\�\�\�]���M\�sP��M�\�?��T]���\�$\�i�Ř�R��ǘ�v\�Mɾ5O�@v\�bm\�U	\�Giv�Q����c�\���\�h|\�v\\T=�6�W�>\n%�\�\�i\�7�kf@�o�.���\�f�\�\'|��U���{-.�ZO�\��.�\\��Y,�]\\\�̬\�\�V�����ek+YZ\�ֵ�KRԦ\��\���P\"í\�\"�\�\�x�\�\�}V\�\�_U���\�\�\�?ֆ\�rVX\'[D\�P� ����w,)�;\�&򍇇5��|\�,\'A\�\�<eU	\�\�:�t7�\�\�aC�C{\�ms��l)��g�5Cdg��\�\�\�|74E�d|��Hs�� \rr_���\�n/\n󛅂���q\��譌is��\'�lk�~�{�1��\�戽�̶��1?���E{�dZk\�Dt7\��\0��ֻ�\�\�w���:}��#^)�\�e1<~%@,87\�\�\��7e\�\�Yb\�X��6/\�\'|��\nl�x-\�ܕ�*F	U�V\��-\��[��ݟe��-E�\����\��Y,�\�,�\�.�\�.�\�.\n�=?��uOW�\�X_�\�_�\�_�\�_�C_�B_�\�M�\0\r	NMw4\\�2z��g�Q�{�T�\�C\�曈j柈f�bP\�\�C\�4�\nn)����kO��ԪoE�\�+LH�M�<M�\�b!$\�\�C�N8�jd1\Z\�F߇+�d�-d[\�RR�tWZ*ؗ�n�\�\�.\�\�0�(vG?ٳi���5\�\�ܚ�l\�R\��el@\":lP\"\��d�V�5�e\�x��ݮ\�O�P�\�k���G�hlV�\�z(\�lF������\�\�koE�?T\�H�\��@�%Zc46\�\�\�\0\�]\�d��3\\\�\�sV����$:\\��v����\�3!��J��S��G\�\r����\�#0�/�UQ��4K��H���\�ݫ\�\�9�`9��s�Msy��C\'�-�G�%\�Y,\�X\�Z�Y,�J��n�RsdT�ٕP�Y,�¤\�Ȧ\�^���\�-ӽ�&K\�d�Y,�\�+=8�\0��?�Ց�\���7=j%�\Z�*�C�P�\�T\n2P\�u�;\��Zq���\�Ҭ�\\�����%hk\�C\r\��y�v\�_\�@8�n�JN5\�0�/�~np.��8��5ؽD��ψ\�����8Fc�oyׯ^����.7�Hy y�F�bM�sd\�5u�4\�*�9E��}�k\�.*\�\�ź\�3ۊt&O��T�b���l;κ\�_V[\�[�M\�g����+ս\�	�N\�\�J��kE\�I�咂%\�F�вY,�I֨��2h\�Q{\�Jc\�\�g\�\�(�D��\�Q�\�>4c�\�\�WD�p\�T\�\�a�T�\0AQ]#u\�A1��OD\�p�\�VK/\�.h|#\�\�\�\�g%��\�D\�\�\0\��B\�\�ю�\�׺ \rp���\\q\�Cl4d$�Rr\�^\�\"ia`5(�AY�E1ZS\"\r\�W��\�sZ\� {Im3r\�c5\�$ߟ��@��a\r�:�b\�#6]��z+L\'��sW`���c\���#{�5\ZC�BWT:\�\rI���!�C�ҡL\�\rK!�?-I�n\�ER\�%e�\�V��oH���8��\"��3Qo��t\�J,C�\r�3\�$퐕\�\�6�7\�\\\�Z\�n\�\�j�\�\�N����\�\��9�.�>�\';T�&J��bS7�Q��\��\���\�ќ!\Z�VyB2w+���\�0ޭs�7�o5\r\�6\��n��D��v�\"�60.ý5fp��U\�\�\�(\������D��PB4��-��[\�\�[u�[��[\�[վ[\�+|V�o�o�o��kZֵ�\�-H\�!/�z}:]��/\r%�>,I��-�\\d�\�gw�՞\\��+�Q\�z\�˃�\�Zp\�\�f�`Y�\�*\�A�L���ҥ*�/s�u�ao���\�m\�\�?D\r�\��,qt�H\0�\�.w�V	�3\�\�E/�vb]\���=�\0\�sG\�Y��\0\�F���bM\�\�Q1J-NK3�B�\�T\Z�2L�\�\�f\�i�����gUs\�5f�\�Gk\�\�4)����,6Еf���t8\�%\�VxPXƈ\�\��\n\�d\�\�J�\�\�e\�/�F��S���E���̠\�1��\�_L\�8lvfɦ�\"\�Ut\�\r�<�s�(�\�\�ͭ�\��V�\�\�k_&\�TMd�+�\�\�C\�\n��\�pQ&\�A$����JpQv�\�\��\�\�)�?\�����2lG淯�[\���\�\���\�?5�w�\�\�\�x\�u�w��G{�\�\��\�\�x}\����\�>\�Y�ZϺ\�V�-NY�f囗yw�}w�yT�_�z}:Cb��\0��\�\�j,��r*\�m\��&Csh\�\�\�7Vd�qG�0D茜ݘ��+��	�H�ܨ�73\�5�xr7Q�\'x\�4��d\Z�D:\�\�+�C���\�]�\�ފ\�=�oʤ�\�\�Q4��ە$Ƙ�[���As��ą���������pw��w�LL֎\�%w���\�f��\�5rO\�5rQ$ѝJ\n\�tW\n�:�\\\�5\��ʔ�i\"�V��L�&LpV�@~	�����.S�.\�w\�IZ\�\�6�FΜn��h���{\�Y\�^\�b�\�G\�^\��\�\�+>��Rg��.׊�!\�e\�q��\�j�\�}��!>*\�\�Xq��(\�\�>\�ʳ�M�\"sr�aD\�4\�\�\�G\�_�z\Z_\�k~}\�������b�\0R\�R\�Ե�u�{�\�\�o�\�.\�\�.\�ɋ&���j\�,�\�����-+JҴ-E��\�KZ�	IwqwqwuwVM�Ye�{-?E�\�E�>\�t}�\��-\��C�+rV\�n\�\�U�\�r=\�\�\�tŻbtJ5ǒ8��(x�\0\�7y?yE\�\�\�k\�(x��Aƙ���w�(���J,\�\�pQfOd��\�\����\�T��\�]S�\�~G�Z\�Y\�.&U��\�s�\�S\���3-�\��\�B�4tZ&\�qI����\�\�G�;\�v\�<B�\'�\�O��ň\�qο\�)�f�g��\0���G{��G\�J$W?\�.i�G]�+,[\�\�!Jf��7�\'r�:�\��Y�=FJ# \�q�\��D��\�衒/�n�\�n�\�^���mH�%:���<�2�\��\�˦_d�.\�S�\�?\0��]�c\�{\�rP�����a\�(�V�⇃�T,��\���ﾟ\���\'\�5�3Q$�Â�~Ukdf\�t8\�l���J\��J\�H��#�8\�\�V�\�0�N�?h\�q\�iʝ�u\�Xjx&�\�\�0\Ze\�!�[R�\�\�#��(�#\�\��ӗ>�ڡ�\�+n\�ͼ{�S\�:`8IIA\�^޶R\�\r\�8I�K��:[IJi�\�tRi�\�7�\'\�:�\��Y\����h�E-\"�\�Gǔ1%Dc\��\�+K�\�:R�\�h֛�6��\�M\\���ra�K�0��Ƶ���\�Y\����=c\�gX���w$ٞ)��|\�L_U��\�C\�\�<T<��\�w���~>�7J��ꬾ�\��Q|G�fJ�þ\�\���Li\�+T=��4�\�ZT\�y��5h�z{R��E�\�/	`q�O�\�oK?$\�$Kݰ5HÉ9]a\�i-s\�\n\�>�\��-�����R��\�el�V��[�\�\�O\�m{H�D��Md6�b) \���+\�o�N�􅓖Ei>\�O\�i�\�iF\�h\�隺\�w����/>�n�U ;\�LA*\�E�T`ZZ��6�m[֭�[\�[\�[ߪ\�}V��\��Z�\�.\�\�\�\�)�/�~K%�\�e\�\�0�\�AjXZ֥�EfWyw�ydS�V��ej%�	˚\�\�\�\�\�*i��ԷcZf5���5\�$fsVS:\�G\�Ek2�\�%	�Am\�7���T*x�\�\�U��K�\�g�\�\��\�4KAZ\�~����G�G�\\F�L`���^\�&��1��q\�/ݢ~��Xˮ�\�\�_d\�-\�\�ah�k���\�~\��j�h9ˊ\���h�\�\�e?��ƍ+\�\�rN�GW�^��\�!\�p\�nB݅��KWuwVajZ\�-\�ޕ�+z\�w�\�娬ܻ\�\'-.Z�9n\�\�V���\�R�,�K%�\�d�\�\�Y�\�h�\�\�=gt	�)��\�\�iL�\�C\�<j���\�k\�sO\�\�D��E�\�|�u�\"}\�3ϒ��\�*�\�\��J\�F\�\�\�Oe-��\�\����\�0]��?(\��\0�\�1\�[��_U�{��\�b\�\�X�U��V1[\�\����\�u�}\�uwVMY�{-?E�\�šhZ��,��\�A~\�2�enօ�d�jX[���|�\�|��\�*�~�N/�*\��o���~���븴�\�n�\�T��Z,R�\�qR9�;���\��\�T�:<��?\�KO�x-\�E��u\�H\�V8�*��\�U�}\�k�\�������\��\��\����:���r\��\0AT���Y?�*Y?��\�Ǘ�\�d\�,\�,�ԩfo\�T�\�t{8ae\�f\�ҷ��+{�W\���\�聳\0\�V�.\�\�\�e��-\�\�D\'�\�\r�G	����\�\�q<�E\�\�7sX��Veq�\0먩\�\��S�T�V\�nր���Wuj\�y�[վr\�=o��[\�{�N�Y�tޱ\�jé�\�6I_\�9���t=\��<S�=\�\�pL\�\�6�5Gw�D���\�V������C�\�7�\�\r�\0�R_ҿw�\�[���Z?2\�Vz�b\�U�̼Um\r�U�}+R����[O����9cF-2F�χ�Aƫbm�\��[l%fPg��.��4\�yk@Mlg����F.\�2W�5�\'\�Ԝ\�\�J`k�zJ\�^�2��Q;!�Q])\Z!���\�U	\��O\�dV�{-[��K)4߄z}:\'�jXW��X�\�<$\�*�\�\"ٹ��\�ȭ%7	@\�_��෬E\�\"�͕B\������o!���4*5&1��\n$�\�7qO\�\�Dĵw:�*i�\�G�tB�hqm\�r\��\0Q\\�\�\���\��*YO\�T�}���,6a�����HP�\�\�\�/��L�+{�+~\�%&j��g\�\����(��̵~��\'|��ڭ;�QF#�%��@�H�\�v�C�7�1/�΅8��Ҧ\�R�\�^<֑����\�xH<f\�\�\�\�Ίrvs\�9͆��4\0k\�\�\�٭ z�\�ګ*\�U��\��\0��\���U�\�F*1^?��t1�ʫJЉ�\�e��\�1=�,\�T��\��+�	�ed:\�AÚ\�3\�oǲ��\�xug�oD����\�ܵn�	�\0u?\�\' 9�ӊ}8�\�Z{��x&aS�H\�y��kD\�h}�d\\�\��L�7\�Dsr�\�\�Klˍ��s�d�\��P\�^p��\Z6ڠ^m	�\'9��F+!�qW\�\�ddg%}\�p\�ht\�|\�\��e\��Y+#\�\r�/�3tK���׾�\�5��ڽ܂\�R:4t��A\��\�c�\�9\�V �KS=\�qQ��T`�*����U �AT���\�\��o\n޹o\�;\�w���ۖ\�\�v��\n�\n�b.m�g�ӡ��M!d�\��M�=wy&�&����\0���\��d��ux�\�Z����&\�\�:,�c��\�+5����r����0�\�L�����g_m\�ί�s൑�ZǸN�V\�Cg����g��]Nj��ÄA�\�Jϖ��l,\�\�dm3*\�a@�Ms_&���0\�>�ѭ�	\�#M\�:�k\�[#>#Ƞ�Iӽ5jvѷL�����R\��\�t[<\�O��jF;\�R��\�\�tV�\�uV#UceX걏��O��뺲b\�\�F}�\rR\Z�]\Z����\�\���#\�\�\�\�_�\�\�z\��M�M�\���\0u\n\Z�\�Ê\�8��I\���\0ҙ(QB�>H�\0��S\�\'v�z\�\��^�\�g\��\'Zl��\�\�rږ�>�ЯE���l\�\�5Z`Dc��k\�Fkm�y\�\"Nu\�e)\�ClH\�Z��U�|�ݴ\'\�9\�13fA!B��YwP�\r\�\�\��J^9�DT2fJ-pi\�H�\\v�7D���\�/\�T�\�P^\�$4:f�\�(\�|ç�^�:=&8�\�TcJ\��U �e�T��\�A]-h+��Z��\�\�jx@tB�ʯw�\��v]\���O�C=~�o�\�\�	\�\�I��\�H�o���E����\"E�\��6G��op�\�G�\"Sll�\�C\r\�&\��Z\�9aC�>\�4g/\�N�W����\�:����;d&\�\�9�=�\�\�ޥ+(��+q��~\��\0�\���!Hc��*�\��J\�i���\�~�b��X��\�g?ԩȰY��\��e>�a��V;R�(j��Z\�?*\�Ft\�\�l��\���E�5�7\'ٟH\�q���m�N\�kv��\�rL\���3\�b���-�ڲF�&���Nv\�9\�hM\�ٴ�\"�7��e \\\�yD�?���Crݕ�dHMq~E7\��t1\��V�*9d\�eHo�T��H\�R�NtP\�N�x<V�_�[aU�EU�����\�>��\�&MR?e���f=����\�jw�Ds�g�Od�҉ɵC\��N\�H�$\n6)��@\�\nӎ\�\�\�\�R\�?�\��c���\�>�R\�?_�*A�\�VP�\�[Ə\���\0����궈���\�y�ʽa�m�3z\�\��ksL\�3O�:(}\��X_B\�\\$\�$ȭ\�ۤsR\�bi�/�\�<��e8]l\�t��/ex\�i�x\�O[��\n�hX��e�2\�\�\��Ш\�F*CToFkZ�\�\�\��\�D\�\�ApY�KQZ��oFEh*e�]h	�A96�S�v=cK�G��B\�f7\�\���>~�6ߙ���\�\�\�`@���G٭�\��N\�/Cw�K&UW\�v�,V��1�X��K��\�{,,�,0�\�R�B\�-kzUb9kr\�Hn[��.\�\�\�b��\�ඐF�\�\�E�ZT\�\��\�d�y�Z\"�Dֹ��\"��0���l{�&�b�9\�\��\�e�w�W�\�T��\\^\�S �Y�w4Za9�w��\�\����*�c�#~\���c��\��5V\��1j�9V]�8�ݡ���]p\�\"��{9�Űv�wTV��VG\�\�7\�\"q�\Zg4L��~\0��#��ˣ0��\�52�9�8&o;\�츬�H0ӉZ��[\��\�\�OE\�\r�ʐ\\�_U�G��\�(\�b�D����j�\�k5F��KYZ\�\�Vka\�K����\rl9^+X�U��F�K\�\�U\�o��\�\�8�\�G4\�\�12�7\�ilCox�PǢ�p=mNFv��	���g��Y\�\r�\�!\�\�r$�P,�(�Q!�g�\�qN�\0x�\�E?�U\�5\�:�EY�\0\�^,.\�:$׸@��}VA��\�I֛+eoa\�:\�d�\�\�-K5\�dP��6g�\�U,��v\���,q�3\�봷��\�&�5V\�\�MZmV�B��f�\�\��-��\��\�\�L\�\�\�@<ʫᅊ8�X\�c�}\�\'4�e�����+/�\�a�\Zе�U�\�X��Z�Ƈ\��}:\�\�Z�0�aRU���&�����}|\�_\���L7I\�8d\0�\'���\�\�d��Z��	\�<\'Z썓��\�\���1a�O\�Xl\�?Bܑ\�@B�7\� ]��\�\�α�у�A*�؎�a,\�o��H\����~\�o\�z�`��15���P\��^M\n����\���W�����\�oVϰu\��V;�\�q�<\�\�\�J�J\�J7X\�/\�\�{*CrݮbxX��O@\�L!s�\��\�g�����g�\�$\�D\�3\���\��F�jY�\�d���\�\�f�\05\��\"\�2pX Y[��\��7\�`_�\��X�\�?�bs�\�C\���m��ղ�MvE\�kg3rr�\��ֶB�\�\�Q1�(\�]_�F��*B�\�*\��F��2\����\�j�G�\�Ņ��TZ����?ӡ������\\��sL�[8���4���\���}#�U,�ee����-�M\�xʥ@O���\�;7N�\'��C�\�8!�\����\�)�+6隝��Wd�1��G+�\�JW\�T!4�d��lZ	\n#y��jUCG�\��c��\�>\���+&,,\�%��\0Y���V#�^\�u�ţ\��\�g�\�j\n�\�[P�\�!�Nu\�\�*�0�\�h�=V�Um�y,V\��*ǌ\�Gy�;r�d��~K0=�ʯw��\�@O��&\�mn�q���\�qE\��T\�2>\0�C5�o\�qF3�.��ȄȖ����X �\0J�\0�0G��Z�J����\�?\"�\r\�\�\�4\�>�\�5\�\�\�<\�i���\�Q5Δ�N2ӢW\�\\8�\�yZ�V��*1��Ա9S�:(\�-?Tt���\'�~h�Î\�P=��\�\�eg\�X]\r�L�Y\��u\Z�\�_�ܼ\\|,q�\r�/\�[��ec��o]��\�<��ۜ;LE~\�d~\�i/)ψf\��*Cw��\"�^*a��X�,N>\�Xa��1�\0��\�QE�\�\\_�I\�*�]��\�m��@�P4	\�t�Sn�\��|2\�\��U�\�\�_e\�U\�Ȫ4����\�Fkj\�\�\0��\�!E\�ï�\�Rwz,68�\�R\��T�����*\�\�@O��w2#v�g\�blX.\�Y���\0\�z�X\�\��f��V\�\�v��\���.\����|�X�\�w\�\r�q=�\�`{�x����guX \�\�\�ž���\�\�b��\��������\Zx�j˓T�=�_D/Ô\�ph\0�\�\�IҢtXN\�\0�e�\�)��فT\�wqD7����so�z\"wiU8\�af�r������R~�E\�	�%K;Ϣ���+��K%WX�E\�|\�Ȃm��&�Cjn���ȯ\�7\�V8Ac�?\�\�b\Z(~��g�.���P��?�:f\�,\�\�\��Tm���,?�\�\�*\��\0gYG��\�\�\�\���\�\�|�X�1O\�X�\�\��\�\�P/c�0�Bd\�9Ml\r;�a\�(�+|ܦ[\�m�\'\��Ӝ�%\�\�\��<�~\0$�^�+��E�\�>�;\\&\�\�4\�\n�LN�����4�\0ۦI\�wHCt��1h<U���\�0T70Q�\�k3Mx\ZD�j�*W��I�ӡ��YtN^+g,Nq�Z&�#�l��\�z\��L�M�=\�\'��Q\Z5n<\�\�(hl\�惝�bkg\ZʁY��ct�2�\�\�f\�d�%�M�l\r�GJB\�\�H���\n�=S��C\�;i��l\�\�^Q��oI�l\�X\�\�x\�|��vTNd\�\�$�C�\�\"S�\��.^Q��?�x�=\�\�*�}ka�\�\�Xa�\0��W�ѓ\�j�\��g�C=~�g�\�\�3\�7\����\0���\�?�u\�\�tN�,GD�����l�V�Wd�#N\�m\�����K!��l)T\�D�!\0:��c=�c\�t�\�\����aRR	�m{\�^{\�\�u�]V�# �qn8��(v�\�\�%\"V�-伕c?\�L���<��Tx\�7Ĥ�\�n\�I9���U�U\��{���\�\0)\0\0\0\0\0\0!1AQaq����� \��\��0@�\�\0\0?!˄�\��d���𨄐��P�sI��;��\0�\'\�E\�`��B\�	) ���\�\�S�\r\�!Om\�\�~\�;ke�+.0{o\���\�_�� �8-��G\��\��Dw��\�1\�-\�\�]\�>�j��\�$�& sALĵ���\�\ZrA�\�\�,R�Q���t3Cg�øJecr*\�)\�:;�*���Ι3Lt9\�9N2$\�22S\�\�(�-Oa��!�Rb\���fx>i씸(��됸�:�,��\Zp\�_Y&X\�߁~e��A�6\�2\"��!T���\��?�@\�\�0�J\�\�;\�=*~H��\���%�\�XԢ)|�r��e�h\�*�\Z}\�A%�\�\�����\����\�8\�\�~g��G�,�ۘ���\0qr�\�cs�\��\�\�B\�p�b��֘zs\�\�1��>%�=\���($o�%�B��9\�#�\�Ӆ�(�\��p%I{\Zʜ�ڍD�-�2�1J���es,`\�G0H�RʦJ\��\��$@\�\\__���\�\�$�9W�\"�RI��\�ā�YB\��2H2TPYfC\��K\�v�\��v\�P\�\�mLꄭɓ\�\"8٘1\�\��6�&���r9~\'�,�\"\�gA�$���`�\�J�kt)\��Өj4\���R�@�<�\���?�%�\�Q\�3)��d�\�| J�\0�z�C\ZY�\��ƚM9EGJ��m\�3V\�N\�`��p̿ҍu\�9$�\�Cl�$28��\�V�-\�4l�4\ZL�3G%D\�cH��Ť\��\Z3.�!��`\�����	\�6\�a\�2\�%��\�\�Y\"����\��\Z���@\�s�b\�?	��-��=�GSǑ7\�\�vۑY\�4\��;\�~��$���7\Z�,�7�ȟ\�\r챽�L���ι��pY�y_��Ϡ��R�$z�ڦ\�8���;�/\������\�ϧ ��ŐAׯ\�\"ߒ�*�JtG��z�Bh�	8Ѝ=����v1\�ӓ�(P7�1Tz:J�@Q1���`��]\�t\�zVf\�ز\��8zJd\r�j�\�2\�[�ӣ@<Ĉ�������rf\"GŘ�8>\�\��!\�R�:�\�l\�\�\Z�_ �\�>챎�($Wv��S4\�\�`�F3�z�!Nz\r�S	\�R��\�A|�nG/�%\�\���>\�\\\Z���\�@�\�4j�4s�\��\0�;>\��Ѱ\�\�]\�j\��?�_a��S_\��`U섿���W\��\�\�p���(K�O�f>��]\�\�(�\�-��h�]΍>(\�k\"k�b\�q\�nM\�\�OVM���2[\r3\r�\'���ӊ\n^\�5Ц��ص\�!NK&\�d#|���\\h�P�\�\ZS�|��Қ �\0:2#F\�(bDi6�d��ΣB\�5������\�e�\�\��\\\"\�#��\�\�$a%�\�X\\�n\�.�B��o�8�=�2\�\�Otd\��o6y\�\�3\�n#y]\�u�9��7ƌ�\�m\'tOF\�Ǿ�\�L]MxApHW�a�#T����^Ў燖IwK1w\��\��\��\�\�^\n����e\Z�$j\�\�&B@�V�\Z)A�G�\��8�˘Ќt\�#f\�\�,�)���\���\�^	�1��c\�\�\�~�-b�\�\�9�q�&Xg6���K\�I\�d��GFu��b\�)�ɖ*\�\�D\"�:S��L ��F�q%V�5\�\Z�%�����j��J-�\�ʭ#}J\�3�\'Pd�n0Tx��\��Ӌ/|8gT^�+\�7�W1^?�\�ηT�\\\�*R}\�\�$@\�\"�\�CI[?\�\�\0��v\��ƈJ�z�J�>3\�G�D5�RO\�4\�\�\'aыC&�����Ө�\\O��joX�C��IGh7I%w��6-�j���\�\�D2sdV�w��bQ�\�# �ԑ\�T�4gqj\�.�놇�\�\')Ƥ\�[3�\�P�K\0\���\�غ1�\�\��Bx\��\�	�8B\�55>\0�K\�Ʀ:D��)K/`�\�M\��\�7>6ȩ�Y9\�qw�x\�\�=AI:Q��\�qms`\�nKB�\����\�cqĄ\�K&\"t�F;z�AF`��-a-w9��Xg��Y\��>B�m�9P\�^80[_UǅU\�����D�\�6�m\Z\�h\�T��\�\�\�(h�\�\�Qz�c�WA��\�_\�EL\'\�lww)���\��\�,yшeP\�\�\�m\�^E�K$ݍ\�\�vk�+CT�Ya���{�=7f\�\���\�_�[H\�a/��\�x\��(,v��4a�\�V򺞸�D\�\�4\�rm�)�pij��ƦE���\�G\��a<�EB/�J	1p�\�Ec\�	�hB\"X��E*b�&dJ\�){H�%�C@J$������\�M�@v5H ��Y2�\�\�u�,��C�\�B\�\�tOL.\�E\rlB-@�7\�\�j=�\�\�VB��\0a��Sp��rrqM�\"6\�.�\�_csl#F�kԦ�wc�V�=\�D\�	)2�.�]����[�.\�Z!2�#\�t���3�9�\�A��\"\��\n�WC\�\�/�\���CCq��\�X�\���9�8%B\ZGM1*M1d?@\�G@�K��\�\�e=<\�z��8t\�\��̊��\�Y8m�����-�.\�Y\�FMT\�\�ؠ�X\�QBy_���[�\��#5\�j-�hE��FA�\ZǁV4\�\"{J3U!$\�A�2�\��r_A}\�\�\�KSޞ��!�+�4�޶��-Ʊ�ې\�S(�/�lD֤�����\�j/sP�\��w)\�5��p V\�\"�y0_D��\�]�ڷ٤\�\�ķix!u�O@\���$��5s�.��\�1��GMGM4\�\rS8$\�	�I1-\nk��s\r!��mt\Z�\�\Z𢃮Z��JzCC_�A\�\�ş#A����(�٦d>���\�C��A�\�q/hcL\�.��c!z&�R�l��\�\��\0?Lz��`(\�ю$\�&�\�>	��4|taL\rC\�:B��\�yi\0\Z\����Vu=\�\�ē%\�Ƈ�\�k\�2\�nقG2̝e�LMP�\��+�r\�0,\�l\nr�`q�\�\�\�!qK�	P����CYc$PՔ\�!��i��0�Z\'��\�NI�l\�\'2\�\��+fE��O&K\�Tq�Gb\Z�ټ2JɄg=\"\�?E�.GCbߑ���BqmY_\�\Z h\�t�<�\�d\�G)�f����\�j\�\�&��bᡡX���AD���c\�e�揀L�.\�/m\�\�]�Lb0��#{\rYe\�\�G��`\��5��\rQ��%A+E\�Sc\�\"%>h2-\�\�ê�V{-ʹ�	�9\�P�/2[P�І%��)d�F\�C�Q�%\��\'���\nr�\0$t��)O$����Ɗ\�\�+�],�7\�bco.(\\4�6���\Z�c%bYU\�\�MLh���B��P\�&��\0\�o}k�О����������l�%ji�\�3\�\�2C>�\�F|\�J�\�\�\�D1ĕ\"��\�I8s�\�\�\�\�SEL�Q�\�D\Z�eDQߎ�\�\�B�0/��`L�\�b\��\�pg[�\��,\�u�4�\�*f��B	�1\�\�\rE��\���(s@4\')�\"0���j�2�_�\�)\r�b��\�&\�\n5)�qCI��(�\���36g6��\�����\�y���ο&E\�;�:���,`�з\�sKU�Ph�-���\��/L�\��O���\�CӞthSMpKY\�rhhBe�_-�er\�t�\'1��$%�?\�?�^֔嫓 \�s>\��v_�p\�,�\0��\�\�\��\�G�\�}�A��\�\��OC\�ƞ}��:��\���p:sҙ\n�\�\� �(h\��|\\ �,��\�B ȏ\�,\�(\�A[����s)zMJ!�`ԑ\�(f5\�\���X����}1�\�\�voT6O\��G\�	��:V[�uBd�\�Km\�YI�{}ї\�yf4*H\�s\"&\�Te=D�̬��ѫ� D�\'/ù�=\�&��\�\'b>���\�]\�C8I�4�j\�\�p\�\�\�/~Ncv\�X\��\�H�U+��m5!|�\�\�\�\Zi�s\r2����M\�g1�߁1�Z�\�3���N@�Ԭ->*5�ez\��!D��\0����~��M`��z���gF\�\�b\Z�ha΁F\Zir�rT8�Kn9H\n� � N,\�\�Qe����H3qnj%\r\�	G%z#7��.�҃`�k��\�:^\�2�\�\'N\0\�\�S8\�2I�tI�;�*��QF\�5I{A���@IF L\�\�����Uk\�\�3�-\�h2$�KY՜��ZP(���C\�_I�\�\�B\�n���\�\�\�\�b\n/\�j|\r(\"�o�k\�\�G�\��\�9\�av��J\��m�cR�i�\�6:�c%P8�ӽ	\�\�e��?�\�B��v��\�\�iL7\�9�y�ԝS�^c\�4\r\�Ԗ R#W\"hN\�T\�\�\�Z\�PEѶq��S��G�#Lmj/.���T.�U\�	\����\�uCn\'�\�\�\�%O�e\�\�}g{D@\��ߌղ\"�\�\�	�\0(bD!)d%�\�T5U\�A�,Y\�G�gL&\��\��`N��\�:8	\�5ȥ\\ű�C��L\�Y�\�=k�=R\�r��^�E��qlD�\�)��7\�1<�wA\0��P\�\0\nP\�-lJ/�k5��\��G��ݏ�\�H�\���\�cBe	\�\�WB5΅�v�\�\�\�\�	�j�\�\�~�E���5BH҇�0F05�Q�̦�A\n�I\�,�����\�\�G�ß+�}�^+%,�sqr\�\�C�^9��25x�D�\�5�\ZҰ;AB̟C\�%m:\rf{�vp\�R�\�^�U\�٨�D��4{�^���D���I6�Й\�H+\���4\�c�ns\Zq<\�wR��kgDN��>	��\��.\�\� ��>,�j%pf�IRБ�\�#vM\�@��2�+SF��\�\�\�0���փ\�\�\�>f�\�*!I����\�M��nK\"߹\r�q��\�\Z��053��\'؛\�K���\�X�|��:�jߑ�I\��\"\"�	��^�A�t\�B!��\�Y\�\��YY.\�%CW��\�D44lC�����-ɷ)\Z\'��w\�]�A�\�\�ZI���Gٍ���Z��x5�\�C\�i��\ZL�\r����rp��*\Z�\�飴\nɚp�\�\�>H[#Z\�v��S�\�+B\�R>l�+h�\�\rΏ�4;-�ù3\�r�,\�z�f�`�q�Ӵw;��\�3�WF3q\�\�&�\�\n\�o�>�D�:�3�!�=\��\0p�f?\�߂�	\�4\�\�a�,��6x����	\rY%�Aj.�	�v\�TkR�qe=�E\�.9\��\0A�h^Ety�\�^�&��CW�\�|�Y4\�\�έf\��za9J�HCqz��L\�`U��+��ݥNOu�T�l��tN�j<9Ȝ�Y8�I-|#�\0A\�;1\�\�Z\�\�ˣPm�B\��K�M�\�\�q�\�\�(\�ܕIU��i\�/�X����|\�\�#�q��I�\�M\�Ya:\�\�4����C�qŃ\�Atv��!\�>MH\\\�\n\�Uӡ�|荏R�z�֥&z��v\�2E�\�\�g\"\�q���^�>e��nr#�LVj\�v;�vBF%�0��\06\�S.�l\�㇢�b�\�\nWl4@� A2@\��\'\�i85#��OaU7�\'�rcG�̂\�>�7j\�>h��\�~&	W&�\�A�\���V\�HR\�y#	a\Z\�Y�*�_@ޯ�J;\�5n,v\�);���N\���懝riv��1)7��J7\�+�\�\Zŝ稆�ڑHHO9wbZt\��)\�\�ʵ\���\�E\�\�Oa{X\�\Z�Y�������eL<\�9c\��i��Y\�:\�ň@մ�+�\�k*\�C\�${\�.�:S\�\����>t�\\ü?\�K�7B\�\���R\�/�{���\���p�M�\Z\�ZPo\�`\�wiAx�\�h\�\�\�0J`����f-�\0\�,�;���\�e\�G\�\�%z�I\�C \��\Z�$�\�*\Z\�ge\�RÆ���X�rF�Z����2\�p{���/3��\�A��E�\�\�v\r��\�|�282�q$�j5!!KX�\��N�f�2ҍ\��ƙ\'5�N�\�1x9\'\�`\���MKLKC\�a%�7�b*L%��!���]�\�q�\�\�\�D\r`ʒ\�\�\'@\�\"\�̪ʹ\���a\�kRnb�\�\�&���������iI��Uˠz\�肠\�9r~ƹ:\\�QF6�\�\0�\�\��%6\�C��\"�-e�\�_\�\�p;\�ب?.dΘ�\�7�еkR\�n��jC�+v�x���\\\�r\�\�ba�jce�v!- e\�\Zw$,�PD�]\�\�htS�?��Wq�\�4\�4f7џ&\��w\�\Z{pc͇-\�4@\�%\r�E�4�\"ψ%��\"�g�=8�M�n�\�q%i\�PR�b�wEEZ�_��%Ԃ:�\�$\�\�ƕz	\�^y����\�`�\�nT0v�C�ߡ	\�\\W1U\�XME��\�eѾ]�>���һ�48�v|��\�\�8v;\��v\Z��XЮWDC\Z�Ы\�&�o\�[�5\�[��D\�%\�\��l8�\�\"e\�m��\��\ndpX����\�V\�9�\�M:ۓ@rLN�`W\�N�Y�\�\r)\�\�e�\�Q\�?\��\��ӑ=j��\�\�4{!�kQf2\�\�C�\�5(�ì�\�3|�-\�\�\'�o�,�\�\'U=\Z?\�<\�t\���jy����q{���a�cg\�bq�dE�ꅔq\\\�\����6�p��]\�4�0��9\"Q\�\��]\�i\�a����\�y$c��1ĕ|=\"8�\�\�b܂)E;�͜1�f�\�\�#Z���.� +�N���J\�\�s\r�\�c\\�\�S��c�\�~���&�o\�zA\��9EƋ}р\\(rʺ��Z�4(�.h_!\'�\�4<�\�t\\�,z�jz���C�\�B\n�k�\0	^�����3^\��K6ƹ\"H�\�\�ʌ��e�\�^kU3\�_\�\�0Ț\r���$\�.Q��\�a\�罣PvW\�W�\�\�\�3\Z&;E\"T\�Mw�B����iLF|�=�\�Ќ��\�37!Ű�\"�\r\�\�O\�Jr!`I��k��b\�*4�lWIa�?����y&�w)\�K\Z�`\�X�</��\'s@���S�4L\�<zqS����1�K�\��\n{��P��C<2(\�Dîx\�(s`[\r\�\�\Z�k΃�Q�\�\�n\�A�j�E8��!J岵[��\�u\���q���v�\�m�68\�V��d�ݹ��\�\�\�1RIzN�\�<�5,�\� \��@��\���K�U4U\�M\"(Ё\��ݍG��\�t_�\�UQ9�����H�at\�I�̓�m\�\ZqGlG\��@\� \�\�\�@P�\�b_\"Z\�Z\�\�\�/�0�w�Qm�ac��,)\�.�i\�G���\�]\�1\�\���n���\"Id�\�h��S\�!oԂ��?�DF�e\�cQ&[\"���e�jo�}P�|\�\�fT\�2\�b=\'\'\�mv	���Q�E\�)X��!c�4\�E�xc�\�\�b���\�Q1�_��R��bDb\"�Й h@�E�Hy\�\�e�$m\�J2\�0n\ZAT$�\\�˨��gzV@\���j\�\r�E]\�\��\�a\�]�yj,�\�\r+Mw%8��Kۂ*\�\�;�\�^dLMm\�,\�NwJޭ`Z�x�\�r\r\�g�Ȅ\�C��rOp\���\�\�\�p<��\�\�\�A�w���\�O>\�4\�r�wr=\�\�mDO<�j��e�_�_\�^�QQ+\�H��:j_�7|FHl�ǜ\�\'\�\�8\'�\r�\Z��&2\�B5mu�\�ۇH�v�hZ\'BmѶ�\�3�\r)wȈ`:��\�a\�^C\�Hj\�\�yHA�\�\�}f��\�o)�ףu��g:�\�ٿbMZz:�w�4e\�b95��f��g\�N+# ��L�C�e�M\\\�d\�|A1�$=\'��:%@�\�`�\�\�\�R\�/��\�(\�3tbO�\\�UL]D\��r���\�K�$Xa{\�r�.�f���\�j\�	z\'\"��\\�\�\�p�ts=\��V`\Zu��؝�\0\"\�һgb�\�D\�)_\����\��MQ�t=\�ӪcDb��ؒr��\Z�l���M-x\nr��kfx\�\�.̍j�\"iRӓ\��Hl\�o?\��ɗz�9�DW�&r\�\�\�ڷȇ��u�)\Z�\�9;+p2�B4\��\0HIN\�K\�끯\�\�\�Xj\�a~#\��7���2��*Z1\�#|��\�\�~�0�\�(j@\�\�X�P�\�\�\�&�\�?���\nR:�Ä4Lܣr\�\�\Z��y��Q�\�lC�\�1#c�\'\�CDP�\�@�D�ՑBߨ�\�\�*j��џ\�xx�\�;�O�k\�_�����\�\�5�$\�n~c|����N�\0#b\�pP�3?!@���b3^\� H_1{\�1\�jŵ\�|p�[�s\�G�\�Ng$�e�nN�qб�$\�N	ä!\�L��J\�e�%>�)�K���gi�͘�\�[bЄkG\�\�zW\�r9W>\�7f6xc\�#KS/�O\�dG*{�\�Nk�H�\�D@�\�9���D#4��G\�@�\�?\�fK�7�\�\�\"\�]��\��N\�no߂YOа4d\�G�����H\�a�\�\��e��Q�Dbv_\�=�o�q-���\�Jd��\�BQ�S\�y\�\�{F����hrW,CPɌ�;�U�`\�jv�\�.x�}�W\�\�r�\�b��,�d$\�F\�����\����\��\nyܮE�HI\� y�Q���p\���#lln\�\�Eð⨖�*\�u�~B\�3\�*&\�r��\��	�\�\�\\�г���s\�|�)�I5m1\�\�D�K��\�&�\�u��&R��\�c\�\�C�*F\��\0[9]\�\�2�\�ԁV�z��Sv�ݯ�0P`��\�ly+]\�2t�l�\�*e��/%W�fw!3N��C+\\�DıD\�w	.\�F�:\�\'Q�#�m�a壸:(��#��l�����\n	\�/�eC>�Od�60I6��\'��$5F�pQb�Ě�(96,4=�\�*I�D�A�~Y[�<\n�J�o	R3BEl\�\�\�x�iH�\"\��ٯ0�ѡ�,�rܟ����\��m\�SBu�mM0{_P�<�����q�c�H����\��\�`�B�j\�\"M6\�\�c(�/��J�iR�/���R�?,���92HF��\��ĆL�\�d\�T�f�`Ī��N�/\�_�#K\�z\����X�+\�M�^\�\�iR_ȒkH�����6�\�F\�V\�LdH�!X��i�\�\�`gq\�J\�Y�\�\�\�\�v܁�d�z�\�\�M\�u�3/�y୊�7\�A+AלX�	\ZX��j��Ih|#YC�\r0E��\rBW��a�,�X�0\�\�&l���7\�Ae<C\�4`ߩw\"X\nM�X!\�g�0S�L#\�H\nlL� ܏\��F\��Adcԭ\�~\�\'X�}\�.\�*\�	VOc\�\�\Z\Zb�]�\�\Z�5L7�[\�\�c0�\�Y\�I$�\�ş\��9\�ބc\'4k�\�f!\�U9HQb%��\���y3\��$1\�#)\�L�\"��<�-\���\�o�n6w\'R\�F\'I�hf!�!\�\�[�#ոނ�FN,D3\�R1�%��K�i�\�_�bUeK�����iJy�j�\'�#H\��	I�K�#\��\�\�&h�\0�\�\�d|X\�\�\�G��H氆\�\�f\�;�\�\�tC\�{\�\�\Z��\"\�HO� \�x�\�\�\��o��/�Ity	\�	�5�K\�\'��u�\�m\�a=\"D�\�f�Ko�\Z!�Q�j#\�4=��5cL�Dl-�+t\�I\�ai\��\0ٸ\�T��(��qFI��l]��\�4J�ehS\�\�ՠ��mkj圊\�x\�?�}gv\�\�վJ�\�\�\�\��-�[F�|��b؋wq$\��o�`�,RD��#�2G�o4�x�������\�����3\'�o��e\�0�a>�g\"7>dz&� m��8��{��\�\ZZ�%-C�Vz�\�ԍ$7\�m\�\�>ReB\">�\��w2>�s1-\�j��\�zOZ{e���\�M�\��!����\�Eh�D���H�ȋ�\0f\�c#��h.��)���1͋\�\�\'GJ��73\n$Q\�_��\�\�4�\�\���#cL\�D1\'�.�p�*\�\�X*�I��ܑ�v�\rK\"t��ˣ7iZ��\�GICjP\�Z�F��`\�\�8�MO�#�җ��\���G�\�)\�`���3�\�ɳҿJv\�_c,\�\�G�?1��Q���c�f��p\Z�)�\� O�[\���_��\Z S��M/!�_0 \�I��\Z|BM�NH\�h\��\�t\�$c\�4��x�?�IY�\'A+!#@�\�j)��\�!q-D\�A3�Е��>(�ՑBT[�A`F�ў��	t\�AY�\�\�\�J�G�&gq\�v\rs�8�\�^\����\��3�k/jN\�\�\�I���Y\"Vkpe�,�	���?�\"M\n�,���\0�;����1Ǒf\'\�;\�>�\�\�h��ВRlX�%�z(�I�/W\�b$A�4k����@�/`3�\�I#���2��\�\�d�Y\�i\�\�kCf�,y\"�?�ib\�\��\��oS��5BlJ݁;��F�j���(�\�xt�\�vPTn�����ә����2`\�Y�n�(u\�?X�u\n�|\'YBv\�Rk\��\0��m\�j�mI[�\�\�/8s5`\��\�.I\�l9�a�>�f}Mg��_�\�<\�.�\�x^Q�b\\\'��\�f=��pb�mx=8c5qj\��\0��\�#q\���\�#x\�=\�]�\�\��bsBP��\��\�8�(���\n��\�H\�&\�\�\�%�\�\�0!G�R1ȍ8�@�ù\�{ۚ%Ё|�Q\��X\��6� �\�c��j\"GQ͠�kf\�4x\'�$E\�P\�g\�\\\�N�	��RJ�\�\�\�j�N!�\�`����f\�ɉo� ���\�\�.\����v�>�N-Rj��im�\�I\\a�F3�\��}M�=�B]�\�ݲO5n\�o\�D\�V�)(��#Q�ԩ���1V3%7?��^��*\��l�H(2K�lJ:\�D���r\�Ԟ���O4K:\�c�\�c�n�7�\�E3��� ���r�\�\"����GR\�z�\�6�Y(q�\�R|a@\�QcЀU\n�\�CО���e�:9fP�\�n,�C@ՑH^u�\Z\�	��.}\r͏e[��p0\�MS�*�$+!�gs(p\��\rW���{Ƈ��Ԫڄsz]��\\H8\r�M�\�\�!1��F\�y�\"}B\�䆬9V��\�\Z��šө�\0���r�{$p*Vt-+GxR뼥3�(&!\�b�e�i��\�)\�d��|v(�ћ@�e+h�U�R&�\�ٹL��4	�\�ZwX�:�\��\�;�\�PBn\�\�e5&\"�T\�\�:oԦ�h�\�zd��!K*\�\�o\�a��6n�W�b�A?ڙ�\��\0��\�4�\�{Q$�69\�\�#2\�4�|,ӊvM�H\�\�s\�CIe\r�%D\�`L�!��S\��=pzY5t\�~�\�4\"/\�)���\�N&G����b<�.&\�\�T�\Z\�Ό-[Nc`\�EwM]�|\�Y\r1ˣ��\�w\�iB�\�Xe\�472��D�&7��=�\0��m��K\�\�H{	\�H��*݄��\���e�x\�B\�T$���\�&\�؛�o�\�6�|�\�\�$�\"my\Z���d�\�)e�7\\ �\nE��/�9o�X·�2�̶�R/b)ʟ\��\�қS�h�qV$��\�9�\�퐈\�\���|8\�ǁ(�91^�4\�2����i�\�5P\�DĘ��::z/L��\���L	O�\'�N\n\�-�\��6=\��\0\�\��\�C;�\�d=��C\"�!\��5F\�#\r�X\��h��x�Cנ\�Ș\�=9\����:F�\Z`\�l(\�\\*V�cmH��g1T\�\�_��·K�X���\\\�\�\�%�?36j\�ېLJк�{懽�?��*l�b�jR�\�X�X�\�L��;���xZ\03!\�l\"2\�D\\;�d\�<�՜��#�,�	a~\�`���A̶lS?�h�P\��\n[ts�Lt��\�7&Zr�<�4:\nI�MB*\�QC\r\\\�$W�\"\�OTܑ��0%us#�\�b,Zw#$8 \�b!ә��0\��D׶4\�\�.\�����	n�C��\n\�O�\�^K\�s�!�\0L�\0�\�%}\����ؿ>72s\�|L9�1���V@Д �> �ՑB\�K��\"�lX1�ZO �\�NPr�m8\"e!U\�[l\�\�F\�AE		\��?���g\"|֩\�!\�f/n�=\�\�y\Z�\�N\�-�F�d�b��_ =m�1\�HO!{�����Wa��.L�	���K��t�F|�i��\�\�S�vW��TY�����YfFֺ���#��TYЩI�PC\�ed�?��`\�R÷膺��N.pk]�5�\�\�9���\0J_��]\��M�\n��,�\�(\�_P@����;7�y0pӃ:V�oɼ[\�d48A��x|\��\'0�\Z;�h���q�\08r�],\�\�e�\\\�\��\"[�\�8�\� �c\�lyG\�����\�\\Gm��+0@#\�5\�xt҅\�\"\�9�&��!\�W\�1�\�x\��/�\�M\��=��1襖~d�Yk6>Co%cZ�;XZ��\n\�;\nG�hb%:���\�!e&�D�\r���\��\�$�\"\�35C��I\�:��\�]\�\���\�\�\�m\�\�0c&���(�cN�R\�V�0]\�%5k$�ĚʾhmW��\�!N\�q�a\�S]\"\�Z\�T�\�$5u���CY��!\�k?R~����̛��	&�#\'U	\r9�\�	(l.|�`d\n�H\�\�zDh�VH\�Ԭ�S4���s�8Ȗ����$�i�\�L�\0%��/-Ř�\�|\"(\\�@�E\�t���P\�3\r�xe|������:B\�\"c��wG2n��7�)���a��E&�Y�Df��\�QJ�Ԩ�9A#d��||pђS��\�5k\�F�\��4���\0C\�\��\�\�u\�\0o�#\�Ή\�\���κ�Z:עt\���wc{$$\�hOqU�\��\��·y\�``��J��奉�nPP�\�\�E��D��K�\�Q4��k*/�[{�.\�h�#дxD��\��1UR�b\��@\Z\0�%A�\"��mנ\�JN�B:M\�/�?�\�2\�طZ0����~R\�\�WY}�\�C6YH�1\nU`\�\�T+�ʕb$�3S�z��\0Ȭt��Ƃ�K\�\�\�S\���d�lǩ@Y\���ZNOp\�s7{��C,Zԙ\�PJؕ�(e$��%���I\�h\�z#ಢg��8\Z��G\�5�Ї_�\0�-Dr��Ԋ�\�:D���WW8Y$sL$R�\�H霢�����-���r\���<\�=$��?\Z՗Ȟů�̊�Pj4m�B\�T4.e3A,�$��\�#Vi7O�`��8q�t��ToT�b�ƕ��`�˃�f\rL2�Y�1x*2۪X:\�Nb�4�a\�\�h4.rI���_���$\�Dh4�\0\�\�+Q� \�����K\n�m!\�AE��\�FHm)\�\�H��\�R%hK�=�[	�%lHT��\'7�\�G^7�\�1\�kԑWRM�\�L(Wrh\�^�G�,�\�hNs3^�x�dZ4T��H�~�\�\�21h\�GO{��y#�\0\�Xo�\0AtF]L��\�ark���%\'2\�\�����8T�?Q\�\�\�\��?\�	?�\�/�\��9�\0#{\�\�\�y9�\'?\��,���\����V,�i\�\'f�c\Z�?�\�8^O�!\�D��iI\n�Hņ�\�\�\�,�\�\�f\�6\�\����Y�_�Y��Db������nf�H\����\�&q����G��>A��Z\�\�(�����lLYQ@\�a�\'+P�=�\���}\"�9\�\Zn,\�\�+&f\�\�\�%�I�\rO\�\�N\Zuib\�σ\"\�\���D��+[\��>\n#\�Vp8�Œ�W	�� �)�{�ҽY.�\�\�B������p�G\�\�\�BIʴ�R%�\Z\�~�\�V�\�f\�P\�\�4T)�f\�\�#M�&�\�O��|\�3d�B\�b\�4�|\�=y[\�\�j�	K���	\���ġ\�\�L�\�fl�h�dW9p�.�44463�t��^��rlM\�k�\�R�\�	\0��#\�RBL\�#\�?\�3�\�+����\�?\��Q���^\�/�\�m�� P\��C���|At%�)M\n#�`��z�9BI�Y\Z˴\�ۇZ����\re��̆?n��s�bL���/2r&�\r\�d>ù՘�I:\�$��(A�*�#ĽpL+GB��1�ϝ\ZY$:�\�ۜ��ge%CG\�Y_����;�x<��c\�\�\�\��U\�\��\0\r�V��aV\�4kVŹ\�=[�\�饭\�i����G���GZ�ch!\��Ua\�Z	Uq� Sl6\����\'��.�TC\�׃3�U.b�dT�mH\�8\�9���\�\�R]��x\�\�\�&���	�$,2��N��g�-.�)e�\\\�!ܮl\���D��.���&͐��Ba�j���\�\'Ug\�\n<���\�\��вmD�i~���0C�F�\�\��\�um\�LW�ֲ\�Z\�#ǌ��\r�����O��#�\��9#\��\��HXkC��\�`\�|	�\�A�\�x%6P@!�4�\��$`�\�h/è\�]�\��\��\�\�\�\�>�i�\r\�K\�r��\�Cd\�>P�\0\�c�\0�5\�\Z]�* �\�\�ܜ\��6%�\�>�O\�G,�\�?�l�,\�kț\�zd\\�\�\�\Z�ꄹ��\�\�\�\�*��܏\�\�K�n:L�^�(\�w\�\�J6�\�C\�N�YR2��Nf�\�\\d�ǳ&)\nqNF�-�eX&؜�T��^\�dj=�\�\np\�DU71ok.�\�E\�ԍ5)wB�\�m���\n%;��\�&��إ�}#(eԀ��X\�qhjŇ��\�fo�I�;���1\�A!\�y$Y%M�lY\�\��X\�!�\�[aO�\��Yj\�\\�֛�Tl�61#c��Н�<�k�׃ɡ�py4�zb���\�Ӏ\\5��� <��ř�9̐�^G\�8Jo$��\�l\rq�4t6��].���c�-zws�\�\��h\�j���Һ�\�%O0���E�\�1��\�0\�ibB:��\�ߓ&�\�B�,2ùS#\n�Z�)3RN�a	\�=#7Lg�uf�\\\"%KO8\��\�E�a�\�byK1\�fP�Ƈ�6y\�HCR��q\\\�+S\��\�Cv=?�$�Bp2�E�,ۢl��3��0}\'Q��!*�S���F#���\�ۆhBnDg&�+R�\�,C��M�\�H�\�%�#�ĬinB߄u�\��\�h&H\Z!\r��\nIP`#\�(Q�ĕ�	�dИ�ݏ\��2I&���,�I�≰r(\�\'ΰ>0�\�=T�`\�{#\"ڿ#6O5v�cd}�ȯ�xυ\�hq\�F��Ii��*\�\�\�ܻ�\�!-db\�	8ρ�R\�.�\�\�\�\��b�:\�D�6c�\r�\�\�\�GP\�[�	���H�nJ��ɠ\�\��8dk�Ü̲ab��\�\�3\�l}0�u�:MR��u\"U(\�4ၿz\�\� b{ׄ*\�gtr>D��!�r}�cB��c\��#j�Wv�IH��\�\�sbfS\�M\�\�\�\ZnU\�Z�k���	�w\�_ɺ\�<�(�\��7�h#�\"u5*\�i�>W��=�\�ى�[sa�a�$�M\�\�J�%5�\�:ey��o�?�\�\r\nFr\�w�� K�\�_�\nv���R*\�[\�\�\�\�\�\�n\�$]�\�$\�짨\�.a,��$p�|�v��;͍\�-*A�$�@�A��	I\�W,�pq��$�P\�vY�F�\�\�\�4\�\�j��jt-\�\�M\�.��\Z5��\�N��׫\����\0�\�?�\�\\CI\r=\Zm\��\0�\�\r���\�G��ͪR\�aF�&\�V8)�\nU\�Dd��\�k���4\���H\�F\�s\��>M��/8�\r�ߧ���\�6h��B�\�m��ݨo\�6g\�6~\�1X�\�\�\�$�ĺ��������ߥ�?��S\�<O��G��,�\��ZS�#��.�\Z	���\� s×\"��jxܖ\�\�ۜ�B\�C=c�\�\�p��4>8�\ng�AjM�#�h3\\:r\'�)ͬ\��3>`�\�r\�\��\0��r��\�:`MKb��.̔66=���I<��\r��0��\�\\�A��F䁎\�V$��&�]i_1\�Mz�z�<\�?L\��\\p#�1�ӊ��kT5�Л�j\�\�#8F�Ů�~�H�!j�����\�O_\�\��t\�\�xǈ�(i�4~�\���L�@�Tz ��\Z\�E�\r�!2@Й hZ5b\�e<��є5%6I\�\r\�\nS�\���Fe<\r\�<_\�Z\�\�J�+\�\"�#�1c�.�:\�oN\�vd]f��t��\�\�\�+r\ZJi��}Ko����Mo��\Z\�\�\�,\�j[[\']�HK~x�s\'I\�ZLr.\�\�ӑ�\�G��\�Ʋ\�F�\��!nh���v\Z�@Ϡ;�M\�v\�n/��-51\"#\�\�\�i-�?\�݄��\�\�0\�\�ooE\'��$M�N�44�\0t\�\�ˁ�$cga��DuxHFa\��\�ݐ#\�;9�\�Y#\�>f\�d�\�^\�\"hD�d�O����\�!}�BF�=�H\�\�5F%@�\0\�\rѼ�C܍�w\'4�\�v�\�o\�\rh\r���oϐg\"nVs\�\�\���ot(O\�;�\r5m?\���Pg�g2\�\�\�9f�Ji���\"0ú�\����9\�E�Js]MN��{�ghF���CS\������i�g�̶\�؉\���[BR\�\�^I�Hh�\�?:��1�0w�\�7~	�\Z\�H=ډ\�~�&&���E[!:y�*q\Z\�Va\�#�dG�(KBjb{i]nI��ܜ���@�S}\�}l\"I9W{���s!r:��|�Xl;�\�*D���V\�\�f.��&V��$\��\�9n22\��D?�\� \�\"\�&\�ҹ̞�s1H\�I\�O�\�c\�&\��\��Z!\"�,t�($B�pj|A2;�\�OPZ�ɪw��6H�0�;��\�m\n%���\0Q�\0$j{\rQ\�&��\�\�I	�OD!\�jNa�L���\�`�\�\r.��|�+=ݎ\�	�gԍ�Wa�\�\�\�K�\"��w��0ܢ�6\�O��:�D\Z�`�f�xo����C\�w\�<�\�k3���TMeM��}�\�\'��a���\�ж\�h��]2Jmx\�V\�r{-[\"zR!v5�\�7�\�\Z:\�C�jT�RF5\�55�\�����}2ٌ6&�\� �ssLi[�vc��O@\�mM1{.Q���#Q���\�)[X\n*�\�ȉ腳&-��J��k\�\�_�BI<�\�\�cP/\�\�\r/��4<�\���\�\��p7\���k���E�\�	%\��)��0��\�?dj��E%N\�a�r�F\�hjSз��)�;���M)�y3\�<�	S[dVa�\r\�@K��a�\�\��\�4\r��+\�2\�R\�?�l\��\�D\�-\�`L�\�B\�{��?��\�Q��cڭ\�n$5b�\0\�\�f鴺[�,�Z�Y�d\0\\[\�`b��;F�[1�\�DObv;N\�\����Fnt�\�\��\�$)\�@�=\ZX 3\�8���/y�	ę9D�y9�ni@Ut\r�~�`L����\�y�v�a��\0<��m�H�a�}F��\�O���\�s[\ZGx\�]=\�nB=\�p����v?\�#g>A���`�%��L{ �8��\�\�Dk\0О�����z	�6&H\�\�$\�G��\�\�HjP��K�\r�r2\�r����\�c\��j?�\�7��\r��\�\Z���\�l\n\�f�UW�\��\�(޿|�I4\�L�R��1\��Q�#\�H����y:���B`�\0��\�Q#�\�ܷ���LA�\�ej+�T\�k�\�\\!A1\�\�F�\0�O7?c\�e�}\�t�>�ّ��X��\�WVDP�;��\�b\�\�=W#�FCq�8\r\��J\�v�q8�i���\�/	\\�C_Ḍ\�3l\�{\�MR��<��엹.Q\�}s�q\�>������<~�\�\Z¡�4�CV�E\��\�>� hH��pj|q�\��\0���/\�\��\��?�$\�L���\�1X[!\'�]T���ᇬ\�u\n��X����	��\�,�N�h���$��a\�\rZ\�(\�=�\0�\�f�#���C[,a\�I���\Z�\�\r5f�|\�\�i^r����\Z\�\rKM?\�Z�$PU\�\�r�\Z=ƹ\�\r�E�0��Q�.�`�\�,\�b�R��\�ggG3[�\�\�T��KcLp��t�\0t\�SM/�`�Y�\��u�C�c��\�E.�0\"�c��ԩB#<I\"�9w\�E�&�7[\�@گ\�Kߎ\\g��\�\�$�w�J\'\�\�\���1pfr��&\�X\�|����Ɵ\�.2Ctr�F|\�ŕ��\�~\�\�X�\�3\�5k\�\�X苍�o�+���!�J�y��yN�dB�O�\�eCI3R�Q6��(���~p\�nD4�|\��\��\ZyߦK��f�\�l65Z���R\�h����\0�2�\��\�O�F!$q�/����9�тE���4ӹe��\�k.�\�\�#��T�E�l\�\�,k\�\�Wѡ]���ݱ\�ZGD�4�D\�\r\�\�I���6=���N\�\�s�rH�갟1\\��;(�\�\�?:D9P�\��[�\�IۗFōm\�b\�IU*�e\�G2-Ux\�	4�2\�%�#\�\�\�{g��Gq\�1w\�c(N\�.al\�|�n��r|bf�x1\�:!,7�\Z�\�n�\�6\�u,�D\"r^v�\�Gr���5�\�F�\0��g���F$�\�12km�XA\�#���\�	\'ɛ�\�\�v哵�H��6/ڋCZ\'!�*\���l7ag9h�\�P\�qf\�#[�\�]\\��CI�\0-Y.�\0��_B?44�L\�l\0hA�.��H\�g\�{Za�ɾ�Ke\���\�Oxׇr��	\�O\nI&��\�8<y�Ūa�!��B\����\�\�ښY	���\�	\�d\r̵sR*5�D9\\�\�XsABR\'\"u2\'ff�F�]Y�\�L\� �Qf�,!�\Z\�\0��0��/\�Ý2Hن�%Ӊ�\"1d\Z�\�dg29Յ��C��\0\�&\�6��>A�-�_N\�\\}`c!?\�Jf����O\�է�d\�\�<\�\�ō�1� IL����I#r2_\�\�\�\r\\=�qc2W�\�\\�>\�$llk]\�٩\�\Z�~�!��+�rEOa?�}N\�T^���15(t9\�FJ��a�c[>�MX\�]/W!��s\0L:\r�fG\�\�\�\�\�K��\�\��M,��%\��\���>bod�&H\�\��\���lOE\Z\�Y$�.:\'&_P	�\"\�1]�x�\�x\�O\�\�\�S\�;\�J�\"��\��\�ўӒ���>3\�\�\�N`E�\\Ѿ\�X�����c5c�\�HDY��֬oV�Vjw|��ܾ��T�.A\�[�h*]����C5�\��h!�B\�c\Z\�O\�����\0�\�lln\��d�\�L\�\�\�\��;_�D�0s�~��^��\�?��3\�,A,�|2���%ܙ&X�#$��*z:��\�\'i%\�aE�>�Zz�C\�\�\�������0\r#o��\�C\�7e��\�\�ɤ\�\\s#�\�F/�v|rK�\r\�2\�$Y\�9\�\�(iyQn���IŴ��H�\�\'\��/��p�\��a�L[��L�6jQm\�C~\r&�\�y�f4v�xWa-�2\�:8�����#\�@\�\�\�:�\�i�\�\��5S\�@�G�#d�pxpf�i��5\�U�<�b�\�[)Ǚ��qS�`Sk\�k]\�\�$\�3�|1̛����s`\�\�n�\�6\�d\�|\��c\�_&c���C_ǳX\���Js\��\�\rj\�,Ķ�\�\���\���\�\�H\�.�\�#v\�&�t}�^\�w��]\�D}�2�e\�m��\0�v�qS\�㘸1q\��\���=�\�9G\�3\�Q�\�Iǌ�	\�l�?pW3��K\'�\� �\�t>���*\ZWBKD�UU�\�\�։�$F\��\0�����r\�9\�x0V���.\�7\�K\�a3#�z�fg�VZ��%�\�Z�63t�4]��ϓk?��\�\�h�It�Æ��\�缤��x$l��1���\�r>Q��gR5�e�!�K�9��$�<Py�\��\�fe�F\�\�̯�cT��fBU�\"WB\�\�\�1|_G���\0\�0��\����s?��\��y���\�K�\�\\\�ȃ��\0\"?��\�|�I\��A�y*�?S$�\�\��\�\�Y�\�\�t+.���j�����\�=\�3#X�+e\��F̐\�x{��lzF\"+��R7%RA��q�w{\"i\�-θ��Y!��\�s�S˫F,}>�2,�\�l7�\�_����h҈\�fT�\�#\�79\�#���\�\�|��\�?���$�-܋���^�v\�$\�S>�\�Iup)[��M\"�\�\�=\��n%~)q��Rя͞�\�\�!$�66<��q\���$o\�l�l1�\�[�\�\�\��\�\�$�u\�\�\r�O슒�\�b\'G�bJG\nԜ��\�\�9ꐷґ�]�DgF\�\�<�\�\�W؃�X3\�\�}�3`6e�r�VB�d\�\\\�!�1��\�C�$:<�9�W\�\�KY�\nz.	\�89\��m�WR2@�3L|\�\r\�J*��P�Z\r\�y��\�\�o�d$ӑ�(PH�g�a�I\�&��T%aڔ�ݭ���^Dm\��\�Hl��$�8t~y\�\�G�RI�HHm�$)�W���O��\�0�U\�h\�O���\�\�\�zC�̴C\�bI�\0\�Bc\��\r��\�DtI��r�(�0�T*�2-G�N\�E	\0\�*\�\�	��~\"G �\�Ή�\�\�F�f\�<L���/VE�	h͔��\�tDi�l3��\�6\�[�W\�$�B~ި\"\�4��h,�e�\�\��RI$\�\�<y*�[=\�q\�$|\�Nh\�,r\�(.7\�\�$�F��@�f��sY�\�\�\�v�h;�>`�\��	(_+q��bY\�(\�6I,�\��\0$\�\�3-GΒ\0����S�\�J4n\��%�t@%\�7�˘N\�\'\nGN�\n	��!��4�%\�6\��\0=\\Q�?�\���a\����	L��	��D\�\0QS\'\�i|I�S\�\'��{�p\�\�%gQT�G��\�\���$�H�\'�01o\�\�n�����:\�[�\�\�\\�r�2,���QG\���Hw\�Ks\�E�;��\�\�\���Q�%@2�<��Y�Ւ�0$O��_\np:U���!#��%���%\�f���NСv�5#��{\r\�u�hU̹�2���HWPE�Cc�g~c\�R�\�\0\�\�\�6\�|S-Ʉ��\"$A0�2\��\��`|.	\r-\�8\�]F\�,��c\Z\r�A�\�]+]�ǧ\��Fc\�b`(\�h�z\�5�g�`L\�\�o\�#�~߬�_��}��\0+E�\�\�$�l�\�<\�S\Z\�n\�\�a0kGI>ψ\���-\�\�8؞\\\r�\�\��X~:~<=1)*\�I�H�=�\�ƅ��)��\�(�����<�`\Zj\�B�j��	�\�\'\�0\�B3�ј|@]Yp\�C*dE)�p��ue��\�H\�T\�)\�$�Y|.;-S�ۆ���l�;P��|e��s\�,��D\�\�$\�\n3\��\'\�\�Ϛc/\�>���+�\�\����9�\�\��F?\�g��\�\�,�\�<4� ���(�Vč���N��\�<9Kc���d\�(JnD�\��Ȥv{D��5\"���VUM�Oi\�Ź6&_\��\�yy\�I2J/�����ޱU�%��[NZ�P\�Q5��%\�iA�;��?a�TJf¾\"��\�\�\�ut,:��\�P�3o�/�Z\�,�\�p��_��3g�[/\�\�\�\��\��\0�?\�g��\�\�,� ��<��K�x`��\����� N\\d\�s^�R\�r�\0�T�\�\�\r;>)3f�4\�#J&\�ߡfE�QͲ�X\�d���Uȅ�\�T���\ru=V\�\�\�[��NK^} \�t$�\�݊{I\� B3\�@�\�f]�;=�Z\�c\'�\0��\�\0\0\0\0\0\0�D��\�Z�\��0�M<��My�r��5%\'�!��m͇j\�7\�<�\�\�`�\��sb[\�~Rh\��,�\0[i�v}���;\�\�\���������\�&?�T �,\��	K�TRL\�\�0��>�y�m\��\�Ω\r$\0>����\�i��d�IdF�\�\��$1\�	\�\�Dn\�\�\�\�[\�g/\�<�\�\�$\�w���V!\�\�\�比�r�Eʻ\nՄ/����\�]��_,�/�\�~�6Ju\�2\���P\�}��8�p\�}�A�E��s\�F�.n��}�\0(���D\�#\�T\�\�\�R\�Y&%R�9ŹSEx\�(�9�8!\�\�vE1�\�5Ĝ��\0\�DY�-5\�\�A�;b\"xGs2cv-�p7\r�\�\�\�G\�\�\�\�0�\����D1D*\�T��\�\� Ci\�\�\�܎\�0}�n\��\�\��\�\�\���\�\����@\0?�o2�\�i8\�3��gׅoI�H�\Z��PFJL�h�!s��z�jhU��\�[\�\0Vn-p�Э�\�%��h\�h�6d-v\�\���\ZcR\�[M#�Z�ܺ/��\�\�M\�r���\�l\��I�X�R-�c�A�h~\��~\��R<ӧw\�B�SL�H�)Y\r�(��1�/٠P�ZJ���h\�Lo\�\�M�\�!\�[y�\�u%o|ik�I	��#\�QTW�Y\�\�!\�\��\��\�\�M2\�]F����\���pu�߉ܽ(\�\�g���Z�\�#�ί�\"��\�t�\0�47���3쐕���J�[�ۀ>%\�\�[Z2��\�t��9fP�K\�7�|\� �\�޳Po�>�\��\0ppg�k�T�x��x\�DH^�\�\�_�֒f3>\��%\��u\�\\$aƝ_�S���P㤉F\�\�	�\0i�fԍ�+�J\�<O\�2(�\0q��\�)=K`Ѵpu�\��\�ڲ\n*�1�\��,�\\\r0\�\�^݈\�\rq\�Z��6\�/\'�^�$\\h�\�\�-���B%\�H:\�H�;\�\�(BPP�utG_\�OT\��\�=Mr�^\�\�\�\�\�+�)�Ss\�\�x\�׀SH\�Z\rm\���sʠ妫�m���\r�z���\�ۆ\�}q���\�W�\�\r\"�*�p\�w� Iԋ~�\�oJ\�ɫ����>V����r9�\0K\n\�+�ݡ\�u|������\r�e,c\�\�$iL�P$ϱc\�2\�rE�\�\�}\�\�=�ҫ\�\�\�I\�\�\�[�N�\Z\�\�\�&�\ny׀Jl��z�K<\�\�%8��|\�1����q�2aM�H-w�i�O\�>²	ۃ�����s����?G)1zV3X.X\n���\�\�S/\��W\��\�\�j`�2oS�3���ɳ=��X�ԉ\�\�\�7ݔj�\�\�\r�,\��;��\�\�\Zp%\�i\�M�ac��r?�\0c{5 �Q\Z�?\�c	�U�]D�b5W�H�ՌZ&vm����\�?\��\�융��\�)�\�B�<b�$�\�˶�\�`(\nU�\�.�G�\�&i\0��\�\�\�\�N\�\r:\�\�M4��4%P��R�|\�l:h\nG.L�|�C5)\�N����.\�|�\����\�ǓE��\�w;\�z)X)��c�\�\�\�j�;T�|�\�C��J�<|,^Mדg=�SdZ�]\�r\�-�75���ר<�2\�<\�\��#����?b�?\\�\�\�t�࿁�\0\�\�\�{\�\�p\0�q\�<�\�<�\�<�\�\0(\0\0\0\0\0\0\0\0!1AQ�a� q���\��\��0�\�\0?VՎ\�+L财�L)ђ�\\膥2\�Ǻ��\���\�\�t��\0D�H�\0b�\n��ςV\�&\�n�\�\\�\�\��_�-:�\�\Z��� \ZV�\nrS�����宆N8��;FP�ʕ�g\Z(�v�-Yau\�L\�ɒ�\�R����C�\���%\�}�\�^�\�N}I\�\�ZK$�:\�O#$�\�\'_v4�%u�\�^��y#\�\�����*\�\�SPIN^�\�6PU\Z	7R\'餣�+L\�\�e( ��/ԚL�\0Y0��K��3u�\�(YH��G)\���\�$\r�\�D=\��܂\�nJ�bm�����(�I\�P�TC�\�2ă\'\�\�\���N\�W�,�X@�\�Q����^RLo%\�d\Z3y	�c�6H�&uЬ7�\rP\�ȤI�\�Ħt�ٺ���\�$k3|\\P%\�y\�$WV�.@\�hø���`4$\�J�\�>\r�\�ċ1f�\�܊\�\n\��bh�Bd��Y8O�W��)\�$\�R�.\��\�eJ�\�oa&n�\�[J�>\'\�D\�P֭MĤ��a�F�W\�gF�HM���	\r\'�}�%6��}�#IY7��A�-Ǧn�t���\��4KHN��\rM���&HƅQ#~\�\�R���B$\�5\�gf3~��ɟ\�\�	�\�$_��[�I\�F\��%MX\�v�\�Lj\�(Ѫ�}M\��M*u��T��R\�cѺ�Tΐ��\�\�E����l�Vd�NI/AQ����(���d\�M|M.E�\�/��-=!;�=��H%	��8+�i�]��ʘ�M�A(t���#8�?�Z���\�i\r\�E�\����P˂\r\�Gs^��\���fer!�L�\�!�\����$\�I$�L��Һ@\�	\�EbiAru!�;�Kv��j\��8�\�]�\�~BEܨ%L\�1q\�\�CnJ$\���!�D/Q�4\"DU\�(� kC\�\��P�.H\�;��\��^\���E~�\�=3+�,�cvA:\�Bt�2u���=]��2tcBd輐\�XB$T;�$�!-hY.F�gP��8�\�\�L\�0�F���\"\�jѺ��\�6\'�@a#3Q�\0��%%\�\�DIQ�H��\�+��]ő>\�eؚ�,�M\'���\�ƍ\�\�\�B��u\�]_baZ\�I��7`�K\�S+�?\�oda�39\r\�7�3-�\�3`��4\��P\��A�\�\�V�\�F+��Go\�n&7��{�ٻ�\�\��\0hM\�\r�]9�I#�\��\�b�$\�6P\�\�x�i#�\�gT\r�o�\�\�\�\�\�Q&ڌ)8\�{&Ar\�o6\��\'�O`�N����Y�!��\� HE\n�#b���*\��\'I\�L�\�\�\�a۫u�c9:gF\��*	5�\�\"e�Fn*T$h�!:>eua2lu�����P�$4<\�X$��\�\�\r�\r���HD\��ܑ�\�8��1�W�>W�\�B�\�� ���՜�:3U³�%\�a�\�ªi\Z:�I�y\r�$\�R�+�\��&�{��Kr\'�Hd\�a��\�C��q\�\�n,*zX9ю\�;�l�\'QN}����)��1zIV�x�[Ѣ\�]Y\�$�\�ɛ��4�����\�̚^�d�\�z?o!W�-4��/\�6\�T	�#f\\#�KOm��\�\�\�\�Ô$Q��u\��\�\�fr�Όb+v,,I\�2`]�~\�h\�\�\�$ky���!g\'T�q�\�%��\�n�\�ۘ�,N����\�*t4��\�\�ը�uA�\� \�wL�z\�23\�1��D!I\Z\ZPs�� h�>\�@\�\�\�)�\����J\�\�Q0\�A�P�OF\�\�MK��\���\0���*\Z�d�H���g\�\����D��k\�J�\rٰ\�\�Ȃ�\�q�a���\�\�3��\�#�v�a�\�\�BQn(Z9E\�7����&t�q\"��\�<���҂d���4\�i[dɵ0J@�:L��k�u���L��@���8d\�\Z2m ���(D®�ZTZ@\�c�)\�4=-��\�;\�3�=︜(%l$X\�\\�~�Zɦ6�\�$(���yL/�aX_�\�,M(d�\"�B$\�\�t\ZMrW�D?\�1�N��V�\�Q\��\�ᎣŰ\�iT\r\�%Cj=\�r�dc�\�\�H�\0��g\�\�7c�cDic\�\���\�E�r\�j+\�^\�-��7&�D���\�h+�\�j�	�N�u*i�&�N�6t���J9�\�v&�SA�&γ\�u\�\�gPu7a=ķ�+�)a�D!��\�\�T���	u	&`���V$��\"x\��ē��H-	k\�\�I�؟\��ip�\�}\�|~d$��;�<`�0)PK	~�nf8\�\�\'\�M,I�:��I;\�nD��w%ɰΧ�S�Ƅ��P�F;2>����\�a\�}�Uu|�IC�ϯ��\"�y(īG\"5u�[Z�\�I3��(�\�*��x�\���\"��:L	\Z{! �m�&\�\�R�\�;A�j\n�\n�!5-���I\�A�ϰ��\�6\�\�u��������\�i��(E\�M�\�\�ZMé#��\�u�\\u\�gQ�wq;��t��B�4\�4G\�}2U\�|h�4ؤ������KaXWu\���,~\�L�\�\�q�\�}\'�J	��J���\��SD�1��Pd���jJCh�(m	Б�2I&4�b?{\�#L;�\�Q]�\�c-r���\��GrJ@q�jF̮F�\r���-z�\�W\��\"B�3m�-E<!t	�����\�\�3\�\�?�\Z��&�\Z\Z(\�ȫf��2=î>�al>Ėnǚl��5\"�	~\�R6�\�qaO��ݏ?�&eK�T\�m\�pQ{���Q�a�=\�(	l��؛6�F�自Ub9s�:\�D���m�@�,2dc����he�F�L��D��A5\Z�Z�\�OCC��uWBU\�hІ�\n%\��%�O\�\�\���\\;��	X�:\�u\�\�09\�bCȰL1\n.\�%\���j��9��#RU\�+2�Ma\�)�\�\��\�bk�f9\Zj\�;�\�0��ǵ\�ۏq�� �\�\�f\�\�슡�\�!+Q-,4�V�o۔��MJ_��+��;���D��O�,@��v	� {�B�U@�0\�w�\�~CU\�\'\�6\�%ۈ�=��2\�J�$�m�҅D V��\�\�\�\�\�)\�\�d&	\�t�\��#��w!�\�\�;F�>\"w\ny N���rW-�8w\Z�����)>\�f�(\�%r��Y;�hC�\�^�\0\��\n��#Fؿ\�7V%VDii]�WcE\�u夁*PhhN����LI\�\"\��(E��	6^\�BP�F���7al	�\�\�A\r���i<̅��afo��/q(-��ī4\"7\�{\�}�V&\�T\�d�\�Q�o�H2ʈl�Oq0�]\�A�Ԃ\�{�\�B\�\"P�����\�@b�)1=��\�{ܢę;o��>�\0\�&�U�r0��3w�%۲e�\0z	$�S��\�ۧo\�!\�nCd1-h4CM\��\��-خ[�\�+|�k��\�	�\0�݄���\�H\�S8\�pY�p\"\�N��a[V�QpM�({�\�/��ZK�\�\ZK\�KԉO�\�h�ʌMª�<��\�\\���6\\wn\�8~\�\�,�Ed\"w\�\�jn1�ZH*\�\�PAa�&T\Z��6MsD\�$�\�C�$�tV�;�\�\�	�	\�	3\�M�	�~\�ww�4mIs�1\�\���\�R\Z�u\�\"b�\����#F�F��վ���6��\�I͡2���$2���\�X�ԉĂE���A�� 	�7\�\�\ZP\'x�1+A/��BIvm!�\'Ny_g\�(���HH�\�D�=7��Y\�\�W\Z��\���\"\�b{?\�w��K�%��J�/����\�ZXn.\�Z�)\����7a��i\�\�$0\�\��\�N�b҆\�j\�c�9� %\ry\�\�\Z�\�Ȁ{\�\�.�\�\��\�_�hܪ\�\�\�J\���#H ��A0$D̠\�$đ508\�E��\�B:(\r\���k��ArN�2jPޖ	GA���^Fc�]�]�\\�.\�\�\�?��/��\�J�����D��\�F%-#D6�\�űc\�0,I\�T�AtUX�M	\"T_��\�\0(\0\0\0\0\0\0\0\0\0!1AQ��aq���\�\� ��0�\�\0?w2 Eǰ\�,δф\�\�%�\'�h��V\��$HhA�*5R�4C#\Z L�5�\�\�n�\�AA\r�\ZlE%;��j�G9�dy\�ȉ\�\�\�4J�6W_��(D\�\")�\�4Ӂ�a\�g(\�=\Z \���DZ!�F� ��\"�5��\"?Jf,�\"�<�8�����I\��\�r|=\�-\��	�\�H\�\"�\�5gJ�C!�\�،�6i�\�I%�\0JA+F�n��\"-P�\�f$�=p�(B\r	 c\�k@�j4d1NNp\�\n��TfQB\��3.\��iѽ���	\�f��.Q:�\�nIE �<\�W�\0�E\�\r�>r�\"���I4.&d\'�BYU\�RJ�.!�8!jt1;\�8\\k�$ُV��\�!i�<��jy�\�l�\0BKe\�n\�c[&q\�S9��L�2���2\Z���\�\�\��r�,*�\�A&dfv�lɺ�j\�%�3l�6ŨH\\hh�\r	\�D��\�#IU1��\�\�q\�\�C�Q??ؗ�\���\Z\�1V�B \���Ī\\n0\�>@��QRZ\�\��IܢD\��p%P�P\�s�(s\�H<Βdh��*�%�\�Y\r\rP�)�`�\�%\�\"\'v9\�\�~�\���\�0vĬ\�#	\r��D��ϧ\�@\'�\��#$�\��R���*`\��\n��+NX�n5.1�h! \�R\Z�4\�(E\nAP�4@\��:� ��ĸ%���bp$y��%fĬ\�\�\�\��Ah\�)ߏ}�G�H~1&̩q\�U#4$6�Ї��\�j\�t\�	A�@Y�e0�N\�\Z�SL��wR\�\'_�$rd�\�$v!�\r7\rCDW�\Z#\�J�aX�� �jO<	ך�B��!��砢����ru\\�44)�H7D]\"b7)��l\\L�ُY,\���bd�ad�$#��\�4C\0_1$��\\\"nD���\�cr��\�\�\r�%Vc\�\�\��\�A\�\�Ӷ\�\�g\�W(\\W]D\�/1�.�\�16_�(�J�5Ȏ��O\�=�\�\�&|�Im�G!�h1�n\�E\�FCd3�\�1��R\�\�p\"B.�K\�\�|?�	�\�Y�P4Xs2y\�\�WUˈ\���ȁ�!�A�ø�\�B\�R\�H���b)�(7�w6��\�i$\�\\�*��kq\�_\�8�d\\|	&�\�@O�\�lL3��=��BhRj�\�҂\Z=2d��؎z�B9\�u7\�a\n\�UU�0�EIHcCI\\t�X�\�i\�,�y�\�4�ҧRj��\�E+\�I�(JK	b^d�GtLB�		R\�xW*)W\�nCCC��ģ� Ϛ��\�9\�X<r�\�\�d�\�)\"�`�PtA(\\ �Qi|�,�\�_\�\Z�\�]�\�\��v\�y�\�\�\Z�[��\�[�ɴa|PP���\�$!5��M\rY���[�rLU|\�\�;��Ċ\�D\�E\�V\"�:B\r�JC7\"w\rIDSQ�.�\n\Z�>ArhN\� ��.\�m�.x\���\�4Ӈ�ʜ\Z�ŏ]\���P\�t\�N\����\�e˷\�;��Y�DD~,Y$��Pd!�I\"\�V\��\��bEow\�\�\�܊b\�.D:\�\�K\�!\�	n� vKȘhNf]���\�zlKTj&W��U�Q*�~�\�ӕ;�8\�Dڕ>ċ���\\�ȱB�ɖ\"d�J�q�\�9��%;�$\�\�,�،��\�ycr��\0br��!\�b�>�ũ����\\}�K\r:�9c�^	Y%D-z\�# ��6^�\�{��Ƨ�\�F��\�RE�PM7�\�-�\\n��H�ЇP�,�m�\�,�=	��J��K(P\�h���4i�n\n\�u4$�e���\Z�c�\�\���Q!�6�5\'4�NP��vB!1̈�9�C/\�)�\�Z\�Ӱ��\�\\:ST(�4�����P7R�Ћ�l�6�ܗ��\'Ӟ\�xO<\�o���\��pS]	U�]	XK�rǮ�����bL�	\��K\��>�al!1�\�\�l1�w!)u/A��u���j\Z!*H\�bBF0\�\n��7Z\�Kny\ZZZ�Q,�{�\��ܞ�m�t��	B�c���1!�&�׮\�\�E4\�F<ؑ\�u��)CSr,�d�D�(�\�\n\�FDr;\�\Z\�\�ĉ\�\�rd֘)ȩ&+\�8H�\�\�y~\�6ēz|	В�HM�&.�A7��M#CJ\�Fb�\�\':�X]�#)A\"�$%K��7\��uy\n?\�\�@ѹ\�EZ��aC(�%B\�t\�c!�؂:{w�58��\��5Кh%&r\�й��un%�s���_\�\�n2pE��K����<�\�Zd\�%\�\Z\�5�X�`���/v\'e�\�ܖ���ӞF�ܖ\�G�4\�dO<�\�\�K��\�\'��S18�dҢ6���O*!�>Ţ$��&I4Ē�k�:Ĳ�prTShXd�\Z\�a�0�%�Hm$�!�%ԑ*�(�@��\��)\�(���2�$�Зhd�	\�>����a@�\�3#h���\�+Rus���=�^\�Ss�H2\�/.y8^�|#�9e�	\Z&L�L\'\�:lqD���:�X\�s�\�\�w(̆��G^y\Z&�l�y\����\"D��.,4�\�A2�H�&J��)%�ēē\��oH\�Q�u\�A�|��t��:x\�\\e\�2tO\�\\\\:H*ŲW�\�:�8��IؙI\r��\�oP��\�H\�dsry\�Y\n��\�;	lm�\�\�Wga�L\�j�b��LI���:G\�ZE�-�S�\�$�!5\�L�<9�\�k\�S2�����\���N�\�Oa\"#L\�I�\�ި�KV$O� �3s1UӖcȩQ��7�D! �&7#P��\0�g�\Z��e\�{�\�\�\�I�|�\�ȧ\�M�<\�y�ϑ��y�`�\\\�!��\�N\�\�\\\�a�;AH�T%DD4�4$%\�z*�<	$�<K�!f\�\�&�$c�\�\Z�Ǭ�CHk�F\�М���o�� �̑�1&쉬\�`U�Ւƨ��63o��\��CL�C��\�\�p�\��Ja/�\�h��F\�A{I�D�	�NN\r�\�#bcd�\�\�T��U�j�\���\�\\�,�5��6��w\��+\�Cn<� �\��\'\�˒D�A֨\�\�\�IIX�\\�b\0\�\�`�?ඟ\�䂿\�J@XlpCC\�C�\�Z2$D�\�\�&I$�9!�ʉ1�<�\�z�D��K$�=�c7_o\���Bg��\�\�\r�Vy\�<��\�6\�n\�\r� \�5K�1�\�ڎ\�\�\rQ\�E\�6��\�y�CL�D�:\�fH\�\�\��!\�˯�A.�\�\��f	����Еg��1�m�)�Ƽ.\�!<��BV�i\'A�G\��}\�\"\��q���?�\��q�I\Z\�,&I$�I$�6Ix\�2I2,%�i�\'3\r)m�$v\�\�6I m�\�\�\�u\�Rċ0N�R+CP\n*��$�\�	\r\�1\�\�\�\�9�&d \�*=��/�bZ\�L\�d\�\�$��6:2\�\�wԍC)9\rU��M	*K�&솚��\\�g\�$ë\�rL*ୄ(\�\�ju&\�\�TB$tCu\�\rR \�T	x���1iKB`I�H�>�J\�?q�I%�\�&1$ВF&\�\r\"�,�%ܨ�,H�3p�\�\r��\�\�K�&YS���J�U21#h�ۿ�f\\{LC\�\r\�]�\�Ao��#Q�Y��Y�L\�G�rÇ\�@a�\�5	5�\0\��\�\0)\0\0\0\0\0!1AQaq������\�\�� 0@�\�\0\0?\�\���e<ǏH�߼X�O��oNcW(��\���n\"b\�=��W��[<\�DX���jU�\�\\|\�\�\��]�\��\�;\n$�� &�\0\�}\�T\�X\Z#Y_#r�օ\rs�\�\�\�k觼�\�\�\�;��\�-Sف}�\�S&sGY\�UUJ����㡔�fp�NH?_��\0E>l�\�\�8��\�!+VD3y����\�At\�⹙\���)DC8by��\�!+S0\���\Z\�̢W\�3C�(ǹ�\�K�Q���8��\�z{ JW���\0������y��I\�\�K\�7$�؍z�Q\�\�DkU)�9�����%J̠Aò&\�\r\0�\�o\�N\�E�0Oِ��j\�;\�.Mv@\�$\�b\�pk#\�\�^`��a�b��~8�gk�v2��(\�֡����?#�(oq\Z\�t��F�ȡ��2n\�\��ֆ��>ݪ#�\��\0�\���\Z�\�\�ec\�}\��]AD`}Pa\�>�f�\�Heh�zۋ�7^�L�\0\ng��S�U6\�ͰΉ�\�Q\�\�Oca�\�8�Ƕ�%\�9\0\Z�\�2DݝO\�Sc\�.\\U㢹s\�Yh:\�\�\�e����\�\�!�$\�͛H�I�ǌԤ�&Y����d�\�\�Jf2��F�?O\�[\��\0_�9�(��\�!m1\"k\�\�\Z\�7\��4\�\�+}eX�㳏�����>\�<q\�|�\�x�×݉\�ʵ��D�\'�3䘺�D\�y����X8a�iIΥ�\��\�}?�\�\�\�\�_hdb���#\�ۆ�\�*Z��\�`�\�\�Wۻ\"�Σ\�\�%\�] \�?�]�5��3mO�E7q��\0\r\����E�M0�\��5dR5\�\�\0�7s\�3R��<$�@UB\�5m]B\�P׼@4GJ��\�j\Z�E80��wLl�ጺx/\�R\�G\�#mдg\0�v�My H\Z�\��\\X�`#�H�<\0�E������\0�\����(�Ih%\�\�\�4�&\��\�M\�+upq��є\�ܢ�)��\�՛��N.\�R����\�r\�sc��?o�\���`�g;��\\/5�7Q\�I\�e\� M���Ȱ\�.�Op0\���PM\�v9��8\Z�\�3y��@��j��\�i�ɮ� \�\�ø�,�Ǩ\�b߬�k�sG��.�Nqfb���m��\����h�J,��\�(��b��O��\�5+\r�\�\r\�Ԣ�\�\�\�\�\�%�\�;AKd�\�\�\��G\�!ԣ���&V\�x\�b\'��\'p�DB&n��\��5u���3�[���:״�@\�*�2\�\��.?jS=[Vϼ�\�+\�r�\�(\��Ԥ�wڙH��u\�KV�\�\�mu=�V5�\�S\\~��N\�b�%\�Yʸ�Tr�@[¡�qD��+\�QjW�^&T���T	c�ܺ\�`k\�\�M\"i�\�<T��z\��S)Sd@9~H�\���\�:T]\��(OB��T	m�״A\�l��\�n �y�-Q=DxU(\�5�\�F)\�*5 i��^?�\�n\'�\�af쇗\�P�D/p1>)�,s�7\0�?	K+�zGT\��� �pq\�b*+x����\"�W�^,3�_2��|e{������DUcA\�\�e�ݷ\�E\�;m�%g��(�\�|_<\�8�D\�bW3>N��Z3�\�<1R��\�\�/I�O�\�i�M|�\�7dI��Ys\�S���\�\��Do]\"dg\���C�\��\�\�\�\�*Ⱦ�@�\"{T�\�\"\�7i6\�f8~\"޺�\�5\�1Z�\�!�\�V�#�稘ѨK,m�\�\�rq\�O��\�\�����3I�\0�*�_~#�F�_y\�\�\��nO���\�>\�jY��n�����i}ˊ�#\�4Z)}\�8q�?ԫ\r\�W̬���`7��\�[u\�\�xz�.�\�`���a�7a)�1�\�Ts\�/��@�\n�R\�f\'��VEfR�\�\�L�V��*��{���C�E$\r�\�0�\�P@*�൬�R�^}\�HE^��\�Q4�\�d��q1\��OS·Rl��^\�iǼ\�\�O�\�A=\�k\\��[�\�4_ �\�j\Z\nTTx\�TTԯY�ϴM\\\�u�%\�\"h\�n��a9b.HӺ_�:�C\�\���ڷA��b�m\�,g���t\�`u�ehu\r�U�L�@n&u\��\��(]��\�/0قQ\�|Ĳf\�Q�\�G���k�`n\�e\0�=k5\�3�9�5Rȓ\�A\�xk\�u~�\�\"_\�8\'���&�\�\�j\�Õ\�\n>�@5uܭWSߵ�Ѩ��cz�����֜͑3���|t�\�s1\�@7N���<\���S��\'�\��\r\�uy,��o\�^����\��h�A�y���\r���$�%����`9G\����.�\�\�\�Y��3*7\r\�\���aE�+J��\���CvX�\�\�\�u�ɨ\�Ƞj\�YI�!�\�\�\�\"\r�\�\\}�YLg�\�r\�(�Q�WPԧ\�\r���HDl\���:J8]w)v̉Dn\�N��RΦm\�0�p��\�\\\�p%Q]?hq�V\�f�#�R��\�\0Pi\�w\�;F\"\��U���Z\�\�pB`�x�\�\�\������U.10�e\�N|\�{\�Mۭ�cVQꚙ\�I�m՗G�O\�}�}\���Uϙ\�;\�,qq�`\�n�XIi\�A�h\�\�W��\�\�[������u0�\r#�I�n\"7�?y^�\�@ݘ~�\��\�\Z�\�;\�^\��Jp\�@&�r_s�[#���۹D��]�{�����[\�oг\�fc\�@\��\ra\�|G\�M+\�0	\�bqs0��\�\�or��.A�\��	gW������,(lN#�TF�\\\�hi�e\r�%���<\�@ĵs�\�\�t�Bŧ�(\r�\�~�=-\�X�Bݙ�K��h�\�|K���Z�\'\�zB��X���D� Ci��vC��U�q�9~��Z�\�t�f8rA�,J\�e��P�4\\�/C؎؉Y��\�a\r-J\�\��A�0��1\�+	�����\�W\�EK!��\�Q��\�1N\�\�)���A)K���5*��\"\�\�:�dƣ��\�J\0<.h���\�\'���!\�\�jP���9\�f\�h\����8�\\	��k?y��&�3\�_d}�N!\rz@�Û\"\�.\�\�֙\�\�[\�Ռ�ڿ��c`\�+�T\"\�U�h\�\�J0\�Zb\rr�\�c\�\r#D�e\��o�nJA��5*�\�R��^6���8��\����[(3xu\�0�r6\�\�\�+:�\�avB\�8�\�3J���R\�8\�\�\�T&\�eP\�㸝Dm�+/\��\���\�\�\�\��\�\Z\�\"�}v\�s\�\�3c��I�\�\�\�\�\�\�.\�;�-b�IJF��\�7\�y��#�F�1��\�@�\�C~�n�\�<��0��P���Tt�ѻ \�G\�\�>ל��cIO���j���Ob��ۑcJ</\�\\\0\�\0\�}��\�\�\�7�\�e�\�\�h�E\�\�\�<�5z�E\�<x�ws���#[�D0\r\�tEr\�B�@\�������\�\�9�:�\�\�\�0W\Zk�ٕ��[h\'\��\�R\�k�+Ck=\�Ϙ�\�\�!A�\�n7N�\�cI���\�vh) �\�+�1�\�%V\�?^Ȓ\�0 \�C\�=Gi��!	y�?\�p\�ʗ�C\�\'�%c�\0#�h�\� \ň�_d~�����U\���x�����\�YZ�G�\���K�Eo\n.ێ%U2���X}H����OA|{ 3����a\�1s@�|Fa\nM�4������|d���z\0��xڀk*R��\�g\�y\�����bZ\�\�\�W*唳\\�\�</\�(E\�\�M0��\ZC#n\�z\�k�EF{\�àE�^O\�U\�\��ɠ\�\nC¸�\�	oe\�s\�\���QAXƺ�T\�\�\�4�!(�Z\�D�7��)]\"��F�>���ظ8ZC��|yX0\��\�\�+E),w\�jg�xo��$\0\�3�+\�5ZPn\�~`a]P<F��\��!2^�h�e㈌d���\�V(\�<�\��\0\���\�`��i?0B��}`\0��\Z�K�)�~��c(^ی�ݵf��rt���b0~ci\�\��-S�\�\��/�@i\�?x����*(��Y����(\r\�O\�r\��U\�\�g\�Ed%t��y<\��Y������15�xm�(2\�%\�\�.\�\�A#��\�tP#w��\�?c\0�;L��!\'(�\��Ì�a���n�\�>�+�u+�!�l[�٘V�օǓ[X�;�\��W\�\�V50�n$x�=�,ݿ$�?�%|�Ύ\���y/�\0L�lԷ/\\CW}Lܵ\��m��2�\�}\��\�]Dx�9\���-����\\�\�\�\���_z�8A\�U*�\����*\�~b`Z\�m#\�\�Z��)=jL��U\�\�\0{�b\�\�fc\�\"\�\�NL\�k&ֲ����Z˔7jn�P�������AZP�\�>�8\��\�\n;\�\�\�T\Z{�\0SM�g\�*Gʭ\�Py\�\�4ÑE]\����\�[���ϮGp\'�b0�պ\�\�g��\�r�\�ӼDW\0qn|\�q�-9?\�p�{E��\�a0�:,�~\Z<\�@�Q��\�\�Z�׼�\r\�g��\�9ψ��\�+\�cK�vC.`\Z1�\�\�(q\���\�s\�\�\�x\n��P�Q�ȸ���\�kZ�^���F踚��\�\n}`�vc���\�Y�\�ʨ�\�}@n\rx�{W�Mj\Z�_Y�dt�ls\�Kx��\�QG1E�k&�)\��\�\��@���=�	a�#}\�h,\\�\"f�n����\�H�f\�;�\�vu��\�6լdv��+d�*��Ӗ1u)��/��K��\�\�ʤ�^\�\0�-�\�?�?2��\�\"�2\�\�0\�E{��\�@\�<Tq\�+\n7\�ģTy�J\�^\�j��2�MJ|J��\�\�}#\��\0��8\"i�ና\�Yx\�.���\�+�W&�fϼ\�\0,\�#\����\�\�\�sO\�3\Zn�\�⒭Ҹ�=j\�P\n\�Q!^��SY\�b4�\�\��)�\����\�m\�\�\�<.�j*JY\�\\���K\�55qᤡ㩢\�H�+#�7��\�ri\r\�Z)}r\�}��B�\�\���4\�[��!b\�q�E\�*\n��imn��\�n���[�\�h1�\�V\�\�8�l��P�\�<�y��\��Ġ�0�\�CH�)Cz��+nƕ\�\�]�M�/�U@ha���QP�SK�-J4g��1V\�g\�\�W.�E\��\��-al�Z�\nPҭ����3Աs�s\��h���h\�՜M\�%\�o\�<���\�qN`\��5י\�0�|���R��\�f�ŬV���\���~\�\��o}\�V��\�5\��B:���\�_U=��\�!\��J1@���\"\\\r_�\�\rf��ˍsp�\�nS��4�\"sZ7\�9�4(\�4�t\�\�\�1ɴ\�o\�}>\�\����ҁ+��\�[�]�\�/	cY\�R\�\�3]-��	(\��쁠x)H�\��\�\�yP?��?y\�?\�*T�R�&멉��\�\�\�n#c\�\�N�`�Ϙ�Nϼ��y��\��+�iV\�\�\�p\�e�q���/�]�\�f�\��3ս6\�ְ�gP*\�t/N\���\�\��h\�j\�Y\�\n\�\�\�\�&�U����=�}�#��)\�#\�Eʃ�X����\�\�ꌸ�C��c\�)�\�4&L\r�\�o\���0:ܫ=\�!e���\��Ȼ\�#\0n\�\�L�آVN;�_\\\�\�!3\�X\�\�S\0��\�Js\0puKĬ\�\�e�o�j��+s�`\���3�ڏ+8{�\0�O@�f\�\�\�f��V_��j]��\0C\�\�E)\�Z\�P^��\�Qu/�u�\0&0r8�x�b�/Iscһ|}\�\�b1��\���W\Z��-ߥME\�5\�1\�\�\�\'a\�\�\�jm�W+���`\�\�]JSI��E-H���\�$p\�\�!�\0�<�\�\�k3I>H��l_I�~\�\��\n\�F�xgU--N�-\\\�\�<im�Q\�IF0� ��jB\�&o�EXw���\�t�=\�\�(\�k�d�\�j�J��w����\rt\�/V:\��O�i,���\0\�w@tˍf���Vn�Z�����B�D�*T�\\G4\��8\�m;��\�\�ԥeɯ0r��4o\'\�mj&\r7\�t&9�1̦s�\��b��\�Y\��\�r����Q�vG��̣VZ�v\\ɞLa\�ڼq\�u���\��J\�Z�?cG\\\�a\�:��\�&uz\�s,i���\�P�D��.uܕ��\�hTU̍	�/\�b*�+{�4\�\�/\�\Z<�Mj��\�\�Dm�V\�5�W�o)\��]D%�\�LW)5�9u\�>ق�V\�@\�\��\�\n⻃pk(�mo�b<XFs�o�Ȝ1��Ǭ\�\�\�\�X3��@hT\�\�fb0��\�J�;OI��z�cA\��\�\�4G\0\�.��7L�!�^D�	żX7�0dJ�\�&\"�A\�W\��\�-Ms��\��f��2vY6!�n:\�\�ybk{\' 6M�P츜�\�P���\�i6�\�KS�&��\�T�3/\��^���e?L��Q�g\�[\0!%J\�d��\�\�\����D\�\�S��\�n����\�\�;Db�\�\�UP��P>\�\�_0��\�6Ա�\�\�\�?yGDPҐ�W��\'4?rJ�\��A\��Ҿ�.\�\�*��~R�zD�0)p\�\�%\�\Zœ�=%L�`��4\��ʡ�\0\�~K��ڃ\�1#OE���ʶx8��\�\�p�����\�*�\�\�\�\�\Z\�h\�\�-y��s�\�Y�\' �.%1�\�?\�\�(Zyt\�]0J}_(\���\�\r\�r\�p��&��!\�p(j\�9+s$;\�\�朚J��\�j�\n\\�\�&�.�b�\0�]n�.\�Q	J_�\��#\�\�\�X\�Q5ɸ��[eM�e.yj%k�Qm��\�iv�!As\"w|m�@E8\�\�Qn\��\�q�U\Zs��\�����o*���@��	�\�`\�̷Ǿ� �\ZR��\�\�/�3�5�\"{z\��Qż|����Gb�P\�V�\�~�( t\���\�T+zݱ�4u)\�h_�3 �e���{\'y�\�J��\0S)\�\0�\�2p}s�\�2�d\�g	��\�$F�^~\�\�a\�T��G�-;k��\�\�0:9����&=\�\�(\�:V�\�4�T\��\�\�%�\��\�\�g\r\�j�	J\�\���_�)\\K\�\\D�C&&wy��l\�jQ\�Ѝ��\�-*LID<x*����[҃�y3�ƣ]D�C\�D�Z�!T\�--�\�S:Sa	Ez\�포\ni���:w�Hx��\�\�F*E�\n�V�\�\�\�Y\�<��:\�Kui1\��\\\�lpp\��Aeu�S=YJb\�\�s�bg��\044\�>%]Ţ�b\�*�\�\r�u\0\�\�s|\Z�\�a�Hĸ/\�*nh��\�\Z8\r���1]�\�\'#�D�z\��d�ݥ��\\-c\�5+�i��\�j�tֲ£�^�Ql3��p4�*��!�ؼX߼\�Y,M�VM\�c�\�.�>j��\�#���3�g���œ�\�A.�\��O�����\��Y��Z\�\�r\�\�\"��\����걏�B)h��3��coT~\"j��0d\�̥\�m\�iD�\�<\�(ޢ(�\�0Ɣ\r5\�-!��\�\�v\���p��\�Z�Qf� �C\�|�(Q�\�\�`V~\� tI\��30l\�\�K\�d�!�\���Tm[ N�b���\�!��\�\0϶ h�\�\�j#FR7fz�[�{�?H��Q��\�*g�\'�E\�-�\�b\nL\�C��$���\�Kb1�/MJ��\��C(�bJ�+\�TLJeD�;�\�t㤽\�ʧ\�nU�\�HP_0W\ZJ=c��ސ\0&~\"W\�\�<K�L��z50\�k�Hv\�\�L�3\nf0�!\�\n����\�Q\\-��\r�-b�\�Z>\\��J����ܗ����\�V�\�h#����O4�?\�)5�?3\0�(��!Ȱ\�	pDT3]0���p\��H�%\�ūN��\ry�\�\�nV�!Ҫ�\�\�==�1\��4��\�t\�@XCW6\���\�Ȁ\�\�9#k \�C�\0\�b�\�\��	�\Z�%y\\.\�P1(���jt�-�o��\nv�zD�\r\n\�?�\06�C%?�<Ha�5�}cX���C\rTB����$���\"�\�Q\�R�\��=E((�\�\n�& �\�\��C{\�?�Z���Vw-�\�\�3�m��\�0�9u�f��[�fX�@�zĢ@qH\�\Z~�@h�ʙ\�^��ezR�\��噅\�\�\�R\�O�<r$}���\���Y���5{�\0��(Ю��_֖Q\�\�!G����m`G\�\��a\�qU�dU9\��l�(~\�\�ϖ> @�ldP�\�H\�\nၣ�Ꮼr\�u8Dn�a�%vJ\��ꜦH2ʕ��J��Dc�#\�3�y\�t\�ۖ*v���0\�\�1�\�o\�b����y�\0M�L*\�*2\�K�\�\�G3Z�)\n>�\�-ACm5y�\�`�g\��qv	��-�\�p���\�*\�g\\��3.\�Y\�4E\0����\�\�P+�\�\��4�2�\�Y��on��\��Ⱦ�V\�0\�\��\�`\�:�&Ņ;��\"�8\�Wl\�ʵ\�5(��~\�\�#6\�;@ P�\�\��5����K�/ۘ:�cÿy��\�Wl\�J`�[\���x�_���DΪ[gb��x\�Е�)LJ[a�Pi�\r�B�AgT}5��a�\�\�E�S�\0c�\�\�$�MJ2\0g\�[��iQ5� -�\�q\�A�i0����d\n\�.0=\�Pj4Y���,�gUBJ)�u\�ˍ\�\�R1��<��Fs\�Ŋm\�\�0H����;`��y֠l�)�&\�~R��)Ő\�\�?\rv\�z32\�{?Z�\��\\\�]�\�Y��\r���Ǥ�nھ�J\��V\r.��\�5:\0f\0��%j)\�\�\�c\�Y\�UO\��ŜgC\0��\�,=LA\�\�t��\n�w��[7�t^\�\�/\�X&�d`\�.^�~h$�\��Fߖ�j�f~\"G\�*xC�02b\'��PJ����%���ܽ�4\�P\�\�p\\4\�(\�\�\�[0ȹ���s�\�\�\�0�!�O�\�3|�05[L|L� \rU���\� \�PS7\�<r\�Wly]x�u����l��ɑ0�pB�\�\�s�@Y��8��d\�\�\"\��.El5\�\�#��\�ץƛ]Fe\�U����\�E�\�tZ8X���56�[�p\�0HL\�cٙhjQ\r@M~��U�\�\�\�Q4��s\�\��a�5�[Olc��\�[����\�\�\�\�k!	\�\��V\�\�g�Gh�[\�\\a��q�̱!J*\�>a\�\�67\�H\�qSD5�\���\�k#\�\�)(V�R1\�z�\�KgǬAz*vkj\�Zu;�\�g�ߏ0R��[@c\n�%D\�@��1\�r�\�j;q�?�A-�\"^J\�1k=�ю��y\���~\��!>=�`O-j\�_PoF\�\�Qຼx��\�\��Kj�3���s^Q�XR�Fd\��e��}�P�r��+�+ҕr�g<��#��Ff\�C+\��D}��F�Y{~�\�٩�ȿ\�4\���\�\�+�\�8I�k��\�����\�e\�\�t\�@qf;?pt(\�\�a.J32i\�H��6�_�T�C�\�P\��\�;��\'\�TH5=QN*[�.�RkS�y���c��;����8�\ny��\�c\n�\�\�\�`\���{�Te\"\�Q���T���^\�\�[�h�\�0\�½Jm\n�z��<N%�Mlֱ�-ҟ��\�E�Ƥ�:\�.\��n-�J\�|#\�挖���*\���\��-<9�գ׈/U��Y1`\�\�ԑ\0o,�\�C�\����\�X\ZW�t\�sC�f\�\����]c�(q1t�x�)^\�\�p�aiy\�倩6���_\�\��\�r�hW�B��V�F\�\�P\�c�}\�>�DZ���\�((�%\����E��y�`D\�Jfb�\�\�f\����`\�ǀ4��t\�\��\�X\�\�^\"hxYMgf�����P\�5�\�\���Q���fK�\�K�\�QZѠ}׉y\�Q-�פ%�hJ.ܶ{fj\�W5K\�v\�e\�\�K�S�\��C\�n�/\�V�yL^�ශ\�KӚd\�cx��\�����*S:	x�\�Z�\�xpy}!���{�t\�h�!/��|F\ZſH��J�5�\�D1�A\�mƸt�m\�̯,�%�\'�2��{\�V@�����[0\�\"<�~ec\nP�l��\�\0B���AM}>ы�\�Y�ɔGK�\��$H=.1^37�{���ik\�n4-��\�f<O|&Ρf��g��^�\Z\�HRӉO���9�3�\����Hf�\0\�ħz\n�*>�[XU�a�\�\����也x�h%B�>������m�c�}���i�\�[��f�\�\\�@\�Sƚi\�5\�\\\�1\��Ʀ�]i\�0h���h}\Z)�c��\�\�\�j;\�mT�\�HU\�6\�M6�\�h\�ہ\�E\�-:e�\Zc\�\�\�(d}{�yj\�L���Pq���\n \�8�n\Z�\0ק�\��*կ_�̴6m�T\�\�s\�.lu�\�\�n\��\�p5�Î�ꖔsڗ�&\�\�7L莴9�޳^�\�\�\�E*�\�Ø�\nT\Z��\r���}�\�\�*�ul�ј�>L�\r\�_F\�\�.�ȩ~1���U�\�n���B���0��U0(\r�O\��ِӵh����;��ӡa\��|\�\�@K�Ws��9�\��p+2\�:����%��M�L\�e}�\�\�ɱ,{\�p\�B\�s�\�*�Տtx��\�&\�\�\�=�\r�k�9p\�f�[=I�n\�c\�\�\r\�W�\�S\��1\�\��<��,I�lsG�!�� =\�DW\r\��N6*�y�+�\�����3�H�,q�\�q2U�\�\0g?\�W�\�W�4�,L\�9�Fν ~�nh�֠V\�Z�\\/�\��\��/N\�w��UT��\�ķq��bz!y	�����\�x���%P��5�G�\��\�B\n뛸�\Z\�}�by6%��-\\\�Ikk����L�DK�R�M5\�\�+;qa\r)���Y\��\�{Sp�q]��\�;���\Z���\nC�\�AV\�W�TF�M���\�W�a��M�<�\0Sǅ\�w�q���<��Z��\�\�\"�&3Y;�\�4iṣ\�\�;[\�[F��\�|�\0�%\r\�z�!\�\"�Qϴ5/CO8�L�.\�Zܼ\�֯\�\�<z\�o�\�#yzԥ�7\\>!Ȼ�DpZ�\�F2jXQ5\�sd��R*�<C\"NY[\Z\\o�&�[�Ձ|kx�(��B�8�^\�n�E!P�����\�s\�\�	\�S�\�%\��1\�.f�)\�C3�jVA��P@�\���F���\�W�6&\\]�zC\�\�N/\�\�\�5%Tj��<3�\�X��\�&\�\\_\�:�\�fA��\�5%��6��ұk��\�\�j�\�\�����\�\�N\�dǷX�\n\�/q0)\�W\�\r�\�U�e�Q�m��\�G#\0�ӡ��ܵ���QY�Ȱt\�\�[��I��U[�_\��>��,�%\�1E߫1�۫J\"\�v\Z�>w�v���\Z\�}0e�Ih��\�[\��Ǹ�C\�ӹ�t\�e�\� *\�j^�k\�\\D\�d�,Z�Ht�\�x\��z\n�8�\\B\�LK�H���k�X^&ۚ[\�f�O�G�\\aD�S��\��k&�76N>�\�\� y��\�p�AÁ\�y6�cN2\rJ\���f��{1M/\�#-P��%p_梅mZ\�\0\r\�k\�8Ӄs\�\��\�h\�7������0M\�ߗQ ݣ�7\n(�\�\�\�MY��a�y�Z�*��\�t��\��Q|s�0�\�e�\����h\r�\�\�&�Cj90t\�v�x8l?XVpפ*�P?��\���0�>�a�2\�\����W\�/A\�jè����s4d\�Cn�S䵠�D2zs\�	�I\Z��~������Y\�N���J̋g�!�q\�\�K�a�\�=YX%�\���2+qH�\�6<׉�e�����\�\�@F\�T:Sy���S\�>fik\�6c\��C����0,\"Ӈ�\�U��\�\�R�q\�َ㥡Ʈ�\\��\�D�u��\�\�4^o\�$\�\�6rk\�^�4�w9կ���;\�|{�%��\0²�\�&��z4A\�\�īv\�Ԯ�\�[\�P\�\�0\�\�\�w3s#��G\�\�CQq�$\�C��Ⱥ\�\�7��W3�%\�\�\�\\`�R\�g�~X�˿��ڐ{&�?\�n]^\�\rQkI��,��\�J\�\�,�\�;.\�ڥ�\�U�K\'3���\�a��+���*\n�u�Q��0�\�C�_.T\�\�D\�\�.��gS}~�m\�\�O�+\�%\�\'�\��s2\��7�s.�s3R\�2�1ٶ��϶ \r!\�|���f�?1���8�w&�U\�\�	z��nM\Z`�k\�&�\n�(\�\'��](�ڭ���a\��l8\�\�xѸ�\�e{k_\�Q�V�5�o�\�\��\��K\�׭J����V\�)4q)0盨^T�>�}f^�²\�cx�k	mM\�M?\�\�\�|D/{��\0U�Y��\�\�@95}x�F��9&G\�\�{�2�xb5��[WW\�90\�\\����\"`�%�]Eh�\��\n�R\�[K7r�\�qgk5�\�Й�qN�Ƽ\�����\�8,\�\0�;�\\;\Z�`��+�گ\\N\�\�\�=�F\�4]�z[~\�!\�a��w>��g	�(�\�y�)M�d��\�\�.nX\�s�\�7�0U\'+/\�\�\�6|\�\���Mo�,��h%@�Ջ�i�\�\�\�*\'m\�\����\r%x��\0��ٚ�v\�H��^\�u&V1T\�D^@䂞�e%7\�����ǫ\�\�lB�G^g��q\�P\�+JB�\�6�\�!\�a]i�B��~��ʎ�\0���J�\���>wd�\�Y\�\�S+�)\��\�\�A��DT\�@�+\�%K�\�xKOo7�|Ka��v�k.��1���ĵI\�d0nU���^e\�jza8���%\�P�!�U�@RpB���Ҽ���\�H\�a��S\�	��UZcW���h�\�-\�.\�7\�k{�AV�T��\�\n\�\�G2�Nd�\�\�+\r�)�3\�\�l<�z���2b�\�5s@1Њ�Fg���*cYh;J�^���\��\�?X�8q2\�~\"\�\\�m\0�/P\�	\r.G��͊(J�_|kZFjZ��\�҅�\�5�c\�e�\�f���V���<F�\��\0x�\�\�b�ǉ�\�\'��\"\�m�\�V\�p]�ǘm\�~y�}�Oʍ\�}\�ڔM�\�#M`\�1�R��\���B\�*�7T)�55���P�\�;\� �n�1��k�Z�ѱ\�\�Ĭ_l�o�Ϧ!`ϓ,&W\�D��R\�lQ�/�\��U\�~�\\\�^M\�\�PwJ\��\�\�\��\0S%G,f\�\0R\�Kf�q06jJ./�\�rTPm���eɧ\�R�c\��qgaW�\�\�\�\�]́\�)�\�R\�bQ�\�\�U��=}\�\�nW_\�X�O\�<�ܙ![\�ч\�R2j�\�	�W�R���i�\�D\�Ԡ���B�\0\�S�\�-Ć\�\�`���\0��\�f2�WJ�x\�\�\'�\�!����ߐ]�f�\��\�1��\�\�4{��+��\��\��3%6��R����4\�HR\�y\�\�\�?�ؿX\�\�US\��Gc�b��\��L0����N�c\�zd�(Q\�e\�&���\�\�&�EU��Rl)\�\r�fv��������iG�\�_�+)w\���I\�̮�d\�\��\�K_@ǴiB�k��\�� 29��`�\0�Q\�}�mE~\�\�+\�\"s\��H�`6^x\�P(\�\�\��\�e\�*BKF\�\��\�a\�%@V\�g0\�d��k\�?\�q�qMp䈥\�-J��J.\�4v>aRB�n�\�\�[em�\�\���\�~��w��ӔTr\�pW����+��8�x�\���Kc\�3-|�Yn\�\�[�DCDc\ruFM|\�q)@>�\��¶\���ط\��\"fek,E9\�\�\�\"�\�;|��\�x�ߪ����p^i\�߻1hkP@W�\�ZU�\��;c��mP���4&Ww\�b�j$��[gR�`���^F�\�0J�]�O|C!4\�Cu\�ʒT\�\�\�V�\��;�Wk\�`Q��\�\�I\�5\�n&�\�\�&]\��\�E[\0\�C\�zh\��\�\�p\�rv�?��\�k\�!��\�X\�tƯ��Խ�\�iq�Y�O��p����x�\"e���\�YU^\�\�i�\�@�[J.\�\�`����\�\�\�Pݏ\�=\�\�\�o\�#��\�|q+\�T6��Ҏ�)z��)�5\�ᬟԽ�u/\�؅�D�˝\�s���e<f%���+E�7I�\�\"Z\�ܻ\�pF؊���Q[N\�\��ueh=Z?1\��d�\�.c��\�\�\�m\\�\��c����\n�e-HsxO�DU|.��ⷈP�\�\�\�\�\�E\�aib\�G3eE�ŝA\�,\��J\�	\�f�\�%�\�~�\nИ�c5��\�5)�Ϙ�īQ��y��\�ϐ��\�\��f@\�Tj]V�c0\�\�q��\�`���o\'��\Z�]�\�s\��k\�#\���l�81ȍh\�Y\�^@Cǘfvd\�u\�-\�\�f-Y\�\�B�Z��\��\�#J20���Ģ���\�\�V<L\�۫[b\r�\0D.M\�i��f�]\�\�o����n\\�\�v�\��\�E�ѣUq\�%F�����Z���wY�$w\��\�(Xb\�4��\�\�~&p8�\�\��j\�]�⎲��:-:\�P$7]d\�\��0T<\� \�[\�%\�g\\sKy<u9�g)r|s�/e%1{�YL2�\���\��V<��e\�\�\�&�_�cȻ�j2\�/2��h\�{Ayk0�\�%y��\��>�{��\�9�|��5Fq�&1��gT���}\ZN�_Z߱sX\'C�+�w\��z�W\�\�}\��#R�ʪ\�Z6h��B\�\�v\�g�NBSo�\�2ħ�V\�\Zo9\�O\�r\�\�tWj��^\�Y����t���6s�U�x�*\�Vo;��)\�pM�\0[�\�\��X�I�k�y\�I\\�\�������aĝ�XqSR�\�%��t�H��TV���=�H��O`V΍79�xڭg�l\�\�2��m�--~�Y�\�jSs(M�\�\n�{>`\���\�ޝ1F��]/n\�\�B\�j\�H\�T�\�`~\�PV�7�C�#\�Ҁ4�\�\�>\�i\�\��S[���\0\��H�\\�[�C�}`\�\�Z�Q\��\�8 C�����:�.�@�\r�\���\� Ƞ,�D-S [\��E*`9x<�.+Z��Oĭ�Mv<��\�R��3x\�\��90|\�=GF�ہ�Um�H\�\�W�����%{k\�e�iN|�ߘ\�\���\�;�7A\�\�����^x\�4\�<\��w\�\�8��\�0\"5L\�]\�u9tT\�v\�r\��&U��\��̹睤��\�\�efWE�(\�R\�\�Q_t������\��D\�~\��\���T���s\�#\�\�\�A�\�i��\�\���\�z�\�/�R\�B\�Y�0D��\�������\�B/q���\�\�`��11�\�3�171\�\�\��F}R7J�Mޑ6Dۨ����;\�٘�T򹑯�\�+$B��ܰ�\��a\�V,�t��\0-�\�X�.�\�I�`U-�=��PU7!\�[.7L�(�3��є~�\�Z�ن�q\�`�&\��;}L�M�a֫*��1\�\�pȎ\�\�g549��O/��s\���\�o���=�1\��KX�\�\��\Z����\�#Ta��\�;��B�\�g�D��p�}\�\�\�k2�6��{���iK\Z9\�X\�b�\�N:�8�e�e��G�`2{0XŒ\��N��\�HDƿ�a2�\0�\�\�Zp6��{\�\��\�ϲ�	`\�\�\�a�5�\�{F�[y���&��1m�\���\�P%^W\�\�\�\�Эa�\';���|znSw��=\�\�.�\�/؍X�5��B�rK��DK )Q�\�F���X\�R�zB/�\�\�\�7m\�v�\r�)iN76f֞#��\�%R\��S\�P��g\0\�j~\�?�;eܧ��*:C~H�\�P\n�3��$\�\�	�O��C\��zO\�4�O�ͤ8%GT<F\�\�Z�ĉ\�2nvF*��\�Խ\�qqW�\��8�\"\Z*�L\rZQJ,\�:PI�\�sa�YA`�+\rj\�^!�5�!Մ:Ť\�\�[�\����Hxbr4\��Ʀױ\�\�*\0�hVuP`?U[��\�.�\�\�͆\�4�%S�7�E\�mt\���&\���(\\*��\�o�\�\Z4|������\�a9��R�\�=\�sKO	K4p\�\�|@�iF�\\\�o�oN\���Y_?����\�\Zp`\�+tk�MO�L+\�e2k`\�\�\�X�\�Z\��!3/�\�4è\�\�]0(\�_�q\�hgy�F;\�x�u\�쨿M4��%�\�ªr\��\��\�\�`ULt1�ƻ\�B�D>�\Z���\�\�\�⹔mwBzY�繲�\�67\�\�\�y�)E8�\�P�n��Z�L;1�і\�~̬KM��\�z�\�\�\�h۷ۚ\�\\@(aպ�D|\�\�\�6�^c\n=���\0⧯\�(\�\�7��s�\��\�9��*�\�L��\�Q�\�x$	\�\0n�\�\�\�f����\�(�\���\�R\�\���쎎3i�Nf �FE�:(`&+h>ν \rBͮo�\�\�\�*����!�\��\�]x�У\�^\�g\�z�7`O\�\�p�\�8\�6şH�\�\n�_\\ո$}Z[<\�*�vM߲cg	�@6\'|�S\�Ǥ�x5~&:M\�ti\�hX��q�\�R�\�i�$[\�A��Bo/�k��Lc�ՄJa\�l��\\�\\|��P\n�ϬޟdC+\���e���\0\">��\�F\��\�\�\"�\Z{˽FM/̼\�74<\�8\Z% c��8��;?2\�/\�%�mn�\��	S.2�\�c3��i�\�`\�k�\�\Z8ۈ¦S0��_-:�5E��ew���\�\n4�}\�Ҹ\��s\�\��f\�4\�e���rn%�%�P\�(tq~\"a�\�\"jѭA�/��\�\�d\"\�d�\�n��]�+S4Oo��@W\�\��\�$v��91)5�PqM\�L�P��ߨ\�rX�����٨��hEى�0g\��\rrf�,\���G�r.��=#\�F^�?I���\�n6�J�\����\Z�\�Ox�)U垙\�3\�Q\�;��\�\�k[��#uR\�\�\rޗ_xo5z��;��q\��?����L:\�VA\�V�E�\�&#\�\�܁QTr5�z\�/!v3\�7\�	Li��@�Ŀ��=�H�zj9�\�\�\�\���� =\�O0^��3��\n1׎��\�P�ד�\�\0c5\�O�c>��P2�\�%`̧�L\r\�\"h�q\�X\0**4	ix!K-L\�[�J]AZ��B\��!\�:���؝?�N9똛g$\��\�\�v�\�Lnȗ�\��c�:����T,\0�]B�\'}�\�\�y��q7�J\�Xf6�i8�\n��Av��8MQ�\�\�\��\�q�l\�\�!\0ۭD��\\F;V1�E��B�\��svL�d��B^�w}	�0\\��\���V�G������� �k� jèӮ�r$�z?�\�C�ܭ�v8\'\�#\�\�\� \�\�z��KbJ[\\��y-�\�j\�2�rh\�7o\�p9\�ݟ1E���fxr���b\rd\�3��z$Rҕ�\�X�E�\��~�\�R80[�v�e�yE#\�STÃ\r{~`�{\"�u\�\�IZb\�\'?�A*Ч7�˭c&}���\�\�x�\0���wq��\�\�B\�\��EP�9\� l�-�zO`��ƣ�6����5�\�qG�\�p�O\�+k\�c�@h�\�b\Z\�M6\\8\�\�L�\��g(\�i\�X\�q�I�\�\�\�\n\�	)�&\�~�`ͱu��\"���X{GH\�o(\�P\�oH\�A�N�\��P��Ѹ\��U\�9G����\�z�l>�d�c�Ċ�=S�(S3\�7+�\�.0L�!v\"4`���FΡS8&\\�ӱ\�Ad�q1/���ݾ&d\r?h�L�\�]:\�5k\�K8��˭���\��8ٯ�5<\�$V1}�T�)��#��i�\�S\�\�h��K�\���S!_\�L�\�\�5#�g��?P\�\��\�\\7.�\�\r�@CeX\�k\�.5�\�\�\�߻5�\�\�( \�p6�\�S*Y��\��{\�5wh\�\�\�:1;��\'^������җr\�ˈ�\�\�\'2�\�!ȑ�o�\�-/��m1�,\Z��|^\"@�YC�R;咋SC��\�\�\�\��m6���\\:\�U8�?\�	��2\�\�+볭Oqx�fZѸZ�Y��MT����>_U�bauWL{b&�|\�^{�LJJ^*^n9s\nT��\�=C�<kJ�\nڑ��c��UP\�li�\�\�q�:m�\�~&s¢\�׬e��%\�\0�჆�p� \�ȗ�\�\�z\Z\�\�`%�\�fF\�\�\�+`�\���l�\�b\�B�ps�\0&&#Nl9zhB��u\�3M�\�-��pz\�\��\�q\"g��T\�\0�F���\�sx=OV��@���*�1(a\�\�X[\�D}\�l��g\�~\�/A��\"��cg?\�\�\"��\�>�\�R{E2��\r[�\�\�Ï�j`11��	�M\�A�\�p\�t\�l�[#��\�~%����kg�=�\� U*U豯��\�bہ�:\�\�\�\�\'\�z��\�}#\�2o��+,�\�q\�ĔhvY?_\�ԕA\�Hg\�7�k\�SPG�\�D�\np<JS\�-�~=g\Z�V\\� �\�\��\0}���\�Eـz�\\2�je�π�\�_5/6\�ϼ��\"{n�n�\�H�5�\��\�\�\�.\�qR�ў�f?X�Ϲ���\�\�^*bt\�`ݶ�S\�E[\�\�d^ކ?m..\�;s~0W\�YAa�^A��1\�I.\�ݧ:���\�H\�\�j�\�b��\�Wr�\�\0f۠�\��\��\�\��=q\0Pm�n`1\"o�U\�5ϴ\"p\�X�\�\�7�\�TUV�p�\�\�\�٭đ��`-�o;*\�}E�Wj\r_L�!Ö�\�p�$\��\�\�\"\�t\�\�I�l����\rT�5\�MK�&~a�&w\�vY_g\�1\�j5\�8 �/<ähz\�#�\'�\�d�>o0)el��t��\�\��5��%�\�B!\� ��k=#�&y��x\�ĵ�D\�X�\�Q@m\�Ň2ϣ�R\�}gr`_�	�p6_WP\�*��\�\n\��\r\�\��As\�p߈i9\�?|KڢG\�	�\�\��\0;5\�_\�K�aO��\�m��@��jG\�^�\�\�\�v�\�\�W�nچ��}	of\�V�o�5�bZ�*_q�=}�s��#S\��\�`8\���q_\�Ng\��]3\��!\�\�9N6h@\nǚ�&*\�I�\��:�Ł8\�]9�m�\n\�\�%\�\"\�}|@�f-9��ءk\�\�x��sܛ\�\�C��z8�\�I���yu24���]�\0�?H�\�\�\Z�\��\0�#�b\�~��!\�g\�Kl���맟Xn�S,4c\�\�U�����v#``�\�Z\�G�i`��M5yK�\�y=�׫m\�P\�jV���q߉��^��\�!�⯩\�z\������%ո\�\�\"\�%�+^N� �\�\��i7D=��a\�O��\\vW)r(\r\�Z�͛\��R�1��u���@�\�lsFN\�T�� �o�/u�x򱃆��\��\��bp\�q1�\0>]]<��WIe\��7̴\0o\"���tc<\�1��mx��\�`	QKΣ�W�\�ǈ�E�\��9i�%�p\�@)�W^;�\0\�\�\�0!(A\�\�\�c4p\�P\�(\�5�-�����)<,��i\�S\�r�l&�\�\�I��\�3��oV�)�\\�Q�L�B\���)͓y�2@�5�(^\�R�\�=\��\�Hc	\�8P��N\"�4Ol}0T�ʶ\�X\�\��\0�\�{�� �<9 �UO�\���jZz�8o�\"\�%!��h��#}J`\�\�7�J^\�\�e\�;8��6�A�\��q\r\Z`^`V|�2��\'\��\'\�~\��G\�3����<@�����z��\�5zB��=��\n�D�%�d�Sa����j�;g��sN���y�\�0�\�a\����\�\Z�#S�\�y�Q\�\�\�+j�\�ψ�{�\0�wU��3]Ä\�r��\�^ᷴ�>�f~��L��\0i�nZ��[\�T!P� /���I}̄\�� �q7\"��m\'X�\�80�j���Ǣ\"��`(�c̹G\�W�V^e>�\�`��n�\01Z��7\r9\�jl�����Ta�\�(��jI�XP�po.��J���2�\��6Y���O6\�\�|\�Dz�,,9\�穊Z\�xU&\�ސSA\�\�\Z�LtU`��9V�P�_�M\�⯛\"ǵ�-j�y�+L�\�\n\�0\�\��Tg�\�y\�%ޞ\�\�\�J\�\�̮��ზ\�)��\"0\"�f9��OCU`\�:i��\0v��.�]I�u\�\�\r�ۃ\�\�9%��ܠQ(�f\�\�r/\�\�@Y3!\�\�\�\�\�	G�\��5���Y_ID\�\�k؀��\��ώ=#ԼCu�0\��Ԭ�Y\�g.ar\��\"�eŶ��\�s\Z�P���J�]�V\�\�j0�]Fu�s\�q(,l��DǤ	y�����\�\�`4Ķq\�\�8��\�\'R;�u=K_�?E\�*Rŝ����E1d9=�2\��\0Rr?	\0��\"r��\�\�\����=�����\���[j7�8\���m�@VjZy}&�xɍ��޽�^f�\�\�h\�\�8���^�\�,�v��?\\E\�j\�^�\�#�f,\�:\�8TN(�I\'Tj-\�� �\�952f���?L4Ѯ�+��J8f��\��\�\�r}e\�!�Q�钳�0e�T�\�\�\'�\�b�m�빊\�\�K6`�\�\���c]Je98V\ng�He��ϖ5�ٍb�D��mj(u\�\�\�yg�\�\�p�jZmQ\�a�)�C0\ZZo�=��jL�ų\�r�/�M�{^)\�%�`�C\��}��N\�MG\�#�f�2=�MK����p\nQ��[��T`�]��M\��J�p.,XX\�\�*���̲Qyr�gl\"+\�ɶ�\�9����\�	\��\0\nrW�(���0\�J\�yO\�@M0����W�m!\�z��\����>�\")C�Tk�zcN�#�u���?�\�?^c�4�\�ۢ��ud����\\\"».\�/1�X���\�\n�%\�8lL\�\�(�i��\��N\�\��(ڱ\�\��B���_��[*-[����7D�ኪ,�\�8�\�d�V��\�0#֓.��+]?h\��WE?\�L\�?�p�L/	>>��\�,���U\�\�?�Dj���\�|\���\�(�4q��ʬ\n8W�LXP\�Ɇ\\�\��zÄb)\�~\�(k\�Y�n㟊�_\r:��6\�[;\�\�q�\���#RM�\�c\�|\��)|\�Lk\���rL?��\��+\����\�\�-��M�h	Ya\�Ө�r�u\�ɜ\�\�\Zn>�+\\��\�\�\Z)�lɆ��\�\�U\�8]b(��\��\0D��&/�O�p\�o�	�����)64s\�&l\�mV�\��y�5yVs��jQ�YV=l\�\�\n�P��z�MMj�\�E1~�W��ew�D�\�\�-��%Uf3\�r�\�jU@\Z̺�jA��������о��n�4hH�\�L�/K�\��\�b+/H\��\0�`� ��1\�<\�\�N�y�AT�j�\�\�B?2l�b�W6\�[\�4�\�\�\".\�\�\�\rx/>\���e��1\�\�.�6\�B@q�`1\�WȀ\���Um\��ʁ�~�H!�=`z���\�}��Gс8�s?H����~#h\�1�lx�JgC�hK\�.X~ ;��z��q��X\��\�\�\�2\Z`o\�\"�\�P�\�23/\0Z\'\�Q��\�+K(iC��\�\�0\��\�_\�E����_�\�G\�:���	|���Ef\�\�|�x�VO�jk�cQf\�\�\�K\�\�X�\�kq]�P:�\Zj\r�U��K��\�3�~eڌ�q�0l� �ks�L�\�xV\�c\�g~N�r�4��\Z��\�q\��)}�x\�\�:�(ǌ3��wo��\�K\�䍡��YST��_�&�?)������s)DN���9w\��\�\�H��|Kw]f8�v�C�S5\�ah� Ϯ�-�\�\�d\Z<��\"B�у�9�U\�r�\�WWW\�ޢ��\�;�an��S�\�\�YJ�����\ry\�j��?!t�KA|:\�0�J�@N/�}s\r~Dܷy��(щL�Y\�m7� E�s�=c�\�\� .���;\�\�}L�ix�ϑ��3/\"Pk\�\�]r�=�\�_m���-}��ayޟ�ͷ\�n�̂:\�\Z\��\0C:]���~, \�qq\� z��b�\�\Z,\0[qb*\����\����\��E�\��\0Իg\�\�Ȁ8=R\�?>)��z}\�\�1_��T��\�O�WG\�X\�q>QOT��ɍ\�,\�h�8�\0Pq*Xru2i����i�\�,\���:[\�+��u�\�7=�\�\Za�@\�{�u蚰�=f\�\�\n���\�XM\�߈%_\��F\�OhQk~�E\�\�ο\�+����v��\�zi5����Z\'��\n�\0\�D+�\�\�H\�\�\�\����)� +K�\�Zܪڷ#�궎�\�7A+E\�\�\�]�3�<�\"\�F�-\�,\Z�\�o\�M-\�\�\�c��1.mT\�\�Ǭ��a�خ��l,���1\��\�\"�����	`ۏ�7��gL���N?\�G��R1!��-�+Jd\�n6gj[���\�\�\�x\0ztA \n�	kV�\�1S:Hf\�чf�V\�	Vj�ݢ\�\�]�Cb\�\\\�1g//�*\�q!��^�\�+�	RqV1b\��Gh�YF\�\�!��)<��z�qm>�	�ʠ��Ao�)4#\\�^�#X<�s��1\�\��!ն��;@\�3\�� z�X��}\�\�n�_9J\�\�	���}����Ŋ\�6χ�z��e�^��\�\�Tz\�4..\�:�hNh3\�Io:H�j8q�n\Z�y\�M�鎏�!@[K��\�	F\���AE 6�K�d\'�\�Xr\�Z�b\�z澊LV=#n?njo���\�Z\�i{g����%\�D�1�_Ή�\����2ت�\0brb\n����e�Y�Dԗ\0Hl��S��	�u\��\�<	A�w�L�i�Ь\�$D)�\�.\r)�x\'�uL,y\�\�,�\�\�\�̊m:j_�\�_���A9\�\r�*\�fy���;1P�\�\��\����j0[�\�+��\n&&O3?;\��̥���\�\0�mr�<�\�\�IF(\�\�\0�o�W\�\���_D\�`\�T\��5��0��\�)kVY�\�si�ҰY��\�-G\'OD\Z2\�rߝ�!�3��V�\�ռ\rz>��{\�8jU���\�\�\�\�b\�\��*q;\�*褴[�\�\\��d�ٲ�b\"�\\Kb�7\�\�!\�䳘�:�����\n�B�x�\�O-�T���Ҙ\�9�Zp6�rV3�ᬽ3֪\�e\�\�\�O�\�u\�f��/_X��piM�\'\�̥�^!o-�T\ZTt+i\�\�\�J\�t�4�$�++�2�_����\�l/��¹�8ׄ6���{���\0��M�c�So3%\�4\�[�\�C���m��9\r�b�>\����\�G\�9\�h\�H�\�+\�wsgA�\�P�n-6\0�5��\�\�\�,�ܲ\�6V�A��#���%K\���\�er��m��\�(��Ii\�c9s�\�\r\�`�\�\�	\\�-7ϖc��䉨�\�\�wJ�\�򮧉7�1��GSS�P\��\�*\��n%:����!B<8���U\�Q�G�\� �Y]J.\�\�]UZ�z$dS�~��\�\��\��\�ꄘ<TWFAF=��V|\�c�\'\'dE�b��\nωj_�\�O ��Mc��\�\�V�\0SUi�\�\�ݦgA\�R\�GtR�Uψ�\���\�8�o\�1\\DM�\�P&\�\n\�Q\�P$�\�zjR(a�\�ɧ>H\�s�Wp�{��ڪ�0����\0��#!hoX\���\�A��\�Q�l\�\�`�ePF�|8\�GY�\��k\�\�\�j�T������\�A�Z\�Wc\�\�ʹ\�\�{u\��ndcw\����K�R�\�\ZC\��\��1]c�i�\�>�c��\�\�����\�\�.yϷ�x\�\�w~;���V\�\��\����E%�o\��G\�Jf�X\�;\�B�<\�:AT,\�>!-E-0wB:�#WKboX�m�R4x�\�\r`\n\�r��\�E\��\��\�S�c\�/U\�H\�\����R˥�q)��\�\�\\�e�h�݊ɽ�#<8\rj\�\�\r�L�͂g\�N\�3��\�\�U!ٴ��\�v˸�o34z8\n�ފ�\�\�:\�\�\�[\�h@�l��\�U\�~fC�\���\�\"̴{�W*�\0�G\'sV�_re�2�.����\Z\�\�Ev�T���\�&\0\�\'���	�=Z\�P0�WF��MvES|k4��\�������\�J����\�)\�j��S�\�A��.\�U䲟\�J*��?#g�����\r��\�p��	KȦ�\�\�\�NGeS�\�\�C49�^�cD:���e�\�n�s}Km��&^#wq-\�}��\0\�y|2Ҙ��[h�O��J�\�\�!�|_^ni��ڼ\�\�:J\nYL0D��\�\�pG\�5��\�2J�=w-f{2�I[=�ѝ�6IVQ���\Z�\0\�\�,2!�\�c�\���op9�w5z>\�\r�A\�^k\�W\�߉��\�\�44B�\�\�G>v\�\�M� �\�\'\�w,6Հl��\�{\�]%\�B\�\�\�\�P����\�`��n1�E�;mn7F�=Vk?�}�I�\�\�HcV\�\�\���\�Va\�\�>�F�m\�pÝk\�2\�\�4\�#���D(�=��W\0ͭA\��<Q�^\�MB�w8	˂6\�qs�U_�j&дy��I��s\�N*Za�\��V�$\0qXOl\0������\�-7���p mӝ\�x�3�A�1�\�\�C8���jو:j8�\�U���4�\�v(�\n2�\�\�w\�\nXN8�\\㌮�*\\@�Su\�\��\�9tp8>��8�\�\�un^ѐe\�\0�=n$F��\�j\�\�\�!\�����9���\�7�]\�\�\'\�4Y�\01\�%,�r�E\�~#C*4�	Gy���8\�c)�ێ��X@i\�o��\Z3�&*m�]F\�R\���5�s�\��17���e\�@�,\�i��5��\�\�e&&[��1�T!i��}\�\�ĕq�\�%m�KhX�zJM\�_�����\�\���\�f�6\�/\�J�ԭ�|@!@D\�9�H4-�٫�SKZV�D\��.\�\�ĭ�$�y�D$�_i�n\� \�|�V���\�!\�R\n�Z���\0�!OfD\�\�ߝ\��5W#�\�+{X\�xX.`��段q\',�Ԡyj\�X\�<�@�ʕB_pw�^j \'\����`,\�\�\�\\\n��(�V]=$��@\�9\Z�\�X`)�9\��+�~�\� ��\�Ƨ2�Y�x��Y�驠L*�g�\�y�^F�تU�\���(z\r����E\�5Ͳ\��\�\�=�\���\�w7I�\n\�ӎ~%^Z�����B�L��|՞g\�\�\�_F�\�Uw��,o�q\�b0U	����\�\��3\��,�֪�����\�U�\�nb7`n�+�-�fɒM�L�\0\n\�ǜ\�9n�]����~��c�)�\�\�S\�ʛ��Aj�\r\�\�\�N�\�7ذkg�� h\�@�\�f�\�n	`�\�f_\�\�!FI\�ܦw�0��\�P\�q�\�A��`����\�y\n=��\�`\r-\�\ZT�\�<10\�.�>\�7�\�M�\�[��/m>\�8u)�8�\�\����GQa�L�q9\�K��\�Y�\��e& \����\0\�z�\0���\�\�\�\�\�\��\0~f޳\�.\�\Z\�>hu�Xv@\�\�%UoGǀt=ЉJ\���\�\Z��Q��\�\�i]J��R\��DРz5#a\�\�\��|1�F�P:�B��\�\�%yK^\\b)�-~�\Z)��� :1a��s)\�Nc�Ò\�\�D\�\��&/�69#�{\�m\�\��%uW�\��&�>�G�(�\�z\�|G\�`�l���I�x?��\�LK���?��KB\�\�\�.ş_�-ԅ��ވ+\��\� $\nV\�闡�Gt:s������fY��1\�\�xʙ^W\Z��L�8=�\�s#\�*��,<\0V�zCl�y��5��\�?\�1�u\�ygݯ1�\r4xo[�C��\�3�v�Lg�Vs���\�u�\�;\0n��6�kV\�����;���\���}�aR�\�\�0\'v�e/\rc\�ـ\��a�3EnT)�1v�/�JS�\��/^g>J��G\n\�:�oxps�w�| h,J�x\��\'j��1+�\�\�\n�q:\r=\�>�[�ٟ7�h�l\\]\�e +X�Z\���%�:x5\�0tA�EM�ER���\�_��w0KvF�\��a�Yke\���\�+�D�Fzk�s]]\n�8��\�\�W�_��=�\�Q�\�=;�PprB\����C\�s\�9&�K\�1���]\\c\'P\�\�K̬[�\�%��s\�\�\�\�\�	x�Ԋ�\�C�Ϙ\�L�+\�w��\�\�Sџ�LS/�x\�[Yp\�]��\�}#(���\"��_�Îbg\�^\�\�}\"{0Y\�K����)�bo�8z\��H\�\���\�l�\�&\�l��A\�\�<3c\�r�$MP\��$\�\�>��\����.\�\�\��͍虦�\0���el*g\�\�a4�\�\�u�DH\0_,\�Ǥ\���\�|Ek�\n\�)\�\�HrZ�U�\0}#\\O\�\�_�\�\�,\�\�k�\0���\�\�\��\�f\rJY�{}|\�\�\��s\�q�K\��k\�S��\�r�\�Xg-q��\�IN�U�\�s\�V\"S#!�@6��]\0�hB.>N��­�ߴ5\0l�V��x.q�\r��\�g\�h˥�XGV\��\0col�(*拆\�\\]p�fs\�ր�o\�\�8�\�\�y/���B:T�Xwg˙��:h�����_5q���^a\�+گ�P>\�2�R�\0��T\�Et��K\�uR��|KU��D���%��3\� @�Y�aTC s\��\\-s�ω�N\r\�h׼j��ZPS|���%zŒ\�U!�\�\�Ѻ�J\�v܏y�\�J��l\'��\�\�\�\�\�p�<S\�\��8�?k\�\\h���Ecs\�Mz�����KvC&҉\��\0��Q(\�cm	c?�J,ܼ=%\�ޔ�\�d\�x�^ny ;H\0ǉN��\�\�,�\�C\�\�\�\�2\�7h�#��\�\�eшW�(��\�**pjE\�\n&b�\�M�\"ك\�[\�U�\���.5�\��c^X`\�]�\�W�am�\�\�<\�X�\0??\�;�\�f\"@�0�\\�K\�\��f\�>n;\\Y6���\�\'-s\�m\���̋f��}�I\�\�u��\�1aM�w?O�W���«7���?\�7s}?t\��P���Ť�4�����HF!\"�U�q��i��2Y��\����\������9+v\�#\0��Wa�)i,_nɩ\�\�\0f8�E\�Ϩ@a\�T\�\�Xrn\�\�\�ZOQ\�\n��F\��\0��N\�R\�Z���Xbz8�]�\�F��\�}�\��t-�4�n3��E1U��<b�\�³��9\�	\��\��\�@J�;R�C\�G1�\�\�D	F�ד�\�*,^�\�*l(=�Хvg�AFZ�Ƈk��\�A�s�\�gE�	\�M��m�9��d����P\�\�K\���?�|\�_Bf\�wT@�ޢ��l�ނsNy��3\�E|�N��\�\Z<�\�~\�Zx#��\�\�\�,A�E\�\�b(���js\�\�\�p3�\�M\�~��\�\r\�P�\�\����e��x�SE�0\�>(\�\"�\"��\�_�\�-m��.\�\��\�3�>DU��`\r�b\n�,�g$(�W{\�k�t����\0U3�~S\0>Ø\"I�Z��\�F�m��;\�ؔm\�\�NH\�9牓_.1u\ne�`�%�\�nɑ{D\�O=\�&\�5)\\g��7�\�ou�y\��^h\�y\�\�)!V�q���L����}5\��n=g2\�G����D̀sF�>=n9\�H\�\�\Z�\�\�6�\�/B^��\�-Ѻ+A-b��hQP7y!��\\ݦPxu\"gN�\�%����8s(�\\\�p�����\��MF\�$��\�MF��;\�h�(�ߠ\�\�f00��F	c��\�3u�%.26���n_�_}cy�E�\Z�7dr�l�Oջ�d\�)�˙J�0�<yY\�+��Jo9��y��b�\��\0e�V�ϭ\��\ng4\�\��ve;/��Gŏ�U\��Y�_,���3Lg\��(T\0=��E)\�l�� ��\��)}z�>���E_˙Mu\�&\����-R��Ҽ4\��\"L/|Mz��{Åz�\��\Z��\����Ĥ\�\�v���oS:��|:\Z���\�^�\�Hp�9z�E|!�v��@R<x����m�D\r�����ލk�\��nmB\��\�i�\�-L�\�?�Zɳ\�?_̽��\�\rŖMK(\�<\�pl�Ǟ/\��ʓQ\\f\�_5\�Kl\���:�χ\�\��\�1ns\�\r\�&\�߾\�\�h���i�\�\�Q\�\Z���/\�\0;\�\��m\�4c�y�m�\���\�ns����\�D�>\�>��t�^1;\�\r�w\�r��8�q\�E#���QC\�\�8�\�\�0�\�R�þ&���u\�\�q�1��\�\��J�\�]`ܢ\�-\�1F���}�+��Æ\"dN\�V\�+5\�=3�K��\�#\�W�\\��`V�qN\�7��\�\���l#�l\�;���\�ͺ��س\�\�&߈�i�\ZΓc\�\�}\�\�cԡ!�����>1*\�y��\�\����\��X\�\�����к�ާ��J�\�L9&�5��m6�ݥ*W^nR`c� \��	S2��\�^�\�Xq�\0e�N-�\'\�̥^��\�X�\���w\�e\�~�@�Ku��	x�F�\�Os�Ud@M�M\�~e�\�߈�\�r�Ƽ\�\�b\�\�\�fp�91*}�r?�-�h��K�\�\�5`b\�� \�W��9��\�U�IKHT(\�s�\�?��\n\�4r�	9Ǧ�H�\�z|K\�/�E\�x~\�\�1m��\niۇ8��\�b\�Ϥkb�\�h�r:J�\�\��q�\�\'y��eY8�\�\�.ӘW�z�F�b\�s�ܶ�c\�1\�\�hA�\�c\���ev�/\��l�B��\n\�s\0Ư\�j\\k�B�+W\��OQ�O�RW�ܡ�V?�Ş�M�e\�p��\�#�c%�	��V(T\�\�Fe9(�yy\�թrZܜP0W�6;g\Z\��\Z\'/3I[��\�Ajz~YH!G��\r3�)�4a��ٜ��\0�\�m�I\�]��{FGQ�G\�3[jB�\�QP\0��\�m\�\�`\��$\0#trv���\�o֡�~�\�ɠ\�5&U�J�ȥ������|}if��qM\��\0P\04�@X\�\�U����K\\2\�lm\"劲[�Q\�\�y�:£lљq\n���Ѭ\�9\�\�\�n3o�o|\���\�&��~�)Y��\Z�r\�CL$;n\�H\�zHJ����tc�ӅEC+\�,����\�\"\�$�\�Ꟙ�\�yO\�wr�9�G_oCإ\�!ͥ)�#sW\�;V`\�\�3i\�\�\��E\�\�S���\��)�����6�\�18�8S0�\��\�,\�tg\�\�-�M�k\��a�\��~ܨƯ�U~ L�\"\�k�ܲ\�O�\�g����\0��pB�\05^&T�\�3��\�%Zz�\0h*�\Zq\ZT��E�%�I\�\�\'\�y��c�\�\�V\�\����\�\�8|���\�C�1��c\�\�i௨,�Qmt�􎭍Ϻ�\�OI�sm\�\�ʪ�\��B}z�\�\���\�p�M\�y,�@\�AJ�(�04�[��\�H�\�>\�}�>�ⴒv�;��O��`�\�^���l���M�#i��)��\0g\�Nc\�\�Nٔ!�\r�\��;�+\�\�~9��\��xf�0]9Ԩ�حƛ \�.�����`0�F�\��\�S\0f�\���y��\���Hf�)8O���cq\\\�\�\�Q�-\�~#E|L�k�گt7\��Ϩ* Y�c\r\�X���\��\�x�1�A:\�Y_RR޴\�GQ�^�\�0�\"\�M��O�&���s9\��)\ncOj\�\�\�Wz\�➝d� \�\�[<G\r|\��^×�O|C{\�0$�vĢ+��\�c�\�I@\�	�\�7\�\�L^\�Ml2ƻ��V��KT\ZZsx���y(���\�6Uk��֦��R�5\�\�;�\�.@]�@���c�\�\"\�mS?�E\\�\�^[�ǈI4\�\�\�s\0�8�\0!\���^�\�X�\0�cb�\�\\�\�9-\�mޛ�\0�G鈪��\�-\�p�ye4\����|zPYuy�(5s8bz\�e8<FG��_��\0d\�\0\�o\�\�\�\��\�\�-Â��\�	��g\nz��\\e5����/��?=\�\\s�b�f�a����*�?\�X7�c�\�XN�\�\�ٵ\�p;/\��4KG@>�l�\Z7�B\�\�H\n�\�i��*\�\�\�W�iM�x����\�\nv\�lX�NS!\n9\�\'\�(Ԗ��S<\�\�\r�c�{`Y�\�+�Ay�|W\"�pOh�\�b����Lh�nҷ\�Q�Wt,�\�s�&\���|\�\�Z�����\�ʩ|�^>�\�\��D8\�|Ki�\�5�\�G�\���� Pu>Ŀ3�ԵA\�Z^3\�P>ܦ�\�\�\'�j&<6�\�jW\n˶l\Z\�M#��OI�J\��\0u\�r\�Q\n\�F\���uu\�{ Z8\�\�\0�#>�D�\�I�~�..g�\�bIb!lWg\�X�*�,��.�=�ܮ�\�o\�0|��db8X?k\�S�Ot%Rڛ��s09Ke\�,�[gA\�\�Ȋڎ���\�p�	��W�\�|ʖ\'�\03C\�\�\�\�3�MM�4��L��L]\���2��\�[l��@�\���\����h���\���\�\r\�\�3/�J�)n4�*1�\�\\\�\�w\�[��J`Wj�Gr� \�\"��-�\�\Z7���k,\0]f��\�\�\0\0,\'v�Xw\�\�\�!m��\���Z�\�\�\�\�T�\�aL��#\Zu�\�#�棫\�J�Y\�W�� \�\�\�	u1��L(�^.$�!	mVo���/��W\n�I\���\�*]�W�\����X[6/\�8�߫.\��r�o�,�SO�\�\�:�\�%\���Ъ\��:o\�;*�F;\�K>� .�\0D\�Q=\�hI8��m�\Z~\n�=#�]K9\�\\X/�B�Fh�0�/�O܎&���\�C�=\�f=�W\�<]\��4����Ŭ�|��	�OL\�8��ĵ\�\�\�n� ��\�ܓw騲{9���#\���U\��\�p>1�\���\�AJ��.�6�\������+\��`\�?4u���޺y�@�\�\r|\�d�1�\�1WlAE\�*�)��_��+\Z\�֚�\0�\�Y\\c\��\�lG�\�$Y+\���)��\r������1\"ߜ�\�\�%�\�\�E\�H�E���\�&}��p�M^�\�#�r�`p\��yڀ\�\�4\��D\� B\��\�6\�\�=����~\�\�H\Z4\�.y���\�R\�,G\"\�3i�<\�\n�C-TI\�w\�@\���4�\rڝ�\0O�I�57_\�V<�6u4.\�*�@n�\�Z\��\�CvWw4m܃�F%��\�r\�ķ6>����|F̆��N��/%NV71L��B�\�\�\�\���,\�~�o\�K*���f\�\'7\�\r\0\�8̔>���AO�5(�[�\�j;\��!z�\�s+x�\�\�\�g8~�S*��;\�N�֪9O�\�6�~>�t�\�We\�a)�\�_����\�\�/��ƨr\�Y�\r\�\�J} �\"rʆ\�\�1l\0\�1{\�[\��\0MDQ\�Z9�(k�?��u��\Z\� �!��\�K�y�\�{B�	�+�\��k�1-8��,/k�1B3\�\�=P�2\Z\�]�\�uQ�\�k\�m����X_\�م�\rV�դx\\��sUw\�Y�(\�C�f���L\�[x\�!�8\���\�C��b�\�y���\�E�\�E�E��~�kU�^F\�r�-\�\�̢�0[2�m��ł�\�뼫2��Q��\�1��\�\��\�˜\�}.�\�\�]��\�W�S�\r������n\�\�s�|Dr�/�h�N�\��\"j�O�4\r얃\�\�V\�\�\���\�[\��������;�|���?\�B���WU\�\�8�\�\�(�\�~��W\�]�~\�-��Js\�!`\�\�*5Y�(t.\�7\�\��_�m\�΁>�\�b�U^&\�Z6+��(3AeWq,�U)|��Z}\�4���R\�d0e�\0��6�\���\�\0\n,R�b\�\�<2\�\�<K\�\�z����\�\�VK��,FՈ\�\"?��o�ͤ)�V}�\�P2�2���O,\�8�\�q\�*�\�Ѧ\�5铯I�oB���\'�3~��e�<�ī��?��%����,\��(\���Qل�\�\�l\�G��w,#QlN�v\�@;�گ�s\"��LK�1	c\�P\0�*y���\�\��Ho\��ÉODU	\�1\�\ZW^�J����Ǟ\�/��X{�ͥO\�6���n�\"\r�{%��D\�	�8�C��\�[@I�@�\�zܨM���Ie�ѯ��\�Z\�\��\�<�G\�(�N0���n�\�\�|�i��Ȱ�]xw\�\�L��o\�R\�ts�\�`@��\�Ջ��at#��~\�a=w\�0��a�{\�$�V�\0\"ᙱ�[7r\�\�q���\�ξ\�#\��h�,5k���\0��^�k�\���<\�Vc��.\�\�\n>\nJ\�͉\�\�\�C&q2���(]Q+1jk\�\�e�V\�y`N���\�\�R���=�\�G\n\�+\�-{`\�f[\��W\�K`)��� ��&6&X+\�\�\��DѿT�\�\�e���\n8nX9C\\1�f{\�\Z�\��\�\né�\\&\\H8\�(�\�U(\�Û��킾\�z��\�1U�n6\�?#��\���O�6\��\�K�\�\�\Zsf��\�Q\�5\��g|�$>c\�\�\�b{�\�F\��\�\�ϖ����PYq�iuz*\�i��������`\�_�\�G\�~ \�Mc\�5���#{\�\��NEn�\�C� �ͪ�}J\�	���\�\���V���{ق5�\�K~\"LVn��PV/\Zט\�\�<uU\�3\�\�4\�N>�w�\0��i�\�)\�3ߡ��B\'\�>��\�\�i�\�:o�40���������\��ؓS)\����\�~\�fQ�\�\�!\�-��\�\�j�\�Χ7�)m+�\�q@�Ӄ��.^\�\�7�3��\�rɾ\�\�I�rq�M/�\"�5�����G���NSV65�э��۝\�$\�\�.1.\�+>\r�\�Zu5n\�\�l\n\�R\�QHm>7���; M�B��)�NY��u9][�a�i\�i�6z�5Q�\�o���H�[f�\�L�J�\0iW\�B\�\�¿\�\��D�\�R}G\�\�\�;n#�G��6�B]\r�W��}~\"\���\"\�2\��6\�\�	�\\n\\�i�)\�~0��E0�2\� f�d\��Jc1Uɓ\�$\Z\�:^%[jk�BJ�?J\"���ϫ�yL���\�ײt|6\�/c\�qPrE\�ʛ.V\�ٿ$�\0\�\�\�p\�.T\�o�PÔ�^\�//~sxD#�\�z�;�^:���t��0����q\�y�\�w\�p���f=�JӍ�\�2/1�6��\�p��\"���\���{��K_3��\0\"<d�Qk��-u\�������Q`�\�	�\�^8#\�Z�3�Q-\�_-�c��\0x>{�\�2����\�\�\�Y\�Q��LZ\�E/��u� �3>փk\��\�\�C�Ƿ\���eULҍ�w\�\�d�e\�<u9!�>rC\��!�Ml���+K��t���Np��1u\�;(�,ux}jo�>	.OqQ�\��������>\�j[X�Da\�z\�\�;����\\K\�xO\�	�/�Q�|�����S�h	��\�\�\����\�p*ai׸�\�q}e�¦8&\��]K.\�\"�b\�<D��K�\�\�6�58EX^��\�J�f�\�R\�\�q��2d��\�b��Vh��q�S\��/\�W�����\�*\�>\�,g�Ƚem�\�T�\�<`4\rq\�6\��6��Rl爃�m	C\�d�\�\�\��$\\���\���[�����Db�-�� \�\�(\�Uv�\�Nn.\�ЪR\�˭DP�\�\�ᙼ�\'��\\��\�R}&\���\�\�k�\�X��S>a>s�� ��EC8-_\�9\�P6?(�y\�	w���A�_�=ĸ?-�����E\�|3-4\�X�&��Ii�_/�%�\�\"\�3�\�\�E|\�\�o��Z|\�\�\��\�\�)����LoP�9�6`�(	�cqi�x+e�a�x�\�t@S+ܶ\�*]\�\r\�D,,�B@��NS\Z�u\��G 2���9\�\nC\���\�~\�	U���QLpO,��I�a�Bd)�\�ľo;sl�\\�Wm�#\�f`�\�t:\��\�Ǭ�\�_�\�(_�%>���^W�\'{��\r\�;Y����\�U\"ΪHE�\Z\0<G\�\�\�ɬ�\���\�M��S\'\�\�+�V��̇Y�/\�>��<B\��ɩA��\�P��d\n\�,�\0MC� R\r\�j}+Y@�\���\�\�\"\�\�u6�\���\n\�\�8��h\�l-)C/�+\�5\�*��\�\'\�\�\�x\�wY��OX`\�0�.sI�\�p���Fd(��E\�\�;��\��ۉM=#\0��~ F�|R>�%S�酫S��S(�<x�\0�xi��\� 0]e���tߚ%�_�.�[\�>�)�8D\��c*4��\�`�\0ڂp�\�H\�iyA\�\�$(��cc\�\��G\\�\���&��\�\�y7ꪺ\�\\\�\�D�u\�ј\�*\�\�\�\��Ը0z\�\�`\�\�1\����-���\�\�\�,e���3\�\'L�H\�\�\�X��G\�P,O����|%)�o��ّ��\�3���KXG��H�wB��\���p\�U����)�\�[#Vmu.\Z}&l\�\rI\�s�l���`۩\�\'\�o(w>�8u\\\�e�W���k\�\0׍`�����{߯�,�К��O]�\�Hb�\�?\�%�\�\�-�\�e�\�\�\��ܿYps\�_Y~�\�q\����\�X�\�a]G�33�x��#\�8��0\Z��o\�_��6I�[J�^ىxJ��t\�\�߿\�>Ї���\0[��0�\'o\��?�~\�W�N�s5�\�wil�r�W\�p\�փ�X:\�+\�\�㛆��\�E\"�]E�\�\�ܥo������\nB1\�\�+D�\�d�\�{�د��\0��5p/h�G�Q���\�oF=�\�iB#G.&<%��۱�\�B.�\�\�*>\�wO���)�&HTdR!\���Z�{�\��V\�\�AL�\��iC7����4>b�V\�&�5�Auy��r\�\�ۿ�mv|\�)�/H�)��Le�\�<�\��5/,\�\�\r\�]cF�w-(�S��+�49\r��Խk\�T׾%\�.��t�_+\�=�%��cyb[L\���\�ٞcļ\�)ܿ\�bΙl��O�\�\�\�	�o}\�\�)zBf	y�\�>�ʿr��\�֡]��ٞ\�!��\�\����\�S^�΢:���]�A��\�<�|���	\�!�\�\�y�(�~�>�\�r��j_�91\�:\'N�\�\�*�qKr�w\��Lm\�6{{�CK\�/\�	��x\�\�1`s��꾀K�[ϫ/d��\�r?�#8\�m\�.\�L_h\�հ\��\0Jc+6m�\�o���\�\�w/��]�\�?\�*�\���*\�e�d7����\"��D�Me�\�\�\�\�ΟyM�\�\�\�Ö)]\��\�\"�`�Z%�\�Q�I{�x\�7\�>�\�\��J%\�]��TaC\�\�U�\�j\0���]CY��E�#�P�Y\�,\��\�\�\�\�^LE�.\�q�\�\�b3,(^�^�pb\�Z>�%\�G\n6�Jd����\��\�\�k`�L�\'c+x�\�615P%Y\�b�\�E��\�\�\�����*��\��DV��r��\�8��sԴMfWؘ\�_R,\��^�\�\��B\�\�yg>/\�_�#��0�\�\n��%A��\�\r�l\\F�z\�2\�s\Z���.\�^\�	��!O�p<z\r��c\�\����\"Ӯ⼯�\��P�zAΦ\���]G\�\�\�2�\�d}�h<\�{H���f�\�\�\��A`\�\�U\�\�Vw�2;��\�xz?�\���S�h\�g\�\�\�\�\�.��y�V�wf1\�l�LU���\0��o��q\�\�g�Xי�)[Kk�����+����\�%��̶\��d��1YXc�,6!\��<b7\��9\��\�Z]y�N(�LiiL�7̥��\�\�>!�Ϲ\�o�����\�\�\��\�\�F\�F�?\�b07�4\�\�/}���F-��C\�0�w\�J-�\�.\\���W�k\�x\�Wm}\"�/u̷�ߝN�2`w\�PògCr\�Z�l0\0\�\��׏d)h��\���^�f&w�_��\�%10U�H\�eZ\�i\'\�\�\�/\�\�#؆\\yp$\�Yo2\�_Nf�\�2�A�\Z�\�&\�*\��b�3\��L*^��@rQ\�\��\�|\\�^�y�_���\�(�\����do\�y�[�G/h�\��g\Zw3M�^(� bU\��z\�\�\�:8�\��$�=|�\0dj~�	~R�dL\\WG\�j_G\�>�w��\�\�K��\'K�\0q�#x\�sY5)��\�|\�ξ�\�DM&�M��\�pq/\Znp\�?��#�ZW�_q�f�\�7�\0\"\�Wy�e�\�SD�鈎W��\�vJ��&�y#�K�\�\��j�\���r����\�}�~r���2\��lGj��20E]E��.\\�\�=��^x+��xK<��]\�.\�킁/T�`j\��\0����f�\�\n���\�\�\�j\�\�\��F<D@���@3��\�;`7D\�_\Z�����&6E�yK\�hJØ~𧙁I9�\�&��?}�mǃ�x��\�I�_vq\�\n\�&A^���}&\0���76\�\�d\�9\�L�&Y��\�޻u�\�K�\�_C\�/�\�\Z�Cܗy\�v?\��\0�%7�}\����Y�\�ר���e�\� �o\�\0G*4\�G\n\�\�0·M\�\�`��_�����ݓ\0\��\��l��\��ϭF�\�Y�D�k\�DQQ\�q9;|\�	q~\�\�\�\��g%�,�q,\�\�q9g\���˃\�t�\�vl\�\�tK>�8l�\�Kx����Eq�-�v���\��&W\�_�,\�L�	{h>&-\�vƱ\�+�j�\0��\�g*W��\\\\\��\�ֲ⚅\�0��p��\�>�Qg��N\�{e}ehFD.;�\�M#�:\�#hFp\�\��\rb\0�i��\0#��7�\Z�ب�_̵�9���Zl8��|\�K����TNC>�aK	Lx�D�Y\��N���\\��#m\�.\�3y�s��\�r߽��0�����qjs~��\�_k�\�袹W\�0Fn�΂���\�\0\�B\���K�:\�e\�ey,�L�/\�m5x}�g�;����nG�c@\\~\�\�\������\r��\�F�,Su\�|�T\�\��A\\ow�`Eϼ\\\��|O>�x�@>w��^.�RN4�K5B�h\�ԗ\��\�\�Q�\��#YRs\�	L�\��X�Ò|�͈�U5Zا\�M�\�3\�1\��|,�4��B)Z(S\��\n��>�\� ���,s{�.\�\�Rt���\�<�W��??\�w��\�̹s\�\�lè\n\�+��\0��/����\�*y�;��\�1��^���r6f}\�\r\�\�\�p����S?�\�k\��FH%\�.0)B�\�\�қ\�#@�\�m-\�+^��@\�4$j	�j���Z\"�\�\�\r\�T�W1il}U�1�\�./�S\�\n�e�s�v\�U\n|�\�G(\�0�a��1a�ձ \�\��\�\�\\f��\����㈦x\n\�5>^\ZCY��~!�|��J�/V�AVO��\�\�w�\�s⃆>\�\�G��A�J\��^*\�\�ݝ\�?y�g�&\����faQs\�;��\�a)\�w\�jbdH+�[�{ǧ�S�\��ϴ�\�.\�X�\�\�8�,\���0pbZ**\��y+~��\�\�C���-��b��\�&E߹Q5��K�_G$4)4�x���\�_\�Oi�eMx倹�S����\�KoS�\�xW�qz����\r\�i=S���<GK�6L�\�\Z\"��!��p��-^3�X\�e�p�p5�1r�1\�\�\�Mp��tH�)D\�\�CAK�m\�jV\�\�\�CZf\�/H/\�\�ty�\�-D�\��\�\�j�q\�-x�\Z���MP,\�?���rh\�\rXG\�\Z0�_����)���\"\�ft@A\�hNl7i�˗�_�/J�̯1!�\��j2�H9\�x��\�(\�K#T��\r^Pp\�\��H*�M༥r�\�U\�\�j\�f=��8����\���E~�?I\���\0���\�����\�?��Kq�ik�\�\�.~ܼN\�S�:�\�>\�\�m�n\Za�\�߉v\��4�c�\�X)\��\�\�-\�ܽE\�\�\�u����O7�Iy���\�\��\"\�.�P۰י��*�\��\0 �1\r�\�\�!����\��`*\�7�c�\�F�+{�\�\n�mU���z�\�+I��.�ݗE?�ĳ|,)�\�M-\�	v�\�\r\��\�Ҳ�q�R�\�~\�)T8�>�M+C�\���L\�\�i�J�\�z�\rZz�Zk\�\�/i@4�>}`Қ��ԥ36�\�kkȬ+�2�^%�/\��B\�ʈ+�	k�ͽ\�ŕU��\�_������e\�d?\�5a>�~��?���O����\���\�}T�\�r��M��������B�p_Hy\�_���\�P�\0Q�\�\Z8%�l�2�\�	y�9�1Ro����\�Q|��e\�\"�,衷�\�_��)�f}�ztK*d4\�,K;ɻ����dbfwB�\�\n��ߩ�:1����1�F\���\\�\�K\�@〢\�\�m�X\�\�\�g�7�̤��({��\� ]��\������dL:!/J�U\�u�)b�\�nB�ߘ\�@�5�en��ٳgRƒ\�\�lz�e�u\�\�%�;b�e��\0��\0��\0�\�','1146689000','11111111111111',3,1,6,0,1,'Eduardo Roberto Daher','Centro','SP','Itapecerica da Serra',1135,'','Avenida ',NULL,NULL,NULL,NULL,NULL);
/*!40000 ALTER TABLE `LGPD_1000_controlador` ENABLE KEYS */;
-- UNLOCK TABLES;

--
-- Table structure for table `LGPD_1001_diretoria`
--

DROP TABLE IF EXISTS `LGPD_1001_diretoria`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `LGPD_1001_diretoria` (
  `id_diretoria_1001` int NOT NULL AUTO_INCREMENT,
  `sigla_dir_1001` char(8) DEFAULT NULL,
  `nome_dir_1001` char(100) NOT NULL,
  `id_controlador_1000` int NOT NULL,
  PRIMARY KEY (`id_diretoria_1001`),
  KEY `fk_id_controlador_1001` (`id_controlador_1000`),
  CONSTRAINT `fk_id_controlador_1001` FOREIGN KEY (`id_controlador_1000`) REFERENCES `LGPD_1000_controlador` (`id_controlador_1000`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `LGPD_1001_diretoria`
--

-- LOCK TABLES `LGPD_1001_diretoria` WRITE;
/*!40000 ALTER TABLE `LGPD_1001_diretoria` DISABLE KEYS */;
/*!40000 ALTER TABLE `LGPD_1001_diretoria` ENABLE KEYS */;
-- UNLOCK TABLES;

--
-- Table structure for table `LGPD_1002_area`
--

DROP TABLE IF EXISTS `LGPD_1002_area`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `LGPD_1002_area` (
  `id_area_1002` int NOT NULL AUTO_INCREMENT,
  `sigla_area_1002` char(8) NOT NULL,
  `nome_area_1002` char(100) NOT NULL,
  `id_diretoria_1001` int NOT NULL,
  `id_controlador_1000` int DEFAULT NULL,
  PRIMARY KEY (`id_area_1002`),
  KEY `fki_fk_id_diretoria_1001` (`id_diretoria_1001`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `LGPD_1002_area`
--

-- LOCK TABLES `LGPD_1002_area` WRITE;
/*!40000 ALTER TABLE `LGPD_1002_area` DISABLE KEYS */;
/*!40000 ALTER TABLE `LGPD_1002_area` ENABLE KEYS */;
-- UNLOCK TABLES;

--
-- Table structure for table `LGPD_1003_departamento`
--

DROP TABLE IF EXISTS `LGPD_1003_departamento`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `LGPD_1003_departamento` (
  `id_dpto_1003` int NOT NULL AUTO_INCREMENT,
  `sigla_dpto_1003` char(8) NOT NULL,
  `nome_dpto_1003` char(100) NOT NULL,
  `id_area_1002` int NOT NULL,
  `id_controlador_1000` int DEFAULT NULL,
  PRIMARY KEY (`id_dpto_1003`),
  KEY `fki_fk_id_area_1002` (`id_area_1002`)
) ENGINE=InnoDB AUTO_INCREMENT=15 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `LGPD_1003_departamento`
--

-- LOCK TABLES `LGPD_1003_departamento` WRITE;
/*!40000 ALTER TABLE `LGPD_1003_departamento` DISABLE KEYS */;
/*!40000 ALTER TABLE `LGPD_1003_departamento` ENABLE KEYS */;
-- UNLOCK TABLES;

--
-- Table structure for table `LGPD_1004_cargos`
--

DROP TABLE IF EXISTS `LGPD_1004_cargos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `LGPD_1004_cargos` (
  `id_cargo_1004` int NOT NULL AUTO_INCREMENT,
  `nome_cargo_1004` char(150) NOT NULL,
  `id_controlador_1000` int NOT NULL,
  `arquivo_1004` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id_cargo_1004`),
  KEY `fki_fk_id_controlador_1004` (`id_controlador_1000`),
  CONSTRAINT `fk_id_controlador_1004` FOREIGN KEY (`id_controlador_1000`) REFERENCES `LGPD_1000_controlador` (`id_controlador_1000`)
) ENGINE=InnoDB AUTO_INCREMENT=15 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `LGPD_1004_cargos`
--

-- LOCK TABLES `LGPD_1004_cargos` WRITE;
/*!40000 ALTER TABLE `LGPD_1004_cargos` DISABLE KEYS */;
/*!40000 ALTER TABLE `LGPD_1004_cargos` ENABLE KEYS */;
-- UNLOCK TABLES;

--
-- Table structure for table `LGPD_1005_assoc_contr_user`
--

DROP TABLE IF EXISTS `LGPD_1005_assoc_contr_user`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `LGPD_1005_assoc_contr_user` (
  `id_controlador_1000` int DEFAULT NULL,
  `id_user` int DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `LGPD_1005_assoc_contr_user`
--

-- LOCK TABLES `LGPD_1005_assoc_contr_user` WRITE;
/*!40000 ALTER TABLE `LGPD_1005_assoc_contr_user` DISABLE KEYS */;
INSERT INTO `LGPD_1005_assoc_contr_user` VALUES (1,1);
/*!40000 ALTER TABLE `LGPD_1005_assoc_contr_user` ENABLE KEYS */;
-- UNLOCK TABLES;

--
-- Table structure for table `LGPD_1006_dpo_contr_externo`
--

DROP TABLE IF EXISTS `LGPD_1006_dpo_contr_externo`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `LGPD_1006_dpo_contr_externo` (
  `id_dpo_controlador_1006` int NOT NULL AUTO_INCREMENT,
  `id_controlador_1000` int DEFAULT NULL,
  `id_terc_2090` int DEFAULT NULL COMMENT 'Indica se o DPO é interno ou DPO as Service ("Interno" ou "DPASS)',
  `nome_resp_1006` varchar(250) DEFAULT NULL,
  `email_resp_1006` varchar(250) DEFAULT NULL,
  `tel_resp_1006` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`id_dpo_controlador_1006`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `LGPD_1006_dpo_contr_externo`
--

-- LOCK TABLES `LGPD_1006_dpo_contr_externo` WRITE;
/*!40000 ALTER TABLE `LGPD_1006_dpo_contr_externo` DISABLE KEYS */;
/*!40000 ALTER TABLE `LGPD_1006_dpo_contr_externo` ENABLE KEYS */;
-- UNLOCK TABLES;

--
-- Table structure for table `LGPD_1050_organograma`
--

DROP TABLE IF EXISTS `LGPD_1050_organograma`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `LGPD_1050_organograma` (
  `id_controlador_1000` int NOT NULL,
  `id_diretoria_1001` int DEFAULT NULL,
  `id_area_1002` int DEFAULT NULL,
  `id_dpto_1003` int NOT NULL,
  `id_organograma_1050` int NOT NULL AUTO_INCREMENT,
  `user_insert_1050` varchar(45) DEFAULT NULL,
  `dt_insert_1050` date DEFAULT NULL,
  `user_update_1050` varchar(45) DEFAULT NULL,
  `dt_ult_update_1050` date DEFAULT NULL,
  PRIMARY KEY (`id_organograma_1050`),
  KEY `fki_fk_id_controlador_1000` (`id_controlador_1000`),
  CONSTRAINT `fk_id_controlador_1000_2` FOREIGN KEY (`id_controlador_1000`) REFERENCES `LGPD_1000_controlador` (`id_controlador_1000`)
) ENGINE=InnoDB AUTO_INCREMENT=14 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `LGPD_1050_organograma`
--

-- LOCK TABLES `LGPD_1050_organograma` WRITE;
/*!40000 ALTER TABLE `LGPD_1050_organograma` DISABLE KEYS */;
/*!40000 ALTER TABLE `LGPD_1050_organograma` ENABLE KEYS */;
-- UNLOCK TABLES;

--
-- Table structure for table `LGPD_1051_comite`
--

DROP TABLE IF EXISTS `LGPD_1051_comite`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `LGPD_1051_comite` (
  `id_comite_1051` int NOT NULL AUTO_INCREMENT,
  `nome_comite_1051` text,
  `resp_comite_1051` int DEFAULT NULL,
  `dt_inst_comite_1051` date DEFAULT NULL,
  `objetivo_comite_1051` text,
  `ativo_comite_1051` tinyint(1) DEFAULT NULL,
  `id_controlador_1000` int DEFAULT NULL,
  `arquivo_1051` varchar(255) DEFAULT NULL,
  `user_insert_1051` varchar(45) DEFAULT NULL,
  `dt_insert_1051` date DEFAULT NULL,
  `user_update_1051` varchar(45) DEFAULT NULL,
  `dt_ult_update_1051` date DEFAULT NULL,
  PRIMARY KEY (`id_comite_1051`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `LGPD_1051_comite`
--

-- LOCK TABLES `LGPD_1051_comite` WRITE;
/*!40000 ALTER TABLE `LGPD_1051_comite` DISABLE KEYS */;
/*!40000 ALTER TABLE `LGPD_1051_comite` ENABLE KEYS */;
-- UNLOCK TABLES;

--
-- Table structure for table `LGPD_1052_membros_comite`
--

DROP TABLE IF EXISTS `LGPD_1052_membros_comite`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `LGPD_1052_membros_comite` (
  `id_comite_1051` int DEFAULT NULL,
  `id_membro_1052` int DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `LGPD_1052_membros_comite`
--

-- LOCK TABLES `LGPD_1052_membros_comite` WRITE;
/*!40000 ALTER TABLE `LGPD_1052_membros_comite` DISABLE KEYS */;
/*!40000 ALTER TABLE `LGPD_1052_membros_comite` ENABLE KEYS */;
-- UNLOCK TABLES;

--
-- Table structure for table `LGPD_1053_eventos_comite`
--

DROP TABLE IF EXISTS `LGPD_1053_eventos_comite`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `LGPD_1053_eventos_comite` (
  `id_comite_1051` int DEFAULT NULL,
  `dt_evento_1053` date DEFAULT NULL,
  `assunto_evento_1053` text,
  `ata_evento_1053` text,
  `resp_evento_1053` int DEFAULT NULL,
  `id_evento_1053` int NOT NULL AUTO_INCREMENT,
  `ata_participantes_1053` text,
  `anexo1_1053` varchar(250) DEFAULT NULL,
  `anexo2_1053` varchar(250) DEFAULT NULL,
  `anexo3_1053` varchar(250) DEFAULT NULL,
  PRIMARY KEY (`id_evento_1053`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `LGPD_1053_eventos_comite`
--

-- LOCK TABLES `LGPD_1053_eventos_comite` WRITE;
/*!40000 ALTER TABLE `LGPD_1053_eventos_comite` DISABLE KEYS */;
/*!40000 ALTER TABLE `LGPD_1053_eventos_comite` ENABLE KEYS */;
-- UNLOCK TABLES;

--
-- Table structure for table `LGPD_1100_equipe`
--

DROP TABLE IF EXISTS `LGPD_1100_equipe`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `LGPD_1100_equipe` (
  `cpf_1100` char(11) NOT NULL,
  `nome_1100` char(250) NOT NULL,
  `telefone_1100` char(40) DEFAULT NULL,
  `email_1100` char(250) NOT NULL,
  `cod_pessoa_1100` int NOT NULL AUTO_INCREMENT,
  `id_controlador_1000` int NOT NULL,
  `id_cargo_1004` int NOT NULL,
  `id_organograma_1050` int DEFAULT NULL,
  `foto` longblob,
  `user_insert_1100` varchar(45) DEFAULT NULL,
  `dt_insert_1100` date DEFAULT NULL,
  `user_update_1100` varchar(45) DEFAULT NULL,
  `dt_ult_update_1100` date DEFAULT NULL,
  `id_carga_menb_1150` int DEFAULT NULL,
  `acao_carga_1100` varchar(10) DEFAULT NULL,
  PRIMARY KEY (`cod_pessoa_1100`),
  KEY `fk_id_controlador_1000` (`id_controlador_1000`),
  CONSTRAINT `fk_id_controlador_1000` FOREIGN KEY (`id_controlador_1000`) REFERENCES `LGPD_1000_controlador` (`id_controlador_1000`)
) ENGINE=InnoDB AUTO_INCREMENT=14 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `LGPD_1100_equipe`
--

-- LOCK TABLES `LGPD_1100_equipe` WRITE;
/*!40000 ALTER TABLE `LGPD_1100_equipe` DISABLE KEYS */;
/*!40000 ALTER TABLE `LGPD_1100_equipe` ENABLE KEYS */;
-- UNLOCK TABLES;

--
-- Table structure for table `LGPD_1150_carga_membro`
--

DROP TABLE IF EXISTS `LGPD_1150_carga_membro`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `LGPD_1150_carga_membro` (
  `id_carga_menb_1150` int NOT NULL AUTO_INCREMENT,
  `dt_carga_1150` date DEFAULT NULL,
  `nome_arq_carga_1150` varchar(250) DEFAULT NULL,
  `user_resp_carga_1150` int DEFAULT NULL,
  `tot_reg_envi_1150` int DEFAULT NULL,
  `tot_reg_insert_1150` int DEFAULT NULL,
  `tot_reg_update_1150` int DEFAULT NULL,
  `id_controlador_1000` int DEFAULT NULL,
  `ind_carga_efetivada_1150` tinyint DEFAULT '0',
  PRIMARY KEY (`id_carga_menb_1150`)
) ENGINE=InnoDB AUTO_INCREMENT=261 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `LGPD_1150_carga_membro`
--

-- LOCK TABLES `LGPD_1150_carga_membro` WRITE;
/*!40000 ALTER TABLE `LGPD_1150_carga_membro` DISABLE KEYS */;
/*!40000 ALTER TABLE `LGPD_1150_carga_membro` ENABLE KEYS */;
-- UNLOCK TABLES;

--
-- Table structure for table `LGPD_1160_log_carga_membro`
--

DROP TABLE IF EXISTS `LGPD_1160_log_carga_membro`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `LGPD_1160_log_carga_membro` (
  `id_log_carga_membro_1160` int NOT NULL AUTO_INCREMENT,
  `id_carga_menb_1150` int NOT NULL,
  `nr_linha_1160` int DEFAULT NULL,
  `cpf_1160` varchar(20) DEFAULT NULL,
  `erro_1160` text,
  PRIMARY KEY (`id_log_carga_membro_1160`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `LGPD_1160_log_carga_membro`
--

-- LOCK TABLES `LGPD_1160_log_carga_membro` WRITE;
/*!40000 ALTER TABLE `LGPD_1160_log_carga_membro` DISABLE KEYS */;
/*!40000 ALTER TABLE `LGPD_1160_log_carga_membro` ENABLE KEYS */;
-- UNLOCK TABLES;

--
-- Table structure for table `LGPD_1170_hist_carga_membro`
--

DROP TABLE IF EXISTS `LGPD_1170_hist_carga_membro`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `LGPD_1170_hist_carga_membro` (
  `cpf_1170` char(11) DEFAULT NULL,
  `nome_1170` char(250) NOT NULL,
  `telefone_1170` char(40) DEFAULT NULL,
  `email_1170` char(250) NOT NULL,
  `id_1170` int NOT NULL AUTO_INCREMENT,
  `id_controlador_1000` int NOT NULL,
  `id_cargo_1004` int NOT NULL,
  `id_organograma_1050` int DEFAULT NULL,
  `id_carga_menb_1150` int DEFAULT NULL,
  `acao_carga_1170` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT NULL,
  `nr_linha_1170` int DEFAULT NULL,
  PRIMARY KEY (`id_1170`)
) ENGINE=InnoDB AUTO_INCREMENT=124 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `LGPD_1170_hist_carga_membro`
--

-- LOCK TABLES `LGPD_1170_hist_carga_membro` WRITE;
/*!40000 ALTER TABLE `LGPD_1170_hist_carga_membro` DISABLE KEYS */;
/*!40000 ALTER TABLE `LGPD_1170_hist_carga_membro` ENABLE KEYS */;
-- UNLOCK TABLES;

--
-- Table structure for table `LGPD_2000_processos`
--

DROP TABLE IF EXISTS `LGPD_2000_processos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `LGPD_2000_processos` (
  `cod_prc_2000` int NOT NULL AUTO_INCREMENT,
  `tit_prc_2000` text,
  `dsc_prc_2000` text,
  `id_status_prc_2000` int NOT NULL,
  `resp_prc_2000` int DEFAULT NULL,
  `id_clsf_gen_nivel_9999` int NOT NULL,
  `id_tp_prc_2000` int NOT NULL,
  `id_controlador_1000` int NOT NULL,
  `id_organograma_1050` int DEFAULT NULL,
  `aprov_aut_prz_2000` tinyint(1) DEFAULT NULL,
  `dt_sol_aprov_2000` date DEFAULT NULL,
  `dt_aprov_2000` date DEFAULT NULL,
  `dt_sla_aprov_2000` date DEFAULT NULL,
  `url_bpmn_2000` text,
  `anexo_2000` varchar(250) DEFAULT NULL,
  `user_insert_2000` varchar(45) DEFAULT NULL,
  `dt_insert_2000` date DEFAULT NULL,
  `user_update_2000` varchar(45) DEFAULT NULL,
  `dt_ult_update_2000` date DEFAULT NULL,
  `entr_prc_assoc_2000` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`cod_prc_2000`),
  KEY `fk_status_prc_2000` (`id_status_prc_2000`),
  KEY `fk_clsf_gen_nivel_9999_2` (`id_clsf_gen_nivel_9999`),
  KEY `fk_tp_prc_2000` (`id_tp_prc_2000`),
  KEY `fki_fk_organograma_1050` (`id_organograma_1050`),
  KEY `fki_id_controlador_1000` (`id_controlador_1000`),
  KEY `fki_o` (`resp_prc_2000`),
  CONSTRAINT `fk_clsf_gen_nivel_9999_2` FOREIGN KEY (`id_clsf_gen_nivel_9999`) REFERENCES `DOM_clsf_gen_nivel_9999` (`id_clsf_gen_nivel_9999`),
  CONSTRAINT `fk_organograma_1050` FOREIGN KEY (`id_organograma_1050`) REFERENCES `LGPD_1050_organograma` (`id_organograma_1050`),
  CONSTRAINT `fk_status_prc_2000` FOREIGN KEY (`id_status_prc_2000`) REFERENCES `DOM_status_prc_2000` (`id_status_prc_2000`),
  CONSTRAINT `fk_tp_prc_2000` FOREIGN KEY (`id_tp_prc_2000`) REFERENCES `DOM_tp_prc_2000` (`id_tp_prc_2000`),
  CONSTRAINT `id_controlador_1000` FOREIGN KEY (`id_controlador_1000`) REFERENCES `LGPD_1000_controlador` (`id_controlador_1000`)
) ENGINE=InnoDB AUTO_INCREMENT=42 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `LGPD_2000_processos`
--

-- LOCK TABLES `LGPD_2000_processos` WRITE;
/*!40000 ALTER TABLE `LGPD_2000_processos` DISABLE KEYS */;
/*!40000 ALTER TABLE `LGPD_2000_processos` ENABLE KEYS */;
-- UNLOCK TABLES;

--
-- Table structure for table `LGPD_2001_form_entr_prc`
--

DROP TABLE IF EXISTS `LGPD_2001_form_entr_prc`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `LGPD_2001_form_entr_prc` (
  `id_form_entr_prc_2001` int NOT NULL AUTO_INCREMENT,
  `nome_form_entr_prc_2001` varchar(250) NOT NULL,
  `instr_preench_form_entr_prc_2001` longtext,
  `id_controlador_1000` int NOT NULL,
  `user_insert_2001` varchar(45) DEFAULT NULL,
  `dt_insert_2001` date DEFAULT NULL,
  `user_update_2001` varchar(45) DEFAULT NULL,
  `dt_update_2001` date DEFAULT NULL,
  PRIMARY KEY (`id_form_entr_prc_2001`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `LGPD_2001_form_entr_prc`
--

-- LOCK TABLES `LGPD_2001_form_entr_prc` WRITE;
/*!40000 ALTER TABLE `LGPD_2001_form_entr_prc` DISABLE KEYS */;
/*!40000 ALTER TABLE `LGPD_2001_form_entr_prc` ENABLE KEYS */;
-- UNLOCK TABLES;

--
-- Table structure for table `LGPD_2002_config_entr_prc`
--

DROP TABLE IF EXISTS `LGPD_2002_config_entr_prc`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `LGPD_2002_config_entr_prc` (
  `id_2002` int NOT NULL AUTO_INCREMENT,
  `id_2001` int DEFAULT NULL COMMENT 'Id do fomulário de referencia',
  `questao_2002` text,
  `id_tp_resp_2002` int NOT NULL,
  `instr_questao_2002` varchar(400) DEFAULT NULL,
  `order_questao_2002` int DEFAULT NULL,
  `ind_ativa_2002` tinyint DEFAULT '1' COMMENT 'Indica se a questão esta ativa para novos formulários ',
  PRIMARY KEY (`id_2002`)
) ENGINE=InnoDB AUTO_INCREMENT=106 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `LGPD_2002_config_entr_prc`
--

-- LOCK TABLES `LGPD_2002_config_entr_prc` WRITE;
/*!40000 ALTER TABLE `LGPD_2002_config_entr_prc` DISABLE KEYS */;
/*!40000 ALTER TABLE `LGPD_2002_config_entr_prc` ENABLE KEYS */;
-- UNLOCK TABLES;

--
-- Table structure for table `LGPD_2003_envio_entr_prc`
--

DROP TABLE IF EXISTS `LGPD_2003_envio_entr_prc`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `LGPD_2003_envio_entr_prc` (
  `id_envio_2003` int NOT NULL AUTO_INCREMENT,
  `id_organograma_1050` int DEFAULT NULL,
  `cod_pessoa_1100` int DEFAULT NULL,
  `objetivo_2003` longtext,
  `dt_envio_2003` date DEFAULT NULL,
  `finalizado_2003` tinyint(1) DEFAULT NULL,
  `dt_finaliza_2003` date DEFAULT NULL,
  `senha_2003` char(15) DEFAULT NULL,
  `id_controlador_1000` int NOT NULL,
  `id_form_entr_prc_2001` int DEFAULT NULL,
  `user_insert_2003` varchar(45) DEFAULT NULL,
  `dt_insert_2003` date DEFAULT NULL,
  `user_update_2003` varchar(45) DEFAULT NULL,
  `dt_update_2003` date DEFAULT NULL,
  PRIMARY KEY (`id_envio_2003`)
) ENGINE=InnoDB AUTO_INCREMENT=133 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `LGPD_2003_envio_entr_prc`
--

-- LOCK TABLES `LGPD_2003_envio_entr_prc` WRITE;
/*!40000 ALTER TABLE `LGPD_2003_envio_entr_prc` DISABLE KEYS */;
/*!40000 ALTER TABLE `LGPD_2003_envio_entr_prc` ENABLE KEYS */;
-- UNLOCK TABLES;

--
-- Table structure for table `LGPD_2004_resp_entr_prc`
--

DROP TABLE IF EXISTS `LGPD_2004_resp_entr_prc`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `LGPD_2004_resp_entr_prc` (
  `id_envio_2003` int DEFAULT NULL,
  `id_2002` int DEFAULT NULL,
  `resposta_2004` text,
  `coment_resp_7400` longtext,
  `id_2004` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`id_2004`)
) ENGINE=InnoDB AUTO_INCREMENT=277 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `LGPD_2004_resp_entr_prc`
--

-- LOCK TABLES `LGPD_2004_resp_entr_prc` WRITE;
/*!40000 ALTER TABLE `LGPD_2004_resp_entr_prc` DISABLE KEYS */;
/*!40000 ALTER TABLE `LGPD_2004_resp_entr_prc` ENABLE KEYS */;
-- UNLOCK TABLES;

--
-- Table structure for table `LGPD_2005_assoc_prc_entr`
--

DROP TABLE IF EXISTS `LGPD_2005_assoc_prc_entr`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `LGPD_2005_assoc_prc_entr` (
  `cod_prc_2000` int NOT NULL,
  `id_envio_2003` int NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci COMMENT='Associação do processo com os formulários de levantamento/entrevistas';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `LGPD_2005_assoc_prc_entr`
--

-- LOCK TABLES `LGPD_2005_assoc_prc_entr` WRITE;
/*!40000 ALTER TABLE `LGPD_2005_assoc_prc_entr` DISABLE KEYS */;
/*!40000 ALTER TABLE `LGPD_2005_assoc_prc_entr` ENABLE KEYS */;
-- UNLOCK TABLES;

--
-- Table structure for table `LGPD_2006_config_det_opt`
--

DROP TABLE IF EXISTS `LGPD_2006_config_det_opt`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `LGPD_2006_config_det_opt` (
  `id_2006` int NOT NULL AUTO_INCREMENT,
  `id_2002` int DEFAULT NULL,
  `opt_2006` text,
  `id_controlador_1000` int DEFAULT NULL,
  PRIMARY KEY (`id_2006`)
) ENGINE=InnoDB AUTO_INCREMENT=153 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `LGPD_2006_config_det_opt`
--

-- LOCK TABLES `LGPD_2006_config_det_opt` WRITE;
/*!40000 ALTER TABLE `LGPD_2006_config_det_opt` DISABLE KEYS */;
/*!40000 ALTER TABLE `LGPD_2006_config_det_opt` ENABLE KEYS */;
-- UNLOCK TABLES;

--
-- Table structure for table `LGPD_2007_carga_prc`
--

DROP TABLE IF EXISTS `LGPD_2007_carga_prc`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `LGPD_2007_carga_prc` (
  `id_carga_prc_2007` int NOT NULL AUTO_INCREMENT,
  `nome_arquivo_2007` varchar(250) NOT NULL,
  `data_carga_2007` date NOT NULL,
  `usuario_resp_carga_2007` int NOT NULL,
  `tot_reg_enviados_2007` int DEFAULT NULL,
  `tot_reg_incluidos_2007` int DEFAULT NULL,
  `id_controlador_1000` int NOT NULL,
  `ind_prosseguiu_carga_2007` tinyint NOT NULL DEFAULT '0',
  PRIMARY KEY (`id_carga_prc_2007`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `LGPD_2007_carga_prc`
--

-- LOCK TABLES `LGPD_2007_carga_prc` WRITE;
/*!40000 ALTER TABLE `LGPD_2007_carga_prc` DISABLE KEYS */;
/*!40000 ALTER TABLE `LGPD_2007_carga_prc` ENABLE KEYS */;
-- UNLOCK TABLES;

--
-- Table structure for table `LGPD_2008_log_err_carga_prc`
--

DROP TABLE IF EXISTS `LGPD_2008_log_err_carga_prc`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `LGPD_2008_log_err_carga_prc` (
  `id_log_err_carga_prc_2008` int NOT NULL AUTO_INCREMENT,
  `id_carga_prc_2007` int NOT NULL,
  `nr_linha_2008` int DEFAULT NULL,
  `tit_prc_2008` text NOT NULL,
  `erro_2008` varchar(200) NOT NULL,
  PRIMARY KEY (`id_log_err_carga_prc_2008`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `LGPD_2008_log_err_carga_prc`
--

-- LOCK TABLES `LGPD_2008_log_err_carga_prc` WRITE;
/*!40000 ALTER TABLE `LGPD_2008_log_err_carga_prc` DISABLE KEYS */;
/*!40000 ALTER TABLE `LGPD_2008_log_err_carga_prc` ENABLE KEYS */;
-- UNLOCK TABLES;

--
-- Table structure for table `LGPD_2009_hist_carga_prc`
--

DROP TABLE IF EXISTS `LGPD_2009_hist_carga_prc`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `LGPD_2009_hist_carga_prc` (
  `id_hist_carga_prc_2009` int NOT NULL AUTO_INCREMENT,
  `id_carga_prc_2007` int NOT NULL,
  `titulo_prc_2009` varchar(300) NOT NULL,
  `desc_prc_2009` text,
  `resp_prc_2009` int NOT NULL,
  `id_clsf_gen_nivel_2009` int NOT NULL,
  `id_tp_prc_2009` int NOT NULL,
  `id_organograma_2009` int NOT NULL,
  `id_controlador_1000` int NOT NULL,
  `data_carga_2009` date NOT NULL,
  `nr_linha_2009` int DEFAULT NULL,
  `acao_carga_2009` varchar(10) DEFAULT NULL,
  PRIMARY KEY (`id_hist_carga_prc_2009`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `LGPD_2009_hist_carga_prc`
--

-- LOCK TABLES `LGPD_2009_hist_carga_prc` WRITE;
/*!40000 ALTER TABLE `LGPD_2009_hist_carga_prc` DISABLE KEYS */;
/*!40000 ALTER TABLE `LGPD_2009_hist_carga_prc` ENABLE KEYS */;
-- UNLOCK TABLES;

--
-- Table structure for table `LGPD_2010_ativos`
--

DROP TABLE IF EXISTS `LGPD_2010_ativos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `LGPD_2010_ativos` (
  `id_atv_2010` int NOT NULL AUTO_INCREMENT,
  `desc_atv_2010` text NOT NULL,
  `id_status_cid_disp_2010` int NOT NULL,
  `id_status_cid_int_2010` int NOT NULL,
  `id_status_cid_cnfd_2010` int NOT NULL,
  `id_sub_tp_atv_2010` varchar(100) DEFAULT NULL,
  `id_tipo_atv_2010` int NOT NULL,
  `nome_atv_2010` char(250) NOT NULL,
  `desc_cid_cnfd_2010` text,
  `desc_cid_int_2010` text,
  `desc_cid_disp_2010` text,
  `tecnologia_2010` char(150) DEFAULT NULL,
  `resp_cod_atv_2010` int DEFAULT NULL,
  `id_controlador_1000` int NOT NULL,
  `niv_conf_atv_2010` char(10) DEFAULT NULL,
  `agent_verify_2010` tinyint(1) DEFAULT NULL,
  `agent_risk_2010` tinyint(1) DEFAULT NULL,
  `id_terc_2090` int DEFAULT NULL,
  `ind_saas_2010` tinyint DEFAULT NULL,
  `user_insert_2010` varchar(45) DEFAULT NULL,
  `dt_insert_2010` date DEFAULT NULL,
  `user_update_2010` varchar(45) DEFAULT NULL,
  `dt_ult_update_2010` date DEFAULT NULL,
  `calculo_pendente` tinyint DEFAULT '0',
  PRIMARY KEY (`id_atv_2010`),
  KEY `fk_sub_tp_atv_2010` (`id_sub_tp_atv_2010`),
  KEY `fk_tp_atv_2010` (`id_tipo_atv_2010`),
  CONSTRAINT `fk_tp_atv_2010` FOREIGN KEY (`id_tipo_atv_2010`) REFERENCES `DOM_tipo_atv_2010` (`id_tipo_atv_2010`)
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `LGPD_2010_ativos`
--

-- LOCK TABLES `LGPD_2010_ativos` WRITE;
/*!40000 ALTER TABLE `LGPD_2010_ativos` DISABLE KEYS */;
/*!40000 ALTER TABLE `LGPD_2010_ativos` ENABLE KEYS */;
-- UNLOCK TABLES;

--
-- Table structure for table `LGPD_2010_hist_prc`
--

DROP TABLE IF EXISTS `LGPD_2010_hist_prc`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `LGPD_2010_hist_prc` (
  `cod_hist_prc` int NOT NULL AUTO_INCREMENT,
  `cod_prc_2000` int NOT NULL,
  `id_status_prc_2000` int NOT NULL,
  `dt_status_prc_2000` date NOT NULL,
  `resp_status_prc_2000` varchar(45) DEFAULT NULL,
  `aprv_prc_2000` int DEFAULT NULL,
  `reprv_prc_2000` int DEFAULT NULL,
  `obs_hist_prc_2000` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`cod_hist_prc`),
  KEY `fk_2000_prc_idx` (`cod_prc_2000`),
  CONSTRAINT `fk_2000_prc` FOREIGN KEY (`cod_prc_2000`) REFERENCES `LGPD_2000_processos` (`cod_prc_2000`)
) ENGINE=InnoDB AUTO_INCREMENT=30 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci COMMENT='Histórico de status de procesos';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `LGPD_2010_hist_prc`
--

-- LOCK TABLES `LGPD_2010_hist_prc` WRITE;
/*!40000 ALTER TABLE `LGPD_2010_hist_prc` DISABLE KEYS */;
/*!40000 ALTER TABLE `LGPD_2010_hist_prc` ENABLE KEYS */;
-- UNLOCK TABLES;

--
-- Table structure for table `LGPD_2011_model_quest_cid`
--

DROP TABLE IF EXISTS `LGPD_2011_model_quest_cid`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `LGPD_2011_model_quest_cid` (
  `id_model_quest_cid_2011` int NOT NULL AUTO_INCREMENT,
  `medida_2011` varchar(250) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NOT NULL,
  `questao_2011` varchar(250) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NOT NULL,
  PRIMARY KEY (`id_model_quest_cid_2011`)
) ENGINE=InnoDB AUTO_INCREMENT=27 DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `LGPD_2011_model_quest_cid`
--

-- LOCK TABLES `LGPD_2011_model_quest_cid` WRITE;
/*!40000 ALTER TABLE `LGPD_2011_model_quest_cid` DISABLE KEYS */;
INSERT INTO `LGPD_2011_model_quest_cid` VALUES (1,'Backup e Recuperação de Dados','Backups Regulares e Recuperação dos Backups'),(2,'Backup e Recuperação de Dados','Testes regulares de recuperação dos backups'),(3,'Backup e Recuperação de Dados','Criptografia dos Backups'),(4,'Backup e Recuperação de Dados','Redundância dos Backups'),(5,'Controle de Acesso','Listas de controle de acesso (ACLs)'),(6,'Controle de Acesso','Autenticação multifator (MFA)'),(7,'Controle de Acesso','Recaptha'),(8,'Controle de Acesso','Controle de Acesso Baseado em Funções (RBAC)'),(9,'Monitoramento de Sistemas','Logs de auditoria detalhados'),(10,'Monitoramento de Sistemas','Logs de acesso'),(11,'Monitoramento de Sistemas','Monitoramento contínuo e alertas em tempo real'),(12,'Monitoramento de Sistemas','Ferramentas de detecção de falhas '),(13,'Criptografia','Criptografia de Dados em Repouso'),(14,'Criptografia','Criptografia de Dados em Trânsito'),(15,'Criptografia','Gerenciamento de Chaves criptográficas'),(16,'Verificação de Integridade e Confidencialidade de Dados','DLP (Data Loss Prevention)'),(17,'Redundância de Hardware e Rede','Implementação de soluções de redundância para componentes críticos (servidores, redes, armazenamento).'),(18,'Redundância de Hardware e Rede','Configuração de mecanismos de failover automatizado para garantir a continuidade do serviço em caso de falhas.'),(19,'Gestão e contole de versões ','Gestão e contole de versões '),(20,'Balanceamento de Carga','Balanceamento de Carga'),(21,'Atualizações e Patches','Atualizações e Patches'),(22,'Treinamento de Segurança para Funcionários','Treinamento de Segurança para Funcionários'),(23,'Plano de Recuperação de Desastres','Plano de Recuperação de Desastres'),(24,'Contratos de Nível de Serviço (SLAs)','Contratos de Nível de Serviço (SLAs)'),(25,'Análise de Vulnerabilidades','Análise de Vulnerabilidades'),(26,'Gerenciamento de Incidentes e ameaças','Gerenciamento de Incidentes e ameaças');
/*!40000 ALTER TABLE `LGPD_2011_model_quest_cid` ENABLE KEYS */;
-- UNLOCK TABLES;

--
-- Table structure for table `LGPD_2012_aval_cid`
--

DROP TABLE IF EXISTS `LGPD_2012_aval_cid`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `LGPD_2012_aval_cid` (
  `id_quest_cid_2012` int NOT NULL AUTO_INCREMENT,
  `id_atv_2010` int NOT NULL,
  `id_model_quest_cid_2011` int NOT NULL,
  `peso_2012` int NOT NULL DEFAULT '0',
  `sas_2012` tinyint NOT NULL DEFAULT '0',
  `sugestao_2012` tinyint NOT NULL DEFAULT '0',
  `nao_aplica` tinyint DEFAULT NULL,
  `confid_obrigatorio` tinyint DEFAULT NULL,
  `confid_desejavel` tinyint DEFAULT NULL,
  `confid_possui` tinyint DEFAULT NULL,
  `integ_obrigatorio` tinyint DEFAULT NULL,
  `integ_desejavel` tinyint DEFAULT NULL,
  `integ_possui` tinyint DEFAULT NULL,
  `dispo_obrigatorio` tinyint DEFAULT NULL,
  `dispo_desjavel` tinyint DEFAULT NULL,
  `dispo_possui` tinyint DEFAULT NULL,
  PRIMARY KEY (`id_quest_cid_2012`)
) ENGINE=InnoDB AUTO_INCREMENT=492 DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `LGPD_2012_aval_cid`
--

-- LOCK TABLES `LGPD_2012_aval_cid` WRITE;
/*!40000 ALTER TABLE `LGPD_2012_aval_cid` DISABLE KEYS */;
/*!40000 ALTER TABLE `LGPD_2012_aval_cid` ENABLE KEYS */;
-- UNLOCK TABLES;

--
-- Table structure for table `LGPD_2013_param_sas_aval_cid`
--

DROP TABLE IF EXISTS `LGPD_2013_param_sas_aval_cid`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `LGPD_2013_param_sas_aval_cid` (
  `id_gestao_sas_param_cid_2013` int NOT NULL AUTO_INCREMENT,
  `id_atv_2010` int NOT NULL,
  `habilitou_calc_real_2013` tinyint NOT NULL DEFAULT '0',
  `dt_habilitacao_calc_real_2013` datetime DEFAULT NULL,
  PRIMARY KEY (`id_gestao_sas_param_cid_2013`),
  KEY `fk_id_ativos_2010` (`id_atv_2010`),
  CONSTRAINT `fk_id_ativos_2010` FOREIGN KEY (`id_atv_2010`) REFERENCES `LGPD_2010_ativos` (`id_atv_2010`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `LGPD_2013_param_sas_aval_cid`
--

-- LOCK TABLES `LGPD_2013_param_sas_aval_cid` WRITE;
/*!40000 ALTER TABLE `LGPD_2013_param_sas_aval_cid` DISABLE KEYS */;
/*!40000 ALTER TABLE `LGPD_2013_param_sas_aval_cid` ENABLE KEYS */;
-- UNLOCK TABLES;

--
-- Table structure for table `LGPD_2014_carga_atv`
--

DROP TABLE IF EXISTS `LGPD_2014_carga_atv`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `LGPD_2014_carga_atv` (
  `id_carga_atv_2014` int NOT NULL AUTO_INCREMENT,
  `nome_arquivo_2014` varchar(250) NOT NULL,
  `data_carga_2014` date NOT NULL,
  `usuario_resp_carga_2014` int NOT NULL,
  `tot_reg_enviados_2014` int DEFAULT NULL,
  `tot_reg_incluidos_2014` int DEFAULT NULL,
  `id_controlador_1000` int NOT NULL,
  `ind_prosseguiu_carga_2014` tinyint NOT NULL DEFAULT '0',
  PRIMARY KEY (`id_carga_atv_2014`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `LGPD_2014_carga_atv`
--

-- LOCK TABLES `LGPD_2014_carga_atv` WRITE;
/*!40000 ALTER TABLE `LGPD_2014_carga_atv` DISABLE KEYS */;
/*!40000 ALTER TABLE `LGPD_2014_carga_atv` ENABLE KEYS */;
-- UNLOCK TABLES;

--
-- Table structure for table `LGPD_2015_log_err_carga_atv`
--

DROP TABLE IF EXISTS `LGPD_2015_log_err_carga_atv`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `LGPD_2015_log_err_carga_atv` (
  `id_log_err_carga_atv_2015` int NOT NULL AUTO_INCREMENT,
  `id_carga_atv_2014` int NOT NULL,
  `nr_linha_2015` int DEFAULT NULL,
  `nome_atv_2015` text NOT NULL,
  `erro_2015` varchar(200) NOT NULL,
  PRIMARY KEY (`id_log_err_carga_atv_2015`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `LGPD_2015_log_err_carga_atv`
--

-- LOCK TABLES `LGPD_2015_log_err_carga_atv` WRITE;
/*!40000 ALTER TABLE `LGPD_2015_log_err_carga_atv` DISABLE KEYS */;
/*!40000 ALTER TABLE `LGPD_2015_log_err_carga_atv` ENABLE KEYS */;
-- UNLOCK TABLES;

--
-- Table structure for table `LGPD_2016_hist_carga_atv`
--

DROP TABLE IF EXISTS `LGPD_2016_hist_carga_atv`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `LGPD_2016_hist_carga_atv` (
  `id_hist_carga_atv_2016` int NOT NULL AUTO_INCREMENT,
  `id_carga_atv_2014` int NOT NULL,
  `nome_atv_2016` varchar(250) NOT NULL,
  `desc_atv_2016` text,
  `resp_atv_2016` int DEFAULT NULL,
  `id_terc_2016` int DEFAULT NULL,
  `id_tipo_atv_2016` int NOT NULL,
  `ind_saas_2016` tinyint NOT NULL,
  `sub_tp_atv_2016` varchar(100) DEFAULT NULL,
  `tecnologia_2016` varchar(150) DEFAULT NULL,
  `id_status_cid_cnfd_2016` int DEFAULT NULL,
  `id_status_cid_int_2016` int DEFAULT NULL,
  `id_status_cid_disp_2016` int DEFAULT NULL,
  `desc_cid_cnfd_2016` text,
  `desc_cid_int_2016` text,
  `desc_cid_disp_2016` text,
  `id_controlador_1000` int NOT NULL,
  `nr_linha_2016` int DEFAULT NULL,
  `acao_carga_2016` varchar(10) DEFAULT NULL,
  PRIMARY KEY (`id_hist_carga_atv_2016`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `LGPD_2016_hist_carga_atv`
--

-- LOCK TABLES `LGPD_2016_hist_carga_atv` WRITE;
/*!40000 ALTER TABLE `LGPD_2016_hist_carga_atv` DISABLE KEYS */;
/*!40000 ALTER TABLE `LGPD_2016_hist_carga_atv` ENABLE KEYS */;
-- UNLOCK TABLES;

--
-- Table structure for table `LGPD_2020_artefatos`
--

DROP TABLE IF EXISTS `LGPD_2020_artefatos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `LGPD_2020_artefatos` (
  `cod_art_2020` int NOT NULL AUTO_INCREMENT,
  `nome_art_2020` char(250) NOT NULL,
  `contrato_art_2020` tinyint(1) DEFAULT NULL,
  `id_controlador_1000` int NOT NULL,
  `id_tp_artefato_2020` int NOT NULL,
  `relac_tit_art_2020` text,
  `desc_art_2020` varchar(1000) DEFAULT NULL,
  `user_insert_2020` varchar(45) DEFAULT NULL,
  `dt_insert_2020` date DEFAULT NULL,
  `user_update_2020` varchar(45) DEFAULT NULL,
  `dt_ult_update_2020` date DEFAULT NULL,
  PRIMARY KEY (`cod_art_2020`),
  KEY `fk_tp_atv_2020` (`id_tp_artefato_2020`),
  KEY `fk_id_controlador_1000_1` (`id_controlador_1000`),
  CONSTRAINT `fk_id_controlador_1000_1` FOREIGN KEY (`id_controlador_1000`) REFERENCES `LGPD_1000_controlador` (`id_controlador_1000`),
  CONSTRAINT `fk_tp_atv_2020` FOREIGN KEY (`id_tp_artefato_2020`) REFERENCES `DOM_tp_artefato_2020` (`id_tp_artefato_2020`)
) ENGINE=InnoDB AUTO_INCREMENT=14 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `LGPD_2020_artefatos`
--

-- LOCK TABLES `LGPD_2020_artefatos` WRITE;
/*!40000 ALTER TABLE `LGPD_2020_artefatos` DISABLE KEYS */;
/*!40000 ALTER TABLE `LGPD_2020_artefatos` ENABLE KEYS */;
-- UNLOCK TABLES;

--
-- Table structure for table `LGPD_2021_carga_art`
--

DROP TABLE IF EXISTS `LGPD_2021_carga_art`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `LGPD_2021_carga_art` (
  `id_carga_art_2021` int NOT NULL AUTO_INCREMENT,
  `nome_arquivo_2021` varchar(250) NOT NULL,
  `data_carga_2021` date NOT NULL,
  `usuario_resp_carga_2021` int NOT NULL,
  `tot_reg_enviados_2021` int DEFAULT NULL,
  `tot_reg_incluidos_2021` int DEFAULT NULL,
  `id_controlador_1000` int NOT NULL,
  `ind_prosseguiu_carga_2021` tinyint NOT NULL DEFAULT '0',
  PRIMARY KEY (`id_carga_art_2021`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `LGPD_2021_carga_art`
--

-- LOCK TABLES `LGPD_2021_carga_art` WRITE;
/*!40000 ALTER TABLE `LGPD_2021_carga_art` DISABLE KEYS */;
/*!40000 ALTER TABLE `LGPD_2021_carga_art` ENABLE KEYS */;
-- UNLOCK TABLES;

--
-- Table structure for table `LGPD_2022_log_err_carga_art`
--

DROP TABLE IF EXISTS `LGPD_2022_log_err_carga_art`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `LGPD_2022_log_err_carga_art` (
  `id_log_err_carga_art_2022` int NOT NULL AUTO_INCREMENT,
  `id_carga_art_2021` int NOT NULL,
  `nr_linha_2022` int DEFAULT NULL,
  `nome_art_2022` text NOT NULL,
  `erro_2022` varchar(200) NOT NULL,
  PRIMARY KEY (`id_log_err_carga_art_2022`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `LGPD_2022_log_err_carga_art`
--

-- LOCK TABLES `LGPD_2022_log_err_carga_art` WRITE;
/*!40000 ALTER TABLE `LGPD_2022_log_err_carga_art` DISABLE KEYS */;
/*!40000 ALTER TABLE `LGPD_2022_log_err_carga_art` ENABLE KEYS */;
-- UNLOCK TABLES;

--
-- Table structure for table `LGPD_2023_hist_carga_art`
--

DROP TABLE IF EXISTS `LGPD_2023_hist_carga_art`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `LGPD_2023_hist_carga_art` (
  `id_hist_carga_art_2023` int NOT NULL AUTO_INCREMENT,
  `id_carga_art_2021` int NOT NULL,
  `nome_art_2023` char(250) NOT NULL,
  `desc_art_2023` varchar(1000) DEFAULT NULL,
  `id_tp_artefato_2023` int NOT NULL,
  `contrato_art_2023` tinyint(1) DEFAULT NULL,
  `id_controlador_1000` int NOT NULL,
  `nr_linha_2023` int DEFAULT NULL,
  `acao_carga_2023` varchar(10) DEFAULT NULL,
  PRIMARY KEY (`id_hist_carga_art_2023`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `LGPD_2023_hist_carga_art`
--

-- LOCK TABLES `LGPD_2023_hist_carga_art` WRITE;
/*!40000 ALTER TABLE `LGPD_2023_hist_carga_art` DISABLE KEYS */;
/*!40000 ALTER TABLE `LGPD_2023_hist_carga_art` ENABLE KEYS */;
-- UNLOCK TABLES;

--
-- Table structure for table `LGPD_2030_dados`
--

DROP TABLE IF EXISTS `LGPD_2030_dados`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `LGPD_2030_dados` (
  `id_tipo_dad_2030` int NOT NULL,
  `nome_dad_2030` char(150) NOT NULL,
  `desc_dad_2030` text,
  `cod_dad_2030` int NOT NULL AUTO_INCREMENT,
  `dado_anonimizavel_2030` tinyint(1) DEFAULT NULL,
  `id_tipificacao_dad_2030` int NOT NULL,
  `id_controlador_1000` int DEFAULT NULL,
  `user_insert_2030` varchar(45) DEFAULT NULL,
  `dt_insert_2030` date DEFAULT NULL,
  `user_update_2030` varchar(45) DEFAULT NULL,
  `dt_ult_update_2030` date DEFAULT NULL,
  PRIMARY KEY (`cod_dad_2030`),
  KEY `fk_tipo_dad_2030` (`id_tipo_dad_2030`),
  KEY `fk_tipificacao_dad_2030` (`id_tipificacao_dad_2030`),
  CONSTRAINT `fk_tipificacao_dad_2030` FOREIGN KEY (`id_tipificacao_dad_2030`) REFERENCES `DOM_tipificacao_dad_2030` (`id_tipificacao_dad_2030`),
  CONSTRAINT `fk_tipo_dad_2030` FOREIGN KEY (`id_tipo_dad_2030`) REFERENCES `DOM_tipo_dad_2030` (`id_tipo_dad_2030`)
) ENGINE=InnoDB AUTO_INCREMENT=40 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `LGPD_2030_dados`
--

-- LOCK TABLES `LGPD_2030_dados` WRITE;
/*!40000 ALTER TABLE `LGPD_2030_dados` DISABLE KEYS */;
/*!40000 ALTER TABLE `LGPD_2030_dados` ENABLE KEYS */;
-- UNLOCK TABLES;

--
-- Table structure for table `LGPD_2031_carga_dados`
--

DROP TABLE IF EXISTS `LGPD_2031_carga_dados`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `LGPD_2031_carga_dados` (
  `id_carga_dad_2031` int NOT NULL AUTO_INCREMENT,
  `nome_arquivo_2031` varchar(250) NOT NULL,
  `data_carga_2031` date NOT NULL,
  `usuario_resp_carga_2031` int NOT NULL,
  `tot_reg_enviados_2031` int DEFAULT NULL,
  `tot_reg_incluidos_2031` int DEFAULT NULL,
  `id_controlador_1000` int NOT NULL,
  `ind_prosseguiu_carga_2031` tinyint NOT NULL DEFAULT '0',
  PRIMARY KEY (`id_carga_dad_2031`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `LGPD_2031_carga_dados`
--

-- LOCK TABLES `LGPD_2031_carga_dados` WRITE;
/*!40000 ALTER TABLE `LGPD_2031_carga_dados` DISABLE KEYS */;
/*!40000 ALTER TABLE `LGPD_2031_carga_dados` ENABLE KEYS */;
-- UNLOCK TABLES;

--
-- Table structure for table `LGPD_2032_log_err_carga_dados`
--

DROP TABLE IF EXISTS `LGPD_2032_log_err_carga_dados`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `LGPD_2032_log_err_carga_dados` (
  `id_log_err_carga_dad_2032` int NOT NULL AUTO_INCREMENT,
  `id_carga_dad_2031` int NOT NULL,
  `nr_linha_2032` int DEFAULT NULL,
  `nome_dad_2032` text NOT NULL,
  `erro_2032` varchar(200) NOT NULL,
  PRIMARY KEY (`id_log_err_carga_dad_2032`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `LGPD_2032_log_err_carga_dados`
--

-- LOCK TABLES `LGPD_2032_log_err_carga_dados` WRITE;
/*!40000 ALTER TABLE `LGPD_2032_log_err_carga_dados` DISABLE KEYS */;
/*!40000 ALTER TABLE `LGPD_2032_log_err_carga_dados` ENABLE KEYS */;
-- UNLOCK TABLES;

--
-- Table structure for table `LGPD_2033_hist_carga_dados`
--

DROP TABLE IF EXISTS `LGPD_2033_hist_carga_dados`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `LGPD_2033_hist_carga_dados` (
  `id_hist_carga_dad_2033` int NOT NULL AUTO_INCREMENT,
  `id_carga_dad_2031` int NOT NULL,
  `nome_dad_2033` char(150) NOT NULL,
  `desc_dad_2033` text,
  `dado_anonimizavel_2033` tinyint(1) DEFAULT NULL,
  `id_tipo_dad_2033` int NOT NULL,
  `id_tipificacao_dad_2033` int NOT NULL,
  `id_controlador_1000` int DEFAULT NULL,
  `nr_linha_2033` int DEFAULT NULL,
  `acao_carga_2033` varchar(10) DEFAULT NULL,
  PRIMARY KEY (`id_hist_carga_dad_2033`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `LGPD_2033_hist_carga_dados`
--

-- LOCK TABLES `LGPD_2033_hist_carga_dados` WRITE;
/*!40000 ALTER TABLE `LGPD_2033_hist_carga_dados` DISABLE KEYS */;
/*!40000 ALTER TABLE `LGPD_2033_hist_carga_dados` ENABLE KEYS */;
-- UNLOCK TABLES;

--
-- Table structure for table `LGPD_2040_assoc_prc_atv`
--

DROP TABLE IF EXISTS `LGPD_2040_assoc_prc_atv`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `LGPD_2040_assoc_prc_atv` (
  `cod_prc_2000` int NOT NULL,
  `cod_atv_2010` int NOT NULL,
  PRIMARY KEY (`cod_prc_2000`,`cod_atv_2010`),
  KEY `fki_fk_cod_atv_2010` (`cod_atv_2010`),
  KEY `fki_fk_cod_prc_2000` (`cod_prc_2000`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `LGPD_2040_assoc_prc_atv`
--

-- LOCK TABLES `LGPD_2040_assoc_prc_atv` WRITE;
/*!40000 ALTER TABLE `LGPD_2040_assoc_prc_atv` DISABLE KEYS */;
/*!40000 ALTER TABLE `LGPD_2040_assoc_prc_atv` ENABLE KEYS */;
-- UNLOCK TABLES;

--
-- Table structure for table `LGPD_2050_assoc_atv_art`
--

DROP TABLE IF EXISTS `LGPD_2050_assoc_atv_art`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `LGPD_2050_assoc_atv_art` (
  `cod_atv_2010` int NOT NULL,
  `cod_art_2020` int NOT NULL,
  `id_assoc_2050` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`id_assoc_2050`),
  UNIQUE KEY `ixLGPD_2050_01` (`cod_atv_2010`,`cod_art_2020`),
  KEY `fki_fk_cod_art_2050` (`cod_art_2020`)
) ENGINE=InnoDB AUTO_INCREMENT=20 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `LGPD_2050_assoc_atv_art`
--

-- LOCK TABLES `LGPD_2050_assoc_atv_art` WRITE;
/*!40000 ALTER TABLE `LGPD_2050_assoc_atv_art` DISABLE KEYS */;
/*!40000 ALTER TABLE `LGPD_2050_assoc_atv_art` ENABLE KEYS */;
-- UNLOCK TABLES;

--
-- Table structure for table `LGPD_2060_assoc_art_dad`
--

DROP TABLE IF EXISTS `LGPD_2060_assoc_art_dad`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `LGPD_2060_assoc_art_dad` (
  `cod_art_2020` int NOT NULL,
  `cod_dad_2030` int NOT NULL,
  `id_assoc_2060` int NOT NULL AUTO_INCREMENT,
  `espec_dado_2060` char(200) DEFAULT NULL,
  PRIMARY KEY (`id_assoc_2060`),
  KEY `fki_fk_cod_art_2060` (`cod_art_2020`)
) ENGINE=InnoDB AUTO_INCREMENT=27 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `LGPD_2060_assoc_art_dad`
--

-- LOCK TABLES `LGPD_2060_assoc_art_dad` WRITE;
/*!40000 ALTER TABLE `LGPD_2060_assoc_art_dad` DISABLE KEYS */;
/*!40000 ALTER TABLE `LGPD_2060_assoc_art_dad` ENABLE KEYS */;
-- UNLOCK TABLES;

--
-- Table structure for table `LGPD_2065_fund_legal`
--

DROP TABLE IF EXISTS `LGPD_2065_fund_legal`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `LGPD_2065_fund_legal` (
  `titulo_fund_leg_2065` char(250) NOT NULL,
  `dt_ini_vig_2065` date DEFAULT NULL,
  `desc_fund_leg_2065` text,
  `cod_fund_leg_2065` int NOT NULL AUTO_INCREMENT,
  `id_tp_fund_leg_2065` int NOT NULL,
  `id_controlador_1000` int DEFAULT NULL,
  `id_amb_reg_2066` varchar(150) DEFAULT NULL,
  `ind_pol_publica_2065` tinyint(1) DEFAULT NULL,
  `anexo_2065` varchar(250) DEFAULT NULL,
  `user_insert_2065` varchar(45) DEFAULT NULL,
  `dt_insert_2065` date DEFAULT NULL,
  `user_update_2065` varchar(45) DEFAULT NULL,
  `dt_ult_update_2065` date DEFAULT NULL,
  PRIMARY KEY (`cod_fund_leg_2065`),
  KEY `fk_tp_fund_leg_2065` (`id_tp_fund_leg_2065`),
  CONSTRAINT `fk_tp_fund_leg_2065` FOREIGN KEY (`id_tp_fund_leg_2065`) REFERENCES `DOM_tp_fund_legal_2065` (`id_tp_fund_legal_2065`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `LGPD_2065_fund_legal`
--

-- LOCK TABLES `LGPD_2065_fund_legal` WRITE;
/*!40000 ALTER TABLE `LGPD_2065_fund_legal` DISABLE KEYS */;
/*!40000 ALTER TABLE `LGPD_2065_fund_legal` ENABLE KEYS */;
-- UNLOCK TABLES;

--
-- Table structure for table `LGPD_2066_ambiente_reg`
--

DROP TABLE IF EXISTS `LGPD_2066_ambiente_reg`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `LGPD_2066_ambiente_reg` (
  `id_amb_reg_2066` int NOT NULL AUTO_INCREMENT,
  `nome_orgao_2066` text,
  `desc_orgão_2066` text,
  `id_controlador_1000` int DEFAULT NULL,
  PRIMARY KEY (`id_amb_reg_2066`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `LGPD_2066_ambiente_reg`
--

-- LOCK TABLES `LGPD_2066_ambiente_reg` WRITE;
/*!40000 ALTER TABLE `LGPD_2066_ambiente_reg` DISABLE KEYS */;
/*!40000 ALTER TABLE `LGPD_2066_ambiente_reg` ENABLE KEYS */;
-- UNLOCK TABLES;

--
-- Table structure for table `LGPD_2070_finalidades`
--

DROP TABLE IF EXISTS `LGPD_2070_finalidades`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `LGPD_2070_finalidades` (
  `cod_fin_2070` int NOT NULL AUTO_INCREMENT,
  `nome_fin_2070` char(250) NOT NULL,
  `desc_fin_2070` text,
  `descarte_fim_2070` tinyint(1) DEFAULT NULL,
  `prc_descart_fin_2070` text,
  `id_hipt_trat_fin_2070` int NOT NULL,
  `prc_consent_fin_2070` text,
  `cod_prc_2000` int NOT NULL,
  `id_papel_ent_2070` int NOT NULL,
  `rot_auto_2070` tinyint(1) DEFAULT NULL,
  `dado_criança_2070` tinyint(1) DEFAULT NULL,
  `usa_operador_2070` tinyint(1) DEFAULT NULL,
  `compart_dado_2070` tinyint(1) DEFAULT NULL,
  `desc_proc_compart_2070` text,
  `id_controlador_1000` int DEFAULT NULL,
  `id_frq_fin_2070` int NOT NULL,
  `id_vlm_reg_fin_2070` int NOT NULL,
  `cod_prc_descart_fin_2070` int DEFAULT NULL,
  `cod_prc_consent_fin_2070` int DEFAULT NULL,
  `cod_operador_2070` int DEFAULT NULL,
  `id_contrato_2085` int DEFAULT NULL,
  `utlz_dad_sensivel_2070` tinyint(1) DEFAULT NULL,
  `legitimidade_interesse_2070` text,
  `agent_verify_2070` tinyint(1) DEFAULT NULL,
  `origem_info_2070` varchar(200) DEFAULT NULL,
  `destino_info_2070` varchar(200) DEFAULT NULL,
  `prz_descarte_2070` int DEFAULT NULL COMMENT 'Prazo de armazenamento do dado antes do descarte ',
  `prz_consent_2070` int DEFAULT NULL COMMENT 'Prazo do consentimento para finalidades com hipotese = consentimento do titular',
  `cod_proc_compart_2070` int DEFAULT NULL COMMENT 'codigo do processo de compartilhamento',
  `ind_transf_intern_2070` tinyint DEFAULT NULL COMMENT 'indicador se existe transferência internacional',
  `rel_pais_trnsf_intern_2070` varchar(250) DEFAULT NULL,
  `user_insert_2070` varchar(45) DEFAULT NULL,
  `dt_insert_2070` date DEFAULT NULL,
  `user_update_2070` varchar(45) DEFAULT NULL,
  `dt_ult_update_2070` date DEFAULT NULL,
  `anexo1_2070` varchar(150) DEFAULT NULL,
  `anexo2_2070` varchar(150) DEFAULT NULL,
  `leg_lic_esp_2070` tinyint DEFAULT NULL COMMENT 'Este interesse é lícito e específico?',
  `leg_benef_2070` longtext COMMENT 'Qual benefício a empresa (ou terceiro) obterá com este tratamento?',
  `leg_conclusao_2070` longtext COMMENT 'Conclusão final do avaliador em relação aos parametros do legitimo interesse.',
  `leg_avaliador_2070` int DEFAULT NULL COMMENT 'Pessoal responsável por avaliar e aprovar os parametros do legitimo interesse.',
  `leg_status_aval_2070` varchar(45) DEFAULT NULL COMMENT 'Status da avaliação dos parametros do legitimo interesse.',
  `ind_alto_impact_2070` int DEFAULT NULL,
  `just_alto_impact_2070` varchar(250) DEFAULT NULL,
  `id_abrang_nr_tit_2070` int DEFAULT NULL,
  `id_abrang_duracao_2070` int DEFAULT NULL,
  `id_abrang_ext_geo_2070` int DEFAULT NULL,
  `dir_int_imped_exerc_2070` tinyint DEFAULT NULL,
  `dir_int_imped_utlz_serc_2070` tinyint DEFAULT NULL,
  `dir_int_dano_discriminacao` tinyint DEFAULT NULL,
  `dir_int_dano_integrid_fis` tinyint DEFAULT NULL,
  `dir_int_dano_img_reput` tinyint DEFAULT NULL,
  `dir_int_dano_fraude_fin` tinyint DEFAULT NULL,
  `dir_int_dano_roubo_ident` tinyint DEFAULT NULL,
  `aval_crit_esp_tec_emerg` tinyint DEFAULT NULL,
  `aval_crit_esp_monit_areas` tinyint DEFAULT NULL,
  `aval_crit_esp_algorit_dec` tinyint DEFAULT NULL,
  PRIMARY KEY (`cod_fin_2070`),
  KEY `fki_fk_cod_processo_2000` (`cod_prc_2000`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `LGPD_2070_finalidades`
--

-- LOCK TABLES `LGPD_2070_finalidades` WRITE;
/*!40000 ALTER TABLE `LGPD_2070_finalidades` DISABLE KEYS */;
/*!40000 ALTER TABLE `LGPD_2070_finalidades` ENABLE KEYS */;
-- UNLOCK TABLES;

--
-- Table structure for table `LGPD_2073_assoc_ativos_fin`
--

DROP TABLE IF EXISTS `LGPD_2073_assoc_ativos_fin`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `LGPD_2073_assoc_ativos_fin` (
  `cod_fin_2070` int NOT NULL,
  `cod_atv_2010` int NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `LGPD_2073_assoc_ativos_fin`
--

-- LOCK TABLES `LGPD_2073_assoc_ativos_fin` WRITE;
/*!40000 ALTER TABLE `LGPD_2073_assoc_ativos_fin` DISABLE KEYS */;
/*!40000 ALTER TABLE `LGPD_2073_assoc_ativos_fin` ENABLE KEYS */;
-- UNLOCK TABLES;

--
-- Table structure for table `LGPD_2074_assoc_atv_art_fin`
--

DROP TABLE IF EXISTS `LGPD_2074_assoc_atv_art_fin`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `LGPD_2074_assoc_atv_art_fin` (
  `cod_fin_2070` int NOT NULL,
  `id_atv_2010` int DEFAULT NULL,
  `cod_art_2020` int DEFAULT NULL,
  `id_assoc_2074` int NOT NULL AUTO_INCREMENT,
  `id_assoc_2050` int DEFAULT NULL,
  PRIMARY KEY (`id_assoc_2074`)
) ENGINE=InnoDB AUTO_INCREMENT=32 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `LGPD_2074_assoc_atv_art_fin`
--

-- LOCK TABLES `LGPD_2074_assoc_atv_art_fin` WRITE;
/*!40000 ALTER TABLE `LGPD_2074_assoc_atv_art_fin` DISABLE KEYS */;
/*!40000 ALTER TABLE `LGPD_2074_assoc_atv_art_fin` ENABLE KEYS */;
-- UNLOCK TABLES;

--
-- Table structure for table `LGPD_2075_assoc_funcional_fin`
--

DROP TABLE IF EXISTS `LGPD_2075_assoc_funcional_fin`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `LGPD_2075_assoc_funcional_fin` (
  `cod_fin_2070` int NOT NULL,
  `cod_dad_2030` int NOT NULL,
  `dado_imprec_2075` tinyint(1) DEFAULT NULL,
  `id_atv_2010` int DEFAULT NULL,
  `cod_art_2020` int DEFAULT NULL,
  `id_assoc_2060` int DEFAULT NULL,
  `id_assoc_2075` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`id_assoc_2075`),
  KEY `fki_fk_cd_dad_2030` (`cod_dad_2030`),
  KEY `fki_fk_cd_fin_2070` (`cod_fin_2070`)
) ENGINE=InnoDB AUTO_INCREMENT=118 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `LGPD_2075_assoc_funcional_fin`
--

-- LOCK TABLES `LGPD_2075_assoc_funcional_fin` WRITE;
/*!40000 ALTER TABLE `LGPD_2075_assoc_funcional_fin` DISABLE KEYS */;
/*!40000 ALTER TABLE `LGPD_2075_assoc_funcional_fin` ENABLE KEYS */;
-- UNLOCK TABLES;

--
-- Table structure for table `LGPD_2076_fin_compart_terc`
--

DROP TABLE IF EXISTS `LGPD_2076_fin_compart_terc`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `LGPD_2076_fin_compart_terc` (
  `id_terc_2090` int DEFAULT NULL,
  `cod_fin_2070` int DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `LGPD_2076_fin_compart_terc`
--

-- LOCK TABLES `LGPD_2076_fin_compart_terc` WRITE;
/*!40000 ALTER TABLE `LGPD_2076_fin_compart_terc` DISABLE KEYS */;
/*!40000 ALTER TABLE `LGPD_2076_fin_compart_terc` ENABLE KEYS */;
-- UNLOCK TABLES;

--
-- Table structure for table `LGPD_2077_assoc_fund_leg_fin`
--

DROP TABLE IF EXISTS `LGPD_2077_assoc_fund_leg_fin`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `LGPD_2077_assoc_fund_leg_fin` (
  `cod_fund_leg_2065` int DEFAULT NULL,
  `cod_fin_2070` int DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `LGPD_2077_assoc_fund_leg_fin`
--

-- LOCK TABLES `LGPD_2077_assoc_fund_leg_fin` WRITE;
/*!40000 ALTER TABLE `LGPD_2077_assoc_fund_leg_fin` DISABLE KEYS */;
/*!40000 ALTER TABLE `LGPD_2077_assoc_fund_leg_fin` ENABLE KEYS */;
-- UNLOCK TABLES;

--
-- Table structure for table `LGPD_2078_assoc_fund_polpub_fin`
--

DROP TABLE IF EXISTS `LGPD_2078_assoc_fund_polpub_fin`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `LGPD_2078_assoc_fund_polpub_fin` (
  `cod_fund_leg_2065` int DEFAULT NULL,
  `cod_fin_2070` int DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `LGPD_2078_assoc_fund_polpub_fin`
--

-- LOCK TABLES `LGPD_2078_assoc_fund_polpub_fin` WRITE;
/*!40000 ALTER TABLE `LGPD_2078_assoc_fund_polpub_fin` DISABLE KEYS */;
/*!40000 ALTER TABLE `LGPD_2078_assoc_fund_polpub_fin` ENABLE KEYS */;
-- UNLOCK TABLES;

--
-- Table structure for table `LGPD_2080_politicas`
--

DROP TABLE IF EXISTS `LGPD_2080_politicas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `LGPD_2080_politicas` (
  `id_politica_2080` int NOT NULL AUTO_INCREMENT,
  `titulo_politica_2080` text,
  `resp_politica_2008` int DEFAULT NULL,
  `resumo_politica_2080` text,
  `dt_publ_pol_2080` date DEFAULT NULL,
  `dt_fim_vig_pol_2080` date DEFAULT NULL,
  `id_status_pol_2080` int NOT NULL,
  `flag_priv_publica_2080` tinyint(1) DEFAULT '0',
  `flag_int_gov_2080` tinyint(1) DEFAULT NULL,
  `flag_completa_2080` tinyint(1) DEFAULT NULL,
  `flag_trat_agnt_2080` tinyint(1) DEFAULT NULL,
  `flag_tem_proc_manut_2080` tinyint(1) DEFAULT NULL,
  `flag_exeq_2080` tinyint(1) DEFAULT NULL,
  `flag_trt_risco_2080` tinyint(1) DEFAULT NULL,
  `flag_trt_tit_2080` tinyint(1) DEFAULT NULL,
  `flag_trt_inc_2080` tinyint(1) DEFAULT NULL,
  `flag_trt_dpo_2080` tinyint(1) DEFAULT NULL,
  `flag_trt_trasnf_2080` tinyint(1) DEFAULT NULL,
  `link_pol_priv_pub_2080` text,
  `id_area_1002` int DEFAULT NULL,
  `id_controlador_1000` int DEFAULT NULL,
  `nm_anexo_1_2080` text,
  `cod_prc_2000` int DEFAULT NULL,
  `agent_verify_2080` tinyint(1) DEFAULT NULL,
  `agent_risk_2080` tinyint(1) DEFAULT NULL,
  `id_prc_manut_pol_2080` int DEFAULT NULL,
  `user_insert_2080` varchar(45) DEFAULT NULL,
  `dt_insert_2080` date DEFAULT NULL,
  `user_update_2080` varchar(45) DEFAULT NULL,
  `dt_ult_update_2080` date DEFAULT NULL,
  `nota_minima_aval_2080` int DEFAULT NULL,
  PRIMARY KEY (`id_politica_2080`),
  KEY `fk_status_pol_2080` (`id_status_pol_2080`),
  CONSTRAINT `fk_status_pol_2080` FOREIGN KEY (`id_status_pol_2080`) REFERENCES `DOM_status_pol_2080` (`id_status_pol_2080`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `LGPD_2080_politicas`
--

-- LOCK TABLES `LGPD_2080_politicas` WRITE;
/*!40000 ALTER TABLE `LGPD_2080_politicas` DISABLE KEYS */;
/*!40000 ALTER TABLE `LGPD_2080_politicas` ENABLE KEYS */;
-- UNLOCK TABLES;

--
-- Table structure for table `LGPD_2081_env_politica`
--

DROP TABLE IF EXISTS `LGPD_2081_env_politica`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `LGPD_2081_env_politica` (
  `id_env_politica_2081` int NOT NULL AUTO_INCREMENT,
  `id_politica_2080` int DEFAULT NULL,
  `cod_pessoa_1100` int DEFAULT NULL,
  `dt_env_2081` date DEFAULT NULL,
  `status_2081` varchar(45) DEFAULT NULL,
  `dt_ciencia_2081` date DEFAULT NULL,
  `token_2081` varchar(65) DEFAULT NULL,
  PRIMARY KEY (`id_env_politica_2081`)
) ENGINE=InnoDB AUTO_INCREMENT=92 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `LGPD_2081_env_politica`
--

-- LOCK TABLES `LGPD_2081_env_politica` WRITE;
/*!40000 ALTER TABLE `LGPD_2081_env_politica` DISABLE KEYS */;
/*!40000 ALTER TABLE `LGPD_2081_env_politica` ENABLE KEYS */;
-- UNLOCK TABLES;

--
-- Table structure for table `LGPD_2082_env_politica_terc`
--

DROP TABLE IF EXISTS `LGPD_2082_env_politica_terc`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `LGPD_2082_env_politica_terc` (
  `id_env_politica_terc_2082` int NOT NULL AUTO_INCREMENT,
  `id_politica_2080` int DEFAULT NULL,
  `id_terc_2090` int NOT NULL,
  `dt_env_2082` date DEFAULT NULL,
  `status_2082` varchar(45) DEFAULT NULL,
  `dt_ciencia_2082` date DEFAULT NULL,
  `token_2082` varchar(65) DEFAULT NULL,
  `ind_inclui_quest_2082` tinyint(1) DEFAULT '0',
  `senha_quest_2082` varchar(100) DEFAULT NULL,
  `dt_envio_quest_2082` date DEFAULT NULL,
  `quest_finalizado_2082` tinyint(1) DEFAULT '0',
  `dt_finaliza_quest_2082` date DEFAULT NULL,
  `result_final_pesos_2082` int DEFAULT NULL,
  PRIMARY KEY (`id_env_politica_terc_2082`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `LGPD_2082_env_politica_terc`
--

-- LOCK TABLES `LGPD_2082_env_politica_terc` WRITE;
/*!40000 ALTER TABLE `LGPD_2082_env_politica_terc` DISABLE KEYS */;
/*!40000 ALTER TABLE `LGPD_2082_env_politica_terc` ENABLE KEYS */;
-- UNLOCK TABLES;

--
-- Table structure for table `LGPD_2083_quest_pol`
--

DROP TABLE IF EXISTS `LGPD_2083_quest_pol`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `LGPD_2083_quest_pol` (
  `id_quest_pol_2083` int NOT NULL AUTO_INCREMENT,
  `id_politica_2080` int NOT NULL,
  `questao_2083` text,
  `id_controlador_1000` int DEFAULT NULL,
  `id_tp_resp_2083` int DEFAULT NULL,
  `order_questao_2083` int DEFAULT NULL,
  `ind_ativa_2083` tinyint(1) DEFAULT NULL,
  `peso_resp_sim_2083` int DEFAULT '0',
  `peso_resp_nao_2083` int DEFAULT '0',
  PRIMARY KEY (`id_quest_pol_2083`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `LGPD_2083_quest_pol`
--

-- LOCK TABLES `LGPD_2083_quest_pol` WRITE;
/*!40000 ALTER TABLE `LGPD_2083_quest_pol` DISABLE KEYS */;
/*!40000 ALTER TABLE `LGPD_2083_quest_pol` ENABLE KEYS */;
-- UNLOCK TABLES;

--
-- Table structure for table `LGPD_2084_opt_quest_pol`
--

DROP TABLE IF EXISTS `LGPD_2084_opt_quest_pol`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `LGPD_2084_opt_quest_pol` (
  `id_opt_quest_pol_2084` int NOT NULL AUTO_INCREMENT,
  `id_quest_pol_2083` int NOT NULL,
  `opcao_2084` text,
  `id_controlador_1000` int DEFAULT NULL,
  `peso_2084` int DEFAULT NULL,
  PRIMARY KEY (`id_opt_quest_pol_2084`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `LGPD_2084_opt_quest_pol`
--

-- LOCK TABLES `LGPD_2084_opt_quest_pol` WRITE;
/*!40000 ALTER TABLE `LGPD_2084_opt_quest_pol` DISABLE KEYS */;
/*!40000 ALTER TABLE `LGPD_2084_opt_quest_pol` ENABLE KEYS */;
-- UNLOCK TABLES;

--
-- Table structure for table `LGPD_2085_contratos`
--

DROP TABLE IF EXISTS `LGPD_2085_contratos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `LGPD_2085_contratos` (
  `id_contrato_2085` int NOT NULL AUTO_INCREMENT,
  `titulo_2085` text,
  `resumo_2085` text,
  `dt_ini_vig_2085` date DEFAULT NULL,
  `dt_fim_vig_2085` date DEFAULT NULL,
  `id_status_contr_2085` int NOT NULL,
  `id_atuacao_contr_2085` int NOT NULL,
  `id_controlador_1000` int DEFAULT NULL,
  `id_terc_2090` int DEFAULT NULL,
  `cod_art_2020` int DEFAULT NULL,
  `define_lim_trat_2085` tinyint(1) DEFAULT NULL,
  `define_med_tec_2085` tinyint(1) DEFAULT NULL,
  `define_periodo_2085` tinyint(1) DEFAULT NULL,
  `anexo_2085` varchar(250) DEFAULT NULL,
  `user_insert_2085` varchar(45) DEFAULT NULL,
  `dt_insert_2085` date DEFAULT NULL,
  `user_update_2085` varchar(45) DEFAULT NULL,
  `dt_ult_update_2085` date DEFAULT NULL,
  PRIMARY KEY (`id_contrato_2085`),
  KEY `fk_status_contr_2085` (`id_status_contr_2085`),
  KEY `fk_atuacao_contr_2085` (`id_atuacao_contr_2085`),
  CONSTRAINT `fk_atuacao_contr_2085` FOREIGN KEY (`id_atuacao_contr_2085`) REFERENCES `DOM_atuacao_contr_2085` (`id_atuacao_contr_2085`),
  CONSTRAINT `fk_status_contr_2085` FOREIGN KEY (`id_status_contr_2085`) REFERENCES `DOM_status_contr_2085` (`id_status_contr_2085`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `LGPD_2085_contratos`
--

-- LOCK TABLES `LGPD_2085_contratos` WRITE;
/*!40000 ALTER TABLE `LGPD_2085_contratos` DISABLE KEYS */;
/*!40000 ALTER TABLE `LGPD_2085_contratos` ENABLE KEYS */;
-- UNLOCK TABLES;

--
-- Table structure for table `LGPD_2086_assoc_contr_fin`
--

DROP TABLE IF EXISTS `LGPD_2086_assoc_contr_fin`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `LGPD_2086_assoc_contr_fin` (
  `id_contrato_2085` int DEFAULT NULL,
  `cod_fin_2070` int DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `LGPD_2086_assoc_contr_fin`
--

-- LOCK TABLES `LGPD_2086_assoc_contr_fin` WRITE;
/*!40000 ALTER TABLE `LGPD_2086_assoc_contr_fin` DISABLE KEYS */;
/*!40000 ALTER TABLE `LGPD_2086_assoc_contr_fin` ENABLE KEYS */;
-- UNLOCK TABLES;

--
-- Table structure for table `LGPD_2087_ndas`
--

DROP TABLE IF EXISTS `LGPD_2087_ndas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `LGPD_2087_ndas` (
  `id` int NOT NULL AUTO_INCREMENT,
  `nome_documento` varchar(255) NOT NULL,
  `parte_divulgadora` varchar(255) NOT NULL,
  `parte_receptora` varchar(255) NOT NULL,
  `data_assinatura` date DEFAULT NULL,
  `data_inicio` date DEFAULT NULL,
  `data_fim` date DEFAULT NULL,
  `escopo_informacao` text,
  `clausulas_excecao` text,
  `duracao_confidencialidade` varchar(255) DEFAULT NULL,
  `jurisdicao` varchar(255) DEFAULT NULL,
  `contato_responsavel` varchar(255) DEFAULT NULL,
  `email_contato` varchar(255) DEFAULT NULL,
  `telefone_contato` varchar(20) DEFAULT NULL,
  `caminho_arquivo` varchar(512) DEFAULT NULL,
  `data_criacao` date DEFAULT NULL,
  `data_atualizacao` date DEFAULT NULL,
  `id_controlador_1000` int DEFAULT NULL,
  `papel_nda` varchar(45) DEFAULT NULL COMMENT 'indica se eu sou o receptor ou divulgador no nda',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `LGPD_2087_ndas`
--

-- LOCK TABLES `LGPD_2087_ndas` WRITE;
/*!40000 ALTER TABLE `LGPD_2087_ndas` DISABLE KEYS */;
/*!40000 ALTER TABLE `LGPD_2087_ndas` ENABLE KEYS */;
-- UNLOCK TABLES;

--
-- Table structure for table `LGPD_2088_resp_quest_pol`
--

DROP TABLE IF EXISTS `LGPD_2088_resp_quest_pol`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `LGPD_2088_resp_quest_pol` (
  `id_resp_quest_pol_2088` int NOT NULL AUTO_INCREMENT,
  `id_env_politica_terc_2082` int NOT NULL,
  `resposta_2088` text,
  `id_quest_pol_2083` int DEFAULT NULL,
  `questao_2088` text CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci,
  `id_tp_resp_2088` int DEFAULT NULL,
  `order_questao_2088` int DEFAULT NULL,
  `peso_2088` int DEFAULT NULL,
  PRIMARY KEY (`id_resp_quest_pol_2088`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `LGPD_2088_resp_quest_pol`
--

-- LOCK TABLES `LGPD_2088_resp_quest_pol` WRITE;
/*!40000 ALTER TABLE `LGPD_2088_resp_quest_pol` DISABLE KEYS */;
/*!40000 ALTER TABLE `LGPD_2088_resp_quest_pol` ENABLE KEYS */;
-- UNLOCK TABLES;

--
-- Table structure for table `LGPD_2090_terceiros`
--

DROP TABLE IF EXISTS `LGPD_2090_terceiros`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `LGPD_2090_terceiros` (
  `id_terc_2090` int NOT NULL AUTO_INCREMENT,
  `nome_tec_2090` text,
  `id_tp_terc_2090` int NOT NULL,
  `cpf_cnpj_terc_2090` char(14) DEFAULT NULL,
  `id_tp_atu_terc_2090` int NOT NULL,
  `end_terc_2090` text,
  `web_site_2090` text,
  `nome_dpo_terc_2090` text,
  `tel_dpo_terc_2090` char(20) DEFAULT NULL,
  `email_dpo_terc_2090` text,
  `obs_terc_2090` text,
  `id_controlador_1000` int DEFAULT NULL,
  `ind_terc_generico_2090` int DEFAULT NULL,
  `just_generico_2090` text,
  `id_classif_terc_2090` int NOT NULL,
  `id_categoria_terc_2090` int NOT NULL,
  `nome_contato_terc_2090` varchar(100) DEFAULT NULL,
  `tel_contato_terc_2090` varchar(20) DEFAULT NULL,
  `email_contato_terc_2090` varchar(150) DEFAULT NULL,
  `nome_gestor_terc_2090` varchar(100) DEFAULT NULL,
  `tel_gestor_terc_2090` varchar(20) DEFAULT NULL,
  `email_gestor_terc_2090` varchar(150) DEFAULT NULL,
  `nome_fiscal_terc_2090` varchar(100) DEFAULT NULL,
  `tel_fiscal_terc_2090` varchar(20) DEFAULT NULL,
  `email_fiscal_terc_2090` varchar(150) DEFAULT NULL,
  `user_insert_2090` varchar(45) DEFAULT NULL,
  `dt_insert_2090` date DEFAULT NULL,
  `user_update_2090` varchar(45) DEFAULT NULL,
  `dt_ult_update_2090` date DEFAULT NULL,
  `origem_cad_terc_2090` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`id_terc_2090`),
  KEY `fk_tp_terc_2090` (`id_tp_terc_2090`),
  KEY `fk_tp_atu_terc_2090` (`id_tp_atu_terc_2090`),
  KEY `fk_classif_terc_2090` (`id_classif_terc_2090`),
  KEY `fk_categoria_terc_2090` (`id_categoria_terc_2090`),
  CONSTRAINT `fk_categoria_terc_2090` FOREIGN KEY (`id_categoria_terc_2090`) REFERENCES `DOM_categoria_terc_2090` (`id_categoria_terc_2090`),
  CONSTRAINT `fk_classif_terc_2090` FOREIGN KEY (`id_classif_terc_2090`) REFERENCES `DOM_classif_terc_2090` (`id_classif_terc_2090`),
  CONSTRAINT `fk_tp_atu_terc_2090` FOREIGN KEY (`id_tp_atu_terc_2090`) REFERENCES `DOM_tp_atu_terc_2090` (`id_tp_atu_terc_2090`),
  CONSTRAINT `fk_tp_terc_2090` FOREIGN KEY (`id_tp_terc_2090`) REFERENCES `DOM_tp_terc_2090` (`id_tp_terc_2090`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `LGPD_2090_terceiros`
--

-- LOCK TABLES `LGPD_2090_terceiros` WRITE;
/*!40000 ALTER TABLE `LGPD_2090_terceiros` DISABLE KEYS */;
/*!40000 ALTER TABLE `LGPD_2090_terceiros` ENABLE KEYS */;
-- UNLOCK TABLES;

--
-- Table structure for table `LGPD_2091_cad_terc_portal`
--

DROP TABLE IF EXISTS `LGPD_2091_cad_terc_portal`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `LGPD_2091_cad_terc_portal` (
  `id_cad_terc_portal_2091` int NOT NULL AUTO_INCREMENT,
  `contato_env_cad_terc_2091` varchar(250) DEFAULT NULL,
  `token_env_cad_terc_2091` varchar(10) DEFAULT NULL,
  `dt_env_cad_terc_2091` date DEFAULT NULL,
  `dt_finaliza_cad_terc_2091` date DEFAULT NULL,
  `status_cad_terc_2091` varchar(45) DEFAULT 'Enviado',
  `cnpj_cad_terc_2091` varchar(45) DEFAULT NULL,
  `razao_cad_terc_2091` varchar(250) DEFAULT NULL,
  `id_controlador_1000` int DEFAULT NULL,
  PRIMARY KEY (`id_cad_terc_portal_2091`)
) ENGINE=InnoDB AUTO_INCREMENT=45 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci COMMENT='Tabela de registro de envio de solicitação para cadastro externo de terceiros. O cadastro é realizado pelo próprio terceiro através de um portal. Estas tabela armazena o token de acesso e gerencia a finalizlização do  cadastro.';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `LGPD_2091_cad_terc_portal`
--

-- LOCK TABLES `LGPD_2091_cad_terc_portal` WRITE;
/*!40000 ALTER TABLE `LGPD_2091_cad_terc_portal` DISABLE KEYS */;
/*!40000 ALTER TABLE `LGPD_2091_cad_terc_portal` ENABLE KEYS */;
-- UNLOCK TABLES;

--
-- Table structure for table `LGPD_2093_ocorr_terc`
--

DROP TABLE IF EXISTS `LGPD_2093_ocorr_terc`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `LGPD_2093_ocorr_terc` (
  `id_2093` int NOT NULL AUTO_INCREMENT,
  `id_terc_2090` int DEFAULT NULL,
  `id_tp_ocorr_2093` int NOT NULL,
  `desc_ocorr_2093` text,
  `data_ocorr_2093` date DEFAULT NULL,
  `severidade_ocorr_2093` int DEFAULT NULL,
  `action_ocorr_2093` text,
  `id_controlador_1000` int DEFAULT NULL,
  `user_insert_2093` varchar(45) DEFAULT NULL,
  `dt_insert_2093` date DEFAULT NULL,
  `user_update_2093` varchar(45) DEFAULT NULL,
  `dt_ult_update_2093` date DEFAULT NULL,
  PRIMARY KEY (`id_2093`),
  KEY `fk_tp_ocorr_2093` (`id_tp_ocorr_2093`),
  CONSTRAINT `fk_tp_ocorr_2093` FOREIGN KEY (`id_tp_ocorr_2093`) REFERENCES `DOM_tp_ocorr_2093` (`id_tp_ocorr_2093`)
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `LGPD_2093_ocorr_terc`
--

-- LOCK TABLES `LGPD_2093_ocorr_terc` WRITE;
/*!40000 ALTER TABLE `LGPD_2093_ocorr_terc` DISABLE KEYS */;
/*!40000 ALTER TABLE `LGPD_2093_ocorr_terc` ENABLE KEYS */;
-- UNLOCK TABLES;

--
-- Table structure for table `LGPD_2095_med_tec`
--

DROP TABLE IF EXISTS `LGPD_2095_med_tec`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `LGPD_2095_med_tec` (
  `id_med_tec_2095` int NOT NULL AUTO_INCREMENT,
  `id_model_quest_cid_2011` int DEFAULT NULL COMMENT 'id da medida tecnica padrão do framework omnisblue',
  `titulo_med_2095` text,
  `desc_med_2095` text,
  `id_controlador_1000` int DEFAULT NULL,
  `id_politica_2080` int DEFAULT NULL,
  `user_insert_2095` varchar(45) DEFAULT NULL,
  `dt_insert_2095` date DEFAULT NULL,
  `user_update_2095` varchar(45) DEFAULT NULL,
  `dt_ult_update_2095` date DEFAULT NULL,
  `incide_conf_2095` tinyint DEFAULT NULL COMMENT 'incide no parametro de confidencialidade no ativo que utiliza esta medida ?',
  `incide_integr_2095` tinyint DEFAULT NULL COMMENT 'incide no parametro de integridade no ativo que utiliza esta medida ?',
  `incide_dispo_2095` tinyint DEFAULT NULL COMMENT 'incide no parametro de disponibilidade no ativo que utiliza esta medida ?',
  PRIMARY KEY (`id_med_tec_2095`)
) ENGINE=InnoDB AUTO_INCREMENT=52 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `LGPD_2095_med_tec`
--

-- LOCK TABLES `LGPD_2095_med_tec` WRITE;
/*!40000 ALTER TABLE `LGPD_2095_med_tec` DISABLE KEYS */;
INSERT INTO `LGPD_2095_med_tec` VALUES (20,1,'Backups Regulares e Recuperação dos Backups','Consiste em copiar os dados importantes para um local seguro (físico ou na nuvem) em intervalos regulares. A recuperação de backups permite restaurar os dados em caso de perda, corrupção ou desastres.',1,0,'',NULL,'Admin','2025-01-29',0,1,1),(21,2,'Testes regulares de recuperação dos backups','Além de fazer backups, é crucial testar periodicamente a restauração desses backups para garantir que eles estejam funcionando corretamente e que os dados possam ser recuperados em caso de necessidade.',1,0,'',NULL,'Admin','2025-01-29',0,1,1),(22,3,'Criptografia dos Backups','Criptografar os backups adiciona uma camada extra de segurança, protegendo os dados mesmo se o local de armazenamento for comprometido.',1,0,'',NULL,'Admin','2025-01-29',1,1,1),(23,4,'Redundância dos Backups','Manter cópias dos backups em locais diferentes (redundância geográfica) aumenta a resiliência contra desastres naturais ou falhas em um único local.',1,0,'',NULL,'Admin','2025-01-29',0,0,1),(24,5,'Listas de controle de acesso (ACLs)','ACLs definem permissões de acesso a recursos específicos (arquivos, diretórios, etc.), controlando quem pode ler, escrever ou executar cada recurso.',1,0,'',NULL,'Admin','2025-01-29',1,1,0),(25,6,'Autenticação multifator (MFA)','Exige mais de uma forma de autenticação para acessar um sistema ou recurso, como senha e código enviado por SMS ou aplicativo autenticador, aumentando a segurança contra acessos não autorizados.',1,0,'',NULL,'Admin','2025-01-29',1,1,0),(26,7,'Recaptha','Um sistema de verificação para distinguir entre humanos e robôs, utilizado para prevenir ataques automatizados, como bots de spam ou brute-force.',1,0,'',NULL,'Admin','2025-01-29',1,1,0),(27,8,'Controle de Acesso Baseado em Funções (RBAC)','Define permissões de acesso com base nos papéis ou funções dos usuários na organização, simplificando o gerenciamento de permissões e garantindo que cada usuário tenha apenas o acesso necessário para realizar suas tarefas.',1,0,'',NULL,'Admin','2025-01-29',1,1,0),(28,9,'Logs de auditoria detalhados','Registram as atividades realizadas nos sistemas, como logins, alterações em dados, acessos a recursos, etc. Esses logs são essenciais para investigar incidentes de segurança e identificar possíveis violações.',1,0,'',NULL,'Admin','2025-01-29',0,1,0),(29,10,'Logs de acesso','Registram as tentativas de acesso aos sistemas, incluindo logins bem-sucedidos e falhos. São úteis para monitorar atividades suspeitas e identificar tentativas de acesso não autorizado.',1,0,'',NULL,'Admin','2025-01-28',1,1,0),(30,11,'Monitoramento contínuo e alertas em tempo real','Monitora constantemente os sistemas em busca de atividades suspeitas ou anomalias e gera alertas em tempo real para que as equipes de segurança possam agir rapidamente.',1,0,'',NULL,'Admin','2025-01-29',0,0,1),(31,12,'Ferramentas de detecção de falhas ','Utilizam técnicas e algoritmos para identificar possíveis falhas de segurança nos sistemas, como vulnerabilidades em softwares ou configurações incorretas.',1,0,'',NULL,'Admin','2025-01-29',0,1,1),(32,13,'Criptografia de Dados em Repouso','Criptografa os dados armazenados em dispositivos de armazenamento (HDs, SSDs, etc.), protegendo-os contra acessos não autorizados em caso de roubo ou perda dos dispositivos.',1,0,'',NULL,'Admin','2025-01-29',1,1,0),(33,14,'Criptografia de Dados em Trânsito','Criptografa os dados que estão sendo transmitidos entre sistemas ou dispositivos, protegendo-os contra interceptação durante a transmissão. Exemplos: HTTPS, VPN.',1,0,'',NULL,'Admin','2025-01-29',1,1,0),(34,15,'Gerenciamento de Chaves criptográficas','Define políticas e procedimentos para a geração, armazenamento, distribuição e revogação de chaves criptográficas, garantindo a segurança dos dados criptografados.',1,0,'',NULL,'Admin','2025-01-29',1,1,0),(35,16,'DLP (Data Loss Prevention)','Conjunto de técnicas e ferramentas para prevenir a perda ou o vazamento de dados sensíveis, monitorando o tráfego de dados e bloqueando transferências não autorizadas.',1,0,'',NULL,'Admin','2025-01-28',1,1,1),(36,17,'Implementação de soluções de redundância para componentes críticos (servidores, redes, armazenamento).','Duplicar componentes críticos da infraestrutura para garantir a disponibilidade dos serviços em caso de falha de um dos componentes (servidores, redes, armazenamento).',1,0,'',NULL,'Admin','2025-01-28',0,1,1),(37,18,'Configuração de mecanismos de failover automatizado para garantir a continuidade do serviço em caso de falhas.','Implementar sistemas que automaticamente direcionam o tráfego para um sistema redundante em caso de falha do sistema principal, minimizando o tempo de inatividade.',1,0,'',NULL,'Admin','2025-01-28',0,1,1),(38,19,'Gestão e contole de versões ','Manter um histórico das diferentes versões de software e aplicações, permitindo reverter para versões anteriores em caso de problemas ou vulnerabilidades.',1,0,'',NULL,'Admin','2025-01-29',0,1,0),(39,20,'Balanceamento de Carga','Distribuir o tráfego de rede entre vários servidores para evitar sobrecarga em um único servidor e garantir a disponibilidade e o desempenho dos serviços.',1,0,'',NULL,'Admin','2025-01-29',0,0,1),(40,21,'Atualizações e Patches','Aplicar regularmente atualizações de segurança e patches para corrigir vulnerabilidades conhecidas em softwares e sistemas operacionais.',1,0,'',NULL,'Admin','2025-01-29',1,1,1),(41,22,'Treinamento de Segurança para Funcionários','Educar os funcionários sobre as melhores práticas de segurança da informação, como senhas fortes, phishing, engenharia social, etc.',1,0,'',NULL,'Admin','2025-01-29',1,1,1),(42,23,'Plano de Recuperação de Desastres','Documentar procedimentos para restaurar os sistemas e dados em caso de um desastre (incêndio, inundação, etc.), minimizando o tempo de inatividade e a perda de dados.',1,0,'',NULL,'Admin','2025-01-29',1,1,1),(43,24,'Contratos de Nível de Serviço (SLAs)','Acordos entre o provedor de serviços e o cliente que definem os níveis de serviço esperados, incluindo tempo de resposta a incidentes de segurança, tempo de inatividade permitido, etc.',1,0,'',NULL,'Admin','2025-01-29',0,0,1),(44,25,'Análise de Vulnerabilidades','Realizar testes e varreduras para identificar vulnerabilidades de segurança nos sistemas e aplicações, permitindo corrigi-las antes que sejam exploradas por invasores.',1,0,'',NULL,'Admin','2025-01-29',1,1,1),(45,26,'Gerenciamento de Incidentes e ameaças','Definir procedimentos para lidar com incidentes de segurança, desde a detecção até a resolução, incluindo a comunicação com as partes interessadas e a análise forense.',1,0,'',NULL,'Admin','2025-01-29',1,1,1);
/*!40000 ALTER TABLE `LGPD_2095_med_tec` ENABLE KEYS */;
-- UNLOCK TABLES;

--
-- Table structure for table `LGPD_2097_assoc_med_atv`
--

DROP TABLE IF EXISTS `LGPD_2097_assoc_med_atv`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `LGPD_2097_assoc_med_atv` (
  `id_med_tec_2095` int NOT NULL,
  `id_atv_2010` int NOT NULL,
  `especificação_2097` text,
  `id_assoc_2097` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`id_assoc_2097`)
) ENGINE=InnoDB AUTO_INCREMENT=16 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `LGPD_2097_assoc_med_atv`
--

-- LOCK TABLES `LGPD_2097_assoc_med_atv` WRITE;
/*!40000 ALTER TABLE `LGPD_2097_assoc_med_atv` DISABLE KEYS */;
/*!40000 ALTER TABLE `LGPD_2097_assoc_med_atv` ENABLE KEYS */;
-- UNLOCK TABLES;

--
-- Table structure for table `LGPD_2100_prz_aprv_proc`
--

DROP TABLE IF EXISTS `LGPD_2100_prz_aprv_proc`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `LGPD_2100_prz_aprv_proc` (
  `prz_dias_aprv_proc_2100` int DEFAULT NULL,
  `msg_env_aprv_2100` text,
  `id_controlador_1000` int DEFAULT NULL,
  `id_prz_2100` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`id_prz_2100`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `LGPD_2100_prz_aprv_proc`
--

-- LOCK TABLES `LGPD_2100_prz_aprv_proc` WRITE;
/*!40000 ALTER TABLE `LGPD_2100_prz_aprv_proc` DISABLE KEYS */;
/*!40000 ALTER TABLE `LGPD_2100_prz_aprv_proc` ENABLE KEYS */;
-- UNLOCK TABLES;

--
-- Table structure for table `LGPD_3000_riscos`
--

DROP TABLE IF EXISTS `LGPD_3000_riscos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `LGPD_3000_riscos` (
  `titulo_risc_3000` longtext,
  `det_risc_300` longtext,
  `dt_reg_risc_3000` date DEFAULT NULL,
  `id_status_risc_3000` int NOT NULL,
  `id_resp_risc_3000` int DEFAULT NULL,
  `id_clsf_gen_nivel_9999` int NOT NULL,
  `prob_risc_3000` int DEFAULT NULL,
  `crit_risc_3000` char(50) DEFAULT NULL,
  `id_tp_est_risc_3000` int NOT NULL,
  `dt_disparo_risc_3000` date DEFAULT NULL,
  `estrategia_risc_3000` text,
  `ação_disp_risc_3000` text,
  `id_categoria_risc_3000` int NOT NULL,
  `id_organograma_1050` int DEFAULT NULL,
  `id_risco_3000` int NOT NULL AUTO_INCREMENT,
  `id_controlador_1000` int DEFAULT NULL,
  `agent_verify_3000` tinyint(1) DEFAULT NULL,
  `personas_afet_3000` text,
  `fac_3000` int DEFAULT NULL,
  `risco_residual_3000` decimal(10,0) DEFAULT NULL,
  `user_insert_3000` varchar(45) DEFAULT NULL,
  `dt_insert_3000` date DEFAULT NULL,
  `user_update_3000` varchar(45) DEFAULT NULL,
  `dt_ult_update_3000` date DEFAULT NULL,
  PRIMARY KEY (`id_risco_3000`),
  KEY `fk_status_risc_3000` (`id_status_risc_3000`),
  KEY `fk_clsf_gen_nivel_9999` (`id_clsf_gen_nivel_9999`),
  KEY `fk_tp_est_risc_3000` (`id_tp_est_risc_3000`),
  KEY `fk_categoria_risc_3000` (`id_categoria_risc_3000`),
  CONSTRAINT `fk_categoria_risc_3000` FOREIGN KEY (`id_categoria_risc_3000`) REFERENCES `DOM_categoria_risc_3000` (`id_categoria_risc_3000`),
  CONSTRAINT `fk_clsf_gen_nivel_9999` FOREIGN KEY (`id_clsf_gen_nivel_9999`) REFERENCES `DOM_clsf_gen_nivel_9999` (`id_clsf_gen_nivel_9999`),
  CONSTRAINT `fk_status_risc_3000` FOREIGN KEY (`id_status_risc_3000`) REFERENCES `DOM_status_risc_3000` (`id_status_risc_3000`),
  CONSTRAINT `fk_tp_est_risc_3000` FOREIGN KEY (`id_tp_est_risc_3000`) REFERENCES `DOM_tp_est_risc_3000` (`id_tp_est_risc_3000`)
) ENGINE=InnoDB AUTO_INCREMENT=18 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `LGPD_3000_riscos`
--

-- LOCK TABLES `LGPD_3000_riscos` WRITE;
/*!40000 ALTER TABLE `LGPD_3000_riscos` DISABLE KEYS */;
/*!40000 ALTER TABLE `LGPD_3000_riscos` ENABLE KEYS */;
-- UNLOCK TABLES;

--
-- Table structure for table `LGPD_3100_assoc_risc_atv`
--

DROP TABLE IF EXISTS `LGPD_3100_assoc_risc_atv`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `LGPD_3100_assoc_risc_atv` (
  `id_risco_3000` int DEFAULT NULL,
  `id_atv_2010` int DEFAULT NULL,
  KEY `fki_fk_atv_2010` (`id_atv_2010`),
  KEY `fki_fk_risco_3100` (`id_risco_3000`),
  CONSTRAINT `fk_risco_3100` FOREIGN KEY (`id_risco_3000`) REFERENCES `LGPD_3000_riscos` (`id_risco_3000`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `LGPD_3100_assoc_risc_atv`
--

-- LOCK TABLES `LGPD_3100_assoc_risc_atv` WRITE;
/*!40000 ALTER TABLE `LGPD_3100_assoc_risc_atv` DISABLE KEYS */;
/*!40000 ALTER TABLE `LGPD_3100_assoc_risc_atv` ENABLE KEYS */;
-- UNLOCK TABLES;

--
-- Table structure for table `LGPD_3300_assoc_risc_prc`
--

DROP TABLE IF EXISTS `LGPD_3300_assoc_risc_prc`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `LGPD_3300_assoc_risc_prc` (
  `cod_prc_2000` int DEFAULT NULL,
  `id_risco_3000` int DEFAULT NULL,
  KEY `fki_fk_risco_3300` (`id_risco_3000`),
  KEY `fki_i` (`cod_prc_2000`),
  CONSTRAINT `fk_proc_3300` FOREIGN KEY (`cod_prc_2000`) REFERENCES `LGPD_2000_processos` (`cod_prc_2000`),
  CONSTRAINT `fk_risco_3300` FOREIGN KEY (`id_risco_3000`) REFERENCES `LGPD_3000_riscos` (`id_risco_3000`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `LGPD_3300_assoc_risc_prc`
--

-- LOCK TABLES `LGPD_3300_assoc_risc_prc` WRITE;
/*!40000 ALTER TABLE `LGPD_3300_assoc_risc_prc` DISABLE KEYS */;
/*!40000 ALTER TABLE `LGPD_3300_assoc_risc_prc` ENABLE KEYS */;
-- UNLOCK TABLES;

--
-- Table structure for table `LGPD_3400_assoc_risc_fin`
--

DROP TABLE IF EXISTS `LGPD_3400_assoc_risc_fin`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `LGPD_3400_assoc_risc_fin` (
  `id_risco_3000` int DEFAULT NULL,
  `cod_fin_2070` int DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `LGPD_3400_assoc_risc_fin`
--

-- LOCK TABLES `LGPD_3400_assoc_risc_fin` WRITE;
/*!40000 ALTER TABLE `LGPD_3400_assoc_risc_fin` DISABLE KEYS */;
/*!40000 ALTER TABLE `LGPD_3400_assoc_risc_fin` ENABLE KEYS */;
-- UNLOCK TABLES;

--
-- Table structure for table `LGPD_3450_assoc_risc_terc`
--

DROP TABLE IF EXISTS `LGPD_3450_assoc_risc_terc`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `LGPD_3450_assoc_risc_terc` (
  `id_risco_3000` int DEFAULT NULL,
  `id_terc_2090` int DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `LGPD_3450_assoc_risc_terc`
--

-- LOCK TABLES `LGPD_3450_assoc_risc_terc` WRITE;
/*!40000 ALTER TABLE `LGPD_3450_assoc_risc_terc` DISABLE KEYS */;
/*!40000 ALTER TABLE `LGPD_3450_assoc_risc_terc` ENABLE KEYS */;
-- UNLOCK TABLES;

--
-- Table structure for table `LGPD_3500_checklist_risk_padrao`
--

DROP TABLE IF EXISTS `LGPD_3500_checklist_risk_padrao`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `LGPD_3500_checklist_risk_padrao` (
  `id_chklst_risk_padrao_3500` int NOT NULL AUTO_INCREMENT,
  `id_analist_resp_chklst_3500` int NOT NULL COMMENT 'id do analista responsável pelo preenchimento do check list',
  `dt_ini_preench_chklst_3500` date DEFAULT NULL COMMENT 'data de inicio do preenchimento',
  `ind_fim_preench_chklst_3500` tinyint DEFAULT NULL COMMENT 'flag para indicar a finalização do preenchimento do check list',
  `dt_fim_preench_chklst_3500` date DEFAULT NULL COMMENT 'data em que foi finalizado o preenchimento do check list',
  `id_controlador_1000` int NOT NULL,
  PRIMARY KEY (`id_chklst_risk_padrao_3500`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `LGPD_3500_checklist_risk_padrao`
--

-- LOCK TABLES `LGPD_3500_checklist_risk_padrao` WRITE;
/*!40000 ALTER TABLE `LGPD_3500_checklist_risk_padrao` DISABLE KEYS */;
/*!40000 ALTER TABLE `LGPD_3500_checklist_risk_padrao` ENABLE KEYS */;
-- UNLOCK TABLES;

--
-- Table structure for table `LGPD_3510_form_chklist_risk_padrao`
--

DROP TABLE IF EXISTS `LGPD_3510_form_chklist_risk_padrao`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `LGPD_3510_form_chklist_risk_padrao` (
  `id_form_chklist_risk_padrao_3510` int NOT NULL AUTO_INCREMENT,
  `id_topico_3500` int NOT NULL,
  `questao_3510` varchar(450) DEFAULT NULL,
  `resposta_3510` longtext,
  `obs_3510` longtext,
  `ind_risk_gerado` tinyint DEFAULT NULL,
  `ind_ativ_gerada` tinyint DEFAULT NULL,
  `id_chklst_risk_padrao_3500` int DEFAULT NULL,
  PRIMARY KEY (`id_form_chklist_risk_padrao_3510`)
) ENGINE=InnoDB AUTO_INCREMENT=65 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci COMMENT='contem as questão do cheklist para riscos padrão. Tabela filha da LGPD_3500_checklist_risk_padrao';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `LGPD_3510_form_chklist_risk_padrao`
--

-- LOCK TABLES `LGPD_3510_form_chklist_risk_padrao` WRITE;
/*!40000 ALTER TABLE `LGPD_3510_form_chklist_risk_padrao` DISABLE KEYS */;
/*!40000 ALTER TABLE `LGPD_3510_form_chklist_risk_padrao` ENABLE KEYS */;
-- UNLOCK TABLES;

--
-- Table structure for table `LGPD_3600_chklst_risk_area_mestre`
--

DROP TABLE IF EXISTS `LGPD_3600_chklst_risk_area_mestre`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `LGPD_3600_chklst_risk_area_mestre` (
  `id_chklst_risk_padrao_3600` int NOT NULL AUTO_INCREMENT,
  `id_analist_resp_sol_chklst_3600` int DEFAULT NULL COMMENT 'id do analista responsável pela solicitação de preenchimento',
  `dt_ini_preench_chklst_3600` date DEFAULT NULL COMMENT 'data de inicio do preenchimento',
  `ind_fim_preench_chklst_3600` tinyint DEFAULT NULL COMMENT 'flag para indicar a finalização do preenchimento do check list',
  `dt_fim_preench_chklst_3600` date DEFAULT NULL COMMENT 'data em que foi finalizado o preenchimento do check list',
  `cod_pessoa_1100` int NOT NULL COMMENT 'responsável da área pelo preenchimento do check list',
  `id_organograma_1050` int NOT NULL,
  `id_controlador_1000` int NOT NULL,
  `token_chklst_3600` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`id_chklst_risk_padrao_3600`)
) ENGINE=InnoDB AUTO_INCREMENT=14 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `LGPD_3600_chklst_risk_area_mestre`
--

-- LOCK TABLES `LGPD_3600_chklst_risk_area_mestre` WRITE;
/*!40000 ALTER TABLE `LGPD_3600_chklst_risk_area_mestre` DISABLE KEYS */;
/*!40000 ALTER TABLE `LGPD_3600_chklst_risk_area_mestre` ENABLE KEYS */;
-- UNLOCK TABLES;

--
-- Table structure for table `LGPD_3610_model_chklst_area`
--

DROP TABLE IF EXISTS `LGPD_3610_model_chklst_area`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `LGPD_3610_model_chklst_area` (
  `id_3610_model_chklst_area` int NOT NULL AUTO_INCREMENT,
  `id_topico_3600` int DEFAULT NULL,
  `questao_3610` varchar(500) DEFAULT NULL,
  `id_tp_resposta_3700` int DEFAULT NULL,
  `ordem_quest_chklst_3610` int DEFAULT NULL,
  PRIMARY KEY (`id_3610_model_chklst_area`)
) ENGINE=InnoDB AUTO_INCREMENT=26 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `LGPD_3610_model_chklst_area`
--

-- LOCK TABLES `LGPD_3610_model_chklst_area` WRITE;
/*!40000 ALTER TABLE `LGPD_3610_model_chklst_area` DISABLE KEYS */;
INSERT INTO `LGPD_3610_model_chklst_area` VALUES (1,1,'Os sistemas que você usa para realizar suas atividades diárias permitem que cada usuário tenha acesso a uma parte do sistema ou todos os usuários tem acesso a todas as telas?',3,1),(2,1,'Os documentos físicos utilizados em seu departamento são armazenados (guardados) em local seguro? Se sim, explique na coluna \"Observações\"',1,2),(3,1,'O acesso a esses documentos físicos são monitorados (com o uso de câmeras, por exemplo)? Se sim, explique na coluna \"Observações\"',1,3),(4,2,'Você possui uma usuário e senha pessoal para acessar os sistemas que você faz uso para realizar suas atividades diárias?',1,4),(5,2,'Se você perder alguma de suas senhas, é possível recuperá-la? Se sim, como funciona esse procedimento (explique na coluna \"Observações\")?',1,5),(6,2,'As pessoas do seu departamento compartilham senhas para acesso aos sistemas?',1,6),(7,2,'É possível prever o valor de uma senha de um companheiro de trabalho por conta do padrão utilizado para criação dessa senha? Exemplo: O campo \"usuário\" sempre é o número da matrícula do colaborador, e a \"senha padrão\" é sempre o número do CPF...',1,7),(8,2,'As senhas cadastradas nos sistemas em uso são simples (como por exemplo: \"senha123\") ou são complexas, exigindo números e caracteres especiais, por exemplo?',4,8),(9,3,'Sempre que o time da unidade ou departamento faz uso de documentos físicos (impressos), é comum que as pessoas deixem esses documentos em cima de suas mesas quando se afastam das mesas?',1,9),(10,3,'As telas dos computadores utilizados pela unidade ou departamento são travadas automaticamente depois de um tempo sem uso do computador?',1,10),(11,3,'Documentos físicos são impressos em impressoras compartilhadas?',1,11),(12,3,'As impressoras compartilhadas do departamento ficam em um local visível e acessível por todos?',2,12),(13,4,'Os colaboradores utilizam desktops/notebooks individuais para o trabalho do dia a dia ou são compartilhados?',5,13),(14,4,'Os desktops/notebooks utilizados possuem algum tipo de criptografia de disco implementada?',1,14),(15,4,'Os colaboradores possuem acesso irrestrito aos servidor da entidade aonde os sistemas estão hospedados?',1,15),(16,5,'Os colaboradores fazem uso de dispositivos móveis particulares para executar suas rotinas de trabalho no departamento, como celulares, tablets, pen-drives, notebooks, HD externos, etc.?',1,16),(17,5,'Quando os colaboradores fazem uso de dispositivos móveis particulares, esses são integrados ou conectados à rede ou aos dispositivos físicos da entidade?',1,17),(18,5,'Os dispositivos móveis particulares utilizados possuem algum tipo de criptografia de proteção?',1,18),(19,6,'Documentos físicos ou eletrônicos do departamento são compartilhados com terceiros, de fora da entidade?',1,19),(20,6,'Quando documentos físicos ou eletrônicos são compartilhados com terceiros, isso se dá por solicitações formais e documentadas?',2,20),(21,6,'Documentos físicos ou eletrônicos são \"levados pra casa\" para terminar o trabalho de casa?',1,21),(22,6,'O time do departamento faz uso de endereços de e-mails pessoais ou corporativos para transferência de documentos eletrônicos interna ou externamente?',6,22),(23,7,'Quando os computadores do departamento são trocados ou levados para manutenção, há um processo prévio de eliminação de informações?',1,23),(24,7,'Os documentos físicos ou eletrônicos utilizados pelo departamento são, de alguma maneira, descartados/eliminados ou são guardados por tempo indeterminado?',7,24),(25,7,'Há algum procedimento formal para descarte de informações presentes em documentos físicos ou eletrônicos?',1,25);
/*!40000 ALTER TABLE `LGPD_3610_model_chklst_area` ENABLE KEYS */;
-- UNLOCK TABLES;

--
-- Table structure for table `LGPD_3620_chklst_area_resp`
--

DROP TABLE IF EXISTS `LGPD_3620_chklst_area_resp`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `LGPD_3620_chklst_area_resp` (
  `id_3620_chklst_area_resp` int NOT NULL AUTO_INCREMENT,
  `id_chklst_risk_padrao_3600` int DEFAULT NULL,
  `id_3610_model_chklst_area` int DEFAULT NULL,
  `resposta_3620` varchar(45) DEFAULT NULL,
  `ind_risk_ger_3620` tinyint DEFAULT '0',
  `ind_task_ger_3620` tinyint DEFAULT '0',
  `obs_chklst_3620` longtext,
  PRIMARY KEY (`id_3620_chklst_area_resp`)
) ENGINE=InnoDB AUTO_INCREMENT=126 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `LGPD_3620_chklst_area_resp`
--

-- LOCK TABLES `LGPD_3620_chklst_area_resp` WRITE;
/*!40000 ALTER TABLE `LGPD_3620_chklst_area_resp` DISABLE KEYS */;
/*!40000 ALTER TABLE `LGPD_3620_chklst_area_resp` ENABLE KEYS */;
-- UNLOCK TABLES;

--
-- Table structure for table `LGPD_3700_opt_resp_chklst_area`
--

DROP TABLE IF EXISTS `LGPD_3700_opt_resp_chklst_area`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `LGPD_3700_opt_resp_chklst_area` (
  `id_3700_opt_resp_chklst_area` int NOT NULL AUTO_INCREMENT,
  `id_resp_3700` int DEFAULT NULL,
  `opt_resp_3700` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`id_3700_opt_resp_chklst_area`)
) ENGINE=InnoDB AUTO_INCREMENT=17 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `LGPD_3700_opt_resp_chklst_area`
--

-- LOCK TABLES `LGPD_3700_opt_resp_chklst_area` WRITE;
/*!40000 ALTER TABLE `LGPD_3700_opt_resp_chklst_area` DISABLE KEYS */;
/*!40000 ALTER TABLE `LGPD_3700_opt_resp_chklst_area` ENABLE KEYS */;
-- UNLOCK TABLES;

--
-- Table structure for table `LGPD_3900_status_atividades`
--

DROP TABLE IF EXISTS `LGPD_3900_status_atividades`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `LGPD_3900_status_atividades` (
  `id_status_atv_3900` int NOT NULL AUTO_INCREMENT,
  `desc_status_atv_3900` char(100) NOT NULL,
  PRIMARY KEY (`id_status_atv_3900`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `LGPD_3900_status_atividades`
--

-- LOCK TABLES `LGPD_3900_status_atividades` WRITE;
/*!40000 ALTER TABLE `LGPD_3900_status_atividades` DISABLE KEYS */;
INSERT INTO `LGPD_3900_status_atividades` VALUES (1,'Planejada'),(2,'Em andamento'),(3,'Em revisão'),(4,'Pausada'),(5,'Finalizada');
/*!40000 ALTER TABLE `LGPD_3900_status_atividades` ENABLE KEYS */;
-- UNLOCK TABLES;

--
-- Table structure for table `LGPD_4000_atividades`
--

DROP TABLE IF EXISTS `LGPD_4000_atividades`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `LGPD_4000_atividades` (
  `id_atv_4000` int NOT NULL AUTO_INCREMENT,
  `desc_atv_4000` text NOT NULL,
  `resp_atv_4000` int NOT NULL,
  `id_status_atv_4000` int NOT NULL,
  `dt_ini_atv_4000` date DEFAULT NULL,
  `dt_fim_atv_4000` date DEFAULT NULL,
  `id_tp_disc_atv_4000` int NOT NULL,
  `etapa_rel_4000` text,
  `hr_ini_atv_4000` time DEFAULT NULL,
  `hr_fim_atv_400` time DEFAULT NULL,
  `id_controlador_1000` int DEFAULT NULL,
  `ger_asssitant_4000` tinyint(1) DEFAULT NULL,
  `titulo_atv_4000` varchar(255) NOT NULL,
  `reminder` varchar(255) DEFAULT NULL,
  `id_api` varchar(255) DEFAULT NULL,
  `id_event_google` varchar(255) DEFAULT NULL,
  `recur_info` varchar(255) DEFAULT NULL,
  `event_color` varchar(255) DEFAULT NULL,
  `creator` varchar(255) DEFAULT NULL,
  `id_tema_atv_4000` int DEFAULT NULL,
  `acompanhamento_atv_4000` text,
  `user_cad_atv_4000` varchar(255) DEFAULT NULL,
  `id_risco_3000` int DEFAULT NULL,
  PRIMARY KEY (`id_atv_4000`),
  KEY `fk_tp_disc_atv_4000` (`id_tp_disc_atv_4000`),
  KEY `fki_fk_id_resp_4000` (`resp_atv_4000`),
  KEY `fki_fk_id_status_4000` (`id_status_atv_4000`),
  CONSTRAINT `fk_id_status_4000` FOREIGN KEY (`id_status_atv_4000`) REFERENCES `LGPD_3900_status_atividades` (`id_status_atv_3900`),
  CONSTRAINT `fk_tp_disc_atv_4000` FOREIGN KEY (`id_tp_disc_atv_4000`) REFERENCES `DOM_tp_disc_atv_4000` (`id_tp_disc_atv_4000`)
) ENGINE=InnoDB AUTO_INCREMENT=33 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `LGPD_4000_atividades`
--

-- LOCK TABLES `LGPD_4000_atividades` WRITE;
/*!40000 ALTER TABLE `LGPD_4000_atividades` DISABLE KEYS */;
/*!40000 ALTER TABLE `LGPD_4000_atividades` ENABLE KEYS */;
-- UNLOCK TABLES;

--
-- Table structure for table `LGPD_4500_plano_acao`
--

DROP TABLE IF EXISTS `LGPD_4500_plano_acao`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `LGPD_4500_plano_acao` (
  `titulo_plan_4500` text NOT NULL,
  `dt_aprv_4500` date DEFAULT NULL,
  `dt_publ_4500` date DEFAULT NULL,
  `resp_plan_4500` int DEFAULT NULL,
  `obs_plan_4500` text,
  `id_plan_4500` int NOT NULL AUTO_INCREMENT,
  `id_controlador_1000` int DEFAULT NULL,
  `nm_anexo_4500` varchar(150) DEFAULT NULL,
  `ind_tp_pln_4500` varchar(15) DEFAULT NULL COMMENT '(Área) ou (Corporativo)',
  `id_organograma_1050` int DEFAULT NULL,
  PRIMARY KEY (`id_plan_4500`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `LGPD_4500_plano_acao`
--

-- LOCK TABLES `LGPD_4500_plano_acao` WRITE;
/*!40000 ALTER TABLE `LGPD_4500_plano_acao` DISABLE KEYS */;
/*!40000 ALTER TABLE `LGPD_4500_plano_acao` ENABLE KEYS */;
-- UNLOCK TABLES;

--
-- Table structure for table `LGPD_5000_cod_etica`
--

DROP TABLE IF EXISTS `LGPD_5000_cod_etica`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `LGPD_5000_cod_etica` (
  `id_cod_etica_5000` int NOT NULL AUTO_INCREMENT,
  `dt_pub_5000` date DEFAULT NULL,
  `resp_5000` int DEFAULT NULL,
  `versão_5000` char(50) DEFAULT NULL,
  `obs_5000` text,
  `resumo_etica_5000` text,
  `id_controlador_1000` int DEFAULT NULL,
  `anexo_5000` text,
  `titulo_cod_etica_5000` varchar(250) DEFAULT NULL,
  `nota_minima_aval_5000` int DEFAULT NULL,
  PRIMARY KEY (`id_cod_etica_5000`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `LGPD_5000_cod_etica`
--

-- LOCK TABLES `LGPD_5000_cod_etica` WRITE;
/*!40000 ALTER TABLE `LGPD_5000_cod_etica` DISABLE KEYS */;
/*!40000 ALTER TABLE `LGPD_5000_cod_etica` ENABLE KEYS */;
-- UNLOCK TABLES;

--
-- Table structure for table `LGPD_5001_env_cod`
--

DROP TABLE IF EXISTS `LGPD_5001_env_cod`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `LGPD_5001_env_cod` (
  `id_env_cod_5001` int NOT NULL AUTO_INCREMENT,
  `id_cod_etica_5000` int DEFAULT NULL,
  `cod_pessoa_1100` int DEFAULT NULL,
  `dt_env_5001` date DEFAULT NULL,
  `status_5001` varchar(45) DEFAULT NULL,
  `dt_ciencia_5001` date DEFAULT NULL,
  `token_5001` varchar(65) DEFAULT NULL,
  PRIMARY KEY (`id_env_cod_5001`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `LGPD_5001_env_cod`
--

-- LOCK TABLES `LGPD_5001_env_cod` WRITE;
/*!40000 ALTER TABLE `LGPD_5001_env_cod` DISABLE KEYS */;
/*!40000 ALTER TABLE `LGPD_5001_env_cod` ENABLE KEYS */;
-- UNLOCK TABLES;

--
-- Table structure for table `LGPD_5002_env_cod_terc`
--

DROP TABLE IF EXISTS `LGPD_5002_env_cod_terc`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `LGPD_5002_env_cod_terc` (
  `id_env_cod_terc_5002` int NOT NULL AUTO_INCREMENT,
  `id_cod_etica_5000` int DEFAULT NULL,
  `id_terc_2090` int DEFAULT NULL,
  `dt_env_5002` date DEFAULT NULL,
  `status_5002` varchar(45) DEFAULT NULL,
  `dt_ciencia_5002` date DEFAULT NULL,
  `token_5002` varchar(65) DEFAULT NULL,
  `dt_envio_quest_5002` date DEFAULT NULL,
  `quest_finalizado_5002` tinyint(1) DEFAULT '0',
  `dt_finaliza_quest_5002` date DEFAULT NULL,
  `ind_incui_quest_5002` tinyint(1) DEFAULT '0',
  `senha_quest_5002` varchar(100) DEFAULT NULL,
  `result_final_pesos_5002` int DEFAULT NULL,
  PRIMARY KEY (`id_env_cod_terc_5002`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `LGPD_5002_env_cod_terc`
--

-- LOCK TABLES `LGPD_5002_env_cod_terc` WRITE;
/*!40000 ALTER TABLE `LGPD_5002_env_cod_terc` DISABLE KEYS */;
/*!40000 ALTER TABLE `LGPD_5002_env_cod_terc` ENABLE KEYS */;
-- UNLOCK TABLES;

--
-- Table structure for table `LGPD_5003_quest_cod_etica`
--

DROP TABLE IF EXISTS `LGPD_5003_quest_cod_etica`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `LGPD_5003_quest_cod_etica` (
  `id_quest_cod_5003` int NOT NULL AUTO_INCREMENT,
  `id_cod_etica_5000` int NOT NULL,
  `questao_5003` text,
  `id_controlador_1000` int DEFAULT NULL,
  `id_tp_resp_5003` int DEFAULT NULL,
  `order_questao_5003` int DEFAULT NULL,
  `ind_ativa_5003` tinyint(1) DEFAULT NULL,
  `peso_resp_sim_5003` int DEFAULT '0',
  `peso_resp_nao_5003` int DEFAULT '0',
  PRIMARY KEY (`id_quest_cod_5003`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `LGPD_5003_quest_cod_etica`
--

-- LOCK TABLES `LGPD_5003_quest_cod_etica` WRITE;
/*!40000 ALTER TABLE `LGPD_5003_quest_cod_etica` DISABLE KEYS */;
/*!40000 ALTER TABLE `LGPD_5003_quest_cod_etica` ENABLE KEYS */;
-- UNLOCK TABLES;

--
-- Table structure for table `LGPD_5004_opt_quest_cod_etica`
--

DROP TABLE IF EXISTS `LGPD_5004_opt_quest_cod_etica`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `LGPD_5004_opt_quest_cod_etica` (
  `id_opt_quest_cod_5004` int NOT NULL AUTO_INCREMENT,
  `id_quest_cod_5003` int NOT NULL,
  `opcao_5004` text,
  `id_controlador_1000` int DEFAULT NULL,
  `peso_5004` int DEFAULT NULL,
  PRIMARY KEY (`id_opt_quest_cod_5004`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `LGPD_5004_opt_quest_cod_etica`
--

-- LOCK TABLES `LGPD_5004_opt_quest_cod_etica` WRITE;
/*!40000 ALTER TABLE `LGPD_5004_opt_quest_cod_etica` DISABLE KEYS */;
/*!40000 ALTER TABLE `LGPD_5004_opt_quest_cod_etica` ENABLE KEYS */;
-- UNLOCK TABLES;

--
-- Table structure for table `LGPD_5005_resp_quest_cod_etica`
--

DROP TABLE IF EXISTS `LGPD_5005_resp_quest_cod_etica`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `LGPD_5005_resp_quest_cod_etica` (
  `id_resp_quest_cod_5005` int NOT NULL AUTO_INCREMENT,
  `id_env_cod_terc_5002` int NOT NULL,
  `resposta_5005` text,
  `id_quest_cod_5003` int DEFAULT NULL,
  `questao_5005` text CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci,
  `id_tp_resp_5005` int DEFAULT NULL,
  `order_questao_5005` int DEFAULT NULL,
  `peso_5005` int DEFAULT NULL,
  PRIMARY KEY (`id_resp_quest_cod_5005`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `LGPD_5005_resp_quest_cod_etica`
--

-- LOCK TABLES `LGPD_5005_resp_quest_cod_etica` WRITE;
/*!40000 ALTER TABLE `LGPD_5005_resp_quest_cod_etica` DISABLE KEYS */;
/*!40000 ALTER TABLE `LGPD_5005_resp_quest_cod_etica` ENABLE KEYS */;
-- UNLOCK TABLES;

--
-- Table structure for table `LGPD_5100_cod_conduta`
--

DROP TABLE IF EXISTS `LGPD_5100_cod_conduta`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `LGPD_5100_cod_conduta` (
  `id_cod_cond_5100` int NOT NULL AUTO_INCREMENT,
  `dt_pub_5100` date DEFAULT NULL,
  `resp_5100` int DEFAULT NULL,
  `versão_5100` char(50) DEFAULT NULL,
  `obs_5100` text,
  `resumo_conduta_5100` text,
  `id_controlador_1000` int DEFAULT NULL,
  `anexo_5100` text,
  PRIMARY KEY (`id_cod_cond_5100`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `LGPD_5100_cod_conduta`
--

-- LOCK TABLES `LGPD_5100_cod_conduta` WRITE;
/*!40000 ALTER TABLE `LGPD_5100_cod_conduta` DISABLE KEYS */;
/*!40000 ALTER TABLE `LGPD_5100_cod_conduta` ENABLE KEYS */;
-- UNLOCK TABLES;

--
-- Table structure for table `LGPD_6000_PDCA`
--

DROP TABLE IF EXISTS `LGPD_6000_PDCA`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `LGPD_6000_PDCA` (
  `id_pdca_6000` int NOT NULL AUTO_INCREMENT,
  `resp_pdca_6000` int DEFAULT NULL,
  `dt_ini_pdca_6000` date DEFAULT NULL,
  `dt_fim_pdca_6000` date DEFAULT NULL,
  `efetuar_treina_6000` tinyint(1) DEFAULT NULL,
  `revisar_cod_conduta_6000` tinyint(1) DEFAULT NULL,
  `revisar_cod_etica_6000` tinyint(1) DEFAULT NULL,
  `apont_pol_6000` text,
  `apont_conduta_6000` text,
  `apont_etica_6000` text,
  `apont_risco_6000` text,
  `apont_contrato_6000` text,
  `apont_proc_6000` text,
  `detalhamento_pdca_6000` text,
  `id_status_pdca_6000` int NOT NULL,
  `id_controlador_1000` int DEFAULT NULL,
  `apont_medtec_6000` text,
  PRIMARY KEY (`id_pdca_6000`),
  KEY `fk_status_pdca_6000` (`id_status_pdca_6000`),
  CONSTRAINT `fk_status_pdca_6000` FOREIGN KEY (`id_status_pdca_6000`) REFERENCES `DOM_status_pdca_6000` (`id_status_pdca_6000`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `LGPD_6000_PDCA`
--

-- LOCK TABLES `LGPD_6000_PDCA` WRITE;
/*!40000 ALTER TABLE `LGPD_6000_PDCA` DISABLE KEYS */;
/*!40000 ALTER TABLE `LGPD_6000_PDCA` ENABLE KEYS */;
-- UNLOCK TABLES;

--
-- Table structure for table `LGPD_6100_catalog_treinamentos`
--

DROP TABLE IF EXISTS `LGPD_6100_catalog_treinamentos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `LGPD_6100_catalog_treinamentos` (
  `id_treina_6000` int NOT NULL AUTO_INCREMENT,
  `titulo_treina_6000` text,
  `desc_treina_6000` text,
  `id_controlador_1000` int DEFAULT NULL,
  `conteudo_prog_6100` text,
  `anexo1_6100` varchar(250) DEFAULT NULL,
  `anexo2_6100` varchar(250) DEFAULT NULL,
  `anexo3_6100` varchar(250) DEFAULT NULL,
  PRIMARY KEY (`id_treina_6000`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `LGPD_6100_catalog_treinamentos`
--

-- LOCK TABLES `LGPD_6100_catalog_treinamentos` WRITE;
/*!40000 ALTER TABLE `LGPD_6100_catalog_treinamentos` DISABLE KEYS */;
/*!40000 ALTER TABLE `LGPD_6100_catalog_treinamentos` ENABLE KEYS */;
-- UNLOCK TABLES;

--
-- Table structure for table `LGPD_6200_agenda_treina`
--

DROP TABLE IF EXISTS `LGPD_6200_agenda_treina`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `LGPD_6200_agenda_treina` (
  `id_agenda_triena_6200` int NOT NULL AUTO_INCREMENT,
  `id_treina_6000` int DEFAULT NULL,
  `data_inicio_6200` date DEFAULT NULL,
  `data_termino_6200` date DEFAULT NULL,
  `instrutor_6200` int DEFAULT NULL,
  `id_controlador_1000` int DEFAULT NULL,
  PRIMARY KEY (`id_agenda_triena_6200`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `LGPD_6200_agenda_treina`
--

-- LOCK TABLES `LGPD_6200_agenda_treina` WRITE;
/*!40000 ALTER TABLE `LGPD_6200_agenda_treina` DISABLE KEYS */;
/*!40000 ALTER TABLE `LGPD_6200_agenda_treina` ENABLE KEYS */;
-- UNLOCK TABLES;

--
-- Table structure for table `LGPD_6300_aluno_treina`
--

DROP TABLE IF EXISTS `LGPD_6300_aluno_treina`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `LGPD_6300_aluno_treina` (
  `id_6300_aluno_treina` int NOT NULL AUTO_INCREMENT,
  `id_agenda_treina_6200` int NOT NULL,
  `cod_pessoa_1100` int NOT NULL,
  PRIMARY KEY (`id_6300_aluno_treina`)
) ENGINE=InnoDB AUTO_INCREMENT=19 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `LGPD_6300_aluno_treina`
--

-- LOCK TABLES `LGPD_6300_aluno_treina` WRITE;
/*!40000 ALTER TABLE `LGPD_6300_aluno_treina` DISABLE KEYS */;
/*!40000 ALTER TABLE `LGPD_6300_aluno_treina` ENABLE KEYS */;
-- UNLOCK TABLES;

--
-- Table structure for table `LGPD_6500_assoc_treina_pdca`
--

DROP TABLE IF EXISTS `LGPD_6500_assoc_treina_pdca`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `LGPD_6500_assoc_treina_pdca` (
  `id_treina_6000` int DEFAULT NULL,
  `id_pdca_6000` int DEFAULT NULL,
  `ministrar_triena_6500` tinyint(1) DEFAULT NULL,
  `instrutor_6500` int DEFAULT NULL,
  `dt_ini_treina_6500` date DEFAULT NULL,
  `dt_fim_treina_6500` date DEFAULT NULL,
  `finalizado_triena_6500` tinyint(1) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `LGPD_6500_assoc_treina_pdca`
--

-- LOCK TABLES `LGPD_6500_assoc_treina_pdca` WRITE;
/*!40000 ALTER TABLE `LGPD_6500_assoc_treina_pdca` DISABLE KEYS */;
/*!40000 ALTER TABLE `LGPD_6500_assoc_treina_pdca` ENABLE KEYS */;
-- UNLOCK TABLES;

--
-- Table structure for table `LGPD_7050_sessao_aval_forne`
--

DROP TABLE IF EXISTS `LGPD_7050_sessao_aval_forne`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `LGPD_7050_sessao_aval_forne` (
  `id_sessao_aval_forne_7050` int NOT NULL AUTO_INCREMENT,
  `titulo_sessao_7050` varchar(50) NOT NULL,
  `desc_sessao_7050` varchar(400) DEFAULT NULL,
  `ordem_sessao_7050` int DEFAULT NULL,
  `id_controlador_1000` int NOT NULL,
  `id_7000` int NOT NULL,
  `ind_ativa_7050` tinyint DEFAULT '1',
  `ind_secao_interna_7050` tinyint DEFAULT '0',
  PRIMARY KEY (`id_sessao_aval_forne_7050`),
  KEY `fk_id_controlador` (`id_controlador_1000`),
  KEY `fk_config_mestre_aval_id_7000` (`id_7000`),
  CONSTRAINT `fk_config_mestre_aval_id_7000` FOREIGN KEY (`id_7000`) REFERENCES `LGPD_config_mestre_avaliação_7000` (`id_7000`),
  CONSTRAINT `fk_id_controlador` FOREIGN KEY (`id_controlador_1000`) REFERENCES `LGPD_1000_controlador` (`id_controlador_1000`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `LGPD_7050_sessao_aval_forne`
--

-- LOCK TABLES `LGPD_7050_sessao_aval_forne` WRITE;
/*!40000 ALTER TABLE `LGPD_7050_sessao_aval_forne` DISABLE KEYS */;
/*!40000 ALTER TABLE `LGPD_7050_sessao_aval_forne` ENABLE KEYS */;
-- UNLOCK TABLES;

--
-- Table structure for table `LGPD_7300_envio_aval_forne`
--

DROP TABLE IF EXISTS `LGPD_7300_envio_aval_forne`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `LGPD_7300_envio_aval_forne` (
  `id_envio_7300` int NOT NULL AUTO_INCREMENT,
  `id_terc_2090` int DEFAULT NULL,
  `id_7000` int DEFAULT NULL,
  `dt_envio_7300` date DEFAULT NULL,
  `finalizado_7300` tinyint(1) DEFAULT NULL,
  `dt_finaliza_7300` date DEFAULT NULL,
  `senha_7300` char(15) DEFAULT NULL,
  `id_controlador_1000` int NOT NULL,
  `analisado_7300` tinyint DEFAULT NULL,
  `risco_gerado_7300` tinyint DEFAULT NULL,
  `dt_geracao_7300` date DEFAULT NULL,
  `ind_aval_env_7300` tinyint DEFAULT NULL,
  `ind_prosseguiu_form_7300` tinyint NOT NULL DEFAULT '0',
  `ind_secao_interna_7300` tinyint DEFAULT '0',
  `ind_secao_interna_finalizada_7300` tinyint DEFAULT NULL,
  `resultado_aval_env_7300` varchar(45) DEFAULT NULL,
  `dt_analise_final_7300` date DEFAULT NULL,
  `secao_atual` int NOT NULL DEFAULT '1',
  `concl_aval_final_7300` longtext,
  `criticidade_aval_7300` varchar(38) DEFAULT NULL,
  `dt_exp_aval_7300` date DEFAULT NULL,
  `ind_not_exp_preenc_aval_7300` tinyint DEFAULT '0',
  `ind_exp_sla_aval_7300` tinyint(1) DEFAULT '0',
  PRIMARY KEY (`id_envio_7300`)
) ENGINE=InnoDB AUTO_INCREMENT=16 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `LGPD_7300_envio_aval_forne`
--

-- LOCK TABLES `LGPD_7300_envio_aval_forne` WRITE;
/*!40000 ALTER TABLE `LGPD_7300_envio_aval_forne` DISABLE KEYS */;
/*!40000 ALTER TABLE `LGPD_7300_envio_aval_forne` ENABLE KEYS */;
-- UNLOCK TABLES;

--
-- Table structure for table `LGPD_7400_resp_aval_forne`
--

DROP TABLE IF EXISTS `LGPD_7400_resp_aval_forne`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `LGPD_7400_resp_aval_forne` (
  `id_envio_7300` int DEFAULT NULL,
  `id_7100` int DEFAULT NULL,
  `resposta_7400` text,
  `nivel_risk_analise_7400` varchar(45) DEFAULT NULL,
  `existe_risco_analise_7400` varchar(45) DEFAULT NULL,
  `just_analise_7400` longtext,
  `anexo_comprov_7400` varchar(250) DEFAULT NULL,
  `coment_resp_7400` longtext,
  `nota_peso_7400` int DEFAULT NULL COMMENT 'nota do peso atingido através da resposta enviada',
  `id_7400` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`id_7400`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `LGPD_7400_resp_aval_forne`
--

-- LOCK TABLES `LGPD_7400_resp_aval_forne` WRITE;
/*!40000 ALTER TABLE `LGPD_7400_resp_aval_forne` DISABLE KEYS */;
/*!40000 ALTER TABLE `LGPD_7400_resp_aval_forne` ENABLE KEYS */;
-- UNLOCK TABLES;

--
-- Table structure for table `LGPD_7500_config_peso_quest_txt`
--

DROP TABLE IF EXISTS `LGPD_7500_config_peso_quest_txt`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `LGPD_7500_config_peso_quest_txt` (
  `id_config_peso_quest_txt_7500` int NOT NULL AUTO_INCREMENT,
  `desc_aval_quest_txt_7500` longtext,
  `peso_aval_quest_txt_7500` int DEFAULT NULL,
  `id_controlador_1000` int DEFAULT NULL,
  PRIMARY KEY (`id_config_peso_quest_txt_7500`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `LGPD_7500_config_peso_quest_txt`
--

-- LOCK TABLES `LGPD_7500_config_peso_quest_txt` WRITE;
/*!40000 ALTER TABLE `LGPD_7500_config_peso_quest_txt` DISABLE KEYS */;
/*!40000 ALTER TABLE `LGPD_7500_config_peso_quest_txt` ENABLE KEYS */;
-- UNLOCK TABLES;

--
-- Table structure for table `LGPD_7600_range_risk_ddp`
--

DROP TABLE IF EXISTS `LGPD_7600_range_risk_ddp`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `LGPD_7600_range_risk_ddp` (
  `id_range_risk_ddp_7600` int NOT NULL AUTO_INCREMENT,
  `id_7000` int DEFAULT NULL,
  `ind_niv_baixa_ini` int DEFAULT NULL,
  `ind_niv_baixa_fim` int DEFAULT NULL,
  `ind_niv_moderada_ini` int DEFAULT NULL,
  `ind_niv_moderada_fim` int DEFAULT NULL,
  `ind_niv_alta_ini` int DEFAULT NULL,
  `ind_niv_alta_fim` int DEFAULT NULL,
  `ind_niv_urgente_ini` int DEFAULT NULL,
  `ind_niv_iurgente_fim` int DEFAULT NULL,
  `notifica_alerta_baixa` tinyint DEFAULT NULL,
  `notifica_alerta_moderada` tinyint DEFAULT NULL,
  `notifica_alerta_alta` tinyint DEFAULT NULL,
  `notifica_alerta_urgente` tinyint DEFAULT NULL,
  `cod_pessoa_alerta_baixa` varchar(1000) DEFAULT NULL,
  `cod_pessoa_alerta_moderada` varchar(1000) DEFAULT NULL,
  `cod_pessoa_alerta_alta` varchar(1000) DEFAULT NULL,
  `cod_pessoa_alerta_urgente` varchar(1000) DEFAULT NULL,
  PRIMARY KEY (`id_range_risk_ddp_7600`)
) ENGINE=InnoDB AUTO_INCREMENT=31 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci COMMENT='Tabela de configuraçã de range de risco com base no peso avaliado pelo DDP';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `LGPD_7600_range_risk_ddp`
--

-- LOCK TABLES `LGPD_7600_range_risk_ddp` WRITE;
/*!40000 ALTER TABLE `LGPD_7600_range_risk_ddp` DISABLE KEYS */;
/*!40000 ALTER TABLE `LGPD_7600_range_risk_ddp` ENABLE KEYS */;
-- UNLOCK TABLES;

--
-- Table structure for table `LGPD_7700_config_aval_validade`
--

DROP TABLE IF EXISTS `LGPD_7700_config_aval_validade`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `LGPD_7700_config_aval_validade` (
  `id_controlador_1000` int NOT NULL,
  `validade_aval_meses_7700` int NOT NULL,
  PRIMARY KEY (`id_controlador_1000`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `LGPD_7700_config_aval_validade`
--

-- LOCK TABLES `LGPD_7700_config_aval_validade` WRITE;
/*!40000 ALTER TABLE `LGPD_7700_config_aval_validade` DISABLE KEYS */;
/*!40000 ALTER TABLE `LGPD_7700_config_aval_validade` ENABLE KEYS */;
-- UNLOCK TABLES;

--
-- Table structure for table `LGPD_9000_anexos`
--

DROP TABLE IF EXISTS `LGPD_9000_anexos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `LGPD_9000_anexos` (
  `fileid` int DEFAULT NULL,
  `userid` int DEFAULT NULL,
  `filename` text,
  `filetype` char(10) DEFAULT NULL,
  `cod_prc_2000` int DEFAULT NULL,
  `binaryvalue` blob
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `LGPD_9000_anexos`
--

-- LOCK TABLES `LGPD_9000_anexos` WRITE;
/*!40000 ALTER TABLE `LGPD_9000_anexos` DISABLE KEYS */;
/*!40000 ALTER TABLE `LGPD_9000_anexos` ENABLE KEYS */;
-- UNLOCK TABLES;

--
-- Table structure for table `LGPD_9001_anexos_pol`
--

DROP TABLE IF EXISTS `LGPD_9001_anexos_pol`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `LGPD_9001_anexos_pol` (
  `fileid` int DEFAULT NULL,
  `userid` int DEFAULT NULL,
  `filename` text,
  `filetype` char(10) DEFAULT NULL,
  `cod_politica` int DEFAULT NULL,
  `filebynari` blob
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `LGPD_9001_anexos_pol`
--

-- LOCK TABLES `LGPD_9001_anexos_pol` WRITE;
/*!40000 ALTER TABLE `LGPD_9001_anexos_pol` DISABLE KEYS */;
/*!40000 ALTER TABLE `LGPD_9001_anexos_pol` ENABLE KEYS */;
-- UNLOCK TABLES;

--
-- Table structure for table `LGPD_999_assoc_eqp_org`
--

DROP TABLE IF EXISTS `LGPD_999_assoc_eqp_org`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `LGPD_999_assoc_eqp_org` (
  `cod_pessoa_1100` int DEFAULT NULL,
  `id_organograma` int DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `LGPD_999_assoc_eqp_org`
--

-- LOCK TABLES `LGPD_999_assoc_eqp_org` WRITE;
/*!40000 ALTER TABLE `LGPD_999_assoc_eqp_org` DISABLE KEYS */;
/*!40000 ALTER TABLE `LGPD_999_assoc_eqp_org` ENABLE KEYS */;
-- UNLOCK TABLES;

--
-- Table structure for table `LGPD_analise_det_aprv_7400`
--

DROP TABLE IF EXISTS `LGPD_analise_det_aprv_7400`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `LGPD_analise_det_aprv_7400` (
  `id_7400` int NOT NULL AUTO_INCREMENT,
  `id_env_7300` int NOT NULL,
  `id_config_det_aprv_7300` int NOT NULL,
  `result_7400` varchar(10) DEFAULT NULL,
  `coment_7400` longtext,
  `date_analise_7400` date DEFAULT NULL,
  PRIMARY KEY (`id_7400`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci COMMENT='contém a relação das áreas e responsáveis pela analise de um formulário due diligence';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `LGPD_analise_det_aprv_7400`
--

-- LOCK TABLES `LGPD_analise_det_aprv_7400` WRITE;
/*!40000 ALTER TABLE `LGPD_analise_det_aprv_7400` DISABLE KEYS */;
/*!40000 ALTER TABLE `LGPD_analise_det_aprv_7400` ENABLE KEYS */;
-- UNLOCK TABLES;

--
-- Table structure for table `LGPD_assoc_pdca_contr_6500`
--

DROP TABLE IF EXISTS `LGPD_assoc_pdca_contr_6500`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `LGPD_assoc_pdca_contr_6500` (
  `id_contrato_3500` int DEFAULT NULL,
  `id_pdca_6000` int DEFAULT NULL,
  `data_ini_rev_6500` date DEFAULT NULL,
  `data_fim_rev_6500` date DEFAULT NULL,
  `resp_rev_6500` int DEFAULT NULL,
  `id_status_6500` int NOT NULL,
  `det_rev_contr_6500` varchar(250) DEFAULT NULL,
  KEY `fk_status_6500` (`id_status_6500`),
  CONSTRAINT `fk_status_6500` FOREIGN KEY (`id_status_6500`) REFERENCES `DOM_status_6500` (`id_status_6500`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `LGPD_assoc_pdca_contr_6500`
--

-- LOCK TABLES `LGPD_assoc_pdca_contr_6500` WRITE;
/*!40000 ALTER TABLE `LGPD_assoc_pdca_contr_6500` DISABLE KEYS */;
/*!40000 ALTER TABLE `LGPD_assoc_pdca_contr_6500` ENABLE KEYS */;
-- UNLOCK TABLES;

--
-- Table structure for table `LGPD_assoc_pdca_medtec_6700`
--

DROP TABLE IF EXISTS `LGPD_assoc_pdca_medtec_6700`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `LGPD_assoc_pdca_medtec_6700` (
  `id_pdca_6000` int DEFAULT NULL,
  `id_med_tec_2095` int DEFAULT NULL,
  `data_ini_rev_6700` date DEFAULT NULL,
  `data_fim_rev_6700` date DEFAULT NULL,
  `resp_rev_6700` int DEFAULT NULL,
  `id_status_6500` int NOT NULL,
  `det_rev_medtec_6700` varchar(250) DEFAULT NULL,
  KEY `fk_status_6500_2` (`id_status_6500`),
  CONSTRAINT `fk_status_6500_2` FOREIGN KEY (`id_status_6500`) REFERENCES `DOM_status_6500` (`id_status_6500`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `LGPD_assoc_pdca_medtec_6700`
--

-- LOCK TABLES `LGPD_assoc_pdca_medtec_6700` WRITE;
/*!40000 ALTER TABLE `LGPD_assoc_pdca_medtec_6700` DISABLE KEYS */;
/*!40000 ALTER TABLE `LGPD_assoc_pdca_medtec_6700` ENABLE KEYS */;
-- UNLOCK TABLES;

--
-- Table structure for table `LGPD_assoc_pdca_pol_6300`
--

DROP TABLE IF EXISTS `LGPD_assoc_pdca_pol_6300`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `LGPD_assoc_pdca_pol_6300` (
  `id_politica_2080` int DEFAULT NULL,
  `id_pdca_6000` int DEFAULT NULL,
  `data_ini_rev_6300` date DEFAULT NULL,
  `data_fim_rev_6300` date DEFAULT NULL,
  `resp_rev_6300` int DEFAULT NULL,
  `id_status_6500` int NOT NULL,
  `det_rev_pol_6300` varchar(250) DEFAULT NULL,
  KEY `fk_status_6500_3` (`id_status_6500`),
  CONSTRAINT `fk_status_6500_3` FOREIGN KEY (`id_status_6500`) REFERENCES `DOM_status_6500` (`id_status_6500`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `LGPD_assoc_pdca_pol_6300`
--

-- LOCK TABLES `LGPD_assoc_pdca_pol_6300` WRITE;
/*!40000 ALTER TABLE `LGPD_assoc_pdca_pol_6300` DISABLE KEYS */;
/*!40000 ALTER TABLE `LGPD_assoc_pdca_pol_6300` ENABLE KEYS */;
-- UNLOCK TABLES;

--
-- Table structure for table `LGPD_assoc_pdca_proc_6600`
--

DROP TABLE IF EXISTS `LGPD_assoc_pdca_proc_6600`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `LGPD_assoc_pdca_proc_6600` (
  `cod_prc_2000` int DEFAULT NULL,
  `id_pdca_6000` int DEFAULT NULL,
  `data_ini_rev_6600` date DEFAULT NULL,
  `data_fim_rev_6600` date DEFAULT NULL,
  `resp_rev_6600` int DEFAULT NULL,
  `id_status_6500` int NOT NULL,
  `det_rev_proc_6600` varchar(250) DEFAULT NULL,
  KEY `fk_status_6500_4` (`id_status_6500`),
  CONSTRAINT `fk_status_6500_4` FOREIGN KEY (`id_status_6500`) REFERENCES `DOM_status_6500` (`id_status_6500`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `LGPD_assoc_pdca_proc_6600`
--

-- LOCK TABLES `LGPD_assoc_pdca_proc_6600` WRITE;
/*!40000 ALTER TABLE `LGPD_assoc_pdca_proc_6600` DISABLE KEYS */;
/*!40000 ALTER TABLE `LGPD_assoc_pdca_proc_6600` ENABLE KEYS */;
-- UNLOCK TABLES;

--
-- Table structure for table `LGPD_assoc_pdca_risk_6400`
--

DROP TABLE IF EXISTS `LGPD_assoc_pdca_risk_6400`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `LGPD_assoc_pdca_risk_6400` (
  `id_risco_3000` int DEFAULT NULL,
  `id_pdca_6000` int DEFAULT NULL,
  `data_ini_rev_6400` date DEFAULT NULL,
  `data_fim_rev_6400` date DEFAULT NULL,
  `resp_rev_6400` int DEFAULT NULL,
  `id_status_6500` int NOT NULL,
  `det_rev_risk_6400` varchar(250) DEFAULT NULL,
  KEY `fk_status_6500_5` (`id_status_6500`),
  CONSTRAINT `fk_status_6500_5` FOREIGN KEY (`id_status_6500`) REFERENCES `DOM_status_6500` (`id_status_6500`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `LGPD_assoc_pdca_risk_6400`
--

-- LOCK TABLES `LGPD_assoc_pdca_risk_6400` WRITE;
/*!40000 ALTER TABLE `LGPD_assoc_pdca_risk_6400` DISABLE KEYS */;
/*!40000 ALTER TABLE `LGPD_assoc_pdca_risk_6400` ENABLE KEYS */;
-- UNLOCK TABLES;

--
-- Table structure for table `LGPD_config_det_aprv_7300`
--

DROP TABLE IF EXISTS `LGPD_config_det_aprv_7300`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `LGPD_config_det_aprv_7300` (
  `id_config_det_aprv_7300` int NOT NULL AUTO_INCREMENT,
  `id_7000` int NOT NULL,
  `id_organograma_1050` int NOT NULL,
  `cod_pessoa_1100` int NOT NULL,
  PRIMARY KEY (`id_config_det_aprv_7300`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci COMMENT='contém a relação das áreas e responsáveis pela analise de um formulário due diligence';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `LGPD_config_det_aprv_7300`
--

-- LOCK TABLES `LGPD_config_det_aprv_7300` WRITE;
/*!40000 ALTER TABLE `LGPD_config_det_aprv_7300` DISABLE KEYS */;
/*!40000 ALTER TABLE `LGPD_config_det_aprv_7300` ENABLE KEYS */;
-- UNLOCK TABLES;

--
-- Table structure for table `LGPD_config_det_avaliacao_7100`
--

DROP TABLE IF EXISTS `LGPD_config_det_avaliacao_7100`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `LGPD_config_det_avaliacao_7100` (
  `id_7100` int NOT NULL AUTO_INCREMENT,
  `id_7000` int DEFAULT NULL,
  `questao_7100` text,
  `id_controlador_1000` int DEFAULT NULL,
  `id_tp_resp_7100` int NOT NULL,
  `exige_prova_anexo_7100` tinyint DEFAULT NULL,
  `exige_justificativa_7100` tinyint DEFAULT '0',
  `anexo_prova_7100` varchar(250) DEFAULT NULL,
  `instr_questao_7100` varchar(400) DEFAULT NULL,
  `id_sessao_aval_forne_7050` int DEFAULT NULL,
  `order_questao_7100` int DEFAULT NULL,
  `ind_ativa_7100` tinyint DEFAULT '1' COMMENT 'Indica se a questão esta ativa para novos formulários ',
  `ind_questao_obrigatoria_7100` tinyint DEFAULT '0',
  `peso_resp_sim_7100` int DEFAULT '0' COMMENT 'peso para quando a resposta for do tipo sim/não e a resposta for = ''sim''',
  `peso_resp_nao_7100` int DEFAULT '0' COMMENT 'peso para quando a resposta for do tipo sim/não e a resposta for = ''nao''',
  PRIMARY KEY (`id_7100`),
  KEY `fk_tp_resp_7100` (`id_tp_resp_7100`),
  KEY `fk_id_sessao_aval_forne_7050` (`id_sessao_aval_forne_7050`),
  CONSTRAINT `fk_id_sessao_aval_forne_7050` FOREIGN KEY (`id_sessao_aval_forne_7050`) REFERENCES `LGPD_7050_sessao_aval_forne` (`id_sessao_aval_forne_7050`),
  CONSTRAINT `fk_tp_resp_7100` FOREIGN KEY (`id_tp_resp_7100`) REFERENCES `DOM_tp_resp_7100` (`id_tp_resp_7100`)
) ENGINE=InnoDB AUTO_INCREMENT=16 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `LGPD_config_det_avaliacao_7100`
--

-- LOCK TABLES `LGPD_config_det_avaliacao_7100` WRITE;
/*!40000 ALTER TABLE `LGPD_config_det_avaliacao_7100` DISABLE KEYS */;
/*!40000 ALTER TABLE `LGPD_config_det_avaliacao_7100` ENABLE KEYS */;
-- UNLOCK TABLES;

--
-- Table structure for table `LGPD_config_det_opt_7200`
--

DROP TABLE IF EXISTS `LGPD_config_det_opt_7200`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `LGPD_config_det_opt_7200` (
  `id_7200` int NOT NULL AUTO_INCREMENT,
  `id_7100` int DEFAULT NULL,
  `opção_7200` text,
  `id_controlador_1000` int DEFAULT NULL,
  `peso_7200` int DEFAULT NULL COMMENT 'peso da alternativa para avaliação',
  PRIMARY KEY (`id_7200`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `LGPD_config_det_opt_7200`
--

-- LOCK TABLES `LGPD_config_det_opt_7200` WRITE;
/*!40000 ALTER TABLE `LGPD_config_det_opt_7200` DISABLE KEYS */;
/*!40000 ALTER TABLE `LGPD_config_det_opt_7200` ENABLE KEYS */;
-- UNLOCK TABLES;

--
-- Table structure for table `LGPD_config_mestre_avaliação_7000`
--

DROP TABLE IF EXISTS `LGPD_config_mestre_avaliação_7000`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `LGPD_config_mestre_avaliação_7000` (
  `id_7000` int NOT NULL AUTO_INCREMENT,
  `id_controlador_1000` int DEFAULT NULL,
  `id_classif_terc_2090` int NOT NULL,
  `versao_7000` int DEFAULT NULL,
  `det_versao_7000` longtext,
  `user_insert_7000` varchar(45) DEFAULT NULL,
  `dt_insert_7000` date DEFAULT NULL,
  `user_update_7000` varchar(45) DEFAULT NULL,
  `dt_ult_update_7000` date DEFAULT NULL,
  `env_auto_terc_7000` tinyint DEFAULT NULL COMMENT 'indica se a resposta da análise do formulário deve ser enviado de forma automática para o fornecedor avaliado (0 = não , 1 = sim)',
  `sla_aprov_7000` int DEFAULT NULL,
  `instr_form_7000` longtext,
  `sla_preench_form_7000` int DEFAULT NULL,
  `aval_form_peso_7000` tinyint DEFAULT '0' COMMENT 'Indica que o formulário deve sera avaliado com o critério de peso ',
  `ind_secao_interna_7000` tinyint DEFAULT '0',
  `ind_env_notif_risco_7000` tinyint DEFAULT '0',
  PRIMARY KEY (`id_7000`),
  KEY `fk_classif_terc_2090_2` (`id_classif_terc_2090`),
  CONSTRAINT `fk_classif_terc_2090_2` FOREIGN KEY (`id_classif_terc_2090`) REFERENCES `DOM_classif_terc_2090` (`id_classif_terc_2090`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `LGPD_config_mestre_avaliação_7000`
--

-- LOCK TABLES `LGPD_config_mestre_avaliação_7000` WRITE;
/*!40000 ALTER TABLE `LGPD_config_mestre_avaliação_7000` DISABLE KEYS */;
INSERT INTO `LGPD_config_mestre_avaliação_7000` VALUES (8,3,2,1,'ertet',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,0);
/*!40000 ALTER TABLE `LGPD_config_mestre_avaliação_7000` ENABLE KEYS */;
-- UNLOCK TABLES;

--
-- Table structure for table `PAC_1000_user_portal`
--

DROP TABLE IF EXISTS `PAC_1000_user_portal`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `PAC_1000_user_portal` (
  `nome_1000` text,
  `cpf_1000` char(14) DEFAULT NULL,
  `email_1000` text,
  `ind_confirme_mail_1000` tinyint(1) DEFAULT NULL,
  `ind_valid_docs_1000` tinyint(1) DEFAULT NULL,
  `acesso_liberado_1000` tinyint(1) DEFAULT NULL,
  `dt_sol_acesso_1000` date DEFAULT NULL,
  `dt_resp_sol_1000` date DEFAULT NULL,
  `id_1000` int NOT NULL AUTO_INCREMENT,
  `pass_1000` varchar(255) DEFAULT NULL,
  `id_controlador_1000` int DEFAULT NULL,
  `foto_doc_1000` varchar(250) DEFAULT NULL,
  `foto_pessoa_1000` varchar(250) DEFAULT NULL,
  `justificativas_1000` longtext,
  PRIMARY KEY (`id_1000`)
) ENGINE=InnoDB AUTO_INCREMENT=14 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `PAC_1000_user_portal`
--

-- LOCK TABLES `PAC_1000_user_portal` WRITE;
/*!40000 ALTER TABLE `PAC_1000_user_portal` DISABLE KEYS */;
/*!40000 ALTER TABLE `PAC_1000_user_portal` ENABLE KEYS */;
-- UNLOCK TABLES;

--
-- Table structure for table `PAC_1050_agree_register`
--

DROP TABLE IF EXISTS `PAC_1050_agree_register`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `PAC_1050_agree_register` (
  `email_1050` text,
  `dt_agree_1050` date DEFAULT NULL,
  `cad_concluido_1050` tinyint(1) DEFAULT NULL,
  `dt_concl_cad_1050` date DEFAULT NULL,
  `cadastro_aprovado_1050` tinyint(1) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `PAC_1050_agree_register`
--

-- LOCK TABLES `PAC_1050_agree_register` WRITE;
/*!40000 ALTER TABLE `PAC_1050_agree_register` DISABLE KEYS */;
/*!40000 ALTER TABLE `PAC_1050_agree_register` ENABLE KEYS */;
-- UNLOCK TABLES;

--
-- Table structure for table `PAC_1100_sol_portal`
--

DROP TABLE IF EXISTS `PAC_1100_sol_portal`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `PAC_1100_sol_portal` (
  `id_1100` int NOT NULL AUTO_INCREMENT,
  `id_1000` int DEFAULT NULL,
  `id_1200` int DEFAULT NULL,
  `dt_sol_1100` date DEFAULT NULL,
  `dt_enc_1100` date DEFAULT NULL,
  `desc_sol_1100` text,
  `desc_resol_1100` text,
  `id_pac_1100_status` int NOT NULL,
  `id_controlador_1000` int DEFAULT NULL,
  `anexo_1` varchar(250) DEFAULT NULL,
  `anexo_2` varchar(250) DEFAULT NULL,
  PRIMARY KEY (`id_1100`),
  KEY `fk_pac_1100_status` (`id_pac_1100_status`),
  CONSTRAINT `fk_pac_1100_status` FOREIGN KEY (`id_pac_1100_status`) REFERENCES `DOM_pac_1100_status` (`id_pac_1100_status`)
) ENGINE=InnoDB AUTO_INCREMENT=15 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `PAC_1100_sol_portal`
--

-- LOCK TABLES `PAC_1100_sol_portal` WRITE;
/*!40000 ALTER TABLE `PAC_1100_sol_portal` DISABLE KEYS */;
/*!40000 ALTER TABLE `PAC_1100_sol_portal` ENABLE KEYS */;
-- UNLOCK TABLES;

--
-- Table structure for table `PAC_1110_atv_sol`
--

DROP TABLE IF EXISTS `PAC_1110_atv_sol`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `PAC_1110_atv_sol` (
  `id_1110` int NOT NULL AUTO_INCREMENT,
  `id_1100` int DEFAULT NULL,
  `dt_atv_sol_1110` date DEFAULT NULL,
  `desc_atv_sol_1110` text,
  `origem_atv_sol_1100` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`id_1110`)
) ENGINE=InnoDB AUTO_INCREMENT=14 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `PAC_1110_atv_sol`
--

-- LOCK TABLES `PAC_1110_atv_sol` WRITE;
/*!40000 ALTER TABLE `PAC_1110_atv_sol` DISABLE KEYS */;
/*!40000 ALTER TABLE `PAC_1110_atv_sol` ENABLE KEYS */;
-- UNLOCK TABLES;

--
-- Table structure for table `PAC_1200_sla_sol_portal`
--

DROP TABLE IF EXISTS `PAC_1200_sla_sol_portal`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `PAC_1200_sla_sol_portal` (
  `id_1200` int NOT NULL AUTO_INCREMENT,
  `titulo_cat_1200` text,
  `sla_1200` int DEFAULT NULL,
  `atend_nivel1_1200` int DEFAULT NULL,
  `atend_nivel2_1200` int DEFAULT NULL,
  `desc_1200` text,
  `id_controlador_1000` int DEFAULT NULL,
  PRIMARY KEY (`id_1200`)
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `PAC_1200_sla_sol_portal`
--

-- LOCK TABLES `PAC_1200_sla_sol_portal` WRITE;
/*!40000 ALTER TABLE `PAC_1200_sla_sol_portal` DISABLE KEYS */;
/*!40000 ALTER TABLE `PAC_1200_sla_sol_portal` ENABLE KEYS */;
-- UNLOCK TABLES;

--
-- Table structure for table `PAC_1400_titulares`
--

DROP TABLE IF EXISTS `PAC_1400_titulares`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `PAC_1400_titulares` (
  `cpf_1400` char(14) DEFAULT NULL,
  `nome_1400` text,
  `email_1400` text,
  `tel_1400` char(20) DEFAULT NULL,
  `id_1400` int NOT NULL AUTO_INCREMENT,
  `id_controlador_1000` int DEFAULT NULL,
  `pass_1400` varchar(255) DEFAULT NULL,
  `tp_titular_1400` int NOT NULL,
  PRIMARY KEY (`id_1400`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `PAC_1400_titulares`
--

-- LOCK TABLES `PAC_1400_titulares` WRITE;
/*!40000 ALTER TABLE `PAC_1400_titulares` DISABLE KEYS */;
/*!40000 ALTER TABLE `PAC_1400_titulares` ENABLE KEYS */;
-- UNLOCK TABLES;

--
-- Table structure for table `PAC_1410_dados_tit`
--

DROP TABLE IF EXISTS `PAC_1410_dados_tit`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `PAC_1410_dados_tit` (
  `id_1410` int NOT NULL AUTO_INCREMENT,
  `id_1400` int DEFAULT NULL,
  `cod_dad_2030` int DEFAULT NULL,
  `conteudo_1410` text,
  `id_atv_2010` int DEFAULT NULL,
  `cod_art_2020` int DEFAULT NULL,
  `id_controlador_1000` int DEFAULT NULL,
  PRIMARY KEY (`id_1410`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `PAC_1410_dados_tit`
--

-- LOCK TABLES `PAC_1410_dados_tit` WRITE;
/*!40000 ALTER TABLE `PAC_1410_dados_tit` DISABLE KEYS */;
/*!40000 ALTER TABLE `PAC_1410_dados_tit` ENABLE KEYS */;
-- UNLOCK TABLES;

--
-- Table structure for table `PAC_2000_incidentes`
--

DROP TABLE IF EXISTS `PAC_2000_incidentes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `PAC_2000_incidentes` (
  `id_2000` int NOT NULL AUTO_INCREMENT,
  `titulo_2000` text,
  `desc_inc_2000` text,
  `id_tp_inc_2000` int NOT NULL,
  `id_status_inc_2000` int NOT NULL,
  `relac_risco_2000` tinyint(1) DEFAULT NULL,
  `id_rsco_3000` int DEFAULT NULL,
  `dt_inc_2000` date DEFAULT NULL,
  `dt_enc_inc_2000` date DEFAULT NULL,
  `det_acomp_inc_2000` text,
  `dt_resol_inc_2000` date DEFAULT NULL,
  `id_nivel_crit_2000` int NOT NULL,
  `id_controlador_1000` int DEFAULT NULL,
  `id_atv_2010` int DEFAULT NULL,
  `id_resp_inc_2000` int DEFAULT NULL,
  PRIMARY KEY (`id_2000`),
  KEY `fk_status_inc_2000` (`id_status_inc_2000`),
  KEY `fk_tp_inc_2000` (`id_tp_inc_2000`),
  KEY `fk_nivel_crit_2000` (`id_nivel_crit_2000`),
  CONSTRAINT `fk_nivel_crit_2000` FOREIGN KEY (`id_nivel_crit_2000`) REFERENCES `DOM_nivel_crit_2000` (`id_nivel_crit_2000`),
  CONSTRAINT `fk_status_inc_2000` FOREIGN KEY (`id_status_inc_2000`) REFERENCES `DOM_status_inc_2000` (`id_status_inc_2000`),
  CONSTRAINT `fk_tp_inc_2000` FOREIGN KEY (`id_tp_inc_2000`) REFERENCES `DOM_tp_inc_2000` (`id_tp_inc_2000`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `PAC_2000_incidentes`
--

-- LOCK TABLES `PAC_2000_incidentes` WRITE;
/*!40000 ALTER TABLE `PAC_2000_incidentes` DISABLE KEYS */;
/*!40000 ALTER TABLE `PAC_2000_incidentes` ENABLE KEYS */;
-- UNLOCK TABLES;

--
-- Table structure for table `PAC_2050_and_inc`
--

DROP TABLE IF EXISTS `PAC_2050_and_inc`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `PAC_2050_and_inc` (
  `id_and_inc_2050` int NOT NULL AUTO_INCREMENT,
  `id_2000` int NOT NULL,
  `resp_and_ind_2050` int NOT NULL,
  `dt_and_inc_2050` date NOT NULL,
  `desc_and_inc_2050` longtext NOT NULL,
  `anexo_and_inc_2050` varchar(150) DEFAULT NULL,
  `dt_insert_2050` date NOT NULL,
  `user_insert_2050` varchar(45) NOT NULL,
  PRIMARY KEY (`id_and_inc_2050`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci COMMENT='Registro de andamentos e respostas ao incidente gerado';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `PAC_2050_and_inc`
--

-- LOCK TABLES `PAC_2050_and_inc` WRITE;
/*!40000 ALTER TABLE `PAC_2050_and_inc` DISABLE KEYS */;
/*!40000 ALTER TABLE `PAC_2050_and_inc` ENABLE KEYS */;
-- UNLOCK TABLES;

--
-- Table structure for table `PAC_2100_sla_notificacao`
--

DROP TABLE IF EXISTS `PAC_2100_sla_notificacao`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `PAC_2100_sla_notificacao` (
  `id_2100` int NOT NULL AUTO_INCREMENT,
  `SegInf_Baixa_Inc_2100` int DEFAULT NULL,
  `SegInf_Baixa_NotANPD_2100` int DEFAULT NULL,
  `SegInf_Baixa_NotTit_2100` int DEFAULT NULL,
  `SegInf_Mod_Inc_2100` int DEFAULT NULL,
  `SegInf_Mod_NotANPD_2100` int DEFAULT NULL,
  `SegInf_Mod_NotTit` int DEFAULT NULL,
  `SegInf_Urg_Inc_2100` int DEFAULT NULL,
  `SegInf_Urg_NotANPD_2100` int DEFAULT NULL,
  `SegInf_Urg_NotTit` int DEFAULT NULL,
  `VioDad_Baixa_Inc_2100` int DEFAULT NULL,
  `VioDad_Baixa_NotANPD_2100` int DEFAULT NULL,
  `VioDad_Baixa_NotTit_2100` int DEFAULT NULL,
  `VioDad_Mod_Inc_2100` int DEFAULT NULL,
  `VioDad_Mod_NotANPD_2100` int DEFAULT NULL,
  `VioDad_Mod_NotTit` int DEFAULT NULL,
  `VioDad_Urg_Inc_2100` int DEFAULT NULL,
  `VioDad_Urg_NotANPD_2100` int DEFAULT NULL,
  `VioDad_Urg_NotTit` int DEFAULT NULL,
  `id_controlador_1000` int DEFAULT NULL,
  PRIMARY KEY (`id_2100`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `PAC_2100_sla_notificacao`
--

-- LOCK TABLES `PAC_2100_sla_notificacao` WRITE;
/*!40000 ALTER TABLE `PAC_2100_sla_notificacao` DISABLE KEYS */;
/*!40000 ALTER TABLE `PAC_2100_sla_notificacao` ENABLE KEYS */;
-- UNLOCK TABLES;

--
-- Table structure for table `PAC_3100_env_consent`
--

DROP TABLE IF EXISTS `PAC_3100_env_consent`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `PAC_3100_env_consent` (
  `id_3100` int NOT NULL AUTO_INCREMENT,
  `dt_env_cons_3100` date DEFAULT NULL,
  `dt_ger_3100` date DEFAULT NULL,
  `dt_val_cons_3100` date DEFAULT NULL,
  `ind_ger_cons_3100` tinyint(1) DEFAULT NULL,
  `ind_env_cons_3100` tinyint(1) DEFAULT NULL,
  `des_lot_cons_3100` text,
  `id_controlador_1000` int DEFAULT NULL,
  PRIMARY KEY (`id_3100`)
) ENGINE=InnoDB AUTO_INCREMENT=14 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `PAC_3100_env_consent`
--

-- LOCK TABLES `PAC_3100_env_consent` WRITE;
/*!40000 ALTER TABLE `PAC_3100_env_consent` DISABLE KEYS */;
/*!40000 ALTER TABLE `PAC_3100_env_consent` ENABLE KEYS */;
-- UNLOCK TABLES;

--
-- Table structure for table `PAC_3200_tit_consent`
--

DROP TABLE IF EXISTS `PAC_3200_tit_consent`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `PAC_3200_tit_consent` (
  `id_tit_1400` int DEFAULT NULL,
  `id_lot_3100` int DEFAULT NULL,
  `dt_retorno_3200` date DEFAULT NULL,
  `id_resp_tit_3200` int DEFAULT NULL,
  `ind_revog_cons_3200` tinyint DEFAULT NULL,
  `dt_revog_cons_3200` date DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `PAC_3200_tit_consent`
--

-- LOCK TABLES `PAC_3200_tit_consent` WRITE;
/*!40000 ALTER TABLE `PAC_3200_tit_consent` DISABLE KEYS */;
/*!40000 ALTER TABLE `PAC_3200_tit_consent` ENABLE KEYS */;
-- UNLOCK TABLES;

--
-- Table structure for table `PAC_3300_fin_consent`
--

DROP TABLE IF EXISTS `PAC_3300_fin_consent`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `PAC_3300_fin_consent` (
  `id_fin_2070` int DEFAULT NULL,
  `id_lot_3100` int DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `PAC_3300_fin_consent`
--

-- LOCK TABLES `PAC_3300_fin_consent` WRITE;
/*!40000 ALTER TABLE `PAC_3300_fin_consent` DISABLE KEYS */;
/*!40000 ALTER TABLE `PAC_3300_fin_consent` ENABLE KEYS */;
-- UNLOCK TABLES;

--
-- Table structure for table `PAC_4000_notificacao`
--

DROP TABLE IF EXISTS `PAC_4000_notificacao`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `PAC_4000_notificacao` (
  `titulo_not_4000` text,
  `inc_assoc_not_2000` int DEFAULT NULL,
  `resp_not_4000` int DEFAULT NULL,
  `id_tp_not_4000` int NOT NULL,
  `id_subtipo_not_4000` int NOT NULL,
  `id_status_not_4000` int NOT NULL,
  `id_origem_not_4000` int NOT NULL,
  `id_metodo_env_not_4000` int NOT NULL,
  `dtenv_not_tit_4000` date DEFAULT NULL,
  `dtenv_not_anpd_4000` date DEFAULT NULL,
  `env_not_tit_4000` tinyint(1) DEFAULT NULL,
  `env_not_anpd_4000` tinyint(1) DEFAULT NULL,
  `mot_dem_env_not_4000` text,
  `id_controlador_1000` int DEFAULT NULL,
  `id_not_4000` int NOT NULL AUTO_INCREMENT,
  `dt_reg_not_4000` date DEFAULT NULL,
  `pdf_not_4000` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id_not_4000`),
  KEY `fk_subtipo_not_4000` (`id_subtipo_not_4000`),
  KEY `fk_tp_not_4000` (`id_tp_not_4000`),
  KEY `fk_status_not_4000` (`id_status_not_4000`),
  KEY `fk_origem_not_4000` (`id_origem_not_4000`),
  KEY `fk_metodo_env_not_4000` (`id_metodo_env_not_4000`),
  CONSTRAINT `fk_metodo_env_not_4000` FOREIGN KEY (`id_metodo_env_not_4000`) REFERENCES `DOM_metodo_env_not_4000` (`id_metodo_env_not_4000`),
  CONSTRAINT `fk_origem_not_4000` FOREIGN KEY (`id_origem_not_4000`) REFERENCES `DOM_origem_not_4000` (`id_origem_not_4000`),
  CONSTRAINT `fk_status_not_4000` FOREIGN KEY (`id_status_not_4000`) REFERENCES `DOM_status_not_4000` (`id_status_not_4000`),
  CONSTRAINT `fk_subtipo_not_4000` FOREIGN KEY (`id_subtipo_not_4000`) REFERENCES `DOM_subtipo_not_4000` (`id_subtipo_not_4000`),
  CONSTRAINT `fk_tp_not_4000` FOREIGN KEY (`id_tp_not_4000`) REFERENCES `DOM_tp_not_4000` (`id_tp_not_4000`)
) ENGINE=InnoDB AUTO_INCREMENT=33 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `PAC_4000_notificacao`
--

-- LOCK TABLES `PAC_4000_notificacao` WRITE;
/*!40000 ALTER TABLE `PAC_4000_notificacao` DISABLE KEYS */;
/*!40000 ALTER TABLE `PAC_4000_notificacao` ENABLE KEYS */;
-- UNLOCK TABLES;

--
-- Table structure for table `PAC_9000_DPIA`
--

DROP TABLE IF EXISTS `PAC_9000_DPIA`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `PAC_9000_DPIA` (
  `data_ger_9000` date DEFAULT NULL,
  `id_controlador_1000` int DEFAULT NULL,
  `arquivo_9000` char(250) DEFAULT NULL,
  `id_9000_dpia` int NOT NULL AUTO_INCREMENT,
  `dir_filter_9000` int DEFAULT NULL,
  `area_filter_9000` int DEFAULT NULL,
  `dpto_filter_9000` int DEFAULT NULL,
  `hipotese_filter_9000` int DEFAULT NULL,
  `papel_filter_9000` int DEFAULT NULL,
  `operador_filter_9000` int DEFAULT NULL,
  `ativo_filter_9000` int DEFAULT NULL,
  `finalidade_filter_9000` int DEFAULT NULL,
  `alto_impact_filter_9000` int DEFAULT NULL,
  PRIMARY KEY (`id_9000_dpia`)
) ENGINE=InnoDB AUTO_INCREMENT=186 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `PAC_9000_DPIA`
--

-- LOCK TABLES `PAC_9000_DPIA` WRITE;
/*!40000 ALTER TABLE `PAC_9000_DPIA` DISABLE KEYS */;
/*!40000 ALTER TABLE `PAC_9000_DPIA` ENABLE KEYS */;
-- UNLOCK TABLES;

--
-- Table structure for table `PAC_9100_LIA`
--

DROP TABLE IF EXISTS `PAC_9100_LIA`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `PAC_9100_LIA` (
  `data_ger_9100` date DEFAULT NULL,
  `id_controlador_1000` int DEFAULT NULL,
  `arquivo_9100` char(250) DEFAULT NULL,
  `id_9100_lia` int NOT NULL AUTO_INCREMENT,
  `dir_filter_9100` int DEFAULT NULL,
  `area_filter_9100` int DEFAULT NULL,
  `dpto_filter_9100` int DEFAULT NULL,
  `papel_filter_9100` int DEFAULT NULL,
  `operador_filter_9100` int DEFAULT NULL,
  `ativo_filter_9100` int DEFAULT NULL,
  PRIMARY KEY (`id_9100_lia`)
) ENGINE=InnoDB AUTO_INCREMENT=57 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `PAC_9100_LIA`
--

-- LOCK TABLES `PAC_9100_LIA` WRITE;
/*!40000 ALTER TABLE `PAC_9100_LIA` DISABLE KEYS */;
/*!40000 ALTER TABLE `PAC_9100_LIA` ENABLE KEYS */;
-- UNLOCK TABLES;

--
-- Table structure for table `PAG_lote_1000`
--

DROP TABLE IF EXISTS `PAG_lote_1000`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `PAG_lote_1000` (
  `id_lote_1000` int NOT NULL AUTO_INCREMENT,
  `dt_ger_lote_1000` date DEFAULT NULL,
  `id_controlador_1000` int DEFAULT NULL,
  `qtd_ocorr_1000` int DEFAULT NULL,
  `hr_ger_lote_1000` varchar(10) DEFAULT NULL,
  PRIMARY KEY (`id_lote_1000`)
) ENGINE=InnoDB AUTO_INCREMENT=14 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `PAG_lote_1000`
--

-- LOCK TABLES `PAG_lote_1000` WRITE;
/*!40000 ALTER TABLE `PAG_lote_1000` DISABLE KEYS */;
/*!40000 ALTER TABLE `PAG_lote_1000` ENABLE KEYS */;
-- UNLOCK TABLES;

--
-- Table structure for table `PAG_ocorr_lote_1100`
--

DROP TABLE IF EXISTS `PAG_ocorr_lote_1100`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `PAG_ocorr_lote_1100` (
  `id_lote_1000` int DEFAULT NULL,
  `id_ocorr_1100` int NOT NULL AUTO_INCREMENT,
  `func_ocorr_1100` text,
  `etapa_ocorr_1100` text,
  `regra_1100` longtext,
  PRIMARY KEY (`id_ocorr_1100`)
) ENGINE=InnoDB AUTO_INCREMENT=811 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `PAG_ocorr_lote_1100`
--

-- LOCK TABLES `PAG_ocorr_lote_1100` WRITE;
/*!40000 ALTER TABLE `PAG_ocorr_lote_1100` DISABLE KEYS */;
/*!40000 ALTER TABLE `PAG_ocorr_lote_1100` ENABLE KEYS */;
-- UNLOCK TABLES;

--
-- Table structure for table `lgpd_9000_rel_ropa`
--

DROP TABLE IF EXISTS `lgpd_9000_rel_ropa`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `lgpd_9000_rel_ropa` (
  `id_rel_ropa_9000` int NOT NULL AUTO_INCREMENT,
  `id_controlador_1000` int DEFAULT NULL,
  `lgpd_9000_rel_ropacol` varchar(45) DEFAULT NULL,
  `dt_ger_9000` date DEFAULT NULL,
  `hr_ger_9000` varchar(45) DEFAULT NULL,
  `arquivo_ropa_9000` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`id_rel_ropa_9000`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `lgpd_9000_rel_ropa`
--

-- LOCK TABLES `lgpd_9000_rel_ropa` WRITE;
/*!40000 ALTER TABLE `lgpd_9000_rel_ropa` DISABLE KEYS */;
/*!40000 ALTER TABLE `lgpd_9000_rel_ropa` ENABLE KEYS */;
-- UNLOCK TABLES;

--
-- Table structure for table `sc_log`
--

DROP TABLE IF EXISTS `sc_log`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sc_log` (
  `id` int NOT NULL AUTO_INCREMENT,
  `inserted_date` datetime DEFAULT NULL,
  `username` varchar(90) NOT NULL,
  `application` varchar(255) NOT NULL,
  `creator` varchar(30) NOT NULL,
  `ip_user` varchar(255) NOT NULL,
  `action` varchar(30) NOT NULL,
  `description` text,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=21747 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sc_log`
--

-- LOCK TABLES `sc_log` WRITE;
/*!40000 ALTER TABLE `sc_log` DISABLE KEYS */;
INSERT INTO `sc_log` VALUES (21441,'2025-07-18 10:09:36','diego','menu_dinamico','User','10.0.0.8','login','Logado no sistema com sucesso!'),(21442,'2025-07-18 10:09:36','diego','menu_dinamico','User','10.0.0.8','login Fail','Alguém tentou se logar com o usuário:'),(21443,'2025-07-18 10:09:38','diego','calendar_public_LGPD_4000_atividades','Scriptcase','10.0.0.8','access',''),(21444,'2025-07-22 13:07:20','admin','menu_dinamico','User','10.0.0.8','login','Logado no sistema com sucesso!'),(21445,'2025-07-22 13:07:23','admin','calendar_public_LGPD_4000_atividades','Scriptcase','10.0.0.8','access',''),(21446,'2025-08-12 11:15:11','caroline.franca','menu_dinamico','User','10.0.0.8','login','Logado no sistema com sucesso!'),(21447,'2025-08-12 11:15:11','caroline.franca','menu_dinamico','User','10.0.0.8','login Fail','Alguém tentou se logar com o usuário:'),(21448,'2025-09-11 13:06:47','','blank_email','Scriptcase','10.0.0.8','access',''),(21449,'2025-09-11 13:06:48','','blank_email','Scriptcase','10.0.0.8','access',''),(21450,'2025-09-17 10:44:51','jose.castralli','menu_dinamico','User','10.0.0.8','login','Logado no sistema com sucesso!'),(21451,'2025-09-17 10:44:51','jose.castralli','calendar_public_LGPD_4000_atividades','Scriptcase','10.0.0.8','access',''),(21452,'2025-09-25 16:59:25','','calendar_public_LGPD_4000_atividades','Scriptcase','10.0.0.8','access',''),(21453,'2025-09-29 19:19:37','admin','sub_grid_PAC_1120_fluxo_nivel','Scriptcase','10.0.0.8','access',''),(21454,'2025-09-29 19:22:19','admin','sub_grid_PAC_1120_fluxo_nivel','Scriptcase','10.0.0.8','access',''),(21455,'2025-09-29 19:24:31','admin','sub_grid_PAC_1120_fluxo_nivel','Scriptcase','10.0.0.8','access',''),(21456,'2025-09-29 19:24:41','admin','form_PAC_1120_fluxo_nivel','Scriptcase','10.0.0.8','access',''),(21457,'2025-09-29 19:24:51','admin','form_PAC_1120_fluxo_nivel','Scriptcase','10.0.0.8','insert','--> keys <-- id_hist_nivel_1120 : 61||--> fields <-- id_1100 (new)  : 15||id_1100 (label)  : Id 1100||dt_env_nivel_1120 (new)  : 2025-09-29||dt_env_nivel_1120 (label)  : Dt Env Nivel 1120||dt_fch_nivel_1120 (new)  : 2025-09-29||dt_fch_nivel_1120 (label)  : Data do fechamento||obs_nivel_1120 (new)  : nnnnnnnnjjjjjjjjjjj||obs_nivel_1120 (label)  : Observações / Atividades / Pedidos do remetente||nivel_atend_entrada_1120 (new)  : 2||nivel_atend_entrada_1120 (label)  : Nível receptor||nivel_atend_saida_1120 (new)  : 1||nivel_atend_saida_1120 (label)  : Nível remetente'),(21458,'2025-09-29 19:25:15','admin','sub_grid_PAC_1120_fluxo_nivel','Scriptcase','10.0.0.8','access',''),(21459,'2025-09-29 19:27:17','admin','sub_grid_PAC_1120_fluxo_nivel','Scriptcase','10.0.0.8','access',''),(21460,'2025-09-29 19:27:20','admin','form_PAC_1120_fluxo_nivel','Scriptcase','10.0.0.8','access',''),(21461,'2025-09-29 19:27:35','admin','form_PAC_1120_fluxo_nivel','Scriptcase','10.0.0.8','insert','--> keys <-- id_hist_nivel_1120 : 62||--> fields <-- id_1100 (new)  : 17||id_1100 (label)  : Id 1100||dt_env_nivel_1120 (new)  : 2025-09-29||dt_env_nivel_1120 (label)  : Dt Env Nivel 1120||dt_fch_nivel_1120 (new)  : 2025-09-23||dt_fch_nivel_1120 (label)  : Data do fechamento||obs_nivel_1120 (new)  : n/a||obs_nivel_1120 (label)  : Observações / Atividades / Pedidos do remetente||nivel_atend_entrada_1120 (new)  : 2||nivel_atend_entrada_1120 (label)  : Nível receptor||nivel_atend_saida_1120 (new)  : 1||nivel_atend_saida_1120 (label)  : Nível remetente'),(21462,'2025-09-29 19:27:39','admin','sub_grid_PAC_1120_fluxo_nivel','Scriptcase','10.0.0.8','access',''),(21463,'2025-09-30 18:47:15','admin','grid_PAC_1410_carga_tit','Scriptcase','10.0.0.8','access',''),(21464,'2025-09-30 18:47:20','admin','control_carga_titulares','Scriptcase','10.0.0.8','access',''),(21465,'2025-09-30 18:49:38','admin','form_PAC_1410_carga_validate','Scriptcase','10.0.0.8','access',''),(21466,'2025-09-30 18:49:38','admin','grid_PAC_1420_log_carga','Scriptcase','10.0.0.8','access',''),(21467,'2025-09-30 18:49:38','admin','grid_PAC_1400_titulares_res_carga','Scriptcase','10.0.0.8','access',''),(21468,'2025-09-30 18:49:38','admin','grid_PAC_1430_hist_carga_tit','Scriptcase','10.0.0.8','access',''),(21469,'2025-09-30 18:49:51','admin','control_carga_titulares','Scriptcase','10.0.0.8','access',''),(21470,'2025-09-30 18:49:53','admin','grid_PAC_1410_carga_tit','Scriptcase','10.0.0.8','access',''),(21471,'2025-09-30 18:49:57','admin','form_PAC_1410_carga_validate','Scriptcase','10.0.0.8','access',''),(21472,'2025-09-30 18:49:57','admin','grid_PAC_1420_log_carga','Scriptcase','10.0.0.8','access',''),(21473,'2025-09-30 18:49:57','admin','grid_PAC_1400_titulares_res_carga','Scriptcase','10.0.0.8','access',''),(21474,'2025-09-30 18:49:57','admin','grid_PAC_1430_hist_carga_tit','Scriptcase','10.0.0.8','access',''),(21475,'2025-09-30 18:50:07','admin','grid_PAC_1410_carga_tit','Scriptcase','10.0.0.8','access',''),(21476,'2025-09-30 18:50:11','admin','form_PAC_1410_carga_validate','Scriptcase','10.0.0.8','access',''),(21477,'2025-09-30 18:50:11','admin','grid_PAC_1420_log_carga','Scriptcase','10.0.0.8','access',''),(21478,'2025-09-30 18:50:11','admin','grid_PAC_1400_titulares_res_carga','Scriptcase','10.0.0.8','access',''),(21479,'2025-09-30 18:50:11','admin','grid_PAC_1430_hist_carga_tit','Scriptcase','10.0.0.8','access',''),(21480,'2025-09-30 18:50:14','admin','grid_PAC_1410_carga_tit','Scriptcase','10.0.0.8','access',''),(21481,'2025-10-01 08:18:23','admin','grid_PAC_1410_carga_tit','Scriptcase','10.0.0.8','access',''),(21482,'2025-10-01 08:18:31','admin','control_carga_titulares','Scriptcase','10.0.0.8','access',''),(21483,'2025-10-01 08:21:55','admin','grid_PAC_1410_carga_tit','Scriptcase','10.0.0.8','access',''),(21484,'2025-10-01 08:21:56','admin','form_PAC_1410_carga_validate','Scriptcase','10.0.0.8','access',''),(21485,'2025-10-01 08:21:57','admin','grid_PAC_1420_log_carga','Scriptcase','10.0.0.8','access',''),(21486,'2025-10-01 08:21:57','admin','grid_PAC_1400_titulares_res_carga','Scriptcase','10.0.0.8','access',''),(21487,'2025-10-01 08:21:57','admin','grid_PAC_1430_hist_carga_tit','Scriptcase','10.0.0.8','access',''),(21488,'2025-10-01 08:22:00','admin','grid_PAC_1410_carga_tit','Scriptcase','10.0.0.8','access',''),(21489,'2025-10-01 08:28:57','admin','grid_PAC_1410_carga_tit','Scriptcase','10.0.0.8','access',''),(21490,'2025-10-01 08:29:01','admin','control_carga_titulares','Scriptcase','10.0.0.8','access',''),(21491,'2025-10-01 08:29:13','admin','grid_PAC_1410_carga_tit','Scriptcase','10.0.0.8','access',''),(21492,'2025-10-01 08:29:18','admin','grid_PAC_1410_carga_tit','Scriptcase','10.0.0.8','access',''),(21493,'2025-10-01 08:29:59','admin','grid_PAC_1410_carga_tit','Scriptcase','10.0.0.8','access',''),(21494,'2025-10-01 08:30:01','admin','control_carga_titulares','Scriptcase','10.0.0.8','access',''),(21495,'2025-10-01 08:30:30','admin','form_PAC_1410_carga_validate','Scriptcase','10.0.0.8','access',''),(21496,'2025-10-01 08:30:30','admin','grid_PAC_1400_titulares_res_carga','Scriptcase','10.0.0.8','access',''),(21497,'2025-10-01 08:30:31','admin','grid_PAC_1420_log_carga','Scriptcase','10.0.0.8','access',''),(21498,'2025-10-01 08:30:31','admin','grid_PAC_1430_hist_carga_tit','Scriptcase','10.0.0.8','access',''),(21499,'2025-10-01 08:30:36','admin','control_carga_titulares','Scriptcase','10.0.0.8','access',''),(21500,'2025-10-01 11:43:50','admin','grid_PAC_1410_carga_tit','Scriptcase','10.0.0.8','access',''),(21501,'2025-10-01 11:44:03','admin','grid_PAC_1410_carga_tit','Scriptcase','10.0.0.8','access',''),(21502,'2025-10-01 11:44:05','admin','control_carga_titulares','Scriptcase','10.0.0.8','access',''),(21503,'2025-10-01 11:48:25','admin','form_PAC_1410_carga_validate','Scriptcase','10.0.0.8','access',''),(21504,'2025-10-01 11:48:25','admin','grid_PAC_1420_log_carga','Scriptcase','10.0.0.8','access',''),(21505,'2025-10-01 11:48:25','admin','grid_PAC_1400_titulares_res_carga','Scriptcase','10.0.0.8','access',''),(21506,'2025-10-01 11:48:25','admin','grid_PAC_1430_hist_carga_tit','Scriptcase','10.0.0.8','access',''),(21507,'2025-10-01 11:48:41','admin','grid_PAC_1420_log_carga','Scriptcase','10.0.0.8','access',''),(21508,'2025-10-01 11:48:41','admin','grid_PAC_1400_titulares_res_carga','Scriptcase','10.0.0.8','access',''),(21509,'2025-10-01 11:48:41','admin','grid_PAC_1430_hist_carga_tit','Scriptcase','10.0.0.8','access',''),(21510,'2025-10-01 11:51:22','admin','grid_PAC_1410_carga_tit','Scriptcase','10.0.0.8','access',''),(21511,'2025-10-01 11:51:24','admin','control_carga_titulares','Scriptcase','10.0.0.8','access',''),(21512,'2025-10-01 11:51:30','admin','form_PAC_1410_carga_validate','Scriptcase','10.0.0.8','access',''),(21513,'2025-10-01 11:51:31','admin','grid_PAC_1420_log_carga','Scriptcase','10.0.0.8','access',''),(21514,'2025-10-01 11:51:31','admin','grid_PAC_1400_titulares_res_carga','Scriptcase','10.0.0.8','access',''),(21515,'2025-10-01 11:51:31','admin','grid_PAC_1430_hist_carga_tit','Scriptcase','10.0.0.8','access',''),(21516,'2025-10-01 11:51:41','admin','grid_PAC_1420_log_carga','Scriptcase','10.0.0.8','access',''),(21517,'2025-10-01 11:51:41','admin','grid_PAC_1400_titulares_res_carga','Scriptcase','10.0.0.8','access',''),(21518,'2025-10-01 11:51:41','admin','grid_PAC_1430_hist_carga_tit','Scriptcase','10.0.0.8','access',''),(21519,'2025-10-01 11:51:56','admin','control_carga_titulares','Scriptcase','10.0.0.8','access',''),(21520,'2025-10-01 11:54:57','admin','grid_PAC_1410_carga_tit','Scriptcase','10.0.0.8','access',''),(21521,'2025-10-03 14:06:50','admin','grid_PAC_1410_carga_tit','Scriptcase','10.0.0.8','access',''),(21522,'2025-10-06 16:33:06','admin','grid_PAC_1410_carga_tit','Scriptcase','10.0.0.8','access',''),(21523,'2025-10-06 16:33:08','admin','form_PAC_1410_carga_validate','Scriptcase','10.0.0.8','access',''),(21524,'2025-10-06 16:33:08','admin','grid_PAC_1420_log_carga','Scriptcase','10.0.0.8','access',''),(21525,'2025-10-06 16:33:08','admin','grid_PAC_1400_titulares_res_carga','Scriptcase','10.0.0.8','access',''),(21526,'2025-10-06 16:33:08','admin','grid_PAC_1430_hist_carga_tit','Scriptcase','10.0.0.8','access',''),(21527,'2025-10-06 16:33:15','admin','grid_PAC_1410_carga_tit','Scriptcase','10.0.0.8','access',''),(21528,'2025-10-06 16:33:32','admin','grid_PAC_1410_carga_tit','Scriptcase','10.0.0.8','access',''),(21529,'2025-10-06 16:33:35','admin','form_PAC_1410_carga_validate','Scriptcase','10.0.0.8','access',''),(21530,'2025-10-06 16:33:35','admin','grid_PAC_1420_log_carga','Scriptcase','10.0.0.8','access',''),(21531,'2025-10-06 16:33:35','admin','grid_PAC_1400_titulares_res_carga','Scriptcase','10.0.0.8','access',''),(21532,'2025-10-06 16:33:35','admin','grid_PAC_1430_hist_carga_tit','Scriptcase','10.0.0.8','access',''),(21533,'2025-10-06 16:44:40','admin','grid_PAC_1410_carga_tit','Scriptcase','10.0.0.8','access',''),(21534,'2025-10-06 16:44:44','admin','control_carga_titulares','Scriptcase','10.0.0.8','access',''),(21535,'2025-10-06 16:45:03','admin','form_PAC_1410_carga_validate','Scriptcase','10.0.0.8','access',''),(21536,'2025-10-06 16:45:03','admin','grid_PAC_1420_log_carga','Scriptcase','10.0.0.8','access',''),(21537,'2025-10-06 16:45:03','admin','grid_PAC_1400_titulares_res_carga','Scriptcase','10.0.0.8','access',''),(21538,'2025-10-06 16:45:03','admin','grid_PAC_1430_hist_carga_tit','Scriptcase','10.0.0.8','access',''),(21539,'2025-10-06 16:45:10','admin','grid_PAC_1420_log_carga','Scriptcase','10.0.0.8','access',''),(21540,'2025-10-06 16:45:10','admin','grid_PAC_1400_titulares_res_carga','Scriptcase','10.0.0.8','access',''),(21541,'2025-10-06 16:45:10','admin','grid_PAC_1430_hist_carga_tit','Scriptcase','10.0.0.8','access',''),(21542,'2025-10-06 16:52:24','admin','control_carga_titulares','Scriptcase','10.0.0.8','access',''),(21543,'2025-10-06 16:52:26','admin','grid_PAC_1410_carga_tit','Scriptcase','10.0.0.8','access',''),(21544,'2025-10-06 16:52:33','admin','form_PAC_1410_carga_validate','Scriptcase','10.0.0.8','access',''),(21545,'2025-10-06 16:52:34','admin','grid_PAC_1420_log_carga','Scriptcase','10.0.0.8','access',''),(21546,'2025-10-06 16:52:34','admin','grid_PAC_1400_titulares_res_carga','Scriptcase','10.0.0.8','access',''),(21547,'2025-10-06 16:52:34','admin','grid_PAC_1430_hist_carga_tit','Scriptcase','10.0.0.8','access',''),(21548,'2025-10-06 16:52:50','admin','grid_PAC_1410_carga_tit','Scriptcase','10.0.0.8','access',''),(21549,'2025-10-07 10:52:25','admin','grid_DEN_3000_fluxo_nivel','Scriptcase','10.0.0.8','access',''),(21550,'2025-10-07 10:52:38','admin','grid_DEN_3000_fluxo_nivel','Scriptcase','10.0.0.8','access',''),(21551,'2025-10-07 10:53:15','anderson.neto','grid_DEN_3000_fluxo_nivel','Scriptcase','10.0.0.8','access',''),(21552,'2025-10-07 10:54:07','anderson.neto','form_DEN_3000_fluxo_nivel','Scriptcase','10.0.0.8','access',''),(21553,'2025-10-07 10:54:37','anderson.neto','form_DEN_3000_fluxo_nivel','Scriptcase','10.0.0.8','insert','--> keys <-- id_hist_nivel_3000 : 5||--> fields <-- id_1000 (new)  : 10||id_1000 (label)  : Id 1000||dt_env_nivel_3000 (new)  : 2025-10-07||dt_env_nivel_3000 (label)  : Data da tranferência de nível||dt_fch_nivel_3000 (new)  : 2025-10-07||dt_fch_nivel_3000 (label)  : Data do fechamento deste nível||obs_nivel_3000 (new)  : Coletamos todas as provas e estamos devolvendo para o nível 1 para processeguimento||obs_nivel_3000 (label)  : Informe as atividades de investigação realizadas neste nível||nivel_atend_entrada_3000 (new)  : 1||nivel_atend_entrada_3000 (label)  : Nível a ser transferida a investigação||nivel_atend_saida_3000 (new)  : 2||nivel_atend_saida_3000 (label)  : Nível Atual de investigação'),(21554,'2025-10-07 10:54:37','anderson.neto','grid_DEN_3000_fluxo_nivel','Scriptcase','10.0.0.8','access',''),(21555,'2025-10-08 09:09:25','admin','grid_DEN_3000_fluxo_nivel','Scriptcase','10.0.0.8','access',''),(21556,'2025-10-08 09:17:12','admin','grid_DEN_3000_fluxo_nivel','Scriptcase','10.0.0.8','access',''),(21557,'2025-10-08 09:18:10','admin','grid_DEN_3000_fluxo_nivel','Scriptcase','10.0.0.8','access',''),(21558,'2025-10-08 09:20:29','admin','grid_DEN_3000_fluxo_nivel','Scriptcase','10.0.0.8','access',''),(21559,'2025-10-09 09:17:04','admin','grid_PAC_1410_carga_tit','Scriptcase','10.0.0.8','access',''),(21560,'2025-10-09 09:17:11','admin','control_carga_titulares','Scriptcase','10.0.0.8','access',''),(21561,'2025-10-09 09:20:29','admin','form_PAC_1410_carga_validate','Scriptcase','10.0.0.8','access',''),(21562,'2025-10-09 09:20:29','admin','grid_PAC_1400_titulares_res_carga','Scriptcase','10.0.0.8','access',''),(21563,'2025-10-09 09:20:29','admin','grid_PAC_1420_log_carga','Scriptcase','10.0.0.8','access',''),(21564,'2025-10-09 09:20:29','admin','grid_PAC_1430_hist_carga_tit','Scriptcase','10.0.0.8','access',''),(21565,'2025-10-09 09:21:23','admin','grid_PAC_1420_log_carga','Scriptcase','10.0.0.8','access',''),(21566,'2025-10-09 09:21:23','admin','grid_PAC_1400_titulares_res_carga','Scriptcase','10.0.0.8','access',''),(21567,'2025-10-09 09:21:23','admin','grid_PAC_1430_hist_carga_tit','Scriptcase','10.0.0.8','access',''),(21568,'2025-10-09 11:17:25','admin','grid_PAC_1410_carga_tit','Scriptcase','10.0.0.8','access',''),(21569,'2025-10-09 11:17:35','admin','control_carga_titulares','Scriptcase','10.0.0.8','access',''),(21570,'2025-10-09 11:17:48','admin','grid_PAC_1410_carga_tit','Scriptcase','10.0.0.8','access',''),(21571,'2025-10-09 11:18:44','admin','form_PAC_1410_carga_validate','Scriptcase','10.0.0.8','access',''),(21572,'2025-10-09 11:18:44','admin','grid_PAC_1420_log_carga','Scriptcase','10.0.0.8','access',''),(21573,'2025-10-09 11:18:44','admin','grid_PAC_1400_titulares_res_carga','Scriptcase','10.0.0.8','access',''),(21574,'2025-10-09 11:18:44','admin','grid_PAC_1430_hist_carga_tit','Scriptcase','10.0.0.8','access',''),(21575,'2025-10-09 11:21:22','admin','grid_PAC_1410_carga_tit','Scriptcase','10.0.0.8','access',''),(21576,'2025-10-09 11:22:30','admin','form_PAC_1410_carga_validate','Scriptcase','10.0.0.8','access',''),(21577,'2025-10-09 11:22:30','admin','grid_PAC_1420_log_carga','Scriptcase','10.0.0.8','access',''),(21578,'2025-10-09 11:22:30','admin','grid_PAC_1400_titulares_res_carga','Scriptcase','10.0.0.8','access',''),(21579,'2025-10-09 11:22:30','admin','grid_PAC_1430_hist_carga_tit','Scriptcase','10.0.0.8','access',''),(21580,'2025-10-09 11:24:27','admin','grid_PAC_1410_carga_tit','Scriptcase','10.0.0.8','access',''),(21581,'2025-10-09 11:24:32','admin','control_carga_titulares','Scriptcase','10.0.0.8','access',''),(21582,'2025-10-09 11:25:34','admin','grid_PAC_1410_carga_tit','Scriptcase','10.0.0.8','access',''),(21583,'2025-10-09 11:25:53','admin','control_carga_titulares','Scriptcase','10.0.0.8','access',''),(21584,'2025-10-09 11:26:01','admin','grid_PAC_1410_carga_tit','Scriptcase','10.0.0.8','access',''),(21585,'2025-10-09 11:26:51','admin','form_PAC_1410_carga_validate','Scriptcase','10.0.0.8','access',''),(21586,'2025-10-09 11:26:52','admin','grid_PAC_1420_log_carga','Scriptcase','10.0.0.8','access',''),(21587,'2025-10-09 11:26:52','admin','grid_PAC_1400_titulares_res_carga','Scriptcase','10.0.0.8','access',''),(21588,'2025-10-09 11:26:52','admin','grid_PAC_1430_hist_carga_tit','Scriptcase','10.0.0.8','access',''),(21589,'2025-10-09 11:26:55','admin','grid_PAC_1410_carga_tit','Scriptcase','10.0.0.8','access',''),(21590,'2025-10-09 11:27:44','admin','form_PAC_1410_carga_validate','Scriptcase','10.0.0.8','access',''),(21591,'2025-10-09 11:27:45','admin','grid_PAC_1420_log_carga','Scriptcase','10.0.0.8','access',''),(21592,'2025-10-09 11:27:45','admin','grid_PAC_1400_titulares_res_carga','Scriptcase','10.0.0.8','access',''),(21593,'2025-10-09 11:27:45','admin','grid_PAC_1430_hist_carga_tit','Scriptcase','10.0.0.8','access',''),(21594,'2025-10-09 11:27:52','admin','grid_PAC_1410_carga_tit','Scriptcase','10.0.0.8','access',''),(21595,'2025-10-09 11:27:54','admin','form_PAC_1410_carga_validate','Scriptcase','10.0.0.8','access',''),(21596,'2025-10-09 11:27:54','admin','grid_PAC_1430_hist_carga_tit','Scriptcase','10.0.0.8','access',''),(21597,'2025-10-09 11:27:54','admin','grid_PAC_1400_titulares_res_carga','Scriptcase','10.0.0.8','access',''),(21598,'2025-10-09 11:27:54','admin','grid_PAC_1420_log_carga','Scriptcase','10.0.0.8','access',''),(21599,'2025-10-09 11:28:27','admin','grid_PAC_1410_carga_tit','Scriptcase','10.0.0.8','access',''),(21600,'2025-10-09 11:28:28','admin','form_PAC_1410_carga_validate','Scriptcase','10.0.0.8','access',''),(21601,'2025-10-09 11:28:28','admin','grid_PAC_1420_log_carga','Scriptcase','10.0.0.8','access',''),(21602,'2025-10-09 11:28:28','admin','grid_PAC_1430_hist_carga_tit','Scriptcase','10.0.0.8','access',''),(21603,'2025-10-09 11:28:28','admin','grid_PAC_1400_titulares_res_carga','Scriptcase','10.0.0.8','access',''),(21604,'2025-10-09 11:28:34','admin','grid_PAC_1410_carga_tit','Scriptcase','10.0.0.8','access',''),(21605,'2025-10-09 11:28:39','admin','grid_PAC_1410_carga_tit','Scriptcase','10.0.0.8','access',''),(21606,'2025-10-09 11:28:41','admin','form_PAC_1410_carga_validate','Scriptcase','10.0.0.8','access',''),(21607,'2025-10-09 11:28:41','admin','grid_PAC_1420_log_carga','Scriptcase','10.0.0.8','access',''),(21608,'2025-10-09 11:28:41','admin','grid_PAC_1430_hist_carga_tit','Scriptcase','10.0.0.8','access',''),(21609,'2025-10-09 11:28:41','admin','grid_PAC_1400_titulares_res_carga','Scriptcase','10.0.0.8','access',''),(21610,'2025-10-09 11:28:44','admin','grid_PAC_1410_carga_tit','Scriptcase','10.0.0.8','access',''),(21611,'2025-10-09 11:28:45','admin','form_PAC_1410_carga_validate','Scriptcase','10.0.0.8','access',''),(21612,'2025-10-09 11:28:46','admin','grid_PAC_1420_log_carga','Scriptcase','10.0.0.8','access',''),(21613,'2025-10-09 11:28:46','admin','grid_PAC_1430_hist_carga_tit','Scriptcase','10.0.0.8','access',''),(21614,'2025-10-09 11:28:46','admin','grid_PAC_1400_titulares_res_carga','Scriptcase','10.0.0.8','access',''),(21615,'2025-10-09 11:30:51','admin','grid_PAC_1410_carga_tit','Scriptcase','10.0.0.8','access',''),(21616,'2025-10-09 11:34:22','admin','control_carga_titulares','Scriptcase','10.0.0.8','access',''),(21617,'2025-10-09 13:36:46','admin','grid_PAC_1410_carga_tit','Scriptcase','10.0.0.8','access',''),(21618,'2025-10-09 13:43:10','admin','control_carga_titulares','Scriptcase','10.0.0.8','access',''),(21619,'2025-10-09 15:34:33','admin','grid_PAC_1410_carga_tit','Scriptcase','10.0.0.8','access',''),(21620,'2025-10-09 15:34:40','admin','form_PAC_1410_carga_validate','Scriptcase','10.0.0.8','access',''),(21621,'2025-10-09 15:34:41','admin','grid_PAC_1400_titulares_res_carga','Scriptcase','10.0.0.8','access',''),(21622,'2025-10-09 15:34:41','admin','grid_PAC_1420_log_carga','Scriptcase','10.0.0.8','access',''),(21623,'2025-10-09 15:34:41','admin','grid_PAC_1430_hist_carga_tit','Scriptcase','10.0.0.8','access',''),(21624,'2025-10-09 15:34:46','admin','grid_PAC_1410_carga_tit','Scriptcase','10.0.0.8','access',''),(21625,'2025-10-09 15:34:49','admin','form_PAC_1410_carga_validate','Scriptcase','10.0.0.8','access',''),(21626,'2025-10-09 15:34:49','admin','grid_PAC_1420_log_carga','Scriptcase','10.0.0.8','access',''),(21627,'2025-10-09 15:34:49','admin','grid_PAC_1400_titulares_res_carga','Scriptcase','10.0.0.8','access',''),(21628,'2025-10-09 15:34:49','admin','grid_PAC_1430_hist_carga_tit','Scriptcase','10.0.0.8','access',''),(21629,'2025-10-09 15:34:53','admin','grid_PAC_1410_carga_tit','Scriptcase','10.0.0.8','access',''),(21630,'2025-10-09 15:34:57','admin','grid_PAC_1410_carga_tit','Scriptcase','10.0.0.8','access',''),(21631,'2025-10-09 15:34:59','admin','form_PAC_1410_carga_validate','Scriptcase','10.0.0.8','access',''),(21632,'2025-10-09 15:34:59','admin','grid_PAC_1400_titulares_res_carga','Scriptcase','10.0.0.8','access',''),(21633,'2025-10-09 15:34:59','admin','grid_PAC_1430_hist_carga_tit','Scriptcase','10.0.0.8','access',''),(21634,'2025-10-09 15:34:59','admin','grid_PAC_1420_log_carga','Scriptcase','10.0.0.8','access',''),(21635,'2025-10-09 15:35:02','admin','grid_PAC_1410_carga_tit','Scriptcase','10.0.0.8','access',''),(21636,'2025-10-09 15:35:04','admin','form_PAC_1410_carga_validate','Scriptcase','10.0.0.8','access',''),(21637,'2025-10-09 15:35:04','admin','grid_PAC_1420_log_carga','Scriptcase','10.0.0.8','access',''),(21638,'2025-10-09 15:35:04','admin','grid_PAC_1430_hist_carga_tit','Scriptcase','10.0.0.8','access',''),(21639,'2025-10-09 15:35:04','admin','grid_PAC_1400_titulares_res_carga','Scriptcase','10.0.0.8','access',''),(21640,'2025-10-09 15:35:17','admin','grid_PAC_1410_carga_tit','Scriptcase','10.0.0.8','access',''),(21641,'2025-10-09 15:35:18','admin','form_PAC_1410_carga_validate','Scriptcase','10.0.0.8','access',''),(21642,'2025-10-09 15:35:18','admin','grid_PAC_1420_log_carga','Scriptcase','10.0.0.8','access',''),(21643,'2025-10-09 15:35:18','admin','grid_PAC_1430_hist_carga_tit','Scriptcase','10.0.0.8','access',''),(21644,'2025-10-09 15:35:18','admin','grid_PAC_1400_titulares_res_carga','Scriptcase','10.0.0.8','access',''),(21645,'2025-10-09 15:35:30','admin','grid_PAC_1410_carga_tit','Scriptcase','10.0.0.8','access',''),(21646,'2025-10-09 15:35:34','admin','form_PAC_1410_carga_validate','Scriptcase','10.0.0.8','access',''),(21647,'2025-10-09 15:35:35','admin','grid_PAC_1400_titulares_res_carga','Scriptcase','10.0.0.8','access',''),(21648,'2025-10-09 15:35:35','admin','grid_PAC_1420_log_carga','Scriptcase','10.0.0.8','access',''),(21649,'2025-10-09 15:35:35','admin','grid_PAC_1430_hist_carga_tit','Scriptcase','10.0.0.8','access',''),(21650,'2025-10-09 15:35:36','admin','grid_PAC_1410_carga_tit','Scriptcase','10.0.0.8','access',''),(21651,'2025-10-09 15:35:38','admin','form_PAC_1410_carga_validate','Scriptcase','10.0.0.8','access',''),(21652,'2025-10-09 15:35:38','admin','grid_PAC_1420_log_carga','Scriptcase','10.0.0.8','access',''),(21653,'2025-10-09 15:35:38','admin','grid_PAC_1430_hist_carga_tit','Scriptcase','10.0.0.8','access',''),(21654,'2025-10-09 15:35:38','admin','grid_PAC_1400_titulares_res_carga','Scriptcase','10.0.0.8','access',''),(21655,'2025-10-09 15:35:40','admin','grid_PAC_1410_carga_tit','Scriptcase','10.0.0.8','access',''),(21656,'2025-10-09 15:35:41','admin','form_PAC_1410_carga_validate','Scriptcase','10.0.0.8','access',''),(21657,'2025-10-09 15:35:41','admin','grid_PAC_1420_log_carga','Scriptcase','10.0.0.8','access',''),(21658,'2025-10-09 15:35:41','admin','grid_PAC_1400_titulares_res_carga','Scriptcase','10.0.0.8','access',''),(21659,'2025-10-09 15:35:41','admin','grid_PAC_1430_hist_carga_tit','Scriptcase','10.0.0.8','access',''),(21660,'2025-10-09 15:35:42','admin','grid_PAC_1410_carga_tit','Scriptcase','10.0.0.8','access',''),(21661,'2025-10-09 16:09:34','','calendar_public_LGPD_4000_atividades','Scriptcase','10.0.0.8','access',''),(21662,'2025-10-09 16:09:42','','calendar_public_LGPD_4000_atividades','Scriptcase','10.0.0.8','access',''),(21663,'2025-10-09 16:09:52','','calendar_public_LGPD_4000_atividades','Scriptcase','10.0.0.8','access',''),(21664,'2025-10-09 19:05:15','','blank_email','Scriptcase','10.0.0.8','access',''),(21665,'2025-10-13 14:25:49','admin','grid_PAC_1410_carga_tit','Scriptcase','10.0.0.8','access',''),(21666,'2025-10-13 14:25:50','admin','form_PAC_1410_carga_validate','Scriptcase','10.0.0.8','access',''),(21667,'2025-10-13 14:25:51','admin','grid_PAC_1430_hist_carga_tit','Scriptcase','10.0.0.8','access',''),(21668,'2025-10-13 14:25:51','admin','grid_PAC_1420_log_carga','Scriptcase','10.0.0.8','access',''),(21669,'2025-10-13 14:25:51','admin','grid_PAC_1400_titulares_res_carga','Scriptcase','10.0.0.8','access',''),(21670,'2025-10-13 14:26:07','admin','grid_PAC_1410_carga_tit','Scriptcase','10.0.0.8','access',''),(21671,'2025-10-13 14:26:09','admin','form_PAC_1410_carga_validate','Scriptcase','10.0.0.8','access',''),(21672,'2025-10-13 14:26:09','admin','grid_PAC_1420_log_carga','Scriptcase','10.0.0.8','access',''),(21673,'2025-10-13 14:26:09','admin','grid_PAC_1430_hist_carga_tit','Scriptcase','10.0.0.8','access',''),(21674,'2025-10-13 14:26:09','admin','grid_PAC_1400_titulares_res_carga','Scriptcase','10.0.0.8','access',''),(21675,'2025-10-13 14:32:14','admin','grid_PAC_1410_carga_tit','Scriptcase','10.0.0.8','access',''),(21676,'2025-10-13 14:32:16','admin','form_PAC_1410_carga_validate','Scriptcase','10.0.0.8','access',''),(21677,'2025-10-13 14:32:16','admin','grid_PAC_1420_log_carga','Scriptcase','10.0.0.8','access',''),(21678,'2025-10-13 14:32:16','admin','grid_PAC_1400_titulares_res_carga','Scriptcase','10.0.0.8','access',''),(21679,'2025-10-13 14:32:16','admin','grid_PAC_1430_hist_carga_tit','Scriptcase','10.0.0.8','access',''),(21680,'2025-10-13 14:32:19','admin','grid_PAC_1410_carga_tit','Scriptcase','10.0.0.8','access',''),(21681,'2025-10-13 14:32:21','admin','form_PAC_1410_carga_validate','Scriptcase','10.0.0.8','access',''),(21682,'2025-10-13 14:32:21','admin','grid_PAC_1420_log_carga','Scriptcase','10.0.0.8','access',''),(21683,'2025-10-13 14:32:21','admin','grid_PAC_1430_hist_carga_tit','Scriptcase','10.0.0.8','access',''),(21684,'2025-10-13 14:32:21','admin','grid_PAC_1400_titulares_res_carga','Scriptcase','10.0.0.8','access',''),(21685,'2025-10-13 14:38:15','admin','grid_PAC_1410_carga_tit','Scriptcase','10.0.0.8','access',''),(21686,'2025-10-13 14:52:36','admin','form_PAC_1410_carga_validate','Scriptcase','10.0.0.8','access',''),(21687,'2025-10-13 14:52:36','admin','grid_PAC_1420_log_carga','Scriptcase','10.0.0.8','access',''),(21688,'2025-10-13 14:52:36','admin','grid_PAC_1400_titulares_res_carga','Scriptcase','10.0.0.8','access',''),(21689,'2025-10-13 14:52:36','admin','grid_PAC_1430_hist_carga_tit','Scriptcase','10.0.0.8','access',''),(21690,'2025-10-14 09:25:00','admin','grid_PAC_1410_carga_tit','Scriptcase','10.0.0.8','access',''),(21691,'2025-10-14 09:25:02','admin','form_PAC_1410_carga_validate','Scriptcase','10.0.0.8','access',''),(21692,'2025-10-14 09:25:02','admin','grid_PAC_1400_titulares_res_carga','Scriptcase','10.0.0.8','access',''),(21693,'2025-10-14 09:25:02','admin','grid_PAC_1420_log_carga','Scriptcase','10.0.0.8','access',''),(21694,'2025-10-14 09:25:02','admin','grid_PAC_1430_hist_carga_tit','Scriptcase','10.0.0.8','access',''),(21695,'2025-10-14 09:26:28','admin','grid_PAC_1410_carga_tit','Scriptcase','10.0.0.8','access',''),(21696,'2025-10-14 09:26:30','admin','form_PAC_1410_carga_validate','Scriptcase','10.0.0.8','access',''),(21697,'2025-10-14 09:26:30','admin','grid_PAC_1420_log_carga','Scriptcase','10.0.0.8','access',''),(21698,'2025-10-14 09:26:30','admin','grid_PAC_1400_titulares_res_carga','Scriptcase','10.0.0.8','access',''),(21699,'2025-10-14 09:26:30','admin','grid_PAC_1430_hist_carga_tit','Scriptcase','10.0.0.8','access',''),(21700,'2025-10-14 10:01:54','admin','grid_PAC_1410_carga_tit','Scriptcase','10.0.0.8','access',''),(21701,'2025-10-17 15:12:13','fernanda.taub','grid_DEN_3000_fluxo_nivel','Scriptcase','10.0.0.8','access',''),(21702,'2025-10-17 15:39:35','fernanda.taub','grid_DEN_3000_fluxo_nivel','Scriptcase','10.0.0.8','access',''),(21703,'2025-10-17 15:59:32','fernanda.taub','grid_DEN_3000_fluxo_nivel','Scriptcase','10.0.0.8','access',''),(21704,'2025-10-17 16:08:16','fernanda.taub','grid_DEN_3000_fluxo_nivel','Scriptcase','10.0.0.8','access',''),(21705,'2025-10-17 16:09:10','fernanda.taub','grid_DEN_3000_fluxo_nivel','Scriptcase','10.0.0.8','access',''),(21706,'2025-10-17 16:09:46','fernanda.taub','grid_DEN_3000_fluxo_nivel','Scriptcase','10.0.0.8','access',''),(21707,'2025-10-17 16:10:47','fernanda.taub','grid_DEN_3000_fluxo_nivel','Scriptcase','10.0.0.8','access',''),(21708,'2025-10-17 16:15:48','fernanda.taub','grid_DEN_3000_fluxo_nivel','Scriptcase','10.0.0.8','access',''),(21709,'2025-10-17 16:16:52','fernanda.taub','grid_DEN_3000_fluxo_nivel','Scriptcase','10.0.0.8','access',''),(21710,'2025-10-17 16:17:29','fernanda.taub','grid_DEN_3000_fluxo_nivel','Scriptcase','10.0.0.8','access',''),(21711,'2025-10-17 16:18:08','fernanda.taub','grid_DEN_3000_fluxo_nivel','Scriptcase','10.0.0.8','access',''),(21712,'2025-10-17 16:18:35','fernanda.taub','grid_DEN_3000_fluxo_nivel','Scriptcase','10.0.0.8','access',''),(21713,'2025-10-17 16:19:47','fernanda.taub','grid_DEN_3000_fluxo_nivel','Scriptcase','10.0.0.8','access',''),(21714,'2025-10-17 16:20:41','fernanda.taub','grid_DEN_3000_fluxo_nivel','Scriptcase','10.0.0.8','access',''),(21715,'2025-10-17 16:25:14','fernanda.taub','grid_DEN_3000_fluxo_nivel','Scriptcase','10.0.0.8','access',''),(21716,'2025-10-17 16:26:21','fernanda.taub','grid_DEN_3000_fluxo_nivel','Scriptcase','10.0.0.8','access',''),(21717,'2025-10-17 16:27:10','fernanda.taub','grid_DEN_3000_fluxo_nivel','Scriptcase','10.0.0.8','access',''),(21718,'2025-10-17 16:33:18','fernanda.taub','grid_DEN_3000_fluxo_nivel','Scriptcase','10.0.0.8','access',''),(21719,'2025-10-17 16:45:38','fernanda.taub','grid_DEN_3000_fluxo_nivel','Scriptcase','10.0.0.8','access',''),(21720,'2025-10-17 16:53:43','fernanda.taub','grid_DEN_3000_fluxo_nivel','Scriptcase','10.0.0.8','access',''),(21721,'2025-10-17 16:54:11','fernanda.taub','grid_DEN_3000_fluxo_nivel','Scriptcase','10.0.0.8','access',''),(21722,'2025-10-17 16:54:52','fernanda.taub','grid_DEN_3000_fluxo_nivel','Scriptcase','10.0.0.8','access',''),(21723,'2025-10-17 16:55:27','fernanda.taub','grid_DEN_3000_fluxo_nivel','Scriptcase','10.0.0.8','access',''),(21724,'2025-10-21 10:24:23','','blank_email','Scriptcase','10.0.0.8','access',''),(21725,'2025-10-22 09:46:42','admin','sub_grid_PAC_1120_fluxo_nivel','Scriptcase','10.0.0.8','access',''),(21726,'2025-10-27 11:40:56','','blank_email','Scriptcase','10.0.0.8','access',''),(21727,'2025-10-27 11:40:59','','blank_email','Scriptcase','10.0.0.8','access',''),(21728,'2025-11-14 15:25:04','Florencio.almeida','menu_dinamico','User','10.0.0.8','login','Logado no sistema com sucesso!'),(21729,'2025-11-14 15:25:04','Florencio.almeida','menu_dinamico','User','10.0.0.8','login Fail','Alguém tentou se logar com o usuário:'),(21730,'2025-11-14 15:25:05','Florencio.almeida','calendar_public_LGPD_4000_atividades','Scriptcase','10.0.0.8','access',''),(21731,'2025-11-14 15:25:20','Florencio.almeida','menu_dinamico','User','10.0.0.8','login','Logado no sistema com sucesso!'),(21732,'2025-11-14 15:25:20','Florencio.almeida','menu_dinamico','User','10.0.0.8','login Fail','Alguém tentou se logar com o usuário:'),(21733,'2025-11-14 15:25:21','Florencio.almeida','calendar_public_LGPD_4000_atividades','Scriptcase','10.0.0.8','access',''),(21734,'2025-11-17 14:12:18','admin','grid_DEN_3000_fluxo_nivel','Scriptcase','10.0.0.8','access',''),(21735,'2025-11-17 14:16:33','admin','grid_DEN_3000_fluxo_nivel','Scriptcase','10.0.0.8','access',''),(21736,'2025-11-25 13:24:58','','blank_email','Scriptcase','10.0.0.8','access',''),(21737,'2025-12-03 12:59:22','bpinheiro','menu_dinamico','User','10.0.0.8','login','Logado no sistema com sucesso!'),(21738,'2025-12-03 12:59:22','bpinheiro','menu_dinamico','User','10.0.0.8','login Fail','Alguém tentou se logar com o usuário:'),(21739,'2025-12-03 12:59:23','bpinheiro','calendar_public_LGPD_4000_atividades','Scriptcase','10.0.0.8','access',''),(21740,'2025-12-03 12:59:31','bpinheiro','menu_dinamico','User','10.0.0.8','login','Logado no sistema com sucesso!'),(21741,'2025-12-03 12:59:31','bpinheiro','menu_dinamico','User','10.0.0.8','login Fail','Alguém tentou se logar com o usuário:'),(21742,'2025-12-03 12:59:32','bpinheiro','calendar_public_LGPD_4000_atividades','Scriptcase','10.0.0.8','access',''),(21743,'2025-12-03 12:59:33','bpinheiro','homepage_help','Scriptcase','10.0.0.8','access',''),(21744,'2025-12-03 12:59:36','bpinheiro','calendar_public_LGPD_4000_atividades','Scriptcase','10.0.0.8','access',''),(21745,'2025-12-10 12:14:54','adilson.taub','sub_grid_PAC_1120_fluxo_nivel','Scriptcase','10.0.0.8','access',''),(21746,'2025-12-10 12:16:11','adilson.taub','sub_grid_PAC_1120_fluxo_nivel','Scriptcase','10.0.0.8','access','');
/*!40000 ALTER TABLE `sc_log` ENABLE KEYS */;
-- UNLOCK TABLES;

--
-- Table structure for table `sec_apps`
--

DROP TABLE IF EXISTS `sec_apps`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sec_apps` (
  `app_name` varchar(128) NOT NULL,
  `app_type` varchar(255) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  `product_acronym` char(10) DEFAULT NULL,
  `label_menu` char(100) DEFAULT NULL,
  `node_menu` int DEFAULT NULL,
  `display_menu` tinyint(1) DEFAULT NULL,
  `node_niv2_menu` int DEFAULT NULL,
  `id_sec_apps` int NOT NULL AUTO_INCREMENT,
  `order_app` int NOT NULL,
  `escopo_app` varchar(45) DEFAULT NULL COMMENT 'Define o escopo da aplicação (LGPD , Compliance ou em branco) , caso esteja em branco atende todos os escopos.',
  PRIMARY KEY (`id_sec_apps`)
) ENGINE=InnoDB AUTO_INCREMENT=413 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sec_apps`
--

-- LOCK TABLES `sec_apps` WRITE;
/*!40000 ALTER TABLE `sec_apps` DISABLE KEYS */;
INSERT INTO `sec_apps` VALUES ('Artefatos','','[Item de menu] - Painel / Artefatos: Acesso à exibição dos principais indicadores sobre Artefatos e Documentos','PCP','Artefatos',1,1,NULL,1,3,'LGPD'),('Atividades','','[Item de menu] - Painel / Atividades e Ações: Acesso à exibição dos principais indicadores sobre Atividades e Ações','PCP','Atividades e Ações',1,1,NULL,2,8,'LGPD'),('Ativos','','[Item de menu] - Painel / Ativos de Informação: Acesso à exibição dos principais indicadores sobre Ativos de Informação','PCP','Ativos de Informação',1,1,NULL,3,2,'LGPD'),('Finalidades','','[Item de menu] - Painel / Finalidades de Tratamento de Dados Pessoais: Acesso à exibição dos principais indicadores sobre Finalidades de Tratamento de Dados Pessoais','PCP','Finalidades de Tratamento de Dados Pessoais',1,1,NULL,4,5,'LGPD'),('Governance_menu','','Menu','PCP',NULL,NULL,NULL,NULL,5,0,NULL),('Metadados','','[Item de menu] - Painel / Metadados Pessoais: Acesso à exibição dos principais indicadores sobre Metadados Pessoais','PCP','Metadados Pessoais',1,1,NULL,6,4,'LGPD'),('PDCA','','[Item de menu] - Painel / Ciclos de PDCA: Acesso à exibição dos principais indicadores sobre Ciclos de PDCA de Compliance','PCP','Ciclos de PDCA',1,1,NULL,7,6,'LGPD'),('Processos','','[Item de menu] - Painel / Processos de Negócio: Acesso à exibição dos principais indicadores sobre Processos de Negócio','PCP','Processos de Negócio',1,1,NULL,8,1,'LGPD'),('Riscos','','[Item de menu] - Painel / Riscos: Acesso à exibição dos principais indicadores sobre Gestão de Riscos de Privacidade e Compliance','PCP','Riscos',1,1,NULL,9,7,'LGPD'),('app_Login','','Login','PCP',NULL,NULL,NULL,NULL,10,0,NULL),('app_change_pswd','','[Item de menu] - Segurança / Alteração de senha: Acesso à gestão de senhas de usuários da plataforma','PCP','Alterar Senha',10,1,NULL,11,2,NULL),('app_form_add_users','form','Cadastrar usuários','PCP',NULL,NULL,NULL,NULL,12,0,NULL),('app_form_edit_users','form','Alterar usuários','PCP',NULL,NULL,NULL,NULL,13,0,NULL),('app_form_sec_apps','form','Cadastrar aplicações','PCP',NULL,NULL,NULL,NULL,14,0,NULL),('app_form_sec_groups_apps','','Associar grupos x aplicações','PCP',NULL,1,NULL,NULL,15,0,NULL),('app_form_sec_groups','form','Cadastro de grupos de usuários','PCP',NULL,NULL,NULL,NULL,16,0,NULL),('app_grid_sec_apps','cons','[Item de menu] - Segurança / Aplicações: Acesso ao cadastro de aplicações da plataforma','PCP','Aplicações',10,1,NULL,17,4,NULL),('app_grid_sec_groups','cons','[Item de menu] - Segurança / Perfis: Acesso ao cadastro de perfis de acesso dos usuários da plataforma','PCP','Perfis',10,1,NULL,18,5,NULL),('app_grid_sec_users_groups','cons','[Item de menu] - Segurança / Associação de usuários a perfis: Acesso à configuração da associação de usuários a perfis de acesso','PCP','Associação de usuários a perfis',10,1,NULL,19,3,NULL),('app_grid_sec_users','cons','[Item de menu] - Segurança / Usuários: Acesso ao cadastro de usuários da plataforma','PCP','Usuários',10,1,NULL,20,1,NULL),('app_menu','','Menu','PCP',NULL,1,NULL,NULL,21,0,NULL),('app_retrieve_pswd','','Esqueceu a senha','PCP',NULL,1,NULL,NULL,22,0,NULL),('app_search_sec_groups','','[Item de menu] - Segurança / Associação de perfis a aplicações: Acesso à configuração da associação de perfis de acesso com as aplicações da plataforma','PCP','Associação de perfis a aplicações',10,1,NULL,23,6,NULL),('app_settings','','Configurações de segurança','PCP','Configurações',10,NULL,NULL,24,7,NULL),('app_sync_apps','','Sincronização de aplicações','PCP','Sincronizar Aplicações',10,NULL,NULL,25,8,NULL),('associar_metadados_finalidade','','Associar metadados na finalidade','PCP',NULL,1,NULL,NULL,26,0,'LGPD'),('blank_email','','Enviar mail','PCP',NULL,1,NULL,NULL,27,0,'LGPD'),('blank_pipeline_Ajax','','Pipeline de atividades','PCP',NULL,1,NULL,NULL,28,0,'LGPD'),('blank_pipeline','','[Item de menu] - Atividades e Ações / Meu Quadro de Atividades: Acesso ao Kanban de atividades do usuário logado','PCP','Meu Quadro de Atividades',9,1,NULL,29,1,'LGPD'),('calendar_public_LGPD_4000_atividades','calendar','Calendário de atividades ( DPO )','PCP',NULL,1,NULL,NULL,30,0,'LGPD'),('chart_public_LGPD_2000_processos_complex','','Gráfico processo por complexidade','PCP',NULL,1,NULL,NULL,31,0,'LGPD'),('chart_public_LGPD_2000_processos_geral','','Gráfico processos','PCP',NULL,1,NULL,NULL,32,0,'LGPD'),('chart_public_LGPD_2000_processos_resp','','Gráfico processos por responsável','PCP',NULL,1,NULL,NULL,33,0,'LGPD'),('chart_public_LGPD_2000_status_processos','','Gráfico processo por status','PCP',NULL,1,NULL,NULL,34,0,'LGPD'),('chart_public_LGPD_2000_tipo_processo','','Gráfico processos por tipo','PCP',NULL,1,NULL,NULL,35,0,'LGPD'),('chart_public_LGPD_2010_confia_ativos','','Gráfico confibilidade dos ativos','PCP',NULL,1,NULL,NULL,36,0,'LGPD'),('chart_public_LGPD_2010_disp_ativos','','Gráfico ativos por nível de disponibilidade','PCP',NULL,1,NULL,NULL,37,0,'LGPD'),('chart_public_LGPD_2010_integridade_ativos','','Gráfico ativos por nível de integridade','PCP',NULL,1,NULL,NULL,38,0,'LGPD'),('chart_public_LGPD_2010_resp_ativos','','Gráfico ativos por responsável','PCP',NULL,1,NULL,NULL,39,0,'LGPD'),('chart_public_LGPD_2010_tipo_ativos','','Gráfico tipos de ativos','PCP',NULL,1,NULL,NULL,40,0,'LGPD'),('chart_public_LGPD_2020_artefat_contrato','','Gráfico artefatos tipo contrato','PCP',NULL,1,NULL,NULL,41,0,'LGPD'),('chart_public_LGPD_2020_contrato_artefatos','','Gráfico contratos x artefatos','PCP',NULL,1,NULL,NULL,42,0,'LGPD'),('chart_public_LGPD_2020_tipo_artefatos','','Gráfico artefatos por tipo','PCP',NULL,1,NULL,NULL,43,0,'LGPD'),('chart_public_LGPD_2030_classif_dados','','Gráfico classificação de metadados','PCP',NULL,1,NULL,NULL,44,0,'LGPD'),('chart_public_LGPD_2030_dados_anonimizavel','','Gráfico metadados anonimizavel','PCP',NULL,1,NULL,NULL,45,0,'LGPD'),('chart_public_LGPD_2030_tipif_dados','','Gráfico tipos de dados','PCP',NULL,1,NULL,NULL,46,0,'LGPD'),('chart_public_LGPD_2070_fin_compart_dados','','Gráfico finalidades por compartilhamento','PCP',NULL,1,NULL,NULL,47,0,'LGPD'),('chart_public_LGPD_2070_fin_dad_criancas','','Gráfico finalidades por dados de crianças','PCP',NULL,1,NULL,NULL,48,0,'LGPD'),('chart_public_LGPD_2070_fin_faz_descarte','','Gráfico finalidades por descarte','PCP',NULL,1,NULL,NULL,49,0,'LGPD'),('chart_public_LGPD_2070_fin_frequencia','','Gráfico finalidades por ferequencia','PCP',NULL,1,NULL,NULL,50,0,'LGPD'),('chart_public_LGPD_2070_fin_hipoteses','','Gráfico finalidades por hipóteses de tratamento','PCP',NULL,1,NULL,NULL,51,0,'LGPD'),('chart_public_LGPD_2070_fin_papel','','Gráfico papel da entidade','PCP',NULL,1,NULL,NULL,52,0,'LGPD'),('chart_public_LGPD_2070_fin_processos','','Gráfico finalidades por processos','PCP',NULL,1,NULL,NULL,53,0,'LGPD'),('chart_public_LGPD_2070_fin_rot_automatizada','','Gráfico finalidades por rotinas automatizadas','PCP',NULL,1,NULL,NULL,54,0,'LGPD'),('chart_public_LGPD_2070_fin_utlz_operador','','Gráfico finalidades por utiliza operador','PCP',NULL,1,NULL,NULL,55,0,'LGPD'),('chart_public_LGPD_2070_fin_volumetria','','Gráfico finliadades por volumetria','PCP',NULL,1,NULL,NULL,56,0,'LGPD'),('chart_public_LGPD_3000_categoria_riscos','','Gráfico riscos por categoria','PCP',NULL,1,NULL,NULL,57,0,'LGPD'),('chart_public_LGPD_3000_criticidade_riscos','','Gráfico riscos por criticidade','PCP',NULL,1,NULL,NULL,58,0,'LGPD'),('chart_public_LGPD_3000_estrategia_riscos','','Gráfico riscos por estratégia','PCP',NULL,1,NULL,NULL,59,0,'LGPD'),('chart_public_LGPD_3000_impacto_riscos','','Gráfico riscos por impacto','PCP',NULL,1,NULL,NULL,60,0,'LGPD'),('chart_public_LGPD_3000_prob_riscos','','Gráfico riscos por probabilidade','PCP',NULL,1,NULL,NULL,61,0,'LGPD'),('chart_public_LGPD_3000_resp_riscos','','Gráfico riscos por responsáveis','PCP',NULL,1,NULL,NULL,62,0,'LGPD'),('chart_public_LGPD_3000_status_riscos','','Gráfico riscos por status','PCP',NULL,1,NULL,NULL,63,0,'LGPD'),('chart_public_LGPD_4000_atividades_geral','','Gráfico atividades','PCP',NULL,1,NULL,NULL,64,0,'LGPD'),('chart_public_LGPD_4000_disc_atividades','','Gráfico atividades por disciplina','PCP',NULL,1,NULL,NULL,65,0,'LGPD'),('chart_public_LGPD_4000_etapa_atividades','','Gráfico atividades por etapas','PCP',NULL,1,NULL,NULL,66,0,'LGPD'),('chart_public_LGPD_4000_resp_atividades','','Gráfico atividades por responsável','PCP',NULL,1,NULL,NULL,67,0,'LGPD'),('chart_public_LGPD_4000_status_resp_atividade','','Gráfico atividades por responsável e status','PCP',NULL,1,NULL,NULL,68,0,'LGPD'),('chart_public_LGPD_assoc_pdca_contr_6500','','Gráfico PDCA de contratos','PCP',NULL,1,NULL,NULL,69,0,'LGPD'),('chart_public_LGPD_assoc_pdca_finalizados_treina_6500','','Gráfico PDCA de treinamentos','PCP',NULL,1,NULL,NULL,70,0,'LGPD'),('chart_public_LGPD_assoc_pdca_medtec_6700','','Gráfico PDCA de medidas técnicas','PCP',NULL,1,NULL,NULL,71,0,'LGPD'),('chart_public_LGPD_assoc_pdca_pol_6300','','Gráfico PDCA de políticas','PCP',NULL,1,NULL,NULL,72,0,'LGPD'),('chart_public_LGPD_assoc_pdca_proc_6600','','Gráfico PDCA de processos','PCP',NULL,1,NULL,NULL,73,0,'LGPD'),('chart_public_LGPD_assoc_pdca_realizar_treina_6500','','Gráfico PDCA realização de treinamentos','PCP',NULL,1,NULL,NULL,74,0,'LGPD'),('chart_public_LGPD_assoc_pdca_risk_6400','','Gráfico PDCA de riscos','PCP',NULL,1,NULL,NULL,75,0,'LGPD'),('control_login','','Login','PCP',NULL,1,NULL,NULL,76,0,NULL),('esqueci_senha','','Esqueceu a senha','PCP',NULL,1,NULL,NULL,77,0,NULL),('extrato_pdca','','Extrato PDCA','PCP',NULL,1,NULL,NULL,78,0,NULL),('form_conf_quest_7100','form','Configurar questionário de fornecedores','PCP',NULL,NULL,NULL,NULL,79,0,'CMP'),('form_kanban_atividades_add_registro','form','Cadastrar atividades pelo kanban','PCP',NULL,NULL,NULL,NULL,80,0,'LGPD'),('form_kanban_atividades','form','Kanban de  atividades','PCP',NULL,NULL,NULL,NULL,81,0,'LGPD'),('form_new_pln_acao','form','Cadastrar plano de ação','PCP',NULL,NULL,NULL,NULL,82,0,'LGPD'),('form_public_LGPD_0100_diagnostico','form','Parametrizar etapa de diagnóstico','PCP',NULL,NULL,NULL,NULL,83,0,'LGPD'),('form_public_LGPD_0200_implement','form','Parametrizar etapa de implementação','PCP',NULL,NULL,NULL,NULL,84,0,'LGPD'),('form_public_LGPD_0300_operacao','form','Parametrizar etapa de operação','PCP',NULL,NULL,NULL,NULL,85,0,'LGPD'),('form_public_LGPD_0400_etapas','form','Parametrizar etapas','PCP',NULL,NULL,NULL,NULL,86,0,'LGPD'),('form_public_LGPD_1000_controlador','form','Cadastro de controlador','PCP',NULL,NULL,NULL,NULL,87,0,NULL),('form_public_LGPD_1001_diretoria','form','Cadastro de diretoria','PCP',NULL,NULL,NULL,NULL,88,0,NULL),('form_public_LGPD_1002_area','form','Cadastro de área','PCP',NULL,NULL,NULL,NULL,89,0,NULL),('form_public_LGPD_1003_departamento','form','Cadastro de departamentos','PCP',NULL,NULL,NULL,NULL,90,0,NULL),('form_public_LGPD_1004_cargos','form','Cadastro de cargos','PCP',NULL,NULL,NULL,NULL,91,0,NULL),('form_public_LGPD_1050_organograma','form','Cadastro de organograma','PCP',NULL,NULL,NULL,NULL,92,0,NULL),('form_public_LGPD_1051_comite','form','Cadastro de comitê','PCP',NULL,NULL,NULL,NULL,93,0,NULL),('form_public_LGPD_1053_eventos_comite','form','Agenda de eventos do comitê','PCP',NULL,NULL,NULL,NULL,94,0,'LGPD'),('form_public_LGPD_1100_equipe_1','form','Cadastro de equipe','PCP',NULL,NULL,NULL,NULL,95,0,NULL),('form_public_LGPD_1100_equipe','form','Cadastro de equipe','PCP',NULL,NULL,NULL,NULL,96,0,NULL),('form_public_LGPD_2000_processos','form','Cadastro de processos','PCP',NULL,NULL,NULL,NULL,97,0,'LGPD'),('form_public_LGPD_2010_ativos','form','Cadastro de ativos','PCP',NULL,NULL,NULL,NULL,98,0,'LGPD'),('form_public_LGPD_2020_artefatos','form','Cadastro de artefatos','PCP',NULL,NULL,NULL,NULL,99,0,'LGPD'),('form_public_LGPD_2030_dados','form','Cadastro de metadados','PCP',NULL,NULL,NULL,NULL,100,0,'LGPD'),('form_public_LGPD_2060_config_assoc','form','Associação artefato x metadados','PCP',NULL,NULL,NULL,NULL,101,0,'LGPD'),('form_public_LGPD_2065_fund_legal','form','Cadastro de fundamentos legais','PCP',NULL,NULL,NULL,NULL,102,0,NULL),('form_public_LGPD_2066_ambiente_reg','form','Cadastro de ambientes regulatórios','PCP',NULL,NULL,NULL,NULL,103,0,NULL),('form_public_LGPD_2070_finalidades','form','Parametrizar finalidades','PCP',NULL,NULL,NULL,NULL,104,0,'LGPD'),('form_public_LGPD_2070_registrar_finalidades','form','Registrar finalidades','PCP',NULL,NULL,NULL,NULL,105,0,'LGPD'),('form_public_LGPD_2075_param_assoc_funcional_fin','form','Associação funcional da finalidade','PCP',NULL,NULL,NULL,NULL,106,0,'LGPD'),('form_public_LGPD_2080_politicas','form','Cadastro de políticas','PCP',NULL,NULL,NULL,NULL,107,0,'LGPD'),('form_public_LGPD_2085_contratos','form','Cadastro de contratos','PCP',NULL,NULL,NULL,NULL,108,0,'LGPD'),('form_public_LGPD_2090_terceiros','form','Cadastro de terceiros','PCP',NULL,NULL,NULL,NULL,109,0,NULL),('form_public_LGPD_2093_ocorr_terc','form','Cadastro de ocorrência de terceiros','PCP',NULL,NULL,NULL,NULL,110,0,NULL),('form_public_LGPD_2095_med_tec','form','Cadastro de medidas técnicas','PCP',NULL,NULL,NULL,NULL,111,0,NULL),('form_public_LGPD_2097_config_assoc_med_atv','form','Associar medidas técnicas aos ativos','PCP',NULL,NULL,NULL,NULL,112,0,'LGPD'),('form_public_LGPD_2100_prz_aprv_proc','form','[Item de menu] - Configurações / SLA de aprovação de Processos de Negócio: Acesso à configuração do prazo limite para aprovação de Processos de Negócio cadastrados','PCP','SLA de aprovação de Processos de Negócio',2,1,NULL,113,6,'LGPD'),('form_public_LGPD_3000_riscos','form','Cadastro de riscos','PCP',NULL,NULL,NULL,NULL,114,0,'LGPD'),('form_public_LGPD_4000_atividades','form','Cadastro de atividades','PCP',NULL,NULL,NULL,NULL,115,0,'LGPD'),('form_public_LGPD_5000_cod_etica','form','Cadastro de código de ética','PCP',NULL,NULL,NULL,NULL,116,0,'LGPD'),('form_public_LGPD_6000_PDCA','form','PDCA','PCP',NULL,NULL,NULL,NULL,118,0,'LGPD'),('form_public_LGPD_6100_catalog_treinamentos','form','Cadastro de catalogo de treinamentos','PCP',NULL,NULL,NULL,NULL,119,0,'LGPD'),('form_public_LGPD_6200_agenda_treina','form','Agenda de treinamentos','PCP',NULL,NULL,NULL,NULL,120,0,'LGPD'),('form_public_LGPD_7300_envio_aval_forne','form','Cadastro de questionários (Due Diligence)','PCP',NULL,NULL,NULL,NULL,121,0,'CMP'),('form_public_LGPD_assoc_contr_6500','form','Associação de contratos','PCP',NULL,NULL,NULL,NULL,122,0,'LGPD'),('form_public_LGPD_assoc_medtec_6700','form','Associação de medidas técnicas','PCP',NULL,NULL,NULL,NULL,123,0,'LGPD'),('form_public_LGPD_assoc_pdca_risk_6400','form','Associação de riscos ao PDCA','PCP',NULL,NULL,NULL,NULL,124,0,'LGPD'),('form_public_LGPD_assoc_pol_6300','form','Associação de políticas','PCP',NULL,NULL,NULL,NULL,125,0,'LGPD'),('form_public_LGPD_assoc_proc_6600','form','Associação de processos','PCP',NULL,NULL,NULL,NULL,126,0,'LGPD'),('form_public_LGPD_assoc_treina_6500','form','Associação de treinamentos','PCP',NULL,NULL,NULL,NULL,127,0,'LGPD'),('form_public_LGPD_config_det_opt_7200','form','Parametrizar opções do questionário de fornecedores','PCP',NULL,NULL,NULL,NULL,128,0,'CMP'),('grid_conf_quest_7100','cons','Cofiguração de questionário para fornecedores','PCP',NULL,1,NULL,NULL,129,0,'CMP'),('grid_kanban_atividades_add_registro','cons','Kanban de  atividades','PCP',NULL,1,NULL,NULL,130,0,'LGPD'),('grid_kanban_atividades','cons','Kanban de  atividades','PCP',NULL,1,NULL,NULL,131,0,'LGPD'),('grid_new_pln_acao','cons','[Item de menu] - Atividades e Ações / Plano de Ação LGPD: Acesso ao cadastro do documento \"Plano de Ação\" de adequação à LGPD','PCP','Plano de Ação LGPD',9,1,NULL,133,4,'LGPD'),('grid_public_LGPD_0100_diagnostico','cons','[Item de menu] - Configurações / Projeto de Diagnóstico da LGPD: Acesso à configuração das informações sobre o projeto de Diagnóstico da LGPD','PCP','Projeto de Diagnóstico da LGPD',2,1,NULL,134,2,'LGPD'),('grid_public_LGPD_0200_implement','cons','[Item de menu] - Configurações / Projeto de Adequação da LGPD: Acesso à configuração das informações sobre o projeto de Adequação da LGPD','PCP','Projeto de Adequação da LGPD',2,1,NULL,135,3,'LGPD'),('grid_public_LGPD_0300_operacao','cons','[Item de menu] - Configurações / Projeto de Operação da LGPD: Acesso à configuração das informações sobre a fase de Operação da LGPD','PCP','Projeto de Operação da LGPD',2,1,NULL,136,4,'LGPD'),('grid_public_LGPD_0400_etapas','cons','[Item de menu] - Configurações / Etapas do Diagnóstico da LGPD: Acesso à configuração das etapas do projeto de Diagnóstico de um projeto de adequação à LGPD','PCP','Etapas do Diagnóstico da LGPD',2,1,NULL,137,5,'LGPD'),('grid_public_LGPD_1000_controlador','cons','[Item de menu] - Configurações / Entidade: Acesso à configuração dos dados da entidade','PCP','Entidade',2,1,NULL,138,1,NULL),('grid_public_LGPD_1001_diretoria','cons','[Item de menu] - Estrutura Organizacional / Diretoria: Acesso ao cadastro de Diretorias, que é o nível mais alto da hierarquia organizacional da entidade','PCP','Diretoria',4,1,NULL,139,1,NULL),('grid_public_LGPD_1002_area','cons','[Item de menu] - Estrutura Organizacional / Área: Acesso ao cadastro de Áreas, que dividem uma determinada Diretoria na estrutura hierárquica da entidade','PCP','Área',4,1,NULL,140,2,NULL),('grid_public_LGPD_1003_departamento','cons','[Item de menu] - Estrutura Organizacional / Departamentos: Acesso ao cadastro de Departamentos, que dividem uma determinada Área na estrutura hierárquica da entidade','PCP','Departamentos',4,1,NULL,141,3,NULL),('grid_public_LGPD_1004_cargos','cons','[Item de menu] - Estrutura Organizacional / Cargos: Acesso ao cadastro de Cargos a serem ocupados por pessoas da equipe que ocupem espaço na estrutura hierárquica da entidade','PCP','Cargos',4,1,NULL,142,4,NULL),('grid_public_LGPD_1050_organograma','cons','[Item de menu] - Estrutura Organizacional / Lotação: Acesso ao cadastro de unidades de trabalho, onde é possível alocar as equipes da entidade','PCP','Lotação',4,1,NULL,143,5,NULL),('grid_public_LGPD_1051_comite','cons','[Item de menu] - Estrutura Organizacional / Comitês: Acesso ao cadastro de comitês da entidade, que congregam uma ou mais pessoas previamente cadastradas','PCP','Comitês',4,1,NULL,144,7,'LGPD'),('grid_public_LGPD_1053_eventos_comite','cons','[Item de menu] - Atividades e Ações / Eventos de Comitê: Acesso ao cadastro de eventos associados aos Comitês da entidade','PCP','Eventos de Comitê',9,1,NULL,145,7,'LGPD'),('grid_public_LGPD_1053_sub_eventos_comite','cons','Sub Consulta de Eventos','PCP',NULL,1,NULL,NULL,146,0,'LGPD'),('grid_public_LGPD_1100_equipe','cons','[Item de menu] - Estrutura Organizacional / Equipe: Acesso ao cadastro de pessoas que podem ocupar cargos na estrutura hierárquica da entidade. Essas pessoas serão associadas a diversas outras entidades tratadas na plataforma','PCP','Equipe',4,1,NULL,147,6,NULL),('grid_public_LGPD_2000_proc_aprv_prz_expirado','cons','[Item de menu] - Atividades e Ações / Processos de Negócio Pendentes: Acesso à gestão de Processos de Negócio com SLA de aprovação expirado','PCP','Processos de Negócio Pendentes',9,1,NULL,148,5,'LGPD'),('grid_public_LGPD_2000_processos','cons','[Item de menu] - Fluxo de Informação / Processos de Negócio: Acesso ao cadastro de Processos de Negócio que definem as rotinas operacionais da entidade','PCP','Processos de Negócio',5,1,NULL,149,1,'LGPD'),('grid_public_LGPD_2000_sub_proc_pessoa','cons','Consulta processo por responsável','PCP',NULL,1,NULL,NULL,150,0,'LGPD'),('grid_public_LGPD_2000_sub_processos_atv','cons','Consulta processos por ativos','PCP',NULL,1,NULL,NULL,151,0,'LGPD'),('grid_public_LGPD_2010_ativos_1','cons','Consulta Ativos','PCP',NULL,1,NULL,NULL,152,0,'LGPD'),('grid_public_LGPD_2010_ativos','cons','[Item de menu] - Fluxo de Informação / Ativos de Informação: Acesso ao cadastro de Ativos de Informação utilizados pela entidade na execução de seus Processos de Negócio','PCP','Ativos de Informação',5,1,NULL,153,2,'LGPD'),('grid_public_LGPD_2010_ativos_n_utlz_fin','cons','Processos disponivel para associação com finalidades','PCP',NULL,1,NULL,NULL,154,0,'LGPD'),('grid_public_LGPD_2010_ativos_utlz_fin','cons','Processos associados a finalidade','PCP',NULL,1,NULL,NULL,155,0,'LGPD'),('grid_public_LGPD_2010_sub_ativos','cons','Sub Consulta de Ativos','PCP',NULL,1,NULL,NULL,156,0,'LGPD'),('grid_public_LGPD_2020_artefatos','cons','[Item de menu] - Fluxo de Informação / Artefatos: Acesso ao cadastro de Artefatos e Documentos tratados nos Ativos de Informação utilizados pela entidade','PCP','Artefatos',5,1,NULL,157,3,'LGPD'),('grid_public_LGPD_2020_artefatos_n_utlz_fin','cons','Artefatos disponiveis para associação com finalidades','PCP',NULL,1,NULL,NULL,158,0,'LGPD'),('grid_public_LGPD_2020_artefatos_utlz_fin','cons','Artefatos associados a finalidades','PCP',NULL,1,NULL,NULL,159,0,'LGPD'),('grid_public_LGPD_2030_assoc_art_metadados','cons','Associação de Artefatos e metadados','PCP',NULL,1,NULL,NULL,160,0,'LGPD'),('grid_public_LGPD_2030_dados','cons','[Item de menu] - Fluxo de Informação / Metadados Pessoais: Acesso ao cadastro de Metadados Pessoais presentes nos diferentes Artefatos utilizados pela entidade','PCP','Metadados Pessoais',5,1,NULL,161,4,'LGPD'),('grid_public_LGPD_2065_fund_legal','cons','[Item de menu] - Aspectos Jurídicos / Fundamentos Legais: Acesso ao cadastro de Fundamentos Legais utilizados pela entidade','PCP','Fundamentos Legais',14,1,NULL,162,4,NULL),('grid_public_LGPD_2066_ambiente_reg','cons','[Item de menu] - Aspectos Jurídicos / Ambientes regulatórios: Acesso ao cadastro de Ambientes Regulatórios a serem associados a Fundamentos Legais utilizados pela entidade','PCP','Ambientes regulatórios',14,1,NULL,163,5,NULL),('grid_public_LGPD_2070_finalidades','cons','[Item de menu] - Tratamento de Dados Pessoais / Parametrizar Finalidades de Tratamentos: Acesso à configuração dos aspectos e detalhes das Finalidades de Tratamento de Dados Pessoais previamente cadastradas','PCP','Parametrizar Finalidades de Tratamentos',6,1,NULL,164,2,'LGPD'),('grid_public_LGPD_2070_registrar_finalidades','cons','[Item de menu] - Tratamento de Dados Pessoais / Registrar Finalidade de Tratamento: Acesso ao cadastro de Finalidades de Tratamento de Dados Pessoais executadas pela entidade','PCP','Registrar Finalidade de Tratamento',6,1,NULL,165,1,'LGPD'),('grid_public_LGPD_2070_sub_contratos_finalidades','cons','Sub consulta de contratos dentro da finalidade','PCP',NULL,1,NULL,NULL,166,0,'LGPD'),('grid_public_LGPD_2070_sub_finalidades','cons','Sub consulta de finalidades','PCP',NULL,1,NULL,NULL,167,0,'LGPD'),('grid_public_LGPD_2073_assoc_ativos_fin','cons','Associação de ativos na finalidade','PCP',NULL,1,NULL,NULL,168,0,'LGPD'),('grid_public_LGPD_2075_assoc_metadados_fin','cons','Associação de metadados na finalidade','PCP',NULL,1,NULL,NULL,169,0,'LGPD'),('grid_public_LGPD_2080_politicas','cons','[Item de menu] - Políticas e Regulamentos / Políticas: Acesso ao cadastro de políticas associadas à Governança de Privacidade da entidade','PCP','Políticas',7,1,NULL,170,1,'LGPD'),('grid_public_LGPD_2085_contratos','cons','[Item de menu] - Políticas e Regulamentos / Contratos: Acesso ao cadastro de contratos e modelos de contratos utilizados pela entidade','PCP','Contratos',7,1,NULL,171,2,'LGPD'),('grid_public_LGPD_2090_terceiros','cons','[Item de menu] - Gestão de terceiros / Terceiros: Acesso ao cadastro de entidades terceiras (PJ ou PF) associadas à entidade','PCP','Terceiros',13,1,NULL,172,1,NULL),('grid_public_LGPD_2093_ocorr_terc','cons','[Item de menu] - Gestão de terceiros / Ocorrências: Acesso ao cadastro de ocorrências relacionadas à Terceiros associados à entidade','PCP','Ocorrências',13,1,NULL,173,2,NULL),('grid_public_LGPD_2095_med_tec','cons','[Item de menu] - Medidas Técnicas de Segurança / Medidas Técnicas de Segurança: Acesso ao cadastro de Medidas Técnicas de Segurança da Informação que podem ser associadas a Ativos cadastrados','PCP','Medidas Técnicas de Segurança',8,1,NULL,174,1,'LGPD'),('grid_public_LGPD_2095_sub_med_tec','cons','Sub Consulta de medidas técnicas','PCP',NULL,1,NULL,NULL,175,0,'LGPD'),('grid_public_LGPD_3000_riscos','cons','[Item de menu] - Riscos / Riscos: Acesso ao cadastro de Riscos de Privacidade e Compliance','PCP','Riscos',11,1,NULL,176,1,'LGPD'),('grid_public_LGPD_3000_sub_consulta_riscos','cons','Sub consulta de riscos','PCP',NULL,1,NULL,NULL,177,0,'LGPD'),('grid_public_LGPD_3300_assoc_risc_prc','cons','Associar risco a processos','PCP',NULL,1,NULL,NULL,178,0,'LGPD'),('grid_public_LGPD_4000_atividades','cons','[Item de menu] - Atividades e Ações / Atividades e Ações: Acesso ao cadastro de atividades e ações de governança e compliance','PCP','Atividades e Ações',9,1,NULL,179,2,'LGPD'),('grid_public_LGPD_5000_cod_etica','cons','[Item de menu] - Políticas e Regulamentos / Códigos e Regulamentos Internos: Acesso ao cadastro de documentos que definem as regras internas de Compliance da entidade','PCP','Códigos e Regulamentos Internos',7,1,NULL,180,3,'LGPD'),('grid_public_LGPD_6000_PDCA','cons','[Item de menu] - Atividades e Ações / Gestão de ciclo de PDCA de Compliance: Acesso ao planejamento e gestão de ciclos de PDCA de Compliance','PCP','Gestão de ciclo de PDCA de Compliance',9,1,NULL,182,6,'CMP'),('grid_public_LGPD_6000_SUB_PDCA','cons','Sub consulta PDCA','PCP',NULL,1,NULL,NULL,183,0,'LGPD'),('grid_public_LGPD_6100_catalog_treinamentos','cons','[Item de menu] - Atividades e Ações / Catálogo de treinamentos: Acesso ao cadastro dos tipos de treinamentos que a entidade pode executar para suas equipes','PCP','Catálogo de treinamentos',9,1,NULL,184,9,'LGPD'),('grid_public_LGPD_6200_agenda_treina','cons','[Item de menu] - Atividades e Ações / Agenda de Treinamentos: Acesso à gestão de agenda de treinamentos e capacitações internas da entidade','PCP','Agenda de Treinamentos',9,1,NULL,185,8,'LGPD'),('grid_public_LGPD_7300_envio_aval_forne','cons','Consulta de questionários (Due Diligence)','PCP',NULL,1,NULL,NULL,186,0,'CMP'),('grid_public_LGPD_cons_rev_contr_6500','cons','Consulta revisões de contrato','PCP',NULL,1,NULL,NULL,187,0,'LGPD'),('grid_public_LGPD_cons_rev_medtec_6700','cons','Consulta revisões de medidas técnicas','PCP',NULL,1,NULL,NULL,188,0,'LGPD'),('grid_public_LGPD_cons_rev_pol_6300','cons','Consulta revisão de políticas','PCP',NULL,1,NULL,NULL,189,0,'LGPD'),('grid_public_LGPD_cons_rev_proc_6600','cons','Consulta revisão de processos','PCP',NULL,1,NULL,NULL,190,0,'LGPD'),('grid_public_LGPD_cons_rev_risk_6400','cons','Consulta revisão de riscos','PCP',NULL,1,NULL,NULL,191,0,'LGPD'),('grid_public_subconsulta_sec_users','cons','Sub consulta de usuarios','PCP',NULL,1,NULL,NULL,192,0,'LGPD'),('homepage','','Home Page (Responsábilidades e Atividades)','PCP',NULL,1,NULL,NULL,193,0,NULL),('menu','','Menu PCP','PCP',NULL,1,NULL,NULL,194,0,NULL),('param_aval_mestre_7000','','[Item de menu] - Gestão de terceiros / Formulários de due diligence: Acesso à criação de formulários (e suas questões) para auto avaliação de terceiros','PCP','Formulários de due diligence',13,1,NULL,195,8,'CMP'),('relatorio_finalidades','','Relatório de finalidades','PCP',NULL,1,NULL,NULL,196,0,'LGPD'),('resumo_finalidade','','Resumo de finalidade','PCP',NULL,1,NULL,NULL,197,0,'LGPD'),('risk_heat_map','','[Item de menu] - Riscos / Mapa de Calor: Acesso à exibição do Mapa de Calor dos Riscos cadastrados','PCP','Mapa de Calor',11,1,NULL,198,3,'LGPD'),('search_public_LGPD_4000_atividades','','Filtro de atividades','PCP',NULL,1,NULL,NULL,199,0,'LGPD'),('sub_consulta_configurar_metadados','','Sub consulta configuração de metadados','PCP',NULL,1,NULL,NULL,200,0,'LGPD'),('sub_form_configurar_metados','','Configurar metadados','PCP',NULL,1,NULL,NULL,201,0,'LGPD'),('sub_grid_public_LGPD_2093_ocorr_terc','','Sub consulta ocorrência de terceiros','PCP',NULL,1,NULL,NULL,202,0,'LGPD'),('associar_metadados_finalidade_new','','Associar metadados a finalidades','PCP',NULL,1,NULL,NULL,203,0,'LGPD'),('help_ciclo_de_vida','','Help Ciclo de vida','PCP',NULL,1,NULL,NULL,204,0,NULL),('help_finalidades_fundamentos','','Help Finalidades','PCP',NULL,1,NULL,NULL,205,0,NULL),('help_medidas_administrativas','','Help medidas administrativas','PCP',NULL,1,NULL,NULL,206,0,NULL),('help_medidas_tecnicas','','Help para medidas técnicas','PCP',NULL,1,NULL,NULL,207,0,NULL),('help_plano_acao_atividades','','Help Atividades','PCP',NULL,1,NULL,NULL,208,0,NULL),('help_riscos_e_impactos','','Help Riscos','PCP',NULL,1,NULL,NULL,209,0,NULL),('homepage_help','','Help','PCP',NULL,1,NULL,NULL,210,0,NULL),('Auto_cadastro_PAC_4000_notificacao','','Auto cadastro de notificaÃ§Ã£o','PAC',NULL,NULL,NULL,NULL,211,0,'LGPD'),('Cadastro_DEN_1000_registro','form','Cadastro de denÃºncias ','PAC',NULL,NULL,NULL,NULL,212,0,'CMP'),('Cadastro_DEN_1100_cat','form','Cadastro de categorias de denÃºncias','PAC',NULL,NULL,NULL,NULL,213,0,'CMP'),('Cadastro_PAC_1400_titulares','form','Cadastro de Titulares ','PAC',NULL,NULL,NULL,NULL,214,0,'LGPD'),('Cadastro_PAC_1410_dados_tit','form','Cadastro de dados de titulares','PAC',NULL,NULL,NULL,NULL,215,0,'LGPD'),('Cadastro_PAC_2000_incidentes','form','Cadastro de incidentes','PAC',NULL,NULL,NULL,NULL,216,0,'LGPD'),('Cadastro_PAC_2100_sla_notificacao','form','Cadastro de SLA de notificaÃ§Ãµes','PAC',NULL,NULL,NULL,NULL,217,0,'LGPD'),('Cadastro_PAC_3100_env_consent','form','Cadastro de envio de consentimento','PAC',NULL,NULL,NULL,NULL,218,0,'LGPD'),('Cadastro_PAC_4000_notificacao','form','Cadastro de notificaÃ§ao manual','PAC',NULL,NULL,NULL,NULL,219,0,'LGPD'),('Consulta_DEN_1000_registro','cons','Consulta registro de denÃºncias','PAC','Denúncias',17,1,NULL,220,1,'CMP'),('Consulta_DEN_1100_cat','cons','Consulta categorias de denÃºncias','PAC','Configuração',17,1,NULL,221,2,'CMP'),('Consulta_PAC_1000_user_portal','cons','Consulta usuarios do portal de titular','PAC','Usuários',16,1,NULL,222,1,'LGPD'),('Consulta_PAC_1100_sol_portal','cons','Consulta solicitaÃ§Ãµes do portal do titular ','PAC','Solicitações',16,1,NULL,223,2,'LGPD'),('Consulta_PAC_1400_titulares','cons','Consulta titulares','PAC','Cadastro',18,1,NULL,224,0,'LGPD'),('Consulta_PAC_1410_dados_tit','cons','Consulta dados dos titulares','PAC',NULL,NULL,NULL,NULL,225,0,'LGPD'),('Consulta_PAC_2000_incidentes','cons','Consulta incidentes','PAC','Registros',19,1,NULL,226,1,'LGPD'),('Consulta_PAC_3100_env_consent','cons','Consulta envios de consentimentos ','PAC','Registros',21,1,NULL,227,0,'LGPD'),('Consulta_PAC_4000_notificacao','cons','Consulta notificaÃ§Ãµes','PAC','Registros',20,1,NULL,228,0,'LGPD'),('Consulta_public_LGPD_3000_riscos','cons','Consulta Riscos ','PAC','Riscos',19,1,NULL,229,2,'LGPD'),('Menu_Pac','','Menu','PAC',NULL,NULL,NULL,NULL,230,0,NULL),('pac_app_Login','','Login','PAC',NULL,NULL,NULL,NULL,231,0,NULL),('Cadastro_PAG_lote_1000','form','Cadastro de lotes','PAG',NULL,NULL,NULL,NULL,232,0,'LGPD'),('Consulta_LGPD_3000_riscos_assistant','cons','Consulta riscos gerados ','PAG',NULL,NULL,NULL,NULL,233,0,'LGPD'),('Consulta_LGPD_4000_atividades_assistant','cons','Consulta atividades geradas ','PAG',NULL,NULL,NULL,NULL,234,0,'LGPD'),('Consulta_PAG_lote_1000','cons','Consulta lotes ','PAG',NULL,NULL,NULL,NULL,235,0,'LGPD'),('PAG_menu','','Menu','PAG',NULL,NULL,NULL,NULL,236,0,NULL),('cadastro_PAG_ocorr_lote_1100','form','Cadastro de ocorrencias por lote','PAG',NULL,NULL,NULL,NULL,237,0,'LGPD'),('novo_menu','','Menu','PAG',NULL,NULL,NULL,NULL,238,0,NULL),('sec_Login','','Login','PAG',NULL,NULL,NULL,NULL,239,0,NULL),('sec_change_pswd','','Alterar senha','PAG',NULL,NULL,NULL,NULL,240,0,NULL),('sec_form_add_users','','Cadastrar usuários','PAG',NULL,NULL,NULL,NULL,241,0,NULL),('sec_form_edit_users','','Alterar usuários','PAG',NULL,NULL,NULL,NULL,242,0,NULL),('sec_form_sec_apps','','Cadastro de aplicações','PAG',NULL,NULL,NULL,NULL,243,0,NULL),('sec_form_sec_groups_apps','','Associação de grupos com aplicações','PAG',NULL,NULL,NULL,NULL,244,0,NULL),('sec_form_sec_groups','','Cadastro de perfis de usuários','PAG',NULL,NULL,NULL,NULL,245,0,NULL),('sec_grid_sec_apps','','Consulta aplicações','PAG',NULL,NULL,NULL,NULL,246,0,NULL),('sec_grid_sec_groups','','Consulta grupos de usuários','PAG',NULL,NULL,NULL,NULL,247,0,NULL),('sec_grid_sec_users_groups','','Consulta associação usuarios x grupos','PAG',NULL,NULL,NULL,NULL,248,0,NULL),('sec_grid_sec_users','','Consulta usuários','PAG',NULL,NULL,NULL,NULL,249,0,NULL),('sec_menu','','Menu','PAG',NULL,NULL,NULL,NULL,250,0,NULL),('sec_retrieve_pswd','','Alterar senha','PAG',NULL,NULL,NULL,NULL,251,0,NULL),('sec_search_sec_groups','','Filtro de perfis','PAG',NULL,NULL,NULL,NULL,252,0,NULL),('sec_settings','','Configurações de segurança','PAG',NULL,NULL,NULL,NULL,253,0,NULL),('sec_sync_apps','','Sincronização de aplicações','PAG',NULL,NULL,NULL,NULL,254,0,NULL),('sub_consulta_PAG_ocorr_lote_1100','','Sub consulta de lotes','PAG',NULL,NULL,NULL,NULL,255,0,'LGPD'),('help_geracao_atividades','','Help geração de atividades','PAG',NULL,NULL,NULL,NULL,256,0,NULL),('help_geracao_riscos','','Help geração de riscos','PAG',NULL,NULL,NULL,NULL,257,0,NULL),('help_lotes_validacao','','Help lotes de validação','PAG',NULL,NULL,NULL,NULL,258,0,NULL),('homepage_help','','Help','PAG',NULL,NULL,NULL,NULL,259,0,NULL),('pac_app_change_pswd','','[Item de menu] - SeguranÃ§a / AlteraÃ§Ã£o de senha: Acesso Ã  gestÃ£o de senhas de usuÃ¡rios da plataforma','PAC','Alterar Senha',23,1,NULL,260,2,NULL),('pac_app_form_add_users','form','Cadastrar usuÃ¡rios','PAC',NULL,NULL,NULL,NULL,261,0,NULL),('pac_app_form_edit_users','form','Alterar usuÃ¡rios','PAC',NULL,NULL,NULL,NULL,262,0,NULL),('pac_app_form_sec_apps','form','Cadastrar aplicaÃ§Ãµes','PAC',NULL,NULL,NULL,NULL,263,0,NULL),('pac_app_form_sec_groups_apps','','Associar grupos x aplicaÃ§Ãµes','PAC',NULL,NULL,NULL,NULL,264,0,NULL),('pac_app_form_sec_groups','form','Cadastro de grupos de usuÃ¡rios','PAC',NULL,NULL,NULL,NULL,265,0,NULL),('pac_app_grid_sec_apps','cons','[Item de menu] - SeguranÃ§a / AplicaÃ§Ãµes: Acesso ao cadastro de aplicaÃ§Ãµes da plataforma','PAC','Aplicações',23,1,NULL,266,4,NULL),('pac_app_grid_sec_groups','cons','[Item de menu] - SeguranÃ§a / Perfis: Acesso ao cadastro de perfis de acesso dos usuÃ¡rios da plataforma','PAC','Perfis',23,1,NULL,267,5,NULL),('pac_app_grid_sec_users_groups','cons','[Item de menu] - SeguranÃ§a / AssociaÃ§Ã£o de usuÃ¡rios a perfis: Acesso Ã  configuraÃ§Ã£o da associaÃ§Ã£o de usuÃ¡rios a perfis de acesso','PAC','Associação de usuários a perfis',23,1,NULL,268,3,NULL),('cadastro_PAC_1110_atv_sol','form','Cadastro de Atividades','PAC',NULL,NULL,NULL,NULL,269,0,'LGPD'),('cadastro_PAC_1200_sla_sol_portal','form','Cadastro de SLA de atividades','PAC',NULL,NULL,NULL,NULL,270,0,'LGPD'),('consulta_PAC_1200_sla_sol_portal','cons','Consulta SLA de atividades','PAC','Configurações',16,1,NULL,271,3,'LGPD'),('form_PAC_1100_sol_portal','form','Cadastro de solicitaÃ§Ãµes','PAC',NULL,NULL,NULL,NULL,272,0,'LGPD'),('form_public_PAC_1000_user_portal','form','Casatro de usuario do portal','PAC',NULL,NULL,NULL,NULL,273,0,'LGPD'),('grid_public_PAC_9000_DPIA','cons','Consulta DPIA','PAC','Relatório DPIA',22,1,NULL,274,1,'LGPD'),('grid_public_PAC_9100_LIA','cons','Consulta LIA ','PAC','Relatório LIA',22,1,NULL,275,2,'LGPD'),('pac_menu','','Menu ','PAC',NULL,NULL,NULL,NULL,276,0,NULL),('relatorio_dpia_1','','RelatÃ³rio DPIA','PAC',NULL,NULL,NULL,NULL,277,0,'LGPD'),('relatorio_dpia','','RelatÃ³rio DPIA','PAC',NULL,NULL,NULL,NULL,278,0,'LGPD'),('relatorio_lia','','Relatório LIA','PAC',NULL,NULL,NULL,NULL,279,0,'LGPD'),('relatorio_notificacao','','RelatÃ³rio de notificaÃ§Ã£o','PAC',NULL,NULL,NULL,NULL,280,0,'LGPD'),('sub_consulta_3000_riscos_incidente','','Sub consulta de riscos','PAC',NULL,NULL,NULL,NULL,281,0,'LGPD'),('sub_consulta_3100_assoc_risc_atv','','Sub consulta Riscos x Ativos','PAC',NULL,NULL,NULL,NULL,282,0,'LGPD'),('sub_consulta_3300_assoc_risc_prc','','Sub consulta Riscos x Processos','PAC',NULL,NULL,NULL,NULL,283,0,'LGPD'),('sub_consulta_3400_assoc_risc_fin','','Sub consulta Riscos x Finalidades','PAC',NULL,NULL,NULL,NULL,284,0,'LGPD'),('sub_consulta_PAC_1100_sol_portal','','Sub consulta solicitaÃ§Ãµes do portal','PAC',NULL,NULL,NULL,NULL,285,0,'LGPD'),('sub_consulta_PAC_3200_tit_consent','','Sub consulta consentimentos ','PAC',NULL,NULL,NULL,NULL,286,0,'LGPD'),('sub_consulta_PAC_4000_notificacao','','Sub consulta de notificaÃ§Ãµes ','PAC',NULL,NULL,NULL,NULL,287,0,'LGPD'),('sub_grid_PAC_1400_tit_afet_inc','','Sub consulta titulares afetados no incidente','PAC',NULL,NULL,NULL,NULL,288,0,'LGPD'),('help_cadastro_titulares','','Help cadastro de titulares','PAC',NULL,NULL,NULL,NULL,289,0,NULL),('help_gestao_consentimentos','','Help gestÃ£o de consentimentos','PAC',NULL,NULL,NULL,NULL,290,0,NULL),('help_gestao_incidentes','','Help gestÃ£o de incidentes','PAC',NULL,NULL,NULL,NULL,291,0,NULL),('help_gestao_notificacao','','Help gestÃ£o de notificaÃ§Ã£o','PAC',NULL,NULL,NULL,NULL,292,0,NULL),('help_integracao_portais','','Help integraÃ§Ã£o de portais','PAC',NULL,NULL,NULL,NULL,293,0,NULL),('help_relatorios','','Help relatÃ³rios','PAC',NULL,NULL,NULL,NULL,294,0,NULL),('form_LGPD_0002_conf_smpt','form','[Item de menu] - Configurações / Configuração de envio de e-mails: Acesso à configuração do endereço de de SMTP para envio de e-mails da plataforma','PCP','Configuração de envio de e-mails',2,1,NULL,295,7,NULL),('grid_LGPD_2075_assoc_funcional_dados_fin','cons','Consulta associação de metadados','PCP',NULL,1,NULL,NULL,296,0,'LGPD'),('grid_LGPD_7400_resp_aval_forne','cons','Consulta respostas de questionários  (Due Diligence)','PCP',NULL,1,NULL,NULL,297,0,'CMP'),('pdfreport_LGPD_7300_envio_aval_forne','','geração de PDF - questionário (Due Diligence)','PCP',NULL,1,NULL,NULL,298,0,'CMP'),('relatorio_resp_aval','','Relatório Avaliações','PCP',NULL,1,NULL,NULL,299,0,'CMP'),('control_login_diligence','',NULL,'portal',NULL,1,NULL,NULL,302,0,NULL),('form_CMP_1000_mecanismos','form','Cadastro de mecanismos de auditoria ','PCP',NULL,NULL,NULL,NULL,303,0,'CMP'),('form_CMP_1100_componentes','form','Cadastro de componentes de auditoria','PCP',NULL,NULL,NULL,NULL,304,0,'CMP'),('form_CMP_1200_questoes','form','Cadastro de questões de auditoria','PCP',NULL,NULL,NULL,NULL,305,0,'CMP'),('form_CMP_1300_formularios','form','Cadatro de formulários de auditoria ','PCP',NULL,NULL,NULL,NULL,306,0,'CMP'),('form_CMP_1300_formularios_edit','form','Edição de formulários de auditoria','PCP',NULL,NULL,NULL,NULL,307,0,'CMP'),('form_CMP_1500_acao','form','Recomendações de auditorias','PCP',NULL,NULL,NULL,NULL,308,0,'CMP'),('form_diligence','',NULL,'portal',NULL,1,NULL,NULL,309,0,NULL),('grid_CMP_1000_mecanismos','cons','[Item de menu] - Pilares do Compliance / Mecanismos de Auditoria: Acesso ao cadastro de Mecanismos de Auditoria para projetos de Compliance','PCP','Mecanismos de Auditoria',15,1,NULL,310,1,'CMP'),('grid_CMP_1100_componentes','cons','[Item de menu] - Pilares do Compliance / Componentes de Auditoria: Acesso ao cadastro de Componentes de Auditoria, que compõem os Mecanismos cadastrados','PCP','Componentes de Auditoria',15,1,NULL,311,2,'CMP'),('grid_CMP_1200_questoes','cons','[Item de menu] - Pilares do Compliance / Questões de Auditoria: Acesso ao cadastro de perguntas que são utilizadas para a realização de auditorias de Compliance','PCP','Questões de Auditoria',15,1,NULL,312,3,'CMP'),('grid_CMP_1300_formularios','cons','[Item de menu] - Pilares do Compliance / Formulários de Auditoria: Acesso ao cadastro e configuração de Formulários compostos por perguntas para a realização de auditorias de Compliance','PCP','Formulários de Auditoria',15,1,NULL,313,4,'CMP'),('grid_CMP_1310_formulario_det','cons','Consulta detalhes do formulário de auditoria ','PCP',NULL,1,NULL,NULL,314,0,'CMP'),('grid_CMP_1500_acao','cons','[Item de menu] - Pilares do Compliance / Ações de Auditoria: Acesso ao cadastro de ações pré-determinadas para serem sugeridas a partir do levantamento de determinada Questão cadastrada','PCP','Ações de Auditoria',15,1,NULL,315,5,'CMP'),('form_CMP_1400_formulas_mestre','form','Parametrização de Setup de Auditoria','PCP',NULL,NULL,NULL,NULL,316,0,'CMP'),('form_CMP_1400_formulas_view','form','Visualizar setup de auditoria','PCP',NULL,NULL,NULL,NULL,317,0,'CMP'),('form_CMP_1410_formulas_det_mec','form','Parametrizar mecanismos de auditoria no setup','PCP',NULL,NULL,NULL,NULL,318,0,'CMP'),('form_CMP_1420_formulas_det_niv_ad','form','Parametrizar níveis de aderência do setup de auditoria ','PCP',NULL,NULL,NULL,NULL,319,0,'CMP'),('form_CMP_1430_formulas_det_lim','form','Parametrizar faixas do setup de auditoria','PCP',NULL,NULL,NULL,NULL,320,0,'CMP'),('grid_CMP_0100_faixas','cons','Consultar faixas de setup de auditoria','PCP',NULL,1,NULL,NULL,321,0,'CMP'),('grid_CMP_1400_formulas_mestre','cons','[Item de menu] - Pilares do Compliance / Parâmetros de Ciclos de Auditoria: Acesso à configuração de parâmetros quantitativos utilizados nos Ciclos de Auditoria de Compliance','PCP','Parâmetros de Ciclos de Auditoria',15,1,NULL,322,6,'CMP'),('grid_CMP_1410_formulas_det_mec','cons','Sub Consulta mecanismos do setup de auditoria','PCP',NULL,1,NULL,NULL,323,0,'CMP'),('form_CMP_2000_ciclos','form','Cadastro de ciclos de auditoria','PCP',NULL,NULL,NULL,NULL,324,0,'CMP'),('form_CMP_2500_conf_entrevistados','form','Cadastro de entrevistados do ciclo de auditoria ','PCP',NULL,NULL,NULL,NULL,325,0,'CMP'),('form_CMP_2500_conf_param_entrevistados','form','Parametrizar relação de entrevistados de um ciclo de auditoria','PCP',NULL,NULL,NULL,NULL,326,0,'CMP'),('grid_CMP_1100_entrevistados_desassociados','cons','Consultas candidatos a entrevistas de ciclo de auditoria ','PCP',NULL,1,NULL,NULL,327,0,'CMP'),('grid_CMP_2000_ciclos','cons','[Item de menu] - Auditoria de Compliance / Ciclos de Auditoria: Acesso à gestão de Ciclos de Auditoria de Compliance','PCP','Ciclos de Auditoria',3,1,NULL,328,1,'CMP'),('grid_CMP_2500_conf_entrevistados','cons','[Item de menu] - Auditoria de Compliance / Entrevistados: Acesso à seleção de entrevistados que estarão associados a um Ciclo de Auditoria de Compliance','PCP','Entrevistados',3,1,NULL,329,2,'CMP'),('grid_CMP_2510_entrevistados_associados','cons','Relação de entrevistados de um ciclo de auditoria','PCP',NULL,1,NULL,NULL,330,0,'CMP'),('grid_CMP_3000_aplic_pesq','cons','[Item de menu] - Auditoria de Compliance / Pesquisas de Auditoria: Acesso à aplicação de Pesquisas de Auditoria de Compliance','PCP','Pesquisas de Auditoria',3,1,NULL,331,3,'CMP'),('form_CMP_2500_conf_entrevistados_1','form','Cadastro de entrevistados ','PCP',NULL,NULL,NULL,NULL,332,0,'CMP'),('popup_confirm_action','blank','Pop-up ( não se aplica ao módulo de segirança)','PCP',NULL,1,NULL,NULL,333,0,NULL),('sub_consulta_LGPD_6200_agenda_treina','','Sub consulta de agenda de treinamentos ','PCP',NULL,1,NULL,NULL,334,0,'LGPD'),('Mapa_Calor_Riscos','','Mapa de calor de riscos ','PCP',NULL,1,NULL,NULL,335,0,'LGPD'),('form_CMP_3000_aplic_pesq','form','Cadastro de aplicação de pesquisa de auditorias ','PCP',NULL,NULL,NULL,NULL,336,0,'CMP'),('form_LGPD_2097_assoc_med_atv','','Cadastro de Medidas Técnicas - > Cadastro da especificação da associação entre medida técnica e ativo','PCP',NULL,1,NULL,NULL,337,0,'LGPD'),('grid_CMP_acompanhar_pesquisas','cons','Consulta acompanhamento do andamento de pesquisas de auditorias','PCP',NULL,1,NULL,NULL,338,0,'CMP'),('grid_sc_log','cons','[Item de menu] - Segurança / Histórico de acessos: Acesso à consulta à histórico de acessos de usuários à plataforma','PCP','Histórico de acessos',10,1,NULL,339,9,NULL),('sub_consulta_CMP_2510_det_conf_entrevistados','','Entrevitados em presquisa de auditoria --> Sub Consulta de configuração de entrevidados de pesquisa de auditoria ','PCP',NULL,1,NULL,NULL,340,0,'CMP'),('sub_consulta_CMP_3000_aplic','','Sub consulta status da aplicação de pesquisa de auditoria','PCP',NULL,1,NULL,NULL,341,0,'CMP'),('sub_consulta_CMP_4000_respostas_mestre','','Sub consulta status de respostas dos formulários de auditoria dentro de um ciclo ','PCP',NULL,1,NULL,NULL,342,0,'CMP'),('sub_consulta_LGPD_2097_assoc_med_atv','','Sub consulta de associação entre medidas técnicas e ativos','PCP',NULL,1,NULL,NULL,343,0,'LGPD'),('calendar_app','','Calendário','PCP',NULL,1,NULL,NULL,344,0,'LGPD'),('cons_dad_nao_utlz_LGPD_2030_dados','cons','[Item de menu] - Fluxo de Informação / Metadados Pessoais não utilizados: Acesso à consulta dos Metadados Pessoais cadastrados mas não utilizados em nenhuma associação','PCP','Metadados Pessoais não utilizados',5,1,NULL,345,5,'LGPD'),('cons_minhas_obr_CMP_1610_ol_agenda','cons','[Item de menu] - Aspectos Jurídicos / Minhas Obrigações Legais: Acesso ao cadastro das obrigações legais da entidade que estão sob a responsabilidade do usuário logado','PCP','Minhas Obrigações Legais',14,1,NULL,346,1,'CMP'),('consulta_gerencial_CMP_1610_ol_agenda','cons','[Item de menu] - Aspectos Jurídicos / Acompanhamento de Obrigações Legais: Acesso ao painel de acompanhamento do status das obrigações legais da entidade','PCP','Acompanhamento de Obrigações Legais',14,1,NULL,347,2,'CMP'),('consulta_gerencial_LGPD_4000_atividades','cons','[Item de menu] - Atividades e Ações / Acompanhamento de Atividades e Ações: Acesso ao painel de acompanhamento do status das obrigações legais da entidade','PCP','Acompanhamento de Atividades e Ações',9,1,NULL,348,3,'LGPD'),('control_calendar','','Meu calendário de atividades de adequação','PCP','Meu Calendário de Atividades de Adequação',NULL,NULL,NULL,349,0,'LGPD'),('form_CMP_1600_OL','form','Cadastro de Obrigações Legais ','PCP',NULL,NULL,NULL,NULL,350,0,'CMP'),('form_CMP_resultados_pesquisas','form','Cadastro de resultado de pesquisas de auditoria','PCP',NULL,NULL,NULL,NULL,351,0,'CMP'),('form_DOM_tp_ol_1600','form','Cadastro de tipos de obrigações ','PCP',NULL,NULL,NULL,NULL,352,0,'CMP'),('form_LGPD_4000_atividades','form','Cadastro de atividades de adequação','PCP',NULL,NULL,NULL,NULL,353,0,'LGPD'),('form_minhas_obr_CMP_1610_ol_agenda','','Edição das minhas obrigações legais ','PCP',NULL,1,NULL,NULL,354,0,'CMP'),('grid_CMP_1600_OL','cons','[Item de menu] - Aspectos Jurídicos / Obrigações Legais: Acesso ao cadastro das obrigações legais que a entidade deve atender em um determinado exercício','PCP','Obrigações Legais',14,1,NULL,355,3,'CMP'),('grid_CMP_resultado_pesquisa','cons','[Item de menu] - Auditoria de Compliance / Resultados de Auditoria: Acesso à gestão do resultado de Pesquisas de Auditoria de Compliance','PCP','Resultados de Auditoria',3,1,NULL,356,4,'CMP'),('grid_CMP_resultado_pesquisa_questoes','cons','Consulta resultado da pesquisa de auditoria ','PCP',NULL,1,NULL,NULL,357,0,'CMP'),('grid_CMP_resultado_pesquisa_status_mecanismo','cons','Consulta resultado da pesquisa por mecanismos de auditoria ','PCP',NULL,1,NULL,NULL,358,0,'CMP'),('grid_DOM_tp_ol_1600','cons','[Item de menu] - Aspectos Jurídicos / Tipos de Obrigações Legais: Acesso ao cadastro de tipos de obrigações legais','PCP','Tipos de Obrigações Legais',14,1,NULL,359,6,'CMP'),('grid_LGPD_6300_aluno_treina','cons','Consulta de lista de treinamentos realizados por colaborador','PCP',NULL,1,NULL,NULL,360,0,'LGPD'),('mapa_calor_risco','','Mapa de risco','PCP',NULL,1,NULL,NULL,361,0,'LGPD'),('sub_consulta_CMP_1610_ol_agenda','','Sub consulta de agenda de obrigações legais por obrigação','PCP',NULL,1,NULL,NULL,362,0,'CMP'),('form_LGPD_4000_atividades_calendar','form','Cadastro de atividades de adequação','PCP',NULL,NULL,NULL,NULL,363,0,'LGPD'),('popup_confirm_action_status','','Pop_Up ( Não se plaica ao módulo de segurança ) ','PCP',NULL,1,NULL,NULL,364,0,NULL),('grid_CMP_1550_ger_acao','cons','[Item de menu] - Auditoria de Compliance / Recomendações de Auditoria: Acesso à geração automática de recomendações pós Ciclo de Auditoria de Compliance','PCP','Recomendações de Auditoria',3,1,NULL,365,5,'CMP'),('menu_dinamico','','Menu','PCP',NULL,1,NULL,NULL,366,0,NULL),('relatorio_ciclos_complience','','Extrato de cilco de auditoria ','PCP',NULL,1,NULL,NULL,367,0,'CMP'),('sub_grid_CMP_1550_ger_acao','','Sub grid de recomendaçoes de auditoria por ciclo','PCP',NULL,1,NULL,NULL,368,0,'CMP'),('grid_LGPD_2040_assoc_prc_atv','cons','[Item de menu] - Fluxo de Informação / Associações do Fluxo de Informação: Acesso à consulta das associações entre Processos de Negócio x Ativos de Informação x Artefatos x Metadados Pessoais','PCP','Associações do Fluxo de Informação',5,1,NULL,369,6,'LGPD'),('sub_grid_LGPD_2050_assoc_atv_art','','Sub consulta de associação entre ativos e artefatos','PCP',NULL,NULL,NULL,NULL,370,0,'LGPD'),('grid_LGPD_2097_assoc_med_atv','cons','[Item de menu] - Medidas Técnicas de Segurança / Associações com Ativos de Informação: Acesso à configuração da associação entre Medidas Técnicas de Segurança e Ativos de Informação utilizados pela entidade','PCP','Associações com Ativos de Informação',8,1,NULL,371,2,'LGPD'),('grid_LGPD_3100_assoc_risc_atv','cons','[Item de menu] - Riscos / Associações de Riscos: Acesso à associações entre Riscos e outras informações cadastradas','PCP','Associações de Riscos',11,1,NULL,372,2,'LGPD'),('pac_app_grid_sec_users','cons','[Item de menu] - SeguranÃ§a / UsuÃ¡rios: Acesso ao cadastro de usuÃ¡rios da plataforma','PAC','Usuários',23,1,NULL,373,1,NULL),('pac_app_search_sec_groups','','[Item de menu] - SeguranÃ§a / AssociaÃ§Ã£o de perfis a aplicaÃ§Ãµes: Acesso Ã  configuraÃ§Ã£o da associaÃ§Ã£o de perfis de acesso com as aplicaÃ§Ãµes da plataforma','PAC','Associação de perfis a aplicações',23,1,NULL,374,6,NULL),('form_LGPD_3500_checklist_risk_padrao','form','[Item de menu] - Riscos / Checklist padrão de identificação de riscos e atividades','PCP','Checklist Padrão',11,1,NULL,375,4,'LGPD'),('grid_LGPD_3600_chklst_risk_area_mestre','form','[Item de menu] - Riscos / Checklist por área de identificação de riscos e atividades','PCP','Checklist por Área',11,1,NULL,376,5,'LGPD'),('form_LGPD_3600_chklst_risk_area_mestre','form','Formulário de checklist por área de identificação de riscos e atividades','PCP',NULL,11,NULL,NULL,377,1,'LGPD'),('form_aval_7000','form','Formulários de due diligence: Acesso à criação de formulários (e suas questões) para auto avaliação de terceiros','PCP',NULL,13,NULL,NULL,378,1,'CMP'),('grid_public_LGPD_7300_envio_aval_forne_gerencial','cons','[Item de menu] - Gestão de terceiros / Lista gerêncial de acompanhamento dos envios de Due Diligence','PCP','Acompanhamento de Due Diligence',13,1,NULL,388,3,'CMP'),('grid_public_PCP_9000_DPIA','cons','[Item de menu] - Consulta emissões DPIA','PCP','Emissões DPIA',37,1,NULL,389,1,'LGPD'),('grid_public_pcp_9100_LIA','cons','[Item de menu] - Consulta emissões LIA','PCP','Emissões LIA',37,1,NULL,393,2,'LGPD'),('grid_LGPD_2001_form_entr_prc','cons','[Item de menu] - Fluxo de Informação / Parametrização de formulários de entrevista e levntamento de processos','PCP','Parametrização levantamento de processos',5,1,NULL,405,7,'LGPD'),('grid_LGPD_2003_envio_entr_prc','cons','[Item de menu] - Fluxo de Informação / Gestão de envios de formulários de entrevista e levantamentos de processo','PCP','Gestão envios levantamentos processos',5,1,NULL,406,8,'LGPD'),('grid_LGPD_2087_ndas','cons','[Item de menu] - Políticas e Regulamentos / Gestão de NDA','PCP','NDA',7,1,NULL,407,4,NULL),('form_LGPD_2087_ndas','form','Cadastro de NDA','PCP',NULL,NULL,NULL,NULL,408,0,NULL),('form_LGPD_2001_form_entr_prc','form','Cadastro de parametrização de formulários de mapeamento de processos','PCP',NULL,NULL,NULL,NULL,409,0,'LGPD'),('form_LGPD_2003_envio_entr_prc','form','Cadastro de envio de mapeamento de processos','PCP',NULL,NULL,NULL,NULL,410,0,'LGPD'),('cad_sol_dpia_pcp_9000','form','Cadastro de solcitação de emissão do DPIA','PCP',NULL,NULL,NULL,NULL,411,0,'LGPD'),('form_pcp_9100_LIA','form','Cadastro de solcitação de emissão do LIA','PCP',NULL,NULL,NULL,NULL,412,0,'LGPD');
/*!40000 ALTER TABLE `sec_apps` ENABLE KEYS */;
-- UNLOCK TABLES;

--
-- Table structure for table `sec_groups`
--

DROP TABLE IF EXISTS `sec_groups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sec_groups` (
  `group_id` int NOT NULL,
  `description` varchar(255) DEFAULT NULL,
  `resumo` varchar(300) DEFAULT NULL,
  `escopo` varchar(45) DEFAULT NULL,
  `ind_permite_visualizar_pesos` tinyint DEFAULT '1',
  PRIMARY KEY (`group_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sec_groups`
--

-- LOCK TABLES `sec_groups` WRITE;
/*!40000 ALTER TABLE `sec_groups` DISABLE KEYS */;
INSERT INTO `sec_groups` VALUES (1,'Administrador','Usuário administrador da plataforma, com acesso a todos os módulos','LGPD;Compliance',1),(2,'DPO','Usuário master de projetos de Governança de Privacidade, com acesso a todas as funcionalidades associadas a esses projetos e capaz de dar acesso aos demais usuários\n','LGPD',1),(3,'Analista de Privacidade','Usuário responsável pelos inventários e análises dos aspectos técnicos de projetos de Governança de Privacidade\n','LGPD',1),(4,'Analista de Processos','Usuário responsável pela gestão dos Processos de Negócio tratados na plataforma, que são utilizados como base para projetos de Governança de Privacidade e Compliance','LGPD;Compliance',1),(5,'Analista Jurídico','Usuário responsável pelos inventários e análises dos aspectos jurídicos de projetos de Governança de Privacidade e Compliance\n','LGPD;Compliance',1),(6,'Analista de Segurança da Informação','Usuário responsável pelos inventários e análises dos aspectos de segurança da informaçaão de projetos de Governança de Privacidade\n','LGPD',1),(7,'Membro do Comitê de Privacidade','Usuário com acesso de leitura às informações relacionadas a projetos de Governança de Privacidade e capaz de gerenciar suas tarefas em projetos dessa natureza\n','LGPD',1),(8,'Analista de Compliance','Usuário responsável pelos inventários e análises dos aspectos técnicos de projetos de Compliance\n','Compliance',1),(9,'Gestor de Compliance','Usuário master de projetos de Compliance, com acesso a todas as funcionalidades associadas a esses projetos e capaz de dar acesso aos demais usuários\n','Compliance',1),(10,'Membro do Comitê de Ética e Integridade','Usuário com acesso de leitura às informações relacionadas a projetos de Compliance e capaz de gerenciar suas tarefas em projetos dessa natureza\n','Compliance',1);
/*!40000 ALTER TABLE `sec_groups` ENABLE KEYS */;
-- UNLOCK TABLES;

--
-- Table structure for table `sec_groups_apps`
--

DROP TABLE IF EXISTS `sec_groups_apps`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sec_groups_apps` (
  `group_id` int NOT NULL,
  `app_name` varchar(128) NOT NULL,
  `priv_access` varchar(1) DEFAULT NULL,
  `priv_insert` varchar(1) DEFAULT NULL,
  `priv_delete` varchar(1) DEFAULT NULL,
  `priv_update` varchar(1) DEFAULT NULL,
  `priv_export` varchar(1) DEFAULT NULL,
  `priv_print` varchar(1) DEFAULT NULL,
  `app_description` varchar(255) DEFAULT NULL,
  `node_menu_desc` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`group_id`,`app_name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sec_groups_apps`
--

-- LOCK TABLES `sec_groups_apps` WRITE;
/*!40000 ALTER TABLE `sec_groups_apps` DISABLE KEYS */;
INSERT INTO `sec_groups_apps` VALUES (1,'app_change_pswd','Y','Y','Y','Y','Y','Y','[Item de menu] - Segurança / Alteração de senha: Acesso à gestão de senhas de usuários da plataforma','Segurança'),(1,'app_form_add_users','Y','Y','Y','Y','Y','Y','Cadastrar usuários','Formulário'),(1,'app_form_edit_users','Y','Y','Y','Y','Y','Y','Alterar usuários','Formulário'),(1,'app_form_sec_apps','Y','Y','Y','Y','Y','Y','Cadastrar aplicações','Formulário'),(1,'app_form_sec_groups','Y','Y','Y','Y','Y','Y','Cadastro de grupos de usuários','Formulário'),(1,'app_form_sec_groups_apps','Y','Y','Y','Y','Y','Y','Associar grupos x aplicações','Painel'),(1,'app_grid_sec_apps','Y','Y','Y','Y','Y','Y','[Item de menu] - Segurança / Aplicações: Acesso ao cadastro de aplicações da plataforma','Segurança'),(1,'app_grid_sec_groups','Y','Y','Y','Y','Y','Y','[Item de menu] - Segurança / Perfis: Acesso ao cadastro de perfis de acesso dos usuários da plataforma','Segurança'),(1,'app_grid_sec_users','Y','Y','Y','Y','Y','Y','[Item de menu] - Segurança / Usuários: Acesso ao cadastro de usuários da plataforma','Segurança'),(1,'app_grid_sec_users_groups','Y','Y','Y','Y','Y','Y','[Item de menu] - Segurança / Associação de usuários a perfis: Acesso à configuração da associação de usuários a perfis de acesso','Segurança'),(1,'app_Login','Y','Y','Y','Y','Y','Y','Login',NULL),(1,'app_menu','Y','Y','Y','Y','Y','Y','Menu','Painel'),(1,'app_retrieve_pswd','Y','Y','Y','Y','Y','Y','Esqueceu a senha','Painel'),(1,'app_search_sec_groups','Y','Y','Y','Y','Y','Y','[Item de menu] - Segurança / Associação de perfis a aplicações: Acesso à configuração da associação de perfis de acesso com as aplicações da plataforma','Segurança'),(1,'app_settings','Y','Y','Y','Y','Y','Y','Configurações de segurança','Segurança'),(1,'app_sync_apps','Y','Y','Y','Y','Y','Y','Sincronização de aplicações','Segurança'),(1,'Artefatos','Y','Y','Y','Y','Y','Y','[Item de menu] - Painel / Artefatos: Acesso à exibição dos principais indicadores sobre Artefatos e Documentos','Painel'),(1,'associar_metadados_finalidade','Y','Y','Y','Y','Y','Y','Associar metadados na finalidade','Painel'),(1,'associar_metadados_finalidade_new','Y','Y','Y','Y','Y','Y','Associar metadados a finalidades','Painel'),(1,'Atividades','Y','Y','Y','Y','Y','Y','[Item de menu] - Painel / Atividades e Ações: Acesso à exibição dos principais indicadores sobre Atividades e Ações','Painel'),(1,'Ativos','Y','Y','Y','Y','Y','Y','[Item de menu] - Painel / Ativos de Informação: Acesso à exibição dos principais indicadores sobre Ativos de Informação','Painel'),(1,'Auto_cadastro_PAC_4000_notificacao','Y','Y','Y','Y','Y','Y',NULL,NULL),(1,'blank_email','Y','Y','Y','Y','Y','Y','Enviar mail','Painel'),(1,'blank_pipeline','Y','Y','Y','Y','Y','Y','[Item de menu] - Atividades e Ações / Meu Quadro de Atividades: Acesso ao Kanban de atividades do usuário logado','Atividades e Ações'),(1,'blank_pipeline_Ajax','Y','Y','Y','Y','Y','Y','Pipeline de atividades','Painel'),(1,'cad_sol_dpia_pcp_9000','Y','Y','Y','Y','Y','Y',NULL,'Fluxo de Informação'),(1,'Cadastro_DEN_1000_registro','Y','Y','Y','Y','Y','Y',NULL,NULL),(1,'Cadastro_DEN_1100_cat','Y','Y','Y','Y','Y','Y',NULL,NULL),(1,'cadastro_PAC_1110_atv_sol','Y','Y','Y','Y','Y','Y',NULL,NULL),(1,'cadastro_PAC_1200_sla_sol_portal','Y','Y','Y','Y','Y','Y',NULL,NULL),(1,'Cadastro_PAC_1400_titulares','Y','Y','Y','Y','Y','Y',NULL,NULL),(1,'Cadastro_PAC_1410_dados_tit','Y','Y','Y','Y','Y','Y',NULL,NULL),(1,'Cadastro_PAC_2000_incidentes','Y','Y','Y','Y','Y','Y',NULL,NULL),(1,'Cadastro_PAC_2100_sla_notificacao','Y','Y','Y','Y','Y','Y',NULL,NULL),(1,'Cadastro_PAC_3100_env_consent','Y','Y','Y','Y','Y','Y',NULL,NULL),(1,'Cadastro_PAC_4000_notificacao','Y','Y','Y','Y','Y','Y',NULL,NULL),(1,'Cadastro_PAG_lote_1000','Y','Y','Y','Y','Y','Y',NULL,NULL),(1,'cadastro_PAG_ocorr_lote_1100','Y','Y','Y','Y','Y','Y',NULL,NULL),(1,'calendar_app','Y','','','','Y','Y','Calendário','Painel'),(1,'calendar_public_LGPD_4000_atividades','Y','Y','Y','Y','Y','Y','Calendário de atividades ( DPO )','Painel'),(1,'chart_public_LGPD_2000_processos_complex','Y','Y','Y','Y','Y','Y','Gráfico processo por complexidade','Painel'),(1,'chart_public_LGPD_2000_processos_geral','Y','Y','Y','Y','Y','Y','Gráfico processos','Painel'),(1,'chart_public_LGPD_2000_processos_resp','Y','Y','Y','Y','Y','Y','Gráfico processos por responsável','Painel'),(1,'chart_public_LGPD_2000_status_processos','Y','Y','Y','Y','Y','Y','Gráfico processo por status','Painel'),(1,'chart_public_LGPD_2000_tipo_processo','Y','Y','Y','Y','Y','Y','Gráfico processos por tipo','Painel'),(1,'chart_public_LGPD_2010_confia_ativos','Y','Y','Y','Y','Y','Y','Gráfico confibilidade dos ativos','Painel'),(1,'chart_public_LGPD_2010_disp_ativos','Y','Y','Y','Y','Y','Y','Gráfico ativos por nível de disponibilidade','Painel'),(1,'chart_public_LGPD_2010_integridade_ativos','Y','Y','Y','Y','Y','Y','Gráfico ativos por nível de integridade','Painel'),(1,'chart_public_LGPD_2010_resp_ativos','Y','Y','Y','Y','Y','Y','Gráfico ativos por responsável','Painel'),(1,'chart_public_LGPD_2010_tipo_ativos','Y','Y','Y','Y','Y','Y','Gráfico tipos de ativos','Painel'),(1,'chart_public_LGPD_2020_artefat_contrato','Y','Y','Y','Y','Y','Y','Gráfico artefatos tipo contrato','Painel'),(1,'chart_public_LGPD_2020_contrato_artefatos','Y','Y','Y','Y','Y','Y','Gráfico contratos x artefatos','Painel'),(1,'chart_public_LGPD_2020_tipo_artefatos','Y','Y','Y','Y','Y','Y','Gráfico artefatos por tipo','Painel'),(1,'chart_public_LGPD_2030_classif_dados','Y','Y','Y','Y','Y','Y','Gráfico classificação de metadados','Painel'),(1,'chart_public_LGPD_2030_dados_anonimizavel','Y','Y','Y','Y','Y','Y','Gráfico metadados anonimizavel','Painel'),(1,'chart_public_LGPD_2030_tipif_dados','Y','Y','Y','Y','Y','Y','Gráfico tipos de dados','Painel'),(1,'chart_public_LGPD_2070_fin_compart_dados','Y','Y','Y','Y','Y','Y','Gráfico finalidades por compartilhamento','Painel'),(1,'chart_public_LGPD_2070_fin_dad_criancas','Y','Y','Y','Y','Y','Y','Gráfico finalidades por dados de crianças','Painel'),(1,'chart_public_LGPD_2070_fin_faz_descarte','Y','Y','Y','Y','Y','Y','Gráfico finalidades por descarte','Painel'),(1,'chart_public_LGPD_2070_fin_frequencia','Y','Y','Y','Y','Y','Y','Gráfico finalidades por ferequencia','Painel'),(1,'chart_public_LGPD_2070_fin_hipoteses','Y','Y','Y','Y','Y','Y','Gráfico finalidades por hipóteses de tratamento','Painel'),(1,'chart_public_LGPD_2070_fin_papel','Y','Y','Y','Y','Y','Y','Gráfico papel da entidade','Painel'),(1,'chart_public_LGPD_2070_fin_processos','Y','Y','Y','Y','Y','Y','Gráfico finalidades por processos','Painel'),(1,'chart_public_LGPD_2070_fin_rot_automatizada','Y','Y','Y','Y','Y','Y','Gráfico finalidades por rotinas automatizadas','Painel'),(1,'chart_public_LGPD_2070_fin_utlz_operador','Y','Y','Y','Y','Y','Y','Gráfico finalidades por utiliza operador','Painel'),(1,'chart_public_LGPD_2070_fin_volumetria','Y','Y','Y','Y','Y','Y','Gráfico finliadades por volumetria','Painel'),(1,'chart_public_LGPD_3000_categoria_riscos','Y','Y','Y','Y','Y','Y','Gráfico riscos por categoria','Painel'),(1,'chart_public_LGPD_3000_criticidade_riscos','Y','Y','Y','Y','Y','Y','Gráfico riscos por criticidade','Painel'),(1,'chart_public_LGPD_3000_estrategia_riscos','Y','Y','Y','Y','Y','Y','Gráfico riscos por estratégia','Painel'),(1,'chart_public_LGPD_3000_impacto_riscos','Y','Y','Y','Y','Y','Y','Gráfico riscos por impacto','Painel'),(1,'chart_public_LGPD_3000_prob_riscos','Y','Y','Y','Y','Y','Y','Gráfico riscos por probabilidade','Painel'),(1,'chart_public_LGPD_3000_resp_riscos','Y','Y','Y','Y','Y','Y','Gráfico riscos por responsáveis','Painel'),(1,'chart_public_LGPD_3000_status_riscos','Y','Y','Y','Y','Y','Y','Gráfico riscos por status','Painel'),(1,'chart_public_LGPD_4000_atividades_geral','Y','Y','Y','Y','Y','Y','Gráfico atividades','Painel'),(1,'chart_public_LGPD_4000_disc_atividades','Y','Y','Y','Y','Y','Y','Gráfico atividades por disciplina','Painel'),(1,'chart_public_LGPD_4000_etapa_atividades','Y','Y','Y','Y','Y','Y','Gráfico atividades por etapas','Painel'),(1,'chart_public_LGPD_4000_resp_atividades','Y','Y','Y','Y','Y','Y','Gráfico atividades por responsável','Painel'),(1,'chart_public_LGPD_4000_status_resp_atividade','Y','Y','Y','Y','Y','Y','Gráfico atividades por responsável e status','Painel'),(1,'chart_public_LGPD_assoc_pdca_contr_6500','Y','Y','Y','Y','Y','Y','Gráfico PDCA de contratos','Painel'),(1,'chart_public_LGPD_assoc_pdca_finalizados_treina_6500','Y','Y','Y','Y','Y','Y','Gráfico PDCA de treinamentos','Painel'),(1,'chart_public_LGPD_assoc_pdca_medtec_6700','Y','Y','Y','Y','Y','Y','Gráfico PDCA de medidas técnicas','Painel'),(1,'chart_public_LGPD_assoc_pdca_pol_6300','Y','Y','Y','Y','Y','Y','Gráfico PDCA de políticas','Painel'),(1,'chart_public_LGPD_assoc_pdca_proc_6600','Y','Y','Y','Y','Y','Y','Gráfico PDCA de processos','Painel'),(1,'chart_public_LGPD_assoc_pdca_realizar_treina_6500','Y','Y','Y','Y','Y','Y','Gráfico PDCA realização de treinamentos','Painel'),(1,'chart_public_LGPD_assoc_pdca_risk_6400','Y','Y','Y','Y','Y','Y','Gráfico PDCA de riscos','Painel'),(1,'cons_dad_nao_utlz_LGPD_2030_dados','Y','','','','Y','Y','[Item de menu] - Fluxo de Informação / Metadados Pessoais não utilizados: Acesso à consulta dos Metadados Pessoais cadastrados mas não utilizados em nenhuma associação','Fluxo de Informação'),(1,'cons_minhas_obr_CMP_1610_ol_agenda','Y','','','','Y','Y','[Item de menu] - Aspectos Jurídicos / Minhas Obrigações Legais: Acesso ao cadastro das obrigações legais da entidade que estão sob a responsabilidade do usuário logado','Aspectos Jurídicos'),(1,'Consulta_DEN_1000_registro','Y','Y','Y','Y','Y','Y',NULL,NULL),(1,'Consulta_DEN_1100_cat','Y','Y','Y','Y','Y','Y',NULL,NULL),(1,'consulta_gerencial_CMP_1610_ol_agenda','Y','','','','Y','Y','[Item de menu] - Aspectos Jurídicos / Acompanhamento de Obrigações Legais: Acesso ao painel de acompanhamento do status das obrigações legais da entidade','Aspectos Jurídicos'),(1,'consulta_gerencial_LGPD_4000_atividades','Y','','','','Y','Y','[Item de menu] - Atividades e Ações / Acompanhamento de Atividades e Ações: Acesso ao painel de acompanhamento do status das obrigações legais da entidade','Atividades e Ações'),(1,'Consulta_LGPD_3000_riscos_assistant','Y','Y','Y','Y','Y','Y',NULL,NULL),(1,'Consulta_LGPD_4000_atividades_assistant','Y','Y','Y','Y','Y','Y',NULL,NULL),(1,'Consulta_PAC_1000_user_portal','Y','Y','Y','Y','Y','Y',NULL,NULL),(1,'Consulta_PAC_1100_sol_portal','Y','Y','Y','Y','Y','Y',NULL,NULL),(1,'consulta_PAC_1200_sla_sol_portal','Y','Y','Y','Y','Y','Y',NULL,NULL),(1,'Consulta_PAC_1400_titulares','Y','Y','Y','Y','Y','Y',NULL,NULL),(1,'Consulta_PAC_1410_dados_tit','Y','Y','Y','Y','Y','Y',NULL,NULL),(1,'Consulta_PAC_2000_incidentes','Y','Y','Y','Y','Y','Y',NULL,NULL),(1,'Consulta_PAC_3100_env_consent','Y','Y','Y','Y','Y','Y',NULL,NULL),(1,'Consulta_PAC_4000_notificacao','Y','Y','Y','Y','Y','Y',NULL,NULL),(1,'Consulta_PAG_lote_1000','Y','Y','Y','Y','Y','Y',NULL,NULL),(1,'Consulta_public_LGPD_3000_riscos','Y','Y','Y','Y','Y','Y',NULL,NULL),(1,'control_calendar','Y','','','','Y','Y','Meu calendário de atividades de adequação',NULL),(1,'control_login','Y','Y','Y','Y','Y','Y','Login','Painel'),(1,'control_login_diligence',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(1,'esqueci_senha','Y','Y','Y','Y','Y','Y','Esqueceu a senha','Painel'),(1,'extrato_pdca','Y','Y','Y','Y','Y','Y','Extrato PDCA','Painel'),(1,'Finalidades','Y','Y','Y','Y','Y','Y','[Item de menu] - Painel / Finalidades de Tratamento de Dados Pessoais: Acesso à exibição dos principais indicadores sobre Finalidades de Tratamento de Dados Pessoais','Painel'),(1,'form_aval_7000','Y','Y','Y','Y','Y','Y','Formulários de due diligence: Acesso à criação de formulários (e suas questões) para auto avaliação de terceiros','Gestão de Terceiros'),(1,'form_CMP_1000_mecanismos','Y','Y','Y','Y','Y','Y','Cadastro de mecanismos de auditoria ','Formulário'),(1,'form_CMP_1100_componentes','Y','Y','Y','Y','Y','Y','Cadastro de componentes de auditoria','Formulário'),(1,'form_CMP_1200_questoes','Y','Y','Y','Y','Y','Y','Cadastro de questões de auditoria','Formulário'),(1,'form_CMP_1300_formularios','Y','Y','Y','Y','Y','Y','Cadatro de formulários de auditoria ','Formulário'),(1,'form_CMP_1300_formularios_edit','Y','Y','Y','Y','Y','Y','Edição de formulários de auditoria','Formulário'),(1,'form_CMP_1400_formulas_mestre','Y','Y','Y','Y','Y','Y','Parametrização de Setup de Auditoria','Formulário'),(1,'form_CMP_1400_formulas_view','Y','Y','Y','Y','Y','Y','Visualizar setup de auditoria','Formulário'),(1,'form_CMP_1410_formulas_det_mec','Y','Y','Y','Y','Y','Y','Parametrizar mecanismos de auditoria no setup','Formulário'),(1,'form_CMP_1420_formulas_det_niv_ad','Y','Y','Y','Y','Y','Y','Parametrizar níveis de aderência do setup de auditoria ','Formulário'),(1,'form_CMP_1430_formulas_det_lim','Y','Y','Y','Y','Y','Y','Parametrizar faixas do setup de auditoria','Formulário'),(1,'form_CMP_1500_acao','Y','Y','Y','Y','Y','Y','Recomendações de auditorias','Formulário'),(1,'form_CMP_1600_OL','Y','Y','Y','Y','Y','Y','Cadastro de Obrigações Legais ','Formulário'),(1,'form_CMP_2000_ciclos','Y','Y','Y','Y','Y','Y','Cadastro de ciclos de auditoria','Formulário'),(1,'form_CMP_2500_conf_entrevistados','Y','Y','Y','Y','Y','Y','Cadastro de entrevistados do ciclo de auditoria ','Formulário'),(1,'form_CMP_2500_conf_entrevistados_1','Y','Y','Y','Y','Y','Y','Cadastro de entrevistados ','Formulário'),(1,'form_CMP_2500_conf_param_entrevistados','Y','Y','Y','Y','Y','Y','Parametrizar relação de entrevistados de um ciclo de auditoria','Formulário'),(1,'form_CMP_3000_aplic_pesq','Y','Y','Y','Y','Y','Y','Cadastro de aplicação de pesquisa de auditorias ','Formulário'),(1,'form_CMP_resultados_pesquisas','Y','Y','Y','Y','Y','Y','Cadastro de resultado de pesquisas de auditoria','Formulário'),(1,'form_conf_quest_7100','Y','Y','Y','Y','Y','Y','Configurar questionário de fornecedores','Formulário'),(1,'form_diligence',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(1,'form_DOM_tp_ol_1600','Y','Y','Y','Y','Y','Y','Cadastro de tipos de obrigações ','Formulário'),(1,'form_kanban_atividades','Y','Y','Y','Y','Y','Y','Kanban de  atividades','Formulário'),(1,'form_kanban_atividades_add_registro','Y','Y','Y','Y','Y','Y','Cadastrar atividades pelo kanban','Formulário'),(1,'form_LGPD_0002_conf_smpt','Y','Y','Y','Y','Y','Y','[Item de menu] - Configurações / Configuração de envio de e-mails: Acesso à configuração do endereço de de SMTP para envio de e-mails da plataforma','Formulário'),(1,'form_LGPD_2001_form_entr_prc','Y','Y','Y','Y','Y','Y',NULL,'Fluxo de Informação'),(1,'form_LGPD_2003_envio_entr_prc','Y','Y','Y','Y','Y','Y',NULL,'Fluxo de Informação'),(1,'form_LGPD_2087_ndas','Y','Y','Y','Y','Y','Y',NULL,'Fluxo de Informação'),(1,'form_LGPD_2097_assoc_med_atv',NULL,NULL,NULL,NULL,NULL,NULL,'Cadastro de Medidas Técnicas - > Cadastro da especificação da associação entre medida técnica e ativo','Painel'),(1,'form_LGPD_3500_checklist_risk_padrao','Y','Y','Y','Y','Y','Y','[Item de menu] - Riscos / Checklist padrão de identificação de riscos e atividades','Riscos'),(1,'form_LGPD_3600_chklst_risk_area_mestre','Y','Y','Y','Y','Y','Y','Formulário de checklist por área de identificação de riscos e atividades','Riscos'),(1,'form_LGPD_4000_atividades','Y','Y','Y','Y','Y','Y','Cadastro de atividades de adequação','Formulário'),(1,'form_LGPD_4000_atividades_calendar','Y','Y','Y','Y','Y','Y','Cadastro de atividades de adequação','Formulário'),(1,'form_minhas_obr_CMP_1610_ol_agenda',NULL,NULL,NULL,NULL,NULL,NULL,'Edição das minhas obrigações legais ','Painel'),(1,'form_new_pln_acao','Y','Y','Y','Y','Y','Y','Cadastrar plano de ação','Formulário'),(1,'form_PAC_1100_sol_portal','Y','Y','Y','Y','Y','Y',NULL,NULL),(1,'form_pcp_9100_LIA','Y','Y','Y','Y','Y','Y',NULL,'Fluxo de Informação'),(1,'form_public_LGPD_0100_diagnostico','Y','Y','Y','Y','Y','Y','Parametrizar etapa de diagnóstico','Formulário'),(1,'form_public_LGPD_0200_implement','Y','Y','Y','Y','Y','Y','Parametrizar etapa de implementação','Formulário'),(1,'form_public_LGPD_0300_operacao','Y','Y','Y','Y','Y','Y','Parametrizar etapa de operação','Formulário'),(1,'form_public_LGPD_0400_etapas','Y','Y','Y','Y','Y','Y','Parametrizar etapas','Formulário'),(1,'form_public_LGPD_1000_controlador','Y','Y','Y','Y','Y','Y','Cadastro de controlador','Formulário'),(1,'form_public_LGPD_1001_diretoria','Y','Y','Y','Y','Y','Y','Cadastro de diretoria','Formulário'),(1,'form_public_LGPD_1002_area','Y','Y','Y','Y','Y','Y','Cadastro de área','Formulário'),(1,'form_public_LGPD_1003_departamento','Y','Y','Y','Y','Y','Y','Cadastro de departamentos','Formulário'),(1,'form_public_LGPD_1004_cargos','Y','Y','Y','Y','Y','Y','Cadastro de cargos','Formulário'),(1,'form_public_LGPD_1050_organograma','Y','Y','Y','Y','Y','Y','Cadastro de organograma','Formulário'),(1,'form_public_LGPD_1051_comite','Y','Y','Y','Y','Y','Y','Cadastro de comitê','Formulário'),(1,'form_public_LGPD_1053_eventos_comite','Y','Y','Y','Y','Y','Y','Agenda de eventos do comitê','Formulário'),(1,'form_public_LGPD_1100_equipe','Y','Y','Y','Y','Y','Y','Cadastro de equipe','Formulário'),(1,'form_public_LGPD_1100_equipe_1','Y','Y','Y','Y','Y','Y','Cadastro de equipe','Formulário'),(1,'form_public_LGPD_2000_processos','Y','Y','Y','Y','Y','Y','Cadastro de processos','Formulário'),(1,'form_public_LGPD_2010_ativos','Y','Y','Y','Y','Y','Y','Cadastro de ativos','Formulário'),(1,'form_public_LGPD_2020_artefatos','Y','Y','Y','Y','Y','Y','Cadastro de artefatos','Formulário'),(1,'form_public_LGPD_2030_dados','Y','Y','Y','Y','Y','Y','Cadastro de metadados','Formulário'),(1,'form_public_LGPD_2060_config_assoc','Y','Y','Y','Y','Y','Y','Associação artefato x metadados','Formulário'),(1,'form_public_LGPD_2065_fund_legal','Y','Y','Y','Y','Y','Y','Cadastro de fundamentos legais','Formulário'),(1,'form_public_LGPD_2066_ambiente_reg','Y','Y','Y','Y','Y','Y','Cadastro de ambientes regulatórios','Formulário'),(1,'form_public_LGPD_2070_finalidades','Y','Y','Y','Y','Y','Y','Parametrizar finalidades','Formulário'),(1,'form_public_LGPD_2070_registrar_finalidades','Y','Y','Y','Y','Y','Y','Registrar finalidades','Formulário'),(1,'form_public_LGPD_2075_param_assoc_funcional_fin','Y','Y','Y','Y','Y','Y','Associação funcional da finalidade','Formulário'),(1,'form_public_LGPD_2080_politicas','Y','Y','Y','Y','Y','Y','Cadastro de políticas','Formulário'),(1,'form_public_LGPD_2085_contratos','Y','Y','Y','Y','Y','Y','Cadastro de contratos','Formulário'),(1,'form_public_LGPD_2090_terceiros','Y','Y','Y','Y','Y','Y','Cadastro de terceiros','Formulário'),(1,'form_public_LGPD_2093_ocorr_terc','Y','Y','Y','Y','Y','Y','Cadastro de ocorrência de terceiros','Formulário'),(1,'form_public_LGPD_2095_med_tec','Y','Y','Y','Y','Y','Y','Cadastro de medidas técnicas','Formulário'),(1,'form_public_LGPD_2097_config_assoc_med_atv','Y','Y','Y','Y','Y','Y','Associar medidas técnicas aos ativos','Formulário'),(1,'form_public_LGPD_2100_prz_aprv_proc','Y','Y','Y','Y','Y','Y','[Item de menu] - Configurações / SLA de aprovação de Processos de Negócio: Acesso à configuração do prazo limite para aprovação de Processos de Negócio cadastrados','Formulário'),(1,'form_public_LGPD_3000_riscos','Y','Y','Y','Y','Y','Y','Cadastro de riscos','Formulário'),(1,'form_public_LGPD_4000_atividades','Y','Y','Y','Y','Y','Y','Cadastro de atividades','Formulário'),(1,'form_public_LGPD_5000_cod_etica','Y','Y','Y','Y','Y','Y','Cadastro de código de ética','Formulário'),(1,'form_public_LGPD_5100_cod_conduta','Y','Y','Y','Y','Y','Y',NULL,NULL),(1,'form_public_LGPD_6000_PDCA','Y','Y','Y','Y','Y','Y','PDCA','Formulário'),(1,'form_public_LGPD_6100_catalog_treinamentos','Y','Y','Y','Y','Y','Y','Cadastro de catalogo de treinamentos','Formulário'),(1,'form_public_LGPD_6200_agenda_treina','Y','Y','Y','Y','Y','Y','Agenda de treinamentos','Formulário'),(1,'form_public_LGPD_7300_envio_aval_forne','Y','Y','Y','Y','Y','Y','Cadastro de questionários (Due Diligence)','Formulário'),(1,'form_public_LGPD_assoc_contr_6500','Y','Y','Y','Y','Y','Y','Associação de contratos','Formulário'),(1,'form_public_LGPD_assoc_medtec_6700','Y','Y','Y','Y','Y','Y','Associação de medidas técnicas','Formulário'),(1,'form_public_LGPD_assoc_pdca_risk_6400','Y','Y','Y','Y','Y','Y','Associação de riscos ao PDCA','Formulário'),(1,'form_public_LGPD_assoc_pol_6300','Y','Y','Y','Y','Y','Y','Associação de políticas','Formulário'),(1,'form_public_LGPD_assoc_proc_6600','Y','Y','Y','Y','Y','Y','Associação de processos','Formulário'),(1,'form_public_LGPD_assoc_treina_6500','Y','Y','Y','Y','Y','Y','Associação de treinamentos','Formulário'),(1,'form_public_LGPD_config_det_opt_7200','Y','Y','Y','Y','Y','Y','Parametrizar opções do questionário de fornecedores','Formulário'),(1,'form_public_PAC_1000_user_portal','Y','Y','Y','Y','Y','Y',NULL,NULL),(1,'Governance_menu','Y','Y','Y','Y','Y','Y','Menu',NULL),(1,'grid_CMP_0100_faixas','Y','','','','Y','Y','Consultar faixas de setup de auditoria','Painel'),(1,'grid_CMP_1000_mecanismos','Y','Y','Y','Y','Y','Y','[Item de menu] - Pilares do Compliance / Mecanismos de Auditoria: Acesso ao cadastro de Mecanismos de Auditoria para projetos de Compliance','Pilares de Compliance'),(1,'grid_CMP_1100_componentes','Y','','','','Y','Y','[Item de menu] - Pilares do Compliance / Componentes de Auditoria: Acesso ao cadastro de Componentes de Auditoria, que compõem os Mecanismos cadastrados','Pilares de Compliance'),(1,'grid_CMP_1100_entrevistados_desassociados','Y','','','','Y','Y','Consultas candidatos a entrevistas de ciclo de auditoria ','Painel'),(1,'grid_CMP_1200_questoes','Y','','','','Y','Y','[Item de menu] - Pilares do Compliance / Questões de Auditoria: Acesso ao cadastro de perguntas que são utilizadas para a realização de auditorias de Compliance','Pilares de Compliance'),(1,'grid_CMP_1300_formularios','Y','','','','Y','Y','[Item de menu] - Pilares do Compliance / Formulários de Auditoria: Acesso ao cadastro e configuração de Formulários compostos por perguntas para a realização de auditorias de Compliance','Pilares de Compliance'),(1,'grid_CMP_1310_formulario_det','Y','','','','Y','Y','Consulta detalhes do formulário de auditoria ','Painel'),(1,'grid_CMP_1400_formulas_mestre','Y','','','','Y','Y','[Item de menu] - Pilares do Compliance / Parâmetros de Ciclos de Auditoria: Acesso à configuração de parâmetros quantitativos utilizados nos Ciclos de Auditoria de Compliance','Pilares de Compliance'),(1,'grid_CMP_1410_formulas_det_mec','Y','','','','Y','Y','Sub Consulta mecanismos do setup de auditoria','Painel'),(1,'grid_CMP_1500_acao','Y','','','','Y','Y','[Item de menu] - Pilares do Compliance / Ações de Auditoria: Acesso ao cadastro de ações pré-determinadas para serem sugeridas a partir do levantamento de determinada Questão cadastrada','Pilares de Compliance'),(1,'grid_CMP_1550_ger_acao','Y','','','','Y','Y','[Item de menu] - Auditoria de Compliance / Recomendações de Auditoria: Acesso à geração automática de recomendações pós Ciclo de Auditoria de Compliance','Auditoria de Compliance'),(1,'grid_CMP_1600_OL','Y','','','','Y','Y','[Item de menu] - Aspectos Jurídicos / Obrigações Legais: Acesso ao cadastro das obrigações legais que a entidade deve atender em um determinado exercício','Aspectos Jurídicos'),(1,'grid_CMP_2000_ciclos','Y','','','','Y','Y','[Item de menu] - Auditoria de Compliance / Ciclos de Auditoria: Acesso à gestão de Ciclos de Auditoria de Compliance','Auditoria de Compliance'),(1,'grid_CMP_2500_conf_entrevistados','Y','','','','Y','Y','[Item de menu] - Auditoria de Compliance / Entrevistados: Acesso à seleção de entrevistados que estarão associados a um Ciclo de Auditoria de Compliance','Auditoria de Compliance'),(1,'grid_CMP_2510_entrevistados_associados','Y','','','','Y','Y','Relação de entrevistados de um ciclo de auditoria','Painel'),(1,'grid_CMP_3000_aplic_pesq','Y','','','','Y','Y','[Item de menu] - Auditoria de Compliance / Pesquisas de Auditoria: Acesso à aplicação de Pesquisas de Auditoria de Compliance','Auditoria de Compliance'),(1,'grid_CMP_acompanhar_pesquisas','Y','','','','Y','Y','Consulta acompanhamento do andamento de pesquisas de auditorias','Painel'),(1,'grid_CMP_resultado_pesquisa','Y','','','','Y','Y','[Item de menu] - Auditoria de Compliance / Resultados de Auditoria: Acesso à gestão do resultado de Pesquisas de Auditoria de Compliance','Auditoria de Compliance'),(1,'grid_CMP_resultado_pesquisa_questoes','Y','','','','Y','Y','Consulta resultado da pesquisa de auditoria ','Painel'),(1,'grid_CMP_resultado_pesquisa_status_mecanismo','Y','','','','Y','Y','Consulta resultado da pesquisa por mecanismos de auditoria ','Painel'),(1,'grid_conf_quest_7100','Y','Y','Y','Y','Y','Y','Cofiguração de questionário para fornecedores','Painel'),(1,'grid_DOM_tp_ol_1600','Y','','','','Y','Y','[Item de menu] - Aspectos Jurídicos / Tipos de Obrigações Legais: Acesso ao cadastro de tipos de obrigações legais','Aspectos Jurídicos'),(1,'grid_kanban_atividades','Y','Y','Y','Y','Y','Y','Kanban de  atividades','Painel'),(1,'grid_kanban_atividades_add_registro','Y','Y','Y','Y','Y','Y','Kanban de  atividades','Painel'),(1,'grid_LGPD_2001_form_entr_prc','Y','Y','Y','Y','Y','Y',NULL,'Fluxo de Informação'),(1,'grid_LGPD_2003_envio_entr_prc','Y','Y','Y','Y','Y','Y',NULL,'Fluxo de Informação'),(1,'grid_LGPD_2040_assoc_prc_atv','Y','','','','Y','Y','[Item de menu] - Fluxo de Informação / Associações do Fluxo de Informação: Acesso à consulta das associações entre Processos de Negócio x Ativos de Informação x Artefatos x Metadados Pessoais','Fluxo de Informação'),(1,'grid_LGPD_2075_assoc_funcional_dados_fin','Y','','','','Y','Y','Consulta associação de metadados','Painel'),(1,'grid_LGPD_2087_ndas','Y','Y','Y','Y','Y','Y',NULL,'Políticas e Regulamentos'),(1,'grid_LGPD_2097_assoc_med_atv','Y','','','','Y','Y','[Item de menu] - Medidas Técnicas de Segurança / Associações com Ativos de Informação: Acesso à configuração da associação entre Medidas Técnicas de Segurança e Ativos de Informação utilizados pela entidade','Medidas Técnicas de Segurança'),(1,'grid_LGPD_3100_assoc_risc_atv','Y','','','','Y','Y','[Item de menu] - Riscos / Associações de Riscos: Acesso à associações entre Riscos e outras informações cadastradas','Riscos'),(1,'grid_LGPD_3600_chklst_risk_area_mestre','Y','Y','Y','Y','Y','Y','[Item de menu] - Riscos / Checklist por área de identificação de riscos e atividades','Riscos'),(1,'grid_LGPD_6300_aluno_treina',NULL,NULL,NULL,NULL,NULL,NULL,'Consulta de lista de treinamentos realizados por colaborador','Painel'),(1,'grid_LGPD_7400_resp_aval_forne','Y','','','','Y','Y','Consulta respostas de questionários  (Due Diligence)','Painel'),(1,'grid_new','Y','Y','Y','Y','Y','Y',NULL,NULL),(1,'grid_new_pln_acao','Y','Y','Y','Y','Y','Y','[Item de menu] - Atividades e Ações / Plano de Ação LGPD: Acesso ao cadastro do documento \"Plano de Ação\" de adequação à LGPD','Atividades e Ações'),(1,'grid_public_LGPD_0100_diagnostico','Y','Y','Y','Y','Y','Y','[Item de menu] - Configurações / Projeto de Diagnóstico da LGPD: Acesso à configuração das informações sobre o projeto de Diagnóstico da LGPD','Configurações'),(1,'grid_public_LGPD_0200_implement','Y','Y','Y','Y','Y','Y','[Item de menu] - Configurações / Projeto de Adequação da LGPD: Acesso à configuração das informações sobre o projeto de Adequação da LGPD','Configurações'),(1,'grid_public_LGPD_0300_operacao','Y','Y','Y','Y','Y','Y','[Item de menu] - Configurações / Projeto de Operação da LGPD: Acesso à configuração das informações sobre a fase de Operação da LGPD','Configurações'),(1,'grid_public_LGPD_0400_etapas','Y','Y','Y','Y','Y','Y','[Item de menu] - Configurações / Etapas do Diagnóstico da LGPD: Acesso à configuração das etapas do projeto de Diagnóstico de um projeto de adequação à LGPD','Configurações'),(1,'grid_public_LGPD_1000_controlador','Y','Y','Y','Y','Y','Y','[Item de menu] - Configurações / Entidade: Acesso à configuração dos dados da entidade','Configurações'),(1,'grid_public_LGPD_1001_diretoria','Y','Y','Y','Y','Y','Y','[Item de menu] - Estrutura Organizacional / Diretoria: Acesso ao cadastro de Diretorias, que é o nível mais alto da hierarquia organizacional da entidade','Estrutura Organizacional'),(1,'grid_public_LGPD_1002_area','Y','Y','Y','Y','Y','Y','[Item de menu] - Estrutura Organizacional / Área: Acesso ao cadastro de Áreas, que dividem uma determinada Diretoria na estrutura hierárquica da entidade','Estrutura Organizacional'),(1,'grid_public_LGPD_1003_departamento','Y','Y','Y','Y','Y','Y','[Item de menu] - Estrutura Organizacional / Departamentos: Acesso ao cadastro de Departamentos, que dividem uma determinada Área na estrutura hierárquica da entidade','Estrutura Organizacional'),(1,'grid_public_LGPD_1004_cargos','Y','Y','Y','Y','Y','Y','[Item de menu] - Estrutura Organizacional / Cargos: Acesso ao cadastro de Cargos a serem ocupados por pessoas da equipe que ocupem espaço na estrutura hierárquica da entidade','Estrutura Organizacional'),(1,'grid_public_LGPD_1050_organograma','Y','Y','Y','Y','Y','Y','[Item de menu] - Estrutura Organizacional / Lotação: Acesso ao cadastro de unidades de trabalho, onde é possível alocar as equipes da entidade','Estrutura Organizacional'),(1,'grid_public_LGPD_1051_comite','Y','Y','Y','Y','Y','Y','[Item de menu] - Estrutura Organizacional / Comitês: Acesso ao cadastro de comitês da entidade, que congregam uma ou mais pessoas previamente cadastradas','Estrutura Organizacional'),(1,'grid_public_LGPD_1053_eventos_comite','Y','Y','Y','Y','Y','Y','[Item de menu] - Atividades e Ações / Eventos de Comitê: Acesso ao cadastro de eventos associados aos Comitês da entidade','Atividades e Ações'),(1,'grid_public_LGPD_1053_sub_eventos_comite','Y','Y','Y','Y','Y','Y','Sub Consulta de Eventos','Painel'),(1,'grid_public_LGPD_1100_equipe','Y','Y','Y','Y','Y','Y','[Item de menu] - Estrutura Organizacional / Equipe: Acesso ao cadastro de pessoas que podem ocupar cargos na estrutura hierárquica da entidade. Essas pessoas serão associadas a diversas outras entidades tratadas na plataforma','Estrutura Organizacional'),(1,'grid_public_LGPD_2000_proc_aprv_prz_expirado','Y','Y','Y','Y','Y','Y','[Item de menu] - Atividades e Ações / Processos de Negócio Pendentes: Acesso à gestão de Processos de Negócio com SLA de aprovação expirado','Atividades e Ações'),(1,'grid_public_LGPD_2000_processos','Y','Y','Y','Y','Y','Y','[Item de menu] - Fluxo de Informação / Processos de Negócio: Acesso ao cadastro de Processos de Negócio que definem as rotinas operacionais da entidade','Fluxo de Informação'),(1,'grid_public_LGPD_2000_sub_proc_pessoa','Y','Y','Y','Y','Y','Y','Consulta processo por responsável','Painel'),(1,'grid_public_LGPD_2000_sub_processos_atv','Y','Y','Y','Y','Y','Y','Consulta processos por ativos','Painel'),(1,'grid_public_LGPD_2010_ativos','Y','Y','Y','Y','Y','Y','[Item de menu] - Fluxo de Informação / Ativos de Informação: Acesso ao cadastro de Ativos de Informação utilizados pela entidade na execução de seus Processos de Negócio','Fluxo de Informação'),(1,'grid_public_LGPD_2010_ativos_1','Y','Y','Y','Y','Y','Y','Consulta Ativos','Painel'),(1,'grid_public_LGPD_2010_ativos_n_utlz_fin','Y','Y','Y','Y','Y','Y','Processos disponivel para associação com finalidades','Painel'),(1,'grid_public_LGPD_2010_ativos_utlz_fin','Y','Y','Y','Y','Y','Y','Processos associados a finalidade','Painel'),(1,'grid_public_LGPD_2010_sub_ativos','Y','Y','Y','Y','Y','Y','Sub Consulta de Ativos','Painel'),(1,'grid_public_LGPD_2020_artefatos','Y','Y','Y','Y','Y','Y','[Item de menu] - Fluxo de Informação / Artefatos: Acesso ao cadastro de Artefatos e Documentos tratados nos Ativos de Informação utilizados pela entidade','Fluxo de Informação'),(1,'grid_public_LGPD_2020_artefatos_n_utlz_fin','Y','Y','Y','Y','Y','Y','Artefatos disponiveis para associação com finalidades','Painel'),(1,'grid_public_LGPD_2020_artefatos_utlz_fin','Y','Y','Y','Y','Y','Y','Artefatos associados a finalidades','Painel'),(1,'grid_public_LGPD_2030_assoc_art_metadados','Y','Y','Y','Y','Y','Y','Associação de Artefatos e metadados','Painel'),(1,'grid_public_LGPD_2030_dados','Y','Y','Y','Y','Y','Y','[Item de menu] - Fluxo de Informação / Metadados Pessoais: Acesso ao cadastro de Metadados Pessoais presentes nos diferentes Artefatos utilizados pela entidade','Fluxo de Informação'),(1,'grid_public_LGPD_2065_fund_legal','Y','Y','Y','Y','Y','Y','[Item de menu] - Aspectos Jurídicos / Fundamentos Legais: Acesso ao cadastro de Fundamentos Legais utilizados pela entidade','Aspectos Jurídicos'),(1,'grid_public_LGPD_2066_ambiente_reg','Y','Y','Y','Y','Y','Y','[Item de menu] - Aspectos Jurídicos / Ambientes regulatórios: Acesso ao cadastro de Ambientes Regulatórios a serem associados a Fundamentos Legais utilizados pela entidade','Aspectos Jurídicos'),(1,'grid_public_LGPD_2070_finalidades','Y','Y','Y','Y','Y','Y','[Item de menu] - Tratamento de Dados Pessoais / Parametrizar Finalidades de Tratamentos: Acesso à configuração dos aspectos e detalhes das Finalidades de Tratamento de Dados Pessoais previamente cadastradas','Tratamento de Dados Pessoais'),(1,'grid_public_LGPD_2070_registrar_finalidades','Y','Y','Y','Y','Y','Y','[Item de menu] - Tratamento de Dados Pessoais / Registrar Finalidade de Tratamento: Acesso ao cadastro de Finalidades de Tratamento de Dados Pessoais executadas pela entidade','Tratamento de Dados Pessoais'),(1,'grid_public_LGPD_2070_sub_contratos_finalidades','Y','Y','Y','Y','Y','Y','Sub consulta de contratos dentro da finalidade','Painel'),(1,'grid_public_LGPD_2070_sub_finalidades','Y','Y','Y','Y','Y','Y','Sub consulta de finalidades','Painel'),(1,'grid_public_LGPD_2073_assoc_ativos_fin','Y','Y','Y','Y','Y','Y','Associação de ativos na finalidade','Painel'),(1,'grid_public_LGPD_2075_assoc_metadados_fin','Y','Y','Y','Y','Y','Y','Associação de metadados na finalidade','Painel'),(1,'grid_public_LGPD_2080_politicas','Y','Y','Y','Y','Y','Y','[Item de menu] - Políticas e Regulamentos / Políticas: Acesso ao cadastro de políticas associadas à Governança de Privacidade da entidade','Políticas e Regulamentos'),(1,'grid_public_LGPD_2085_contratos','Y','Y','Y','Y','Y','Y','[Item de menu] - Políticas e Regulamentos / Contratos: Acesso ao cadastro de contratos e modelos de contratos utilizados pela entidade','Políticas e Regulamentos'),(1,'grid_public_LGPD_2090_terceiros','Y','Y','Y','Y','Y','Y','[Item de menu] - Gestão de terceiros / Terceiros: Acesso ao cadastro de entidades terceiras (PJ ou PF) associadas à entidade','Gestão de Terceiros'),(1,'grid_public_LGPD_2093_ocorr_terc','Y','Y','Y','Y','Y','Y','[Item de menu] - Gestão de terceiros / Ocorrências: Acesso ao cadastro de ocorrências relacionadas à Terceiros associados à entidade','Gestão de Terceiros'),(1,'grid_public_LGPD_2095_med_tec','Y','Y','Y','Y','Y','Y','[Item de menu] - Medidas Técnicas de Segurança / Medidas Técnicas de Segurança: Acesso ao cadastro de Medidas Técnicas de Segurança da Informação que podem ser associadas a Ativos cadastrados','Medidas Técnicas de Segurança'),(1,'grid_public_LGPD_2095_sub_med_tec','Y','Y','Y','Y','Y','Y','Sub Consulta de medidas técnicas','Painel'),(1,'grid_public_LGPD_3000_riscos','Y','Y','Y','Y','Y','Y','[Item de menu] - Riscos / Riscos: Acesso ao cadastro de Riscos de Privacidade e Compliance','Riscos'),(1,'grid_public_LGPD_3000_sub_consulta_riscos','Y','Y','Y','Y','Y','Y','Sub consulta de riscos','Painel'),(1,'grid_public_LGPD_3300_assoc_risc_prc','Y','Y','Y','Y','Y','Y','Associar risco a processos','Painel'),(1,'grid_public_LGPD_4000_atividades','Y','Y','Y','Y','Y','Y','[Item de menu] - Atividades e Ações / Atividades e Ações: Acesso ao cadastro de atividades e ações de governança e compliance','Atividades e Ações'),(1,'grid_public_LGPD_5000_cod_etica','Y','Y','Y','Y','Y','Y','[Item de menu] - Políticas e Regulamentos / Códigos e Regulamentos Internos: Acesso ao cadastro de documentos que definem as regras internas de Compliance da entidade','Políticas e Regulamentos'),(1,'grid_public_LGPD_5100_cod_conduta','Y','Y','Y','Y','Y','Y',NULL,NULL),(1,'grid_public_LGPD_6000_PDCA','Y','Y','Y','Y','Y','Y','[Item de menu] - Atividades e Ações / Gestão de ciclo de PDCA de Compliance: Acesso ao planejamento e gestão de ciclos de PDCA de Compliance','Atividades e Ações'),(1,'grid_public_LGPD_6000_SUB_PDCA','Y','Y','Y','Y','Y','Y','Sub consulta PDCA','Painel'),(1,'grid_public_LGPD_6100_catalog_treinamentos','Y','Y','Y','Y','Y','Y','[Item de menu] - Atividades e Ações / Catálogo de treinamentos: Acesso ao cadastro dos tipos de treinamentos que a entidade pode executar para suas equipes','Atividades e Ações'),(1,'grid_public_LGPD_6200_agenda_treina','Y','Y','Y','Y','Y','Y','[Item de menu] - Atividades e Ações / Agenda de Treinamentos: Acesso à gestão de agenda de treinamentos e capacitações internas da entidade','Atividades e Ações'),(1,'grid_public_LGPD_7300_envio_aval_forne','Y','Y','Y','Y','Y','Y','Consulta de questionários (Due Diligence)','Painel'),(1,'grid_public_LGPD_7300_envio_aval_forne_gerencial','Y','Y','Y','Y','Y','Y',NULL,'Gestão de Terceiros'),(1,'grid_public_LGPD_cons_rev_contr_6500','Y','Y','Y','Y','Y','Y','Consulta revisões de contrato','Painel'),(1,'grid_public_LGPD_cons_rev_medtec_6700','Y','Y','Y','Y','Y','Y','Consulta revisões de medidas técnicas','Painel'),(1,'grid_public_LGPD_cons_rev_pol_6300','Y','Y','Y','Y','Y','Y','Consulta revisão de políticas','Painel'),(1,'grid_public_LGPD_cons_rev_proc_6600','Y','Y','Y','Y','Y','Y','Consulta revisão de processos','Painel'),(1,'grid_public_LGPD_cons_rev_risk_6400','Y','Y','Y','Y','Y','Y','Consulta revisão de riscos','Painel'),(1,'grid_public_PAC_9000_DPIA','Y','Y','Y','Y','Y','Y',NULL,NULL),(1,'grid_public_PAC_9100_LIA','Y','Y','Y','Y','Y','Y',NULL,NULL),(1,'grid_public_PCP_9000_DPIA','Y','Y','Y','Y','Y','Y','Consulta DPIA',NULL),(1,'grid_public_pcp_9100_LIA','Y','Y','Y','Y','Y','Y','Consulta LIA ',NULL),(1,'grid_public_subconsulta_sec_users','Y','Y','Y','Y','Y','Y','Sub consulta de usuarios','Painel'),(1,'grid_sc_log','Y','','','','Y','Y','[Item de menu] - Segurança / Histórico de acessos: Acesso à consulta à histórico de acessos de usuários à plataforma','Segurança'),(1,'help_cadastro_titulares','Y','Y','Y','Y','Y','Y',NULL,NULL),(1,'help_ciclo_de_vida','Y','Y','Y','Y','Y','Y','Help Ciclo de vida','Painel'),(1,'help_finalidades_fundamentos','Y','Y','Y','Y','Y','Y','Help Finalidades','Painel'),(1,'help_geracao_atividades','Y','Y','Y','Y','Y','Y',NULL,NULL),(1,'help_geracao_riscos','Y','Y','Y','Y','Y','Y',NULL,NULL),(1,'help_gestao_consentimentos','Y','Y','Y','Y','Y','Y',NULL,NULL),(1,'help_gestao_incidentes','Y','Y','Y','Y','Y','Y',NULL,NULL),(1,'help_gestao_notificacao','Y','Y','Y','Y','Y','Y',NULL,NULL),(1,'help_integracao_portais','Y','Y','Y','Y','Y','Y',NULL,NULL),(1,'help_lotes_validacao','Y','Y','Y','Y','Y','Y',NULL,NULL),(1,'help_medidas_administrativas','Y','Y','Y','Y','Y','Y','Help medidas administrativas','Painel'),(1,'help_medidas_tecnicas','Y','Y','Y','Y','Y','Y','Help para medidas técnicas','Painel'),(1,'help_plano_acao_atividades','Y','Y','Y','Y','Y','Y','Help Atividades','Painel'),(1,'help_relatorios','Y','Y','Y','Y','Y','Y',NULL,NULL),(1,'help_riscos_e_impactos','Y','Y','Y','Y','Y','Y','Help Riscos','Painel'),(1,'homepage','Y','Y','Y','Y','Y','Y','Home Page (Responsábilidades e Atividades)','Painel'),(1,'homepage_help','Y','Y','Y','Y','Y','Y','Help','Painel'),(1,'mapa_calor_risco',NULL,NULL,NULL,NULL,NULL,NULL,'Mapa de risco','Painel'),(1,'Mapa_Calor_Riscos',NULL,NULL,NULL,NULL,NULL,NULL,'Mapa de calor de riscos ','Painel'),(1,'menu','Y','Y','Y','Y','Y','Y','Menu PCP','Painel'),(1,'menu_dinamico',NULL,NULL,NULL,NULL,NULL,NULL,'Menu','Painel'),(1,'Menu_Pac','Y','Y','Y','Y','Y','Y',NULL,NULL),(1,'Metadados','Y','Y','Y','Y','Y','Y','[Item de menu] - Painel / Metadados Pessoais: Acesso à exibição dos principais indicadores sobre Metadados Pessoais','Painel'),(1,'novo_menu','Y','Y','Y','Y','Y','Y',NULL,NULL),(1,'pac_app_change_pswd','Y','Y','Y','Y','Y','Y','[Item de menu] - SeguranÃ§a / AlteraÃ§Ã£o de senha: Acesso Ã  gestÃ£o de senhas de usuÃ¡rios da plataforma','SeguranÃ§a'),(1,'pac_app_form_sec_groups_apps','Y','Y','Y','Y','Y','Y','[Item de menu] - SeguranÃ§a / AssociaÃ§Ã£o de perfis a aplicaÃ§Ãµes: Acesso Ã  configuraÃ§Ã£o da associaÃ§Ã£o de perfis de acesso com as aplicaÃ§Ãµes da plataforma','SeguranÃ§a'),(1,'pac_app_grid_sec_apps','Y','Y','Y','Y','Y','Y','[Item de menu] - SeguranÃ§a / AplicaÃ§Ãµes: Acesso ao cadastro de aplicaÃ§Ãµes da plataforma','SeguranÃ§a'),(1,'pac_app_grid_sec_groups','Y','Y','Y','Y','Y','Y','[Item de menu] - SeguranÃ§a / Perfis: Acesso ao cadastro de perfis de acesso dos usuÃ¡rios da plataforma','SeguranÃ§a'),(1,'pac_app_grid_sec_users','Y','Y','Y','Y','Y','Y','[Item de menu] - SeguranÃ§a / UsuÃ¡rios: Acesso ao cadastro de usuÃ¡rios da plataforma','SeguranÃ§a'),(1,'pac_app_grid_sec_users_groups','Y','Y','Y','Y','Y','Y','[Item de menu] - SeguranÃ§a / AssociaÃ§Ã£o de usuÃ¡rios a perfis: Acesso Ã  configuraÃ§Ã£o da associaÃ§Ã£o de usuÃ¡rios a perfis de acesso','SeguranÃ§a'),(1,'pac_app_search_sec_groups','Y','Y','Y','Y','Y','Y','[Item de menu] - SeguranÃ§a / AssociaÃ§Ã£o de perfis a aplicaÃ§Ãµes: Acesso Ã  configuraÃ§Ã£o da associaÃ§Ã£o de perfis de acesso com as aplicaÃ§Ãµes da plataforma','SeguranÃ§a'),(1,'pac_menu','Y','Y','Y','Y','Y','Y',NULL,NULL),(1,'PAG_menu','Y','Y','Y','Y','Y','Y',NULL,NULL),(1,'param_aval_mestre_7000','Y','Y','Y','Y','Y','Y','[Item de menu] - Gestão de terceiros / Formulários de due diligence: Acesso à criação de formulários (e suas questões) para auto avaliação de terceiros','Gestão de Terceiros'),(1,'PCP_Privacy_Compliance_Project_20231030144841000000.tar',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(1,'PDCA','Y','Y','Y','Y','Y','Y','[Item de menu] - Painel / Ciclos de PDCA: Acesso à exibição dos principais indicadores sobre Ciclos de PDCA de Compliance','Painel'),(1,'pdfreport_LGPD_7300_envio_aval_forne','Y','','','','Y','Y','geração de PDF - questionário (Due Diligence)','Painel'),(1,'popup_confirm_action','Y','','','','Y','Y','Pop-up ( não se aplica ao módulo de segirança)','Painel'),(1,'popup_confirm_action_status','Y','','','','Y','Y','Pop_Up ( Não se plaica ao módulo de segurança ) ','Painel'),(1,'Processos','Y','Y','Y','Y','Y','Y','[Item de menu] - Painel / Processos de Negócio: Acesso à exibição dos principais indicadores sobre Processos de Negócio','Painel'),(1,'relatorio_ciclos_complience',NULL,NULL,NULL,NULL,NULL,NULL,'Extrato de cilco de auditoria ','Painel'),(1,'relatorio_dpia','Y','Y','Y','Y','Y','Y',NULL,NULL),(1,'relatorio_dpia_1','Y','Y','Y','Y','Y','Y',NULL,NULL),(1,'relatorio_finalidades','Y','Y','Y','Y','Y','Y','Relatório de finalidades','Painel'),(1,'relatorio_lia','Y','Y','Y','Y','Y','Y',NULL,NULL),(1,'relatorio_notificacao','Y','Y','Y','Y','Y','Y',NULL,NULL),(1,'relatorio_resp_aval','Y','','','','Y','Y','Relatório Avaliações','Painel'),(1,'resumo_finalidade','Y','Y','Y','Y','Y','Y','Resumo de finalidade','Painel'),(1,'Riscos','Y','Y','Y','Y','Y','Y','[Item de menu] - Painel / Riscos: Acesso à exibição dos principais indicadores sobre Gestão de Riscos de Privacidade e Compliance','Painel'),(1,'risk_heat_map','Y','Y','Y','Y','Y','Y','[Item de menu] - Riscos / Mapa de Calor: Acesso à exibição do Mapa de Calor dos Riscos cadastrados','Riscos'),(1,'search_public_LGPD_4000_atividades','Y','Y','Y','Y','Y','Y','Filtro de atividades','Painel'),(1,'sec_change_pswd','Y','Y','Y','Y','Y','Y',NULL,NULL),(1,'sec_form_add_users','Y','Y','Y','Y','Y','Y',NULL,NULL),(1,'sec_form_edit_users','Y','Y','Y','Y','Y','Y',NULL,NULL),(1,'sec_form_sec_apps','Y','Y','Y','Y','Y','Y',NULL,NULL),(1,'sec_form_sec_groups','Y','Y','Y','Y','Y','Y',NULL,NULL),(1,'sec_form_sec_groups_apps','Y','Y','Y','Y','Y','Y',NULL,NULL),(1,'sec_grid_sec_apps','Y','Y','Y','Y','Y','Y',NULL,NULL),(1,'sec_grid_sec_groups','Y','Y','Y','Y','Y','Y',NULL,NULL),(1,'sec_grid_sec_users','Y','Y','Y','Y','Y','Y',NULL,NULL),(1,'sec_grid_sec_users_groups','Y','Y','Y','Y','Y','Y',NULL,NULL),(1,'sec_Login','Y','Y','Y','Y','Y','Y',NULL,NULL),(1,'sec_menu','Y','Y','Y','Y','Y','Y',NULL,NULL),(1,'sec_retrieve_pswd','Y','Y','Y','Y','Y','Y',NULL,NULL),(1,'sec_search_sec_groups','Y','Y','Y','Y','Y','Y',NULL,NULL),(1,'sec_settings','Y','Y','Y','Y','Y','Y',NULL,NULL),(1,'sec_sync_apps','Y','Y','Y','Y','Y','Y',NULL,NULL),(1,'sub_consulta_3000_riscos_incidente','Y','Y','Y','Y','Y','Y',NULL,NULL),(1,'sub_consulta_3100_assoc_risc_atv','Y','Y','Y','Y','Y','Y',NULL,NULL),(1,'sub_consulta_3300_assoc_risc_prc','Y','Y','Y','Y','Y','Y',NULL,NULL),(1,'sub_consulta_3400_assoc_risc_fin','Y','Y','Y','Y','Y','Y',NULL,NULL),(1,'sub_consulta_CMP_1610_ol_agenda',NULL,NULL,NULL,NULL,NULL,NULL,'Sub consulta de agenda de obrigações legais por obrigação','Painel'),(1,'sub_consulta_CMP_2510_det_conf_entrevistados',NULL,NULL,NULL,NULL,NULL,NULL,'Entrevitados em presquisa de auditoria --> Sub Consulta de configuração de entrevidados de pesquisa de auditoria ','Painel'),(1,'sub_consulta_CMP_3000_aplic',NULL,NULL,NULL,NULL,NULL,NULL,'Sub consulta status da aplicação de pesquisa de auditoria','Painel'),(1,'sub_consulta_CMP_4000_respostas_mestre',NULL,NULL,NULL,NULL,NULL,NULL,'Sub consulta status de respostas dos formulários de auditoria dentro de um ciclo ','Painel'),(1,'sub_consulta_configurar_metadados','Y','Y','Y','Y','Y','Y','Sub consulta configuração de metadados','Painel'),(1,'sub_consulta_LGPD_2097_assoc_med_atv',NULL,NULL,NULL,NULL,NULL,NULL,'Sub consulta de associação entre medidas técnicas e ativos','Painel'),(1,'sub_consulta_LGPD_6200_agenda_treina',NULL,NULL,NULL,NULL,NULL,NULL,'Sub consulta de agenda de treinamentos ','Painel'),(1,'sub_consulta_PAC_1100_sol_portal','Y','Y','Y','Y','Y','Y',NULL,NULL),(1,'sub_consulta_PAC_3200_tit_consent','Y','Y','Y','Y','Y','Y',NULL,NULL),(1,'sub_consulta_PAC_4000_notificacao','Y','Y','Y','Y','Y','Y',NULL,NULL),(1,'sub_consulta_PAG_ocorr_lote_1100','Y','Y','Y','Y','Y','Y',NULL,NULL),(1,'sub_form_configurar_metados','Y','Y','Y','Y','Y','Y','Configurar metadados','Painel'),(1,'sub_grid_CMP_1550_ger_acao',NULL,NULL,NULL,NULL,NULL,NULL,'Sub grid de recomendaçoes de auditoria por ciclo','Painel'),(1,'sub_grid_LGPD_2050_assoc_atv_art',NULL,NULL,NULL,NULL,NULL,NULL,'Sub consulta de associação entre ativos e artefatos',NULL),(1,'sub_grid_PAC_1400_tit_afet_inc','Y','Y','Y','Y','Y','Y',NULL,NULL),(1,'sub_grid_public_LGPD_2093_ocorr_terc','Y','Y','Y','Y','Y','Y','Sub consulta ocorrência de terceiros','Painel'),(1,'Teste',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(2,'app_change_pswd','Y','','','','Y','Y','[Item de menu] - Segurança / Alteração de senha: Acesso à gestão de senhas de usuários da plataforma','Segurança'),(2,'app_form_add_users','Y','Y','Y','Y','','','Cadastrar usuários','Formulário'),(2,'app_form_edit_users','Y','Y','Y','Y','','','Alterar usuários','Formulário'),(2,'app_form_sec_apps','Y','Y','Y','Y','','','Cadastrar aplicações','Formulário'),(2,'app_form_sec_groups','Y','Y','Y','Y','','','Cadastro de grupos de usuários','Formulário'),(2,'app_form_sec_groups_apps','Y','Y','Y','Y','','','Associar grupos x aplicações','Painel'),(2,'app_grid_sec_apps','','','','','','','[Item de menu] - Segurança / Aplicações: Acesso ao cadastro de aplicações da plataforma','Segurança'),(2,'app_grid_sec_groups','','','','','','','[Item de menu] - Segurança / Perfis: Acesso ao cadastro de perfis de acesso dos usuários da plataforma','Segurança'),(2,'app_grid_sec_users','Y','','','','Y','Y','[Item de menu] - Segurança / Usuários: Acesso ao cadastro de usuários da plataforma','Segurança'),(2,'app_grid_sec_users_groups','Y','','','','Y','Y','[Item de menu] - Segurança / Associação de usuários a perfis: Acesso à configuração da associação de usuários a perfis de acesso','Segurança'),(2,'app_Login','Y',NULL,NULL,NULL,'Y','Y','Login',NULL),(2,'app_menu','Y',NULL,NULL,NULL,'Y','Y','Menu','Painel'),(2,'app_retrieve_pswd','Y',NULL,NULL,NULL,'Y','Y','Esqueceu a senha','Painel'),(2,'app_search_sec_groups','','','','','','','[Item de menu] - Segurança / Associação de perfis a aplicações: Acesso à configuração da associação de perfis de acesso com as aplicações da plataforma','Segurança'),(2,'app_settings','','','','','','','Configurações de segurança','Segurança'),(2,'app_sync_apps','','','','','','','Sincronização de aplicações','Segurança'),(2,'Artefatos','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Painel / Artefatos: Acesso à exibição dos principais indicadores sobre Artefatos e Documentos','Painel'),(2,'associar_metadados_finalidade','Y',NULL,NULL,NULL,'Y','Y','Associar metadados na finalidade','Painel'),(2,'associar_metadados_finalidade_new','Y',NULL,NULL,NULL,'Y','Y','Associar metadados a finalidades','Painel'),(2,'Atividades','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Painel / Atividades e Ações: Acesso à exibição dos principais indicadores sobre Atividades e Ações','Painel'),(2,'Ativos','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Painel / Ativos de Informação: Acesso à exibição dos principais indicadores sobre Ativos de Informação','Painel'),(2,'Auto_cadastro_PAC_4000_notificacao','Y',NULL,NULL,NULL,'Y','Y',NULL,NULL),(2,'blank_email','Y',NULL,NULL,NULL,'Y','Y','Enviar mail','Painel'),(2,'blank_pipeline','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Atividades e Ações / Meu Quadro de Atividades: Acesso ao Kanban de atividades do usuário logado','Atividades e Ações'),(2,'blank_pipeline_Ajax','Y',NULL,NULL,NULL,'Y','Y','Pipeline de atividades','Painel'),(2,'cad_sol_dpia_pcp_9000','Y',NULL,NULL,NULL,'Y','Y',NULL,'Fluxo de Informação'),(2,'Cadastro_DEN_1000_registro','Y',NULL,NULL,NULL,'Y','Y',NULL,NULL),(2,'Cadastro_DEN_1100_cat','Y',NULL,NULL,NULL,'Y','Y',NULL,NULL),(2,'cadastro_PAC_1110_atv_sol',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(2,'cadastro_PAC_1200_sla_sol_portal',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(2,'Cadastro_PAC_1400_titulares','Y',NULL,NULL,NULL,'Y','Y',NULL,NULL),(2,'Cadastro_PAC_1410_dados_tit','Y',NULL,NULL,NULL,'Y','Y',NULL,NULL),(2,'Cadastro_PAC_2000_incidentes','Y',NULL,NULL,NULL,'Y','Y',NULL,NULL),(2,'Cadastro_PAC_2100_sla_notificacao','Y',NULL,NULL,NULL,'Y','Y',NULL,NULL),(2,'Cadastro_PAC_3100_env_consent','Y',NULL,NULL,NULL,'Y','Y',NULL,NULL),(2,'Cadastro_PAC_4000_notificacao','Y',NULL,NULL,NULL,'Y','Y',NULL,NULL),(2,'Cadastro_PAG_lote_1000','Y',NULL,NULL,NULL,'Y','Y',NULL,NULL),(2,'cadastro_PAG_ocorr_lote_1100','Y',NULL,NULL,NULL,'Y','Y',NULL,NULL),(2,'calendar_app',NULL,NULL,NULL,NULL,NULL,NULL,'Calendário','Painel'),(2,'calendar_public_LGPD_4000_atividades','','','','','','','Calendário de atividades ( DPO )','Painel'),(2,'chart_public_LGPD_2000_processos_complex','Y',NULL,NULL,NULL,'Y','Y','Gráfico processo por complexidade','Painel'),(2,'chart_public_LGPD_2000_processos_geral','Y',NULL,NULL,NULL,'Y','Y','Gráfico processos','Painel'),(2,'chart_public_LGPD_2000_processos_resp','Y',NULL,NULL,NULL,'Y','Y','Gráfico processos por responsável','Painel'),(2,'chart_public_LGPD_2000_status_processos','Y',NULL,NULL,NULL,'Y','Y','Gráfico processo por status','Painel'),(2,'chart_public_LGPD_2000_tipo_processo','Y',NULL,NULL,NULL,'Y','Y','Gráfico processos por tipo','Painel'),(2,'chart_public_LGPD_2010_confia_ativos','Y',NULL,NULL,NULL,'Y','Y','Gráfico confibilidade dos ativos','Painel'),(2,'chart_public_LGPD_2010_disp_ativos','Y',NULL,NULL,NULL,'Y','Y','Gráfico ativos por nível de disponibilidade','Painel'),(2,'chart_public_LGPD_2010_integridade_ativos','Y',NULL,NULL,NULL,'Y','Y','Gráfico ativos por nível de integridade','Painel'),(2,'chart_public_LGPD_2010_resp_ativos','Y',NULL,NULL,NULL,'Y','Y','Gráfico ativos por responsável','Painel'),(2,'chart_public_LGPD_2010_tipo_ativos','Y',NULL,NULL,NULL,'Y','Y','Gráfico tipos de ativos','Painel'),(2,'chart_public_LGPD_2020_artefat_contrato','Y',NULL,NULL,NULL,'Y','Y','Gráfico artefatos tipo contrato','Painel'),(2,'chart_public_LGPD_2020_contrato_artefatos','Y',NULL,NULL,NULL,'Y','Y','Gráfico contratos x artefatos','Painel'),(2,'chart_public_LGPD_2020_tipo_artefatos','Y',NULL,NULL,NULL,'Y','Y','Gráfico artefatos por tipo','Painel'),(2,'chart_public_LGPD_2030_classif_dados','Y',NULL,NULL,NULL,'Y','Y','Gráfico classificação de metadados','Painel'),(2,'chart_public_LGPD_2030_dados_anonimizavel','Y',NULL,NULL,NULL,'Y','Y','Gráfico metadados anonimizavel','Painel'),(2,'chart_public_LGPD_2030_tipif_dados','Y',NULL,NULL,NULL,'Y','Y','Gráfico tipos de dados','Painel'),(2,'chart_public_LGPD_2070_fin_compart_dados','Y',NULL,NULL,NULL,'Y','Y','Gráfico finalidades por compartilhamento','Painel'),(2,'chart_public_LGPD_2070_fin_dad_criancas','Y',NULL,NULL,NULL,'Y','Y','Gráfico finalidades por dados de crianças','Painel'),(2,'chart_public_LGPD_2070_fin_faz_descarte','Y',NULL,NULL,NULL,'Y','Y','Gráfico finalidades por descarte','Painel'),(2,'chart_public_LGPD_2070_fin_frequencia','Y',NULL,NULL,NULL,'Y','Y','Gráfico finalidades por ferequencia','Painel'),(2,'chart_public_LGPD_2070_fin_hipoteses','Y',NULL,NULL,NULL,'Y','Y','Gráfico finalidades por hipóteses de tratamento','Painel'),(2,'chart_public_LGPD_2070_fin_papel','Y',NULL,NULL,NULL,'Y','Y','Gráfico papel da entidade','Painel'),(2,'chart_public_LGPD_2070_fin_processos','Y',NULL,NULL,NULL,'Y','Y','Gráfico finalidades por processos','Painel'),(2,'chart_public_LGPD_2070_fin_rot_automatizada','Y',NULL,NULL,NULL,'Y','Y','Gráfico finalidades por rotinas automatizadas','Painel'),(2,'chart_public_LGPD_2070_fin_utlz_operador','Y',NULL,NULL,NULL,'Y','Y','Gráfico finalidades por utiliza operador','Painel'),(2,'chart_public_LGPD_2070_fin_volumetria','Y',NULL,NULL,NULL,'Y','Y','Gráfico finliadades por volumetria','Painel'),(2,'chart_public_LGPD_3000_categoria_riscos','Y',NULL,NULL,NULL,'Y','Y','Gráfico riscos por categoria','Painel'),(2,'chart_public_LGPD_3000_criticidade_riscos','Y',NULL,NULL,NULL,'Y','Y','Gráfico riscos por criticidade','Painel'),(2,'chart_public_LGPD_3000_estrategia_riscos','Y',NULL,NULL,NULL,'Y','Y','Gráfico riscos por estratégia','Painel'),(2,'chart_public_LGPD_3000_impacto_riscos','Y',NULL,NULL,NULL,'Y','Y','Gráfico riscos por impacto','Painel'),(2,'chart_public_LGPD_3000_prob_riscos','Y',NULL,NULL,NULL,'Y','Y','Gráfico riscos por probabilidade','Painel'),(2,'chart_public_LGPD_3000_resp_riscos','Y',NULL,NULL,NULL,'Y','Y','Gráfico riscos por responsáveis','Painel'),(2,'chart_public_LGPD_3000_status_riscos','Y',NULL,NULL,NULL,'Y','Y','Gráfico riscos por status','Painel'),(2,'chart_public_LGPD_4000_atividades_geral','Y',NULL,NULL,NULL,'Y','Y','Gráfico atividades','Painel'),(2,'chart_public_LGPD_4000_disc_atividades','Y',NULL,NULL,NULL,'Y','Y','Gráfico atividades por disciplina','Painel'),(2,'chart_public_LGPD_4000_etapa_atividades','Y',NULL,NULL,NULL,'Y','Y','Gráfico atividades por etapas','Painel'),(2,'chart_public_LGPD_4000_resp_atividades','Y',NULL,NULL,NULL,'Y','Y','Gráfico atividades por responsável','Painel'),(2,'chart_public_LGPD_4000_status_resp_atividade','Y',NULL,NULL,NULL,'Y','Y','Gráfico atividades por responsável e status','Painel'),(2,'chart_public_LGPD_assoc_pdca_contr_6500','Y',NULL,NULL,NULL,'Y','Y','Gráfico PDCA de contratos','Painel'),(2,'chart_public_LGPD_assoc_pdca_finalizados_treina_6500','Y',NULL,NULL,NULL,'Y','Y','Gráfico PDCA de treinamentos','Painel'),(2,'chart_public_LGPD_assoc_pdca_medtec_6700','Y',NULL,NULL,NULL,'Y','Y','Gráfico PDCA de medidas técnicas','Painel'),(2,'chart_public_LGPD_assoc_pdca_pol_6300','Y',NULL,NULL,NULL,'Y','Y','Gráfico PDCA de políticas','Painel'),(2,'chart_public_LGPD_assoc_pdca_proc_6600','Y',NULL,NULL,NULL,'Y','Y','Gráfico PDCA de processos','Painel'),(2,'chart_public_LGPD_assoc_pdca_realizar_treina_6500','Y',NULL,NULL,NULL,'Y','Y','Gráfico PDCA realização de treinamentos','Painel'),(2,'chart_public_LGPD_assoc_pdca_risk_6400','Y',NULL,NULL,NULL,'Y','Y','Gráfico PDCA de riscos','Painel'),(2,'cons_dad_nao_utlz_LGPD_2030_dados','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Fluxo de Informação / Metadados Pessoais não utilizados: Acesso à consulta dos Metadados Pessoais cadastrados mas não utilizados em nenhuma associação','Fluxo de Informação'),(2,'cons_minhas_obr_CMP_1610_ol_agenda','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Aspectos Jurídicos / Minhas Obrigações Legais: Acesso ao cadastro das obrigações legais da entidade que estão sob a responsabilidade do usuário logado','Aspectos Jurídicos'),(2,'Consulta_DEN_1000_registro','Y',NULL,NULL,NULL,'Y','Y',NULL,NULL),(2,'Consulta_DEN_1100_cat','Y',NULL,NULL,NULL,'Y','Y',NULL,NULL),(2,'consulta_gerencial_CMP_1610_ol_agenda','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Aspectos Jurídicos / Acompanhamento de Obrigações Legais: Acesso ao painel de acompanhamento do status das obrigações legais da entidade','Aspectos Jurídicos'),(2,'consulta_gerencial_LGPD_4000_atividades','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Atividades e Ações / Acompanhamento de Atividades e Ações: Acesso ao painel de acompanhamento do status das obrigações legais da entidade','Atividades e Ações'),(2,'Consulta_LGPD_3000_riscos_assistant','','','','','','',NULL,NULL),(2,'Consulta_LGPD_4000_atividades_assistant','','','','','','',NULL,NULL),(2,'Consulta_PAC_1000_user_portal','Y',NULL,NULL,NULL,'Y','Y',NULL,NULL),(2,'Consulta_PAC_1100_sol_portal','Y',NULL,NULL,NULL,'Y','Y',NULL,NULL),(2,'consulta_PAC_1200_sla_sol_portal',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(2,'Consulta_PAC_1400_titulares','Y',NULL,NULL,NULL,'Y','Y',NULL,NULL),(2,'Consulta_PAC_1410_dados_tit','Y',NULL,NULL,NULL,'Y','Y',NULL,NULL),(2,'Consulta_PAC_2000_incidentes','Y',NULL,NULL,NULL,'Y','Y',NULL,NULL),(2,'Consulta_PAC_3100_env_consent','Y',NULL,NULL,NULL,'Y','Y',NULL,NULL),(2,'Consulta_PAC_4000_notificacao','Y',NULL,NULL,NULL,'Y','Y',NULL,NULL),(2,'Consulta_PAG_lote_1000','Y',NULL,NULL,NULL,'Y','Y',NULL,NULL),(2,'Consulta_public_LGPD_3000_riscos','Y',NULL,NULL,NULL,'Y','Y',NULL,NULL),(2,'control_calendar',NULL,NULL,NULL,NULL,NULL,NULL,'Meu calendário de atividades de adequação',NULL),(2,'control_login','Y',NULL,NULL,NULL,'Y','Y','Login','Painel'),(2,'control_login_diligence',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(2,'esqueci_senha','Y',NULL,NULL,NULL,'Y','Y','Esqueceu a senha','Painel'),(2,'extrato_pdca','Y',NULL,NULL,NULL,'Y','Y','Extrato PDCA','Painel'),(2,'Finalidades','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Painel / Finalidades de Tratamento de Dados Pessoais: Acesso à exibição dos principais indicadores sobre Finalidades de Tratamento de Dados Pessoais','Painel'),(2,'form_aval_7000','Y',NULL,NULL,NULL,'Y','Y','Formulários de due diligence: Acesso à criação de formulários (e suas questões) para auto avaliação de terceiros','Gestão de Terceiros'),(2,'form_CMP_1000_mecanismos','','','','',NULL,NULL,'Cadastro de mecanismos de auditoria ','Formulário'),(2,'form_CMP_1100_componentes','','','','',NULL,NULL,'Cadastro de componentes de auditoria','Formulário'),(2,'form_CMP_1200_questoes','','','','',NULL,NULL,'Cadastro de questões de auditoria','Formulário'),(2,'form_CMP_1300_formularios','','','','',NULL,NULL,'Cadatro de formulários de auditoria ','Formulário'),(2,'form_CMP_1300_formularios_edit','','','','',NULL,NULL,'Edição de formulários de auditoria','Formulário'),(2,'form_CMP_1400_formulas_mestre','','','','',NULL,NULL,'Parametrização de Setup de Auditoria','Formulário'),(2,'form_CMP_1400_formulas_view','','','','',NULL,NULL,'Visualizar setup de auditoria','Formulário'),(2,'form_CMP_1410_formulas_det_mec','','','','',NULL,NULL,'Parametrizar mecanismos de auditoria no setup','Formulário'),(2,'form_CMP_1420_formulas_det_niv_ad','','','','',NULL,NULL,'Parametrizar níveis de aderência do setup de auditoria ','Formulário'),(2,'form_CMP_1430_formulas_det_lim','','','','',NULL,NULL,'Parametrizar faixas do setup de auditoria','Formulário'),(2,'form_CMP_1500_acao','','','','',NULL,NULL,'Recomendações de auditorias','Formulário'),(2,'form_CMP_1600_OL','','','','',NULL,NULL,'Cadastro de Obrigações Legais ','Formulário'),(2,'form_CMP_2000_ciclos','','','','',NULL,NULL,'Cadastro de ciclos de auditoria','Formulário'),(2,'form_CMP_2500_conf_entrevistados','','','','',NULL,NULL,'Cadastro de entrevistados do ciclo de auditoria ','Formulário'),(2,'form_CMP_2500_conf_entrevistados_1','','','','',NULL,NULL,'Cadastro de entrevistados ','Formulário'),(2,'form_CMP_2500_conf_param_entrevistados','','','','',NULL,NULL,'Parametrizar relação de entrevistados de um ciclo de auditoria','Formulário'),(2,'form_CMP_3000_aplic_pesq','','','','',NULL,NULL,'Cadastro de aplicação de pesquisa de auditorias ','Formulário'),(2,'form_CMP_resultados_pesquisas','','','','',NULL,NULL,'Cadastro de resultado de pesquisas de auditoria','Formulário'),(2,'form_conf_quest_7100','Y','Y','Y','Y','Y','Y','Configurar questionário de fornecedores','Formulário'),(2,'form_diligence',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(2,'form_DOM_tp_ol_1600','','','','',NULL,NULL,'Cadastro de tipos de obrigações ','Formulário'),(2,'form_kanban_atividades','Y','Y','Y','Y','Y','Y','Kanban de  atividades','Formulário'),(2,'form_kanban_atividades_add_registro','Y','Y','Y','Y','Y','Y','Cadastrar atividades pelo kanban','Formulário'),(2,'form_LGPD_0002_conf_smpt','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Configurações / Configuração de envio de e-mails: Acesso à configuração do endereço de de SMTP para envio de e-mails da plataforma','Formulário'),(2,'form_LGPD_2001_form_entr_prc','Y',NULL,NULL,NULL,'Y','Y',NULL,'Fluxo de Informação'),(2,'form_LGPD_2003_envio_entr_prc','Y',NULL,NULL,NULL,'Y','Y',NULL,'Fluxo de Informação'),(2,'form_LGPD_2087_ndas','Y',NULL,NULL,NULL,'Y','Y',NULL,'Fluxo de Informação'),(2,'form_LGPD_2097_assoc_med_atv',NULL,NULL,NULL,NULL,NULL,NULL,'Cadastro de Medidas Técnicas - > Cadastro da especificação da associação entre medida técnica e ativo','Painel'),(2,'form_LGPD_3500_checklist_risk_padrao','Y','','','','Y','Y','[Item de menu] - Riscos / Checklist padrão de identificação de riscos e atividades','Riscos'),(2,'form_LGPD_3600_chklst_risk_area_mestre','Y','','','','Y','Y','Formulário de checklist por área de identificação de riscos e atividades','Riscos'),(2,'form_LGPD_4000_atividades','Y','Y','Y','Y',NULL,NULL,'Cadastro de atividades de adequação','Formulário'),(2,'form_LGPD_4000_atividades_calendar',NULL,NULL,NULL,NULL,NULL,NULL,'Cadastro de atividades de adequação','Formulário'),(2,'form_minhas_obr_CMP_1610_ol_agenda',NULL,NULL,NULL,NULL,NULL,NULL,'Edição das minhas obrigações legais ','Painel'),(2,'form_new_pln_acao','Y','Y','Y','Y','Y','Y','Cadastrar plano de ação','Formulário'),(2,'form_PAC_1100_sol_portal',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(2,'form_pcp_9100_LIA','Y',NULL,NULL,NULL,'Y','Y',NULL,'Fluxo de Informação'),(2,'form_public_LGPD_0100_diagnostico','Y','Y','Y','Y','','','Parametrizar etapa de diagnóstico','Formulário'),(2,'form_public_LGPD_0200_implement','Y','Y','Y','Y','','','Parametrizar etapa de implementação','Formulário'),(2,'form_public_LGPD_0300_operacao','Y','Y','Y','Y','','','Parametrizar etapa de operação','Formulário'),(2,'form_public_LGPD_0400_etapas','Y','Y','Y','Y','','','Parametrizar etapas','Formulário'),(2,'form_public_LGPD_1000_controlador','Y','Y','Y','Y','','','Cadastro de controlador','Formulário'),(2,'form_public_LGPD_1001_diretoria','Y','Y','Y','Y','','','Cadastro de diretoria','Formulário'),(2,'form_public_LGPD_1002_area','Y','Y','Y','Y','','','Cadastro de área','Formulário'),(2,'form_public_LGPD_1003_departamento','Y','Y','Y','Y','','','Cadastro de departamentos','Formulário'),(2,'form_public_LGPD_1004_cargos','Y','Y','Y','Y','','','Cadastro de cargos','Formulário'),(2,'form_public_LGPD_1050_organograma','Y','Y','Y','Y','','','Cadastro de organograma','Formulário'),(2,'form_public_LGPD_1051_comite','Y','Y','Y','Y','','','Cadastro de comitê','Formulário'),(2,'form_public_LGPD_1053_eventos_comite','Y','','','','','','Agenda de eventos do comitê','Formulário'),(2,'form_public_LGPD_1100_equipe','Y','Y','Y','Y','','','Cadastro de equipe','Formulário'),(2,'form_public_LGPD_1100_equipe_1','Y','Y','Y','Y','Y','Y','Cadastro de equipe','Formulário'),(2,'form_public_LGPD_2000_processos','Y','Y','Y','Y','Y','Y','Cadastro de processos','Formulário'),(2,'form_public_LGPD_2010_ativos','Y','Y','Y','Y','Y','Y','Cadastro de ativos','Formulário'),(2,'form_public_LGPD_2020_artefatos','Y','Y','Y','Y','Y','Y','Cadastro de artefatos','Formulário'),(2,'form_public_LGPD_2030_dados','Y','Y','Y','Y','Y','Y','Cadastro de metadados','Formulário'),(2,'form_public_LGPD_2060_config_assoc','Y',NULL,NULL,NULL,'Y','Y','Associação artefato x metadados','Formulário'),(2,'form_public_LGPD_2065_fund_legal','Y','Y','Y','Y','Y','Y','Cadastro de fundamentos legais','Formulário'),(2,'form_public_LGPD_2066_ambiente_reg','Y','Y','Y','Y','Y','Y','Cadastro de ambientes regulatórios','Formulário'),(2,'form_public_LGPD_2070_finalidades','Y','Y','Y','Y','Y','Y','Parametrizar finalidades','Formulário'),(2,'form_public_LGPD_2070_registrar_finalidades','Y','Y','Y','Y','Y','Y','Registrar finalidades','Formulário'),(2,'form_public_LGPD_2075_param_assoc_funcional_fin','Y',NULL,NULL,NULL,'Y','Y','Associação funcional da finalidade','Formulário'),(2,'form_public_LGPD_2080_politicas','Y','Y','Y','Y','Y','Y','Cadastro de políticas','Formulário'),(2,'form_public_LGPD_2085_contratos','Y','Y','Y','Y','Y','Y','Cadastro de contratos','Formulário'),(2,'form_public_LGPD_2090_terceiros','Y','Y','Y','Y','Y','Y','Cadastro de terceiros','Formulário'),(2,'form_public_LGPD_2093_ocorr_terc','Y','Y','Y','Y','Y','Y','Cadastro de ocorrência de terceiros','Formulário'),(2,'form_public_LGPD_2095_med_tec','Y','Y','Y','Y','Y','Y','Cadastro de medidas técnicas','Formulário'),(2,'form_public_LGPD_2097_config_assoc_med_atv','Y',NULL,NULL,NULL,'Y','Y','Associar medidas técnicas aos ativos','Formulário'),(2,'form_public_LGPD_2100_prz_aprv_proc','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Configurações / SLA de aprovação de Processos de Negócio: Acesso à configuração do prazo limite para aprovação de Processos de Negócio cadastrados','Formulário'),(2,'form_public_LGPD_3000_riscos','Y','Y','Y','Y','Y','Y','Cadastro de riscos','Formulário'),(2,'form_public_LGPD_4000_atividades','Y','Y','Y','Y','Y','Y','Cadastro de atividades','Formulário'),(2,'form_public_LGPD_5000_cod_etica','Y','Y','Y','Y','Y','Y','Cadastro de código de ética','Formulário'),(2,'form_public_LGPD_5100_cod_conduta','Y',NULL,NULL,NULL,'Y','Y',NULL,NULL),(2,'form_public_LGPD_6000_PDCA','','','','','Y','Y','PDCA','Formulário'),(2,'form_public_LGPD_6100_catalog_treinamentos','Y','Y','Y','Y','Y','Y','Cadastro de catalogo de treinamentos','Formulário'),(2,'form_public_LGPD_6200_agenda_treina','Y','Y','Y','Y','Y','Y','Agenda de treinamentos','Formulário'),(2,'form_public_LGPD_7300_envio_aval_forne','Y','Y','Y','Y','Y','Y','Cadastro de questionários (Due Diligence)','Formulário'),(2,'form_public_LGPD_assoc_contr_6500','Y',NULL,NULL,NULL,'Y','Y','Associação de contratos','Formulário'),(2,'form_public_LGPD_assoc_medtec_6700','Y',NULL,NULL,NULL,'Y','Y','Associação de medidas técnicas','Formulário'),(2,'form_public_LGPD_assoc_pdca_risk_6400','Y',NULL,NULL,NULL,'Y','Y','Associação de riscos ao PDCA','Formulário'),(2,'form_public_LGPD_assoc_pol_6300','Y',NULL,NULL,NULL,'Y','Y','Associação de políticas','Formulário'),(2,'form_public_LGPD_assoc_proc_6600','Y',NULL,NULL,NULL,'Y','Y','Associação de processos','Formulário'),(2,'form_public_LGPD_assoc_treina_6500','Y',NULL,NULL,NULL,'Y','Y','Associação de treinamentos','Formulário'),(2,'form_public_LGPD_config_det_opt_7200','Y','Y','Y','Y','Y','Y','Parametrizar opções do questionário de fornecedores','Formulário'),(2,'form_public_PAC_1000_user_portal',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(2,'Governance_menu','Y',NULL,NULL,NULL,'Y','Y','Menu',NULL),(2,'grid_CMP_0100_faixas',NULL,NULL,NULL,NULL,NULL,NULL,'Consultar faixas de setup de auditoria','Painel'),(2,'grid_CMP_1000_mecanismos','',NULL,NULL,NULL,NULL,NULL,'[Item de menu] - Pilares do Compliance / Mecanismos de Auditoria: Acesso ao cadastro de Mecanismos de Auditoria para projetos de Compliance','Pilares de Compliance'),(2,'grid_CMP_1100_componentes','',NULL,NULL,NULL,NULL,NULL,'[Item de menu] - Pilares do Compliance / Componentes de Auditoria: Acesso ao cadastro de Componentes de Auditoria, que compõem os Mecanismos cadastrados','Pilares de Compliance'),(2,'grid_CMP_1100_entrevistados_desassociados',NULL,NULL,NULL,NULL,NULL,NULL,'Consultas candidatos a entrevistas de ciclo de auditoria ','Painel'),(2,'grid_CMP_1200_questoes','',NULL,NULL,NULL,NULL,NULL,'[Item de menu] - Pilares do Compliance / Questões de Auditoria: Acesso ao cadastro de perguntas que são utilizadas para a realização de auditorias de Compliance','Pilares de Compliance'),(2,'grid_CMP_1300_formularios','',NULL,NULL,NULL,NULL,NULL,'[Item de menu] - Pilares do Compliance / Formulários de Auditoria: Acesso ao cadastro e configuração de Formulários compostos por perguntas para a realização de auditorias de Compliance','Pilares de Compliance'),(2,'grid_CMP_1310_formulario_det',NULL,NULL,NULL,NULL,NULL,NULL,'Consulta detalhes do formulário de auditoria ','Painel'),(2,'grid_CMP_1400_formulas_mestre','',NULL,NULL,NULL,NULL,NULL,'[Item de menu] - Pilares do Compliance / Parâmetros de Ciclos de Auditoria: Acesso à configuração de parâmetros quantitativos utilizados nos Ciclos de Auditoria de Compliance','Pilares de Compliance'),(2,'grid_CMP_1410_formulas_det_mec',NULL,NULL,NULL,NULL,NULL,NULL,'Sub Consulta mecanismos do setup de auditoria','Painel'),(2,'grid_CMP_1500_acao','',NULL,NULL,NULL,NULL,NULL,'[Item de menu] - Pilares do Compliance / Ações de Auditoria: Acesso ao cadastro de ações pré-determinadas para serem sugeridas a partir do levantamento de determinada Questão cadastrada','Pilares de Compliance'),(2,'grid_CMP_1550_ger_acao','',NULL,NULL,NULL,NULL,NULL,'[Item de menu] - Auditoria de Compliance / Recomendações de Auditoria: Acesso à geração automática de recomendações pós Ciclo de Auditoria de Compliance','Auditoria de Compliance'),(2,'grid_CMP_1600_OL','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Aspectos Jurídicos / Obrigações Legais: Acesso ao cadastro das obrigações legais que a entidade deve atender em um determinado exercício','Aspectos Jurídicos'),(2,'grid_CMP_2000_ciclos','',NULL,NULL,NULL,NULL,NULL,'[Item de menu] - Auditoria de Compliance / Ciclos de Auditoria: Acesso à gestão de Ciclos de Auditoria de Compliance','Auditoria de Compliance'),(2,'grid_CMP_2500_conf_entrevistados','',NULL,NULL,NULL,NULL,NULL,'[Item de menu] - Auditoria de Compliance / Entrevistados: Acesso à seleção de entrevistados que estarão associados a um Ciclo de Auditoria de Compliance','Auditoria de Compliance'),(2,'grid_CMP_2510_entrevistados_associados',NULL,NULL,NULL,NULL,NULL,NULL,'Relação de entrevistados de um ciclo de auditoria','Painel'),(2,'grid_CMP_3000_aplic_pesq','',NULL,NULL,NULL,NULL,NULL,'[Item de menu] - Auditoria de Compliance / Pesquisas de Auditoria: Acesso à aplicação de Pesquisas de Auditoria de Compliance','Auditoria de Compliance'),(2,'grid_CMP_acompanhar_pesquisas',NULL,NULL,NULL,NULL,NULL,NULL,'Consulta acompanhamento do andamento de pesquisas de auditorias','Painel'),(2,'grid_CMP_resultado_pesquisa','',NULL,NULL,NULL,NULL,NULL,'[Item de menu] - Auditoria de Compliance / Resultados de Auditoria: Acesso à gestão do resultado de Pesquisas de Auditoria de Compliance','Auditoria de Compliance'),(2,'grid_CMP_resultado_pesquisa_questoes',NULL,NULL,NULL,NULL,NULL,NULL,'Consulta resultado da pesquisa de auditoria ','Painel'),(2,'grid_CMP_resultado_pesquisa_status_mecanismo',NULL,NULL,NULL,NULL,NULL,NULL,'Consulta resultado da pesquisa por mecanismos de auditoria ','Painel'),(2,'grid_conf_quest_7100','Y',NULL,NULL,NULL,'Y','Y','Cofiguração de questionário para fornecedores','Painel'),(2,'grid_DOM_tp_ol_1600','',NULL,NULL,NULL,NULL,NULL,'[Item de menu] - Aspectos Jurídicos / Tipos de Obrigações Legais: Acesso ao cadastro de tipos de obrigações legais','Aspectos Jurídicos'),(2,'grid_kanban_atividades','Y',NULL,NULL,NULL,'Y','Y','Kanban de  atividades','Painel'),(2,'grid_kanban_atividades_add_registro','Y',NULL,NULL,NULL,'Y','Y','Kanban de  atividades','Painel'),(2,'grid_LGPD_2001_form_entr_prc','Y',NULL,NULL,NULL,'Y','Y',NULL,'Fluxo de Informação'),(2,'grid_LGPD_2003_envio_entr_prc','Y',NULL,NULL,NULL,'Y','Y',NULL,'Fluxo de Informação'),(2,'grid_LGPD_2040_assoc_prc_atv','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Fluxo de Informação / Associações do Fluxo de Informação: Acesso à consulta das associações entre Processos de Negócio x Ativos de Informação x Artefatos x Metadados Pessoais','Fluxo de Informação'),(2,'grid_LGPD_2075_assoc_funcional_dados_fin',NULL,NULL,NULL,NULL,NULL,NULL,'Consulta associação de metadados','Painel'),(2,'grid_LGPD_2087_ndas','Y',NULL,NULL,NULL,'Y','Y',NULL,'Políticas e Regulamentos'),(2,'grid_LGPD_2097_assoc_med_atv','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Medidas Técnicas de Segurança / Associações com Ativos de Informação: Acesso à configuração da associação entre Medidas Técnicas de Segurança e Ativos de Informação utilizados pela entidade','Medidas Técnicas de Segurança'),(2,'grid_LGPD_3100_assoc_risc_atv','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Riscos / Associações de Riscos: Acesso à associações entre Riscos e outras informações cadastradas','Riscos'),(2,'grid_LGPD_3600_chklst_risk_area_mestre','Y','','','','Y','Y','[Item de menu] - Riscos / Checklist por área de identificação de riscos e atividades','Riscos'),(2,'grid_LGPD_6300_aluno_treina',NULL,NULL,NULL,NULL,NULL,NULL,'Consulta de lista de treinamentos realizados por colaborador','Painel'),(2,'grid_LGPD_7400_resp_aval_forne',NULL,NULL,NULL,NULL,NULL,NULL,'Consulta respostas de questionários  (Due Diligence)','Painel'),(2,'grid_new','Y',NULL,NULL,NULL,'Y','Y',NULL,NULL),(2,'grid_new_pln_acao','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Atividades e Ações / Plano de Ação LGPD: Acesso ao cadastro do documento \"Plano de Ação\" de adequação à LGPD','Atividades e Ações'),(2,'grid_public_LGPD_0100_diagnostico','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Configurações / Projeto de Diagnóstico da LGPD: Acesso à configuração das informações sobre o projeto de Diagnóstico da LGPD','Configurações'),(2,'grid_public_LGPD_0200_implement','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Configurações / Projeto de Adequação da LGPD: Acesso à configuração das informações sobre o projeto de Adequação da LGPD','Configurações'),(2,'grid_public_LGPD_0300_operacao','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Configurações / Projeto de Operação da LGPD: Acesso à configuração das informações sobre a fase de Operação da LGPD','Configurações'),(2,'grid_public_LGPD_0400_etapas','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Configurações / Etapas do Diagnóstico da LGPD: Acesso à configuração das etapas do projeto de Diagnóstico de um projeto de adequação à LGPD','Configurações'),(2,'grid_public_LGPD_1000_controlador','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Configurações / Entidade: Acesso à configuração dos dados da entidade','Configurações'),(2,'grid_public_LGPD_1001_diretoria','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Estrutura Organizacional / Diretoria: Acesso ao cadastro de Diretorias, que é o nível mais alto da hierarquia organizacional da entidade','Estrutura Organizacional'),(2,'grid_public_LGPD_1002_area','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Estrutura Organizacional / Área: Acesso ao cadastro de Áreas, que dividem uma determinada Diretoria na estrutura hierárquica da entidade','Estrutura Organizacional'),(2,'grid_public_LGPD_1003_departamento','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Estrutura Organizacional / Departamentos: Acesso ao cadastro de Departamentos, que dividem uma determinada Área na estrutura hierárquica da entidade','Estrutura Organizacional'),(2,'grid_public_LGPD_1004_cargos','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Estrutura Organizacional / Cargos: Acesso ao cadastro de Cargos a serem ocupados por pessoas da equipe que ocupem espaço na estrutura hierárquica da entidade','Estrutura Organizacional'),(2,'grid_public_LGPD_1050_organograma','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Estrutura Organizacional / Lotação: Acesso ao cadastro de unidades de trabalho, onde é possível alocar as equipes da entidade','Estrutura Organizacional'),(2,'grid_public_LGPD_1051_comite','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Estrutura Organizacional / Comitês: Acesso ao cadastro de comitês da entidade, que congregam uma ou mais pessoas previamente cadastradas','Estrutura Organizacional'),(2,'grid_public_LGPD_1053_eventos_comite','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Atividades e Ações / Eventos de Comitê: Acesso ao cadastro de eventos associados aos Comitês da entidade','Atividades e Ações'),(2,'grid_public_LGPD_1053_sub_eventos_comite','Y',NULL,NULL,NULL,'Y','Y','Sub Consulta de Eventos','Painel'),(2,'grid_public_LGPD_1100_equipe','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Estrutura Organizacional / Equipe: Acesso ao cadastro de pessoas que podem ocupar cargos na estrutura hierárquica da entidade. Essas pessoas serão associadas a diversas outras entidades tratadas na plataforma','Estrutura Organizacional'),(2,'grid_public_LGPD_2000_proc_aprv_prz_expirado','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Atividades e Ações / Processos de Negócio Pendentes: Acesso à gestão de Processos de Negócio com SLA de aprovação expirado','Atividades e Ações'),(2,'grid_public_LGPD_2000_processos','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Fluxo de Informação / Processos de Negócio: Acesso ao cadastro de Processos de Negócio que definem as rotinas operacionais da entidade','Fluxo de Informação'),(2,'grid_public_LGPD_2000_sub_proc_pessoa','Y',NULL,NULL,NULL,'Y','Y','Consulta processo por responsável','Painel'),(2,'grid_public_LGPD_2000_sub_processos_atv','Y',NULL,NULL,NULL,'Y','Y','Consulta processos por ativos','Painel'),(2,'grid_public_LGPD_2010_ativos','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Fluxo de Informação / Ativos de Informação: Acesso ao cadastro de Ativos de Informação utilizados pela entidade na execução de seus Processos de Negócio','Fluxo de Informação'),(2,'grid_public_LGPD_2010_ativos_1','Y',NULL,NULL,NULL,'Y','Y','Consulta Ativos','Painel'),(2,'grid_public_LGPD_2010_ativos_n_utlz_fin','Y',NULL,NULL,NULL,'Y','Y','Processos disponivel para associação com finalidades','Painel'),(2,'grid_public_LGPD_2010_ativos_utlz_fin','Y',NULL,NULL,NULL,'Y','Y','Processos associados a finalidade','Painel'),(2,'grid_public_LGPD_2010_sub_ativos','Y',NULL,NULL,NULL,'Y','Y','Sub Consulta de Ativos','Painel'),(2,'grid_public_LGPD_2020_artefatos','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Fluxo de Informação / Artefatos: Acesso ao cadastro de Artefatos e Documentos tratados nos Ativos de Informação utilizados pela entidade','Fluxo de Informação'),(2,'grid_public_LGPD_2020_artefatos_n_utlz_fin','Y',NULL,NULL,NULL,'Y','Y','Artefatos disponiveis para associação com finalidades','Painel'),(2,'grid_public_LGPD_2020_artefatos_utlz_fin','Y',NULL,NULL,NULL,'Y','Y','Artefatos associados a finalidades','Painel'),(2,'grid_public_LGPD_2030_assoc_art_metadados','Y',NULL,NULL,NULL,'Y','Y','Associação de Artefatos e metadados','Painel'),(2,'grid_public_LGPD_2030_dados','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Fluxo de Informação / Metadados Pessoais: Acesso ao cadastro de Metadados Pessoais presentes nos diferentes Artefatos utilizados pela entidade','Fluxo de Informação'),(2,'grid_public_LGPD_2065_fund_legal','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Aspectos Jurídicos / Fundamentos Legais: Acesso ao cadastro de Fundamentos Legais utilizados pela entidade','Aspectos Jurídicos'),(2,'grid_public_LGPD_2066_ambiente_reg','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Aspectos Jurídicos / Ambientes regulatórios: Acesso ao cadastro de Ambientes Regulatórios a serem associados a Fundamentos Legais utilizados pela entidade','Aspectos Jurídicos'),(2,'grid_public_LGPD_2070_finalidades','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Tratamento de Dados Pessoais / Parametrizar Finalidades de Tratamentos: Acesso à configuração dos aspectos e detalhes das Finalidades de Tratamento de Dados Pessoais previamente cadastradas','Tratamento de Dados Pessoais'),(2,'grid_public_LGPD_2070_registrar_finalidades','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Tratamento de Dados Pessoais / Registrar Finalidade de Tratamento: Acesso ao cadastro de Finalidades de Tratamento de Dados Pessoais executadas pela entidade','Tratamento de Dados Pessoais'),(2,'grid_public_LGPD_2070_sub_contratos_finalidades','Y',NULL,NULL,NULL,'Y','Y','Sub consulta de contratos dentro da finalidade','Painel'),(2,'grid_public_LGPD_2070_sub_finalidades','Y',NULL,NULL,NULL,'Y','Y','Sub consulta de finalidades','Painel'),(2,'grid_public_LGPD_2073_assoc_ativos_fin','Y',NULL,NULL,NULL,'Y','Y','Associação de ativos na finalidade','Painel'),(2,'grid_public_LGPD_2075_assoc_metadados_fin','Y',NULL,NULL,NULL,'Y','Y','Associação de metadados na finalidade','Painel'),(2,'grid_public_LGPD_2080_politicas','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Políticas e Regulamentos / Políticas: Acesso ao cadastro de políticas associadas à Governança de Privacidade da entidade','Políticas e Regulamentos'),(2,'grid_public_LGPD_2085_contratos','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Políticas e Regulamentos / Contratos: Acesso ao cadastro de contratos e modelos de contratos utilizados pela entidade','Políticas e Regulamentos'),(2,'grid_public_LGPD_2090_terceiros','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Gestão de terceiros / Terceiros: Acesso ao cadastro de entidades terceiras (PJ ou PF) associadas à entidade','Gestão de Terceiros'),(2,'grid_public_LGPD_2093_ocorr_terc','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Gestão de terceiros / Ocorrências: Acesso ao cadastro de ocorrências relacionadas à Terceiros associados à entidade','Gestão de Terceiros'),(2,'grid_public_LGPD_2095_med_tec','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Medidas Técnicas de Segurança / Medidas Técnicas de Segurança: Acesso ao cadastro de Medidas Técnicas de Segurança da Informação que podem ser associadas a Ativos cadastrados','Medidas Técnicas de Segurança'),(2,'grid_public_LGPD_2095_sub_med_tec','Y',NULL,NULL,NULL,'Y','Y','Sub Consulta de medidas técnicas','Painel'),(2,'grid_public_LGPD_3000_riscos','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Riscos / Riscos: Acesso ao cadastro de Riscos de Privacidade e Compliance','Riscos'),(2,'grid_public_LGPD_3000_sub_consulta_riscos','Y',NULL,NULL,NULL,'Y','Y','Sub consulta de riscos','Painel'),(2,'grid_public_LGPD_3300_assoc_risc_prc','Y',NULL,NULL,NULL,'Y','Y','Associar risco a processos','Painel'),(2,'grid_public_LGPD_4000_atividades','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Atividades e Ações / Atividades e Ações: Acesso ao cadastro de atividades e ações de governança e compliance','Atividades e Ações'),(2,'grid_public_LGPD_5000_cod_etica','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Políticas e Regulamentos / Códigos e Regulamentos Internos: Acesso ao cadastro de documentos que definem as regras internas de Compliance da entidade','Políticas e Regulamentos'),(2,'grid_public_LGPD_5100_cod_conduta','Y',NULL,NULL,NULL,'Y','Y',NULL,NULL),(2,'grid_public_LGPD_6000_PDCA','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Atividades e Ações / Gestão de ciclo de PDCA de Compliance: Acesso ao planejamento e gestão de ciclos de PDCA de Compliance','Atividades e Ações'),(2,'grid_public_LGPD_6000_SUB_PDCA','Y',NULL,NULL,NULL,'Y','Y','Sub consulta PDCA','Painel'),(2,'grid_public_LGPD_6100_catalog_treinamentos','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Atividades e Ações / Catálogo de treinamentos: Acesso ao cadastro dos tipos de treinamentos que a entidade pode executar para suas equipes','Atividades e Ações'),(2,'grid_public_LGPD_6200_agenda_treina','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Atividades e Ações / Agenda de Treinamentos: Acesso à gestão de agenda de treinamentos e capacitações internas da entidade','Atividades e Ações'),(2,'grid_public_LGPD_7300_envio_aval_forne','Y',NULL,NULL,NULL,'Y','Y','Consulta de questionários (Due Diligence)','Painel'),(2,'grid_public_LGPD_7300_envio_aval_forne_gerencial','Y',NULL,NULL,NULL,'Y','Y',NULL,'Gestão de Terceiros'),(2,'grid_public_LGPD_cons_rev_contr_6500','Y',NULL,NULL,NULL,'Y','Y','Consulta revisões de contrato','Painel'),(2,'grid_public_LGPD_cons_rev_medtec_6700','Y',NULL,NULL,NULL,'Y','Y','Consulta revisões de medidas técnicas','Painel'),(2,'grid_public_LGPD_cons_rev_pol_6300','Y',NULL,NULL,NULL,'Y','Y','Consulta revisão de políticas','Painel'),(2,'grid_public_LGPD_cons_rev_proc_6600','Y',NULL,NULL,NULL,'Y','Y','Consulta revisão de processos','Painel'),(2,'grid_public_LGPD_cons_rev_risk_6400','Y',NULL,NULL,NULL,'Y','Y','Consulta revisão de riscos','Painel'),(2,'grid_public_PAC_9000_DPIA',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(2,'grid_public_PAC_9100_LIA',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(2,'grid_public_PCP_9000_DPIA',NULL,NULL,NULL,NULL,NULL,NULL,'Consulta DPIA',NULL),(2,'grid_public_pcp_9100_LIA',NULL,NULL,NULL,NULL,NULL,NULL,'Consulta LIA ',NULL),(2,'grid_public_subconsulta_sec_users','Y',NULL,NULL,NULL,'Y','Y','Sub consulta de usuarios','Painel'),(2,'grid_sc_log','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Segurança / Histórico de acessos: Acesso à consulta à histórico de acessos de usuários à plataforma','Segurança'),(2,'help_cadastro_titulares',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(2,'help_ciclo_de_vida','Y',NULL,NULL,NULL,'Y','Y','Help Ciclo de vida','Painel'),(2,'help_finalidades_fundamentos','Y',NULL,NULL,NULL,'Y','Y','Help Finalidades','Painel'),(2,'help_geracao_atividades','Y',NULL,NULL,NULL,'Y','Y',NULL,NULL),(2,'help_geracao_riscos','Y',NULL,NULL,NULL,'Y','Y',NULL,NULL),(2,'help_gestao_consentimentos',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(2,'help_gestao_incidentes',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(2,'help_gestao_notificacao',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(2,'help_integracao_portais',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(2,'help_lotes_validacao','Y',NULL,NULL,NULL,'Y','Y',NULL,NULL),(2,'help_medidas_administrativas','Y',NULL,NULL,NULL,'Y','Y','Help medidas administrativas','Painel'),(2,'help_medidas_tecnicas','Y',NULL,NULL,NULL,'Y','Y','Help para medidas técnicas','Painel'),(2,'help_plano_acao_atividades','Y',NULL,NULL,NULL,'Y','Y','Help Atividades','Painel'),(2,'help_relatorios',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(2,'help_riscos_e_impactos','Y',NULL,NULL,NULL,'Y','Y','Help Riscos','Painel'),(2,'homepage','Y',NULL,NULL,NULL,'Y','Y','Home Page (Responsábilidades e Atividades)','Painel'),(2,'homepage_help','Y',NULL,NULL,NULL,'Y','Y','Help','Painel'),(2,'mapa_calor_risco',NULL,NULL,NULL,NULL,NULL,NULL,'Mapa de risco','Painel'),(2,'Mapa_Calor_Riscos',NULL,NULL,NULL,NULL,NULL,NULL,'Mapa de calor de riscos ','Painel'),(2,'menu','Y',NULL,NULL,NULL,'Y','Y','Menu PCP','Painel'),(2,'menu_dinamico',NULL,NULL,NULL,NULL,NULL,NULL,'Menu','Painel'),(2,'Menu_Pac','Y',NULL,NULL,NULL,'Y','Y',NULL,NULL),(2,'Metadados','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Painel / Metadados Pessoais: Acesso à exibição dos principais indicadores sobre Metadados Pessoais','Painel'),(2,'novo_menu','Y',NULL,NULL,NULL,'Y','Y',NULL,NULL),(2,'pac_app_change_pswd','Y','','','','Y','Y','[Item de menu] - SeguranÃ§a / AlteraÃ§Ã£o de senha: Acesso Ã  gestÃ£o de senhas de usuÃ¡rios da plataforma','SeguranÃ§a'),(2,'pac_app_form_sec_groups_apps','','','','','','','[Item de menu] - SeguranÃ§a / AssociaÃ§Ã£o de perfis a aplicaÃ§Ãµes: Acesso Ã  configuraÃ§Ã£o da associaÃ§Ã£o de perfis de acesso com as aplicaÃ§Ãµes da plataforma','SeguranÃ§a'),(2,'pac_app_grid_sec_apps','','','','','','','[Item de menu] - SeguranÃ§a / AplicaÃ§Ãµes: Acesso ao cadastro de aplicaÃ§Ãµes da plataforma','SeguranÃ§a'),(2,'pac_app_grid_sec_groups','','','','','','','[Item de menu] - SeguranÃ§a / Perfis: Acesso ao cadastro de perfis de acesso dos usuÃ¡rios da plataforma','SeguranÃ§a'),(2,'pac_app_grid_sec_users','Y','','','','Y','Y','[Item de menu] - SeguranÃ§a / UsuÃ¡rios: Acesso ao cadastro de usuÃ¡rios da plataforma','SeguranÃ§a'),(2,'pac_app_grid_sec_users_groups','Y','','','','Y','Y','[Item de menu] - SeguranÃ§a / AssociaÃ§Ã£o de usuÃ¡rios a perfis: Acesso Ã  configuraÃ§Ã£o da associaÃ§Ã£o de usuÃ¡rios a perfis de acesso','SeguranÃ§a'),(2,'pac_app_search_sec_groups','','','','','','','[Item de menu] - SeguranÃ§a / AssociaÃ§Ã£o de perfis a aplicaÃ§Ãµes: Acesso Ã  configuraÃ§Ã£o da associaÃ§Ã£o de perfis de acesso com as aplicaÃ§Ãµes da plataforma','SeguranÃ§a'),(2,'pac_menu',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(2,'PAG_menu','Y',NULL,NULL,NULL,'Y','Y',NULL,NULL),(2,'param_aval_mestre_7000','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Gestão de terceiros / Formulários de due diligence: Acesso à criação de formulários (e suas questões) para auto avaliação de terceiros','Gestão de Terceiros'),(2,'PCP_Privacy_Compliance_Project_20231030144841000000.tar',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(2,'PDCA','',NULL,NULL,NULL,NULL,NULL,'[Item de menu] - Painel / Ciclos de PDCA: Acesso à exibição dos principais indicadores sobre Ciclos de PDCA de Compliance','Painel'),(2,'pdfreport_LGPD_7300_envio_aval_forne',NULL,NULL,NULL,NULL,NULL,NULL,'geração de PDF - questionário (Due Diligence)','Painel'),(2,'popup_confirm_action',NULL,NULL,NULL,NULL,NULL,NULL,'Pop-up ( não se aplica ao módulo de segirança)','Painel'),(2,'popup_confirm_action_status',NULL,NULL,NULL,NULL,NULL,NULL,'Pop_Up ( Não se plaica ao módulo de segurança ) ','Painel'),(2,'Processos','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Painel / Processos de Negócio: Acesso à exibição dos principais indicadores sobre Processos de Negócio','Painel'),(2,'relatorio_ciclos_complience',NULL,NULL,NULL,NULL,NULL,NULL,'Extrato de cilco de auditoria ','Painel'),(2,'relatorio_dpia',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(2,'relatorio_dpia_1',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(2,'relatorio_finalidades','Y',NULL,NULL,NULL,'Y','Y','Relatório de finalidades','Painel'),(2,'relatorio_lia',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(2,'relatorio_notificacao',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(2,'relatorio_resp_aval',NULL,NULL,NULL,NULL,NULL,NULL,'Relatório Avaliações','Painel'),(2,'resumo_finalidade','Y',NULL,NULL,NULL,'Y','Y','Resumo de finalidade','Painel'),(2,'Riscos','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Painel / Riscos: Acesso à exibição dos principais indicadores sobre Gestão de Riscos de Privacidade e Compliance','Painel'),(2,'risk_heat_map','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Riscos / Mapa de Calor: Acesso à exibição do Mapa de Calor dos Riscos cadastrados','Riscos'),(2,'search_public_LGPD_4000_atividades','Y',NULL,NULL,NULL,'Y','Y','Filtro de atividades','Painel'),(2,'sec_change_pswd','Y',NULL,NULL,NULL,'Y','Y',NULL,NULL),(2,'sec_form_add_users','Y',NULL,NULL,NULL,'Y','Y',NULL,NULL),(2,'sec_form_edit_users','Y',NULL,NULL,NULL,'Y','Y',NULL,NULL),(2,'sec_form_sec_apps','Y',NULL,NULL,NULL,'Y','Y',NULL,NULL),(2,'sec_form_sec_groups','Y',NULL,NULL,NULL,'Y','Y',NULL,NULL),(2,'sec_form_sec_groups_apps','Y',NULL,NULL,NULL,'Y','Y',NULL,NULL),(2,'sec_grid_sec_apps','Y',NULL,NULL,NULL,'Y','Y',NULL,NULL),(2,'sec_grid_sec_groups','Y',NULL,NULL,NULL,'Y','Y',NULL,NULL),(2,'sec_grid_sec_users','Y',NULL,NULL,NULL,'Y','Y',NULL,NULL),(2,'sec_grid_sec_users_groups','Y',NULL,NULL,NULL,'Y','Y',NULL,NULL),(2,'sec_Login','Y',NULL,NULL,NULL,'Y','Y',NULL,NULL),(2,'sec_menu','Y',NULL,NULL,NULL,'Y','Y',NULL,NULL),(2,'sec_retrieve_pswd','Y',NULL,NULL,NULL,'Y','Y',NULL,NULL),(2,'sec_search_sec_groups','Y',NULL,NULL,NULL,'Y','Y',NULL,NULL),(2,'sec_settings','Y',NULL,NULL,NULL,'Y','Y',NULL,NULL),(2,'sec_sync_apps','Y',NULL,NULL,NULL,'Y','Y',NULL,NULL),(2,'sub_consulta_3000_riscos_incidente',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(2,'sub_consulta_3100_assoc_risc_atv',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(2,'sub_consulta_3300_assoc_risc_prc',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(2,'sub_consulta_3400_assoc_risc_fin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(2,'sub_consulta_CMP_1610_ol_agenda',NULL,NULL,NULL,NULL,NULL,NULL,'Sub consulta de agenda de obrigações legais por obrigação','Painel'),(2,'sub_consulta_CMP_2510_det_conf_entrevistados',NULL,NULL,NULL,NULL,NULL,NULL,'Entrevitados em presquisa de auditoria --> Sub Consulta de configuração de entrevidados de pesquisa de auditoria ','Painel'),(2,'sub_consulta_CMP_3000_aplic',NULL,NULL,NULL,NULL,NULL,NULL,'Sub consulta status da aplicação de pesquisa de auditoria','Painel'),(2,'sub_consulta_CMP_4000_respostas_mestre',NULL,NULL,NULL,NULL,NULL,NULL,'Sub consulta status de respostas dos formulários de auditoria dentro de um ciclo ','Painel'),(2,'sub_consulta_configurar_metadados','Y',NULL,NULL,NULL,'Y','Y','Sub consulta configuração de metadados','Painel'),(2,'sub_consulta_LGPD_2097_assoc_med_atv',NULL,NULL,NULL,NULL,NULL,NULL,'Sub consulta de associação entre medidas técnicas e ativos','Painel'),(2,'sub_consulta_LGPD_6200_agenda_treina',NULL,NULL,NULL,NULL,NULL,NULL,'Sub consulta de agenda de treinamentos ','Painel'),(2,'sub_consulta_PAC_1100_sol_portal',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(2,'sub_consulta_PAC_3200_tit_consent',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(2,'sub_consulta_PAC_4000_notificacao',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(2,'sub_consulta_PAG_ocorr_lote_1100','Y',NULL,NULL,NULL,'Y','Y',NULL,NULL),(2,'sub_form_configurar_metados','Y',NULL,NULL,NULL,'Y','Y','Configurar metadados','Painel'),(2,'sub_grid_CMP_1550_ger_acao',NULL,NULL,NULL,NULL,NULL,NULL,'Sub grid de recomendaçoes de auditoria por ciclo','Painel'),(2,'sub_grid_LGPD_2050_assoc_atv_art',NULL,NULL,NULL,NULL,NULL,NULL,'Sub consulta de associação entre ativos e artefatos',NULL),(2,'sub_grid_PAC_1400_tit_afet_inc',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(2,'sub_grid_public_LGPD_2093_ocorr_terc','Y',NULL,NULL,NULL,'Y','Y','Sub consulta ocorrência de terceiros','Painel'),(2,'Teste',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(3,'app_change_pswd','',NULL,NULL,NULL,NULL,NULL,'[Item de menu] - Segurança / Alteração de senha: Acesso à gestão de senhas de usuários da plataforma','Segurança'),(3,'app_form_add_users','','','','',NULL,NULL,'Cadastrar usuários','Formulário'),(3,'app_form_edit_users','','','','',NULL,NULL,'Alterar usuários','Formulário'),(3,'app_form_sec_apps','','','','',NULL,NULL,'Cadastrar aplicações','Formulário'),(3,'app_form_sec_groups','','','','',NULL,NULL,'Cadastro de grupos de usuários','Formulário'),(3,'app_form_sec_groups_apps','','','','',NULL,NULL,'Associar grupos x aplicações','Painel'),(3,'app_grid_sec_apps','',NULL,NULL,NULL,NULL,NULL,'[Item de menu] - Segurança / Aplicações: Acesso ao cadastro de aplicações da plataforma','Segurança'),(3,'app_grid_sec_groups','',NULL,NULL,NULL,NULL,NULL,'[Item de menu] - Segurança / Perfis: Acesso ao cadastro de perfis de acesso dos usuários da plataforma','Segurança'),(3,'app_grid_sec_users','',NULL,NULL,NULL,NULL,NULL,'[Item de menu] - Segurança / Usuários: Acesso ao cadastro de usuários da plataforma','Segurança'),(3,'app_grid_sec_users_groups','',NULL,NULL,NULL,NULL,NULL,'[Item de menu] - Segurança / Associação de usuários a perfis: Acesso à configuração da associação de usuários a perfis de acesso','Segurança'),(3,'app_Login',NULL,NULL,NULL,NULL,NULL,NULL,'Login',NULL),(3,'app_menu',NULL,NULL,NULL,NULL,NULL,NULL,'Menu','Painel'),(3,'app_retrieve_pswd',NULL,NULL,NULL,NULL,NULL,NULL,'Esqueceu a senha','Painel'),(3,'app_search_sec_groups','',NULL,NULL,NULL,NULL,NULL,'[Item de menu] - Segurança / Associação de perfis a aplicações: Acesso à configuração da associação de perfis de acesso com as aplicações da plataforma','Segurança'),(3,'app_settings','',NULL,NULL,NULL,NULL,NULL,'Configurações de segurança','Segurança'),(3,'app_sync_apps','',NULL,NULL,NULL,NULL,NULL,'Sincronização de aplicações','Segurança'),(3,'Artefatos','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Painel / Artefatos: Acesso à exibição dos principais indicadores sobre Artefatos e Documentos','Painel'),(3,'associar_metadados_finalidade',NULL,NULL,NULL,NULL,NULL,NULL,'Associar metadados na finalidade','Painel'),(3,'associar_metadados_finalidade_new',NULL,NULL,NULL,NULL,NULL,NULL,'Associar metadados a finalidades','Painel'),(3,'Atividades','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Painel / Atividades e Ações: Acesso à exibição dos principais indicadores sobre Atividades e Ações','Painel'),(3,'Ativos','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Painel / Ativos de Informação: Acesso à exibição dos principais indicadores sobre Ativos de Informação','Painel'),(3,'Auto_cadastro_PAC_4000_notificacao',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(3,'blank_email',NULL,NULL,NULL,NULL,NULL,NULL,'Enviar mail','Painel'),(3,'blank_pipeline','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Atividades e Ações / Meu Quadro de Atividades: Acesso ao Kanban de atividades do usuário logado','Atividades e Ações'),(3,'blank_pipeline_Ajax',NULL,NULL,NULL,NULL,NULL,NULL,'Pipeline de atividades','Painel'),(3,'cad_sol_dpia_pcp_9000','Y','','','','Y','Y',NULL,'Fluxo de Informação'),(3,'Cadastro_DEN_1000_registro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(3,'Cadastro_DEN_1100_cat',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(3,'cadastro_PAC_1110_atv_sol',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(3,'cadastro_PAC_1200_sla_sol_portal',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(3,'Cadastro_PAC_1400_titulares',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(3,'Cadastro_PAC_1410_dados_tit',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(3,'Cadastro_PAC_2000_incidentes',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(3,'Cadastro_PAC_2100_sla_notificacao',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(3,'Cadastro_PAC_3100_env_consent',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(3,'Cadastro_PAC_4000_notificacao',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(3,'Cadastro_PAG_lote_1000',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(3,'cadastro_PAG_ocorr_lote_1100',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(3,'calendar_app',NULL,NULL,NULL,NULL,NULL,NULL,'Calendário','Painel'),(3,'calendar_public_LGPD_4000_atividades',NULL,NULL,NULL,NULL,NULL,NULL,'Calendário de atividades ( DPO )','Painel'),(3,'chart_public_LGPD_2000_processos_complex',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico processo por complexidade','Painel'),(3,'chart_public_LGPD_2000_processos_geral',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico processos','Painel'),(3,'chart_public_LGPD_2000_processos_resp',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico processos por responsável','Painel'),(3,'chart_public_LGPD_2000_status_processos',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico processo por status','Painel'),(3,'chart_public_LGPD_2000_tipo_processo',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico processos por tipo','Painel'),(3,'chart_public_LGPD_2010_confia_ativos',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico confibilidade dos ativos','Painel'),(3,'chart_public_LGPD_2010_disp_ativos',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico ativos por nível de disponibilidade','Painel'),(3,'chart_public_LGPD_2010_integridade_ativos',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico ativos por nível de integridade','Painel'),(3,'chart_public_LGPD_2010_resp_ativos',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico ativos por responsável','Painel'),(3,'chart_public_LGPD_2010_tipo_ativos',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico tipos de ativos','Painel'),(3,'chart_public_LGPD_2020_artefat_contrato',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico artefatos tipo contrato','Painel'),(3,'chart_public_LGPD_2020_contrato_artefatos',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico contratos x artefatos','Painel'),(3,'chart_public_LGPD_2020_tipo_artefatos',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico artefatos por tipo','Painel'),(3,'chart_public_LGPD_2030_classif_dados',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico classificação de metadados','Painel'),(3,'chart_public_LGPD_2030_dados_anonimizavel',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico metadados anonimizavel','Painel'),(3,'chart_public_LGPD_2030_tipif_dados',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico tipos de dados','Painel'),(3,'chart_public_LGPD_2070_fin_compart_dados',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico finalidades por compartilhamento','Painel'),(3,'chart_public_LGPD_2070_fin_dad_criancas',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico finalidades por dados de crianças','Painel'),(3,'chart_public_LGPD_2070_fin_faz_descarte',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico finalidades por descarte','Painel'),(3,'chart_public_LGPD_2070_fin_frequencia',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico finalidades por ferequencia','Painel'),(3,'chart_public_LGPD_2070_fin_hipoteses',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico finalidades por hipóteses de tratamento','Painel'),(3,'chart_public_LGPD_2070_fin_papel',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico papel da entidade','Painel'),(3,'chart_public_LGPD_2070_fin_processos',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico finalidades por processos','Painel'),(3,'chart_public_LGPD_2070_fin_rot_automatizada',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico finalidades por rotinas automatizadas','Painel'),(3,'chart_public_LGPD_2070_fin_utlz_operador',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico finalidades por utiliza operador','Painel'),(3,'chart_public_LGPD_2070_fin_volumetria',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico finliadades por volumetria','Painel'),(3,'chart_public_LGPD_3000_categoria_riscos',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico riscos por categoria','Painel'),(3,'chart_public_LGPD_3000_criticidade_riscos',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico riscos por criticidade','Painel'),(3,'chart_public_LGPD_3000_estrategia_riscos',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico riscos por estratégia','Painel'),(3,'chart_public_LGPD_3000_impacto_riscos',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico riscos por impacto','Painel'),(3,'chart_public_LGPD_3000_prob_riscos',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico riscos por probabilidade','Painel'),(3,'chart_public_LGPD_3000_resp_riscos',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico riscos por responsáveis','Painel'),(3,'chart_public_LGPD_3000_status_riscos',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico riscos por status','Painel'),(3,'chart_public_LGPD_4000_atividades_geral',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico atividades','Painel'),(3,'chart_public_LGPD_4000_disc_atividades',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico atividades por disciplina','Painel'),(3,'chart_public_LGPD_4000_etapa_atividades',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico atividades por etapas','Painel'),(3,'chart_public_LGPD_4000_resp_atividades',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico atividades por responsável','Painel'),(3,'chart_public_LGPD_4000_status_resp_atividade',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico atividades por responsável e status','Painel'),(3,'chart_public_LGPD_assoc_pdca_contr_6500',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico PDCA de contratos','Painel'),(3,'chart_public_LGPD_assoc_pdca_finalizados_treina_6500',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico PDCA de treinamentos','Painel'),(3,'chart_public_LGPD_assoc_pdca_medtec_6700',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico PDCA de medidas técnicas','Painel'),(3,'chart_public_LGPD_assoc_pdca_pol_6300',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico PDCA de políticas','Painel'),(3,'chart_public_LGPD_assoc_pdca_proc_6600',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico PDCA de processos','Painel'),(3,'chart_public_LGPD_assoc_pdca_realizar_treina_6500',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico PDCA realização de treinamentos','Painel'),(3,'chart_public_LGPD_assoc_pdca_risk_6400',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico PDCA de riscos','Painel'),(3,'cons_dad_nao_utlz_LGPD_2030_dados','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Fluxo de Informação / Metadados Pessoais não utilizados: Acesso à consulta dos Metadados Pessoais cadastrados mas não utilizados em nenhuma associação','Fluxo de Informação'),(3,'cons_minhas_obr_CMP_1610_ol_agenda','',NULL,NULL,NULL,NULL,NULL,'[Item de menu] - Aspectos Jurídicos / Minhas Obrigações Legais: Acesso ao cadastro das obrigações legais da entidade que estão sob a responsabilidade do usuário logado','Aspectos Jurídicos'),(3,'Consulta_DEN_1000_registro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(3,'Consulta_DEN_1100_cat',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(3,'consulta_gerencial_CMP_1610_ol_agenda','',NULL,NULL,NULL,NULL,NULL,'[Item de menu] - Aspectos Jurídicos / Acompanhamento de Obrigações Legais: Acesso ao painel de acompanhamento do status das obrigações legais da entidade','Aspectos Jurídicos'),(3,'consulta_gerencial_LGPD_4000_atividades','',NULL,NULL,NULL,NULL,NULL,'[Item de menu] - Atividades e Ações / Acompanhamento de Atividades e Ações: Acesso ao painel de acompanhamento do status das obrigações legais da entidade','Atividades e Ações'),(3,'Consulta_LGPD_3000_riscos_assistant',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(3,'Consulta_LGPD_4000_atividades_assistant',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(3,'Consulta_PAC_1000_user_portal',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(3,'Consulta_PAC_1100_sol_portal',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(3,'consulta_PAC_1200_sla_sol_portal',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(3,'Consulta_PAC_1400_titulares',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(3,'Consulta_PAC_1410_dados_tit',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(3,'Consulta_PAC_2000_incidentes',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(3,'Consulta_PAC_3100_env_consent',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(3,'Consulta_PAC_4000_notificacao',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(3,'Consulta_PAG_lote_1000',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(3,'Consulta_public_LGPD_3000_riscos',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(3,'control_calendar',NULL,NULL,NULL,NULL,NULL,NULL,'Meu calendário de atividades de adequação',NULL),(3,'control_login',NULL,NULL,NULL,NULL,NULL,NULL,'Login','Painel'),(3,'control_login_diligence',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(3,'esqueci_senha',NULL,NULL,NULL,NULL,NULL,NULL,'Esqueceu a senha','Painel'),(3,'extrato_pdca',NULL,NULL,NULL,NULL,NULL,NULL,'Extrato PDCA','Painel'),(3,'Finalidades','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Painel / Finalidades de Tratamento de Dados Pessoais: Acesso à exibição dos principais indicadores sobre Finalidades de Tratamento de Dados Pessoais','Painel'),(3,'form_aval_7000','Y',NULL,NULL,NULL,'Y','Y','Formulários de due diligence: Acesso à criação de formulários (e suas questões) para auto avaliação de terceiros','Gestão de Terceiros'),(3,'form_CMP_1000_mecanismos','','','','',NULL,NULL,'Cadastro de mecanismos de auditoria ','Formulário'),(3,'form_CMP_1100_componentes','','','','',NULL,NULL,'Cadastro de componentes de auditoria','Formulário'),(3,'form_CMP_1200_questoes','','','','',NULL,NULL,'Cadastro de questões de auditoria','Formulário'),(3,'form_CMP_1300_formularios','','','','',NULL,NULL,'Cadatro de formulários de auditoria ','Formulário'),(3,'form_CMP_1300_formularios_edit','','','','',NULL,NULL,'Edição de formulários de auditoria','Formulário'),(3,'form_CMP_1400_formulas_mestre','','','','',NULL,NULL,'Parametrização de Setup de Auditoria','Formulário'),(3,'form_CMP_1400_formulas_view','','','','',NULL,NULL,'Visualizar setup de auditoria','Formulário'),(3,'form_CMP_1410_formulas_det_mec','','','','',NULL,NULL,'Parametrizar mecanismos de auditoria no setup','Formulário'),(3,'form_CMP_1420_formulas_det_niv_ad','','','','',NULL,NULL,'Parametrizar níveis de aderência do setup de auditoria ','Formulário'),(3,'form_CMP_1430_formulas_det_lim','','','','',NULL,NULL,'Parametrizar faixas do setup de auditoria','Formulário'),(3,'form_CMP_1500_acao','','','','',NULL,NULL,'Recomendações de auditorias','Formulário'),(3,'form_CMP_1600_OL','','','','','Y','Y','Cadastro de Obrigações Legais ','Formulário'),(3,'form_CMP_2000_ciclos','','','','',NULL,NULL,'Cadastro de ciclos de auditoria','Formulário'),(3,'form_CMP_2500_conf_entrevistados','','','','',NULL,NULL,'Cadastro de entrevistados do ciclo de auditoria ','Formulário'),(3,'form_CMP_2500_conf_entrevistados_1','','','','',NULL,NULL,'Cadastro de entrevistados ','Formulário'),(3,'form_CMP_2500_conf_param_entrevistados','','','','',NULL,NULL,'Parametrizar relação de entrevistados de um ciclo de auditoria','Formulário'),(3,'form_CMP_3000_aplic_pesq','','','','',NULL,NULL,'Cadastro de aplicação de pesquisa de auditorias ','Formulário'),(3,'form_CMP_resultados_pesquisas','','','','',NULL,NULL,'Cadastro de resultado de pesquisas de auditoria','Formulário'),(3,'form_conf_quest_7100','Y','Y','Y','Y',NULL,NULL,'Configurar questionário de fornecedores','Formulário'),(3,'form_diligence',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(3,'form_DOM_tp_ol_1600','','','','',NULL,NULL,'Cadastro de tipos de obrigações ','Formulário'),(3,'form_kanban_atividades','Y','Y','Y','Y',NULL,NULL,'Kanban de  atividades','Formulário'),(3,'form_kanban_atividades_add_registro','Y','Y','Y','Y',NULL,NULL,'Cadastrar atividades pelo kanban','Formulário'),(3,'form_LGPD_0002_conf_smpt','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Configurações / Configuração de envio de e-mails: Acesso à configuração do endereço de de SMTP para envio de e-mails da plataforma','Formulário'),(3,'form_LGPD_2001_form_entr_prc','Y','','','','Y','Y',NULL,'Fluxo de Informação'),(3,'form_LGPD_2003_envio_entr_prc','Y','','','','Y','Y',NULL,'Fluxo de Informação'),(3,'form_LGPD_2087_ndas','Y','','','','Y','Y',NULL,'Fluxo de Informação'),(3,'form_LGPD_2097_assoc_med_atv',NULL,NULL,NULL,NULL,NULL,NULL,'Cadastro de Medidas Técnicas - > Cadastro da especificação da associação entre medida técnica e ativo','Painel'),(3,'form_LGPD_3500_checklist_risk_padrao','Y','','','','Y','Y','[Item de menu] - Riscos / Checklist padrão de identificação de riscos e atividades','Riscos'),(3,'form_LGPD_3600_chklst_risk_area_mestre','Y','','','','Y','Y','Formulário de checklist por área de identificação de riscos e atividades','Riscos'),(3,'form_LGPD_4000_atividades','Y','Y','Y','Y',NULL,NULL,'Cadastro de atividades de adequação','Formulário'),(3,'form_LGPD_4000_atividades_calendar',NULL,NULL,NULL,NULL,NULL,NULL,'Cadastro de atividades de adequação','Formulário'),(3,'form_minhas_obr_CMP_1610_ol_agenda',NULL,NULL,NULL,NULL,NULL,NULL,'Edição das minhas obrigações legais ','Painel'),(3,'form_new_pln_acao','Y','Y','','Y',NULL,NULL,'Cadastrar plano de ação','Formulário'),(3,'form_PAC_1100_sol_portal',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(3,'form_pcp_9100_LIA','Y','','','','Y','Y',NULL,'Fluxo de Informação'),(3,'form_public_LGPD_0100_diagnostico','Y','','','',NULL,NULL,'Parametrizar etapa de diagnóstico','Formulário'),(3,'form_public_LGPD_0200_implement','Y','','','',NULL,NULL,'Parametrizar etapa de implementação','Formulário'),(3,'form_public_LGPD_0300_operacao','Y','','','',NULL,NULL,'Parametrizar etapa de operação','Formulário'),(3,'form_public_LGPD_0400_etapas','Y','','','',NULL,NULL,'Parametrizar etapas','Formulário'),(3,'form_public_LGPD_1000_controlador','Y','Y','Y','Y',NULL,NULL,'Cadastro de controlador','Formulário'),(3,'form_public_LGPD_1001_diretoria','Y','Y','Y','Y',NULL,NULL,'Cadastro de diretoria','Formulário'),(3,'form_public_LGPD_1002_area','Y','Y','Y','Y',NULL,NULL,'Cadastro de área','Formulário'),(3,'form_public_LGPD_1003_departamento','Y','Y','Y','Y',NULL,NULL,'Cadastro de departamentos','Formulário'),(3,'form_public_LGPD_1004_cargos','Y','Y','Y','Y',NULL,NULL,'Cadastro de cargos','Formulário'),(3,'form_public_LGPD_1050_organograma','Y','Y','Y','Y',NULL,NULL,'Cadastro de organograma','Formulário'),(3,'form_public_LGPD_1051_comite','Y','Y','Y','Y',NULL,NULL,'Cadastro de comitê','Formulário'),(3,'form_public_LGPD_1053_eventos_comite','','','','',NULL,NULL,'Agenda de eventos do comitê','Formulário'),(3,'form_public_LGPD_1100_equipe','Y','Y','Y','Y',NULL,NULL,'Cadastro de equipe','Formulário'),(3,'form_public_LGPD_1100_equipe_1','Y','Y','Y','Y',NULL,NULL,'Cadastro de equipe','Formulário'),(3,'form_public_LGPD_2000_processos','Y','Y','Y','Y','Y','Y','Cadastro de processos','Formulário'),(3,'form_public_LGPD_2010_ativos','Y','Y','Y','Y','Y','Y','Cadastro de ativos','Formulário'),(3,'form_public_LGPD_2020_artefatos','Y','Y','Y','Y','Y','Y','Cadastro de artefatos','Formulário'),(3,'form_public_LGPD_2030_dados','Y','Y','Y','Y','Y','Y','Cadastro de metadados','Formulário'),(3,'form_public_LGPD_2060_config_assoc','Y','Y','Y','Y','Y','Y','Associação artefato x metadados','Formulário'),(3,'form_public_LGPD_2065_fund_legal','Y','Y','Y','Y',NULL,NULL,'Cadastro de fundamentos legais','Formulário'),(3,'form_public_LGPD_2066_ambiente_reg','Y','Y','Y','Y',NULL,NULL,'Cadastro de ambientes regulatórios','Formulário'),(3,'form_public_LGPD_2070_finalidades','Y','Y','Y','Y','Y','Y','Parametrizar finalidades','Formulário'),(3,'form_public_LGPD_2070_registrar_finalidades','Y','Y','Y','Y','Y','Y','Registrar finalidades','Formulário'),(3,'form_public_LGPD_2075_param_assoc_funcional_fin','Y','Y','Y','Y','Y','Y','Associação funcional da finalidade','Formulário'),(3,'form_public_LGPD_2080_politicas','Y','Y','Y','Y',NULL,NULL,'Cadastro de políticas','Formulário'),(3,'form_public_LGPD_2085_contratos','Y','Y','Y','Y',NULL,NULL,'Cadastro de contratos','Formulário'),(3,'form_public_LGPD_2090_terceiros','Y','Y','Y','Y',NULL,NULL,'Cadastro de terceiros','Formulário'),(3,'form_public_LGPD_2093_ocorr_terc','Y','Y','Y','Y',NULL,NULL,'Cadastro de ocorrência de terceiros','Formulário'),(3,'form_public_LGPD_2095_med_tec','Y','','','',NULL,NULL,'Cadastro de medidas técnicas','Formulário'),(3,'form_public_LGPD_2097_config_assoc_med_atv',NULL,NULL,NULL,NULL,NULL,NULL,'Associar medidas técnicas aos ativos','Formulário'),(3,'form_public_LGPD_2100_prz_aprv_proc','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Configurações / SLA de aprovação de Processos de Negócio: Acesso à configuração do prazo limite para aprovação de Processos de Negócio cadastrados','Formulário'),(3,'form_public_LGPD_3000_riscos','Y','Y','Y','Y',NULL,NULL,'Cadastro de riscos','Formulário'),(3,'form_public_LGPD_4000_atividades','Y','Y','Y','Y',NULL,NULL,'Cadastro de atividades','Formulário'),(3,'form_public_LGPD_5000_cod_etica','Y','','','',NULL,NULL,'Cadastro de código de ética','Formulário'),(3,'form_public_LGPD_5100_cod_conduta',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(3,'form_public_LGPD_6000_PDCA','','','','',NULL,NULL,'PDCA','Formulário'),(3,'form_public_LGPD_6100_catalog_treinamentos','Y','Y','Y','Y',NULL,NULL,'Cadastro de catalogo de treinamentos','Formulário'),(3,'form_public_LGPD_6200_agenda_treina','Y','Y','Y','Y',NULL,NULL,'Agenda de treinamentos','Formulário'),(3,'form_public_LGPD_7300_envio_aval_forne','Y','Y','Y','Y',NULL,NULL,'Cadastro de questionários (Due Diligence)','Formulário'),(3,'form_public_LGPD_assoc_contr_6500',NULL,NULL,NULL,NULL,NULL,NULL,'Associação de contratos','Formulário'),(3,'form_public_LGPD_assoc_medtec_6700',NULL,NULL,NULL,NULL,NULL,NULL,'Associação de medidas técnicas','Formulário'),(3,'form_public_LGPD_assoc_pdca_risk_6400',NULL,NULL,NULL,NULL,NULL,NULL,'Associação de riscos ao PDCA','Formulário'),(3,'form_public_LGPD_assoc_pol_6300',NULL,NULL,NULL,NULL,NULL,NULL,'Associação de políticas','Formulário'),(3,'form_public_LGPD_assoc_proc_6600',NULL,NULL,NULL,NULL,NULL,NULL,'Associação de processos','Formulário'),(3,'form_public_LGPD_assoc_treina_6500',NULL,NULL,NULL,NULL,NULL,NULL,'Associação de treinamentos','Formulário'),(3,'form_public_LGPD_config_det_opt_7200','Y','Y','Y','Y',NULL,NULL,'Parametrizar opções do questionário de fornecedores','Formulário'),(3,'form_public_PAC_1000_user_portal',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(3,'Governance_menu',NULL,NULL,NULL,NULL,NULL,NULL,'Menu',NULL),(3,'grid_CMP_0100_faixas',NULL,NULL,NULL,NULL,NULL,NULL,'Consultar faixas de setup de auditoria','Painel'),(3,'grid_CMP_1000_mecanismos','',NULL,NULL,NULL,NULL,NULL,'[Item de menu] - Pilares do Compliance / Mecanismos de Auditoria: Acesso ao cadastro de Mecanismos de Auditoria para projetos de Compliance','Pilares de Compliance'),(3,'grid_CMP_1100_componentes','',NULL,NULL,NULL,NULL,NULL,'[Item de menu] - Pilares do Compliance / Componentes de Auditoria: Acesso ao cadastro de Componentes de Auditoria, que compõem os Mecanismos cadastrados','Pilares de Compliance'),(3,'grid_CMP_1100_entrevistados_desassociados',NULL,NULL,NULL,NULL,NULL,NULL,'Consultas candidatos a entrevistas de ciclo de auditoria ','Painel'),(3,'grid_CMP_1200_questoes','',NULL,NULL,NULL,NULL,NULL,'[Item de menu] - Pilares do Compliance / Questões de Auditoria: Acesso ao cadastro de perguntas que são utilizadas para a realização de auditorias de Compliance','Pilares de Compliance'),(3,'grid_CMP_1300_formularios','',NULL,NULL,NULL,NULL,NULL,'[Item de menu] - Pilares do Compliance / Formulários de Auditoria: Acesso ao cadastro e configuração de Formulários compostos por perguntas para a realização de auditorias de Compliance','Pilares de Compliance'),(3,'grid_CMP_1310_formulario_det',NULL,NULL,NULL,NULL,NULL,NULL,'Consulta detalhes do formulário de auditoria ','Painel'),(3,'grid_CMP_1400_formulas_mestre','',NULL,NULL,NULL,NULL,NULL,'[Item de menu] - Pilares do Compliance / Parâmetros de Ciclos de Auditoria: Acesso à configuração de parâmetros quantitativos utilizados nos Ciclos de Auditoria de Compliance','Pilares de Compliance'),(3,'grid_CMP_1410_formulas_det_mec',NULL,NULL,NULL,NULL,NULL,NULL,'Sub Consulta mecanismos do setup de auditoria','Painel'),(3,'grid_CMP_1500_acao','',NULL,NULL,NULL,NULL,NULL,'[Item de menu] - Pilares do Compliance / Ações de Auditoria: Acesso ao cadastro de ações pré-determinadas para serem sugeridas a partir do levantamento de determinada Questão cadastrada','Pilares de Compliance'),(3,'grid_CMP_1550_ger_acao','',NULL,NULL,NULL,NULL,NULL,'[Item de menu] - Auditoria de Compliance / Recomendações de Auditoria: Acesso à geração automática de recomendações pós Ciclo de Auditoria de Compliance','Auditoria de Compliance'),(3,'grid_CMP_1600_OL','',NULL,NULL,NULL,NULL,NULL,'[Item de menu] - Aspectos Jurídicos / Obrigações Legais: Acesso ao cadastro das obrigações legais que a entidade deve atender em um determinado exercício','Aspectos Jurídicos'),(3,'grid_CMP_2000_ciclos','',NULL,NULL,NULL,NULL,NULL,'[Item de menu] - Auditoria de Compliance / Ciclos de Auditoria: Acesso à gestão de Ciclos de Auditoria de Compliance','Auditoria de Compliance'),(3,'grid_CMP_2500_conf_entrevistados','',NULL,NULL,NULL,NULL,NULL,'[Item de menu] - Auditoria de Compliance / Entrevistados: Acesso à seleção de entrevistados que estarão associados a um Ciclo de Auditoria de Compliance','Auditoria de Compliance'),(3,'grid_CMP_2510_entrevistados_associados',NULL,NULL,NULL,NULL,NULL,NULL,'Relação de entrevistados de um ciclo de auditoria','Painel'),(3,'grid_CMP_3000_aplic_pesq','',NULL,NULL,NULL,NULL,NULL,'[Item de menu] - Auditoria de Compliance / Pesquisas de Auditoria: Acesso à aplicação de Pesquisas de Auditoria de Compliance','Auditoria de Compliance'),(3,'grid_CMP_acompanhar_pesquisas',NULL,NULL,NULL,NULL,NULL,NULL,'Consulta acompanhamento do andamento de pesquisas de auditorias','Painel'),(3,'grid_CMP_resultado_pesquisa','',NULL,NULL,NULL,NULL,NULL,'[Item de menu] - Auditoria de Compliance / Resultados de Auditoria: Acesso à gestão do resultado de Pesquisas de Auditoria de Compliance','Auditoria de Compliance'),(3,'grid_CMP_resultado_pesquisa_questoes',NULL,NULL,NULL,NULL,NULL,NULL,'Consulta resultado da pesquisa de auditoria ','Painel'),(3,'grid_CMP_resultado_pesquisa_status_mecanismo',NULL,NULL,NULL,NULL,NULL,NULL,'Consulta resultado da pesquisa por mecanismos de auditoria ','Painel'),(3,'grid_conf_quest_7100',NULL,NULL,NULL,NULL,NULL,NULL,'Cofiguração de questionário para fornecedores','Painel'),(3,'grid_DOM_tp_ol_1600','',NULL,NULL,NULL,NULL,NULL,'[Item de menu] - Aspectos Jurídicos / Tipos de Obrigações Legais: Acesso ao cadastro de tipos de obrigações legais','Aspectos Jurídicos'),(3,'grid_kanban_atividades',NULL,NULL,NULL,NULL,NULL,NULL,'Kanban de  atividades','Painel'),(3,'grid_kanban_atividades_add_registro',NULL,NULL,NULL,NULL,NULL,NULL,'Kanban de  atividades','Painel'),(3,'grid_LGPD_2001_form_entr_prc','Y','','','','Y','Y',NULL,'Fluxo de Informação'),(3,'grid_LGPD_2003_envio_entr_prc','Y','','','','Y','Y',NULL,'Fluxo de Informação'),(3,'grid_LGPD_2040_assoc_prc_atv','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Fluxo de Informação / Associações do Fluxo de Informação: Acesso à consulta das associações entre Processos de Negócio x Ativos de Informação x Artefatos x Metadados Pessoais','Fluxo de Informação'),(3,'grid_LGPD_2075_assoc_funcional_dados_fin',NULL,NULL,NULL,NULL,NULL,NULL,'Consulta associação de metadados','Painel'),(3,'grid_LGPD_2087_ndas','Y',NULL,NULL,NULL,'Y','Y',NULL,'Políticas e Regulamentos'),(3,'grid_LGPD_2097_assoc_med_atv','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Medidas Técnicas de Segurança / Associações com Ativos de Informação: Acesso à configuração da associação entre Medidas Técnicas de Segurança e Ativos de Informação utilizados pela entidade','Medidas Técnicas de Segurança'),(3,'grid_LGPD_3100_assoc_risc_atv','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Riscos / Associações de Riscos: Acesso à associações entre Riscos e outras informações cadastradas','Riscos'),(3,'grid_LGPD_3600_chklst_risk_area_mestre','Y','','','','Y','Y','[Item de menu] - Riscos / Checklist por área de identificação de riscos e atividades','Riscos'),(3,'grid_LGPD_6300_aluno_treina',NULL,NULL,NULL,NULL,NULL,NULL,'Consulta de lista de treinamentos realizados por colaborador','Painel'),(3,'grid_LGPD_7400_resp_aval_forne',NULL,NULL,NULL,NULL,NULL,NULL,'Consulta respostas de questionários  (Due Diligence)','Painel'),(3,'grid_new',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(3,'grid_new_pln_acao','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Atividades e Ações / Plano de Ação LGPD: Acesso ao cadastro do documento \"Plano de Ação\" de adequação à LGPD','Atividades e Ações'),(3,'grid_public_LGPD_0100_diagnostico','',NULL,NULL,NULL,NULL,NULL,'[Item de menu] - Configurações / Projeto de Diagnóstico da LGPD: Acesso à configuração das informações sobre o projeto de Diagnóstico da LGPD','Configurações'),(3,'grid_public_LGPD_0200_implement','',NULL,NULL,NULL,NULL,NULL,'[Item de menu] - Configurações / Projeto de Adequação da LGPD: Acesso à configuração das informações sobre o projeto de Adequação da LGPD','Configurações'),(3,'grid_public_LGPD_0300_operacao','',NULL,NULL,NULL,NULL,NULL,'[Item de menu] - Configurações / Projeto de Operação da LGPD: Acesso à configuração das informações sobre a fase de Operação da LGPD','Configurações'),(3,'grid_public_LGPD_0400_etapas','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Configurações / Etapas do Diagnóstico da LGPD: Acesso à configuração das etapas do projeto de Diagnóstico de um projeto de adequação à LGPD','Configurações'),(3,'grid_public_LGPD_1000_controlador','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Configurações / Entidade: Acesso à configuração dos dados da entidade','Configurações'),(3,'grid_public_LGPD_1001_diretoria','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Estrutura Organizacional / Diretoria: Acesso ao cadastro de Diretorias, que é o nível mais alto da hierarquia organizacional da entidade','Estrutura Organizacional'),(3,'grid_public_LGPD_1002_area','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Estrutura Organizacional / Área: Acesso ao cadastro de Áreas, que dividem uma determinada Diretoria na estrutura hierárquica da entidade','Estrutura Organizacional'),(3,'grid_public_LGPD_1003_departamento','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Estrutura Organizacional / Departamentos: Acesso ao cadastro de Departamentos, que dividem uma determinada Área na estrutura hierárquica da entidade','Estrutura Organizacional'),(3,'grid_public_LGPD_1004_cargos','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Estrutura Organizacional / Cargos: Acesso ao cadastro de Cargos a serem ocupados por pessoas da equipe que ocupem espaço na estrutura hierárquica da entidade','Estrutura Organizacional'),(3,'grid_public_LGPD_1050_organograma','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Estrutura Organizacional / Lotação: Acesso ao cadastro de unidades de trabalho, onde é possível alocar as equipes da entidade','Estrutura Organizacional'),(3,'grid_public_LGPD_1051_comite','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Estrutura Organizacional / Comitês: Acesso ao cadastro de comitês da entidade, que congregam uma ou mais pessoas previamente cadastradas','Estrutura Organizacional'),(3,'grid_public_LGPD_1053_eventos_comite','',NULL,NULL,NULL,NULL,NULL,'[Item de menu] - Atividades e Ações / Eventos de Comitê: Acesso ao cadastro de eventos associados aos Comitês da entidade','Atividades e Ações'),(3,'grid_public_LGPD_1053_sub_eventos_comite',NULL,NULL,NULL,NULL,NULL,NULL,'Sub Consulta de Eventos','Painel'),(3,'grid_public_LGPD_1100_equipe','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Estrutura Organizacional / Equipe: Acesso ao cadastro de pessoas que podem ocupar cargos na estrutura hierárquica da entidade. Essas pessoas serão associadas a diversas outras entidades tratadas na plataforma','Estrutura Organizacional'),(3,'grid_public_LGPD_2000_proc_aprv_prz_expirado','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Atividades e Ações / Processos de Negócio Pendentes: Acesso à gestão de Processos de Negócio com SLA de aprovação expirado','Atividades e Ações'),(3,'grid_public_LGPD_2000_processos','Y','','','','Y','Y','[Item de menu] - Fluxo de Informação / Processos de Negócio: Acesso ao cadastro de Processos de Negócio que definem as rotinas operacionais da entidade','Fluxo de Informação'),(3,'grid_public_LGPD_2000_sub_proc_pessoa',NULL,NULL,NULL,NULL,NULL,NULL,'Consulta processo por responsável','Painel'),(3,'grid_public_LGPD_2000_sub_processos_atv',NULL,NULL,NULL,NULL,NULL,NULL,'Consulta processos por ativos','Painel'),(3,'grid_public_LGPD_2010_ativos','Y','','','','Y','Y','[Item de menu] - Fluxo de Informação / Ativos de Informação: Acesso ao cadastro de Ativos de Informação utilizados pela entidade na execução de seus Processos de Negócio','Fluxo de Informação'),(3,'grid_public_LGPD_2010_ativos_1',NULL,NULL,NULL,NULL,NULL,NULL,'Consulta Ativos','Painel'),(3,'grid_public_LGPD_2010_ativos_n_utlz_fin',NULL,NULL,NULL,NULL,NULL,NULL,'Processos disponivel para associação com finalidades','Painel'),(3,'grid_public_LGPD_2010_ativos_utlz_fin',NULL,NULL,NULL,NULL,NULL,NULL,'Processos associados a finalidade','Painel'),(3,'grid_public_LGPD_2010_sub_ativos',NULL,NULL,NULL,NULL,NULL,NULL,'Sub Consulta de Ativos','Painel'),(3,'grid_public_LGPD_2020_artefatos','Y','','','','Y','Y','[Item de menu] - Fluxo de Informação / Artefatos: Acesso ao cadastro de Artefatos e Documentos tratados nos Ativos de Informação utilizados pela entidade','Fluxo de Informação'),(3,'grid_public_LGPD_2020_artefatos_n_utlz_fin',NULL,NULL,NULL,NULL,NULL,NULL,'Artefatos disponiveis para associação com finalidades','Painel'),(3,'grid_public_LGPD_2020_artefatos_utlz_fin',NULL,NULL,NULL,NULL,NULL,NULL,'Artefatos associados a finalidades','Painel'),(3,'grid_public_LGPD_2030_assoc_art_metadados',NULL,NULL,NULL,NULL,NULL,NULL,'Associação de Artefatos e metadados','Painel'),(3,'grid_public_LGPD_2030_dados','Y','','','','Y','Y','[Item de menu] - Fluxo de Informação / Metadados Pessoais: Acesso ao cadastro de Metadados Pessoais presentes nos diferentes Artefatos utilizados pela entidade','Fluxo de Informação'),(3,'grid_public_LGPD_2065_fund_legal','Y','','','','Y','Y','[Item de menu] - Aspectos Jurídicos / Fundamentos Legais: Acesso ao cadastro de Fundamentos Legais utilizados pela entidade','Aspectos Jurídicos'),(3,'grid_public_LGPD_2066_ambiente_reg','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Aspectos Jurídicos / Ambientes regulatórios: Acesso ao cadastro de Ambientes Regulatórios a serem associados a Fundamentos Legais utilizados pela entidade','Aspectos Jurídicos'),(3,'grid_public_LGPD_2070_finalidades','Y','','','','Y','Y','[Item de menu] - Tratamento de Dados Pessoais / Parametrizar Finalidades de Tratamentos: Acesso à configuração dos aspectos e detalhes das Finalidades de Tratamento de Dados Pessoais previamente cadastradas','Tratamento de Dados Pessoais'),(3,'grid_public_LGPD_2070_registrar_finalidades','Y','','','','Y','Y','[Item de menu] - Tratamento de Dados Pessoais / Registrar Finalidade de Tratamento: Acesso ao cadastro de Finalidades de Tratamento de Dados Pessoais executadas pela entidade','Tratamento de Dados Pessoais'),(3,'grid_public_LGPD_2070_sub_contratos_finalidades',NULL,NULL,NULL,NULL,NULL,NULL,'Sub consulta de contratos dentro da finalidade','Painel'),(3,'grid_public_LGPD_2070_sub_finalidades',NULL,NULL,NULL,NULL,NULL,NULL,'Sub consulta de finalidades','Painel'),(3,'grid_public_LGPD_2073_assoc_ativos_fin',NULL,NULL,NULL,NULL,NULL,NULL,'Associação de ativos na finalidade','Painel'),(3,'grid_public_LGPD_2075_assoc_metadados_fin',NULL,NULL,NULL,NULL,NULL,NULL,'Associação de metadados na finalidade','Painel'),(3,'grid_public_LGPD_2080_politicas','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Políticas e Regulamentos / Políticas: Acesso ao cadastro de políticas associadas à Governança de Privacidade da entidade','Políticas e Regulamentos'),(3,'grid_public_LGPD_2085_contratos','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Políticas e Regulamentos / Contratos: Acesso ao cadastro de contratos e modelos de contratos utilizados pela entidade','Políticas e Regulamentos'),(3,'grid_public_LGPD_2090_terceiros','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Gestão de terceiros / Terceiros: Acesso ao cadastro de entidades terceiras (PJ ou PF) associadas à entidade','Gestão de Terceiros'),(3,'grid_public_LGPD_2093_ocorr_terc','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Gestão de terceiros / Ocorrências: Acesso ao cadastro de ocorrências relacionadas à Terceiros associados à entidade','Gestão de Terceiros'),(3,'grid_public_LGPD_2095_med_tec','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Medidas Técnicas de Segurança / Medidas Técnicas de Segurança: Acesso ao cadastro de Medidas Técnicas de Segurança da Informação que podem ser associadas a Ativos cadastrados','Medidas Técnicas de Segurança'),(3,'grid_public_LGPD_2095_sub_med_tec',NULL,NULL,NULL,NULL,NULL,NULL,'Sub Consulta de medidas técnicas','Painel'),(3,'grid_public_LGPD_3000_riscos','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Riscos / Riscos: Acesso ao cadastro de Riscos de Privacidade e Compliance','Riscos'),(3,'grid_public_LGPD_3000_sub_consulta_riscos',NULL,NULL,NULL,NULL,NULL,NULL,'Sub consulta de riscos','Painel'),(3,'grid_public_LGPD_3300_assoc_risc_prc',NULL,NULL,NULL,NULL,NULL,NULL,'Associar risco a processos','Painel'),(3,'grid_public_LGPD_4000_atividades','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Atividades e Ações / Atividades e Ações: Acesso ao cadastro de atividades e ações de governança e compliance','Atividades e Ações'),(3,'grid_public_LGPD_5000_cod_etica','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Políticas e Regulamentos / Códigos e Regulamentos Internos: Acesso ao cadastro de documentos que definem as regras internas de Compliance da entidade','Políticas e Regulamentos'),(3,'grid_public_LGPD_5100_cod_conduta',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(3,'grid_public_LGPD_6000_PDCA','',NULL,NULL,NULL,NULL,NULL,'[Item de menu] - Atividades e Ações / Gestão de ciclo de PDCA de Compliance: Acesso ao planejamento e gestão de ciclos de PDCA de Compliance','Atividades e Ações'),(3,'grid_public_LGPD_6000_SUB_PDCA',NULL,NULL,NULL,NULL,NULL,NULL,'Sub consulta PDCA','Painel'),(3,'grid_public_LGPD_6100_catalog_treinamentos','',NULL,NULL,NULL,NULL,NULL,'[Item de menu] - Atividades e Ações / Catálogo de treinamentos: Acesso ao cadastro dos tipos de treinamentos que a entidade pode executar para suas equipes','Atividades e Ações'),(3,'grid_public_LGPD_6200_agenda_treina','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Atividades e Ações / Agenda de Treinamentos: Acesso à gestão de agenda de treinamentos e capacitações internas da entidade','Atividades e Ações'),(3,'grid_public_LGPD_7300_envio_aval_forne',NULL,NULL,NULL,NULL,NULL,NULL,'Consulta de questionários (Due Diligence)','Painel'),(3,'grid_public_LGPD_7300_envio_aval_forne_gerencial','Y',NULL,NULL,NULL,'Y','Y',NULL,'Gestão de Terceiros'),(3,'grid_public_LGPD_cons_rev_contr_6500',NULL,NULL,NULL,NULL,NULL,NULL,'Consulta revisões de contrato','Painel'),(3,'grid_public_LGPD_cons_rev_medtec_6700',NULL,NULL,NULL,NULL,NULL,NULL,'Consulta revisões de medidas técnicas','Painel'),(3,'grid_public_LGPD_cons_rev_pol_6300',NULL,NULL,NULL,NULL,NULL,NULL,'Consulta revisão de políticas','Painel'),(3,'grid_public_LGPD_cons_rev_proc_6600',NULL,NULL,NULL,NULL,NULL,NULL,'Consulta revisão de processos','Painel'),(3,'grid_public_LGPD_cons_rev_risk_6400',NULL,NULL,NULL,NULL,NULL,NULL,'Consulta revisão de riscos','Painel'),(3,'grid_public_PAC_9000_DPIA',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(3,'grid_public_PAC_9100_LIA',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(3,'grid_public_PCP_9000_DPIA',NULL,NULL,NULL,NULL,NULL,NULL,'Consulta DPIA',NULL),(3,'grid_public_pcp_9100_LIA',NULL,NULL,NULL,NULL,NULL,NULL,'Consulta LIA ',NULL),(3,'grid_public_subconsulta_sec_users',NULL,NULL,NULL,NULL,NULL,NULL,'Sub consulta de usuarios','Painel'),(3,'grid_sc_log','',NULL,NULL,NULL,NULL,NULL,'[Item de menu] - Segurança / Histórico de acessos: Acesso à consulta à histórico de acessos de usuários à plataforma','Segurança'),(3,'help_cadastro_titulares',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(3,'help_ciclo_de_vida',NULL,NULL,NULL,NULL,NULL,NULL,'Help Ciclo de vida','Painel'),(3,'help_finalidades_fundamentos',NULL,NULL,NULL,NULL,NULL,NULL,'Help Finalidades','Painel'),(3,'help_geracao_atividades',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(3,'help_geracao_riscos',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(3,'help_gestao_consentimentos',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(3,'help_gestao_incidentes',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(3,'help_gestao_notificacao',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(3,'help_integracao_portais',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(3,'help_lotes_validacao',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(3,'help_medidas_administrativas',NULL,NULL,NULL,NULL,NULL,NULL,'Help medidas administrativas','Painel'),(3,'help_medidas_tecnicas',NULL,NULL,NULL,NULL,NULL,NULL,'Help para medidas técnicas','Painel'),(3,'help_plano_acao_atividades',NULL,NULL,NULL,NULL,NULL,NULL,'Help Atividades','Painel'),(3,'help_relatorios',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(3,'help_riscos_e_impactos',NULL,NULL,NULL,NULL,NULL,NULL,'Help Riscos','Painel'),(3,'homepage',NULL,NULL,NULL,NULL,NULL,NULL,'Home Page (Responsábilidades e Atividades)','Painel'),(3,'homepage_help',NULL,NULL,NULL,NULL,NULL,NULL,'Help','Painel'),(3,'mapa_calor_risco',NULL,NULL,NULL,NULL,NULL,NULL,'Mapa de risco','Painel'),(3,'Mapa_Calor_Riscos',NULL,NULL,NULL,NULL,NULL,NULL,'Mapa de calor de riscos ','Painel'),(3,'menu',NULL,NULL,NULL,NULL,NULL,NULL,'Menu PCP','Painel'),(3,'menu_dinamico',NULL,NULL,NULL,NULL,NULL,NULL,'Menu','Painel'),(3,'Menu_Pac',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(3,'Metadados','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Painel / Metadados Pessoais: Acesso à exibição dos principais indicadores sobre Metadados Pessoais','Painel'),(3,'novo_menu',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(3,'pac_app_change_pswd','Y','','','','','','[Item de menu] - SeguranÃ§a / AlteraÃ§Ã£o de senha: Acesso Ã  gestÃ£o de senhas de usuÃ¡rios da plataforma','SeguranÃ§a'),(3,'pac_app_form_sec_groups_apps','',NULL,NULL,NULL,NULL,NULL,'[Item de menu] - SeguranÃ§a / AssociaÃ§Ã£o de perfis a aplicaÃ§Ãµes: Acesso Ã  configuraÃ§Ã£o da associaÃ§Ã£o de perfis de acesso com as aplicaÃ§Ãµes da plataforma','SeguranÃ§a'),(3,'pac_app_grid_sec_apps','',NULL,NULL,NULL,NULL,NULL,'[Item de menu] - SeguranÃ§a / AplicaÃ§Ãµes: Acesso ao cadastro de aplicaÃ§Ãµes da plataforma','SeguranÃ§a'),(3,'pac_app_grid_sec_groups','',NULL,NULL,NULL,NULL,NULL,'[Item de menu] - SeguranÃ§a / Perfis: Acesso ao cadastro de perfis de acesso dos usuÃ¡rios da plataforma','SeguranÃ§a'),(3,'pac_app_grid_sec_users','',NULL,NULL,NULL,NULL,NULL,'[Item de menu] - SeguranÃ§a / UsuÃ¡rios: Acesso ao cadastro de usuÃ¡rios da plataforma','SeguranÃ§a'),(3,'pac_app_grid_sec_users_groups','',NULL,NULL,NULL,NULL,NULL,'[Item de menu] - SeguranÃ§a / AssociaÃ§Ã£o de usuÃ¡rios a perfis: Acesso Ã  configuraÃ§Ã£o da associaÃ§Ã£o de usuÃ¡rios a perfis de acesso','SeguranÃ§a'),(3,'pac_app_search_sec_groups','',NULL,NULL,NULL,NULL,NULL,'[Item de menu] - SeguranÃ§a / AssociaÃ§Ã£o de perfis a aplicaÃ§Ãµes: Acesso Ã  configuraÃ§Ã£o da associaÃ§Ã£o de perfis de acesso com as aplicaÃ§Ãµes da plataforma','SeguranÃ§a'),(3,'pac_menu',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(3,'PAG_menu',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(3,'param_aval_mestre_7000','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Gestão de terceiros / Formulários de due diligence: Acesso à criação de formulários (e suas questões) para auto avaliação de terceiros','Gestão de Terceiros'),(3,'PDCA','',NULL,NULL,NULL,NULL,NULL,'[Item de menu] - Painel / Ciclos de PDCA: Acesso à exibição dos principais indicadores sobre Ciclos de PDCA de Compliance','Painel'),(3,'pdfreport_LGPD_7300_envio_aval_forne',NULL,NULL,NULL,NULL,NULL,NULL,'geração de PDF - questionário (Due Diligence)','Painel'),(3,'popup_confirm_action',NULL,NULL,NULL,NULL,NULL,NULL,'Pop-up ( não se aplica ao módulo de segirança)','Painel'),(3,'popup_confirm_action_status',NULL,NULL,NULL,NULL,NULL,NULL,'Pop_Up ( Não se plaica ao módulo de segurança ) ','Painel'),(3,'Processos','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Painel / Processos de Negócio: Acesso à exibição dos principais indicadores sobre Processos de Negócio','Painel'),(3,'relatorio_ciclos_complience',NULL,NULL,NULL,NULL,NULL,NULL,'Extrato de cilco de auditoria ','Painel'),(3,'relatorio_dpia',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(3,'relatorio_dpia_1',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(3,'relatorio_finalidades',NULL,NULL,NULL,NULL,NULL,NULL,'Relatório de finalidades','Painel'),(3,'relatorio_lia',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(3,'relatorio_notificacao',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(3,'relatorio_resp_aval',NULL,NULL,NULL,NULL,NULL,NULL,'Relatório Avaliações','Painel'),(3,'resumo_finalidade',NULL,NULL,NULL,NULL,NULL,NULL,'Resumo de finalidade','Painel'),(3,'Riscos','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Painel / Riscos: Acesso à exibição dos principais indicadores sobre Gestão de Riscos de Privacidade e Compliance','Painel'),(3,'risk_heat_map','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Riscos / Mapa de Calor: Acesso à exibição do Mapa de Calor dos Riscos cadastrados','Riscos'),(3,'search_public_LGPD_4000_atividades',NULL,NULL,NULL,NULL,NULL,NULL,'Filtro de atividades','Painel'),(3,'sec_change_pswd',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(3,'sec_form_add_users',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(3,'sec_form_edit_users',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(3,'sec_form_sec_apps',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(3,'sec_form_sec_groups',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(3,'sec_form_sec_groups_apps',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(3,'sec_grid_sec_apps',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(3,'sec_grid_sec_groups',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(3,'sec_grid_sec_users',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(3,'sec_grid_sec_users_groups',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(3,'sec_Login',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(3,'sec_menu',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(3,'sec_retrieve_pswd',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(3,'sec_search_sec_groups',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(3,'sec_settings',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(3,'sec_sync_apps',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(3,'sub_consulta_3000_riscos_incidente',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(3,'sub_consulta_3100_assoc_risc_atv',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(3,'sub_consulta_3300_assoc_risc_prc',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(3,'sub_consulta_3400_assoc_risc_fin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(3,'sub_consulta_CMP_1610_ol_agenda',NULL,NULL,NULL,NULL,NULL,NULL,'Sub consulta de agenda de obrigações legais por obrigação','Painel'),(3,'sub_consulta_CMP_2510_det_conf_entrevistados',NULL,NULL,NULL,NULL,NULL,NULL,'Entrevitados em presquisa de auditoria --> Sub Consulta de configuração de entrevidados de pesquisa de auditoria ','Painel'),(3,'sub_consulta_CMP_3000_aplic',NULL,NULL,NULL,NULL,NULL,NULL,'Sub consulta status da aplicação de pesquisa de auditoria','Painel'),(3,'sub_consulta_CMP_4000_respostas_mestre',NULL,NULL,NULL,NULL,NULL,NULL,'Sub consulta status de respostas dos formulários de auditoria dentro de um ciclo ','Painel'),(3,'sub_consulta_configurar_metadados',NULL,NULL,NULL,NULL,NULL,NULL,'Sub consulta configuração de metadados','Painel'),(3,'sub_consulta_LGPD_2097_assoc_med_atv',NULL,NULL,NULL,NULL,NULL,NULL,'Sub consulta de associação entre medidas técnicas e ativos','Painel'),(3,'sub_consulta_LGPD_6200_agenda_treina',NULL,NULL,NULL,NULL,NULL,NULL,'Sub consulta de agenda de treinamentos ','Painel'),(3,'sub_consulta_PAC_1100_sol_portal',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(3,'sub_consulta_PAC_3200_tit_consent',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(3,'sub_consulta_PAC_4000_notificacao',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(3,'sub_consulta_PAG_ocorr_lote_1100',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(3,'sub_form_configurar_metados',NULL,NULL,NULL,NULL,NULL,NULL,'Configurar metadados','Painel'),(3,'sub_grid_CMP_1550_ger_acao',NULL,NULL,NULL,NULL,NULL,NULL,'Sub grid de recomendaçoes de auditoria por ciclo','Painel'),(3,'sub_grid_LGPD_2050_assoc_atv_art',NULL,NULL,NULL,NULL,NULL,NULL,'Sub consulta de associação entre ativos e artefatos',NULL),(3,'sub_grid_PAC_1400_tit_afet_inc',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(3,'sub_grid_public_LGPD_2093_ocorr_terc',NULL,NULL,NULL,NULL,NULL,NULL,'Sub consulta ocorrência de terceiros','Painel'),(4,'app_change_pswd','',NULL,NULL,NULL,NULL,NULL,'[Item de menu] - Segurança / Alteração de senha: Acesso à gestão de senhas de usuários da plataforma','Segurança'),(4,'app_form_add_users','','','','',NULL,NULL,'Cadastrar usuários','Formulário'),(4,'app_form_edit_users','','','','',NULL,NULL,'Alterar usuários','Formulário'),(4,'app_form_sec_apps','','','','',NULL,NULL,'Cadastrar aplicações','Formulário'),(4,'app_form_sec_groups','','','','',NULL,NULL,'Cadastro de grupos de usuários','Formulário'),(4,'app_form_sec_groups_apps','','','','',NULL,NULL,'Associar grupos x aplicações','Painel'),(4,'app_grid_sec_apps','',NULL,NULL,NULL,NULL,NULL,'[Item de menu] - Segurança / Aplicações: Acesso ao cadastro de aplicações da plataforma','Segurança'),(4,'app_grid_sec_groups','',NULL,NULL,NULL,NULL,NULL,'[Item de menu] - Segurança / Perfis: Acesso ao cadastro de perfis de acesso dos usuários da plataforma','Segurança'),(4,'app_grid_sec_users','',NULL,NULL,NULL,NULL,NULL,'[Item de menu] - Segurança / Usuários: Acesso ao cadastro de usuários da plataforma','Segurança'),(4,'app_grid_sec_users_groups','',NULL,NULL,NULL,NULL,NULL,'[Item de menu] - Segurança / Associação de usuários a perfis: Acesso à configuração da associação de usuários a perfis de acesso','Segurança'),(4,'app_Login',NULL,NULL,NULL,NULL,NULL,NULL,'Login',NULL),(4,'app_menu',NULL,NULL,NULL,NULL,NULL,NULL,'Menu','Painel'),(4,'app_retrieve_pswd',NULL,NULL,NULL,NULL,NULL,NULL,'Esqueceu a senha','Painel'),(4,'app_search_sec_groups','',NULL,NULL,NULL,NULL,NULL,'[Item de menu] - Segurança / Associação de perfis a aplicações: Acesso à configuração da associação de perfis de acesso com as aplicações da plataforma','Segurança'),(4,'app_settings','',NULL,NULL,NULL,NULL,NULL,'Configurações de segurança','Segurança'),(4,'app_sync_apps','',NULL,NULL,NULL,NULL,NULL,'Sincronização de aplicações','Segurança'),(4,'Artefatos','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Painel / Artefatos: Acesso à exibição dos principais indicadores sobre Artefatos e Documentos','Painel'),(4,'associar_metadados_finalidade',NULL,NULL,NULL,NULL,NULL,NULL,'Associar metadados na finalidade','Painel'),(4,'associar_metadados_finalidade_new',NULL,NULL,NULL,NULL,NULL,NULL,'Associar metadados a finalidades','Painel'),(4,'Atividades','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Painel / Atividades e Ações: Acesso à exibição dos principais indicadores sobre Atividades e Ações','Painel'),(4,'Ativos','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Painel / Ativos de Informação: Acesso à exibição dos principais indicadores sobre Ativos de Informação','Painel'),(4,'Auto_cadastro_PAC_4000_notificacao',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(4,'blank_email',NULL,NULL,NULL,NULL,NULL,NULL,'Enviar mail','Painel'),(4,'blank_pipeline','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Atividades e Ações / Meu Quadro de Atividades: Acesso ao Kanban de atividades do usuário logado','Atividades e Ações'),(4,'blank_pipeline_Ajax',NULL,NULL,NULL,NULL,NULL,NULL,'Pipeline de atividades','Painel'),(4,'cad_sol_dpia_pcp_9000','Y','','','','Y','Y',NULL,'Fluxo de Informação'),(4,'Cadastro_DEN_1000_registro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(4,'Cadastro_DEN_1100_cat',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(4,'cadastro_PAC_1110_atv_sol',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(4,'cadastro_PAC_1200_sla_sol_portal',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(4,'Cadastro_PAC_1400_titulares',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(4,'Cadastro_PAC_1410_dados_tit',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(4,'Cadastro_PAC_2000_incidentes',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(4,'Cadastro_PAC_2100_sla_notificacao',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(4,'Cadastro_PAC_3100_env_consent',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(4,'Cadastro_PAC_4000_notificacao',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(4,'Cadastro_PAG_lote_1000',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(4,'cadastro_PAG_ocorr_lote_1100',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(4,'calendar_app',NULL,NULL,NULL,NULL,NULL,NULL,'Calendário','Painel'),(4,'calendar_public_LGPD_4000_atividades',NULL,NULL,NULL,NULL,NULL,NULL,'Calendário de atividades ( DPO )','Painel'),(4,'chart_public_LGPD_2000_processos_complex','Y','','','','Y','Y','Gráfico processo por complexidade','Painel'),(4,'chart_public_LGPD_2000_processos_geral','Y','','','','Y','Y','Gráfico processos','Painel'),(4,'chart_public_LGPD_2000_processos_resp','Y','','','','Y','Y','Gráfico processos por responsável','Painel'),(4,'chart_public_LGPD_2000_status_processos','Y','','','','Y','Y','Gráfico processo por status','Painel'),(4,'chart_public_LGPD_2000_tipo_processo','Y','','','','Y','Y','Gráfico processos por tipo','Painel'),(4,'chart_public_LGPD_2010_confia_ativos',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico confibilidade dos ativos','Painel'),(4,'chart_public_LGPD_2010_disp_ativos',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico ativos por nível de disponibilidade','Painel'),(4,'chart_public_LGPD_2010_integridade_ativos',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico ativos por nível de integridade','Painel'),(4,'chart_public_LGPD_2010_resp_ativos',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico ativos por responsável','Painel'),(4,'chart_public_LGPD_2010_tipo_ativos',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico tipos de ativos','Painel'),(4,'chart_public_LGPD_2020_artefat_contrato',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico artefatos tipo contrato','Painel'),(4,'chart_public_LGPD_2020_contrato_artefatos',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico contratos x artefatos','Painel'),(4,'chart_public_LGPD_2020_tipo_artefatos',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico artefatos por tipo','Painel'),(4,'chart_public_LGPD_2030_classif_dados',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico classificação de metadados','Painel'),(4,'chart_public_LGPD_2030_dados_anonimizavel',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico metadados anonimizavel','Painel'),(4,'chart_public_LGPD_2030_tipif_dados',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico tipos de dados','Painel'),(4,'chart_public_LGPD_2070_fin_compart_dados',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico finalidades por compartilhamento','Painel'),(4,'chart_public_LGPD_2070_fin_dad_criancas',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico finalidades por dados de crianças','Painel'),(4,'chart_public_LGPD_2070_fin_faz_descarte',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico finalidades por descarte','Painel'),(4,'chart_public_LGPD_2070_fin_frequencia',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico finalidades por ferequencia','Painel'),(4,'chart_public_LGPD_2070_fin_hipoteses',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico finalidades por hipóteses de tratamento','Painel'),(4,'chart_public_LGPD_2070_fin_papel',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico papel da entidade','Painel'),(4,'chart_public_LGPD_2070_fin_processos','Y','','','','Y','Y','Gráfico finalidades por processos','Painel'),(4,'chart_public_LGPD_2070_fin_rot_automatizada',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico finalidades por rotinas automatizadas','Painel'),(4,'chart_public_LGPD_2070_fin_utlz_operador',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico finalidades por utiliza operador','Painel'),(4,'chart_public_LGPD_2070_fin_volumetria',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico finliadades por volumetria','Painel'),(4,'chart_public_LGPD_3000_categoria_riscos',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico riscos por categoria','Painel'),(4,'chart_public_LGPD_3000_criticidade_riscos',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico riscos por criticidade','Painel'),(4,'chart_public_LGPD_3000_estrategia_riscos',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico riscos por estratégia','Painel'),(4,'chart_public_LGPD_3000_impacto_riscos',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico riscos por impacto','Painel'),(4,'chart_public_LGPD_3000_prob_riscos',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico riscos por probabilidade','Painel'),(4,'chart_public_LGPD_3000_resp_riscos',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico riscos por responsáveis','Painel'),(4,'chart_public_LGPD_3000_status_riscos',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico riscos por status','Painel'),(4,'chart_public_LGPD_4000_atividades_geral',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico atividades','Painel'),(4,'chart_public_LGPD_4000_disc_atividades',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico atividades por disciplina','Painel'),(4,'chart_public_LGPD_4000_etapa_atividades',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico atividades por etapas','Painel'),(4,'chart_public_LGPD_4000_resp_atividades',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico atividades por responsável','Painel'),(4,'chart_public_LGPD_4000_status_resp_atividade',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico atividades por responsável e status','Painel'),(4,'chart_public_LGPD_assoc_pdca_contr_6500',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico PDCA de contratos','Painel'),(4,'chart_public_LGPD_assoc_pdca_finalizados_treina_6500',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico PDCA de treinamentos','Painel'),(4,'chart_public_LGPD_assoc_pdca_medtec_6700',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico PDCA de medidas técnicas','Painel'),(4,'chart_public_LGPD_assoc_pdca_pol_6300',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico PDCA de políticas','Painel'),(4,'chart_public_LGPD_assoc_pdca_proc_6600',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico PDCA de processos','Painel'),(4,'chart_public_LGPD_assoc_pdca_realizar_treina_6500',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico PDCA realização de treinamentos','Painel'),(4,'chart_public_LGPD_assoc_pdca_risk_6400',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico PDCA de riscos','Painel'),(4,'cons_dad_nao_utlz_LGPD_2030_dados','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Fluxo de Informação / Metadados Pessoais não utilizados: Acesso à consulta dos Metadados Pessoais cadastrados mas não utilizados em nenhuma associação','Fluxo de Informação'),(4,'cons_minhas_obr_CMP_1610_ol_agenda','',NULL,NULL,NULL,NULL,NULL,'[Item de menu] - Aspectos Jurídicos / Minhas Obrigações Legais: Acesso ao cadastro das obrigações legais da entidade que estão sob a responsabilidade do usuário logado','Aspectos Jurídicos'),(4,'Consulta_DEN_1000_registro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(4,'Consulta_DEN_1100_cat',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(4,'consulta_gerencial_CMP_1610_ol_agenda','',NULL,NULL,NULL,NULL,NULL,'[Item de menu] - Aspectos Jurídicos / Acompanhamento de Obrigações Legais: Acesso ao painel de acompanhamento do status das obrigações legais da entidade','Aspectos Jurídicos'),(4,'consulta_gerencial_LGPD_4000_atividades','',NULL,NULL,NULL,NULL,NULL,'[Item de menu] - Atividades e Ações / Acompanhamento de Atividades e Ações: Acesso ao painel de acompanhamento do status das obrigações legais da entidade','Atividades e Ações'),(4,'Consulta_LGPD_3000_riscos_assistant',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(4,'Consulta_LGPD_4000_atividades_assistant',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(4,'Consulta_PAC_1000_user_portal',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(4,'Consulta_PAC_1100_sol_portal',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(4,'consulta_PAC_1200_sla_sol_portal',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(4,'Consulta_PAC_1400_titulares',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(4,'Consulta_PAC_1410_dados_tit',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(4,'Consulta_PAC_2000_incidentes',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(4,'Consulta_PAC_3100_env_consent',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(4,'Consulta_PAC_4000_notificacao',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(4,'Consulta_PAG_lote_1000',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(4,'Consulta_public_LGPD_3000_riscos',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(4,'control_calendar',NULL,NULL,NULL,NULL,NULL,NULL,'Meu calendário de atividades de adequação',NULL),(4,'control_login',NULL,NULL,NULL,NULL,NULL,NULL,'Login','Painel'),(4,'control_login_diligence',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(4,'esqueci_senha',NULL,NULL,NULL,NULL,NULL,NULL,'Esqueceu a senha','Painel'),(4,'extrato_pdca',NULL,NULL,NULL,NULL,NULL,NULL,'Extrato PDCA','Painel'),(4,'Finalidades','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Painel / Finalidades de Tratamento de Dados Pessoais: Acesso à exibição dos principais indicadores sobre Finalidades de Tratamento de Dados Pessoais','Painel'),(4,'form_aval_7000','Y',NULL,NULL,NULL,NULL,NULL,'Formulários de due diligence: Acesso à criação de formulários (e suas questões) para auto avaliação de terceiros','Gestão de Terceiros'),(4,'form_CMP_1000_mecanismos','','','','',NULL,NULL,'Cadastro de mecanismos de auditoria ','Formulário'),(4,'form_CMP_1100_componentes','','','','',NULL,NULL,'Cadastro de componentes de auditoria','Formulário'),(4,'form_CMP_1200_questoes','','','','',NULL,NULL,'Cadastro de questões de auditoria','Formulário'),(4,'form_CMP_1300_formularios','','','','',NULL,NULL,'Cadatro de formulários de auditoria ','Formulário'),(4,'form_CMP_1300_formularios_edit','','','','',NULL,NULL,'Edição de formulários de auditoria','Formulário'),(4,'form_CMP_1400_formulas_mestre','','','','',NULL,NULL,'Parametrização de Setup de Auditoria','Formulário'),(4,'form_CMP_1400_formulas_view','','','','',NULL,NULL,'Visualizar setup de auditoria','Formulário'),(4,'form_CMP_1410_formulas_det_mec','','','','',NULL,NULL,'Parametrizar mecanismos de auditoria no setup','Formulário'),(4,'form_CMP_1420_formulas_det_niv_ad','','','','',NULL,NULL,'Parametrizar níveis de aderência do setup de auditoria ','Formulário'),(4,'form_CMP_1430_formulas_det_lim','','','','',NULL,NULL,'Parametrizar faixas do setup de auditoria','Formulário'),(4,'form_CMP_1500_acao','','','','',NULL,NULL,'Recomendações de auditorias','Formulário'),(4,'form_CMP_1600_OL','','','','',NULL,NULL,'Cadastro de Obrigações Legais ','Formulário'),(4,'form_CMP_2000_ciclos','','','','',NULL,NULL,'Cadastro de ciclos de auditoria','Formulário'),(4,'form_CMP_2500_conf_entrevistados','','','','',NULL,NULL,'Cadastro de entrevistados do ciclo de auditoria ','Formulário'),(4,'form_CMP_2500_conf_entrevistados_1','','','','',NULL,NULL,'Cadastro de entrevistados ','Formulário'),(4,'form_CMP_2500_conf_param_entrevistados','','','','',NULL,NULL,'Parametrizar relação de entrevistados de um ciclo de auditoria','Formulário'),(4,'form_CMP_3000_aplic_pesq','','','','',NULL,NULL,'Cadastro de aplicação de pesquisa de auditorias ','Formulário'),(4,'form_CMP_resultados_pesquisas','','','','',NULL,NULL,'Cadastro de resultado de pesquisas de auditoria','Formulário'),(4,'form_conf_quest_7100','','','','',NULL,NULL,'Configurar questionário de fornecedores','Formulário'),(4,'form_diligence',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(4,'form_DOM_tp_ol_1600','','','','',NULL,NULL,'Cadastro de tipos de obrigações ','Formulário'),(4,'form_kanban_atividades','Y','','','Y',NULL,NULL,'Kanban de  atividades','Formulário'),(4,'form_kanban_atividades_add_registro','Y','','','Y',NULL,NULL,'Cadastrar atividades pelo kanban','Formulário'),(4,'form_LGPD_0002_conf_smpt','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Configurações / Configuração de envio de e-mails: Acesso à configuração do endereço de de SMTP para envio de e-mails da plataforma','Formulário'),(4,'form_LGPD_2001_form_entr_prc','Y','','','','Y','Y',NULL,'Fluxo de Informação'),(4,'form_LGPD_2003_envio_entr_prc','Y','','','','Y','Y',NULL,'Fluxo de Informação'),(4,'form_LGPD_2087_ndas','Y','','','','Y','Y',NULL,'Fluxo de Informação'),(4,'form_LGPD_2097_assoc_med_atv',NULL,NULL,NULL,NULL,NULL,NULL,'Cadastro de Medidas Técnicas - > Cadastro da especificação da associação entre medida técnica e ativo','Painel'),(4,'form_LGPD_3500_checklist_risk_padrao','Y','','','','Y','Y','[Item de menu] - Riscos / Checklist padrão de identificação de riscos e atividades','Riscos'),(4,'form_LGPD_3600_chklst_risk_area_mestre','Y','','','','Y','Y','Formulário de checklist por área de identificação de riscos e atividades','Riscos'),(4,'form_LGPD_4000_atividades','Y','','','Y',NULL,NULL,'Cadastro de atividades de adequação','Formulário'),(4,'form_LGPD_4000_atividades_calendar',NULL,NULL,NULL,NULL,NULL,NULL,'Cadastro de atividades de adequação','Formulário'),(4,'form_minhas_obr_CMP_1610_ol_agenda',NULL,NULL,NULL,NULL,NULL,NULL,'Edição das minhas obrigações legais ','Painel'),(4,'form_new_pln_acao','Y','','','',NULL,NULL,'Cadastrar plano de ação','Formulário'),(4,'form_PAC_1100_sol_portal',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(4,'form_pcp_9100_LIA','Y','','','','Y','Y',NULL,'Fluxo de Informação'),(4,'form_public_LGPD_0100_diagnostico','','','','',NULL,NULL,'Parametrizar etapa de diagnóstico','Formulário'),(4,'form_public_LGPD_0200_implement','','','','',NULL,NULL,'Parametrizar etapa de implementação','Formulário'),(4,'form_public_LGPD_0300_operacao','','','','',NULL,NULL,'Parametrizar etapa de operação','Formulário'),(4,'form_public_LGPD_0400_etapas','','','','',NULL,NULL,'Parametrizar etapas','Formulário'),(4,'form_public_LGPD_1000_controlador','Y','','','',NULL,NULL,'Cadastro de controlador','Formulário'),(4,'form_public_LGPD_1001_diretoria','Y','Y','Y','Y',NULL,NULL,'Cadastro de diretoria','Formulário'),(4,'form_public_LGPD_1002_area','Y','Y','Y','Y',NULL,NULL,'Cadastro de área','Formulário'),(4,'form_public_LGPD_1003_departamento','Y','Y','Y','Y',NULL,NULL,'Cadastro de departamentos','Formulário'),(4,'form_public_LGPD_1004_cargos','Y','Y','Y','Y',NULL,NULL,'Cadastro de cargos','Formulário'),(4,'form_public_LGPD_1050_organograma','Y','Y','Y','Y',NULL,NULL,'Cadastro de organograma','Formulário'),(4,'form_public_LGPD_1051_comite','Y','Y','Y','Y',NULL,NULL,'Cadastro de comitê','Formulário'),(4,'form_public_LGPD_1053_eventos_comite','','','','',NULL,NULL,'Agenda de eventos do comitê','Formulário'),(4,'form_public_LGPD_1100_equipe','Y','Y','Y','Y',NULL,NULL,'Cadastro de equipe','Formulário'),(4,'form_public_LGPD_1100_equipe_1','Y','Y','Y','Y',NULL,NULL,'Cadastro de equipe','Formulário'),(4,'form_public_LGPD_2000_processos','Y','Y','Y','Y','Y','Y','Cadastro de processos','Formulário'),(4,'form_public_LGPD_2010_ativos','Y','Y','Y','Y',NULL,NULL,'Cadastro de ativos','Formulário'),(4,'form_public_LGPD_2020_artefatos','Y','Y','Y','Y',NULL,NULL,'Cadastro de artefatos','Formulário'),(4,'form_public_LGPD_2030_dados','Y','Y','Y','Y',NULL,NULL,'Cadastro de metadados','Formulário'),(4,'form_public_LGPD_2060_config_assoc',NULL,NULL,NULL,NULL,NULL,NULL,'Associação artefato x metadados','Formulário'),(4,'form_public_LGPD_2065_fund_legal','','','','',NULL,NULL,'Cadastro de fundamentos legais','Formulário'),(4,'form_public_LGPD_2066_ambiente_reg','','','','',NULL,NULL,'Cadastro de ambientes regulatórios','Formulário'),(4,'form_public_LGPD_2070_finalidades','Y','','','',NULL,NULL,'Parametrizar finalidades','Formulário'),(4,'form_public_LGPD_2070_registrar_finalidades','Y','','','',NULL,NULL,'Registrar finalidades','Formulário'),(4,'form_public_LGPD_2075_param_assoc_funcional_fin',NULL,NULL,NULL,NULL,NULL,NULL,'Associação funcional da finalidade','Formulário'),(4,'form_public_LGPD_2080_politicas','Y','','','',NULL,NULL,'Cadastro de políticas','Formulário'),(4,'form_public_LGPD_2085_contratos','','','','',NULL,NULL,'Cadastro de contratos','Formulário'),(4,'form_public_LGPD_2090_terceiros','','','','',NULL,NULL,'Cadastro de terceiros','Formulário'),(4,'form_public_LGPD_2093_ocorr_terc','','','','',NULL,NULL,'Cadastro de ocorrência de terceiros','Formulário'),(4,'form_public_LGPD_2095_med_tec','','','','',NULL,NULL,'Cadastro de medidas técnicas','Formulário'),(4,'form_public_LGPD_2097_config_assoc_med_atv',NULL,NULL,NULL,NULL,NULL,NULL,'Associar medidas técnicas aos ativos','Formulário'),(4,'form_public_LGPD_2100_prz_aprv_proc','Y','Y','Y','Y','Y','Y','[Item de menu] - Configurações / SLA de aprovação de Processos de Negócio: Acesso à configuração do prazo limite para aprovação de Processos de Negócio cadastrados','Formulário'),(4,'form_public_LGPD_3000_riscos','Y','Y','Y','Y',NULL,NULL,'Cadastro de riscos','Formulário'),(4,'form_public_LGPD_4000_atividades','Y','','','Y',NULL,NULL,'Cadastro de atividades','Formulário'),(4,'form_public_LGPD_5000_cod_etica','Y','','','',NULL,NULL,'Cadastro de código de ética','Formulário'),(4,'form_public_LGPD_5100_cod_conduta',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(4,'form_public_LGPD_6000_PDCA','','','','',NULL,NULL,'PDCA','Formulário'),(4,'form_public_LGPD_6100_catalog_treinamentos','Y','','','',NULL,NULL,'Cadastro de catalogo de treinamentos','Formulário'),(4,'form_public_LGPD_6200_agenda_treina','Y','','','',NULL,NULL,'Agenda de treinamentos','Formulário'),(4,'form_public_LGPD_7300_envio_aval_forne','','','','',NULL,NULL,'Cadastro de questionários (Due Diligence)','Formulário'),(4,'form_public_LGPD_assoc_contr_6500',NULL,NULL,NULL,NULL,NULL,NULL,'Associação de contratos','Formulário'),(4,'form_public_LGPD_assoc_medtec_6700',NULL,NULL,NULL,NULL,NULL,NULL,'Associação de medidas técnicas','Formulário'),(4,'form_public_LGPD_assoc_pdca_risk_6400',NULL,NULL,NULL,NULL,NULL,NULL,'Associação de riscos ao PDCA','Formulário'),(4,'form_public_LGPD_assoc_pol_6300',NULL,NULL,NULL,NULL,NULL,NULL,'Associação de políticas','Formulário'),(4,'form_public_LGPD_assoc_proc_6600',NULL,NULL,NULL,NULL,NULL,NULL,'Associação de processos','Formulário'),(4,'form_public_LGPD_assoc_treina_6500',NULL,NULL,NULL,NULL,NULL,NULL,'Associação de treinamentos','Formulário'),(4,'form_public_LGPD_config_det_opt_7200','','','','',NULL,NULL,'Parametrizar opções do questionário de fornecedores','Formulário'),(4,'form_public_PAC_1000_user_portal',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(4,'Governance_menu',NULL,NULL,NULL,NULL,NULL,NULL,'Menu',NULL),(4,'grid_CMP_0100_faixas',NULL,NULL,NULL,NULL,NULL,NULL,'Consultar faixas de setup de auditoria','Painel'),(4,'grid_CMP_1000_mecanismos','',NULL,NULL,NULL,NULL,NULL,'[Item de menu] - Pilares do Compliance / Mecanismos de Auditoria: Acesso ao cadastro de Mecanismos de Auditoria para projetos de Compliance','Pilares de Compliance'),(4,'grid_CMP_1100_componentes','',NULL,NULL,NULL,NULL,NULL,'[Item de menu] - Pilares do Compliance / Componentes de Auditoria: Acesso ao cadastro de Componentes de Auditoria, que compõem os Mecanismos cadastrados','Pilares de Compliance'),(4,'grid_CMP_1100_entrevistados_desassociados',NULL,NULL,NULL,NULL,NULL,NULL,'Consultas candidatos a entrevistas de ciclo de auditoria ','Painel'),(4,'grid_CMP_1200_questoes','',NULL,NULL,NULL,NULL,NULL,'[Item de menu] - Pilares do Compliance / Questões de Auditoria: Acesso ao cadastro de perguntas que são utilizadas para a realização de auditorias de Compliance','Pilares de Compliance'),(4,'grid_CMP_1300_formularios','',NULL,NULL,NULL,NULL,NULL,'[Item de menu] - Pilares do Compliance / Formulários de Auditoria: Acesso ao cadastro e configuração de Formulários compostos por perguntas para a realização de auditorias de Compliance','Pilares de Compliance'),(4,'grid_CMP_1310_formulario_det',NULL,NULL,NULL,NULL,NULL,NULL,'Consulta detalhes do formulário de auditoria ','Painel'),(4,'grid_CMP_1400_formulas_mestre','',NULL,NULL,NULL,NULL,NULL,'[Item de menu] - Pilares do Compliance / Parâmetros de Ciclos de Auditoria: Acesso à configuração de parâmetros quantitativos utilizados nos Ciclos de Auditoria de Compliance','Pilares de Compliance'),(4,'grid_CMP_1410_formulas_det_mec',NULL,NULL,NULL,NULL,NULL,NULL,'Sub Consulta mecanismos do setup de auditoria','Painel'),(4,'grid_CMP_1500_acao','',NULL,NULL,NULL,NULL,NULL,'[Item de menu] - Pilares do Compliance / Ações de Auditoria: Acesso ao cadastro de ações pré-determinadas para serem sugeridas a partir do levantamento de determinada Questão cadastrada','Pilares de Compliance'),(4,'grid_CMP_1550_ger_acao','',NULL,NULL,NULL,NULL,NULL,'[Item de menu] - Auditoria de Compliance / Recomendações de Auditoria: Acesso à geração automática de recomendações pós Ciclo de Auditoria de Compliance','Auditoria de Compliance'),(4,'grid_CMP_1600_OL','',NULL,NULL,NULL,NULL,NULL,'[Item de menu] - Aspectos Jurídicos / Obrigações Legais: Acesso ao cadastro das obrigações legais que a entidade deve atender em um determinado exercício','Aspectos Jurídicos'),(4,'grid_CMP_2000_ciclos','',NULL,NULL,NULL,NULL,NULL,'[Item de menu] - Auditoria de Compliance / Ciclos de Auditoria: Acesso à gestão de Ciclos de Auditoria de Compliance','Auditoria de Compliance'),(4,'grid_CMP_2500_conf_entrevistados','',NULL,NULL,NULL,NULL,NULL,'[Item de menu] - Auditoria de Compliance / Entrevistados: Acesso à seleção de entrevistados que estarão associados a um Ciclo de Auditoria de Compliance','Auditoria de Compliance'),(4,'grid_CMP_2510_entrevistados_associados',NULL,NULL,NULL,NULL,NULL,NULL,'Relação de entrevistados de um ciclo de auditoria','Painel'),(4,'grid_CMP_3000_aplic_pesq','',NULL,NULL,NULL,NULL,NULL,'[Item de menu] - Auditoria de Compliance / Pesquisas de Auditoria: Acesso à aplicação de Pesquisas de Auditoria de Compliance','Auditoria de Compliance'),(4,'grid_CMP_acompanhar_pesquisas',NULL,NULL,NULL,NULL,NULL,NULL,'Consulta acompanhamento do andamento de pesquisas de auditorias','Painel'),(4,'grid_CMP_resultado_pesquisa','',NULL,NULL,NULL,NULL,NULL,'[Item de menu] - Auditoria de Compliance / Resultados de Auditoria: Acesso à gestão do resultado de Pesquisas de Auditoria de Compliance','Auditoria de Compliance'),(4,'grid_CMP_resultado_pesquisa_questoes',NULL,NULL,NULL,NULL,NULL,NULL,'Consulta resultado da pesquisa de auditoria ','Painel'),(4,'grid_CMP_resultado_pesquisa_status_mecanismo',NULL,NULL,NULL,NULL,NULL,NULL,'Consulta resultado da pesquisa por mecanismos de auditoria ','Painel'),(4,'grid_conf_quest_7100',NULL,NULL,NULL,NULL,NULL,NULL,'Cofiguração de questionário para fornecedores','Painel'),(4,'grid_DOM_tp_ol_1600','',NULL,NULL,NULL,NULL,NULL,'[Item de menu] - Aspectos Jurídicos / Tipos de Obrigações Legais: Acesso ao cadastro de tipos de obrigações legais','Aspectos Jurídicos'),(4,'grid_kanban_atividades',NULL,NULL,NULL,NULL,NULL,NULL,'Kanban de  atividades','Painel'),(4,'grid_kanban_atividades_add_registro',NULL,NULL,NULL,NULL,NULL,NULL,'Kanban de  atividades','Painel'),(4,'grid_LGPD_2001_form_entr_prc','Y','','','','Y','Y',NULL,'Fluxo de Informação'),(4,'grid_LGPD_2003_envio_entr_prc','Y','','','','Y','Y',NULL,'Fluxo de Informação'),(4,'grid_LGPD_2040_assoc_prc_atv','Y','','','','Y','Y','[Item de menu] - Fluxo de Informação / Associações do Fluxo de Informação: Acesso à consulta das associações entre Processos de Negócio x Ativos de Informação x Artefatos x Metadados Pessoais','Fluxo de Informação'),(4,'grid_LGPD_2075_assoc_funcional_dados_fin',NULL,NULL,NULL,NULL,NULL,NULL,'Consulta associação de metadados','Painel'),(4,'grid_LGPD_2087_ndas','Y',NULL,NULL,NULL,'Y','Y',NULL,'Políticas e Regulamentos'),(4,'grid_LGPD_2097_assoc_med_atv','',NULL,NULL,NULL,NULL,NULL,'[Item de menu] - Medidas Técnicas de Segurança / Associações com Ativos de Informação: Acesso à configuração da associação entre Medidas Técnicas de Segurança e Ativos de Informação utilizados pela entidade','Medidas Técnicas de Segurança'),(4,'grid_LGPD_3100_assoc_risc_atv','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Riscos / Associações de Riscos: Acesso à associações entre Riscos e outras informações cadastradas','Riscos'),(4,'grid_LGPD_3600_chklst_risk_area_mestre','Y','','','','Y','Y','[Item de menu] - Riscos / Checklist por área de identificação de riscos e atividades','Riscos'),(4,'grid_LGPD_6300_aluno_treina',NULL,NULL,NULL,NULL,NULL,NULL,'Consulta de lista de treinamentos realizados por colaborador','Painel'),(4,'grid_LGPD_7400_resp_aval_forne',NULL,NULL,NULL,NULL,NULL,NULL,'Consulta respostas de questionários  (Due Diligence)','Painel'),(4,'grid_new_pln_acao','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Atividades e Ações / Plano de Ação LGPD: Acesso ao cadastro do documento \"Plano de Ação\" de adequação à LGPD','Atividades e Ações'),(4,'grid_public_LGPD_0100_diagnostico','',NULL,NULL,NULL,NULL,NULL,'[Item de menu] - Configurações / Projeto de Diagnóstico da LGPD: Acesso à configuração das informações sobre o projeto de Diagnóstico da LGPD','Configurações'),(4,'grid_public_LGPD_0200_implement','',NULL,NULL,NULL,NULL,NULL,'[Item de menu] - Configurações / Projeto de Adequação da LGPD: Acesso à configuração das informações sobre o projeto de Adequação da LGPD','Configurações'),(4,'grid_public_LGPD_0300_operacao','',NULL,NULL,NULL,NULL,NULL,'[Item de menu] - Configurações / Projeto de Operação da LGPD: Acesso à configuração das informações sobre a fase de Operação da LGPD','Configurações'),(4,'grid_public_LGPD_0400_etapas','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Configurações / Etapas do Diagnóstico da LGPD: Acesso à configuração das etapas do projeto de Diagnóstico de um projeto de adequação à LGPD','Configurações'),(4,'grid_public_LGPD_1000_controlador','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Configurações / Entidade: Acesso à configuração dos dados da entidade','Configurações'),(4,'grid_public_LGPD_1001_diretoria','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Estrutura Organizacional / Diretoria: Acesso ao cadastro de Diretorias, que é o nível mais alto da hierarquia organizacional da entidade','Estrutura Organizacional'),(4,'grid_public_LGPD_1002_area','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Estrutura Organizacional / Área: Acesso ao cadastro de Áreas, que dividem uma determinada Diretoria na estrutura hierárquica da entidade','Estrutura Organizacional'),(4,'grid_public_LGPD_1003_departamento','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Estrutura Organizacional / Departamentos: Acesso ao cadastro de Departamentos, que dividem uma determinada Área na estrutura hierárquica da entidade','Estrutura Organizacional'),(4,'grid_public_LGPD_1004_cargos','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Estrutura Organizacional / Cargos: Acesso ao cadastro de Cargos a serem ocupados por pessoas da equipe que ocupem espaço na estrutura hierárquica da entidade','Estrutura Organizacional'),(4,'grid_public_LGPD_1050_organograma','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Estrutura Organizacional / Lotação: Acesso ao cadastro de unidades de trabalho, onde é possível alocar as equipes da entidade','Estrutura Organizacional'),(4,'grid_public_LGPD_1051_comite','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Estrutura Organizacional / Comitês: Acesso ao cadastro de comitês da entidade, que congregam uma ou mais pessoas previamente cadastradas','Estrutura Organizacional'),(4,'grid_public_LGPD_1053_eventos_comite','',NULL,NULL,NULL,NULL,NULL,'[Item de menu] - Atividades e Ações / Eventos de Comitê: Acesso ao cadastro de eventos associados aos Comitês da entidade','Atividades e Ações'),(4,'grid_public_LGPD_1053_sub_eventos_comite',NULL,NULL,NULL,NULL,NULL,NULL,'Sub Consulta de Eventos','Painel'),(4,'grid_public_LGPD_1100_equipe','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Estrutura Organizacional / Equipe: Acesso ao cadastro de pessoas que podem ocupar cargos na estrutura hierárquica da entidade. Essas pessoas serão associadas a diversas outras entidades tratadas na plataforma','Estrutura Organizacional'),(4,'grid_public_LGPD_2000_proc_aprv_prz_expirado','Y','','','','Y','Y','[Item de menu] - Atividades e Ações / Processos de Negócio Pendentes: Acesso à gestão de Processos de Negócio com SLA de aprovação expirado','Atividades e Ações'),(4,'grid_public_LGPD_2000_processos','Y','','','','Y','Y','[Item de menu] - Fluxo de Informação / Processos de Negócio: Acesso ao cadastro de Processos de Negócio que definem as rotinas operacionais da entidade','Fluxo de Informação'),(4,'grid_public_LGPD_2000_sub_proc_pessoa','Y','','','','Y','Y','Consulta processo por responsável','Painel'),(4,'grid_public_LGPD_2000_sub_processos_atv','Y','','','','Y','Y','Consulta processos por ativos','Painel'),(4,'grid_public_LGPD_2010_ativos','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Fluxo de Informação / Ativos de Informação: Acesso ao cadastro de Ativos de Informação utilizados pela entidade na execução de seus Processos de Negócio','Fluxo de Informação'),(4,'grid_public_LGPD_2010_ativos_1',NULL,NULL,NULL,NULL,NULL,NULL,'Consulta Ativos','Painel'),(4,'grid_public_LGPD_2010_ativos_n_utlz_fin',NULL,NULL,NULL,NULL,NULL,NULL,'Processos disponivel para associação com finalidades','Painel'),(4,'grid_public_LGPD_2010_ativos_utlz_fin',NULL,NULL,NULL,NULL,NULL,NULL,'Processos associados a finalidade','Painel'),(4,'grid_public_LGPD_2010_sub_ativos',NULL,NULL,NULL,NULL,NULL,NULL,'Sub Consulta de Ativos','Painel'),(4,'grid_public_LGPD_2020_artefatos','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Fluxo de Informação / Artefatos: Acesso ao cadastro de Artefatos e Documentos tratados nos Ativos de Informação utilizados pela entidade','Fluxo de Informação'),(4,'grid_public_LGPD_2020_artefatos_n_utlz_fin',NULL,NULL,NULL,NULL,NULL,NULL,'Artefatos disponiveis para associação com finalidades','Painel'),(4,'grid_public_LGPD_2020_artefatos_utlz_fin',NULL,NULL,NULL,NULL,NULL,NULL,'Artefatos associados a finalidades','Painel'),(4,'grid_public_LGPD_2030_assoc_art_metadados',NULL,NULL,NULL,NULL,NULL,NULL,'Associação de Artefatos e metadados','Painel'),(4,'grid_public_LGPD_2030_dados','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Fluxo de Informação / Metadados Pessoais: Acesso ao cadastro de Metadados Pessoais presentes nos diferentes Artefatos utilizados pela entidade','Fluxo de Informação'),(4,'grid_public_LGPD_2065_fund_legal','',NULL,NULL,NULL,NULL,NULL,'[Item de menu] - Aspectos Jurídicos / Fundamentos Legais: Acesso ao cadastro de Fundamentos Legais utilizados pela entidade','Aspectos Jurídicos'),(4,'grid_public_LGPD_2066_ambiente_reg','',NULL,NULL,NULL,NULL,NULL,'[Item de menu] - Aspectos Jurídicos / Ambientes regulatórios: Acesso ao cadastro de Ambientes Regulatórios a serem associados a Fundamentos Legais utilizados pela entidade','Aspectos Jurídicos'),(4,'grid_public_LGPD_2070_finalidades','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Tratamento de Dados Pessoais / Parametrizar Finalidades de Tratamentos: Acesso à configuração dos aspectos e detalhes das Finalidades de Tratamento de Dados Pessoais previamente cadastradas','Tratamento de Dados Pessoais'),(4,'grid_public_LGPD_2070_registrar_finalidades','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Tratamento de Dados Pessoais / Registrar Finalidade de Tratamento: Acesso ao cadastro de Finalidades de Tratamento de Dados Pessoais executadas pela entidade','Tratamento de Dados Pessoais'),(4,'grid_public_LGPD_2070_sub_contratos_finalidades',NULL,NULL,NULL,NULL,NULL,NULL,'Sub consulta de contratos dentro da finalidade','Painel'),(4,'grid_public_LGPD_2070_sub_finalidades',NULL,NULL,NULL,NULL,NULL,NULL,'Sub consulta de finalidades','Painel'),(4,'grid_public_LGPD_2073_assoc_ativos_fin',NULL,NULL,NULL,NULL,NULL,NULL,'Associação de ativos na finalidade','Painel'),(4,'grid_public_LGPD_2075_assoc_metadados_fin',NULL,NULL,NULL,NULL,NULL,NULL,'Associação de metadados na finalidade','Painel'),(4,'grid_public_LGPD_2080_politicas','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Políticas e Regulamentos / Políticas: Acesso ao cadastro de políticas associadas à Governança de Privacidade da entidade','Políticas e Regulamentos'),(4,'grid_public_LGPD_2085_contratos','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Políticas e Regulamentos / Contratos: Acesso ao cadastro de contratos e modelos de contratos utilizados pela entidade','Políticas e Regulamentos'),(4,'grid_public_LGPD_2090_terceiros','',NULL,NULL,NULL,NULL,NULL,'[Item de menu] - Gestão de terceiros / Terceiros: Acesso ao cadastro de entidades terceiras (PJ ou PF) associadas à entidade','Gestão de Terceiros'),(4,'grid_public_LGPD_2093_ocorr_terc','',NULL,NULL,NULL,NULL,NULL,'[Item de menu] - Gestão de terceiros / Ocorrências: Acesso ao cadastro de ocorrências relacionadas à Terceiros associados à entidade','Gestão de Terceiros'),(4,'grid_public_LGPD_2095_med_tec','',NULL,NULL,NULL,NULL,NULL,'[Item de menu] - Medidas Técnicas de Segurança / Medidas Técnicas de Segurança: Acesso ao cadastro de Medidas Técnicas de Segurança da Informação que podem ser associadas a Ativos cadastrados','Medidas Técnicas de Segurança'),(4,'grid_public_LGPD_2095_sub_med_tec',NULL,NULL,NULL,NULL,NULL,NULL,'Sub Consulta de medidas técnicas','Painel'),(4,'grid_public_LGPD_3000_riscos','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Riscos / Riscos: Acesso ao cadastro de Riscos de Privacidade e Compliance','Riscos'),(4,'grid_public_LGPD_3000_sub_consulta_riscos',NULL,NULL,NULL,NULL,NULL,NULL,'Sub consulta de riscos','Painel'),(4,'grid_public_LGPD_3300_assoc_risc_prc',NULL,NULL,NULL,NULL,NULL,NULL,'Associar risco a processos','Painel'),(4,'grid_public_LGPD_4000_atividades','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Atividades e Ações / Atividades e Ações: Acesso ao cadastro de atividades e ações de governança e compliance','Atividades e Ações'),(4,'grid_public_LGPD_5000_cod_etica','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Políticas e Regulamentos / Códigos e Regulamentos Internos: Acesso ao cadastro de documentos que definem as regras internas de Compliance da entidade','Políticas e Regulamentos'),(4,'grid_public_LGPD_5100_cod_conduta',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(4,'grid_public_LGPD_6000_PDCA','',NULL,NULL,NULL,NULL,NULL,'[Item de menu] - Atividades e Ações / Gestão de ciclo de PDCA de Compliance: Acesso ao planejamento e gestão de ciclos de PDCA de Compliance','Atividades e Ações'),(4,'grid_public_LGPD_6000_SUB_PDCA',NULL,NULL,NULL,NULL,NULL,NULL,'Sub consulta PDCA','Painel'),(4,'grid_public_LGPD_6100_catalog_treinamentos','',NULL,NULL,NULL,NULL,NULL,'[Item de menu] - Atividades e Ações / Catálogo de treinamentos: Acesso ao cadastro dos tipos de treinamentos que a entidade pode executar para suas equipes','Atividades e Ações'),(4,'grid_public_LGPD_6200_agenda_treina','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Atividades e Ações / Agenda de Treinamentos: Acesso à gestão de agenda de treinamentos e capacitações internas da entidade','Atividades e Ações'),(4,'grid_public_LGPD_7300_envio_aval_forne',NULL,NULL,NULL,NULL,NULL,NULL,'Consulta de questionários (Due Diligence)','Painel'),(4,'grid_public_LGPD_7300_envio_aval_forne_gerencial','',NULL,NULL,NULL,NULL,NULL,NULL,'Gestão de Terceiros'),(4,'grid_public_LGPD_cons_rev_contr_6500',NULL,NULL,NULL,NULL,NULL,NULL,'Consulta revisões de contrato','Painel'),(4,'grid_public_LGPD_cons_rev_medtec_6700',NULL,NULL,NULL,NULL,NULL,NULL,'Consulta revisões de medidas técnicas','Painel'),(4,'grid_public_LGPD_cons_rev_pol_6300',NULL,NULL,NULL,NULL,NULL,NULL,'Consulta revisão de políticas','Painel'),(4,'grid_public_LGPD_cons_rev_proc_6600',NULL,NULL,NULL,NULL,NULL,NULL,'Consulta revisão de processos','Painel'),(4,'grid_public_LGPD_cons_rev_risk_6400',NULL,NULL,NULL,NULL,NULL,NULL,'Consulta revisão de riscos','Painel'),(4,'grid_public_PAC_9000_DPIA',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(4,'grid_public_PAC_9100_LIA',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(4,'grid_public_PCP_9000_DPIA',NULL,NULL,NULL,NULL,NULL,NULL,'Consulta DPIA',NULL),(4,'grid_public_pcp_9100_LIA',NULL,NULL,NULL,NULL,NULL,NULL,'Consulta LIA ',NULL),(4,'grid_public_subconsulta_sec_users',NULL,NULL,NULL,NULL,NULL,NULL,'Sub consulta de usuarios','Painel'),(4,'grid_sc_log','',NULL,NULL,NULL,NULL,NULL,'[Item de menu] - Segurança / Histórico de acessos: Acesso à consulta à histórico de acessos de usuários à plataforma','Segurança'),(4,'help_cadastro_titulares',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(4,'help_ciclo_de_vida',NULL,NULL,NULL,NULL,NULL,NULL,'Help Ciclo de vida','Painel'),(4,'help_finalidades_fundamentos',NULL,NULL,NULL,NULL,NULL,NULL,'Help Finalidades','Painel'),(4,'help_geracao_atividades',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(4,'help_geracao_riscos',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(4,'help_gestao_consentimentos',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(4,'help_gestao_incidentes',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(4,'help_gestao_notificacao',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(4,'help_integracao_portais',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(4,'help_lotes_validacao',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(4,'help_medidas_administrativas',NULL,NULL,NULL,NULL,NULL,NULL,'Help medidas administrativas','Painel'),(4,'help_medidas_tecnicas',NULL,NULL,NULL,NULL,NULL,NULL,'Help para medidas técnicas','Painel'),(4,'help_plano_acao_atividades',NULL,NULL,NULL,NULL,NULL,NULL,'Help Atividades','Painel'),(4,'help_relatorios',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(4,'help_riscos_e_impactos',NULL,NULL,NULL,NULL,NULL,NULL,'Help Riscos','Painel'),(4,'homepage',NULL,NULL,NULL,NULL,NULL,NULL,'Home Page (Responsábilidades e Atividades)','Painel'),(4,'homepage_help',NULL,NULL,NULL,NULL,NULL,NULL,'Help','Painel'),(4,'mapa_calor_risco',NULL,NULL,NULL,NULL,NULL,NULL,'Mapa de risco','Painel'),(4,'Mapa_Calor_Riscos',NULL,NULL,NULL,NULL,NULL,NULL,'Mapa de calor de riscos ','Painel'),(4,'menu',NULL,NULL,NULL,NULL,NULL,NULL,'Menu PCP','Painel'),(4,'menu_dinamico',NULL,NULL,NULL,NULL,NULL,NULL,'Menu','Painel'),(4,'Menu_Pac',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(4,'Metadados','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Painel / Metadados Pessoais: Acesso à exibição dos principais indicadores sobre Metadados Pessoais','Painel'),(4,'novo_menu',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(4,'pac_app_change_pswd','Y','','','','','','[Item de menu] - SeguranÃ§a / AlteraÃ§Ã£o de senha: Acesso Ã  gestÃ£o de senhas de usuÃ¡rios da plataforma','SeguranÃ§a'),(4,'pac_app_form_sec_groups_apps','',NULL,NULL,NULL,NULL,NULL,'[Item de menu] - SeguranÃ§a / AssociaÃ§Ã£o de perfis a aplicaÃ§Ãµes: Acesso Ã  configuraÃ§Ã£o da associaÃ§Ã£o de perfis de acesso com as aplicaÃ§Ãµes da plataforma','SeguranÃ§a'),(4,'pac_app_grid_sec_apps','',NULL,NULL,NULL,NULL,NULL,'[Item de menu] - SeguranÃ§a / AplicaÃ§Ãµes: Acesso ao cadastro de aplicaÃ§Ãµes da plataforma','SeguranÃ§a'),(4,'pac_app_grid_sec_groups','',NULL,NULL,NULL,NULL,NULL,'[Item de menu] - SeguranÃ§a / Perfis: Acesso ao cadastro de perfis de acesso dos usuÃ¡rios da plataforma','SeguranÃ§a'),(4,'pac_app_grid_sec_users','',NULL,NULL,NULL,NULL,NULL,'[Item de menu] - SeguranÃ§a / UsuÃ¡rios: Acesso ao cadastro de usuÃ¡rios da plataforma','SeguranÃ§a'),(4,'pac_app_grid_sec_users_groups','',NULL,NULL,NULL,NULL,NULL,'[Item de menu] - SeguranÃ§a / AssociaÃ§Ã£o de usuÃ¡rios a perfis: Acesso Ã  configuraÃ§Ã£o da associaÃ§Ã£o de usuÃ¡rios a perfis de acesso','SeguranÃ§a'),(4,'pac_app_search_sec_groups','',NULL,NULL,NULL,NULL,NULL,'[Item de menu] - SeguranÃ§a / AssociaÃ§Ã£o de perfis a aplicaÃ§Ãµes: Acesso Ã  configuraÃ§Ã£o da associaÃ§Ã£o de perfis de acesso com as aplicaÃ§Ãµes da plataforma','SeguranÃ§a'),(4,'pac_menu',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(4,'PAG_menu',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(4,'param_aval_mestre_7000','',NULL,NULL,NULL,NULL,NULL,'[Item de menu] - Gestão de terceiros / Formulários de due diligence: Acesso à criação de formulários (e suas questões) para auto avaliação de terceiros','Gestão de Terceiros'),(4,'PDCA','',NULL,NULL,NULL,NULL,NULL,'[Item de menu] - Painel / Ciclos de PDCA: Acesso à exibição dos principais indicadores sobre Ciclos de PDCA de Compliance','Painel'),(4,'pdfreport_LGPD_7300_envio_aval_forne',NULL,NULL,NULL,NULL,NULL,NULL,'geração de PDF - questionário (Due Diligence)','Painel'),(4,'popup_confirm_action',NULL,NULL,NULL,NULL,NULL,NULL,'Pop-up ( não se aplica ao módulo de segirança)','Painel'),(4,'popup_confirm_action_status',NULL,NULL,NULL,NULL,NULL,NULL,'Pop_Up ( Não se plaica ao módulo de segurança ) ','Painel'),(4,'Processos','Y','','','','Y','Y','[Item de menu] - Painel / Processos de Negócio: Acesso à exibição dos principais indicadores sobre Processos de Negócio','Painel'),(4,'relatorio_ciclos_complience',NULL,NULL,NULL,NULL,NULL,NULL,'Extrato de cilco de auditoria ','Painel'),(4,'relatorio_dpia',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(4,'relatorio_dpia_1',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(4,'relatorio_finalidades',NULL,NULL,NULL,NULL,NULL,NULL,'Relatório de finalidades','Painel'),(4,'relatorio_lia',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(4,'relatorio_notificacao',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(4,'relatorio_resp_aval',NULL,NULL,NULL,NULL,NULL,NULL,'Relatório Avaliações','Painel'),(4,'resumo_finalidade',NULL,NULL,NULL,NULL,NULL,NULL,'Resumo de finalidade','Painel'),(4,'Riscos','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Painel / Riscos: Acesso à exibição dos principais indicadores sobre Gestão de Riscos de Privacidade e Compliance','Painel'),(4,'risk_heat_map','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Riscos / Mapa de Calor: Acesso à exibição do Mapa de Calor dos Riscos cadastrados','Riscos'),(4,'search_public_LGPD_4000_atividades',NULL,NULL,NULL,NULL,NULL,NULL,'Filtro de atividades','Painel'),(4,'sec_change_pswd',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(4,'sec_form_add_users',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(4,'sec_form_edit_users',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(4,'sec_form_sec_apps',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(4,'sec_form_sec_groups',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(4,'sec_form_sec_groups_apps',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(4,'sec_grid_sec_apps',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(4,'sec_grid_sec_groups',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(4,'sec_grid_sec_users',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(4,'sec_grid_sec_users_groups',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(4,'sec_Login',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(4,'sec_menu',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(4,'sec_retrieve_pswd',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(4,'sec_search_sec_groups',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(4,'sec_settings',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(4,'sec_sync_apps',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(4,'sub_consulta_3000_riscos_incidente',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(4,'sub_consulta_3100_assoc_risc_atv',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(4,'sub_consulta_3300_assoc_risc_prc',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(4,'sub_consulta_3400_assoc_risc_fin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(4,'sub_consulta_CMP_1610_ol_agenda',NULL,NULL,NULL,NULL,NULL,NULL,'Sub consulta de agenda de obrigações legais por obrigação','Painel'),(4,'sub_consulta_CMP_2510_det_conf_entrevistados',NULL,NULL,NULL,NULL,NULL,NULL,'Entrevitados em presquisa de auditoria --> Sub Consulta de configuração de entrevidados de pesquisa de auditoria ','Painel'),(4,'sub_consulta_CMP_3000_aplic',NULL,NULL,NULL,NULL,NULL,NULL,'Sub consulta status da aplicação de pesquisa de auditoria','Painel'),(4,'sub_consulta_CMP_4000_respostas_mestre',NULL,NULL,NULL,NULL,NULL,NULL,'Sub consulta status de respostas dos formulários de auditoria dentro de um ciclo ','Painel'),(4,'sub_consulta_configurar_metadados',NULL,NULL,NULL,NULL,NULL,NULL,'Sub consulta configuração de metadados','Painel'),(4,'sub_consulta_LGPD_2097_assoc_med_atv',NULL,NULL,NULL,NULL,NULL,NULL,'Sub consulta de associação entre medidas técnicas e ativos','Painel'),(4,'sub_consulta_LGPD_6200_agenda_treina',NULL,NULL,NULL,NULL,NULL,NULL,'Sub consulta de agenda de treinamentos ','Painel'),(4,'sub_consulta_PAC_1100_sol_portal',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(4,'sub_consulta_PAC_3200_tit_consent',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(4,'sub_consulta_PAC_4000_notificacao',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(4,'sub_consulta_PAG_ocorr_lote_1100',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(4,'sub_form_configurar_metados',NULL,NULL,NULL,NULL,NULL,NULL,'Configurar metadados','Painel'),(4,'sub_grid_CMP_1550_ger_acao',NULL,NULL,NULL,NULL,NULL,NULL,'Sub grid de recomendaçoes de auditoria por ciclo','Painel'),(4,'sub_grid_LGPD_2050_assoc_atv_art',NULL,NULL,NULL,NULL,NULL,NULL,'Sub consulta de associação entre ativos e artefatos',NULL),(4,'sub_grid_PAC_1400_tit_afet_inc',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(4,'sub_grid_public_LGPD_2093_ocorr_terc',NULL,NULL,NULL,NULL,NULL,NULL,'Sub consulta ocorrência de terceiros','Painel'),(5,'app_change_pswd','',NULL,NULL,NULL,NULL,NULL,'[Item de menu] - Segurança / Alteração de senha: Acesso à gestão de senhas de usuários da plataforma','Segurança'),(5,'app_form_add_users','','','','',NULL,NULL,'Cadastrar usuários','Formulário'),(5,'app_form_edit_users','','','','',NULL,NULL,'Alterar usuários','Formulário'),(5,'app_form_sec_apps','','','','',NULL,NULL,'Cadastrar aplicações','Formulário'),(5,'app_form_sec_groups','','','','',NULL,NULL,'Cadastro de grupos de usuários','Formulário'),(5,'app_form_sec_groups_apps','','','','',NULL,NULL,'Associar grupos x aplicações','Painel'),(5,'app_grid_sec_apps','',NULL,NULL,NULL,NULL,NULL,'[Item de menu] - Segurança / Aplicações: Acesso ao cadastro de aplicações da plataforma','Segurança'),(5,'app_grid_sec_groups','',NULL,NULL,NULL,NULL,NULL,'[Item de menu] - Segurança / Perfis: Acesso ao cadastro de perfis de acesso dos usuários da plataforma','Segurança'),(5,'app_grid_sec_users','',NULL,NULL,NULL,NULL,NULL,'[Item de menu] - Segurança / Usuários: Acesso ao cadastro de usuários da plataforma','Segurança'),(5,'app_grid_sec_users_groups','',NULL,NULL,NULL,NULL,NULL,'[Item de menu] - Segurança / Associação de usuários a perfis: Acesso à configuração da associação de usuários a perfis de acesso','Segurança'),(5,'app_Login',NULL,NULL,NULL,NULL,NULL,NULL,'Login',NULL),(5,'app_menu',NULL,NULL,NULL,NULL,NULL,NULL,'Menu','Painel'),(5,'app_retrieve_pswd',NULL,NULL,NULL,NULL,NULL,NULL,'Esqueceu a senha','Painel'),(5,'app_search_sec_groups','',NULL,NULL,NULL,NULL,NULL,'[Item de menu] - Segurança / Associação de perfis a aplicações: Acesso à configuração da associação de perfis de acesso com as aplicações da plataforma','Segurança'),(5,'app_settings','',NULL,NULL,NULL,NULL,NULL,'Configurações de segurança','Segurança'),(5,'app_sync_apps','',NULL,NULL,NULL,NULL,NULL,'Sincronização de aplicações','Segurança'),(5,'Artefatos','',NULL,NULL,NULL,NULL,NULL,'[Item de menu] - Painel / Artefatos: Acesso à exibição dos principais indicadores sobre Artefatos e Documentos','Painel'),(5,'associar_metadados_finalidade',NULL,NULL,NULL,NULL,NULL,NULL,'Associar metadados na finalidade','Painel'),(5,'associar_metadados_finalidade_new',NULL,NULL,NULL,NULL,NULL,NULL,'Associar metadados a finalidades','Painel'),(5,'Atividades','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Painel / Atividades e Ações: Acesso à exibição dos principais indicadores sobre Atividades e Ações','Painel'),(5,'Ativos','',NULL,NULL,NULL,NULL,NULL,'[Item de menu] - Painel / Ativos de Informação: Acesso à exibição dos principais indicadores sobre Ativos de Informação','Painel'),(5,'Auto_cadastro_PAC_4000_notificacao',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(5,'blank_email',NULL,NULL,NULL,NULL,NULL,NULL,'Enviar mail','Painel'),(5,'blank_pipeline','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Atividades e Ações / Meu Quadro de Atividades: Acesso ao Kanban de atividades do usuário logado','Atividades e Ações'),(5,'blank_pipeline_Ajax',NULL,NULL,NULL,NULL,NULL,NULL,'Pipeline de atividades','Painel'),(5,'cad_sol_dpia_pcp_9000','Y',NULL,NULL,NULL,'Y','Y',NULL,'Fluxo de Informação'),(5,'Cadastro_DEN_1000_registro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(5,'Cadastro_DEN_1100_cat',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(5,'cadastro_PAC_1110_atv_sol',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(5,'cadastro_PAC_1200_sla_sol_portal',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(5,'Cadastro_PAC_1400_titulares',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(5,'Cadastro_PAC_1410_dados_tit',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(5,'Cadastro_PAC_2000_incidentes',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(5,'Cadastro_PAC_2100_sla_notificacao',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(5,'Cadastro_PAC_3100_env_consent',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(5,'Cadastro_PAC_4000_notificacao',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(5,'Cadastro_PAG_lote_1000',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(5,'cadastro_PAG_ocorr_lote_1100',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(5,'calendar_app',NULL,NULL,NULL,NULL,NULL,NULL,'Calendário','Painel'),(5,'calendar_public_LGPD_4000_atividades',NULL,NULL,NULL,NULL,NULL,NULL,'Calendário de atividades ( DPO )','Painel'),(5,'chart_public_LGPD_2000_processos_complex',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico processo por complexidade','Painel'),(5,'chart_public_LGPD_2000_processos_geral',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico processos','Painel'),(5,'chart_public_LGPD_2000_processos_resp',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico processos por responsável','Painel'),(5,'chart_public_LGPD_2000_status_processos',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico processo por status','Painel'),(5,'chart_public_LGPD_2000_tipo_processo',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico processos por tipo','Painel'),(5,'chart_public_LGPD_2010_confia_ativos',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico confibilidade dos ativos','Painel'),(5,'chart_public_LGPD_2010_disp_ativos',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico ativos por nível de disponibilidade','Painel'),(5,'chart_public_LGPD_2010_integridade_ativos',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico ativos por nível de integridade','Painel'),(5,'chart_public_LGPD_2010_resp_ativos',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico ativos por responsável','Painel'),(5,'chart_public_LGPD_2010_tipo_ativos',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico tipos de ativos','Painel'),(5,'chart_public_LGPD_2020_artefat_contrato',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico artefatos tipo contrato','Painel'),(5,'chart_public_LGPD_2020_contrato_artefatos',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico contratos x artefatos','Painel'),(5,'chart_public_LGPD_2020_tipo_artefatos',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico artefatos por tipo','Painel'),(5,'chart_public_LGPD_2030_classif_dados',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico classificação de metadados','Painel'),(5,'chart_public_LGPD_2030_dados_anonimizavel',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico metadados anonimizavel','Painel'),(5,'chart_public_LGPD_2030_tipif_dados',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico tipos de dados','Painel'),(5,'chart_public_LGPD_2070_fin_compart_dados',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico finalidades por compartilhamento','Painel'),(5,'chart_public_LGPD_2070_fin_dad_criancas',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico finalidades por dados de crianças','Painel'),(5,'chart_public_LGPD_2070_fin_faz_descarte',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico finalidades por descarte','Painel'),(5,'chart_public_LGPD_2070_fin_frequencia',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico finalidades por ferequencia','Painel'),(5,'chart_public_LGPD_2070_fin_hipoteses',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico finalidades por hipóteses de tratamento','Painel'),(5,'chart_public_LGPD_2070_fin_papel',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico papel da entidade','Painel'),(5,'chart_public_LGPD_2070_fin_processos',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico finalidades por processos','Painel'),(5,'chart_public_LGPD_2070_fin_rot_automatizada',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico finalidades por rotinas automatizadas','Painel'),(5,'chart_public_LGPD_2070_fin_utlz_operador',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico finalidades por utiliza operador','Painel'),(5,'chart_public_LGPD_2070_fin_volumetria',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico finliadades por volumetria','Painel'),(5,'chart_public_LGPD_3000_categoria_riscos',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico riscos por categoria','Painel'),(5,'chart_public_LGPD_3000_criticidade_riscos',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico riscos por criticidade','Painel'),(5,'chart_public_LGPD_3000_estrategia_riscos',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico riscos por estratégia','Painel'),(5,'chart_public_LGPD_3000_impacto_riscos',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico riscos por impacto','Painel'),(5,'chart_public_LGPD_3000_prob_riscos',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico riscos por probabilidade','Painel'),(5,'chart_public_LGPD_3000_resp_riscos',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico riscos por responsáveis','Painel'),(5,'chart_public_LGPD_3000_status_riscos',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico riscos por status','Painel'),(5,'chart_public_LGPD_4000_atividades_geral',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico atividades','Painel'),(5,'chart_public_LGPD_4000_disc_atividades',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico atividades por disciplina','Painel'),(5,'chart_public_LGPD_4000_etapa_atividades',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico atividades por etapas','Painel'),(5,'chart_public_LGPD_4000_resp_atividades',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico atividades por responsável','Painel'),(5,'chart_public_LGPD_4000_status_resp_atividade',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico atividades por responsável e status','Painel'),(5,'chart_public_LGPD_assoc_pdca_contr_6500',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico PDCA de contratos','Painel'),(5,'chart_public_LGPD_assoc_pdca_finalizados_treina_6500',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico PDCA de treinamentos','Painel'),(5,'chart_public_LGPD_assoc_pdca_medtec_6700',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico PDCA de medidas técnicas','Painel'),(5,'chart_public_LGPD_assoc_pdca_pol_6300',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico PDCA de políticas','Painel'),(5,'chart_public_LGPD_assoc_pdca_proc_6600',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico PDCA de processos','Painel'),(5,'chart_public_LGPD_assoc_pdca_realizar_treina_6500',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico PDCA realização de treinamentos','Painel'),(5,'chart_public_LGPD_assoc_pdca_risk_6400',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico PDCA de riscos','Painel'),(5,'cons_dad_nao_utlz_LGPD_2030_dados','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Fluxo de Informação / Metadados Pessoais não utilizados: Acesso à consulta dos Metadados Pessoais cadastrados mas não utilizados em nenhuma associação','Fluxo de Informação'),(5,'cons_minhas_obr_CMP_1610_ol_agenda','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Aspectos Jurídicos / Minhas Obrigações Legais: Acesso ao cadastro das obrigações legais da entidade que estão sob a responsabilidade do usuário logado','Aspectos Jurídicos'),(5,'Consulta_DEN_1000_registro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(5,'Consulta_DEN_1100_cat',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(5,'consulta_gerencial_CMP_1610_ol_agenda','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Aspectos Jurídicos / Acompanhamento de Obrigações Legais: Acesso ao painel de acompanhamento do status das obrigações legais da entidade','Aspectos Jurídicos'),(5,'consulta_gerencial_LGPD_4000_atividades','',NULL,NULL,NULL,NULL,NULL,'[Item de menu] - Atividades e Ações / Acompanhamento de Atividades e Ações: Acesso ao painel de acompanhamento do status das obrigações legais da entidade','Atividades e Ações'),(5,'Consulta_LGPD_3000_riscos_assistant',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(5,'Consulta_LGPD_4000_atividades_assistant',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(5,'Consulta_PAC_1000_user_portal',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(5,'Consulta_PAC_1100_sol_portal',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(5,'consulta_PAC_1200_sla_sol_portal',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(5,'Consulta_PAC_1400_titulares',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(5,'Consulta_PAC_1410_dados_tit',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(5,'Consulta_PAC_2000_incidentes',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(5,'Consulta_PAC_3100_env_consent',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(5,'Consulta_PAC_4000_notificacao',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(5,'Consulta_PAG_lote_1000',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(5,'Consulta_public_LGPD_3000_riscos',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(5,'control_calendar',NULL,NULL,NULL,NULL,NULL,NULL,'Meu calendário de atividades de adequação',NULL),(5,'control_login',NULL,NULL,NULL,NULL,NULL,NULL,'Login','Painel'),(5,'control_login_diligence',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(5,'esqueci_senha',NULL,NULL,NULL,NULL,NULL,NULL,'Esqueceu a senha','Painel'),(5,'extrato_pdca',NULL,NULL,NULL,NULL,NULL,NULL,'Extrato PDCA','Painel'),(5,'Finalidades','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Painel / Finalidades de Tratamento de Dados Pessoais: Acesso à exibição dos principais indicadores sobre Finalidades de Tratamento de Dados Pessoais','Painel'),(5,'form_aval_7000','Y',NULL,NULL,NULL,'Y','Y','Formulários de due diligence: Acesso à criação de formulários (e suas questões) para auto avaliação de terceiros','Gestão de Terceiros'),(5,'form_CMP_1000_mecanismos','Y','','','',NULL,NULL,'Cadastro de mecanismos de auditoria ','Formulário'),(5,'form_CMP_1100_componentes','Y','','','',NULL,NULL,'Cadastro de componentes de auditoria','Formulário'),(5,'form_CMP_1200_questoes','Y','','','',NULL,NULL,'Cadastro de questões de auditoria','Formulário'),(5,'form_CMP_1300_formularios','Y','','','',NULL,NULL,'Cadatro de formulários de auditoria ','Formulário'),(5,'form_CMP_1300_formularios_edit','Y','','','',NULL,NULL,'Edição de formulários de auditoria','Formulário'),(5,'form_CMP_1400_formulas_mestre','Y','','','',NULL,NULL,'Parametrização de Setup de Auditoria','Formulário'),(5,'form_CMP_1400_formulas_view','Y','','','',NULL,NULL,'Visualizar setup de auditoria','Formulário'),(5,'form_CMP_1410_formulas_det_mec','Y','','','',NULL,NULL,'Parametrizar mecanismos de auditoria no setup','Formulário'),(5,'form_CMP_1420_formulas_det_niv_ad','Y','','','',NULL,NULL,'Parametrizar níveis de aderência do setup de auditoria ','Formulário'),(5,'form_CMP_1430_formulas_det_lim','Y','','','',NULL,NULL,'Parametrizar faixas do setup de auditoria','Formulário'),(5,'form_CMP_1500_acao','Y','','','',NULL,NULL,'Recomendações de auditorias','Formulário'),(5,'form_CMP_1600_OL','Y','Y','Y','Y',NULL,NULL,'Cadastro de Obrigações Legais ','Formulário'),(5,'form_CMP_2000_ciclos','Y','','','',NULL,NULL,'Cadastro de ciclos de auditoria','Formulário'),(5,'form_CMP_2500_conf_entrevistados','Y','','','',NULL,NULL,'Cadastro de entrevistados do ciclo de auditoria ','Formulário'),(5,'form_CMP_2500_conf_entrevistados_1','Y','','','',NULL,NULL,'Cadastro de entrevistados ','Formulário'),(5,'form_CMP_2500_conf_param_entrevistados','Y','','','',NULL,NULL,'Parametrizar relação de entrevistados de um ciclo de auditoria','Formulário'),(5,'form_CMP_3000_aplic_pesq','Y','','','',NULL,NULL,'Cadastro de aplicação de pesquisa de auditorias ','Formulário'),(5,'form_CMP_resultados_pesquisas','Y','','','',NULL,NULL,'Cadastro de resultado de pesquisas de auditoria','Formulário'),(5,'form_conf_quest_7100','Y','Y','Y','Y',NULL,NULL,'Configurar questionário de fornecedores','Formulário'),(5,'form_diligence',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(5,'form_DOM_tp_ol_1600','Y','Y','Y','Y',NULL,NULL,'Cadastro de tipos de obrigações ','Formulário'),(5,'form_kanban_atividades','Y','','','Y',NULL,NULL,'Kanban de  atividades','Formulário'),(5,'form_kanban_atividades_add_registro','Y','','','Y',NULL,NULL,'Cadastrar atividades pelo kanban','Formulário'),(5,'form_LGPD_0002_conf_smpt','',NULL,NULL,NULL,NULL,NULL,'[Item de menu] - Configurações / Configuração de envio de e-mails: Acesso à configuração do endereço de de SMTP para envio de e-mails da plataforma','Formulário'),(5,'form_LGPD_2001_form_entr_prc','Y',NULL,NULL,NULL,'Y','Y',NULL,'Fluxo de Informação'),(5,'form_LGPD_2003_envio_entr_prc','Y',NULL,NULL,NULL,'Y','Y',NULL,'Fluxo de Informação'),(5,'form_LGPD_2087_ndas','Y',NULL,NULL,NULL,'Y','Y',NULL,'Fluxo de Informação'),(5,'form_LGPD_2097_assoc_med_atv',NULL,NULL,NULL,NULL,NULL,NULL,'Cadastro de Medidas Técnicas - > Cadastro da especificação da associação entre medida técnica e ativo','Painel'),(5,'form_LGPD_3500_checklist_risk_padrao','Y','','','','Y','Y','[Item de menu] - Riscos / Checklist padrão de identificação de riscos e atividades','Riscos'),(5,'form_LGPD_3600_chklst_risk_area_mestre','Y','','','','Y','Y','Formulário de checklist por área de identificação de riscos e atividades','Riscos'),(5,'form_LGPD_4000_atividades','Y','','','Y',NULL,NULL,'Cadastro de atividades de adequação','Formulário'),(5,'form_LGPD_4000_atividades_calendar',NULL,NULL,NULL,NULL,NULL,NULL,'Cadastro de atividades de adequação','Formulário'),(5,'form_minhas_obr_CMP_1610_ol_agenda',NULL,NULL,NULL,NULL,NULL,NULL,'Edição das minhas obrigações legais ','Painel'),(5,'form_new_pln_acao','Y','','','',NULL,NULL,'Cadastrar plano de ação','Formulário'),(5,'form_PAC_1100_sol_portal',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(5,'form_pcp_9100_LIA','Y',NULL,NULL,NULL,'Y','Y',NULL,'Fluxo de Informação'),(5,'form_public_LGPD_0100_diagnostico','','','','',NULL,NULL,'Parametrizar etapa de diagnóstico','Formulário'),(5,'form_public_LGPD_0200_implement','','','','',NULL,NULL,'Parametrizar etapa de implementação','Formulário'),(5,'form_public_LGPD_0300_operacao','','','','',NULL,NULL,'Parametrizar etapa de operação','Formulário'),(5,'form_public_LGPD_0400_etapas','','','','',NULL,NULL,'Parametrizar etapas','Formulário'),(5,'form_public_LGPD_1000_controlador','Y','Y','Y','Y',NULL,NULL,'Cadastro de controlador','Formulário'),(5,'form_public_LGPD_1001_diretoria','Y','','','',NULL,NULL,'Cadastro de diretoria','Formulário'),(5,'form_public_LGPD_1002_area','Y','','','',NULL,NULL,'Cadastro de área','Formulário'),(5,'form_public_LGPD_1003_departamento','Y','','','',NULL,NULL,'Cadastro de departamentos','Formulário'),(5,'form_public_LGPD_1004_cargos','Y','','','',NULL,NULL,'Cadastro de cargos','Formulário'),(5,'form_public_LGPD_1050_organograma','Y','','','',NULL,NULL,'Cadastro de organograma','Formulário'),(5,'form_public_LGPD_1051_comite','Y','','','',NULL,NULL,'Cadastro de comitê','Formulário'),(5,'form_public_LGPD_1053_eventos_comite','','','','',NULL,NULL,'Agenda de eventos do comitê','Formulário'),(5,'form_public_LGPD_1100_equipe','Y','','','',NULL,NULL,'Cadastro de equipe','Formulário'),(5,'form_public_LGPD_1100_equipe_1','Y','','','',NULL,NULL,'Cadastro de equipe','Formulário'),(5,'form_public_LGPD_2000_processos','Y','','','',NULL,NULL,'Cadastro de processos','Formulário'),(5,'form_public_LGPD_2010_ativos','','','','',NULL,NULL,'Cadastro de ativos','Formulário'),(5,'form_public_LGPD_2020_artefatos','','','','',NULL,NULL,'Cadastro de artefatos','Formulário'),(5,'form_public_LGPD_2030_dados','','','','',NULL,NULL,'Cadastro de metadados','Formulário'),(5,'form_public_LGPD_2060_config_assoc',NULL,NULL,NULL,NULL,NULL,NULL,'Associação artefato x metadados','Formulário'),(5,'form_public_LGPD_2065_fund_legal','Y','Y','Y','Y',NULL,NULL,'Cadastro de fundamentos legais','Formulário'),(5,'form_public_LGPD_2066_ambiente_reg','Y','Y','Y','Y',NULL,NULL,'Cadastro de ambientes regulatórios','Formulário'),(5,'form_public_LGPD_2070_finalidades','Y','','','',NULL,NULL,'Parametrizar finalidades','Formulário'),(5,'form_public_LGPD_2070_registrar_finalidades','Y','','','',NULL,NULL,'Registrar finalidades','Formulário'),(5,'form_public_LGPD_2075_param_assoc_funcional_fin',NULL,NULL,NULL,NULL,NULL,NULL,'Associação funcional da finalidade','Formulário'),(5,'form_public_LGPD_2080_politicas','Y','Y','Y','Y',NULL,NULL,'Cadastro de políticas','Formulário'),(5,'form_public_LGPD_2085_contratos','Y','Y','Y','Y',NULL,NULL,'Cadastro de contratos','Formulário'),(5,'form_public_LGPD_2090_terceiros','Y','','','',NULL,NULL,'Cadastro de terceiros','Formulário'),(5,'form_public_LGPD_2093_ocorr_terc','Y','Y','Y','Y',NULL,NULL,'Cadastro de ocorrência de terceiros','Formulário'),(5,'form_public_LGPD_2095_med_tec','','','','',NULL,NULL,'Cadastro de medidas técnicas','Formulário'),(5,'form_public_LGPD_2097_config_assoc_med_atv',NULL,NULL,NULL,NULL,NULL,NULL,'Associar medidas técnicas aos ativos','Formulário'),(5,'form_public_LGPD_2100_prz_aprv_proc','',NULL,NULL,NULL,NULL,NULL,'[Item de menu] - Configurações / SLA de aprovação de Processos de Negócio: Acesso à configuração do prazo limite para aprovação de Processos de Negócio cadastrados','Formulário'),(5,'form_public_LGPD_3000_riscos','Y','Y','Y','Y',NULL,NULL,'Cadastro de riscos','Formulário'),(5,'form_public_LGPD_4000_atividades','Y','','','Y',NULL,NULL,'Cadastro de atividades','Formulário'),(5,'form_public_LGPD_5000_cod_etica','Y','Y','Y','Y',NULL,NULL,'Cadastro de código de ética','Formulário'),(5,'form_public_LGPD_5100_cod_conduta',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(5,'form_public_LGPD_6000_PDCA','','','','',NULL,NULL,'PDCA','Formulário'),(5,'form_public_LGPD_6100_catalog_treinamentos','','','','',NULL,NULL,'Cadastro de catalogo de treinamentos','Formulário'),(5,'form_public_LGPD_6200_agenda_treina','Y','Y','Y','Y',NULL,NULL,'Agenda de treinamentos','Formulário'),(5,'form_public_LGPD_7300_envio_aval_forne','Y','Y','Y','Y',NULL,NULL,'Cadastro de questionários (Due Diligence)','Formulário'),(5,'form_public_LGPD_assoc_contr_6500',NULL,NULL,NULL,NULL,NULL,NULL,'Associação de contratos','Formulário'),(5,'form_public_LGPD_assoc_medtec_6700',NULL,NULL,NULL,NULL,NULL,NULL,'Associação de medidas técnicas','Formulário'),(5,'form_public_LGPD_assoc_pdca_risk_6400',NULL,NULL,NULL,NULL,NULL,NULL,'Associação de riscos ao PDCA','Formulário'),(5,'form_public_LGPD_assoc_pol_6300',NULL,NULL,NULL,NULL,NULL,NULL,'Associação de políticas','Formulário'),(5,'form_public_LGPD_assoc_proc_6600',NULL,NULL,NULL,NULL,NULL,NULL,'Associação de processos','Formulário'),(5,'form_public_LGPD_assoc_treina_6500',NULL,NULL,NULL,NULL,NULL,NULL,'Associação de treinamentos','Formulário'),(5,'form_public_LGPD_config_det_opt_7200','Y','Y','Y','Y',NULL,NULL,'Parametrizar opções do questionário de fornecedores','Formulário'),(5,'form_public_PAC_1000_user_portal',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(5,'Governance_menu',NULL,NULL,NULL,NULL,NULL,NULL,'Menu',NULL),(5,'grid_CMP_0100_faixas',NULL,NULL,NULL,NULL,NULL,NULL,'Consultar faixas de setup de auditoria','Painel'),(5,'grid_CMP_1000_mecanismos','',NULL,NULL,NULL,NULL,NULL,'[Item de menu] - Pilares do Compliance / Mecanismos de Auditoria: Acesso ao cadastro de Mecanismos de Auditoria para projetos de Compliance','Pilares de Compliance'),(5,'grid_CMP_1100_componentes','',NULL,NULL,NULL,NULL,NULL,'[Item de menu] - Pilares do Compliance / Componentes de Auditoria: Acesso ao cadastro de Componentes de Auditoria, que compõem os Mecanismos cadastrados','Pilares de Compliance'),(5,'grid_CMP_1100_entrevistados_desassociados',NULL,NULL,NULL,NULL,NULL,NULL,'Consultas candidatos a entrevistas de ciclo de auditoria ','Painel'),(5,'grid_CMP_1200_questoes','',NULL,NULL,NULL,NULL,NULL,'[Item de menu] - Pilares do Compliance / Questões de Auditoria: Acesso ao cadastro de perguntas que são utilizadas para a realização de auditorias de Compliance','Pilares de Compliance'),(5,'grid_CMP_1300_formularios','',NULL,NULL,NULL,NULL,NULL,'[Item de menu] - Pilares do Compliance / Formulários de Auditoria: Acesso ao cadastro e configuração de Formulários compostos por perguntas para a realização de auditorias de Compliance','Pilares de Compliance'),(5,'grid_CMP_1310_formulario_det',NULL,NULL,NULL,NULL,NULL,NULL,'Consulta detalhes do formulário de auditoria ','Painel'),(5,'grid_CMP_1400_formulas_mestre','',NULL,NULL,NULL,NULL,NULL,'[Item de menu] - Pilares do Compliance / Parâmetros de Ciclos de Auditoria: Acesso à configuração de parâmetros quantitativos utilizados nos Ciclos de Auditoria de Compliance','Pilares de Compliance'),(5,'grid_CMP_1410_formulas_det_mec',NULL,NULL,NULL,NULL,NULL,NULL,'Sub Consulta mecanismos do setup de auditoria','Painel'),(5,'grid_CMP_1500_acao','',NULL,NULL,NULL,NULL,NULL,'[Item de menu] - Pilares do Compliance / Ações de Auditoria: Acesso ao cadastro de ações pré-determinadas para serem sugeridas a partir do levantamento de determinada Questão cadastrada','Pilares de Compliance'),(5,'grid_CMP_1550_ger_acao','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Auditoria de Compliance / Recomendações de Auditoria: Acesso à geração automática de recomendações pós Ciclo de Auditoria de Compliance','Auditoria de Compliance'),(5,'grid_CMP_1600_OL','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Aspectos Jurídicos / Obrigações Legais: Acesso ao cadastro das obrigações legais que a entidade deve atender em um determinado exercício','Aspectos Jurídicos'),(5,'grid_CMP_2000_ciclos','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Auditoria de Compliance / Ciclos de Auditoria: Acesso à gestão de Ciclos de Auditoria de Compliance','Auditoria de Compliance'),(5,'grid_CMP_2500_conf_entrevistados','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Auditoria de Compliance / Entrevistados: Acesso à seleção de entrevistados que estarão associados a um Ciclo de Auditoria de Compliance','Auditoria de Compliance'),(5,'grid_CMP_2510_entrevistados_associados',NULL,NULL,NULL,NULL,NULL,NULL,'Relação de entrevistados de um ciclo de auditoria','Painel'),(5,'grid_CMP_3000_aplic_pesq','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Auditoria de Compliance / Pesquisas de Auditoria: Acesso à aplicação de Pesquisas de Auditoria de Compliance','Auditoria de Compliance'),(5,'grid_CMP_acompanhar_pesquisas',NULL,NULL,NULL,NULL,NULL,NULL,'Consulta acompanhamento do andamento de pesquisas de auditorias','Painel'),(5,'grid_CMP_resultado_pesquisa','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Auditoria de Compliance / Resultados de Auditoria: Acesso à gestão do resultado de Pesquisas de Auditoria de Compliance','Auditoria de Compliance'),(5,'grid_CMP_resultado_pesquisa_questoes',NULL,NULL,NULL,NULL,NULL,NULL,'Consulta resultado da pesquisa de auditoria ','Painel'),(5,'grid_CMP_resultado_pesquisa_status_mecanismo',NULL,NULL,NULL,NULL,NULL,NULL,'Consulta resultado da pesquisa por mecanismos de auditoria ','Painel'),(5,'grid_conf_quest_7100',NULL,NULL,NULL,NULL,NULL,NULL,'Cofiguração de questionário para fornecedores','Painel'),(5,'grid_DOM_tp_ol_1600','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Aspectos Jurídicos / Tipos de Obrigações Legais: Acesso ao cadastro de tipos de obrigações legais','Aspectos Jurídicos'),(5,'grid_kanban_atividades',NULL,NULL,NULL,NULL,NULL,NULL,'Kanban de  atividades','Painel'),(5,'grid_kanban_atividades_add_registro',NULL,NULL,NULL,NULL,NULL,NULL,'Kanban de  atividades','Painel'),(5,'grid_LGPD_2001_form_entr_prc','Y',NULL,NULL,NULL,'Y','Y',NULL,'Fluxo de Informação'),(5,'grid_LGPD_2003_envio_entr_prc','Y',NULL,NULL,NULL,'Y','Y',NULL,'Fluxo de Informação'),(5,'grid_LGPD_2040_assoc_prc_atv','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Fluxo de Informação / Associações do Fluxo de Informação: Acesso à consulta das associações entre Processos de Negócio x Ativos de Informação x Artefatos x Metadados Pessoais','Fluxo de Informação'),(5,'grid_LGPD_2075_assoc_funcional_dados_fin',NULL,NULL,NULL,NULL,NULL,NULL,'Consulta associação de metadados','Painel'),(5,'grid_LGPD_2087_ndas','Y',NULL,NULL,NULL,'Y','Y',NULL,'Políticas e Regulamentos'),(5,'grid_LGPD_2097_assoc_med_atv','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Medidas Técnicas de Segurança / Associações com Ativos de Informação: Acesso à configuração da associação entre Medidas Técnicas de Segurança e Ativos de Informação utilizados pela entidade','Medidas Técnicas de Segurança'),(5,'grid_LGPD_3100_assoc_risc_atv','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Riscos / Associações de Riscos: Acesso à associações entre Riscos e outras informações cadastradas','Riscos'),(5,'grid_LGPD_3600_chklst_risk_area_mestre','Y','','','','Y','Y','[Item de menu] - Riscos / Checklist por área de identificação de riscos e atividades','Riscos'),(5,'grid_LGPD_6300_aluno_treina',NULL,NULL,NULL,NULL,NULL,NULL,'Consulta de lista de treinamentos realizados por colaborador','Painel'),(5,'grid_LGPD_7400_resp_aval_forne',NULL,NULL,NULL,NULL,NULL,NULL,'Consulta respostas de questionários  (Due Diligence)','Painel'),(5,'grid_new_pln_acao','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Atividades e Ações / Plano de Ação LGPD: Acesso ao cadastro do documento \"Plano de Ação\" de adequação à LGPD','Atividades e Ações'),(5,'grid_public_LGPD_0100_diagnostico','',NULL,NULL,NULL,NULL,NULL,'[Item de menu] - Configurações / Projeto de Diagnóstico da LGPD: Acesso à configuração das informações sobre o projeto de Diagnóstico da LGPD','Configurações'),(5,'grid_public_LGPD_0200_implement','',NULL,NULL,NULL,NULL,NULL,'[Item de menu] - Configurações / Projeto de Adequação da LGPD: Acesso à configuração das informações sobre o projeto de Adequação da LGPD','Configurações'),(5,'grid_public_LGPD_0300_operacao','',NULL,NULL,NULL,NULL,NULL,'[Item de menu] - Configurações / Projeto de Operação da LGPD: Acesso à configuração das informações sobre a fase de Operação da LGPD','Configurações'),(5,'grid_public_LGPD_0400_etapas','',NULL,NULL,NULL,NULL,NULL,'[Item de menu] - Configurações / Etapas do Diagnóstico da LGPD: Acesso à configuração das etapas do projeto de Diagnóstico de um projeto de adequação à LGPD','Configurações'),(5,'grid_public_LGPD_1000_controlador','',NULL,NULL,NULL,NULL,NULL,'[Item de menu] - Configurações / Entidade: Acesso à configuração dos dados da entidade','Configurações'),(5,'grid_public_LGPD_1001_diretoria','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Estrutura Organizacional / Diretoria: Acesso ao cadastro de Diretorias, que é o nível mais alto da hierarquia organizacional da entidade','Estrutura Organizacional'),(5,'grid_public_LGPD_1002_area','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Estrutura Organizacional / Área: Acesso ao cadastro de Áreas, que dividem uma determinada Diretoria na estrutura hierárquica da entidade','Estrutura Organizacional'),(5,'grid_public_LGPD_1003_departamento','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Estrutura Organizacional / Departamentos: Acesso ao cadastro de Departamentos, que dividem uma determinada Área na estrutura hierárquica da entidade','Estrutura Organizacional'),(5,'grid_public_LGPD_1004_cargos','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Estrutura Organizacional / Cargos: Acesso ao cadastro de Cargos a serem ocupados por pessoas da equipe que ocupem espaço na estrutura hierárquica da entidade','Estrutura Organizacional'),(5,'grid_public_LGPD_1050_organograma','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Estrutura Organizacional / Lotação: Acesso ao cadastro de unidades de trabalho, onde é possível alocar as equipes da entidade','Estrutura Organizacional'),(5,'grid_public_LGPD_1051_comite','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Estrutura Organizacional / Comitês: Acesso ao cadastro de comitês da entidade, que congregam uma ou mais pessoas previamente cadastradas','Estrutura Organizacional'),(5,'grid_public_LGPD_1053_eventos_comite','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Atividades e Ações / Eventos de Comitê: Acesso ao cadastro de eventos associados aos Comitês da entidade','Atividades e Ações'),(5,'grid_public_LGPD_1053_sub_eventos_comite',NULL,NULL,NULL,NULL,NULL,NULL,'Sub Consulta de Eventos','Painel'),(5,'grid_public_LGPD_1100_equipe','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Estrutura Organizacional / Equipe: Acesso ao cadastro de pessoas que podem ocupar cargos na estrutura hierárquica da entidade. Essas pessoas serão associadas a diversas outras entidades tratadas na plataforma','Estrutura Organizacional'),(5,'grid_public_LGPD_2000_proc_aprv_prz_expirado','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Atividades e Ações / Processos de Negócio Pendentes: Acesso à gestão de Processos de Negócio com SLA de aprovação expirado','Atividades e Ações'),(5,'grid_public_LGPD_2000_processos','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Fluxo de Informação / Processos de Negócio: Acesso ao cadastro de Processos de Negócio que definem as rotinas operacionais da entidade','Fluxo de Informação'),(5,'grid_public_LGPD_2000_sub_proc_pessoa',NULL,NULL,NULL,NULL,NULL,NULL,'Consulta processo por responsável','Painel'),(5,'grid_public_LGPD_2000_sub_processos_atv',NULL,NULL,NULL,NULL,NULL,NULL,'Consulta processos por ativos','Painel'),(5,'grid_public_LGPD_2010_ativos','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Fluxo de Informação / Ativos de Informação: Acesso ao cadastro de Ativos de Informação utilizados pela entidade na execução de seus Processos de Negócio','Fluxo de Informação'),(5,'grid_public_LGPD_2010_ativos_1',NULL,NULL,NULL,NULL,NULL,NULL,'Consulta Ativos','Painel'),(5,'grid_public_LGPD_2010_ativos_n_utlz_fin',NULL,NULL,NULL,NULL,NULL,NULL,'Processos disponivel para associação com finalidades','Painel'),(5,'grid_public_LGPD_2010_ativos_utlz_fin',NULL,NULL,NULL,NULL,NULL,NULL,'Processos associados a finalidade','Painel'),(5,'grid_public_LGPD_2010_sub_ativos',NULL,NULL,NULL,NULL,NULL,NULL,'Sub Consulta de Ativos','Painel'),(5,'grid_public_LGPD_2020_artefatos','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Fluxo de Informação / Artefatos: Acesso ao cadastro de Artefatos e Documentos tratados nos Ativos de Informação utilizados pela entidade','Fluxo de Informação'),(5,'grid_public_LGPD_2020_artefatos_n_utlz_fin',NULL,NULL,NULL,NULL,NULL,NULL,'Artefatos disponiveis para associação com finalidades','Painel'),(5,'grid_public_LGPD_2020_artefatos_utlz_fin',NULL,NULL,NULL,NULL,NULL,NULL,'Artefatos associados a finalidades','Painel'),(5,'grid_public_LGPD_2030_assoc_art_metadados',NULL,NULL,NULL,NULL,NULL,NULL,'Associação de Artefatos e metadados','Painel'),(5,'grid_public_LGPD_2030_dados','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Fluxo de Informação / Metadados Pessoais: Acesso ao cadastro de Metadados Pessoais presentes nos diferentes Artefatos utilizados pela entidade','Fluxo de Informação'),(5,'grid_public_LGPD_2065_fund_legal','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Aspectos Jurídicos / Fundamentos Legais: Acesso ao cadastro de Fundamentos Legais utilizados pela entidade','Aspectos Jurídicos'),(5,'grid_public_LGPD_2066_ambiente_reg','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Aspectos Jurídicos / Ambientes regulatórios: Acesso ao cadastro de Ambientes Regulatórios a serem associados a Fundamentos Legais utilizados pela entidade','Aspectos Jurídicos'),(5,'grid_public_LGPD_2070_finalidades','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Tratamento de Dados Pessoais / Parametrizar Finalidades de Tratamentos: Acesso à configuração dos aspectos e detalhes das Finalidades de Tratamento de Dados Pessoais previamente cadastradas','Tratamento de Dados Pessoais'),(5,'grid_public_LGPD_2070_registrar_finalidades','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Tratamento de Dados Pessoais / Registrar Finalidade de Tratamento: Acesso ao cadastro de Finalidades de Tratamento de Dados Pessoais executadas pela entidade','Tratamento de Dados Pessoais'),(5,'grid_public_LGPD_2070_sub_contratos_finalidades',NULL,NULL,NULL,NULL,NULL,NULL,'Sub consulta de contratos dentro da finalidade','Painel'),(5,'grid_public_LGPD_2070_sub_finalidades',NULL,NULL,NULL,NULL,NULL,NULL,'Sub consulta de finalidades','Painel'),(5,'grid_public_LGPD_2073_assoc_ativos_fin',NULL,NULL,NULL,NULL,NULL,NULL,'Associação de ativos na finalidade','Painel'),(5,'grid_public_LGPD_2075_assoc_metadados_fin',NULL,NULL,NULL,NULL,NULL,NULL,'Associação de metadados na finalidade','Painel'),(5,'grid_public_LGPD_2080_politicas','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Políticas e Regulamentos / Políticas: Acesso ao cadastro de políticas associadas à Governança de Privacidade da entidade','Políticas e Regulamentos'),(5,'grid_public_LGPD_2085_contratos','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Políticas e Regulamentos / Contratos: Acesso ao cadastro de contratos e modelos de contratos utilizados pela entidade','Políticas e Regulamentos'),(5,'grid_public_LGPD_2090_terceiros','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Gestão de terceiros / Terceiros: Acesso ao cadastro de entidades terceiras (PJ ou PF) associadas à entidade','Gestão de Terceiros'),(5,'grid_public_LGPD_2093_ocorr_terc','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Gestão de terceiros / Ocorrências: Acesso ao cadastro de ocorrências relacionadas à Terceiros associados à entidade','Gestão de Terceiros'),(5,'grid_public_LGPD_2095_med_tec','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Medidas Técnicas de Segurança / Medidas Técnicas de Segurança: Acesso ao cadastro de Medidas Técnicas de Segurança da Informação que podem ser associadas a Ativos cadastrados','Medidas Técnicas de Segurança'),(5,'grid_public_LGPD_2095_sub_med_tec',NULL,NULL,NULL,NULL,NULL,NULL,'Sub Consulta de medidas técnicas','Painel'),(5,'grid_public_LGPD_3000_riscos','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Riscos / Riscos: Acesso ao cadastro de Riscos de Privacidade e Compliance','Riscos'),(5,'grid_public_LGPD_3000_sub_consulta_riscos',NULL,NULL,NULL,NULL,NULL,NULL,'Sub consulta de riscos','Painel'),(5,'grid_public_LGPD_3300_assoc_risc_prc',NULL,NULL,NULL,NULL,NULL,NULL,'Associar risco a processos','Painel'),(5,'grid_public_LGPD_4000_atividades','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Atividades e Ações / Atividades e Ações: Acesso ao cadastro de atividades e ações de governança e compliance','Atividades e Ações'),(5,'grid_public_LGPD_5000_cod_etica','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Políticas e Regulamentos / Códigos e Regulamentos Internos: Acesso ao cadastro de documentos que definem as regras internas de Compliance da entidade','Políticas e Regulamentos'),(5,'grid_public_LGPD_5100_cod_conduta',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(5,'grid_public_LGPD_6000_PDCA','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Atividades e Ações / Gestão de ciclo de PDCA de Compliance: Acesso ao planejamento e gestão de ciclos de PDCA de Compliance','Atividades e Ações'),(5,'grid_public_LGPD_6000_SUB_PDCA',NULL,NULL,NULL,NULL,NULL,NULL,'Sub consulta PDCA','Painel'),(5,'grid_public_LGPD_6100_catalog_treinamentos','',NULL,NULL,NULL,NULL,NULL,'[Item de menu] - Atividades e Ações / Catálogo de treinamentos: Acesso ao cadastro dos tipos de treinamentos que a entidade pode executar para suas equipes','Atividades e Ações'),(5,'grid_public_LGPD_6200_agenda_treina','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Atividades e Ações / Agenda de Treinamentos: Acesso à gestão de agenda de treinamentos e capacitações internas da entidade','Atividades e Ações'),(5,'grid_public_LGPD_7300_envio_aval_forne',NULL,NULL,NULL,NULL,NULL,NULL,'Consulta de questionários (Due Diligence)','Painel'),(5,'grid_public_LGPD_7300_envio_aval_forne_gerencial','Y',NULL,NULL,NULL,'Y','Y',NULL,'Gestão de Terceiros'),(5,'grid_public_LGPD_cons_rev_contr_6500',NULL,NULL,NULL,NULL,NULL,NULL,'Consulta revisões de contrato','Painel'),(5,'grid_public_LGPD_cons_rev_medtec_6700',NULL,NULL,NULL,NULL,NULL,NULL,'Consulta revisões de medidas técnicas','Painel'),(5,'grid_public_LGPD_cons_rev_pol_6300',NULL,NULL,NULL,NULL,NULL,NULL,'Consulta revisão de políticas','Painel'),(5,'grid_public_LGPD_cons_rev_proc_6600',NULL,NULL,NULL,NULL,NULL,NULL,'Consulta revisão de processos','Painel'),(5,'grid_public_LGPD_cons_rev_risk_6400',NULL,NULL,NULL,NULL,NULL,NULL,'Consulta revisão de riscos','Painel'),(5,'grid_public_PAC_9000_DPIA',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(5,'grid_public_PAC_9100_LIA',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(5,'grid_public_PCP_9000_DPIA',NULL,NULL,NULL,NULL,NULL,NULL,'Consulta DPIA',NULL),(5,'grid_public_pcp_9100_LIA',NULL,NULL,NULL,NULL,NULL,NULL,'Consulta LIA ',NULL),(5,'grid_public_subconsulta_sec_users',NULL,NULL,NULL,NULL,NULL,NULL,'Sub consulta de usuarios','Painel'),(5,'grid_sc_log','',NULL,NULL,NULL,NULL,NULL,'[Item de menu] - Segurança / Histórico de acessos: Acesso à consulta à histórico de acessos de usuários à plataforma','Segurança'),(5,'help_cadastro_titulares',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(5,'help_ciclo_de_vida',NULL,NULL,NULL,NULL,NULL,NULL,'Help Ciclo de vida','Painel'),(5,'help_finalidades_fundamentos',NULL,NULL,NULL,NULL,NULL,NULL,'Help Finalidades','Painel'),(5,'help_geracao_atividades',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(5,'help_geracao_riscos',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(5,'help_gestao_consentimentos',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(5,'help_gestao_incidentes',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(5,'help_gestao_notificacao',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(5,'help_integracao_portais',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(5,'help_lotes_validacao',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(5,'help_medidas_administrativas',NULL,NULL,NULL,NULL,NULL,NULL,'Help medidas administrativas','Painel'),(5,'help_medidas_tecnicas',NULL,NULL,NULL,NULL,NULL,NULL,'Help para medidas técnicas','Painel'),(5,'help_plano_acao_atividades',NULL,NULL,NULL,NULL,NULL,NULL,'Help Atividades','Painel'),(5,'help_relatorios',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(5,'help_riscos_e_impactos',NULL,NULL,NULL,NULL,NULL,NULL,'Help Riscos','Painel'),(5,'homepage',NULL,NULL,NULL,NULL,NULL,NULL,'Home Page (Responsábilidades e Atividades)','Painel'),(5,'homepage_help',NULL,NULL,NULL,NULL,NULL,NULL,'Help','Painel'),(5,'mapa_calor_risco',NULL,NULL,NULL,NULL,NULL,NULL,'Mapa de risco','Painel'),(5,'Mapa_Calor_Riscos',NULL,NULL,NULL,NULL,NULL,NULL,'Mapa de calor de riscos ','Painel'),(5,'menu',NULL,NULL,NULL,NULL,NULL,NULL,'Menu PCP','Painel'),(5,'menu_dinamico',NULL,NULL,NULL,NULL,NULL,NULL,'Menu','Painel'),(5,'Menu_Pac',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(5,'Metadados','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Painel / Metadados Pessoais: Acesso à exibição dos principais indicadores sobre Metadados Pessoais','Painel'),(5,'novo_menu',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(5,'pac_app_change_pswd','Y','','','','','','[Item de menu] - SeguranÃ§a / AlteraÃ§Ã£o de senha: Acesso Ã  gestÃ£o de senhas de usuÃ¡rios da plataforma','SeguranÃ§a'),(5,'pac_app_form_sec_groups_apps','',NULL,NULL,NULL,NULL,NULL,'[Item de menu] - SeguranÃ§a / AssociaÃ§Ã£o de perfis a aplicaÃ§Ãµes: Acesso Ã  configuraÃ§Ã£o da associaÃ§Ã£o de perfis de acesso com as aplicaÃ§Ãµes da plataforma','SeguranÃ§a'),(5,'pac_app_grid_sec_apps','',NULL,NULL,NULL,NULL,NULL,'[Item de menu] - SeguranÃ§a / AplicaÃ§Ãµes: Acesso ao cadastro de aplicaÃ§Ãµes da plataforma','SeguranÃ§a'),(5,'pac_app_grid_sec_groups','',NULL,NULL,NULL,NULL,NULL,'[Item de menu] - SeguranÃ§a / Perfis: Acesso ao cadastro de perfis de acesso dos usuÃ¡rios da plataforma','SeguranÃ§a'),(5,'pac_app_grid_sec_users','',NULL,NULL,NULL,NULL,NULL,'[Item de menu] - SeguranÃ§a / UsuÃ¡rios: Acesso ao cadastro de usuÃ¡rios da plataforma','SeguranÃ§a'),(5,'pac_app_grid_sec_users_groups','',NULL,NULL,NULL,NULL,NULL,'[Item de menu] - SeguranÃ§a / AssociaÃ§Ã£o de usuÃ¡rios a perfis: Acesso Ã  configuraÃ§Ã£o da associaÃ§Ã£o de usuÃ¡rios a perfis de acesso','SeguranÃ§a'),(5,'pac_app_search_sec_groups','',NULL,NULL,NULL,NULL,NULL,'[Item de menu] - SeguranÃ§a / AssociaÃ§Ã£o de perfis a aplicaÃ§Ãµes: Acesso Ã  configuraÃ§Ã£o da associaÃ§Ã£o de perfis de acesso com as aplicaÃ§Ãµes da plataforma','SeguranÃ§a'),(5,'pac_menu',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(5,'PAG_menu',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(5,'param_aval_mestre_7000','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Gestão de terceiros / Formulários de due diligence: Acesso à criação de formulários (e suas questões) para auto avaliação de terceiros','Gestão de Terceiros'),(5,'PDCA','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Painel / Ciclos de PDCA: Acesso à exibição dos principais indicadores sobre Ciclos de PDCA de Compliance','Painel'),(5,'pdfreport_LGPD_7300_envio_aval_forne',NULL,NULL,NULL,NULL,NULL,NULL,'geração de PDF - questionário (Due Diligence)','Painel'),(5,'popup_confirm_action',NULL,NULL,NULL,NULL,NULL,NULL,'Pop-up ( não se aplica ao módulo de segirança)','Painel'),(5,'popup_confirm_action_status',NULL,NULL,NULL,NULL,NULL,NULL,'Pop_Up ( Não se plaica ao módulo de segurança ) ','Painel'),(5,'Processos','',NULL,NULL,NULL,NULL,NULL,'[Item de menu] - Painel / Processos de Negócio: Acesso à exibição dos principais indicadores sobre Processos de Negócio','Painel'),(5,'relatorio_ciclos_complience',NULL,NULL,NULL,NULL,NULL,NULL,'Extrato de cilco de auditoria ','Painel'),(5,'relatorio_dpia',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(5,'relatorio_dpia_1',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(5,'relatorio_finalidades',NULL,NULL,NULL,NULL,NULL,NULL,'Relatório de finalidades','Painel'),(5,'relatorio_lia',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(5,'relatorio_notificacao',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(5,'relatorio_resp_aval',NULL,NULL,NULL,NULL,NULL,NULL,'Relatório Avaliações','Painel'),(5,'resumo_finalidade',NULL,NULL,NULL,NULL,NULL,NULL,'Resumo de finalidade','Painel'),(5,'Riscos','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Painel / Riscos: Acesso à exibição dos principais indicadores sobre Gestão de Riscos de Privacidade e Compliance','Painel'),(5,'risk_heat_map','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Riscos / Mapa de Calor: Acesso à exibição do Mapa de Calor dos Riscos cadastrados','Riscos'),(5,'search_public_LGPD_4000_atividades',NULL,NULL,NULL,NULL,NULL,NULL,'Filtro de atividades','Painel'),(5,'sec_change_pswd',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(5,'sec_form_add_users',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(5,'sec_form_edit_users',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(5,'sec_form_sec_apps',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(5,'sec_form_sec_groups',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(5,'sec_form_sec_groups_apps',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(5,'sec_grid_sec_apps',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(5,'sec_grid_sec_groups',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(5,'sec_grid_sec_users',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(5,'sec_grid_sec_users_groups',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(5,'sec_Login',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(5,'sec_menu',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(5,'sec_retrieve_pswd',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(5,'sec_search_sec_groups',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(5,'sec_settings',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(5,'sec_sync_apps',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(5,'sub_consulta_3000_riscos_incidente',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(5,'sub_consulta_3100_assoc_risc_atv',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(5,'sub_consulta_3300_assoc_risc_prc',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(5,'sub_consulta_3400_assoc_risc_fin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(5,'sub_consulta_CMP_1610_ol_agenda',NULL,NULL,NULL,NULL,NULL,NULL,'Sub consulta de agenda de obrigações legais por obrigação','Painel'),(5,'sub_consulta_CMP_2510_det_conf_entrevistados',NULL,NULL,NULL,NULL,NULL,NULL,'Entrevitados em presquisa de auditoria --> Sub Consulta de configuração de entrevidados de pesquisa de auditoria ','Painel'),(5,'sub_consulta_CMP_3000_aplic',NULL,NULL,NULL,NULL,NULL,NULL,'Sub consulta status da aplicação de pesquisa de auditoria','Painel'),(5,'sub_consulta_CMP_4000_respostas_mestre',NULL,NULL,NULL,NULL,NULL,NULL,'Sub consulta status de respostas dos formulários de auditoria dentro de um ciclo ','Painel'),(5,'sub_consulta_configurar_metadados',NULL,NULL,NULL,NULL,NULL,NULL,'Sub consulta configuração de metadados','Painel'),(5,'sub_consulta_LGPD_2097_assoc_med_atv',NULL,NULL,NULL,NULL,NULL,NULL,'Sub consulta de associação entre medidas técnicas e ativos','Painel'),(5,'sub_consulta_LGPD_6200_agenda_treina',NULL,NULL,NULL,NULL,NULL,NULL,'Sub consulta de agenda de treinamentos ','Painel'),(5,'sub_consulta_PAC_1100_sol_portal',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(5,'sub_consulta_PAC_3200_tit_consent',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(5,'sub_consulta_PAC_4000_notificacao',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(5,'sub_consulta_PAG_ocorr_lote_1100',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(5,'sub_form_configurar_metados',NULL,NULL,NULL,NULL,NULL,NULL,'Configurar metadados','Painel'),(5,'sub_grid_CMP_1550_ger_acao',NULL,NULL,NULL,NULL,NULL,NULL,'Sub grid de recomendaçoes de auditoria por ciclo','Painel'),(5,'sub_grid_LGPD_2050_assoc_atv_art',NULL,NULL,NULL,NULL,NULL,NULL,'Sub consulta de associação entre ativos e artefatos',NULL),(5,'sub_grid_PAC_1400_tit_afet_inc',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(5,'sub_grid_public_LGPD_2093_ocorr_terc',NULL,NULL,NULL,NULL,NULL,NULL,'Sub consulta ocorrência de terceiros','Painel'),(6,'app_change_pswd','',NULL,NULL,NULL,NULL,NULL,'[Item de menu] - Segurança / Alteração de senha: Acesso à gestão de senhas de usuários da plataforma','Segurança'),(6,'app_form_add_users','','','','',NULL,NULL,'Cadastrar usuários','Formulário'),(6,'app_form_edit_users','','','','',NULL,NULL,'Alterar usuários','Formulário'),(6,'app_form_sec_apps','','','','',NULL,NULL,'Cadastrar aplicações','Formulário'),(6,'app_form_sec_groups','','','','',NULL,NULL,'Cadastro de grupos de usuários','Formulário'),(6,'app_form_sec_groups_apps','','','','',NULL,NULL,'Associar grupos x aplicações','Painel'),(6,'app_grid_sec_apps','',NULL,NULL,NULL,NULL,NULL,'[Item de menu] - Segurança / Aplicações: Acesso ao cadastro de aplicações da plataforma','Segurança'),(6,'app_grid_sec_groups','',NULL,NULL,NULL,NULL,NULL,'[Item de menu] - Segurança / Perfis: Acesso ao cadastro de perfis de acesso dos usuários da plataforma','Segurança'),(6,'app_grid_sec_users','',NULL,NULL,NULL,NULL,NULL,'[Item de menu] - Segurança / Usuários: Acesso ao cadastro de usuários da plataforma','Segurança'),(6,'app_grid_sec_users_groups','',NULL,NULL,NULL,NULL,NULL,'[Item de menu] - Segurança / Associação de usuários a perfis: Acesso à configuração da associação de usuários a perfis de acesso','Segurança'),(6,'app_Login',NULL,NULL,NULL,NULL,NULL,NULL,'Login',NULL),(6,'app_menu',NULL,NULL,NULL,NULL,NULL,NULL,'Menu','Painel'),(6,'app_retrieve_pswd',NULL,NULL,NULL,NULL,NULL,NULL,'Esqueceu a senha','Painel'),(6,'app_search_sec_groups','',NULL,NULL,NULL,NULL,NULL,'[Item de menu] - Segurança / Associação de perfis a aplicações: Acesso à configuração da associação de perfis de acesso com as aplicações da plataforma','Segurança'),(6,'app_settings','',NULL,NULL,NULL,NULL,NULL,'Configurações de segurança','Segurança'),(6,'app_sync_apps','',NULL,NULL,NULL,NULL,NULL,'Sincronização de aplicações','Segurança'),(6,'Artefatos','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Painel / Artefatos: Acesso à exibição dos principais indicadores sobre Artefatos e Documentos','Painel'),(6,'associar_metadados_finalidade',NULL,NULL,NULL,NULL,NULL,NULL,'Associar metadados na finalidade','Painel'),(6,'associar_metadados_finalidade_new',NULL,NULL,NULL,NULL,NULL,NULL,'Associar metadados a finalidades','Painel'),(6,'Atividades','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Painel / Atividades e Ações: Acesso à exibição dos principais indicadores sobre Atividades e Ações','Painel'),(6,'Ativos','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Painel / Ativos de Informação: Acesso à exibição dos principais indicadores sobre Ativos de Informação','Painel'),(6,'Auto_cadastro_PAC_4000_notificacao',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(6,'blank_email',NULL,NULL,NULL,NULL,NULL,NULL,'Enviar mail','Painel'),(6,'blank_pipeline','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Atividades e Ações / Meu Quadro de Atividades: Acesso ao Kanban de atividades do usuário logado','Atividades e Ações'),(6,'blank_pipeline_Ajax',NULL,NULL,NULL,NULL,NULL,NULL,'Pipeline de atividades','Painel'),(6,'cad_sol_dpia_pcp_9000','Y',NULL,NULL,NULL,'Y','Y',NULL,'Fluxo de Informação'),(6,'Cadastro_DEN_1000_registro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(6,'Cadastro_DEN_1100_cat',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(6,'cadastro_PAC_1110_atv_sol',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(6,'cadastro_PAC_1200_sla_sol_portal',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(6,'Cadastro_PAC_1400_titulares',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(6,'Cadastro_PAC_1410_dados_tit',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(6,'Cadastro_PAC_2000_incidentes',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(6,'Cadastro_PAC_2100_sla_notificacao',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(6,'Cadastro_PAC_3100_env_consent',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(6,'Cadastro_PAC_4000_notificacao',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(6,'Cadastro_PAG_lote_1000',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(6,'cadastro_PAG_ocorr_lote_1100',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(6,'calendar_app',NULL,NULL,NULL,NULL,NULL,NULL,'Calendário','Painel'),(6,'calendar_public_LGPD_4000_atividades',NULL,NULL,NULL,NULL,NULL,NULL,'Calendário de atividades ( DPO )','Painel'),(6,'chart_public_LGPD_2000_processos_complex',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico processo por complexidade','Painel'),(6,'chart_public_LGPD_2000_processos_geral',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico processos','Painel'),(6,'chart_public_LGPD_2000_processos_resp',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico processos por responsável','Painel'),(6,'chart_public_LGPD_2000_status_processos',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico processo por status','Painel'),(6,'chart_public_LGPD_2000_tipo_processo',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico processos por tipo','Painel'),(6,'chart_public_LGPD_2010_confia_ativos',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico confibilidade dos ativos','Painel'),(6,'chart_public_LGPD_2010_disp_ativos',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico ativos por nível de disponibilidade','Painel'),(6,'chart_public_LGPD_2010_integridade_ativos',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico ativos por nível de integridade','Painel'),(6,'chart_public_LGPD_2010_resp_ativos',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico ativos por responsável','Painel'),(6,'chart_public_LGPD_2010_tipo_ativos',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico tipos de ativos','Painel'),(6,'chart_public_LGPD_2020_artefat_contrato',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico artefatos tipo contrato','Painel'),(6,'chart_public_LGPD_2020_contrato_artefatos',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico contratos x artefatos','Painel'),(6,'chart_public_LGPD_2020_tipo_artefatos',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico artefatos por tipo','Painel'),(6,'chart_public_LGPD_2030_classif_dados',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico classificação de metadados','Painel'),(6,'chart_public_LGPD_2030_dados_anonimizavel',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico metadados anonimizavel','Painel'),(6,'chart_public_LGPD_2030_tipif_dados',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico tipos de dados','Painel'),(6,'chart_public_LGPD_2070_fin_compart_dados',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico finalidades por compartilhamento','Painel'),(6,'chart_public_LGPD_2070_fin_dad_criancas',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico finalidades por dados de crianças','Painel'),(6,'chart_public_LGPD_2070_fin_faz_descarte',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico finalidades por descarte','Painel'),(6,'chart_public_LGPD_2070_fin_frequencia',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico finalidades por ferequencia','Painel'),(6,'chart_public_LGPD_2070_fin_hipoteses',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico finalidades por hipóteses de tratamento','Painel'),(6,'chart_public_LGPD_2070_fin_papel',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico papel da entidade','Painel'),(6,'chart_public_LGPD_2070_fin_processos',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico finalidades por processos','Painel'),(6,'chart_public_LGPD_2070_fin_rot_automatizada',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico finalidades por rotinas automatizadas','Painel'),(6,'chart_public_LGPD_2070_fin_utlz_operador',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico finalidades por utiliza operador','Painel'),(6,'chart_public_LGPD_2070_fin_volumetria',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico finliadades por volumetria','Painel'),(6,'chart_public_LGPD_3000_categoria_riscos',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico riscos por categoria','Painel'),(6,'chart_public_LGPD_3000_criticidade_riscos',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico riscos por criticidade','Painel'),(6,'chart_public_LGPD_3000_estrategia_riscos',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico riscos por estratégia','Painel'),(6,'chart_public_LGPD_3000_impacto_riscos',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico riscos por impacto','Painel'),(6,'chart_public_LGPD_3000_prob_riscos',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico riscos por probabilidade','Painel'),(6,'chart_public_LGPD_3000_resp_riscos',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico riscos por responsáveis','Painel'),(6,'chart_public_LGPD_3000_status_riscos',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico riscos por status','Painel'),(6,'chart_public_LGPD_4000_atividades_geral',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico atividades','Painel'),(6,'chart_public_LGPD_4000_disc_atividades',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico atividades por disciplina','Painel'),(6,'chart_public_LGPD_4000_etapa_atividades',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico atividades por etapas','Painel'),(6,'chart_public_LGPD_4000_resp_atividades',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico atividades por responsável','Painel'),(6,'chart_public_LGPD_4000_status_resp_atividade',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico atividades por responsável e status','Painel'),(6,'chart_public_LGPD_assoc_pdca_contr_6500',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico PDCA de contratos','Painel'),(6,'chart_public_LGPD_assoc_pdca_finalizados_treina_6500',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico PDCA de treinamentos','Painel'),(6,'chart_public_LGPD_assoc_pdca_medtec_6700',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico PDCA de medidas técnicas','Painel'),(6,'chart_public_LGPD_assoc_pdca_pol_6300',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico PDCA de políticas','Painel'),(6,'chart_public_LGPD_assoc_pdca_proc_6600',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico PDCA de processos','Painel'),(6,'chart_public_LGPD_assoc_pdca_realizar_treina_6500',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico PDCA realização de treinamentos','Painel'),(6,'chart_public_LGPD_assoc_pdca_risk_6400',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico PDCA de riscos','Painel'),(6,'cons_dad_nao_utlz_LGPD_2030_dados','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Fluxo de Informação / Metadados Pessoais não utilizados: Acesso à consulta dos Metadados Pessoais cadastrados mas não utilizados em nenhuma associação','Fluxo de Informação'),(6,'cons_minhas_obr_CMP_1610_ol_agenda','',NULL,NULL,NULL,NULL,NULL,'[Item de menu] - Aspectos Jurídicos / Minhas Obrigações Legais: Acesso ao cadastro das obrigações legais da entidade que estão sob a responsabilidade do usuário logado','Aspectos Jurídicos'),(6,'Consulta_DEN_1000_registro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(6,'Consulta_DEN_1100_cat',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(6,'consulta_gerencial_CMP_1610_ol_agenda','',NULL,NULL,NULL,NULL,NULL,'[Item de menu] - Aspectos Jurídicos / Acompanhamento de Obrigações Legais: Acesso ao painel de acompanhamento do status das obrigações legais da entidade','Aspectos Jurídicos'),(6,'consulta_gerencial_LGPD_4000_atividades','',NULL,NULL,NULL,NULL,NULL,'[Item de menu] - Atividades e Ações / Acompanhamento de Atividades e Ações: Acesso ao painel de acompanhamento do status das obrigações legais da entidade','Atividades e Ações'),(6,'Consulta_LGPD_3000_riscos_assistant',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(6,'Consulta_LGPD_4000_atividades_assistant',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(6,'Consulta_PAC_1000_user_portal',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(6,'Consulta_PAC_1100_sol_portal',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(6,'consulta_PAC_1200_sla_sol_portal',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(6,'Consulta_PAC_1400_titulares',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(6,'Consulta_PAC_1410_dados_tit',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(6,'Consulta_PAC_2000_incidentes',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(6,'Consulta_PAC_3100_env_consent',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(6,'Consulta_PAC_4000_notificacao',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(6,'Consulta_PAG_lote_1000',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(6,'Consulta_public_LGPD_3000_riscos',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(6,'control_calendar',NULL,NULL,NULL,NULL,NULL,NULL,'Meu calendário de atividades de adequação',NULL),(6,'control_login',NULL,NULL,NULL,NULL,NULL,NULL,'Login','Painel'),(6,'control_login_diligence',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(6,'esqueci_senha',NULL,NULL,NULL,NULL,NULL,NULL,'Esqueceu a senha','Painel'),(6,'extrato_pdca',NULL,NULL,NULL,NULL,NULL,NULL,'Extrato PDCA','Painel'),(6,'Finalidades','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Painel / Finalidades de Tratamento de Dados Pessoais: Acesso à exibição dos principais indicadores sobre Finalidades de Tratamento de Dados Pessoais','Painel'),(6,'form_aval_7000','Y',NULL,NULL,NULL,'Y','Y','Formulários de due diligence: Acesso à criação de formulários (e suas questões) para auto avaliação de terceiros','Gestão de Terceiros'),(6,'form_CMP_1000_mecanismos','','','','',NULL,NULL,'Cadastro de mecanismos de auditoria ','Formulário'),(6,'form_CMP_1100_componentes','','','','',NULL,NULL,'Cadastro de componentes de auditoria','Formulário'),(6,'form_CMP_1200_questoes','','','','',NULL,NULL,'Cadastro de questões de auditoria','Formulário'),(6,'form_CMP_1300_formularios','','','','',NULL,NULL,'Cadatro de formulários de auditoria ','Formulário'),(6,'form_CMP_1300_formularios_edit','','','','',NULL,NULL,'Edição de formulários de auditoria','Formulário'),(6,'form_CMP_1400_formulas_mestre','','','','',NULL,NULL,'Parametrização de Setup de Auditoria','Formulário'),(6,'form_CMP_1400_formulas_view','','','','',NULL,NULL,'Visualizar setup de auditoria','Formulário'),(6,'form_CMP_1410_formulas_det_mec','','','','',NULL,NULL,'Parametrizar mecanismos de auditoria no setup','Formulário'),(6,'form_CMP_1420_formulas_det_niv_ad','','','','',NULL,NULL,'Parametrizar níveis de aderência do setup de auditoria ','Formulário'),(6,'form_CMP_1430_formulas_det_lim','','','','',NULL,NULL,'Parametrizar faixas do setup de auditoria','Formulário'),(6,'form_CMP_1500_acao','','','','',NULL,NULL,'Recomendações de auditorias','Formulário'),(6,'form_CMP_1600_OL','','','','',NULL,NULL,'Cadastro de Obrigações Legais ','Formulário'),(6,'form_CMP_2000_ciclos','','','','',NULL,NULL,'Cadastro de ciclos de auditoria','Formulário'),(6,'form_CMP_2500_conf_entrevistados','','','','',NULL,NULL,'Cadastro de entrevistados do ciclo de auditoria ','Formulário'),(6,'form_CMP_2500_conf_entrevistados_1','','','','',NULL,NULL,'Cadastro de entrevistados ','Formulário'),(6,'form_CMP_2500_conf_param_entrevistados','','','','',NULL,NULL,'Parametrizar relação de entrevistados de um ciclo de auditoria','Formulário'),(6,'form_CMP_3000_aplic_pesq','','','','',NULL,NULL,'Cadastro de aplicação de pesquisa de auditorias ','Formulário'),(6,'form_CMP_resultados_pesquisas','','','','',NULL,NULL,'Cadastro de resultado de pesquisas de auditoria','Formulário'),(6,'form_conf_quest_7100','Y','Y','Y','Y',NULL,NULL,'Configurar questionário de fornecedores','Formulário'),(6,'form_diligence',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(6,'form_DOM_tp_ol_1600','','','','',NULL,NULL,'Cadastro de tipos de obrigações ','Formulário'),(6,'form_kanban_atividades','Y','','','Y',NULL,NULL,'Kanban de  atividades','Formulário'),(6,'form_kanban_atividades_add_registro','Y','','','Y',NULL,NULL,'Cadastrar atividades pelo kanban','Formulário'),(6,'form_LGPD_0002_conf_smpt','',NULL,NULL,NULL,NULL,NULL,'[Item de menu] - Configurações / Configuração de envio de e-mails: Acesso à configuração do endereço de de SMTP para envio de e-mails da plataforma','Formulário'),(6,'form_LGPD_2001_form_entr_prc','Y',NULL,NULL,NULL,'Y','Y',NULL,'Fluxo de Informação'),(6,'form_LGPD_2003_envio_entr_prc','Y',NULL,NULL,NULL,'Y','Y',NULL,'Fluxo de Informação'),(6,'form_LGPD_2087_ndas','Y',NULL,NULL,NULL,'Y','Y',NULL,'Fluxo de Informação'),(6,'form_LGPD_2097_assoc_med_atv',NULL,NULL,NULL,NULL,NULL,NULL,'Cadastro de Medidas Técnicas - > Cadastro da especificação da associação entre medida técnica e ativo','Painel'),(6,'form_LGPD_3500_checklist_risk_padrao','Y','','','','Y','Y','[Item de menu] - Riscos / Checklist padrão de identificação de riscos e atividades','Riscos'),(6,'form_LGPD_3600_chklst_risk_area_mestre','Y','','','','Y','Y','Formulário de checklist por área de identificação de riscos e atividades','Riscos'),(6,'form_LGPD_4000_atividades','Y','','','Y',NULL,NULL,'Cadastro de atividades de adequação','Formulário'),(6,'form_LGPD_4000_atividades_calendar',NULL,NULL,NULL,NULL,NULL,NULL,'Cadastro de atividades de adequação','Formulário'),(6,'form_minhas_obr_CMP_1610_ol_agenda',NULL,NULL,NULL,NULL,NULL,NULL,'Edição das minhas obrigações legais ','Painel'),(6,'form_new_pln_acao','Y','','','',NULL,NULL,'Cadastrar plano de ação','Formulário'),(6,'form_PAC_1100_sol_portal',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(6,'form_pcp_9100_LIA','Y',NULL,NULL,NULL,'Y','Y',NULL,'Fluxo de Informação'),(6,'form_public_LGPD_0100_diagnostico','','','','',NULL,NULL,'Parametrizar etapa de diagnóstico','Formulário'),(6,'form_public_LGPD_0200_implement','','','','',NULL,NULL,'Parametrizar etapa de implementação','Formulário'),(6,'form_public_LGPD_0300_operacao','','','','',NULL,NULL,'Parametrizar etapa de operação','Formulário'),(6,'form_public_LGPD_0400_etapas','','','','',NULL,NULL,'Parametrizar etapas','Formulário'),(6,'form_public_LGPD_1000_controlador','','','','',NULL,NULL,'Cadastro de controlador','Formulário'),(6,'form_public_LGPD_1001_diretoria','','','','',NULL,NULL,'Cadastro de diretoria','Formulário'),(6,'form_public_LGPD_1002_area','','','','',NULL,NULL,'Cadastro de área','Formulário'),(6,'form_public_LGPD_1003_departamento','','','','',NULL,NULL,'Cadastro de departamentos','Formulário'),(6,'form_public_LGPD_1004_cargos','','','','',NULL,NULL,'Cadastro de cargos','Formulário'),(6,'form_public_LGPD_1050_organograma','','','','',NULL,NULL,'Cadastro de organograma','Formulário'),(6,'form_public_LGPD_1051_comite','Y','','','',NULL,NULL,'Cadastro de comitê','Formulário'),(6,'form_public_LGPD_1053_eventos_comite','','','','',NULL,NULL,'Agenda de eventos do comitê','Formulário'),(6,'form_public_LGPD_1100_equipe','','','','',NULL,NULL,'Cadastro de equipe','Formulário'),(6,'form_public_LGPD_1100_equipe_1','','','','',NULL,NULL,'Cadastro de equipe','Formulário'),(6,'form_public_LGPD_2000_processos','','','','',NULL,NULL,'Cadastro de processos','Formulário'),(6,'form_public_LGPD_2010_ativos','Y','','','Y',NULL,NULL,'Cadastro de ativos','Formulário'),(6,'form_public_LGPD_2020_artefatos','','','','',NULL,NULL,'Cadastro de artefatos','Formulário'),(6,'form_public_LGPD_2030_dados','','','','',NULL,NULL,'Cadastro de metadados','Formulário'),(6,'form_public_LGPD_2060_config_assoc',NULL,NULL,NULL,NULL,NULL,NULL,'Associação artefato x metadados','Formulário'),(6,'form_public_LGPD_2065_fund_legal','','','','',NULL,NULL,'Cadastro de fundamentos legais','Formulário'),(6,'form_public_LGPD_2066_ambiente_reg','','','','',NULL,NULL,'Cadastro de ambientes regulatórios','Formulário'),(6,'form_public_LGPD_2070_finalidades','','','','',NULL,NULL,'Parametrizar finalidades','Formulário'),(6,'form_public_LGPD_2070_registrar_finalidades','','','','',NULL,NULL,'Registrar finalidades','Formulário'),(6,'form_public_LGPD_2075_param_assoc_funcional_fin',NULL,NULL,NULL,NULL,NULL,NULL,'Associação funcional da finalidade','Formulário'),(6,'form_public_LGPD_2080_politicas','Y','Y','Y','Y',NULL,NULL,'Cadastro de políticas','Formulário'),(6,'form_public_LGPD_2085_contratos','Y','','','',NULL,NULL,'Cadastro de contratos','Formulário'),(6,'form_public_LGPD_2090_terceiros','Y','Y','Y','Y',NULL,NULL,'Cadastro de terceiros','Formulário'),(6,'form_public_LGPD_2093_ocorr_terc','Y','Y','Y','Y',NULL,NULL,'Cadastro de ocorrência de terceiros','Formulário'),(6,'form_public_LGPD_2095_med_tec','Y','Y','Y','Y',NULL,NULL,'Cadastro de medidas técnicas','Formulário'),(6,'form_public_LGPD_2097_config_assoc_med_atv',NULL,NULL,NULL,NULL,NULL,NULL,'Associar medidas técnicas aos ativos','Formulário'),(6,'form_public_LGPD_2100_prz_aprv_proc','',NULL,NULL,NULL,NULL,NULL,'[Item de menu] - Configurações / SLA de aprovação de Processos de Negócio: Acesso à configuração do prazo limite para aprovação de Processos de Negócio cadastrados','Formulário'),(6,'form_public_LGPD_3000_riscos','Y','Y','Y','Y',NULL,NULL,'Cadastro de riscos','Formulário'),(6,'form_public_LGPD_4000_atividades','Y','','','Y',NULL,NULL,'Cadastro de atividades','Formulário'),(6,'form_public_LGPD_5000_cod_etica','Y','','','',NULL,NULL,'Cadastro de código de ética','Formulário'),(6,'form_public_LGPD_5100_cod_conduta',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(6,'form_public_LGPD_6000_PDCA','','','','',NULL,NULL,'PDCA','Formulário'),(6,'form_public_LGPD_6100_catalog_treinamentos','Y','','','',NULL,NULL,'Cadastro de catalogo de treinamentos','Formulário'),(6,'form_public_LGPD_6200_agenda_treina','Y','Y','Y','Y',NULL,NULL,'Agenda de treinamentos','Formulário'),(6,'form_public_LGPD_7300_envio_aval_forne','Y','Y','Y','Y',NULL,NULL,'Cadastro de questionários (Due Diligence)','Formulário'),(6,'form_public_LGPD_assoc_contr_6500',NULL,NULL,NULL,NULL,NULL,NULL,'Associação de contratos','Formulário'),(6,'form_public_LGPD_assoc_medtec_6700',NULL,NULL,NULL,NULL,NULL,NULL,'Associação de medidas técnicas','Formulário'),(6,'form_public_LGPD_assoc_pdca_risk_6400',NULL,NULL,NULL,NULL,NULL,NULL,'Associação de riscos ao PDCA','Formulário'),(6,'form_public_LGPD_assoc_pol_6300',NULL,NULL,NULL,NULL,NULL,NULL,'Associação de políticas','Formulário'),(6,'form_public_LGPD_assoc_proc_6600',NULL,NULL,NULL,NULL,NULL,NULL,'Associação de processos','Formulário'),(6,'form_public_LGPD_assoc_treina_6500',NULL,NULL,NULL,NULL,NULL,NULL,'Associação de treinamentos','Formulário'),(6,'form_public_LGPD_config_det_opt_7200','Y','Y','Y','Y',NULL,NULL,'Parametrizar opções do questionário de fornecedores','Formulário'),(6,'form_public_PAC_1000_user_portal',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(6,'Governance_menu',NULL,NULL,NULL,NULL,NULL,NULL,'Menu',NULL),(6,'grid_CMP_0100_faixas',NULL,NULL,NULL,NULL,NULL,NULL,'Consultar faixas de setup de auditoria','Painel'),(6,'grid_CMP_1000_mecanismos','',NULL,NULL,NULL,NULL,NULL,'[Item de menu] - Pilares do Compliance / Mecanismos de Auditoria: Acesso ao cadastro de Mecanismos de Auditoria para projetos de Compliance','Pilares de Compliance'),(6,'grid_CMP_1100_componentes','',NULL,NULL,NULL,NULL,NULL,'[Item de menu] - Pilares do Compliance / Componentes de Auditoria: Acesso ao cadastro de Componentes de Auditoria, que compõem os Mecanismos cadastrados','Pilares de Compliance'),(6,'grid_CMP_1100_entrevistados_desassociados',NULL,NULL,NULL,NULL,NULL,NULL,'Consultas candidatos a entrevistas de ciclo de auditoria ','Painel'),(6,'grid_CMP_1200_questoes','',NULL,NULL,NULL,NULL,NULL,'[Item de menu] - Pilares do Compliance / Questões de Auditoria: Acesso ao cadastro de perguntas que são utilizadas para a realização de auditorias de Compliance','Pilares de Compliance'),(6,'grid_CMP_1300_formularios','',NULL,NULL,NULL,NULL,NULL,'[Item de menu] - Pilares do Compliance / Formulários de Auditoria: Acesso ao cadastro e configuração de Formulários compostos por perguntas para a realização de auditorias de Compliance','Pilares de Compliance'),(6,'grid_CMP_1310_formulario_det',NULL,NULL,NULL,NULL,NULL,NULL,'Consulta detalhes do formulário de auditoria ','Painel'),(6,'grid_CMP_1400_formulas_mestre','',NULL,NULL,NULL,NULL,NULL,'[Item de menu] - Pilares do Compliance / Parâmetros de Ciclos de Auditoria: Acesso à configuração de parâmetros quantitativos utilizados nos Ciclos de Auditoria de Compliance','Pilares de Compliance'),(6,'grid_CMP_1410_formulas_det_mec',NULL,NULL,NULL,NULL,NULL,NULL,'Sub Consulta mecanismos do setup de auditoria','Painel'),(6,'grid_CMP_1500_acao','',NULL,NULL,NULL,NULL,NULL,'[Item de menu] - Pilares do Compliance / Ações de Auditoria: Acesso ao cadastro de ações pré-determinadas para serem sugeridas a partir do levantamento de determinada Questão cadastrada','Pilares de Compliance'),(6,'grid_CMP_1550_ger_acao','',NULL,NULL,NULL,NULL,NULL,'[Item de menu] - Auditoria de Compliance / Recomendações de Auditoria: Acesso à geração automática de recomendações pós Ciclo de Auditoria de Compliance','Auditoria de Compliance'),(6,'grid_CMP_1600_OL','',NULL,NULL,NULL,NULL,NULL,'[Item de menu] - Aspectos Jurídicos / Obrigações Legais: Acesso ao cadastro das obrigações legais que a entidade deve atender em um determinado exercício','Aspectos Jurídicos'),(6,'grid_CMP_2000_ciclos','',NULL,NULL,NULL,NULL,NULL,'[Item de menu] - Auditoria de Compliance / Ciclos de Auditoria: Acesso à gestão de Ciclos de Auditoria de Compliance','Auditoria de Compliance'),(6,'grid_CMP_2500_conf_entrevistados','',NULL,NULL,NULL,NULL,NULL,'[Item de menu] - Auditoria de Compliance / Entrevistados: Acesso à seleção de entrevistados que estarão associados a um Ciclo de Auditoria de Compliance','Auditoria de Compliance'),(6,'grid_CMP_2510_entrevistados_associados',NULL,NULL,NULL,NULL,NULL,NULL,'Relação de entrevistados de um ciclo de auditoria','Painel'),(6,'grid_CMP_3000_aplic_pesq','',NULL,NULL,NULL,NULL,NULL,'[Item de menu] - Auditoria de Compliance / Pesquisas de Auditoria: Acesso à aplicação de Pesquisas de Auditoria de Compliance','Auditoria de Compliance'),(6,'grid_CMP_acompanhar_pesquisas',NULL,NULL,NULL,NULL,NULL,NULL,'Consulta acompanhamento do andamento de pesquisas de auditorias','Painel'),(6,'grid_CMP_resultado_pesquisa','',NULL,NULL,NULL,NULL,NULL,'[Item de menu] - Auditoria de Compliance / Resultados de Auditoria: Acesso à gestão do resultado de Pesquisas de Auditoria de Compliance','Auditoria de Compliance'),(6,'grid_CMP_resultado_pesquisa_questoes',NULL,NULL,NULL,NULL,NULL,NULL,'Consulta resultado da pesquisa de auditoria ','Painel'),(6,'grid_CMP_resultado_pesquisa_status_mecanismo',NULL,NULL,NULL,NULL,NULL,NULL,'Consulta resultado da pesquisa por mecanismos de auditoria ','Painel'),(6,'grid_conf_quest_7100',NULL,NULL,NULL,NULL,NULL,NULL,'Cofiguração de questionário para fornecedores','Painel'),(6,'grid_DOM_tp_ol_1600','',NULL,NULL,NULL,NULL,NULL,'[Item de menu] - Aspectos Jurídicos / Tipos de Obrigações Legais: Acesso ao cadastro de tipos de obrigações legais','Aspectos Jurídicos'),(6,'grid_kanban_atividades',NULL,NULL,NULL,NULL,NULL,NULL,'Kanban de  atividades','Painel'),(6,'grid_kanban_atividades_add_registro',NULL,NULL,NULL,NULL,NULL,NULL,'Kanban de  atividades','Painel'),(6,'grid_LGPD_2001_form_entr_prc','Y',NULL,NULL,NULL,'Y','Y',NULL,'Fluxo de Informação'),(6,'grid_LGPD_2003_envio_entr_prc','Y',NULL,NULL,NULL,'Y','Y',NULL,'Fluxo de Informação'),(6,'grid_LGPD_2040_assoc_prc_atv','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Fluxo de Informação / Associações do Fluxo de Informação: Acesso à consulta das associações entre Processos de Negócio x Ativos de Informação x Artefatos x Metadados Pessoais','Fluxo de Informação'),(6,'grid_LGPD_2075_assoc_funcional_dados_fin',NULL,NULL,NULL,NULL,NULL,NULL,'Consulta associação de metadados','Painel'),(6,'grid_LGPD_2087_ndas','Y',NULL,NULL,NULL,'Y','Y',NULL,'Políticas e Regulamentos'),(6,'grid_LGPD_2097_assoc_med_atv','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Medidas Técnicas de Segurança / Associações com Ativos de Informação: Acesso à configuração da associação entre Medidas Técnicas de Segurança e Ativos de Informação utilizados pela entidade','Medidas Técnicas de Segurança'),(6,'grid_LGPD_3100_assoc_risc_atv','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Riscos / Associações de Riscos: Acesso à associações entre Riscos e outras informações cadastradas','Riscos'),(6,'grid_LGPD_3600_chklst_risk_area_mestre','Y','','','','Y','Y','[Item de menu] - Riscos / Checklist por área de identificação de riscos e atividades','Riscos'),(6,'grid_LGPD_6300_aluno_treina',NULL,NULL,NULL,NULL,NULL,NULL,'Consulta de lista de treinamentos realizados por colaborador','Painel'),(6,'grid_LGPD_7400_resp_aval_forne',NULL,NULL,NULL,NULL,NULL,NULL,'Consulta respostas de questionários  (Due Diligence)','Painel'),(6,'grid_new_pln_acao','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Atividades e Ações / Plano de Ação LGPD: Acesso ao cadastro do documento \"Plano de Ação\" de adequação à LGPD','Atividades e Ações'),(6,'grid_public_LGPD_0100_diagnostico','',NULL,NULL,NULL,NULL,NULL,'[Item de menu] - Configurações / Projeto de Diagnóstico da LGPD: Acesso à configuração das informações sobre o projeto de Diagnóstico da LGPD','Configurações'),(6,'grid_public_LGPD_0200_implement','',NULL,NULL,NULL,NULL,NULL,'[Item de menu] - Configurações / Projeto de Adequação da LGPD: Acesso à configuração das informações sobre o projeto de Adequação da LGPD','Configurações'),(6,'grid_public_LGPD_0300_operacao','',NULL,NULL,NULL,NULL,NULL,'[Item de menu] - Configurações / Projeto de Operação da LGPD: Acesso à configuração das informações sobre a fase de Operação da LGPD','Configurações'),(6,'grid_public_LGPD_0400_etapas','',NULL,NULL,NULL,NULL,NULL,'[Item de menu] - Configurações / Etapas do Diagnóstico da LGPD: Acesso à configuração das etapas do projeto de Diagnóstico de um projeto de adequação à LGPD','Configurações'),(6,'grid_public_LGPD_1000_controlador','',NULL,NULL,NULL,NULL,NULL,'[Item de menu] - Configurações / Entidade: Acesso à configuração dos dados da entidade','Configurações'),(6,'grid_public_LGPD_1001_diretoria','',NULL,NULL,NULL,NULL,NULL,'[Item de menu] - Estrutura Organizacional / Diretoria: Acesso ao cadastro de Diretorias, que é o nível mais alto da hierarquia organizacional da entidade','Estrutura Organizacional'),(6,'grid_public_LGPD_1002_area','',NULL,NULL,NULL,NULL,NULL,'[Item de menu] - Estrutura Organizacional / Área: Acesso ao cadastro de Áreas, que dividem uma determinada Diretoria na estrutura hierárquica da entidade','Estrutura Organizacional'),(6,'grid_public_LGPD_1003_departamento','',NULL,NULL,NULL,NULL,NULL,'[Item de menu] - Estrutura Organizacional / Departamentos: Acesso ao cadastro de Departamentos, que dividem uma determinada Área na estrutura hierárquica da entidade','Estrutura Organizacional'),(6,'grid_public_LGPD_1004_cargos','',NULL,NULL,NULL,NULL,NULL,'[Item de menu] - Estrutura Organizacional / Cargos: Acesso ao cadastro de Cargos a serem ocupados por pessoas da equipe que ocupem espaço na estrutura hierárquica da entidade','Estrutura Organizacional'),(6,'grid_public_LGPD_1050_organograma','',NULL,NULL,NULL,NULL,NULL,'[Item de menu] - Estrutura Organizacional / Lotação: Acesso ao cadastro de unidades de trabalho, onde é possível alocar as equipes da entidade','Estrutura Organizacional'),(6,'grid_public_LGPD_1051_comite','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Estrutura Organizacional / Comitês: Acesso ao cadastro de comitês da entidade, que congregam uma ou mais pessoas previamente cadastradas','Estrutura Organizacional'),(6,'grid_public_LGPD_1053_eventos_comite','',NULL,NULL,NULL,NULL,NULL,'[Item de menu] - Atividades e Ações / Eventos de Comitê: Acesso ao cadastro de eventos associados aos Comitês da entidade','Atividades e Ações'),(6,'grid_public_LGPD_1053_sub_eventos_comite',NULL,NULL,NULL,NULL,NULL,NULL,'Sub Consulta de Eventos','Painel'),(6,'grid_public_LGPD_1100_equipe','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Estrutura Organizacional / Equipe: Acesso ao cadastro de pessoas que podem ocupar cargos na estrutura hierárquica da entidade. Essas pessoas serão associadas a diversas outras entidades tratadas na plataforma','Estrutura Organizacional'),(6,'grid_public_LGPD_2000_proc_aprv_prz_expirado','',NULL,NULL,NULL,NULL,NULL,'[Item de menu] - Atividades e Ações / Processos de Negócio Pendentes: Acesso à gestão de Processos de Negócio com SLA de aprovação expirado','Atividades e Ações'),(6,'grid_public_LGPD_2000_processos','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Fluxo de Informação / Processos de Negócio: Acesso ao cadastro de Processos de Negócio que definem as rotinas operacionais da entidade','Fluxo de Informação'),(6,'grid_public_LGPD_2000_sub_proc_pessoa',NULL,NULL,NULL,NULL,NULL,NULL,'Consulta processo por responsável','Painel'),(6,'grid_public_LGPD_2000_sub_processos_atv',NULL,NULL,NULL,NULL,NULL,NULL,'Consulta processos por ativos','Painel'),(6,'grid_public_LGPD_2010_ativos','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Fluxo de Informação / Ativos de Informação: Acesso ao cadastro de Ativos de Informação utilizados pela entidade na execução de seus Processos de Negócio','Fluxo de Informação'),(6,'grid_public_LGPD_2010_ativos_1',NULL,NULL,NULL,NULL,NULL,NULL,'Consulta Ativos','Painel'),(6,'grid_public_LGPD_2010_ativos_n_utlz_fin',NULL,NULL,NULL,NULL,NULL,NULL,'Processos disponivel para associação com finalidades','Painel'),(6,'grid_public_LGPD_2010_ativos_utlz_fin',NULL,NULL,NULL,NULL,NULL,NULL,'Processos associados a finalidade','Painel'),(6,'grid_public_LGPD_2010_sub_ativos',NULL,NULL,NULL,NULL,NULL,NULL,'Sub Consulta de Ativos','Painel'),(6,'grid_public_LGPD_2020_artefatos','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Fluxo de Informação / Artefatos: Acesso ao cadastro de Artefatos e Documentos tratados nos Ativos de Informação utilizados pela entidade','Fluxo de Informação'),(6,'grid_public_LGPD_2020_artefatos_n_utlz_fin',NULL,NULL,NULL,NULL,NULL,NULL,'Artefatos disponiveis para associação com finalidades','Painel'),(6,'grid_public_LGPD_2020_artefatos_utlz_fin',NULL,NULL,NULL,NULL,NULL,NULL,'Artefatos associados a finalidades','Painel'),(6,'grid_public_LGPD_2030_assoc_art_metadados',NULL,NULL,NULL,NULL,NULL,NULL,'Associação de Artefatos e metadados','Painel'),(6,'grid_public_LGPD_2030_dados','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Fluxo de Informação / Metadados Pessoais: Acesso ao cadastro de Metadados Pessoais presentes nos diferentes Artefatos utilizados pela entidade','Fluxo de Informação'),(6,'grid_public_LGPD_2065_fund_legal','',NULL,NULL,NULL,NULL,NULL,'[Item de menu] - Aspectos Jurídicos / Fundamentos Legais: Acesso ao cadastro de Fundamentos Legais utilizados pela entidade','Aspectos Jurídicos'),(6,'grid_public_LGPD_2066_ambiente_reg','',NULL,NULL,NULL,NULL,NULL,'[Item de menu] - Aspectos Jurídicos / Ambientes regulatórios: Acesso ao cadastro de Ambientes Regulatórios a serem associados a Fundamentos Legais utilizados pela entidade','Aspectos Jurídicos'),(6,'grid_public_LGPD_2070_finalidades','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Tratamento de Dados Pessoais / Parametrizar Finalidades de Tratamentos: Acesso à configuração dos aspectos e detalhes das Finalidades de Tratamento de Dados Pessoais previamente cadastradas','Tratamento de Dados Pessoais'),(6,'grid_public_LGPD_2070_registrar_finalidades','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Tratamento de Dados Pessoais / Registrar Finalidade de Tratamento: Acesso ao cadastro de Finalidades de Tratamento de Dados Pessoais executadas pela entidade','Tratamento de Dados Pessoais'),(6,'grid_public_LGPD_2070_sub_contratos_finalidades',NULL,NULL,NULL,NULL,NULL,NULL,'Sub consulta de contratos dentro da finalidade','Painel'),(6,'grid_public_LGPD_2070_sub_finalidades',NULL,NULL,NULL,NULL,NULL,NULL,'Sub consulta de finalidades','Painel'),(6,'grid_public_LGPD_2073_assoc_ativos_fin',NULL,NULL,NULL,NULL,NULL,NULL,'Associação de ativos na finalidade','Painel'),(6,'grid_public_LGPD_2075_assoc_metadados_fin',NULL,NULL,NULL,NULL,NULL,NULL,'Associação de metadados na finalidade','Painel'),(6,'grid_public_LGPD_2080_politicas','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Políticas e Regulamentos / Políticas: Acesso ao cadastro de políticas associadas à Governança de Privacidade da entidade','Políticas e Regulamentos'),(6,'grid_public_LGPD_2085_contratos','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Políticas e Regulamentos / Contratos: Acesso ao cadastro de contratos e modelos de contratos utilizados pela entidade','Políticas e Regulamentos'),(6,'grid_public_LGPD_2090_terceiros','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Gestão de terceiros / Terceiros: Acesso ao cadastro de entidades terceiras (PJ ou PF) associadas à entidade','Gestão de Terceiros'),(6,'grid_public_LGPD_2093_ocorr_terc','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Gestão de terceiros / Ocorrências: Acesso ao cadastro de ocorrências relacionadas à Terceiros associados à entidade','Gestão de Terceiros'),(6,'grid_public_LGPD_2095_med_tec','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Medidas Técnicas de Segurança / Medidas Técnicas de Segurança: Acesso ao cadastro de Medidas Técnicas de Segurança da Informação que podem ser associadas a Ativos cadastrados','Medidas Técnicas de Segurança'),(6,'grid_public_LGPD_2095_sub_med_tec',NULL,NULL,NULL,NULL,NULL,NULL,'Sub Consulta de medidas técnicas','Painel'),(6,'grid_public_LGPD_3000_riscos','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Riscos / Riscos: Acesso ao cadastro de Riscos de Privacidade e Compliance','Riscos'),(6,'grid_public_LGPD_3000_sub_consulta_riscos',NULL,NULL,NULL,NULL,NULL,NULL,'Sub consulta de riscos','Painel'),(6,'grid_public_LGPD_3300_assoc_risc_prc',NULL,NULL,NULL,NULL,NULL,NULL,'Associar risco a processos','Painel'),(6,'grid_public_LGPD_4000_atividades','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Atividades e Ações / Atividades e Ações: Acesso ao cadastro de atividades e ações de governança e compliance','Atividades e Ações'),(6,'grid_public_LGPD_5000_cod_etica','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Políticas e Regulamentos / Códigos e Regulamentos Internos: Acesso ao cadastro de documentos que definem as regras internas de Compliance da entidade','Políticas e Regulamentos'),(6,'grid_public_LGPD_5100_cod_conduta',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(6,'grid_public_LGPD_6000_PDCA','',NULL,NULL,NULL,NULL,NULL,'[Item de menu] - Atividades e Ações / Gestão de ciclo de PDCA de Compliance: Acesso ao planejamento e gestão de ciclos de PDCA de Compliance','Atividades e Ações'),(6,'grid_public_LGPD_6000_SUB_PDCA',NULL,NULL,NULL,NULL,NULL,NULL,'Sub consulta PDCA','Painel'),(6,'grid_public_LGPD_6100_catalog_treinamentos','',NULL,NULL,NULL,NULL,NULL,'[Item de menu] - Atividades e Ações / Catálogo de treinamentos: Acesso ao cadastro dos tipos de treinamentos que a entidade pode executar para suas equipes','Atividades e Ações'),(6,'grid_public_LGPD_6200_agenda_treina','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Atividades e Ações / Agenda de Treinamentos: Acesso à gestão de agenda de treinamentos e capacitações internas da entidade','Atividades e Ações'),(6,'grid_public_LGPD_7300_envio_aval_forne',NULL,NULL,NULL,NULL,NULL,NULL,'Consulta de questionários (Due Diligence)','Painel'),(6,'grid_public_LGPD_7300_envio_aval_forne_gerencial','Y',NULL,NULL,NULL,'Y','Y',NULL,'Gestão de Terceiros'),(6,'grid_public_LGPD_cons_rev_contr_6500',NULL,NULL,NULL,NULL,NULL,NULL,'Consulta revisões de contrato','Painel'),(6,'grid_public_LGPD_cons_rev_medtec_6700',NULL,NULL,NULL,NULL,NULL,NULL,'Consulta revisões de medidas técnicas','Painel'),(6,'grid_public_LGPD_cons_rev_pol_6300',NULL,NULL,NULL,NULL,NULL,NULL,'Consulta revisão de políticas','Painel'),(6,'grid_public_LGPD_cons_rev_proc_6600',NULL,NULL,NULL,NULL,NULL,NULL,'Consulta revisão de processos','Painel'),(6,'grid_public_LGPD_cons_rev_risk_6400',NULL,NULL,NULL,NULL,NULL,NULL,'Consulta revisão de riscos','Painel'),(6,'grid_public_PAC_9000_DPIA',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(6,'grid_public_PAC_9100_LIA',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(6,'grid_public_PCP_9000_DPIA',NULL,NULL,NULL,NULL,NULL,NULL,'Consulta DPIA',NULL),(6,'grid_public_pcp_9100_LIA',NULL,NULL,NULL,NULL,NULL,NULL,'Consulta LIA ',NULL),(6,'grid_public_subconsulta_sec_users',NULL,NULL,NULL,NULL,NULL,NULL,'Sub consulta de usuarios','Painel'),(6,'grid_sc_log','',NULL,NULL,NULL,NULL,NULL,'[Item de menu] - Segurança / Histórico de acessos: Acesso à consulta à histórico de acessos de usuários à plataforma','Segurança'),(6,'help_cadastro_titulares',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(6,'help_ciclo_de_vida',NULL,NULL,NULL,NULL,NULL,NULL,'Help Ciclo de vida','Painel'),(6,'help_finalidades_fundamentos',NULL,NULL,NULL,NULL,NULL,NULL,'Help Finalidades','Painel'),(6,'help_geracao_atividades',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(6,'help_geracao_riscos',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(6,'help_gestao_consentimentos',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(6,'help_gestao_incidentes',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(6,'help_gestao_notificacao',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(6,'help_integracao_portais',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(6,'help_lotes_validacao',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(6,'help_medidas_administrativas',NULL,NULL,NULL,NULL,NULL,NULL,'Help medidas administrativas','Painel'),(6,'help_medidas_tecnicas',NULL,NULL,NULL,NULL,NULL,NULL,'Help para medidas técnicas','Painel'),(6,'help_plano_acao_atividades',NULL,NULL,NULL,NULL,NULL,NULL,'Help Atividades','Painel'),(6,'help_relatorios',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(6,'help_riscos_e_impactos',NULL,NULL,NULL,NULL,NULL,NULL,'Help Riscos','Painel'),(6,'homepage',NULL,NULL,NULL,NULL,NULL,NULL,'Home Page (Responsábilidades e Atividades)','Painel'),(6,'homepage_help',NULL,NULL,NULL,NULL,NULL,NULL,'Help','Painel'),(6,'mapa_calor_risco',NULL,NULL,NULL,NULL,NULL,NULL,'Mapa de risco','Painel'),(6,'Mapa_Calor_Riscos',NULL,NULL,NULL,NULL,NULL,NULL,'Mapa de calor de riscos ','Painel'),(6,'menu',NULL,NULL,NULL,NULL,NULL,NULL,'Menu PCP','Painel'),(6,'menu_dinamico',NULL,NULL,NULL,NULL,NULL,NULL,'Menu','Painel'),(6,'Menu_Pac',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(6,'Metadados','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Painel / Metadados Pessoais: Acesso à exibição dos principais indicadores sobre Metadados Pessoais','Painel'),(6,'novo_menu',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(6,'pac_app_change_pswd','Y','','','','','','[Item de menu] - SeguranÃ§a / AlteraÃ§Ã£o de senha: Acesso Ã  gestÃ£o de senhas de usuÃ¡rios da plataforma','SeguranÃ§a'),(6,'pac_app_form_sec_groups_apps','',NULL,NULL,NULL,NULL,NULL,'[Item de menu] - SeguranÃ§a / AssociaÃ§Ã£o de perfis a aplicaÃ§Ãµes: Acesso Ã  configuraÃ§Ã£o da associaÃ§Ã£o de perfis de acesso com as aplicaÃ§Ãµes da plataforma','SeguranÃ§a'),(6,'pac_app_grid_sec_apps','',NULL,NULL,NULL,NULL,NULL,'[Item de menu] - SeguranÃ§a / AplicaÃ§Ãµes: Acesso ao cadastro de aplicaÃ§Ãµes da plataforma','SeguranÃ§a'),(6,'pac_app_grid_sec_groups','',NULL,NULL,NULL,NULL,NULL,'[Item de menu] - SeguranÃ§a / Perfis: Acesso ao cadastro de perfis de acesso dos usuÃ¡rios da plataforma','SeguranÃ§a'),(6,'pac_app_grid_sec_users','',NULL,NULL,NULL,NULL,NULL,'[Item de menu] - SeguranÃ§a / UsuÃ¡rios: Acesso ao cadastro de usuÃ¡rios da plataforma','SeguranÃ§a'),(6,'pac_app_grid_sec_users_groups','',NULL,NULL,NULL,NULL,NULL,'[Item de menu] - SeguranÃ§a / AssociaÃ§Ã£o de usuÃ¡rios a perfis: Acesso Ã  configuraÃ§Ã£o da associaÃ§Ã£o de usuÃ¡rios a perfis de acesso','SeguranÃ§a'),(6,'pac_app_search_sec_groups','',NULL,NULL,NULL,NULL,NULL,'[Item de menu] - SeguranÃ§a / AssociaÃ§Ã£o de perfis a aplicaÃ§Ãµes: Acesso Ã  configuraÃ§Ã£o da associaÃ§Ã£o de perfis de acesso com as aplicaÃ§Ãµes da plataforma','SeguranÃ§a'),(6,'pac_menu',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(6,'PAG_menu',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(6,'param_aval_mestre_7000','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Gestão de terceiros / Formulários de due diligence: Acesso à criação de formulários (e suas questões) para auto avaliação de terceiros','Gestão de Terceiros'),(6,'PDCA','',NULL,NULL,NULL,NULL,NULL,'[Item de menu] - Painel / Ciclos de PDCA: Acesso à exibição dos principais indicadores sobre Ciclos de PDCA de Compliance','Painel'),(6,'pdfreport_LGPD_7300_envio_aval_forne',NULL,NULL,NULL,NULL,NULL,NULL,'geração de PDF - questionário (Due Diligence)','Painel'),(6,'popup_confirm_action',NULL,NULL,NULL,NULL,NULL,NULL,'Pop-up ( não se aplica ao módulo de segirança)','Painel'),(6,'popup_confirm_action_status',NULL,NULL,NULL,NULL,NULL,NULL,'Pop_Up ( Não se plaica ao módulo de segurança ) ','Painel'),(6,'Processos','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Painel / Processos de Negócio: Acesso à exibição dos principais indicadores sobre Processos de Negócio','Painel'),(6,'relatorio_ciclos_complience',NULL,NULL,NULL,NULL,NULL,NULL,'Extrato de cilco de auditoria ','Painel'),(6,'relatorio_dpia',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(6,'relatorio_dpia_1',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(6,'relatorio_finalidades',NULL,NULL,NULL,NULL,NULL,NULL,'Relatório de finalidades','Painel'),(6,'relatorio_lia',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(6,'relatorio_notificacao',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(6,'relatorio_resp_aval',NULL,NULL,NULL,NULL,NULL,NULL,'Relatório Avaliações','Painel'),(6,'resumo_finalidade',NULL,NULL,NULL,NULL,NULL,NULL,'Resumo de finalidade','Painel'),(6,'Riscos','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Painel / Riscos: Acesso à exibição dos principais indicadores sobre Gestão de Riscos de Privacidade e Compliance','Painel'),(6,'risk_heat_map','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Riscos / Mapa de Calor: Acesso à exibição do Mapa de Calor dos Riscos cadastrados','Riscos'),(6,'search_public_LGPD_4000_atividades',NULL,NULL,NULL,NULL,NULL,NULL,'Filtro de atividades','Painel'),(6,'sec_change_pswd',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(6,'sec_form_add_users',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(6,'sec_form_edit_users',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(6,'sec_form_sec_apps',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(6,'sec_form_sec_groups',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(6,'sec_form_sec_groups_apps',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(6,'sec_grid_sec_apps',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(6,'sec_grid_sec_groups',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(6,'sec_grid_sec_users',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(6,'sec_grid_sec_users_groups',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(6,'sec_Login',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(6,'sec_menu',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(6,'sec_retrieve_pswd',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(6,'sec_search_sec_groups',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(6,'sec_settings',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(6,'sec_sync_apps',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(6,'sub_consulta_3000_riscos_incidente',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(6,'sub_consulta_3100_assoc_risc_atv',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(6,'sub_consulta_3300_assoc_risc_prc',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(6,'sub_consulta_3400_assoc_risc_fin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(6,'sub_consulta_CMP_1610_ol_agenda',NULL,NULL,NULL,NULL,NULL,NULL,'Sub consulta de agenda de obrigações legais por obrigação','Painel'),(6,'sub_consulta_CMP_2510_det_conf_entrevistados',NULL,NULL,NULL,NULL,NULL,NULL,'Entrevitados em presquisa de auditoria --> Sub Consulta de configuração de entrevidados de pesquisa de auditoria ','Painel'),(6,'sub_consulta_CMP_3000_aplic',NULL,NULL,NULL,NULL,NULL,NULL,'Sub consulta status da aplicação de pesquisa de auditoria','Painel'),(6,'sub_consulta_CMP_4000_respostas_mestre',NULL,NULL,NULL,NULL,NULL,NULL,'Sub consulta status de respostas dos formulários de auditoria dentro de um ciclo ','Painel'),(6,'sub_consulta_configurar_metadados',NULL,NULL,NULL,NULL,NULL,NULL,'Sub consulta configuração de metadados','Painel'),(6,'sub_consulta_LGPD_2097_assoc_med_atv',NULL,NULL,NULL,NULL,NULL,NULL,'Sub consulta de associação entre medidas técnicas e ativos','Painel'),(6,'sub_consulta_LGPD_6200_agenda_treina',NULL,NULL,NULL,NULL,NULL,NULL,'Sub consulta de agenda de treinamentos ','Painel'),(6,'sub_consulta_PAC_1100_sol_portal',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(6,'sub_consulta_PAC_3200_tit_consent',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(6,'sub_consulta_PAC_4000_notificacao',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(6,'sub_consulta_PAG_ocorr_lote_1100',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(6,'sub_form_configurar_metados',NULL,NULL,NULL,NULL,NULL,NULL,'Configurar metadados','Painel'),(6,'sub_grid_CMP_1550_ger_acao',NULL,NULL,NULL,NULL,NULL,NULL,'Sub grid de recomendaçoes de auditoria por ciclo','Painel'),(6,'sub_grid_LGPD_2050_assoc_atv_art',NULL,NULL,NULL,NULL,NULL,NULL,'Sub consulta de associação entre ativos e artefatos',NULL),(6,'sub_grid_PAC_1400_tit_afet_inc',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(6,'sub_grid_public_LGPD_2093_ocorr_terc',NULL,NULL,NULL,NULL,NULL,NULL,'Sub consulta ocorrência de terceiros','Painel'),(7,'app_change_pswd','',NULL,NULL,NULL,NULL,NULL,'[Item de menu] - Segurança / Alteração de senha: Acesso à gestão de senhas de usuários da plataforma','Segurança'),(7,'app_form_add_users','','','','',NULL,NULL,'Cadastrar usuários','Formulário'),(7,'app_form_edit_users','','','','',NULL,NULL,'Alterar usuários','Formulário'),(7,'app_form_sec_apps','','','','',NULL,NULL,'Cadastrar aplicações','Formulário'),(7,'app_form_sec_groups','','','','',NULL,NULL,'Cadastro de grupos de usuários','Formulário'),(7,'app_form_sec_groups_apps','','','','',NULL,NULL,'Associar grupos x aplicações','Painel'),(7,'app_grid_sec_apps','',NULL,NULL,NULL,NULL,NULL,'[Item de menu] - Segurança / Aplicações: Acesso ao cadastro de aplicações da plataforma','Segurança'),(7,'app_grid_sec_groups','',NULL,NULL,NULL,NULL,NULL,'[Item de menu] - Segurança / Perfis: Acesso ao cadastro de perfis de acesso dos usuários da plataforma','Segurança'),(7,'app_grid_sec_users','',NULL,NULL,NULL,NULL,NULL,'[Item de menu] - Segurança / Usuários: Acesso ao cadastro de usuários da plataforma','Segurança'),(7,'app_grid_sec_users_groups','',NULL,NULL,NULL,NULL,NULL,'[Item de menu] - Segurança / Associação de usuários a perfis: Acesso à configuração da associação de usuários a perfis de acesso','Segurança'),(7,'app_Login',NULL,NULL,NULL,NULL,NULL,NULL,'Login',NULL),(7,'app_menu',NULL,NULL,NULL,NULL,NULL,NULL,'Menu','Painel'),(7,'app_retrieve_pswd',NULL,NULL,NULL,NULL,NULL,NULL,'Esqueceu a senha','Painel'),(7,'app_search_sec_groups','',NULL,NULL,NULL,NULL,NULL,'[Item de menu] - Segurança / Associação de perfis a aplicações: Acesso à configuração da associação de perfis de acesso com as aplicações da plataforma','Segurança'),(7,'app_settings','',NULL,NULL,NULL,NULL,NULL,'Configurações de segurança','Segurança'),(7,'app_sync_apps','',NULL,NULL,NULL,NULL,NULL,'Sincronização de aplicações','Segurança'),(7,'Artefatos','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Painel / Artefatos: Acesso à exibição dos principais indicadores sobre Artefatos e Documentos','Painel'),(7,'associar_metadados_finalidade',NULL,NULL,NULL,NULL,NULL,NULL,'Associar metadados na finalidade','Painel'),(7,'associar_metadados_finalidade_new',NULL,NULL,NULL,NULL,NULL,NULL,'Associar metadados a finalidades','Painel'),(7,'Atividades','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Painel / Atividades e Ações: Acesso à exibição dos principais indicadores sobre Atividades e Ações','Painel'),(7,'Ativos','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Painel / Ativos de Informação: Acesso à exibição dos principais indicadores sobre Ativos de Informação','Painel'),(7,'Auto_cadastro_PAC_4000_notificacao',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(7,'blank_email',NULL,NULL,NULL,NULL,NULL,NULL,'Enviar mail','Painel'),(7,'blank_pipeline','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Atividades e Ações / Meu Quadro de Atividades: Acesso ao Kanban de atividades do usuário logado','Atividades e Ações'),(7,'blank_pipeline_Ajax',NULL,NULL,NULL,NULL,NULL,NULL,'Pipeline de atividades','Painel'),(7,'cad_sol_dpia_pcp_9000','Y',NULL,NULL,NULL,'Y','Y',NULL,'Fluxo de Informação'),(7,'Cadastro_DEN_1000_registro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(7,'Cadastro_DEN_1100_cat',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(7,'cadastro_PAC_1110_atv_sol',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(7,'cadastro_PAC_1200_sla_sol_portal',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(7,'Cadastro_PAC_1400_titulares',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(7,'Cadastro_PAC_1410_dados_tit',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(7,'Cadastro_PAC_2000_incidentes',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(7,'Cadastro_PAC_2100_sla_notificacao',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(7,'Cadastro_PAC_3100_env_consent',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(7,'Cadastro_PAC_4000_notificacao',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(7,'Cadastro_PAG_lote_1000',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(7,'cadastro_PAG_ocorr_lote_1100',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(7,'calendar_app',NULL,NULL,NULL,NULL,NULL,NULL,'Calendário','Painel'),(7,'calendar_public_LGPD_4000_atividades',NULL,NULL,NULL,NULL,NULL,NULL,'Calendário de atividades ( DPO )','Painel'),(7,'chart_public_LGPD_2000_processos_complex',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico processo por complexidade','Painel'),(7,'chart_public_LGPD_2000_processos_geral',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico processos','Painel'),(7,'chart_public_LGPD_2000_processos_resp',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico processos por responsável','Painel'),(7,'chart_public_LGPD_2000_status_processos',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico processo por status','Painel'),(7,'chart_public_LGPD_2000_tipo_processo',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico processos por tipo','Painel'),(7,'chart_public_LGPD_2010_confia_ativos',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico confibilidade dos ativos','Painel'),(7,'chart_public_LGPD_2010_disp_ativos',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico ativos por nível de disponibilidade','Painel'),(7,'chart_public_LGPD_2010_integridade_ativos',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico ativos por nível de integridade','Painel'),(7,'chart_public_LGPD_2010_resp_ativos',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico ativos por responsável','Painel'),(7,'chart_public_LGPD_2010_tipo_ativos',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico tipos de ativos','Painel'),(7,'chart_public_LGPD_2020_artefat_contrato',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico artefatos tipo contrato','Painel'),(7,'chart_public_LGPD_2020_contrato_artefatos',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico contratos x artefatos','Painel'),(7,'chart_public_LGPD_2020_tipo_artefatos',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico artefatos por tipo','Painel'),(7,'chart_public_LGPD_2030_classif_dados',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico classificação de metadados','Painel'),(7,'chart_public_LGPD_2030_dados_anonimizavel',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico metadados anonimizavel','Painel'),(7,'chart_public_LGPD_2030_tipif_dados',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico tipos de dados','Painel'),(7,'chart_public_LGPD_2070_fin_compart_dados',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico finalidades por compartilhamento','Painel'),(7,'chart_public_LGPD_2070_fin_dad_criancas',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico finalidades por dados de crianças','Painel'),(7,'chart_public_LGPD_2070_fin_faz_descarte',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico finalidades por descarte','Painel'),(7,'chart_public_LGPD_2070_fin_frequencia',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico finalidades por ferequencia','Painel'),(7,'chart_public_LGPD_2070_fin_hipoteses',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico finalidades por hipóteses de tratamento','Painel'),(7,'chart_public_LGPD_2070_fin_papel',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico papel da entidade','Painel'),(7,'chart_public_LGPD_2070_fin_processos',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico finalidades por processos','Painel'),(7,'chart_public_LGPD_2070_fin_rot_automatizada',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico finalidades por rotinas automatizadas','Painel'),(7,'chart_public_LGPD_2070_fin_utlz_operador',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico finalidades por utiliza operador','Painel'),(7,'chart_public_LGPD_2070_fin_volumetria',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico finliadades por volumetria','Painel'),(7,'chart_public_LGPD_3000_categoria_riscos',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico riscos por categoria','Painel'),(7,'chart_public_LGPD_3000_criticidade_riscos',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico riscos por criticidade','Painel'),(7,'chart_public_LGPD_3000_estrategia_riscos',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico riscos por estratégia','Painel'),(7,'chart_public_LGPD_3000_impacto_riscos',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico riscos por impacto','Painel'),(7,'chart_public_LGPD_3000_prob_riscos',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico riscos por probabilidade','Painel'),(7,'chart_public_LGPD_3000_resp_riscos',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico riscos por responsáveis','Painel'),(7,'chart_public_LGPD_3000_status_riscos',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico riscos por status','Painel'),(7,'chart_public_LGPD_4000_atividades_geral',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico atividades','Painel'),(7,'chart_public_LGPD_4000_disc_atividades',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico atividades por disciplina','Painel'),(7,'chart_public_LGPD_4000_etapa_atividades',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico atividades por etapas','Painel'),(7,'chart_public_LGPD_4000_resp_atividades',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico atividades por responsável','Painel'),(7,'chart_public_LGPD_4000_status_resp_atividade',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico atividades por responsável e status','Painel'),(7,'chart_public_LGPD_assoc_pdca_contr_6500',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico PDCA de contratos','Painel'),(7,'chart_public_LGPD_assoc_pdca_finalizados_treina_6500',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico PDCA de treinamentos','Painel'),(7,'chart_public_LGPD_assoc_pdca_medtec_6700',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico PDCA de medidas técnicas','Painel'),(7,'chart_public_LGPD_assoc_pdca_pol_6300',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico PDCA de políticas','Painel'),(7,'chart_public_LGPD_assoc_pdca_proc_6600',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico PDCA de processos','Painel'),(7,'chart_public_LGPD_assoc_pdca_realizar_treina_6500',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico PDCA realização de treinamentos','Painel'),(7,'chart_public_LGPD_assoc_pdca_risk_6400',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico PDCA de riscos','Painel'),(7,'cons_dad_nao_utlz_LGPD_2030_dados','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Fluxo de Informação / Metadados Pessoais não utilizados: Acesso à consulta dos Metadados Pessoais cadastrados mas não utilizados em nenhuma associação','Fluxo de Informação'),(7,'cons_minhas_obr_CMP_1610_ol_agenda','',NULL,NULL,NULL,NULL,NULL,'[Item de menu] - Aspectos Jurídicos / Minhas Obrigações Legais: Acesso ao cadastro das obrigações legais da entidade que estão sob a responsabilidade do usuário logado','Aspectos Jurídicos'),(7,'Consulta_DEN_1000_registro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(7,'Consulta_DEN_1100_cat',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(7,'consulta_gerencial_CMP_1610_ol_agenda','',NULL,NULL,NULL,NULL,NULL,'[Item de menu] - Aspectos Jurídicos / Acompanhamento de Obrigações Legais: Acesso ao painel de acompanhamento do status das obrigações legais da entidade','Aspectos Jurídicos'),(7,'consulta_gerencial_LGPD_4000_atividades','',NULL,NULL,NULL,NULL,NULL,'[Item de menu] - Atividades e Ações / Acompanhamento de Atividades e Ações: Acesso ao painel de acompanhamento do status das obrigações legais da entidade','Atividades e Ações'),(7,'Consulta_LGPD_3000_riscos_assistant',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(7,'Consulta_LGPD_4000_atividades_assistant',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(7,'Consulta_PAC_1000_user_portal',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(7,'Consulta_PAC_1100_sol_portal',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(7,'consulta_PAC_1200_sla_sol_portal',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(7,'Consulta_PAC_1400_titulares',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(7,'Consulta_PAC_1410_dados_tit',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(7,'Consulta_PAC_2000_incidentes',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(7,'Consulta_PAC_3100_env_consent',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(7,'Consulta_PAC_4000_notificacao',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(7,'Consulta_PAG_lote_1000',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(7,'Consulta_public_LGPD_3000_riscos',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(7,'control_calendar',NULL,NULL,NULL,NULL,NULL,NULL,'Meu calendário de atividades de adequação',NULL),(7,'control_login',NULL,NULL,NULL,NULL,NULL,NULL,'Login','Painel'),(7,'control_login_diligence',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(7,'esqueci_senha',NULL,NULL,NULL,NULL,NULL,NULL,'Esqueceu a senha','Painel'),(7,'extrato_pdca',NULL,NULL,NULL,NULL,NULL,NULL,'Extrato PDCA','Painel'),(7,'Finalidades','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Painel / Finalidades de Tratamento de Dados Pessoais: Acesso à exibição dos principais indicadores sobre Finalidades de Tratamento de Dados Pessoais','Painel'),(7,'form_aval_7000','Y',NULL,NULL,NULL,'Y','Y','Formulários de due diligence: Acesso à criação de formulários (e suas questões) para auto avaliação de terceiros','Gestão de Terceiros'),(7,'form_CMP_1000_mecanismos','','','','',NULL,NULL,'Cadastro de mecanismos de auditoria ','Formulário'),(7,'form_CMP_1100_componentes','','','','',NULL,NULL,'Cadastro de componentes de auditoria','Formulário'),(7,'form_CMP_1200_questoes','','','','',NULL,NULL,'Cadastro de questões de auditoria','Formulário'),(7,'form_CMP_1300_formularios','','','','',NULL,NULL,'Cadatro de formulários de auditoria ','Formulário'),(7,'form_CMP_1300_formularios_edit','','','','',NULL,NULL,'Edição de formulários de auditoria','Formulário'),(7,'form_CMP_1400_formulas_mestre','','','','',NULL,NULL,'Parametrização de Setup de Auditoria','Formulário'),(7,'form_CMP_1400_formulas_view','','','','',NULL,NULL,'Visualizar setup de auditoria','Formulário'),(7,'form_CMP_1410_formulas_det_mec','','','','',NULL,NULL,'Parametrizar mecanismos de auditoria no setup','Formulário'),(7,'form_CMP_1420_formulas_det_niv_ad','','','','',NULL,NULL,'Parametrizar níveis de aderência do setup de auditoria ','Formulário'),(7,'form_CMP_1430_formulas_det_lim','','','','',NULL,NULL,'Parametrizar faixas do setup de auditoria','Formulário'),(7,'form_CMP_1500_acao','','','','',NULL,NULL,'Recomendações de auditorias','Formulário'),(7,'form_CMP_1600_OL','','','','',NULL,NULL,'Cadastro de Obrigações Legais ','Formulário'),(7,'form_CMP_2000_ciclos','','','','',NULL,NULL,'Cadastro de ciclos de auditoria','Formulário'),(7,'form_CMP_2500_conf_entrevistados','','','','',NULL,NULL,'Cadastro de entrevistados do ciclo de auditoria ','Formulário'),(7,'form_CMP_2500_conf_entrevistados_1','','','','',NULL,NULL,'Cadastro de entrevistados ','Formulário'),(7,'form_CMP_2500_conf_param_entrevistados','','','','',NULL,NULL,'Parametrizar relação de entrevistados de um ciclo de auditoria','Formulário'),(7,'form_CMP_3000_aplic_pesq','','','','',NULL,NULL,'Cadastro de aplicação de pesquisa de auditorias ','Formulário'),(7,'form_CMP_resultados_pesquisas','','','','',NULL,NULL,'Cadastro de resultado de pesquisas de auditoria','Formulário'),(7,'form_conf_quest_7100','Y','','','',NULL,NULL,'Configurar questionário de fornecedores','Formulário'),(7,'form_diligence',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(7,'form_DOM_tp_ol_1600','','','','',NULL,NULL,'Cadastro de tipos de obrigações ','Formulário'),(7,'form_kanban_atividades','Y','','','Y',NULL,NULL,'Kanban de  atividades','Formulário'),(7,'form_kanban_atividades_add_registro','Y','','','Y',NULL,NULL,'Cadastrar atividades pelo kanban','Formulário'),(7,'form_LGPD_0002_conf_smpt','',NULL,NULL,NULL,NULL,NULL,'[Item de menu] - Configurações / Configuração de envio de e-mails: Acesso à configuração do endereço de de SMTP para envio de e-mails da plataforma','Formulário'),(7,'form_LGPD_2001_form_entr_prc','Y',NULL,NULL,NULL,'Y','Y',NULL,'Fluxo de Informação'),(7,'form_LGPD_2003_envio_entr_prc','Y',NULL,NULL,NULL,'Y','Y',NULL,'Fluxo de Informação'),(7,'form_LGPD_2087_ndas','Y',NULL,NULL,NULL,'Y','Y',NULL,'Fluxo de Informação'),(7,'form_LGPD_2097_assoc_med_atv',NULL,NULL,NULL,NULL,NULL,NULL,'Cadastro de Medidas Técnicas - > Cadastro da especificação da associação entre medida técnica e ativo','Painel'),(7,'form_LGPD_3500_checklist_risk_padrao','Y','','','','Y','Y','[Item de menu] - Riscos / Checklist padrão de identificação de riscos e atividades','Riscos'),(7,'form_LGPD_3600_chklst_risk_area_mestre','Y','','','','Y','Y','Formulário de checklist por área de identificação de riscos e atividades','Riscos'),(7,'form_LGPD_4000_atividades','Y','','','Y',NULL,NULL,'Cadastro de atividades de adequação','Formulário'),(7,'form_LGPD_4000_atividades_calendar',NULL,NULL,NULL,NULL,NULL,NULL,'Cadastro de atividades de adequação','Formulário'),(7,'form_minhas_obr_CMP_1610_ol_agenda',NULL,NULL,NULL,NULL,NULL,NULL,'Edição das minhas obrigações legais ','Painel'),(7,'form_new_pln_acao','Y','','','',NULL,NULL,'Cadastrar plano de ação','Formulário'),(7,'form_PAC_1100_sol_portal',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(7,'form_pcp_9100_LIA','Y',NULL,NULL,NULL,'Y','Y',NULL,'Fluxo de Informação'),(7,'form_public_LGPD_0100_diagnostico','Y','','','',NULL,NULL,'Parametrizar etapa de diagnóstico','Formulário'),(7,'form_public_LGPD_0200_implement','Y','','','',NULL,NULL,'Parametrizar etapa de implementação','Formulário'),(7,'form_public_LGPD_0300_operacao','Y','','','',NULL,NULL,'Parametrizar etapa de operação','Formulário'),(7,'form_public_LGPD_0400_etapas','Y','','','',NULL,NULL,'Parametrizar etapas','Formulário'),(7,'form_public_LGPD_1000_controlador','Y','','','',NULL,NULL,'Cadastro de controlador','Formulário'),(7,'form_public_LGPD_1001_diretoria','Y','','','',NULL,NULL,'Cadastro de diretoria','Formulário'),(7,'form_public_LGPD_1002_area','Y','','','',NULL,NULL,'Cadastro de área','Formulário'),(7,'form_public_LGPD_1003_departamento','Y','','','',NULL,NULL,'Cadastro de departamentos','Formulário'),(7,'form_public_LGPD_1004_cargos','Y','','','',NULL,NULL,'Cadastro de cargos','Formulário'),(7,'form_public_LGPD_1050_organograma','Y','','','',NULL,NULL,'Cadastro de organograma','Formulário'),(7,'form_public_LGPD_1051_comite','Y','Y','Y','Y',NULL,NULL,'Cadastro de comitê','Formulário'),(7,'form_public_LGPD_1053_eventos_comite','Y','Y','Y','Y',NULL,NULL,'Agenda de eventos do comitê','Formulário'),(7,'form_public_LGPD_1100_equipe','Y','','','',NULL,NULL,'Cadastro de equipe','Formulário'),(7,'form_public_LGPD_1100_equipe_1','Y','','','',NULL,NULL,'Cadastro de equipe','Formulário'),(7,'form_public_LGPD_2000_processos','Y','','','',NULL,NULL,'Cadastro de processos','Formulário'),(7,'form_public_LGPD_2010_ativos','','','','',NULL,NULL,'Cadastro de ativos','Formulário'),(7,'form_public_LGPD_2020_artefatos','','','','',NULL,NULL,'Cadastro de artefatos','Formulário'),(7,'form_public_LGPD_2030_dados','','','','',NULL,NULL,'Cadastro de metadados','Formulário'),(7,'form_public_LGPD_2060_config_assoc',NULL,NULL,NULL,NULL,NULL,NULL,'Associação artefato x metadados','Formulário'),(7,'form_public_LGPD_2065_fund_legal','Y','','','',NULL,NULL,'Cadastro de fundamentos legais','Formulário'),(7,'form_public_LGPD_2066_ambiente_reg','Y','','','',NULL,NULL,'Cadastro de ambientes regulatórios','Formulário'),(7,'form_public_LGPD_2070_finalidades','Y','','','',NULL,NULL,'Parametrizar finalidades','Formulário'),(7,'form_public_LGPD_2070_registrar_finalidades','Y','','','',NULL,NULL,'Registrar finalidades','Formulário'),(7,'form_public_LGPD_2075_param_assoc_funcional_fin',NULL,NULL,NULL,NULL,NULL,NULL,'Associação funcional da finalidade','Formulário'),(7,'form_public_LGPD_2080_politicas','Y','','','',NULL,NULL,'Cadastro de políticas','Formulário'),(7,'form_public_LGPD_2085_contratos','Y','','','',NULL,NULL,'Cadastro de contratos','Formulário'),(7,'form_public_LGPD_2090_terceiros','Y','','','',NULL,NULL,'Cadastro de terceiros','Formulário'),(7,'form_public_LGPD_2093_ocorr_terc','Y','','','',NULL,NULL,'Cadastro de ocorrência de terceiros','Formulário'),(7,'form_public_LGPD_2095_med_tec','Y','','','',NULL,NULL,'Cadastro de medidas técnicas','Formulário'),(7,'form_public_LGPD_2097_config_assoc_med_atv',NULL,NULL,NULL,NULL,NULL,NULL,'Associar medidas técnicas aos ativos','Formulário'),(7,'form_public_LGPD_2100_prz_aprv_proc','',NULL,NULL,NULL,NULL,NULL,'[Item de menu] - Configurações / SLA de aprovação de Processos de Negócio: Acesso à configuração do prazo limite para aprovação de Processos de Negócio cadastrados','Formulário'),(7,'form_public_LGPD_3000_riscos','Y','Y','Y','Y',NULL,NULL,'Cadastro de riscos','Formulário'),(7,'form_public_LGPD_4000_atividades','Y','','','Y',NULL,NULL,'Cadastro de atividades','Formulário'),(7,'form_public_LGPD_5000_cod_etica','Y','Y','Y','Y',NULL,NULL,'Cadastro de código de ética','Formulário'),(7,'form_public_LGPD_5100_cod_conduta',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(7,'form_public_LGPD_6000_PDCA','','','','',NULL,NULL,'PDCA','Formulário'),(7,'form_public_LGPD_6100_catalog_treinamentos','Y','','','',NULL,NULL,'Cadastro de catalogo de treinamentos','Formulário'),(7,'form_public_LGPD_6200_agenda_treina','Y','Y','Y','Y',NULL,NULL,'Agenda de treinamentos','Formulário'),(7,'form_public_LGPD_7300_envio_aval_forne','Y','','','',NULL,NULL,'Cadastro de questionários (Due Diligence)','Formulário'),(7,'form_public_LGPD_assoc_contr_6500',NULL,NULL,NULL,NULL,NULL,NULL,'Associação de contratos','Formulário'),(7,'form_public_LGPD_assoc_medtec_6700',NULL,NULL,NULL,NULL,NULL,NULL,'Associação de medidas técnicas','Formulário'),(7,'form_public_LGPD_assoc_pdca_risk_6400',NULL,NULL,NULL,NULL,NULL,NULL,'Associação de riscos ao PDCA','Formulário'),(7,'form_public_LGPD_assoc_pol_6300',NULL,NULL,NULL,NULL,NULL,NULL,'Associação de políticas','Formulário'),(7,'form_public_LGPD_assoc_proc_6600',NULL,NULL,NULL,NULL,NULL,NULL,'Associação de processos','Formulário'),(7,'form_public_LGPD_assoc_treina_6500',NULL,NULL,NULL,NULL,NULL,NULL,'Associação de treinamentos','Formulário'),(7,'form_public_LGPD_config_det_opt_7200','Y','','','',NULL,NULL,'Parametrizar opções do questionário de fornecedores','Formulário'),(7,'form_public_PAC_1000_user_portal',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(7,'Governance_menu',NULL,NULL,NULL,NULL,NULL,NULL,'Menu',NULL),(7,'grid_CMP_0100_faixas',NULL,NULL,NULL,NULL,NULL,NULL,'Consultar faixas de setup de auditoria','Painel'),(7,'grid_CMP_1000_mecanismos','',NULL,NULL,NULL,NULL,NULL,'[Item de menu] - Pilares do Compliance / Mecanismos de Auditoria: Acesso ao cadastro de Mecanismos de Auditoria para projetos de Compliance','Pilares de Compliance'),(7,'grid_CMP_1100_componentes','',NULL,NULL,NULL,NULL,NULL,'[Item de menu] - Pilares do Compliance / Componentes de Auditoria: Acesso ao cadastro de Componentes de Auditoria, que compõem os Mecanismos cadastrados','Pilares de Compliance'),(7,'grid_CMP_1100_entrevistados_desassociados',NULL,NULL,NULL,NULL,NULL,NULL,'Consultas candidatos a entrevistas de ciclo de auditoria ','Painel'),(7,'grid_CMP_1200_questoes','',NULL,NULL,NULL,NULL,NULL,'[Item de menu] - Pilares do Compliance / Questões de Auditoria: Acesso ao cadastro de perguntas que são utilizadas para a realização de auditorias de Compliance','Pilares de Compliance'),(7,'grid_CMP_1300_formularios','',NULL,NULL,NULL,NULL,NULL,'[Item de menu] - Pilares do Compliance / Formulários de Auditoria: Acesso ao cadastro e configuração de Formulários compostos por perguntas para a realização de auditorias de Compliance','Pilares de Compliance'),(7,'grid_CMP_1310_formulario_det',NULL,NULL,NULL,NULL,NULL,NULL,'Consulta detalhes do formulário de auditoria ','Painel'),(7,'grid_CMP_1400_formulas_mestre','',NULL,NULL,NULL,NULL,NULL,'[Item de menu] - Pilares do Compliance / Parâmetros de Ciclos de Auditoria: Acesso à configuração de parâmetros quantitativos utilizados nos Ciclos de Auditoria de Compliance','Pilares de Compliance'),(7,'grid_CMP_1410_formulas_det_mec',NULL,NULL,NULL,NULL,NULL,NULL,'Sub Consulta mecanismos do setup de auditoria','Painel'),(7,'grid_CMP_1500_acao','',NULL,NULL,NULL,NULL,NULL,'[Item de menu] - Pilares do Compliance / Ações de Auditoria: Acesso ao cadastro de ações pré-determinadas para serem sugeridas a partir do levantamento de determinada Questão cadastrada','Pilares de Compliance'),(7,'grid_CMP_1550_ger_acao','',NULL,NULL,NULL,NULL,NULL,'[Item de menu] - Auditoria de Compliance / Recomendações de Auditoria: Acesso à geração automática de recomendações pós Ciclo de Auditoria de Compliance','Auditoria de Compliance'),(7,'grid_CMP_1600_OL','',NULL,NULL,NULL,NULL,NULL,'[Item de menu] - Aspectos Jurídicos / Obrigações Legais: Acesso ao cadastro das obrigações legais que a entidade deve atender em um determinado exercício','Aspectos Jurídicos'),(7,'grid_CMP_2000_ciclos','',NULL,NULL,NULL,NULL,NULL,'[Item de menu] - Auditoria de Compliance / Ciclos de Auditoria: Acesso à gestão de Ciclos de Auditoria de Compliance','Auditoria de Compliance'),(7,'grid_CMP_2500_conf_entrevistados','',NULL,NULL,NULL,NULL,NULL,'[Item de menu] - Auditoria de Compliance / Entrevistados: Acesso à seleção de entrevistados que estarão associados a um Ciclo de Auditoria de Compliance','Auditoria de Compliance'),(7,'grid_CMP_2510_entrevistados_associados',NULL,NULL,NULL,NULL,NULL,NULL,'Relação de entrevistados de um ciclo de auditoria','Painel'),(7,'grid_CMP_3000_aplic_pesq','',NULL,NULL,NULL,NULL,NULL,'[Item de menu] - Auditoria de Compliance / Pesquisas de Auditoria: Acesso à aplicação de Pesquisas de Auditoria de Compliance','Auditoria de Compliance'),(7,'grid_CMP_acompanhar_pesquisas',NULL,NULL,NULL,NULL,NULL,NULL,'Consulta acompanhamento do andamento de pesquisas de auditorias','Painel'),(7,'grid_CMP_resultado_pesquisa','',NULL,NULL,NULL,NULL,NULL,'[Item de menu] - Auditoria de Compliance / Resultados de Auditoria: Acesso à gestão do resultado de Pesquisas de Auditoria de Compliance','Auditoria de Compliance'),(7,'grid_CMP_resultado_pesquisa_questoes',NULL,NULL,NULL,NULL,NULL,NULL,'Consulta resultado da pesquisa de auditoria ','Painel'),(7,'grid_CMP_resultado_pesquisa_status_mecanismo',NULL,NULL,NULL,NULL,NULL,NULL,'Consulta resultado da pesquisa por mecanismos de auditoria ','Painel'),(7,'grid_conf_quest_7100',NULL,NULL,NULL,NULL,NULL,NULL,'Cofiguração de questionário para fornecedores','Painel'),(7,'grid_DOM_tp_ol_1600','',NULL,NULL,NULL,NULL,NULL,'[Item de menu] - Aspectos Jurídicos / Tipos de Obrigações Legais: Acesso ao cadastro de tipos de obrigações legais','Aspectos Jurídicos'),(7,'grid_kanban_atividades',NULL,NULL,NULL,NULL,NULL,NULL,'Kanban de  atividades','Painel'),(7,'grid_kanban_atividades_add_registro',NULL,NULL,NULL,NULL,NULL,NULL,'Kanban de  atividades','Painel'),(7,'grid_LGPD_2001_form_entr_prc','Y',NULL,NULL,NULL,'Y','Y',NULL,'Fluxo de Informação'),(7,'grid_LGPD_2003_envio_entr_prc','Y',NULL,NULL,NULL,'Y','Y',NULL,'Fluxo de Informação'),(7,'grid_LGPD_2040_assoc_prc_atv','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Fluxo de Informação / Associações do Fluxo de Informação: Acesso à consulta das associações entre Processos de Negócio x Ativos de Informação x Artefatos x Metadados Pessoais','Fluxo de Informação'),(7,'grid_LGPD_2075_assoc_funcional_dados_fin',NULL,NULL,NULL,NULL,NULL,NULL,'Consulta associação de metadados','Painel'),(7,'grid_LGPD_2087_ndas','Y',NULL,NULL,NULL,'Y','Y',NULL,'Políticas e Regulamentos'),(7,'grid_LGPD_2097_assoc_med_atv','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Medidas Técnicas de Segurança / Associações com Ativos de Informação: Acesso à configuração da associação entre Medidas Técnicas de Segurança e Ativos de Informação utilizados pela entidade','Medidas Técnicas de Segurança'),(7,'grid_LGPD_3100_assoc_risc_atv','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Riscos / Associações de Riscos: Acesso à associações entre Riscos e outras informações cadastradas','Riscos'),(7,'grid_LGPD_3600_chklst_risk_area_mestre','Y','','','','Y','Y','[Item de menu] - Riscos / Checklist por área de identificação de riscos e atividades','Riscos'),(7,'grid_LGPD_6300_aluno_treina',NULL,NULL,NULL,NULL,NULL,NULL,'Consulta de lista de treinamentos realizados por colaborador','Painel'),(7,'grid_LGPD_7400_resp_aval_forne',NULL,NULL,NULL,NULL,NULL,NULL,'Consulta respostas de questionários  (Due Diligence)','Painel'),(7,'grid_new_pln_acao','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Atividades e Ações / Plano de Ação LGPD: Acesso ao cadastro do documento \"Plano de Ação\" de adequação à LGPD','Atividades e Ações'),(7,'grid_public_LGPD_0100_diagnostico','',NULL,NULL,NULL,NULL,NULL,'[Item de menu] - Configurações / Projeto de Diagnóstico da LGPD: Acesso à configuração das informações sobre o projeto de Diagnóstico da LGPD','Configurações'),(7,'grid_public_LGPD_0200_implement','',NULL,NULL,NULL,NULL,NULL,'[Item de menu] - Configurações / Projeto de Adequação da LGPD: Acesso à configuração das informações sobre o projeto de Adequação da LGPD','Configurações'),(7,'grid_public_LGPD_0300_operacao','',NULL,NULL,NULL,NULL,NULL,'[Item de menu] - Configurações / Projeto de Operação da LGPD: Acesso à configuração das informações sobre a fase de Operação da LGPD','Configurações'),(7,'grid_public_LGPD_0400_etapas','',NULL,NULL,NULL,NULL,NULL,'[Item de menu] - Configurações / Etapas do Diagnóstico da LGPD: Acesso à configuração das etapas do projeto de Diagnóstico de um projeto de adequação à LGPD','Configurações'),(7,'grid_public_LGPD_1000_controlador','',NULL,NULL,NULL,NULL,NULL,'[Item de menu] - Configurações / Entidade: Acesso à configuração dos dados da entidade','Configurações'),(7,'grid_public_LGPD_1001_diretoria','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Estrutura Organizacional / Diretoria: Acesso ao cadastro de Diretorias, que é o nível mais alto da hierarquia organizacional da entidade','Estrutura Organizacional'),(7,'grid_public_LGPD_1002_area','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Estrutura Organizacional / Área: Acesso ao cadastro de Áreas, que dividem uma determinada Diretoria na estrutura hierárquica da entidade','Estrutura Organizacional'),(7,'grid_public_LGPD_1003_departamento','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Estrutura Organizacional / Departamentos: Acesso ao cadastro de Departamentos, que dividem uma determinada Área na estrutura hierárquica da entidade','Estrutura Organizacional'),(7,'grid_public_LGPD_1004_cargos','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Estrutura Organizacional / Cargos: Acesso ao cadastro de Cargos a serem ocupados por pessoas da equipe que ocupem espaço na estrutura hierárquica da entidade','Estrutura Organizacional'),(7,'grid_public_LGPD_1050_organograma','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Estrutura Organizacional / Lotação: Acesso ao cadastro de unidades de trabalho, onde é possível alocar as equipes da entidade','Estrutura Organizacional'),(7,'grid_public_LGPD_1051_comite','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Estrutura Organizacional / Comitês: Acesso ao cadastro de comitês da entidade, que congregam uma ou mais pessoas previamente cadastradas','Estrutura Organizacional'),(7,'grid_public_LGPD_1053_eventos_comite','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Atividades e Ações / Eventos de Comitê: Acesso ao cadastro de eventos associados aos Comitês da entidade','Atividades e Ações'),(7,'grid_public_LGPD_1053_sub_eventos_comite',NULL,NULL,NULL,NULL,NULL,NULL,'Sub Consulta de Eventos','Painel'),(7,'grid_public_LGPD_1100_equipe','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Estrutura Organizacional / Equipe: Acesso ao cadastro de pessoas que podem ocupar cargos na estrutura hierárquica da entidade. Essas pessoas serão associadas a diversas outras entidades tratadas na plataforma','Estrutura Organizacional'),(7,'grid_public_LGPD_2000_proc_aprv_prz_expirado','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Atividades e Ações / Processos de Negócio Pendentes: Acesso à gestão de Processos de Negócio com SLA de aprovação expirado','Atividades e Ações'),(7,'grid_public_LGPD_2000_processos','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Fluxo de Informação / Processos de Negócio: Acesso ao cadastro de Processos de Negócio que definem as rotinas operacionais da entidade','Fluxo de Informação'),(7,'grid_public_LGPD_2000_sub_proc_pessoa',NULL,NULL,NULL,NULL,NULL,NULL,'Consulta processo por responsável','Painel'),(7,'grid_public_LGPD_2000_sub_processos_atv',NULL,NULL,NULL,NULL,NULL,NULL,'Consulta processos por ativos','Painel'),(7,'grid_public_LGPD_2010_ativos','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Fluxo de Informação / Ativos de Informação: Acesso ao cadastro de Ativos de Informação utilizados pela entidade na execução de seus Processos de Negócio','Fluxo de Informação'),(7,'grid_public_LGPD_2010_ativos_1',NULL,NULL,NULL,NULL,NULL,NULL,'Consulta Ativos','Painel'),(7,'grid_public_LGPD_2010_ativos_n_utlz_fin',NULL,NULL,NULL,NULL,NULL,NULL,'Processos disponivel para associação com finalidades','Painel'),(7,'grid_public_LGPD_2010_ativos_utlz_fin',NULL,NULL,NULL,NULL,NULL,NULL,'Processos associados a finalidade','Painel'),(7,'grid_public_LGPD_2010_sub_ativos',NULL,NULL,NULL,NULL,NULL,NULL,'Sub Consulta de Ativos','Painel'),(7,'grid_public_LGPD_2020_artefatos','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Fluxo de Informação / Artefatos: Acesso ao cadastro de Artefatos e Documentos tratados nos Ativos de Informação utilizados pela entidade','Fluxo de Informação'),(7,'grid_public_LGPD_2020_artefatos_n_utlz_fin',NULL,NULL,NULL,NULL,NULL,NULL,'Artefatos disponiveis para associação com finalidades','Painel'),(7,'grid_public_LGPD_2020_artefatos_utlz_fin',NULL,NULL,NULL,NULL,NULL,NULL,'Artefatos associados a finalidades','Painel'),(7,'grid_public_LGPD_2030_assoc_art_metadados',NULL,NULL,NULL,NULL,NULL,NULL,'Associação de Artefatos e metadados','Painel'),(7,'grid_public_LGPD_2030_dados','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Fluxo de Informação / Metadados Pessoais: Acesso ao cadastro de Metadados Pessoais presentes nos diferentes Artefatos utilizados pela entidade','Fluxo de Informação'),(7,'grid_public_LGPD_2065_fund_legal','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Aspectos Jurídicos / Fundamentos Legais: Acesso ao cadastro de Fundamentos Legais utilizados pela entidade','Aspectos Jurídicos'),(7,'grid_public_LGPD_2066_ambiente_reg','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Aspectos Jurídicos / Ambientes regulatórios: Acesso ao cadastro de Ambientes Regulatórios a serem associados a Fundamentos Legais utilizados pela entidade','Aspectos Jurídicos'),(7,'grid_public_LGPD_2070_finalidades','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Tratamento de Dados Pessoais / Parametrizar Finalidades de Tratamentos: Acesso à configuração dos aspectos e detalhes das Finalidades de Tratamento de Dados Pessoais previamente cadastradas','Tratamento de Dados Pessoais'),(7,'grid_public_LGPD_2070_registrar_finalidades','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Tratamento de Dados Pessoais / Registrar Finalidade de Tratamento: Acesso ao cadastro de Finalidades de Tratamento de Dados Pessoais executadas pela entidade','Tratamento de Dados Pessoais'),(7,'grid_public_LGPD_2070_sub_contratos_finalidades',NULL,NULL,NULL,NULL,NULL,NULL,'Sub consulta de contratos dentro da finalidade','Painel'),(7,'grid_public_LGPD_2070_sub_finalidades',NULL,NULL,NULL,NULL,NULL,NULL,'Sub consulta de finalidades','Painel'),(7,'grid_public_LGPD_2073_assoc_ativos_fin',NULL,NULL,NULL,NULL,NULL,NULL,'Associação de ativos na finalidade','Painel'),(7,'grid_public_LGPD_2075_assoc_metadados_fin',NULL,NULL,NULL,NULL,NULL,NULL,'Associação de metadados na finalidade','Painel'),(7,'grid_public_LGPD_2080_politicas','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Políticas e Regulamentos / Políticas: Acesso ao cadastro de políticas associadas à Governança de Privacidade da entidade','Políticas e Regulamentos'),(7,'grid_public_LGPD_2085_contratos','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Políticas e Regulamentos / Contratos: Acesso ao cadastro de contratos e modelos de contratos utilizados pela entidade','Políticas e Regulamentos'),(7,'grid_public_LGPD_2090_terceiros','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Gestão de terceiros / Terceiros: Acesso ao cadastro de entidades terceiras (PJ ou PF) associadas à entidade','Gestão de Terceiros'),(7,'grid_public_LGPD_2093_ocorr_terc','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Gestão de terceiros / Ocorrências: Acesso ao cadastro de ocorrências relacionadas à Terceiros associados à entidade','Gestão de Terceiros'),(7,'grid_public_LGPD_2095_med_tec','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Medidas Técnicas de Segurança / Medidas Técnicas de Segurança: Acesso ao cadastro de Medidas Técnicas de Segurança da Informação que podem ser associadas a Ativos cadastrados','Medidas Técnicas de Segurança'),(7,'grid_public_LGPD_2095_sub_med_tec',NULL,NULL,NULL,NULL,NULL,NULL,'Sub Consulta de medidas técnicas','Painel'),(7,'grid_public_LGPD_3000_riscos','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Riscos / Riscos: Acesso ao cadastro de Riscos de Privacidade e Compliance','Riscos'),(7,'grid_public_LGPD_3000_sub_consulta_riscos',NULL,NULL,NULL,NULL,NULL,NULL,'Sub consulta de riscos','Painel'),(7,'grid_public_LGPD_3300_assoc_risc_prc',NULL,NULL,NULL,NULL,NULL,NULL,'Associar risco a processos','Painel'),(7,'grid_public_LGPD_4000_atividades','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Atividades e Ações / Atividades e Ações: Acesso ao cadastro de atividades e ações de governança e compliance','Atividades e Ações'),(7,'grid_public_LGPD_5000_cod_etica','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Políticas e Regulamentos / Códigos e Regulamentos Internos: Acesso ao cadastro de documentos que definem as regras internas de Compliance da entidade','Políticas e Regulamentos'),(7,'grid_public_LGPD_5100_cod_conduta',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(7,'grid_public_LGPD_6000_PDCA','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Atividades e Ações / Gestão de ciclo de PDCA de Compliance: Acesso ao planejamento e gestão de ciclos de PDCA de Compliance','Atividades e Ações'),(7,'grid_public_LGPD_6000_SUB_PDCA',NULL,NULL,NULL,NULL,NULL,NULL,'Sub consulta PDCA','Painel'),(7,'grid_public_LGPD_6100_catalog_treinamentos','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Atividades e Ações / Catálogo de treinamentos: Acesso ao cadastro dos tipos de treinamentos que a entidade pode executar para suas equipes','Atividades e Ações'),(7,'grid_public_LGPD_6200_agenda_treina','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Atividades e Ações / Agenda de Treinamentos: Acesso à gestão de agenda de treinamentos e capacitações internas da entidade','Atividades e Ações'),(7,'grid_public_LGPD_7300_envio_aval_forne',NULL,NULL,NULL,NULL,NULL,NULL,'Consulta de questionários (Due Diligence)','Painel'),(7,'grid_public_LGPD_7300_envio_aval_forne_gerencial','Y',NULL,NULL,NULL,'Y','Y',NULL,'Gestão de Terceiros'),(7,'grid_public_LGPD_cons_rev_contr_6500',NULL,NULL,NULL,NULL,NULL,NULL,'Consulta revisões de contrato','Painel'),(7,'grid_public_LGPD_cons_rev_medtec_6700',NULL,NULL,NULL,NULL,NULL,NULL,'Consulta revisões de medidas técnicas','Painel'),(7,'grid_public_LGPD_cons_rev_pol_6300',NULL,NULL,NULL,NULL,NULL,NULL,'Consulta revisão de políticas','Painel'),(7,'grid_public_LGPD_cons_rev_proc_6600',NULL,NULL,NULL,NULL,NULL,NULL,'Consulta revisão de processos','Painel'),(7,'grid_public_LGPD_cons_rev_risk_6400',NULL,NULL,NULL,NULL,NULL,NULL,'Consulta revisão de riscos','Painel'),(7,'grid_public_PAC_9000_DPIA',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(7,'grid_public_PAC_9100_LIA',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(7,'grid_public_PCP_9000_DPIA',NULL,NULL,NULL,NULL,NULL,NULL,'Consulta DPIA',NULL),(7,'grid_public_pcp_9100_LIA',NULL,NULL,NULL,NULL,NULL,NULL,'Consulta LIA ',NULL),(7,'grid_public_subconsulta_sec_users',NULL,NULL,NULL,NULL,NULL,NULL,'Sub consulta de usuarios','Painel'),(7,'grid_sc_log','',NULL,NULL,NULL,NULL,NULL,'[Item de menu] - Segurança / Histórico de acessos: Acesso à consulta à histórico de acessos de usuários à plataforma','Segurança'),(7,'help_cadastro_titulares',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(7,'help_ciclo_de_vida',NULL,NULL,NULL,NULL,NULL,NULL,'Help Ciclo de vida','Painel'),(7,'help_finalidades_fundamentos',NULL,NULL,NULL,NULL,NULL,NULL,'Help Finalidades','Painel'),(7,'help_geracao_atividades',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(7,'help_geracao_riscos',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(7,'help_gestao_consentimentos',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(7,'help_gestao_incidentes',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(7,'help_gestao_notificacao',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(7,'help_integracao_portais',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(7,'help_lotes_validacao',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(7,'help_medidas_administrativas',NULL,NULL,NULL,NULL,NULL,NULL,'Help medidas administrativas','Painel'),(7,'help_medidas_tecnicas',NULL,NULL,NULL,NULL,NULL,NULL,'Help para medidas técnicas','Painel'),(7,'help_plano_acao_atividades',NULL,NULL,NULL,NULL,NULL,NULL,'Help Atividades','Painel'),(7,'help_relatorios',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(7,'help_riscos_e_impactos',NULL,NULL,NULL,NULL,NULL,NULL,'Help Riscos','Painel'),(7,'homepage',NULL,NULL,NULL,NULL,NULL,NULL,'Home Page (Responsábilidades e Atividades)','Painel'),(7,'homepage_help',NULL,NULL,NULL,NULL,NULL,NULL,'Help','Painel'),(7,'mapa_calor_risco',NULL,NULL,NULL,NULL,NULL,NULL,'Mapa de risco','Painel'),(7,'Mapa_Calor_Riscos',NULL,NULL,NULL,NULL,NULL,NULL,'Mapa de calor de riscos ','Painel'),(7,'menu',NULL,NULL,NULL,NULL,NULL,NULL,'Menu PCP','Painel'),(7,'menu_dinamico',NULL,NULL,NULL,NULL,NULL,NULL,'Menu','Painel'),(7,'Menu_Pac',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(7,'Metadados','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Painel / Metadados Pessoais: Acesso à exibição dos principais indicadores sobre Metadados Pessoais','Painel'),(7,'novo_menu',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(7,'pac_app_change_pswd','Y','','','','','','[Item de menu] - SeguranÃ§a / AlteraÃ§Ã£o de senha: Acesso Ã  gestÃ£o de senhas de usuÃ¡rios da plataforma','SeguranÃ§a'),(7,'pac_app_form_sec_groups_apps','',NULL,NULL,NULL,NULL,NULL,'[Item de menu] - SeguranÃ§a / AssociaÃ§Ã£o de perfis a aplicaÃ§Ãµes: Acesso Ã  configuraÃ§Ã£o da associaÃ§Ã£o de perfis de acesso com as aplicaÃ§Ãµes da plataforma','SeguranÃ§a'),(7,'pac_app_grid_sec_apps','',NULL,NULL,NULL,NULL,NULL,'[Item de menu] - SeguranÃ§a / AplicaÃ§Ãµes: Acesso ao cadastro de aplicaÃ§Ãµes da plataforma','SeguranÃ§a'),(7,'pac_app_grid_sec_groups','',NULL,NULL,NULL,NULL,NULL,'[Item de menu] - SeguranÃ§a / Perfis: Acesso ao cadastro de perfis de acesso dos usuÃ¡rios da plataforma','SeguranÃ§a'),(7,'pac_app_grid_sec_users','',NULL,NULL,NULL,NULL,NULL,'[Item de menu] - SeguranÃ§a / UsuÃ¡rios: Acesso ao cadastro de usuÃ¡rios da plataforma','SeguranÃ§a'),(7,'pac_app_grid_sec_users_groups','',NULL,NULL,NULL,NULL,NULL,'[Item de menu] - SeguranÃ§a / AssociaÃ§Ã£o de usuÃ¡rios a perfis: Acesso Ã  configuraÃ§Ã£o da associaÃ§Ã£o de usuÃ¡rios a perfis de acesso','SeguranÃ§a'),(7,'pac_app_search_sec_groups','',NULL,NULL,NULL,NULL,NULL,'[Item de menu] - SeguranÃ§a / AssociaÃ§Ã£o de perfis a aplicaÃ§Ãµes: Acesso Ã  configuraÃ§Ã£o da associaÃ§Ã£o de perfis de acesso com as aplicaÃ§Ãµes da plataforma','SeguranÃ§a'),(7,'pac_menu',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(7,'PAG_menu',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(7,'param_aval_mestre_7000','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Gestão de terceiros / Formulários de due diligence: Acesso à criação de formulários (e suas questões) para auto avaliação de terceiros','Gestão de Terceiros'),(7,'PDCA','',NULL,NULL,NULL,NULL,NULL,'[Item de menu] - Painel / Ciclos de PDCA: Acesso à exibição dos principais indicadores sobre Ciclos de PDCA de Compliance','Painel'),(7,'pdfreport_LGPD_7300_envio_aval_forne',NULL,NULL,NULL,NULL,NULL,NULL,'geração de PDF - questionário (Due Diligence)','Painel'),(7,'popup_confirm_action',NULL,NULL,NULL,NULL,NULL,NULL,'Pop-up ( não se aplica ao módulo de segirança)','Painel'),(7,'popup_confirm_action_status',NULL,NULL,NULL,NULL,NULL,NULL,'Pop_Up ( Não se plaica ao módulo de segurança ) ','Painel'),(7,'Processos','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Painel / Processos de Negócio: Acesso à exibição dos principais indicadores sobre Processos de Negócio','Painel'),(7,'relatorio_ciclos_complience',NULL,NULL,NULL,NULL,NULL,NULL,'Extrato de cilco de auditoria ','Painel'),(7,'relatorio_dpia',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(7,'relatorio_dpia_1',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(7,'relatorio_finalidades',NULL,NULL,NULL,NULL,NULL,NULL,'Relatório de finalidades','Painel'),(7,'relatorio_lia',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(7,'relatorio_notificacao',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(7,'relatorio_resp_aval',NULL,NULL,NULL,NULL,NULL,NULL,'Relatório Avaliações','Painel'),(7,'resumo_finalidade',NULL,NULL,NULL,NULL,NULL,NULL,'Resumo de finalidade','Painel'),(7,'Riscos','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Painel / Riscos: Acesso à exibição dos principais indicadores sobre Gestão de Riscos de Privacidade e Compliance','Painel'),(7,'risk_heat_map','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Riscos / Mapa de Calor: Acesso à exibição do Mapa de Calor dos Riscos cadastrados','Riscos'),(7,'search_public_LGPD_4000_atividades',NULL,NULL,NULL,NULL,NULL,NULL,'Filtro de atividades','Painel'),(7,'sec_change_pswd',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(7,'sec_form_add_users',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(7,'sec_form_edit_users',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(7,'sec_form_sec_apps',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(7,'sec_form_sec_groups',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(7,'sec_form_sec_groups_apps',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(7,'sec_grid_sec_apps',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(7,'sec_grid_sec_groups',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(7,'sec_grid_sec_users',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(7,'sec_grid_sec_users_groups',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(7,'sec_Login',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(7,'sec_menu',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(7,'sec_retrieve_pswd',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(7,'sec_search_sec_groups',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(7,'sec_settings',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(7,'sec_sync_apps',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(7,'sub_consulta_3000_riscos_incidente',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(7,'sub_consulta_3100_assoc_risc_atv',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(7,'sub_consulta_3300_assoc_risc_prc',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(7,'sub_consulta_3400_assoc_risc_fin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(7,'sub_consulta_CMP_1610_ol_agenda',NULL,NULL,NULL,NULL,NULL,NULL,'Sub consulta de agenda de obrigações legais por obrigação','Painel'),(7,'sub_consulta_CMP_2510_det_conf_entrevistados',NULL,NULL,NULL,NULL,NULL,NULL,'Entrevitados em presquisa de auditoria --> Sub Consulta de configuração de entrevidados de pesquisa de auditoria ','Painel'),(7,'sub_consulta_CMP_3000_aplic',NULL,NULL,NULL,NULL,NULL,NULL,'Sub consulta status da aplicação de pesquisa de auditoria','Painel'),(7,'sub_consulta_CMP_4000_respostas_mestre',NULL,NULL,NULL,NULL,NULL,NULL,'Sub consulta status de respostas dos formulários de auditoria dentro de um ciclo ','Painel'),(7,'sub_consulta_configurar_metadados',NULL,NULL,NULL,NULL,NULL,NULL,'Sub consulta configuração de metadados','Painel'),(7,'sub_consulta_LGPD_2097_assoc_med_atv',NULL,NULL,NULL,NULL,NULL,NULL,'Sub consulta de associação entre medidas técnicas e ativos','Painel'),(7,'sub_consulta_LGPD_6200_agenda_treina',NULL,NULL,NULL,NULL,NULL,NULL,'Sub consulta de agenda de treinamentos ','Painel'),(7,'sub_consulta_PAC_1100_sol_portal',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(7,'sub_consulta_PAC_3200_tit_consent',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(7,'sub_consulta_PAC_4000_notificacao',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(7,'sub_consulta_PAG_ocorr_lote_1100',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(7,'sub_form_configurar_metados',NULL,NULL,NULL,NULL,NULL,NULL,'Configurar metadados','Painel'),(7,'sub_grid_CMP_1550_ger_acao',NULL,NULL,NULL,NULL,NULL,NULL,'Sub grid de recomendaçoes de auditoria por ciclo','Painel'),(7,'sub_grid_LGPD_2050_assoc_atv_art',NULL,NULL,NULL,NULL,NULL,NULL,'Sub consulta de associação entre ativos e artefatos',NULL),(7,'sub_grid_PAC_1400_tit_afet_inc',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(7,'sub_grid_public_LGPD_2093_ocorr_terc',NULL,NULL,NULL,NULL,NULL,NULL,'Sub consulta ocorrência de terceiros','Painel'),(8,'app_change_pswd','',NULL,NULL,NULL,NULL,NULL,'[Item de menu] - Segurança / Alteração de senha: Acesso à gestão de senhas de usuários da plataforma','Segurança'),(8,'app_form_add_users','','','','',NULL,NULL,'Cadastrar usuários','Formulário'),(8,'app_form_edit_users','','','','',NULL,NULL,'Alterar usuários','Formulário'),(8,'app_form_sec_apps','','','','',NULL,NULL,'Cadastrar aplicações','Formulário'),(8,'app_form_sec_groups','','','','',NULL,NULL,'Cadastro de grupos de usuários','Formulário'),(8,'app_form_sec_groups_apps','','','','',NULL,NULL,'Associar grupos x aplicações','Painel'),(8,'app_grid_sec_apps','',NULL,NULL,NULL,NULL,NULL,'[Item de menu] - Segurança / Aplicações: Acesso ao cadastro de aplicações da plataforma','Segurança'),(8,'app_grid_sec_groups','',NULL,NULL,NULL,NULL,NULL,'[Item de menu] - Segurança / Perfis: Acesso ao cadastro de perfis de acesso dos usuários da plataforma','Segurança'),(8,'app_grid_sec_users','',NULL,NULL,NULL,NULL,NULL,'[Item de menu] - Segurança / Usuários: Acesso ao cadastro de usuários da plataforma','Segurança'),(8,'app_grid_sec_users_groups','',NULL,NULL,NULL,NULL,NULL,'[Item de menu] - Segurança / Associação de usuários a perfis: Acesso à configuração da associação de usuários a perfis de acesso','Segurança'),(8,'app_Login',NULL,NULL,NULL,NULL,NULL,NULL,'Login',NULL),(8,'app_menu',NULL,NULL,NULL,NULL,NULL,NULL,'Menu','Painel'),(8,'app_retrieve_pswd',NULL,NULL,NULL,NULL,NULL,NULL,'Esqueceu a senha','Painel'),(8,'app_search_sec_groups','',NULL,NULL,NULL,NULL,NULL,'[Item de menu] - Segurança / Associação de perfis a aplicações: Acesso à configuração da associação de perfis de acesso com as aplicações da plataforma','Segurança'),(8,'app_settings','',NULL,NULL,NULL,NULL,NULL,'Configurações de segurança','Segurança'),(8,'app_sync_apps','',NULL,NULL,NULL,NULL,NULL,'Sincronização de aplicações','Segurança'),(8,'Artefatos','',NULL,NULL,NULL,NULL,NULL,'[Item de menu] - Painel / Artefatos: Acesso à exibição dos principais indicadores sobre Artefatos e Documentos','Painel'),(8,'associar_metadados_finalidade',NULL,NULL,NULL,NULL,NULL,NULL,'Associar metadados na finalidade','Painel'),(8,'associar_metadados_finalidade_new',NULL,NULL,NULL,NULL,NULL,NULL,'Associar metadados a finalidades','Painel'),(8,'Atividades','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Painel / Atividades e Ações: Acesso à exibição dos principais indicadores sobre Atividades e Ações','Painel'),(8,'Ativos','',NULL,NULL,NULL,NULL,NULL,'[Item de menu] - Painel / Ativos de Informação: Acesso à exibição dos principais indicadores sobre Ativos de Informação','Painel'),(8,'Auto_cadastro_PAC_4000_notificacao',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(8,'blank_email',NULL,NULL,NULL,NULL,NULL,NULL,'Enviar mail','Painel'),(8,'blank_pipeline','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Atividades e Ações / Meu Quadro de Atividades: Acesso ao Kanban de atividades do usuário logado','Atividades e Ações'),(8,'blank_pipeline_Ajax',NULL,NULL,NULL,NULL,NULL,NULL,'Pipeline de atividades','Painel'),(8,'cad_sol_dpia_pcp_9000','Y',NULL,NULL,NULL,'Y','Y',NULL,'Fluxo de Informação'),(8,'Cadastro_DEN_1000_registro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(8,'Cadastro_DEN_1100_cat',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(8,'cadastro_PAC_1110_atv_sol',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(8,'cadastro_PAC_1200_sla_sol_portal',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(8,'Cadastro_PAC_1400_titulares',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(8,'Cadastro_PAC_1410_dados_tit',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(8,'Cadastro_PAC_2000_incidentes',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(8,'Cadastro_PAC_2100_sla_notificacao',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(8,'Cadastro_PAC_3100_env_consent',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(8,'Cadastro_PAC_4000_notificacao',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(8,'Cadastro_PAG_lote_1000',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(8,'cadastro_PAG_ocorr_lote_1100',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(8,'calendar_app',NULL,NULL,NULL,NULL,NULL,NULL,'Calendário','Painel'),(8,'calendar_public_LGPD_4000_atividades',NULL,NULL,NULL,NULL,NULL,NULL,'Calendário de atividades ( DPO )','Painel'),(8,'chart_public_LGPD_2000_processos_complex',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico processo por complexidade','Painel'),(8,'chart_public_LGPD_2000_processos_geral',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico processos','Painel'),(8,'chart_public_LGPD_2000_processos_resp',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico processos por responsável','Painel'),(8,'chart_public_LGPD_2000_status_processos',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico processo por status','Painel'),(8,'chart_public_LGPD_2000_tipo_processo',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico processos por tipo','Painel'),(8,'chart_public_LGPD_2010_confia_ativos',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico confibilidade dos ativos','Painel'),(8,'chart_public_LGPD_2010_disp_ativos',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico ativos por nível de disponibilidade','Painel'),(8,'chart_public_LGPD_2010_integridade_ativos',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico ativos por nível de integridade','Painel'),(8,'chart_public_LGPD_2010_resp_ativos',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico ativos por responsável','Painel'),(8,'chart_public_LGPD_2010_tipo_ativos',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico tipos de ativos','Painel'),(8,'chart_public_LGPD_2020_artefat_contrato',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico artefatos tipo contrato','Painel'),(8,'chart_public_LGPD_2020_contrato_artefatos',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico contratos x artefatos','Painel'),(8,'chart_public_LGPD_2020_tipo_artefatos',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico artefatos por tipo','Painel'),(8,'chart_public_LGPD_2030_classif_dados',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico classificação de metadados','Painel'),(8,'chart_public_LGPD_2030_dados_anonimizavel',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico metadados anonimizavel','Painel'),(8,'chart_public_LGPD_2030_tipif_dados',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico tipos de dados','Painel'),(8,'chart_public_LGPD_2070_fin_compart_dados',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico finalidades por compartilhamento','Painel'),(8,'chart_public_LGPD_2070_fin_dad_criancas',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico finalidades por dados de crianças','Painel'),(8,'chart_public_LGPD_2070_fin_faz_descarte',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico finalidades por descarte','Painel'),(8,'chart_public_LGPD_2070_fin_frequencia',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico finalidades por ferequencia','Painel'),(8,'chart_public_LGPD_2070_fin_hipoteses',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico finalidades por hipóteses de tratamento','Painel'),(8,'chart_public_LGPD_2070_fin_papel',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico papel da entidade','Painel'),(8,'chart_public_LGPD_2070_fin_processos',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico finalidades por processos','Painel'),(8,'chart_public_LGPD_2070_fin_rot_automatizada',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico finalidades por rotinas automatizadas','Painel'),(8,'chart_public_LGPD_2070_fin_utlz_operador',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico finalidades por utiliza operador','Painel'),(8,'chart_public_LGPD_2070_fin_volumetria',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico finliadades por volumetria','Painel'),(8,'chart_public_LGPD_3000_categoria_riscos',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico riscos por categoria','Painel'),(8,'chart_public_LGPD_3000_criticidade_riscos',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico riscos por criticidade','Painel'),(8,'chart_public_LGPD_3000_estrategia_riscos',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico riscos por estratégia','Painel'),(8,'chart_public_LGPD_3000_impacto_riscos',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico riscos por impacto','Painel'),(8,'chart_public_LGPD_3000_prob_riscos',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico riscos por probabilidade','Painel'),(8,'chart_public_LGPD_3000_resp_riscos',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico riscos por responsáveis','Painel'),(8,'chart_public_LGPD_3000_status_riscos',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico riscos por status','Painel'),(8,'chart_public_LGPD_4000_atividades_geral',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico atividades','Painel'),(8,'chart_public_LGPD_4000_disc_atividades',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico atividades por disciplina','Painel'),(8,'chart_public_LGPD_4000_etapa_atividades',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico atividades por etapas','Painel'),(8,'chart_public_LGPD_4000_resp_atividades',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico atividades por responsável','Painel'),(8,'chart_public_LGPD_4000_status_resp_atividade',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico atividades por responsável e status','Painel'),(8,'chart_public_LGPD_assoc_pdca_contr_6500',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico PDCA de contratos','Painel'),(8,'chart_public_LGPD_assoc_pdca_finalizados_treina_6500',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico PDCA de treinamentos','Painel'),(8,'chart_public_LGPD_assoc_pdca_medtec_6700',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico PDCA de medidas técnicas','Painel'),(8,'chart_public_LGPD_assoc_pdca_pol_6300',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico PDCA de políticas','Painel'),(8,'chart_public_LGPD_assoc_pdca_proc_6600',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico PDCA de processos','Painel'),(8,'chart_public_LGPD_assoc_pdca_realizar_treina_6500',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico PDCA realização de treinamentos','Painel'),(8,'chart_public_LGPD_assoc_pdca_risk_6400',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico PDCA de riscos','Painel'),(8,'cons_dad_nao_utlz_LGPD_2030_dados','',NULL,NULL,NULL,NULL,NULL,'[Item de menu] - Fluxo de Informação / Metadados Pessoais não utilizados: Acesso à consulta dos Metadados Pessoais cadastrados mas não utilizados em nenhuma associação','Fluxo de Informação'),(8,'cons_minhas_obr_CMP_1610_ol_agenda','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Aspectos Jurídicos / Minhas Obrigações Legais: Acesso ao cadastro das obrigações legais da entidade que estão sob a responsabilidade do usuário logado','Aspectos Jurídicos'),(8,'Consulta_DEN_1000_registro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(8,'Consulta_DEN_1100_cat',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(8,'consulta_gerencial_CMP_1610_ol_agenda','',NULL,NULL,NULL,NULL,NULL,'[Item de menu] - Aspectos Jurídicos / Acompanhamento de Obrigações Legais: Acesso ao painel de acompanhamento do status das obrigações legais da entidade','Aspectos Jurídicos'),(8,'consulta_gerencial_LGPD_4000_atividades','',NULL,NULL,NULL,NULL,NULL,'[Item de menu] - Atividades e Ações / Acompanhamento de Atividades e Ações: Acesso ao painel de acompanhamento do status das obrigações legais da entidade','Atividades e Ações'),(8,'Consulta_LGPD_3000_riscos_assistant',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(8,'Consulta_LGPD_4000_atividades_assistant',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(8,'Consulta_PAC_1000_user_portal',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(8,'Consulta_PAC_1100_sol_portal',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(8,'consulta_PAC_1200_sla_sol_portal',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(8,'Consulta_PAC_1400_titulares',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(8,'Consulta_PAC_1410_dados_tit',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(8,'Consulta_PAC_2000_incidentes',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(8,'Consulta_PAC_3100_env_consent',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(8,'Consulta_PAC_4000_notificacao',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(8,'Consulta_PAG_lote_1000',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(8,'Consulta_public_LGPD_3000_riscos',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(8,'control_calendar',NULL,NULL,NULL,NULL,NULL,NULL,'Meu calendário de atividades de adequação',NULL),(8,'control_login',NULL,NULL,NULL,NULL,NULL,NULL,'Login','Painel'),(8,'control_login_diligence',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(8,'esqueci_senha',NULL,NULL,NULL,NULL,NULL,NULL,'Esqueceu a senha','Painel'),(8,'extrato_pdca',NULL,NULL,NULL,NULL,NULL,NULL,'Extrato PDCA','Painel'),(8,'Finalidades','',NULL,NULL,NULL,NULL,NULL,'[Item de menu] - Painel / Finalidades de Tratamento de Dados Pessoais: Acesso à exibição dos principais indicadores sobre Finalidades de Tratamento de Dados Pessoais','Painel'),(8,'form_aval_7000','Y',NULL,NULL,NULL,'Y','Y','Formulários de due diligence: Acesso à criação de formulários (e suas questões) para auto avaliação de terceiros','Gestão de Terceiros'),(8,'form_CMP_1000_mecanismos','Y','','','',NULL,NULL,'Cadastro de mecanismos de auditoria ','Formulário'),(8,'form_CMP_1100_componentes','Y','','','',NULL,NULL,'Cadastro de componentes de auditoria','Formulário'),(8,'form_CMP_1200_questoes','Y','','','',NULL,NULL,'Cadastro de questões de auditoria','Formulário'),(8,'form_CMP_1300_formularios','Y','Y','Y','Y',NULL,NULL,'Cadatro de formulários de auditoria ','Formulário'),(8,'form_CMP_1300_formularios_edit','Y','Y','Y','Y',NULL,NULL,'Edição de formulários de auditoria','Formulário'),(8,'form_CMP_1400_formulas_mestre','Y','Y','Y','Y',NULL,NULL,'Parametrização de Setup de Auditoria','Formulário'),(8,'form_CMP_1400_formulas_view','Y','Y','Y','Y',NULL,NULL,'Visualizar setup de auditoria','Formulário'),(8,'form_CMP_1410_formulas_det_mec','Y','Y','Y','Y',NULL,NULL,'Parametrizar mecanismos de auditoria no setup','Formulário'),(8,'form_CMP_1420_formulas_det_niv_ad','Y','Y','Y','Y',NULL,NULL,'Parametrizar níveis de aderência do setup de auditoria ','Formulário'),(8,'form_CMP_1430_formulas_det_lim','Y','Y','Y','Y',NULL,NULL,'Parametrizar faixas do setup de auditoria','Formulário'),(8,'form_CMP_1500_acao','Y','','','',NULL,NULL,'Recomendações de auditorias','Formulário'),(8,'form_CMP_1600_OL','Y','Y','Y','Y',NULL,NULL,'Cadastro de Obrigações Legais ','Formulário'),(8,'form_CMP_2000_ciclos','Y','Y','Y','Y',NULL,NULL,'Cadastro de ciclos de auditoria','Formulário'),(8,'form_CMP_2500_conf_entrevistados','Y','Y','Y','Y',NULL,NULL,'Cadastro de entrevistados do ciclo de auditoria ','Formulário'),(8,'form_CMP_2500_conf_entrevistados_1','Y','Y','Y','Y',NULL,NULL,'Cadastro de entrevistados ','Formulário'),(8,'form_CMP_2500_conf_param_entrevistados','Y','Y','Y','Y',NULL,NULL,'Parametrizar relação de entrevistados de um ciclo de auditoria','Formulário'),(8,'form_CMP_3000_aplic_pesq','Y','Y','Y','Y',NULL,NULL,'Cadastro de aplicação de pesquisa de auditorias ','Formulário'),(8,'form_CMP_resultados_pesquisas','Y','Y','Y','Y',NULL,NULL,'Cadastro de resultado de pesquisas de auditoria','Formulário'),(8,'form_conf_quest_7100','Y','Y','Y','Y',NULL,NULL,'Configurar questionário de fornecedores','Formulário'),(8,'form_diligence',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(8,'form_DOM_tp_ol_1600','Y','Y','Y','Y',NULL,NULL,'Cadastro de tipos de obrigações ','Formulário'),(8,'form_kanban_atividades','Y','','','Y',NULL,NULL,'Kanban de  atividades','Formulário'),(8,'form_kanban_atividades_add_registro','Y','','','Y',NULL,NULL,'Cadastrar atividades pelo kanban','Formulário'),(8,'form_LGPD_0002_conf_smpt','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Configurações / Configuração de envio de e-mails: Acesso à configuração do endereço de de SMTP para envio de e-mails da plataforma','Formulário'),(8,'form_LGPD_2001_form_entr_prc','Y',NULL,NULL,NULL,'Y','Y',NULL,'Fluxo de Informação'),(8,'form_LGPD_2003_envio_entr_prc','Y',NULL,NULL,NULL,'Y','Y',NULL,'Fluxo de Informação'),(8,'form_LGPD_2087_ndas','Y',NULL,NULL,NULL,'Y','Y',NULL,'Fluxo de Informação'),(8,'form_LGPD_2097_assoc_med_atv',NULL,NULL,NULL,NULL,NULL,NULL,'Cadastro de Medidas Técnicas - > Cadastro da especificação da associação entre medida técnica e ativo','Painel'),(8,'form_LGPD_3500_checklist_risk_padrao','Y','','','','Y','Y','[Item de menu] - Riscos / Checklist padrão de identificação de riscos e atividades','Riscos'),(8,'form_LGPD_3600_chklst_risk_area_mestre','Y','','','','Y','Y','Formulário de checklist por área de identificação de riscos e atividades','Riscos'),(8,'form_LGPD_4000_atividades','Y','','','Y',NULL,NULL,'Cadastro de atividades de adequação','Formulário'),(8,'form_LGPD_4000_atividades_calendar',NULL,NULL,NULL,NULL,NULL,NULL,'Cadastro de atividades de adequação','Formulário'),(8,'form_minhas_obr_CMP_1610_ol_agenda',NULL,NULL,NULL,NULL,NULL,NULL,'Edição das minhas obrigações legais ','Painel'),(8,'form_new_pln_acao','Y','','','',NULL,NULL,'Cadastrar plano de ação','Formulário'),(8,'form_PAC_1100_sol_portal',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(8,'form_pcp_9100_LIA','Y',NULL,NULL,NULL,'Y','Y',NULL,'Fluxo de Informação'),(8,'form_public_LGPD_0100_diagnostico','','','','',NULL,NULL,'Parametrizar etapa de diagnóstico','Formulário'),(8,'form_public_LGPD_0200_implement','','','','',NULL,NULL,'Parametrizar etapa de implementação','Formulário'),(8,'form_public_LGPD_0300_operacao','','','','',NULL,NULL,'Parametrizar etapa de operação','Formulário'),(8,'form_public_LGPD_0400_etapas','','','','',NULL,NULL,'Parametrizar etapas','Formulário'),(8,'form_public_LGPD_1000_controlador','Y','','','',NULL,NULL,'Cadastro de controlador','Formulário'),(8,'form_public_LGPD_1001_diretoria','Y','Y','Y','Y',NULL,NULL,'Cadastro de diretoria','Formulário'),(8,'form_public_LGPD_1002_area','Y','Y','Y','Y',NULL,NULL,'Cadastro de área','Formulário'),(8,'form_public_LGPD_1003_departamento','Y','Y','Y','Y',NULL,NULL,'Cadastro de departamentos','Formulário'),(8,'form_public_LGPD_1004_cargos','Y','Y','Y','Y',NULL,NULL,'Cadastro de cargos','Formulário'),(8,'form_public_LGPD_1050_organograma','Y','Y','Y','Y',NULL,NULL,'Cadastro de organograma','Formulário'),(8,'form_public_LGPD_1051_comite','Y','Y','Y','Y',NULL,NULL,'Cadastro de comitê','Formulário'),(8,'form_public_LGPD_1053_eventos_comite','Y','','','',NULL,NULL,'Agenda de eventos do comitê','Formulário'),(8,'form_public_LGPD_1100_equipe','Y','Y','Y','Y',NULL,NULL,'Cadastro de equipe','Formulário'),(8,'form_public_LGPD_1100_equipe_1','Y','Y','Y','Y',NULL,NULL,'Cadastro de equipe','Formulário'),(8,'form_public_LGPD_2000_processos','Y','','','Y',NULL,NULL,'Cadastro de processos','Formulário'),(8,'form_public_LGPD_2010_ativos','','','','',NULL,NULL,'Cadastro de ativos','Formulário'),(8,'form_public_LGPD_2020_artefatos','','','','',NULL,NULL,'Cadastro de artefatos','Formulário'),(8,'form_public_LGPD_2030_dados','','','','',NULL,NULL,'Cadastro de metadados','Formulário'),(8,'form_public_LGPD_2060_config_assoc',NULL,NULL,NULL,NULL,NULL,NULL,'Associação artefato x metadados','Formulário'),(8,'form_public_LGPD_2065_fund_legal','Y','Y','Y','Y',NULL,NULL,'Cadastro de fundamentos legais','Formulário'),(8,'form_public_LGPD_2066_ambiente_reg','Y','Y','Y','Y',NULL,NULL,'Cadastro de ambientes regulatórios','Formulário'),(8,'form_public_LGPD_2070_finalidades','','','','',NULL,NULL,'Parametrizar finalidades','Formulário'),(8,'form_public_LGPD_2070_registrar_finalidades','','','','',NULL,NULL,'Registrar finalidades','Formulário'),(8,'form_public_LGPD_2075_param_assoc_funcional_fin',NULL,NULL,NULL,NULL,NULL,NULL,'Associação funcional da finalidade','Formulário'),(8,'form_public_LGPD_2080_politicas','Y','','','',NULL,NULL,'Cadastro de políticas','Formulário'),(8,'form_public_LGPD_2085_contratos','Y','Y','Y','Y',NULL,NULL,'Cadastro de contratos','Formulário'),(8,'form_public_LGPD_2090_terceiros','Y','Y','Y','Y',NULL,NULL,'Cadastro de terceiros','Formulário'),(8,'form_public_LGPD_2093_ocorr_terc','Y','Y','Y','Y',NULL,NULL,'Cadastro de ocorrência de terceiros','Formulário'),(8,'form_public_LGPD_2095_med_tec','','','','',NULL,NULL,'Cadastro de medidas técnicas','Formulário'),(8,'form_public_LGPD_2097_config_assoc_med_atv',NULL,NULL,NULL,NULL,NULL,NULL,'Associar medidas técnicas aos ativos','Formulário'),(8,'form_public_LGPD_2100_prz_aprv_proc','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Configurações / SLA de aprovação de Processos de Negócio: Acesso à configuração do prazo limite para aprovação de Processos de Negócio cadastrados','Formulário'),(8,'form_public_LGPD_3000_riscos','Y','Y','Y','Y',NULL,NULL,'Cadastro de riscos','Formulário'),(8,'form_public_LGPD_4000_atividades','Y','','','Y',NULL,NULL,'Cadastro de atividades','Formulário'),(8,'form_public_LGPD_5000_cod_etica','Y','Y','Y','Y',NULL,NULL,'Cadastro de código de ética','Formulário'),(8,'form_public_LGPD_5100_cod_conduta',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(8,'form_public_LGPD_6000_PDCA','Y','Y','Y','Y',NULL,NULL,'PDCA','Formulário'),(8,'form_public_LGPD_6100_catalog_treinamentos','Y','','','',NULL,NULL,'Cadastro de catalogo de treinamentos','Formulário'),(8,'form_public_LGPD_6200_agenda_treina','Y','Y','Y','Y',NULL,NULL,'Agenda de treinamentos','Formulário'),(8,'form_public_LGPD_7300_envio_aval_forne','Y','Y','Y','Y',NULL,NULL,'Cadastro de questionários (Due Diligence)','Formulário'),(8,'form_public_LGPD_assoc_contr_6500',NULL,NULL,NULL,NULL,NULL,NULL,'Associação de contratos','Formulário'),(8,'form_public_LGPD_assoc_medtec_6700',NULL,NULL,NULL,NULL,NULL,NULL,'Associação de medidas técnicas','Formulário'),(8,'form_public_LGPD_assoc_pdca_risk_6400',NULL,NULL,NULL,NULL,NULL,NULL,'Associação de riscos ao PDCA','Formulário'),(8,'form_public_LGPD_assoc_pol_6300',NULL,NULL,NULL,NULL,NULL,NULL,'Associação de políticas','Formulário'),(8,'form_public_LGPD_assoc_proc_6600',NULL,NULL,NULL,NULL,NULL,NULL,'Associação de processos','Formulário'),(8,'form_public_LGPD_assoc_treina_6500',NULL,NULL,NULL,NULL,NULL,NULL,'Associação de treinamentos','Formulário'),(8,'form_public_LGPD_config_det_opt_7200','Y','Y','Y','Y',NULL,NULL,'Parametrizar opções do questionário de fornecedores','Formulário'),(8,'form_public_PAC_1000_user_portal',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(8,'Governance_menu',NULL,NULL,NULL,NULL,NULL,NULL,'Menu',NULL),(8,'grid_CMP_0100_faixas',NULL,NULL,NULL,NULL,NULL,NULL,'Consultar faixas de setup de auditoria','Painel'),(8,'grid_CMP_1000_mecanismos','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Pilares do Compliance / Mecanismos de Auditoria: Acesso ao cadastro de Mecanismos de Auditoria para projetos de Compliance','Pilares de Compliance'),(8,'grid_CMP_1100_componentes','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Pilares do Compliance / Componentes de Auditoria: Acesso ao cadastro de Componentes de Auditoria, que compõem os Mecanismos cadastrados','Pilares de Compliance'),(8,'grid_CMP_1100_entrevistados_desassociados',NULL,NULL,NULL,NULL,NULL,NULL,'Consultas candidatos a entrevistas de ciclo de auditoria ','Painel'),(8,'grid_CMP_1200_questoes','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Pilares do Compliance / Questões de Auditoria: Acesso ao cadastro de perguntas que são utilizadas para a realização de auditorias de Compliance','Pilares de Compliance'),(8,'grid_CMP_1300_formularios','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Pilares do Compliance / Formulários de Auditoria: Acesso ao cadastro e configuração de Formulários compostos por perguntas para a realização de auditorias de Compliance','Pilares de Compliance'),(8,'grid_CMP_1310_formulario_det',NULL,NULL,NULL,NULL,NULL,NULL,'Consulta detalhes do formulário de auditoria ','Painel'),(8,'grid_CMP_1400_formulas_mestre','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Pilares do Compliance / Parâmetros de Ciclos de Auditoria: Acesso à configuração de parâmetros quantitativos utilizados nos Ciclos de Auditoria de Compliance','Pilares de Compliance'),(8,'grid_CMP_1410_formulas_det_mec',NULL,NULL,NULL,NULL,NULL,NULL,'Sub Consulta mecanismos do setup de auditoria','Painel'),(8,'grid_CMP_1500_acao','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Pilares do Compliance / Ações de Auditoria: Acesso ao cadastro de ações pré-determinadas para serem sugeridas a partir do levantamento de determinada Questão cadastrada','Pilares de Compliance'),(8,'grid_CMP_1550_ger_acao','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Auditoria de Compliance / Recomendações de Auditoria: Acesso à geração automática de recomendações pós Ciclo de Auditoria de Compliance','Auditoria de Compliance'),(8,'grid_CMP_1600_OL','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Aspectos Jurídicos / Obrigações Legais: Acesso ao cadastro das obrigações legais que a entidade deve atender em um determinado exercício','Aspectos Jurídicos'),(8,'grid_CMP_2000_ciclos','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Auditoria de Compliance / Ciclos de Auditoria: Acesso à gestão de Ciclos de Auditoria de Compliance','Auditoria de Compliance'),(8,'grid_CMP_2500_conf_entrevistados','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Auditoria de Compliance / Entrevistados: Acesso à seleção de entrevistados que estarão associados a um Ciclo de Auditoria de Compliance','Auditoria de Compliance'),(8,'grid_CMP_2510_entrevistados_associados',NULL,NULL,NULL,NULL,NULL,NULL,'Relação de entrevistados de um ciclo de auditoria','Painel'),(8,'grid_CMP_3000_aplic_pesq','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Auditoria de Compliance / Pesquisas de Auditoria: Acesso à aplicação de Pesquisas de Auditoria de Compliance','Auditoria de Compliance'),(8,'grid_CMP_acompanhar_pesquisas',NULL,NULL,NULL,NULL,NULL,NULL,'Consulta acompanhamento do andamento de pesquisas de auditorias','Painel'),(8,'grid_CMP_resultado_pesquisa','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Auditoria de Compliance / Resultados de Auditoria: Acesso à gestão do resultado de Pesquisas de Auditoria de Compliance','Auditoria de Compliance'),(8,'grid_CMP_resultado_pesquisa_questoes',NULL,NULL,NULL,NULL,NULL,NULL,'Consulta resultado da pesquisa de auditoria ','Painel'),(8,'grid_CMP_resultado_pesquisa_status_mecanismo',NULL,NULL,NULL,NULL,NULL,NULL,'Consulta resultado da pesquisa por mecanismos de auditoria ','Painel'),(8,'grid_conf_quest_7100',NULL,NULL,NULL,NULL,NULL,NULL,'Cofiguração de questionário para fornecedores','Painel'),(8,'grid_DOM_tp_ol_1600','',NULL,NULL,NULL,NULL,NULL,'[Item de menu] - Aspectos Jurídicos / Tipos de Obrigações Legais: Acesso ao cadastro de tipos de obrigações legais','Aspectos Jurídicos'),(8,'grid_kanban_atividades',NULL,NULL,NULL,NULL,NULL,NULL,'Kanban de  atividades','Painel'),(8,'grid_kanban_atividades_add_registro',NULL,NULL,NULL,NULL,NULL,NULL,'Kanban de  atividades','Painel'),(8,'grid_LGPD_2001_form_entr_prc','Y',NULL,NULL,NULL,'Y','Y',NULL,'Fluxo de Informação'),(8,'grid_LGPD_2003_envio_entr_prc','Y',NULL,NULL,NULL,'Y','Y',NULL,'Fluxo de Informação'),(8,'grid_LGPD_2040_assoc_prc_atv','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Fluxo de Informação / Associações do Fluxo de Informação: Acesso à consulta das associações entre Processos de Negócio x Ativos de Informação x Artefatos x Metadados Pessoais','Fluxo de Informação'),(8,'grid_LGPD_2075_assoc_funcional_dados_fin',NULL,NULL,NULL,NULL,NULL,NULL,'Consulta associação de metadados','Painel'),(8,'grid_LGPD_2087_ndas','Y',NULL,NULL,NULL,'Y','Y',NULL,'Políticas e Regulamentos'),(8,'grid_LGPD_2097_assoc_med_atv','',NULL,NULL,NULL,NULL,NULL,'[Item de menu] - Medidas Técnicas de Segurança / Associações com Ativos de Informação: Acesso à configuração da associação entre Medidas Técnicas de Segurança e Ativos de Informação utilizados pela entidade','Medidas Técnicas de Segurança'),(8,'grid_LGPD_3100_assoc_risc_atv','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Riscos / Associações de Riscos: Acesso à associações entre Riscos e outras informações cadastradas','Riscos'),(8,'grid_LGPD_3600_chklst_risk_area_mestre','Y','','','','Y','Y','[Item de menu] - Riscos / Checklist por área de identificação de riscos e atividades','Riscos'),(8,'grid_LGPD_6300_aluno_treina',NULL,NULL,NULL,NULL,NULL,NULL,'Consulta de lista de treinamentos realizados por colaborador','Painel'),(8,'grid_LGPD_7400_resp_aval_forne',NULL,NULL,NULL,NULL,NULL,NULL,'Consulta respostas de questionários  (Due Diligence)','Painel'),(8,'grid_new_pln_acao','',NULL,NULL,NULL,NULL,NULL,'[Item de menu] - Atividades e Ações / Plano de Ação LGPD: Acesso ao cadastro do documento \"Plano de Ação\" de adequação à LGPD','Atividades e Ações'),(8,'grid_public_LGPD_0100_diagnostico','',NULL,NULL,NULL,NULL,NULL,'[Item de menu] - Configurações / Projeto de Diagnóstico da LGPD: Acesso à configuração das informações sobre o projeto de Diagnóstico da LGPD','Configurações'),(8,'grid_public_LGPD_0200_implement','',NULL,NULL,NULL,NULL,NULL,'[Item de menu] - Configurações / Projeto de Adequação da LGPD: Acesso à configuração das informações sobre o projeto de Adequação da LGPD','Configurações'),(8,'grid_public_LGPD_0300_operacao','',NULL,NULL,NULL,NULL,NULL,'[Item de menu] - Configurações / Projeto de Operação da LGPD: Acesso à configuração das informações sobre a fase de Operação da LGPD','Configurações'),(8,'grid_public_LGPD_0400_etapas','',NULL,NULL,NULL,NULL,NULL,'[Item de menu] - Configurações / Etapas do Diagnóstico da LGPD: Acesso à configuração das etapas do projeto de Diagnóstico de um projeto de adequação à LGPD','Configurações'),(8,'grid_public_LGPD_1000_controlador','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Configurações / Entidade: Acesso à configuração dos dados da entidade','Configurações'),(8,'grid_public_LGPD_1001_diretoria','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Estrutura Organizacional / Diretoria: Acesso ao cadastro de Diretorias, que é o nível mais alto da hierarquia organizacional da entidade','Estrutura Organizacional'),(8,'grid_public_LGPD_1002_area','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Estrutura Organizacional / Área: Acesso ao cadastro de Áreas, que dividem uma determinada Diretoria na estrutura hierárquica da entidade','Estrutura Organizacional'),(8,'grid_public_LGPD_1003_departamento','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Estrutura Organizacional / Departamentos: Acesso ao cadastro de Departamentos, que dividem uma determinada Área na estrutura hierárquica da entidade','Estrutura Organizacional'),(8,'grid_public_LGPD_1004_cargos','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Estrutura Organizacional / Cargos: Acesso ao cadastro de Cargos a serem ocupados por pessoas da equipe que ocupem espaço na estrutura hierárquica da entidade','Estrutura Organizacional'),(8,'grid_public_LGPD_1050_organograma','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Estrutura Organizacional / Lotação: Acesso ao cadastro de unidades de trabalho, onde é possível alocar as equipes da entidade','Estrutura Organizacional'),(8,'grid_public_LGPD_1051_comite','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Estrutura Organizacional / Comitês: Acesso ao cadastro de comitês da entidade, que congregam uma ou mais pessoas previamente cadastradas','Estrutura Organizacional'),(8,'grid_public_LGPD_1053_eventos_comite','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Atividades e Ações / Eventos de Comitê: Acesso ao cadastro de eventos associados aos Comitês da entidade','Atividades e Ações'),(8,'grid_public_LGPD_1053_sub_eventos_comite',NULL,NULL,NULL,NULL,NULL,NULL,'Sub Consulta de Eventos','Painel'),(8,'grid_public_LGPD_1100_equipe','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Estrutura Organizacional / Equipe: Acesso ao cadastro de pessoas que podem ocupar cargos na estrutura hierárquica da entidade. Essas pessoas serão associadas a diversas outras entidades tratadas na plataforma','Estrutura Organizacional'),(8,'grid_public_LGPD_2000_proc_aprv_prz_expirado','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Atividades e Ações / Processos de Negócio Pendentes: Acesso à gestão de Processos de Negócio com SLA de aprovação expirado','Atividades e Ações'),(8,'grid_public_LGPD_2000_processos','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Fluxo de Informação / Processos de Negócio: Acesso ao cadastro de Processos de Negócio que definem as rotinas operacionais da entidade','Fluxo de Informação'),(8,'grid_public_LGPD_2000_sub_proc_pessoa',NULL,NULL,NULL,NULL,NULL,NULL,'Consulta processo por responsável','Painel'),(8,'grid_public_LGPD_2000_sub_processos_atv',NULL,NULL,NULL,NULL,NULL,NULL,'Consulta processos por ativos','Painel'),(8,'grid_public_LGPD_2010_ativos','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Fluxo de Informação / Ativos de Informação: Acesso ao cadastro de Ativos de Informação utilizados pela entidade na execução de seus Processos de Negócio','Fluxo de Informação'),(8,'grid_public_LGPD_2010_ativos_1',NULL,NULL,NULL,NULL,NULL,NULL,'Consulta Ativos','Painel'),(8,'grid_public_LGPD_2010_ativos_n_utlz_fin',NULL,NULL,NULL,NULL,NULL,NULL,'Processos disponivel para associação com finalidades','Painel'),(8,'grid_public_LGPD_2010_ativos_utlz_fin',NULL,NULL,NULL,NULL,NULL,NULL,'Processos associados a finalidade','Painel'),(8,'grid_public_LGPD_2010_sub_ativos',NULL,NULL,NULL,NULL,NULL,NULL,'Sub Consulta de Ativos','Painel'),(8,'grid_public_LGPD_2020_artefatos','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Fluxo de Informação / Artefatos: Acesso ao cadastro de Artefatos e Documentos tratados nos Ativos de Informação utilizados pela entidade','Fluxo de Informação'),(8,'grid_public_LGPD_2020_artefatos_n_utlz_fin',NULL,NULL,NULL,NULL,NULL,NULL,'Artefatos disponiveis para associação com finalidades','Painel'),(8,'grid_public_LGPD_2020_artefatos_utlz_fin',NULL,NULL,NULL,NULL,NULL,NULL,'Artefatos associados a finalidades','Painel'),(8,'grid_public_LGPD_2030_assoc_art_metadados',NULL,NULL,NULL,NULL,NULL,NULL,'Associação de Artefatos e metadados','Painel'),(8,'grid_public_LGPD_2030_dados','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Fluxo de Informação / Metadados Pessoais: Acesso ao cadastro de Metadados Pessoais presentes nos diferentes Artefatos utilizados pela entidade','Fluxo de Informação'),(8,'grid_public_LGPD_2065_fund_legal','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Aspectos Jurídicos / Fundamentos Legais: Acesso ao cadastro de Fundamentos Legais utilizados pela entidade','Aspectos Jurídicos'),(8,'grid_public_LGPD_2066_ambiente_reg','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Aspectos Jurídicos / Ambientes regulatórios: Acesso ao cadastro de Ambientes Regulatórios a serem associados a Fundamentos Legais utilizados pela entidade','Aspectos Jurídicos'),(8,'grid_public_LGPD_2070_finalidades','',NULL,NULL,NULL,NULL,NULL,'[Item de menu] - Tratamento de Dados Pessoais / Parametrizar Finalidades de Tratamentos: Acesso à configuração dos aspectos e detalhes das Finalidades de Tratamento de Dados Pessoais previamente cadastradas','Tratamento de Dados Pessoais'),(8,'grid_public_LGPD_2070_registrar_finalidades','',NULL,NULL,NULL,NULL,NULL,'[Item de menu] - Tratamento de Dados Pessoais / Registrar Finalidade de Tratamento: Acesso ao cadastro de Finalidades de Tratamento de Dados Pessoais executadas pela entidade','Tratamento de Dados Pessoais'),(8,'grid_public_LGPD_2070_sub_contratos_finalidades',NULL,NULL,NULL,NULL,NULL,NULL,'Sub consulta de contratos dentro da finalidade','Painel'),(8,'grid_public_LGPD_2070_sub_finalidades',NULL,NULL,NULL,NULL,NULL,NULL,'Sub consulta de finalidades','Painel'),(8,'grid_public_LGPD_2073_assoc_ativos_fin',NULL,NULL,NULL,NULL,NULL,NULL,'Associação de ativos na finalidade','Painel'),(8,'grid_public_LGPD_2075_assoc_metadados_fin',NULL,NULL,NULL,NULL,NULL,NULL,'Associação de metadados na finalidade','Painel'),(8,'grid_public_LGPD_2080_politicas','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Políticas e Regulamentos / Políticas: Acesso ao cadastro de políticas associadas à Governança de Privacidade da entidade','Políticas e Regulamentos'),(8,'grid_public_LGPD_2085_contratos','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Políticas e Regulamentos / Contratos: Acesso ao cadastro de contratos e modelos de contratos utilizados pela entidade','Políticas e Regulamentos'),(8,'grid_public_LGPD_2090_terceiros','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Gestão de terceiros / Terceiros: Acesso ao cadastro de entidades terceiras (PJ ou PF) associadas à entidade','Gestão de Terceiros'),(8,'grid_public_LGPD_2093_ocorr_terc','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Gestão de terceiros / Ocorrências: Acesso ao cadastro de ocorrências relacionadas à Terceiros associados à entidade','Gestão de Terceiros'),(8,'grid_public_LGPD_2095_med_tec','',NULL,NULL,NULL,NULL,NULL,'[Item de menu] - Medidas Técnicas de Segurança / Medidas Técnicas de Segurança: Acesso ao cadastro de Medidas Técnicas de Segurança da Informação que podem ser associadas a Ativos cadastrados','Medidas Técnicas de Segurança'),(8,'grid_public_LGPD_2095_sub_med_tec',NULL,NULL,NULL,NULL,NULL,NULL,'Sub Consulta de medidas técnicas','Painel'),(8,'grid_public_LGPD_3000_riscos','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Riscos / Riscos: Acesso ao cadastro de Riscos de Privacidade e Compliance','Riscos'),(8,'grid_public_LGPD_3000_sub_consulta_riscos',NULL,NULL,NULL,NULL,NULL,NULL,'Sub consulta de riscos','Painel'),(8,'grid_public_LGPD_3300_assoc_risc_prc',NULL,NULL,NULL,NULL,NULL,NULL,'Associar risco a processos','Painel'),(8,'grid_public_LGPD_4000_atividades','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Atividades e Ações / Atividades e Ações: Acesso ao cadastro de atividades e ações de governança e compliance','Atividades e Ações'),(8,'grid_public_LGPD_5000_cod_etica','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Políticas e Regulamentos / Códigos e Regulamentos Internos: Acesso ao cadastro de documentos que definem as regras internas de Compliance da entidade','Políticas e Regulamentos'),(8,'grid_public_LGPD_5100_cod_conduta',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(8,'grid_public_LGPD_6000_PDCA','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Atividades e Ações / Gestão de ciclo de PDCA de Compliance: Acesso ao planejamento e gestão de ciclos de PDCA de Compliance','Atividades e Ações'),(8,'grid_public_LGPD_6000_SUB_PDCA',NULL,NULL,NULL,NULL,NULL,NULL,'Sub consulta PDCA','Painel'),(8,'grid_public_LGPD_6100_catalog_treinamentos','',NULL,NULL,NULL,NULL,NULL,'[Item de menu] - Atividades e Ações / Catálogo de treinamentos: Acesso ao cadastro dos tipos de treinamentos que a entidade pode executar para suas equipes','Atividades e Ações'),(8,'grid_public_LGPD_6200_agenda_treina','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Atividades e Ações / Agenda de Treinamentos: Acesso à gestão de agenda de treinamentos e capacitações internas da entidade','Atividades e Ações'),(8,'grid_public_LGPD_7300_envio_aval_forne',NULL,NULL,NULL,NULL,NULL,NULL,'Consulta de questionários (Due Diligence)','Painel'),(8,'grid_public_LGPD_7300_envio_aval_forne_gerencial','Y',NULL,NULL,NULL,'Y','Y',NULL,'Gestão de Terceiros'),(8,'grid_public_LGPD_cons_rev_contr_6500',NULL,NULL,NULL,NULL,NULL,NULL,'Consulta revisões de contrato','Painel'),(8,'grid_public_LGPD_cons_rev_medtec_6700',NULL,NULL,NULL,NULL,NULL,NULL,'Consulta revisões de medidas técnicas','Painel'),(8,'grid_public_LGPD_cons_rev_pol_6300',NULL,NULL,NULL,NULL,NULL,NULL,'Consulta revisão de políticas','Painel'),(8,'grid_public_LGPD_cons_rev_proc_6600',NULL,NULL,NULL,NULL,NULL,NULL,'Consulta revisão de processos','Painel'),(8,'grid_public_LGPD_cons_rev_risk_6400',NULL,NULL,NULL,NULL,NULL,NULL,'Consulta revisão de riscos','Painel'),(8,'grid_public_PAC_9000_DPIA',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(8,'grid_public_PAC_9100_LIA',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(8,'grid_public_PCP_9000_DPIA',NULL,NULL,NULL,NULL,NULL,NULL,'Consulta DPIA',NULL),(8,'grid_public_pcp_9100_LIA',NULL,NULL,NULL,NULL,NULL,NULL,'Consulta LIA ',NULL),(8,'grid_public_subconsulta_sec_users',NULL,NULL,NULL,NULL,NULL,NULL,'Sub consulta de usuarios','Painel'),(8,'grid_sc_log','',NULL,NULL,NULL,NULL,NULL,'[Item de menu] - Segurança / Histórico de acessos: Acesso à consulta à histórico de acessos de usuários à plataforma','Segurança'),(8,'help_cadastro_titulares',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(8,'help_ciclo_de_vida',NULL,NULL,NULL,NULL,NULL,NULL,'Help Ciclo de vida','Painel'),(8,'help_finalidades_fundamentos',NULL,NULL,NULL,NULL,NULL,NULL,'Help Finalidades','Painel'),(8,'help_geracao_atividades',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(8,'help_geracao_riscos',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(8,'help_gestao_consentimentos',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(8,'help_gestao_incidentes',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(8,'help_gestao_notificacao',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(8,'help_integracao_portais',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(8,'help_lotes_validacao',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(8,'help_medidas_administrativas',NULL,NULL,NULL,NULL,NULL,NULL,'Help medidas administrativas','Painel'),(8,'help_medidas_tecnicas',NULL,NULL,NULL,NULL,NULL,NULL,'Help para medidas técnicas','Painel'),(8,'help_plano_acao_atividades',NULL,NULL,NULL,NULL,NULL,NULL,'Help Atividades','Painel'),(8,'help_relatorios',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(8,'help_riscos_e_impactos',NULL,NULL,NULL,NULL,NULL,NULL,'Help Riscos','Painel'),(8,'homepage',NULL,NULL,NULL,NULL,NULL,NULL,'Home Page (Responsábilidades e Atividades)','Painel'),(8,'homepage_help',NULL,NULL,NULL,NULL,NULL,NULL,'Help','Painel'),(8,'mapa_calor_risco',NULL,NULL,NULL,NULL,NULL,NULL,'Mapa de risco','Painel'),(8,'Mapa_Calor_Riscos',NULL,NULL,NULL,NULL,NULL,NULL,'Mapa de calor de riscos ','Painel'),(8,'menu',NULL,NULL,NULL,NULL,NULL,NULL,'Menu PCP','Painel'),(8,'menu_dinamico',NULL,NULL,NULL,NULL,NULL,NULL,'Menu','Painel'),(8,'Menu_Pac',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(8,'Metadados','',NULL,NULL,NULL,NULL,NULL,'[Item de menu] - Painel / Metadados Pessoais: Acesso à exibição dos principais indicadores sobre Metadados Pessoais','Painel'),(8,'novo_menu',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(8,'pac_app_change_pswd','Y','','','','','','[Item de menu] - SeguranÃ§a / AlteraÃ§Ã£o de senha: Acesso Ã  gestÃ£o de senhas de usuÃ¡rios da plataforma','SeguranÃ§a'),(8,'pac_app_form_sec_groups_apps','',NULL,NULL,NULL,NULL,NULL,'[Item de menu] - SeguranÃ§a / AssociaÃ§Ã£o de perfis a aplicaÃ§Ãµes: Acesso Ã  configuraÃ§Ã£o da associaÃ§Ã£o de perfis de acesso com as aplicaÃ§Ãµes da plataforma','SeguranÃ§a'),(8,'pac_app_grid_sec_apps','',NULL,NULL,NULL,NULL,NULL,'[Item de menu] - SeguranÃ§a / AplicaÃ§Ãµes: Acesso ao cadastro de aplicaÃ§Ãµes da plataforma','SeguranÃ§a'),(8,'pac_app_grid_sec_groups','',NULL,NULL,NULL,NULL,NULL,'[Item de menu] - SeguranÃ§a / Perfis: Acesso ao cadastro de perfis de acesso dos usuÃ¡rios da plataforma','SeguranÃ§a'),(8,'pac_app_grid_sec_users','',NULL,NULL,NULL,NULL,NULL,'[Item de menu] - SeguranÃ§a / UsuÃ¡rios: Acesso ao cadastro de usuÃ¡rios da plataforma','SeguranÃ§a'),(8,'pac_app_grid_sec_users_groups','',NULL,NULL,NULL,NULL,NULL,'[Item de menu] - SeguranÃ§a / AssociaÃ§Ã£o de usuÃ¡rios a perfis: Acesso Ã  configuraÃ§Ã£o da associaÃ§Ã£o de usuÃ¡rios a perfis de acesso','SeguranÃ§a'),(8,'pac_app_search_sec_groups','',NULL,NULL,NULL,NULL,NULL,'[Item de menu] - SeguranÃ§a / AssociaÃ§Ã£o de perfis a aplicaÃ§Ãµes: Acesso Ã  configuraÃ§Ã£o da associaÃ§Ã£o de perfis de acesso com as aplicaÃ§Ãµes da plataforma','SeguranÃ§a'),(8,'pac_menu',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(8,'PAG_menu',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(8,'param_aval_mestre_7000','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Gestão de terceiros / Formulários de due diligence: Acesso à criação de formulários (e suas questões) para auto avaliação de terceiros','Gestão de Terceiros'),(8,'PDCA','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Painel / Ciclos de PDCA: Acesso à exibição dos principais indicadores sobre Ciclos de PDCA de Compliance','Painel'),(8,'pdfreport_LGPD_7300_envio_aval_forne',NULL,NULL,NULL,NULL,NULL,NULL,'geração de PDF - questionário (Due Diligence)','Painel'),(8,'popup_confirm_action',NULL,NULL,NULL,NULL,NULL,NULL,'Pop-up ( não se aplica ao módulo de segirança)','Painel'),(8,'popup_confirm_action_status',NULL,NULL,NULL,NULL,NULL,NULL,'Pop_Up ( Não se plaica ao módulo de segurança ) ','Painel'),(8,'Processos','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Painel / Processos de Negócio: Acesso à exibição dos principais indicadores sobre Processos de Negócio','Painel'),(8,'relatorio_ciclos_complience',NULL,NULL,NULL,NULL,NULL,NULL,'Extrato de cilco de auditoria ','Painel'),(8,'relatorio_dpia',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(8,'relatorio_dpia_1',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(8,'relatorio_finalidades',NULL,NULL,NULL,NULL,NULL,NULL,'Relatório de finalidades','Painel'),(8,'relatorio_lia',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(8,'relatorio_notificacao',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(8,'relatorio_resp_aval',NULL,NULL,NULL,NULL,NULL,NULL,'Relatório Avaliações','Painel'),(8,'resumo_finalidade',NULL,NULL,NULL,NULL,NULL,NULL,'Resumo de finalidade','Painel'),(8,'Riscos','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Painel / Riscos: Acesso à exibição dos principais indicadores sobre Gestão de Riscos de Privacidade e Compliance','Painel'),(8,'risk_heat_map','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Riscos / Mapa de Calor: Acesso à exibição do Mapa de Calor dos Riscos cadastrados','Riscos'),(8,'search_public_LGPD_4000_atividades',NULL,NULL,NULL,NULL,NULL,NULL,'Filtro de atividades','Painel'),(8,'sec_change_pswd',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(8,'sec_form_add_users',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(8,'sec_form_edit_users',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(8,'sec_form_sec_apps',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(8,'sec_form_sec_groups',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(8,'sec_form_sec_groups_apps',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(8,'sec_grid_sec_apps',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(8,'sec_grid_sec_groups',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(8,'sec_grid_sec_users',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(8,'sec_grid_sec_users_groups',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(8,'sec_Login',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(8,'sec_menu',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(8,'sec_retrieve_pswd',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(8,'sec_search_sec_groups',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(8,'sec_settings',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(8,'sec_sync_apps',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(8,'sub_consulta_3000_riscos_incidente',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(8,'sub_consulta_3100_assoc_risc_atv',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(8,'sub_consulta_3300_assoc_risc_prc',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(8,'sub_consulta_3400_assoc_risc_fin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(8,'sub_consulta_CMP_1610_ol_agenda',NULL,NULL,NULL,NULL,NULL,NULL,'Sub consulta de agenda de obrigações legais por obrigação','Painel'),(8,'sub_consulta_CMP_2510_det_conf_entrevistados',NULL,NULL,NULL,NULL,NULL,NULL,'Entrevitados em presquisa de auditoria --> Sub Consulta de configuração de entrevidados de pesquisa de auditoria ','Painel'),(8,'sub_consulta_CMP_3000_aplic',NULL,NULL,NULL,NULL,NULL,NULL,'Sub consulta status da aplicação de pesquisa de auditoria','Painel'),(8,'sub_consulta_CMP_4000_respostas_mestre',NULL,NULL,NULL,NULL,NULL,NULL,'Sub consulta status de respostas dos formulários de auditoria dentro de um ciclo ','Painel'),(8,'sub_consulta_configurar_metadados',NULL,NULL,NULL,NULL,NULL,NULL,'Sub consulta configuração de metadados','Painel'),(8,'sub_consulta_LGPD_2097_assoc_med_atv',NULL,NULL,NULL,NULL,NULL,NULL,'Sub consulta de associação entre medidas técnicas e ativos','Painel'),(8,'sub_consulta_LGPD_6200_agenda_treina',NULL,NULL,NULL,NULL,NULL,NULL,'Sub consulta de agenda de treinamentos ','Painel'),(8,'sub_consulta_PAC_1100_sol_portal',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(8,'sub_consulta_PAC_3200_tit_consent',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(8,'sub_consulta_PAC_4000_notificacao',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(8,'sub_consulta_PAG_ocorr_lote_1100',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(8,'sub_form_configurar_metados',NULL,NULL,NULL,NULL,NULL,NULL,'Configurar metadados','Painel'),(8,'sub_grid_CMP_1550_ger_acao',NULL,NULL,NULL,NULL,NULL,NULL,'Sub grid de recomendaçoes de auditoria por ciclo','Painel'),(8,'sub_grid_LGPD_2050_assoc_atv_art',NULL,NULL,NULL,NULL,NULL,NULL,'Sub consulta de associação entre ativos e artefatos',NULL),(8,'sub_grid_PAC_1400_tit_afet_inc',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(8,'sub_grid_public_LGPD_2093_ocorr_terc',NULL,NULL,NULL,NULL,NULL,NULL,'Sub consulta ocorrência de terceiros','Painel'),(9,'app_change_pswd','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Segurança / Alteração de senha: Acesso à gestão de senhas de usuários da plataforma','Segurança'),(9,'app_form_add_users','Y','Y','Y','Y',NULL,NULL,'Cadastrar usuários','Formulário'),(9,'app_form_edit_users','Y','Y','Y','Y',NULL,NULL,'Alterar usuários','Formulário'),(9,'app_form_sec_apps','Y','Y','Y','Y',NULL,NULL,'Cadastrar aplicações','Formulário'),(9,'app_form_sec_groups','Y','Y','Y','Y',NULL,NULL,'Cadastro de grupos de usuários','Formulário'),(9,'app_form_sec_groups_apps','Y','Y','Y','Y',NULL,NULL,'Associar grupos x aplicações','Painel'),(9,'app_grid_sec_apps','',NULL,NULL,NULL,NULL,NULL,'[Item de menu] - Segurança / Aplicações: Acesso ao cadastro de aplicações da plataforma','Segurança'),(9,'app_grid_sec_groups','',NULL,NULL,NULL,NULL,NULL,'[Item de menu] - Segurança / Perfis: Acesso ao cadastro de perfis de acesso dos usuários da plataforma','Segurança'),(9,'app_grid_sec_users','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Segurança / Usuários: Acesso ao cadastro de usuários da plataforma','Segurança'),(9,'app_grid_sec_users_groups','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Segurança / Associação de usuários a perfis: Acesso à configuração da associação de usuários a perfis de acesso','Segurança'),(9,'app_Login',NULL,NULL,NULL,NULL,NULL,NULL,'Login',NULL),(9,'app_menu',NULL,NULL,NULL,NULL,NULL,NULL,'Menu','Painel'),(9,'app_retrieve_pswd',NULL,NULL,NULL,NULL,NULL,NULL,'Esqueceu a senha','Painel'),(9,'app_search_sec_groups','',NULL,NULL,NULL,NULL,NULL,'[Item de menu] - Segurança / Associação de perfis a aplicações: Acesso à configuração da associação de perfis de acesso com as aplicações da plataforma','Segurança'),(9,'app_settings','',NULL,NULL,NULL,NULL,NULL,'Configurações de segurança','Segurança'),(9,'app_sync_apps','',NULL,NULL,NULL,NULL,NULL,'Sincronização de aplicações','Segurança'),(9,'Artefatos','',NULL,NULL,NULL,NULL,NULL,'[Item de menu] - Painel / Artefatos: Acesso à exibição dos principais indicadores sobre Artefatos e Documentos','Painel'),(9,'associar_metadados_finalidade',NULL,NULL,NULL,NULL,NULL,NULL,'Associar metadados na finalidade','Painel'),(9,'associar_metadados_finalidade_new',NULL,NULL,NULL,NULL,NULL,NULL,'Associar metadados a finalidades','Painel'),(9,'Atividades','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Painel / Atividades e Ações: Acesso à exibição dos principais indicadores sobre Atividades e Ações','Painel'),(9,'Ativos','',NULL,NULL,NULL,NULL,NULL,'[Item de menu] - Painel / Ativos de Informação: Acesso à exibição dos principais indicadores sobre Ativos de Informação','Painel'),(9,'Auto_cadastro_PAC_4000_notificacao',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(9,'blank_email',NULL,NULL,NULL,NULL,NULL,NULL,'Enviar mail','Painel'),(9,'blank_pipeline','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Atividades e Ações / Meu Quadro de Atividades: Acesso ao Kanban de atividades do usuário logado','Atividades e Ações'),(9,'blank_pipeline_Ajax',NULL,NULL,NULL,NULL,NULL,NULL,'Pipeline de atividades','Painel'),(9,'cad_sol_dpia_pcp_9000','Y',NULL,NULL,NULL,'Y','Y',NULL,'Fluxo de Informação'),(9,'Cadastro_DEN_1000_registro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(9,'Cadastro_DEN_1100_cat',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(9,'cadastro_PAC_1110_atv_sol',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(9,'cadastro_PAC_1200_sla_sol_portal',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(9,'Cadastro_PAC_1400_titulares',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(9,'Cadastro_PAC_1410_dados_tit',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(9,'Cadastro_PAC_2000_incidentes',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(9,'Cadastro_PAC_2100_sla_notificacao',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(9,'Cadastro_PAC_3100_env_consent',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(9,'Cadastro_PAC_4000_notificacao',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(9,'Cadastro_PAG_lote_1000',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(9,'cadastro_PAG_ocorr_lote_1100',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(9,'calendar_app',NULL,NULL,NULL,NULL,NULL,NULL,'Calendário','Painel'),(9,'calendar_public_LGPD_4000_atividades',NULL,NULL,NULL,NULL,NULL,NULL,'Calendário de atividades ( DPO )','Painel'),(9,'chart_public_LGPD_2000_processos_complex',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico processo por complexidade','Painel'),(9,'chart_public_LGPD_2000_processos_geral',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico processos','Painel'),(9,'chart_public_LGPD_2000_processos_resp',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico processos por responsável','Painel'),(9,'chart_public_LGPD_2000_status_processos',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico processo por status','Painel'),(9,'chart_public_LGPD_2000_tipo_processo',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico processos por tipo','Painel'),(9,'chart_public_LGPD_2010_confia_ativos',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico confibilidade dos ativos','Painel'),(9,'chart_public_LGPD_2010_disp_ativos',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico ativos por nível de disponibilidade','Painel'),(9,'chart_public_LGPD_2010_integridade_ativos',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico ativos por nível de integridade','Painel'),(9,'chart_public_LGPD_2010_resp_ativos',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico ativos por responsável','Painel'),(9,'chart_public_LGPD_2010_tipo_ativos',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico tipos de ativos','Painel'),(9,'chart_public_LGPD_2020_artefat_contrato',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico artefatos tipo contrato','Painel'),(9,'chart_public_LGPD_2020_contrato_artefatos',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico contratos x artefatos','Painel'),(9,'chart_public_LGPD_2020_tipo_artefatos',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico artefatos por tipo','Painel'),(9,'chart_public_LGPD_2030_classif_dados',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico classificação de metadados','Painel'),(9,'chart_public_LGPD_2030_dados_anonimizavel',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico metadados anonimizavel','Painel'),(9,'chart_public_LGPD_2030_tipif_dados',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico tipos de dados','Painel'),(9,'chart_public_LGPD_2070_fin_compart_dados',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico finalidades por compartilhamento','Painel'),(9,'chart_public_LGPD_2070_fin_dad_criancas',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico finalidades por dados de crianças','Painel'),(9,'chart_public_LGPD_2070_fin_faz_descarte',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico finalidades por descarte','Painel'),(9,'chart_public_LGPD_2070_fin_frequencia',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico finalidades por ferequencia','Painel'),(9,'chart_public_LGPD_2070_fin_hipoteses',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico finalidades por hipóteses de tratamento','Painel'),(9,'chart_public_LGPD_2070_fin_papel',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico papel da entidade','Painel'),(9,'chart_public_LGPD_2070_fin_processos',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico finalidades por processos','Painel'),(9,'chart_public_LGPD_2070_fin_rot_automatizada',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico finalidades por rotinas automatizadas','Painel'),(9,'chart_public_LGPD_2070_fin_utlz_operador',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico finalidades por utiliza operador','Painel'),(9,'chart_public_LGPD_2070_fin_volumetria',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico finliadades por volumetria','Painel'),(9,'chart_public_LGPD_3000_categoria_riscos',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico riscos por categoria','Painel'),(9,'chart_public_LGPD_3000_criticidade_riscos',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico riscos por criticidade','Painel'),(9,'chart_public_LGPD_3000_estrategia_riscos',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico riscos por estratégia','Painel'),(9,'chart_public_LGPD_3000_impacto_riscos',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico riscos por impacto','Painel'),(9,'chart_public_LGPD_3000_prob_riscos',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico riscos por probabilidade','Painel'),(9,'chart_public_LGPD_3000_resp_riscos',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico riscos por responsáveis','Painel'),(9,'chart_public_LGPD_3000_status_riscos',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico riscos por status','Painel'),(9,'chart_public_LGPD_4000_atividades_geral',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico atividades','Painel'),(9,'chart_public_LGPD_4000_disc_atividades',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico atividades por disciplina','Painel'),(9,'chart_public_LGPD_4000_etapa_atividades',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico atividades por etapas','Painel'),(9,'chart_public_LGPD_4000_resp_atividades',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico atividades por responsável','Painel'),(9,'chart_public_LGPD_4000_status_resp_atividade',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico atividades por responsável e status','Painel'),(9,'chart_public_LGPD_assoc_pdca_contr_6500',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico PDCA de contratos','Painel'),(9,'chart_public_LGPD_assoc_pdca_finalizados_treina_6500',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico PDCA de treinamentos','Painel'),(9,'chart_public_LGPD_assoc_pdca_medtec_6700',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico PDCA de medidas técnicas','Painel'),(9,'chart_public_LGPD_assoc_pdca_pol_6300',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico PDCA de políticas','Painel'),(9,'chart_public_LGPD_assoc_pdca_proc_6600',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico PDCA de processos','Painel'),(9,'chart_public_LGPD_assoc_pdca_realizar_treina_6500',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico PDCA realização de treinamentos','Painel'),(9,'chart_public_LGPD_assoc_pdca_risk_6400',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico PDCA de riscos','Painel'),(9,'cons_dad_nao_utlz_LGPD_2030_dados','',NULL,NULL,NULL,NULL,NULL,'[Item de menu] - Fluxo de Informação / Metadados Pessoais não utilizados: Acesso à consulta dos Metadados Pessoais cadastrados mas não utilizados em nenhuma associação','Fluxo de Informação'),(9,'cons_minhas_obr_CMP_1610_ol_agenda','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Aspectos Jurídicos / Minhas Obrigações Legais: Acesso ao cadastro das obrigações legais da entidade que estão sob a responsabilidade do usuário logado','Aspectos Jurídicos'),(9,'Consulta_DEN_1000_registro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(9,'Consulta_DEN_1100_cat',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(9,'consulta_gerencial_CMP_1610_ol_agenda','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Aspectos Jurídicos / Acompanhamento de Obrigações Legais: Acesso ao painel de acompanhamento do status das obrigações legais da entidade','Aspectos Jurídicos'),(9,'consulta_gerencial_LGPD_4000_atividades','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Atividades e Ações / Acompanhamento de Atividades e Ações: Acesso ao painel de acompanhamento do status das obrigações legais da entidade','Atividades e Ações'),(9,'Consulta_LGPD_3000_riscos_assistant',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(9,'Consulta_LGPD_4000_atividades_assistant',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(9,'Consulta_PAC_1000_user_portal',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(9,'Consulta_PAC_1100_sol_portal',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(9,'consulta_PAC_1200_sla_sol_portal',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(9,'Consulta_PAC_1400_titulares',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(9,'Consulta_PAC_1410_dados_tit',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(9,'Consulta_PAC_2000_incidentes',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(9,'Consulta_PAC_3100_env_consent',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(9,'Consulta_PAC_4000_notificacao',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(9,'Consulta_PAG_lote_1000',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(9,'Consulta_public_LGPD_3000_riscos',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(9,'control_calendar',NULL,NULL,NULL,NULL,NULL,NULL,'Meu calendário de atividades de adequação',NULL),(9,'control_login',NULL,NULL,NULL,NULL,NULL,NULL,'Login','Painel'),(9,'control_login_diligence',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(9,'esqueci_senha',NULL,NULL,NULL,NULL,NULL,NULL,'Esqueceu a senha','Painel'),(9,'extrato_pdca',NULL,NULL,NULL,NULL,NULL,NULL,'Extrato PDCA','Painel'),(9,'Finalidades','',NULL,NULL,NULL,NULL,NULL,'[Item de menu] - Painel / Finalidades de Tratamento de Dados Pessoais: Acesso à exibição dos principais indicadores sobre Finalidades de Tratamento de Dados Pessoais','Painel'),(9,'form_aval_7000','Y',NULL,NULL,NULL,'Y','Y','Formulários de due diligence: Acesso à criação de formulários (e suas questões) para auto avaliação de terceiros','Gestão de Terceiros'),(9,'form_CMP_1000_mecanismos','Y','Y','Y','Y',NULL,NULL,'Cadastro de mecanismos de auditoria ','Formulário'),(9,'form_CMP_1100_componentes','Y','Y','Y','Y',NULL,NULL,'Cadastro de componentes de auditoria','Formulário'),(9,'form_CMP_1200_questoes','Y','Y','Y','Y',NULL,NULL,'Cadastro de questões de auditoria','Formulário'),(9,'form_CMP_1300_formularios','Y','Y','Y','Y',NULL,NULL,'Cadatro de formulários de auditoria ','Formulário'),(9,'form_CMP_1300_formularios_edit','Y','Y','Y','Y',NULL,NULL,'Edição de formulários de auditoria','Formulário'),(9,'form_CMP_1400_formulas_mestre','Y','Y','Y','Y',NULL,NULL,'Parametrização de Setup de Auditoria','Formulário'),(9,'form_CMP_1400_formulas_view','Y','Y','Y','Y',NULL,NULL,'Visualizar setup de auditoria','Formulário'),(9,'form_CMP_1410_formulas_det_mec','Y','Y','Y','Y',NULL,NULL,'Parametrizar mecanismos de auditoria no setup','Formulário'),(9,'form_CMP_1420_formulas_det_niv_ad','Y','Y','Y','Y',NULL,NULL,'Parametrizar níveis de aderência do setup de auditoria ','Formulário'),(9,'form_CMP_1430_formulas_det_lim','Y','Y','Y','Y',NULL,NULL,'Parametrizar faixas do setup de auditoria','Formulário'),(9,'form_CMP_1500_acao','Y','Y','Y','Y',NULL,NULL,'Recomendações de auditorias','Formulário'),(9,'form_CMP_1600_OL','Y','Y','Y','Y',NULL,NULL,'Cadastro de Obrigações Legais ','Formulário'),(9,'form_CMP_2000_ciclos','Y','Y','Y','Y',NULL,NULL,'Cadastro de ciclos de auditoria','Formulário'),(9,'form_CMP_2500_conf_entrevistados','Y','Y','Y','Y',NULL,NULL,'Cadastro de entrevistados do ciclo de auditoria ','Formulário'),(9,'form_CMP_2500_conf_entrevistados_1','Y','Y','Y','Y',NULL,NULL,'Cadastro de entrevistados ','Formulário'),(9,'form_CMP_2500_conf_param_entrevistados','Y','Y','Y','Y',NULL,NULL,'Parametrizar relação de entrevistados de um ciclo de auditoria','Formulário'),(9,'form_CMP_3000_aplic_pesq','Y','Y','Y','Y',NULL,NULL,'Cadastro de aplicação de pesquisa de auditorias ','Formulário'),(9,'form_CMP_resultados_pesquisas','Y','Y','Y','Y',NULL,NULL,'Cadastro de resultado de pesquisas de auditoria','Formulário'),(9,'form_conf_quest_7100','Y','Y','Y','Y',NULL,NULL,'Configurar questionário de fornecedores','Formulário'),(9,'form_diligence',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(9,'form_DOM_tp_ol_1600','Y','Y','Y','Y',NULL,NULL,'Cadastro de tipos de obrigações ','Formulário'),(9,'form_kanban_atividades','Y','Y','Y','Y',NULL,NULL,'Kanban de  atividades','Formulário'),(9,'form_kanban_atividades_add_registro','Y','Y','Y','Y',NULL,NULL,'Cadastrar atividades pelo kanban','Formulário'),(9,'form_LGPD_0002_conf_smpt','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Configurações / Configuração de envio de e-mails: Acesso à configuração do endereço de de SMTP para envio de e-mails da plataforma','Formulário'),(9,'form_LGPD_2001_form_entr_prc','Y',NULL,NULL,NULL,'Y','Y',NULL,'Fluxo de Informação'),(9,'form_LGPD_2003_envio_entr_prc','Y',NULL,NULL,NULL,'Y','Y',NULL,'Fluxo de Informação'),(9,'form_LGPD_2087_ndas','Y',NULL,NULL,NULL,'Y','Y',NULL,'Fluxo de Informação'),(9,'form_LGPD_2097_assoc_med_atv',NULL,NULL,NULL,NULL,NULL,NULL,'Cadastro de Medidas Técnicas - > Cadastro da especificação da associação entre medida técnica e ativo','Painel'),(9,'form_LGPD_3500_checklist_risk_padrao','Y','','','','Y','Y','[Item de menu] - Riscos / Checklist padrão de identificação de riscos e atividades','Riscos'),(9,'form_LGPD_3600_chklst_risk_area_mestre','Y','','','','Y','Y','Formulário de checklist por área de identificação de riscos e atividades','Riscos'),(9,'form_LGPD_4000_atividades','Y','Y','Y','Y',NULL,NULL,'Cadastro de atividades de adequação','Formulário'),(9,'form_LGPD_4000_atividades_calendar',NULL,NULL,NULL,NULL,NULL,NULL,'Cadastro de atividades de adequação','Formulário'),(9,'form_minhas_obr_CMP_1610_ol_agenda',NULL,NULL,NULL,NULL,NULL,NULL,'Edição das minhas obrigações legais ','Painel'),(9,'form_new_pln_acao','Y','','','',NULL,NULL,'Cadastrar plano de ação','Formulário'),(9,'form_PAC_1100_sol_portal',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(9,'form_pcp_9100_LIA','Y',NULL,NULL,NULL,'Y','Y',NULL,'Fluxo de Informação'),(9,'form_public_LGPD_0100_diagnostico','','','','',NULL,NULL,'Parametrizar etapa de diagnóstico','Formulário'),(9,'form_public_LGPD_0200_implement','','','','',NULL,NULL,'Parametrizar etapa de implementação','Formulário'),(9,'form_public_LGPD_0300_operacao','','','','',NULL,NULL,'Parametrizar etapa de operação','Formulário'),(9,'form_public_LGPD_0400_etapas','','','','',NULL,NULL,'Parametrizar etapas','Formulário'),(9,'form_public_LGPD_1000_controlador','Y','','','',NULL,NULL,'Cadastro de controlador','Formulário'),(9,'form_public_LGPD_1001_diretoria','Y','Y','Y','Y',NULL,NULL,'Cadastro de diretoria','Formulário'),(9,'form_public_LGPD_1002_area','Y','Y','Y','Y',NULL,NULL,'Cadastro de área','Formulário'),(9,'form_public_LGPD_1003_departamento','Y','Y','Y','Y',NULL,NULL,'Cadastro de departamentos','Formulário'),(9,'form_public_LGPD_1004_cargos','Y','Y','Y','Y',NULL,NULL,'Cadastro de cargos','Formulário'),(9,'form_public_LGPD_1050_organograma','Y','Y','Y','Y',NULL,NULL,'Cadastro de organograma','Formulário'),(9,'form_public_LGPD_1051_comite','Y','Y','Y','Y',NULL,NULL,'Cadastro de comitê','Formulário'),(9,'form_public_LGPD_1053_eventos_comite','Y','Y','Y','Y',NULL,NULL,'Agenda de eventos do comitê','Formulário'),(9,'form_public_LGPD_1100_equipe','Y','Y','Y','Y',NULL,NULL,'Cadastro de equipe','Formulário'),(9,'form_public_LGPD_1100_equipe_1','Y','Y','Y','Y',NULL,NULL,'Cadastro de equipe','Formulário'),(9,'form_public_LGPD_2000_processos','Y','','','Y',NULL,NULL,'Cadastro de processos','Formulário'),(9,'form_public_LGPD_2010_ativos','','','','',NULL,NULL,'Cadastro de ativos','Formulário'),(9,'form_public_LGPD_2020_artefatos','','','','',NULL,NULL,'Cadastro de artefatos','Formulário'),(9,'form_public_LGPD_2030_dados','','','','',NULL,NULL,'Cadastro de metadados','Formulário'),(9,'form_public_LGPD_2060_config_assoc',NULL,NULL,NULL,NULL,NULL,NULL,'Associação artefato x metadados','Formulário'),(9,'form_public_LGPD_2065_fund_legal','Y','Y','Y','Y',NULL,NULL,'Cadastro de fundamentos legais','Formulário'),(9,'form_public_LGPD_2066_ambiente_reg','Y','Y','Y','Y',NULL,NULL,'Cadastro de ambientes regulatórios','Formulário'),(9,'form_public_LGPD_2070_finalidades','','','','',NULL,NULL,'Parametrizar finalidades','Formulário'),(9,'form_public_LGPD_2070_registrar_finalidades','','','','',NULL,NULL,'Registrar finalidades','Formulário'),(9,'form_public_LGPD_2075_param_assoc_funcional_fin',NULL,NULL,NULL,NULL,NULL,NULL,'Associação funcional da finalidade','Formulário'),(9,'form_public_LGPD_2080_politicas','Y','','','',NULL,NULL,'Cadastro de políticas','Formulário'),(9,'form_public_LGPD_2085_contratos','Y','Y','Y','Y',NULL,NULL,'Cadastro de contratos','Formulário'),(9,'form_public_LGPD_2090_terceiros','Y','Y','Y','Y',NULL,NULL,'Cadastro de terceiros','Formulário'),(9,'form_public_LGPD_2093_ocorr_terc','Y','Y','Y','Y',NULL,NULL,'Cadastro de ocorrência de terceiros','Formulário'),(9,'form_public_LGPD_2095_med_tec','','','','',NULL,NULL,'Cadastro de medidas técnicas','Formulário'),(9,'form_public_LGPD_2097_config_assoc_med_atv',NULL,NULL,NULL,NULL,NULL,NULL,'Associar medidas técnicas aos ativos','Formulário'),(9,'form_public_LGPD_2100_prz_aprv_proc','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Configurações / SLA de aprovação de Processos de Negócio: Acesso à configuração do prazo limite para aprovação de Processos de Negócio cadastrados','Formulário'),(9,'form_public_LGPD_3000_riscos','Y','Y','Y','Y',NULL,NULL,'Cadastro de riscos','Formulário'),(9,'form_public_LGPD_4000_atividades','Y','Y','Y','Y',NULL,NULL,'Cadastro de atividades','Formulário'),(9,'form_public_LGPD_5000_cod_etica','Y','Y','Y','Y',NULL,NULL,'Cadastro de código de ética','Formulário'),(9,'form_public_LGPD_5100_cod_conduta',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(9,'form_public_LGPD_6000_PDCA','Y','Y','Y','Y',NULL,NULL,'PDCA','Formulário'),(9,'form_public_LGPD_6100_catalog_treinamentos','Y','Y','Y','Y',NULL,NULL,'Cadastro de catalogo de treinamentos','Formulário'),(9,'form_public_LGPD_6200_agenda_treina','Y','Y','Y','Y',NULL,NULL,'Agenda de treinamentos','Formulário'),(9,'form_public_LGPD_7300_envio_aval_forne','Y','Y','Y','Y',NULL,NULL,'Cadastro de questionários (Due Diligence)','Formulário'),(9,'form_public_LGPD_assoc_contr_6500',NULL,NULL,NULL,NULL,NULL,NULL,'Associação de contratos','Formulário'),(9,'form_public_LGPD_assoc_medtec_6700',NULL,NULL,NULL,NULL,NULL,NULL,'Associação de medidas técnicas','Formulário'),(9,'form_public_LGPD_assoc_pdca_risk_6400',NULL,NULL,NULL,NULL,NULL,NULL,'Associação de riscos ao PDCA','Formulário'),(9,'form_public_LGPD_assoc_pol_6300',NULL,NULL,NULL,NULL,NULL,NULL,'Associação de políticas','Formulário'),(9,'form_public_LGPD_assoc_proc_6600',NULL,NULL,NULL,NULL,NULL,NULL,'Associação de processos','Formulário'),(9,'form_public_LGPD_assoc_treina_6500',NULL,NULL,NULL,NULL,NULL,NULL,'Associação de treinamentos','Formulário'),(9,'form_public_LGPD_config_det_opt_7200','Y','Y','Y','Y',NULL,NULL,'Parametrizar opções do questionário de fornecedores','Formulário'),(9,'form_public_PAC_1000_user_portal',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(9,'Governance_menu',NULL,NULL,NULL,NULL,NULL,NULL,'Menu',NULL),(9,'grid_CMP_0100_faixas',NULL,NULL,NULL,NULL,NULL,NULL,'Consultar faixas de setup de auditoria','Painel'),(9,'grid_CMP_1000_mecanismos','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Pilares do Compliance / Mecanismos de Auditoria: Acesso ao cadastro de Mecanismos de Auditoria para projetos de Compliance','Pilares de Compliance'),(9,'grid_CMP_1100_componentes','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Pilares do Compliance / Componentes de Auditoria: Acesso ao cadastro de Componentes de Auditoria, que compõem os Mecanismos cadastrados','Pilares de Compliance'),(9,'grid_CMP_1100_entrevistados_desassociados',NULL,NULL,NULL,NULL,NULL,NULL,'Consultas candidatos a entrevistas de ciclo de auditoria ','Painel'),(9,'grid_CMP_1200_questoes','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Pilares do Compliance / Questões de Auditoria: Acesso ao cadastro de perguntas que são utilizadas para a realização de auditorias de Compliance','Pilares de Compliance'),(9,'grid_CMP_1300_formularios','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Pilares do Compliance / Formulários de Auditoria: Acesso ao cadastro e configuração de Formulários compostos por perguntas para a realização de auditorias de Compliance','Pilares de Compliance'),(9,'grid_CMP_1310_formulario_det',NULL,NULL,NULL,NULL,NULL,NULL,'Consulta detalhes do formulário de auditoria ','Painel'),(9,'grid_CMP_1400_formulas_mestre','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Pilares do Compliance / Parâmetros de Ciclos de Auditoria: Acesso à configuração de parâmetros quantitativos utilizados nos Ciclos de Auditoria de Compliance','Pilares de Compliance'),(9,'grid_CMP_1410_formulas_det_mec',NULL,NULL,NULL,NULL,NULL,NULL,'Sub Consulta mecanismos do setup de auditoria','Painel'),(9,'grid_CMP_1500_acao','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Pilares do Compliance / Ações de Auditoria: Acesso ao cadastro de ações pré-determinadas para serem sugeridas a partir do levantamento de determinada Questão cadastrada','Pilares de Compliance'),(9,'grid_CMP_1550_ger_acao','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Auditoria de Compliance / Recomendações de Auditoria: Acesso à geração automática de recomendações pós Ciclo de Auditoria de Compliance','Auditoria de Compliance'),(9,'grid_CMP_1600_OL','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Aspectos Jurídicos / Obrigações Legais: Acesso ao cadastro das obrigações legais que a entidade deve atender em um determinado exercício','Aspectos Jurídicos'),(9,'grid_CMP_2000_ciclos','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Auditoria de Compliance / Ciclos de Auditoria: Acesso à gestão de Ciclos de Auditoria de Compliance','Auditoria de Compliance'),(9,'grid_CMP_2500_conf_entrevistados','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Auditoria de Compliance / Entrevistados: Acesso à seleção de entrevistados que estarão associados a um Ciclo de Auditoria de Compliance','Auditoria de Compliance'),(9,'grid_CMP_2510_entrevistados_associados',NULL,NULL,NULL,NULL,NULL,NULL,'Relação de entrevistados de um ciclo de auditoria','Painel'),(9,'grid_CMP_3000_aplic_pesq','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Auditoria de Compliance / Pesquisas de Auditoria: Acesso à aplicação de Pesquisas de Auditoria de Compliance','Auditoria de Compliance'),(9,'grid_CMP_acompanhar_pesquisas',NULL,NULL,NULL,NULL,NULL,NULL,'Consulta acompanhamento do andamento de pesquisas de auditorias','Painel'),(9,'grid_CMP_resultado_pesquisa','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Auditoria de Compliance / Resultados de Auditoria: Acesso à gestão do resultado de Pesquisas de Auditoria de Compliance','Auditoria de Compliance'),(9,'grid_CMP_resultado_pesquisa_questoes',NULL,NULL,NULL,NULL,NULL,NULL,'Consulta resultado da pesquisa de auditoria ','Painel'),(9,'grid_CMP_resultado_pesquisa_status_mecanismo',NULL,NULL,NULL,NULL,NULL,NULL,'Consulta resultado da pesquisa por mecanismos de auditoria ','Painel'),(9,'grid_conf_quest_7100',NULL,NULL,NULL,NULL,NULL,NULL,'Cofiguração de questionário para fornecedores','Painel'),(9,'grid_DOM_tp_ol_1600','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Aspectos Jurídicos / Tipos de Obrigações Legais: Acesso ao cadastro de tipos de obrigações legais','Aspectos Jurídicos'),(9,'grid_kanban_atividades',NULL,NULL,NULL,NULL,NULL,NULL,'Kanban de  atividades','Painel'),(9,'grid_kanban_atividades_add_registro',NULL,NULL,NULL,NULL,NULL,NULL,'Kanban de  atividades','Painel'),(9,'grid_LGPD_2001_form_entr_prc','Y',NULL,NULL,NULL,'Y','Y',NULL,'Fluxo de Informação'),(9,'grid_LGPD_2003_envio_entr_prc','Y',NULL,NULL,NULL,'Y','Y',NULL,'Fluxo de Informação'),(9,'grid_LGPD_2040_assoc_prc_atv','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Fluxo de Informação / Associações do Fluxo de Informação: Acesso à consulta das associações entre Processos de Negócio x Ativos de Informação x Artefatos x Metadados Pessoais','Fluxo de Informação'),(9,'grid_LGPD_2075_assoc_funcional_dados_fin',NULL,NULL,NULL,NULL,NULL,NULL,'Consulta associação de metadados','Painel'),(9,'grid_LGPD_2087_ndas','Y',NULL,NULL,NULL,'Y','Y',NULL,'Políticas e Regulamentos'),(9,'grid_LGPD_2097_assoc_med_atv','',NULL,NULL,NULL,NULL,NULL,'[Item de menu] - Medidas Técnicas de Segurança / Associações com Ativos de Informação: Acesso à configuração da associação entre Medidas Técnicas de Segurança e Ativos de Informação utilizados pela entidade','Medidas Técnicas de Segurança'),(9,'grid_LGPD_3100_assoc_risc_atv','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Riscos / Associações de Riscos: Acesso à associações entre Riscos e outras informações cadastradas','Riscos'),(9,'grid_LGPD_3600_chklst_risk_area_mestre','Y','','','','Y','Y','[Item de menu] - Riscos / Checklist por área de identificação de riscos e atividades','Riscos'),(9,'grid_LGPD_6300_aluno_treina',NULL,NULL,NULL,NULL,NULL,NULL,'Consulta de lista de treinamentos realizados por colaborador','Painel'),(9,'grid_LGPD_7400_resp_aval_forne',NULL,NULL,NULL,NULL,NULL,NULL,'Consulta respostas de questionários  (Due Diligence)','Painel'),(9,'grid_new_pln_acao','',NULL,NULL,NULL,NULL,NULL,'[Item de menu] - Atividades e Ações / Plano de Ação LGPD: Acesso ao cadastro do documento \"Plano de Ação\" de adequação à LGPD','Atividades e Ações'),(9,'grid_public_LGPD_0100_diagnostico','',NULL,NULL,NULL,NULL,NULL,'[Item de menu] - Configurações / Projeto de Diagnóstico da LGPD: Acesso à configuração das informações sobre o projeto de Diagnóstico da LGPD','Configurações'),(9,'grid_public_LGPD_0200_implement','',NULL,NULL,NULL,NULL,NULL,'[Item de menu] - Configurações / Projeto de Adequação da LGPD: Acesso à configuração das informações sobre o projeto de Adequação da LGPD','Configurações'),(9,'grid_public_LGPD_0300_operacao','',NULL,NULL,NULL,NULL,NULL,'[Item de menu] - Configurações / Projeto de Operação da LGPD: Acesso à configuração das informações sobre a fase de Operação da LGPD','Configurações'),(9,'grid_public_LGPD_0400_etapas','',NULL,NULL,NULL,NULL,NULL,'[Item de menu] - Configurações / Etapas do Diagnóstico da LGPD: Acesso à configuração das etapas do projeto de Diagnóstico de um projeto de adequação à LGPD','Configurações'),(9,'grid_public_LGPD_1000_controlador','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Configurações / Entidade: Acesso à configuração dos dados da entidade','Configurações'),(9,'grid_public_LGPD_1001_diretoria','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Estrutura Organizacional / Diretoria: Acesso ao cadastro de Diretorias, que é o nível mais alto da hierarquia organizacional da entidade','Estrutura Organizacional'),(9,'grid_public_LGPD_1002_area','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Estrutura Organizacional / Área: Acesso ao cadastro de Áreas, que dividem uma determinada Diretoria na estrutura hierárquica da entidade','Estrutura Organizacional'),(9,'grid_public_LGPD_1003_departamento','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Estrutura Organizacional / Departamentos: Acesso ao cadastro de Departamentos, que dividem uma determinada Área na estrutura hierárquica da entidade','Estrutura Organizacional'),(9,'grid_public_LGPD_1004_cargos','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Estrutura Organizacional / Cargos: Acesso ao cadastro de Cargos a serem ocupados por pessoas da equipe que ocupem espaço na estrutura hierárquica da entidade','Estrutura Organizacional'),(9,'grid_public_LGPD_1050_organograma','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Estrutura Organizacional / Lotação: Acesso ao cadastro de unidades de trabalho, onde é possível alocar as equipes da entidade','Estrutura Organizacional'),(9,'grid_public_LGPD_1051_comite','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Estrutura Organizacional / Comitês: Acesso ao cadastro de comitês da entidade, que congregam uma ou mais pessoas previamente cadastradas','Estrutura Organizacional'),(9,'grid_public_LGPD_1053_eventos_comite','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Atividades e Ações / Eventos de Comitê: Acesso ao cadastro de eventos associados aos Comitês da entidade','Atividades e Ações'),(9,'grid_public_LGPD_1053_sub_eventos_comite',NULL,NULL,NULL,NULL,NULL,NULL,'Sub Consulta de Eventos','Painel'),(9,'grid_public_LGPD_1100_equipe','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Estrutura Organizacional / Equipe: Acesso ao cadastro de pessoas que podem ocupar cargos na estrutura hierárquica da entidade. Essas pessoas serão associadas a diversas outras entidades tratadas na plataforma','Estrutura Organizacional'),(9,'grid_public_LGPD_2000_proc_aprv_prz_expirado','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Atividades e Ações / Processos de Negócio Pendentes: Acesso à gestão de Processos de Negócio com SLA de aprovação expirado','Atividades e Ações'),(9,'grid_public_LGPD_2000_processos','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Fluxo de Informação / Processos de Negócio: Acesso ao cadastro de Processos de Negócio que definem as rotinas operacionais da entidade','Fluxo de Informação'),(9,'grid_public_LGPD_2000_sub_proc_pessoa',NULL,NULL,NULL,NULL,NULL,NULL,'Consulta processo por responsável','Painel'),(9,'grid_public_LGPD_2000_sub_processos_atv',NULL,NULL,NULL,NULL,NULL,NULL,'Consulta processos por ativos','Painel'),(9,'grid_public_LGPD_2010_ativos','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Fluxo de Informação / Ativos de Informação: Acesso ao cadastro de Ativos de Informação utilizados pela entidade na execução de seus Processos de Negócio','Fluxo de Informação'),(9,'grid_public_LGPD_2010_ativos_1',NULL,NULL,NULL,NULL,NULL,NULL,'Consulta Ativos','Painel'),(9,'grid_public_LGPD_2010_ativos_n_utlz_fin',NULL,NULL,NULL,NULL,NULL,NULL,'Processos disponivel para associação com finalidades','Painel'),(9,'grid_public_LGPD_2010_ativos_utlz_fin',NULL,NULL,NULL,NULL,NULL,NULL,'Processos associados a finalidade','Painel'),(9,'grid_public_LGPD_2010_sub_ativos',NULL,NULL,NULL,NULL,NULL,NULL,'Sub Consulta de Ativos','Painel'),(9,'grid_public_LGPD_2020_artefatos','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Fluxo de Informação / Artefatos: Acesso ao cadastro de Artefatos e Documentos tratados nos Ativos de Informação utilizados pela entidade','Fluxo de Informação'),(9,'grid_public_LGPD_2020_artefatos_n_utlz_fin',NULL,NULL,NULL,NULL,NULL,NULL,'Artefatos disponiveis para associação com finalidades','Painel'),(9,'grid_public_LGPD_2020_artefatos_utlz_fin',NULL,NULL,NULL,NULL,NULL,NULL,'Artefatos associados a finalidades','Painel'),(9,'grid_public_LGPD_2030_assoc_art_metadados',NULL,NULL,NULL,NULL,NULL,NULL,'Associação de Artefatos e metadados','Painel'),(9,'grid_public_LGPD_2030_dados','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Fluxo de Informação / Metadados Pessoais: Acesso ao cadastro de Metadados Pessoais presentes nos diferentes Artefatos utilizados pela entidade','Fluxo de Informação'),(9,'grid_public_LGPD_2065_fund_legal','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Aspectos Jurídicos / Fundamentos Legais: Acesso ao cadastro de Fundamentos Legais utilizados pela entidade','Aspectos Jurídicos'),(9,'grid_public_LGPD_2066_ambiente_reg','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Aspectos Jurídicos / Ambientes regulatórios: Acesso ao cadastro de Ambientes Regulatórios a serem associados a Fundamentos Legais utilizados pela entidade','Aspectos Jurídicos'),(9,'grid_public_LGPD_2070_finalidades','',NULL,NULL,NULL,NULL,NULL,'[Item de menu] - Tratamento de Dados Pessoais / Parametrizar Finalidades de Tratamentos: Acesso à configuração dos aspectos e detalhes das Finalidades de Tratamento de Dados Pessoais previamente cadastradas','Tratamento de Dados Pessoais'),(9,'grid_public_LGPD_2070_registrar_finalidades','',NULL,NULL,NULL,NULL,NULL,'[Item de menu] - Tratamento de Dados Pessoais / Registrar Finalidade de Tratamento: Acesso ao cadastro de Finalidades de Tratamento de Dados Pessoais executadas pela entidade','Tratamento de Dados Pessoais'),(9,'grid_public_LGPD_2070_sub_contratos_finalidades',NULL,NULL,NULL,NULL,NULL,NULL,'Sub consulta de contratos dentro da finalidade','Painel'),(9,'grid_public_LGPD_2070_sub_finalidades',NULL,NULL,NULL,NULL,NULL,NULL,'Sub consulta de finalidades','Painel'),(9,'grid_public_LGPD_2073_assoc_ativos_fin',NULL,NULL,NULL,NULL,NULL,NULL,'Associação de ativos na finalidade','Painel'),(9,'grid_public_LGPD_2075_assoc_metadados_fin',NULL,NULL,NULL,NULL,NULL,NULL,'Associação de metadados na finalidade','Painel'),(9,'grid_public_LGPD_2080_politicas','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Políticas e Regulamentos / Políticas: Acesso ao cadastro de políticas associadas à Governança de Privacidade da entidade','Políticas e Regulamentos'),(9,'grid_public_LGPD_2085_contratos','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Políticas e Regulamentos / Contratos: Acesso ao cadastro de contratos e modelos de contratos utilizados pela entidade','Políticas e Regulamentos'),(9,'grid_public_LGPD_2090_terceiros','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Gestão de terceiros / Terceiros: Acesso ao cadastro de entidades terceiras (PJ ou PF) associadas à entidade','Gestão de Terceiros'),(9,'grid_public_LGPD_2093_ocorr_terc','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Gestão de terceiros / Ocorrências: Acesso ao cadastro de ocorrências relacionadas à Terceiros associados à entidade','Gestão de Terceiros'),(9,'grid_public_LGPD_2095_med_tec','',NULL,NULL,NULL,NULL,NULL,'[Item de menu] - Medidas Técnicas de Segurança / Medidas Técnicas de Segurança: Acesso ao cadastro de Medidas Técnicas de Segurança da Informação que podem ser associadas a Ativos cadastrados','Medidas Técnicas de Segurança'),(9,'grid_public_LGPD_2095_sub_med_tec',NULL,NULL,NULL,NULL,NULL,NULL,'Sub Consulta de medidas técnicas','Painel'),(9,'grid_public_LGPD_3000_riscos','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Riscos / Riscos: Acesso ao cadastro de Riscos de Privacidade e Compliance','Riscos'),(9,'grid_public_LGPD_3000_sub_consulta_riscos',NULL,NULL,NULL,NULL,NULL,NULL,'Sub consulta de riscos','Painel'),(9,'grid_public_LGPD_3300_assoc_risc_prc',NULL,NULL,NULL,NULL,NULL,NULL,'Associar risco a processos','Painel'),(9,'grid_public_LGPD_4000_atividades','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Atividades e Ações / Atividades e Ações: Acesso ao cadastro de atividades e ações de governança e compliance','Atividades e Ações'),(9,'grid_public_LGPD_5000_cod_etica','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Políticas e Regulamentos / Códigos e Regulamentos Internos: Acesso ao cadastro de documentos que definem as regras internas de Compliance da entidade','Políticas e Regulamentos'),(9,'grid_public_LGPD_5100_cod_conduta',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(9,'grid_public_LGPD_6000_PDCA','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Atividades e Ações / Gestão de ciclo de PDCA de Compliance: Acesso ao planejamento e gestão de ciclos de PDCA de Compliance','Atividades e Ações'),(9,'grid_public_LGPD_6000_SUB_PDCA',NULL,NULL,NULL,NULL,NULL,NULL,'Sub consulta PDCA','Painel'),(9,'grid_public_LGPD_6100_catalog_treinamentos','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Atividades e Ações / Catálogo de treinamentos: Acesso ao cadastro dos tipos de treinamentos que a entidade pode executar para suas equipes','Atividades e Ações'),(9,'grid_public_LGPD_6200_agenda_treina','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Atividades e Ações / Agenda de Treinamentos: Acesso à gestão de agenda de treinamentos e capacitações internas da entidade','Atividades e Ações'),(9,'grid_public_LGPD_7300_envio_aval_forne',NULL,NULL,NULL,NULL,NULL,NULL,'Consulta de questionários (Due Diligence)','Painel'),(9,'grid_public_LGPD_7300_envio_aval_forne_gerencial','Y',NULL,NULL,NULL,'Y','Y',NULL,'Gestão de Terceiros'),(9,'grid_public_LGPD_cons_rev_contr_6500',NULL,NULL,NULL,NULL,NULL,NULL,'Consulta revisões de contrato','Painel'),(9,'grid_public_LGPD_cons_rev_medtec_6700',NULL,NULL,NULL,NULL,NULL,NULL,'Consulta revisões de medidas técnicas','Painel'),(9,'grid_public_LGPD_cons_rev_pol_6300',NULL,NULL,NULL,NULL,NULL,NULL,'Consulta revisão de políticas','Painel'),(9,'grid_public_LGPD_cons_rev_proc_6600',NULL,NULL,NULL,NULL,NULL,NULL,'Consulta revisão de processos','Painel'),(9,'grid_public_LGPD_cons_rev_risk_6400',NULL,NULL,NULL,NULL,NULL,NULL,'Consulta revisão de riscos','Painel'),(9,'grid_public_PAC_9000_DPIA',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(9,'grid_public_PAC_9100_LIA',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(9,'grid_public_PCP_9000_DPIA',NULL,NULL,NULL,NULL,NULL,NULL,'Consulta DPIA',NULL),(9,'grid_public_pcp_9100_LIA',NULL,NULL,NULL,NULL,NULL,NULL,'Consulta LIA ',NULL),(9,'grid_public_subconsulta_sec_users',NULL,NULL,NULL,NULL,NULL,NULL,'Sub consulta de usuarios','Painel'),(9,'grid_sc_log','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Segurança / Histórico de acessos: Acesso à consulta à histórico de acessos de usuários à plataforma','Segurança'),(9,'help_cadastro_titulares',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(9,'help_ciclo_de_vida',NULL,NULL,NULL,NULL,NULL,NULL,'Help Ciclo de vida','Painel'),(9,'help_finalidades_fundamentos',NULL,NULL,NULL,NULL,NULL,NULL,'Help Finalidades','Painel'),(9,'help_geracao_atividades',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(9,'help_geracao_riscos',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(9,'help_gestao_consentimentos',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(9,'help_gestao_incidentes',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(9,'help_gestao_notificacao',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(9,'help_integracao_portais',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(9,'help_lotes_validacao',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(9,'help_medidas_administrativas',NULL,NULL,NULL,NULL,NULL,NULL,'Help medidas administrativas','Painel'),(9,'help_medidas_tecnicas',NULL,NULL,NULL,NULL,NULL,NULL,'Help para medidas técnicas','Painel'),(9,'help_plano_acao_atividades',NULL,NULL,NULL,NULL,NULL,NULL,'Help Atividades','Painel'),(9,'help_relatorios',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(9,'help_riscos_e_impactos',NULL,NULL,NULL,NULL,NULL,NULL,'Help Riscos','Painel'),(9,'homepage',NULL,NULL,NULL,NULL,NULL,NULL,'Home Page (Responsábilidades e Atividades)','Painel'),(9,'homepage_help',NULL,NULL,NULL,NULL,NULL,NULL,'Help','Painel'),(9,'mapa_calor_risco',NULL,NULL,NULL,NULL,NULL,NULL,'Mapa de risco','Painel'),(9,'Mapa_Calor_Riscos',NULL,NULL,NULL,NULL,NULL,NULL,'Mapa de calor de riscos ','Painel'),(9,'menu',NULL,NULL,NULL,NULL,NULL,NULL,'Menu PCP','Painel'),(9,'menu_dinamico',NULL,NULL,NULL,NULL,NULL,NULL,'Menu','Painel'),(9,'Menu_Pac',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(9,'Metadados','',NULL,NULL,NULL,NULL,NULL,'[Item de menu] - Painel / Metadados Pessoais: Acesso à exibição dos principais indicadores sobre Metadados Pessoais','Painel'),(9,'novo_menu',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(9,'pac_app_change_pswd','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - SeguranÃ§a / AlteraÃ§Ã£o de senha: Acesso Ã  gestÃ£o de senhas de usuÃ¡rios da plataforma','SeguranÃ§a'),(9,'pac_app_form_sec_groups_apps','',NULL,NULL,NULL,NULL,NULL,'[Item de menu] - SeguranÃ§a / AssociaÃ§Ã£o de perfis a aplicaÃ§Ãµes: Acesso Ã  configuraÃ§Ã£o da associaÃ§Ã£o de perfis de acesso com as aplicaÃ§Ãµes da plataforma','SeguranÃ§a'),(9,'pac_app_grid_sec_apps','',NULL,NULL,NULL,NULL,NULL,'[Item de menu] - SeguranÃ§a / AplicaÃ§Ãµes: Acesso ao cadastro de aplicaÃ§Ãµes da plataforma','SeguranÃ§a'),(9,'pac_app_grid_sec_groups','',NULL,NULL,NULL,NULL,NULL,'[Item de menu] - SeguranÃ§a / Perfis: Acesso ao cadastro de perfis de acesso dos usuÃ¡rios da plataforma','SeguranÃ§a'),(9,'pac_app_grid_sec_users','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - SeguranÃ§a / UsuÃ¡rios: Acesso ao cadastro de usuÃ¡rios da plataforma','SeguranÃ§a'),(9,'pac_app_grid_sec_users_groups','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - SeguranÃ§a / AssociaÃ§Ã£o de usuÃ¡rios a perfis: Acesso Ã  configuraÃ§Ã£o da associaÃ§Ã£o de usuÃ¡rios a perfis de acesso','SeguranÃ§a'),(9,'pac_app_search_sec_groups','',NULL,NULL,NULL,NULL,NULL,'[Item de menu] - SeguranÃ§a / AssociaÃ§Ã£o de perfis a aplicaÃ§Ãµes: Acesso Ã  configuraÃ§Ã£o da associaÃ§Ã£o de perfis de acesso com as aplicaÃ§Ãµes da plataforma','SeguranÃ§a'),(9,'pac_menu',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(9,'PAG_menu',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(9,'param_aval_mestre_7000','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Gestão de terceiros / Formulários de due diligence: Acesso à criação de formulários (e suas questões) para auto avaliação de terceiros','Gestão de Terceiros'),(9,'PDCA','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Painel / Ciclos de PDCA: Acesso à exibição dos principais indicadores sobre Ciclos de PDCA de Compliance','Painel'),(9,'pdfreport_LGPD_7300_envio_aval_forne',NULL,NULL,NULL,NULL,NULL,NULL,'geração de PDF - questionário (Due Diligence)','Painel'),(9,'popup_confirm_action',NULL,NULL,NULL,NULL,NULL,NULL,'Pop-up ( não se aplica ao módulo de segirança)','Painel'),(9,'popup_confirm_action_status',NULL,NULL,NULL,NULL,NULL,NULL,'Pop_Up ( Não se plaica ao módulo de segurança ) ','Painel'),(9,'Processos','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Painel / Processos de Negócio: Acesso à exibição dos principais indicadores sobre Processos de Negócio','Painel'),(9,'relatorio_ciclos_complience',NULL,NULL,NULL,NULL,NULL,NULL,'Extrato de cilco de auditoria ','Painel'),(9,'relatorio_dpia',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(9,'relatorio_dpia_1',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(9,'relatorio_finalidades',NULL,NULL,NULL,NULL,NULL,NULL,'Relatório de finalidades','Painel'),(9,'relatorio_lia',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(9,'relatorio_notificacao',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(9,'relatorio_resp_aval',NULL,NULL,NULL,NULL,NULL,NULL,'Relatório Avaliações','Painel'),(9,'resumo_finalidade',NULL,NULL,NULL,NULL,NULL,NULL,'Resumo de finalidade','Painel'),(9,'Riscos','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Painel / Riscos: Acesso à exibição dos principais indicadores sobre Gestão de Riscos de Privacidade e Compliance','Painel'),(9,'risk_heat_map','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Riscos / Mapa de Calor: Acesso à exibição do Mapa de Calor dos Riscos cadastrados','Riscos'),(9,'search_public_LGPD_4000_atividades',NULL,NULL,NULL,NULL,NULL,NULL,'Filtro de atividades','Painel'),(9,'sec_change_pswd',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(9,'sec_form_add_users',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(9,'sec_form_edit_users',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(9,'sec_form_sec_apps',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(9,'sec_form_sec_groups',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(9,'sec_form_sec_groups_apps',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(9,'sec_grid_sec_apps',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(9,'sec_grid_sec_groups',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(9,'sec_grid_sec_users',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(9,'sec_grid_sec_users_groups',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(9,'sec_Login',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(9,'sec_menu',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(9,'sec_retrieve_pswd',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(9,'sec_search_sec_groups',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(9,'sec_settings',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(9,'sec_sync_apps',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(9,'sub_consulta_3000_riscos_incidente',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(9,'sub_consulta_3100_assoc_risc_atv',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(9,'sub_consulta_3300_assoc_risc_prc',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(9,'sub_consulta_3400_assoc_risc_fin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(9,'sub_consulta_CMP_1610_ol_agenda',NULL,NULL,NULL,NULL,NULL,NULL,'Sub consulta de agenda de obrigações legais por obrigação','Painel'),(9,'sub_consulta_CMP_2510_det_conf_entrevistados',NULL,NULL,NULL,NULL,NULL,NULL,'Entrevitados em presquisa de auditoria --> Sub Consulta de configuração de entrevidados de pesquisa de auditoria ','Painel'),(9,'sub_consulta_CMP_3000_aplic',NULL,NULL,NULL,NULL,NULL,NULL,'Sub consulta status da aplicação de pesquisa de auditoria','Painel'),(9,'sub_consulta_CMP_4000_respostas_mestre',NULL,NULL,NULL,NULL,NULL,NULL,'Sub consulta status de respostas dos formulários de auditoria dentro de um ciclo ','Painel'),(9,'sub_consulta_configurar_metadados',NULL,NULL,NULL,NULL,NULL,NULL,'Sub consulta configuração de metadados','Painel'),(9,'sub_consulta_LGPD_2097_assoc_med_atv',NULL,NULL,NULL,NULL,NULL,NULL,'Sub consulta de associação entre medidas técnicas e ativos','Painel'),(9,'sub_consulta_LGPD_6200_agenda_treina',NULL,NULL,NULL,NULL,NULL,NULL,'Sub consulta de agenda de treinamentos ','Painel'),(9,'sub_consulta_PAC_1100_sol_portal',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(9,'sub_consulta_PAC_3200_tit_consent',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(9,'sub_consulta_PAC_4000_notificacao',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(9,'sub_consulta_PAG_ocorr_lote_1100',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(9,'sub_form_configurar_metados',NULL,NULL,NULL,NULL,NULL,NULL,'Configurar metadados','Painel'),(9,'sub_grid_CMP_1550_ger_acao',NULL,NULL,NULL,NULL,NULL,NULL,'Sub grid de recomendaçoes de auditoria por ciclo','Painel'),(9,'sub_grid_LGPD_2050_assoc_atv_art',NULL,NULL,NULL,NULL,NULL,NULL,'Sub consulta de associação entre ativos e artefatos',NULL),(9,'sub_grid_PAC_1400_tit_afet_inc',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(9,'sub_grid_public_LGPD_2093_ocorr_terc',NULL,NULL,NULL,NULL,NULL,NULL,'Sub consulta ocorrência de terceiros','Painel'),(10,'app_change_pswd','',NULL,NULL,NULL,NULL,NULL,'[Item de menu] - Segurança / Alteração de senha: Acesso à gestão de senhas de usuários da plataforma','Segurança'),(10,'app_form_add_users','','','','',NULL,NULL,'Cadastrar usuários','Formulário'),(10,'app_form_edit_users','','','','',NULL,NULL,'Alterar usuários','Formulário'),(10,'app_form_sec_apps','','','','',NULL,NULL,'Cadastrar aplicações','Formulário'),(10,'app_form_sec_groups','','','','',NULL,NULL,'Cadastro de grupos de usuários','Formulário'),(10,'app_form_sec_groups_apps','','','','',NULL,NULL,'Associar grupos x aplicações','Painel'),(10,'app_grid_sec_apps','',NULL,NULL,NULL,NULL,NULL,'[Item de menu] - Segurança / Aplicações: Acesso ao cadastro de aplicações da plataforma','Segurança'),(10,'app_grid_sec_groups','',NULL,NULL,NULL,NULL,NULL,'[Item de menu] - Segurança / Perfis: Acesso ao cadastro de perfis de acesso dos usuários da plataforma','Segurança'),(10,'app_grid_sec_users','',NULL,NULL,NULL,NULL,NULL,'[Item de menu] - Segurança / Usuários: Acesso ao cadastro de usuários da plataforma','Segurança'),(10,'app_grid_sec_users_groups','',NULL,NULL,NULL,NULL,NULL,'[Item de menu] - Segurança / Associação de usuários a perfis: Acesso à configuração da associação de usuários a perfis de acesso','Segurança'),(10,'app_Login',NULL,NULL,NULL,NULL,NULL,NULL,'Login',NULL),(10,'app_menu',NULL,NULL,NULL,NULL,NULL,NULL,'Menu','Painel'),(10,'app_retrieve_pswd',NULL,NULL,NULL,NULL,NULL,NULL,'Esqueceu a senha','Painel'),(10,'app_search_sec_groups','',NULL,NULL,NULL,NULL,NULL,'[Item de menu] - Segurança / Associação de perfis a aplicações: Acesso à configuração da associação de perfis de acesso com as aplicações da plataforma','Segurança'),(10,'app_settings','',NULL,NULL,NULL,NULL,NULL,'Configurações de segurança','Segurança'),(10,'app_sync_apps','',NULL,NULL,NULL,NULL,NULL,'Sincronização de aplicações','Segurança'),(10,'Artefatos','',NULL,NULL,NULL,NULL,NULL,'[Item de menu] - Painel / Artefatos: Acesso à exibição dos principais indicadores sobre Artefatos e Documentos','Painel'),(10,'associar_metadados_finalidade',NULL,NULL,NULL,NULL,NULL,NULL,'Associar metadados na finalidade','Painel'),(10,'associar_metadados_finalidade_new',NULL,NULL,NULL,NULL,NULL,NULL,'Associar metadados a finalidades','Painel'),(10,'Atividades','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Painel / Atividades e Ações: Acesso à exibição dos principais indicadores sobre Atividades e Ações','Painel'),(10,'Ativos','',NULL,NULL,NULL,NULL,NULL,'[Item de menu] - Painel / Ativos de Informação: Acesso à exibição dos principais indicadores sobre Ativos de Informação','Painel'),(10,'Auto_cadastro_PAC_4000_notificacao',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(10,'blank_email',NULL,NULL,NULL,NULL,NULL,NULL,'Enviar mail','Painel'),(10,'blank_pipeline','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Atividades e Ações / Meu Quadro de Atividades: Acesso ao Kanban de atividades do usuário logado','Atividades e Ações'),(10,'blank_pipeline_Ajax',NULL,NULL,NULL,NULL,NULL,NULL,'Pipeline de atividades','Painel'),(10,'cad_sol_dpia_pcp_9000','Y',NULL,NULL,NULL,'Y','Y',NULL,'Fluxo de Informação'),(10,'Cadastro_DEN_1000_registro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(10,'Cadastro_DEN_1100_cat',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(10,'cadastro_PAC_1110_atv_sol',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(10,'cadastro_PAC_1200_sla_sol_portal',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(10,'Cadastro_PAC_1400_titulares',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(10,'Cadastro_PAC_1410_dados_tit',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(10,'Cadastro_PAC_2000_incidentes',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(10,'Cadastro_PAC_2100_sla_notificacao',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(10,'Cadastro_PAC_3100_env_consent',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(10,'Cadastro_PAC_4000_notificacao',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(10,'Cadastro_PAG_lote_1000',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(10,'cadastro_PAG_ocorr_lote_1100',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(10,'calendar_app',NULL,NULL,NULL,NULL,NULL,NULL,'Calendário','Painel'),(10,'calendar_public_LGPD_4000_atividades',NULL,NULL,NULL,NULL,NULL,NULL,'Calendário de atividades ( DPO )','Painel'),(10,'chart_public_LGPD_2000_processos_complex',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico processo por complexidade','Painel'),(10,'chart_public_LGPD_2000_processos_geral',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico processos','Painel'),(10,'chart_public_LGPD_2000_processos_resp',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico processos por responsável','Painel'),(10,'chart_public_LGPD_2000_status_processos',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico processo por status','Painel'),(10,'chart_public_LGPD_2000_tipo_processo',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico processos por tipo','Painel'),(10,'chart_public_LGPD_2010_confia_ativos',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico confibilidade dos ativos','Painel'),(10,'chart_public_LGPD_2010_disp_ativos',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico ativos por nível de disponibilidade','Painel'),(10,'chart_public_LGPD_2010_integridade_ativos',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico ativos por nível de integridade','Painel'),(10,'chart_public_LGPD_2010_resp_ativos',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico ativos por responsável','Painel'),(10,'chart_public_LGPD_2010_tipo_ativos',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico tipos de ativos','Painel'),(10,'chart_public_LGPD_2020_artefat_contrato',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico artefatos tipo contrato','Painel'),(10,'chart_public_LGPD_2020_contrato_artefatos',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico contratos x artefatos','Painel'),(10,'chart_public_LGPD_2020_tipo_artefatos',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico artefatos por tipo','Painel'),(10,'chart_public_LGPD_2030_classif_dados',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico classificação de metadados','Painel'),(10,'chart_public_LGPD_2030_dados_anonimizavel',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico metadados anonimizavel','Painel'),(10,'chart_public_LGPD_2030_tipif_dados',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico tipos de dados','Painel'),(10,'chart_public_LGPD_2070_fin_compart_dados',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico finalidades por compartilhamento','Painel'),(10,'chart_public_LGPD_2070_fin_dad_criancas',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico finalidades por dados de crianças','Painel'),(10,'chart_public_LGPD_2070_fin_faz_descarte',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico finalidades por descarte','Painel'),(10,'chart_public_LGPD_2070_fin_frequencia',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico finalidades por ferequencia','Painel'),(10,'chart_public_LGPD_2070_fin_hipoteses',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico finalidades por hipóteses de tratamento','Painel'),(10,'chart_public_LGPD_2070_fin_papel',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico papel da entidade','Painel'),(10,'chart_public_LGPD_2070_fin_processos',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico finalidades por processos','Painel'),(10,'chart_public_LGPD_2070_fin_rot_automatizada',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico finalidades por rotinas automatizadas','Painel'),(10,'chart_public_LGPD_2070_fin_utlz_operador',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico finalidades por utiliza operador','Painel'),(10,'chart_public_LGPD_2070_fin_volumetria',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico finliadades por volumetria','Painel'),(10,'chart_public_LGPD_3000_categoria_riscos',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico riscos por categoria','Painel'),(10,'chart_public_LGPD_3000_criticidade_riscos',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico riscos por criticidade','Painel'),(10,'chart_public_LGPD_3000_estrategia_riscos',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico riscos por estratégia','Painel'),(10,'chart_public_LGPD_3000_impacto_riscos',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico riscos por impacto','Painel'),(10,'chart_public_LGPD_3000_prob_riscos',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico riscos por probabilidade','Painel'),(10,'chart_public_LGPD_3000_resp_riscos',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico riscos por responsáveis','Painel'),(10,'chart_public_LGPD_3000_status_riscos',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico riscos por status','Painel'),(10,'chart_public_LGPD_4000_atividades_geral',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico atividades','Painel'),(10,'chart_public_LGPD_4000_disc_atividades',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico atividades por disciplina','Painel'),(10,'chart_public_LGPD_4000_etapa_atividades',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico atividades por etapas','Painel'),(10,'chart_public_LGPD_4000_resp_atividades',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico atividades por responsável','Painel'),(10,'chart_public_LGPD_4000_status_resp_atividade',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico atividades por responsável e status','Painel'),(10,'chart_public_LGPD_assoc_pdca_contr_6500',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico PDCA de contratos','Painel'),(10,'chart_public_LGPD_assoc_pdca_finalizados_treina_6500',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico PDCA de treinamentos','Painel'),(10,'chart_public_LGPD_assoc_pdca_medtec_6700',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico PDCA de medidas técnicas','Painel'),(10,'chart_public_LGPD_assoc_pdca_pol_6300',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico PDCA de políticas','Painel'),(10,'chart_public_LGPD_assoc_pdca_proc_6600',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico PDCA de processos','Painel'),(10,'chart_public_LGPD_assoc_pdca_realizar_treina_6500',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico PDCA realização de treinamentos','Painel'),(10,'chart_public_LGPD_assoc_pdca_risk_6400',NULL,NULL,NULL,NULL,NULL,NULL,'Gráfico PDCA de riscos','Painel'),(10,'cons_dad_nao_utlz_LGPD_2030_dados','',NULL,NULL,NULL,NULL,NULL,'[Item de menu] - Fluxo de Informação / Metadados Pessoais não utilizados: Acesso à consulta dos Metadados Pessoais cadastrados mas não utilizados em nenhuma associação','Fluxo de Informação'),(10,'cons_minhas_obr_CMP_1610_ol_agenda','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Aspectos Jurídicos / Minhas Obrigações Legais: Acesso ao cadastro das obrigações legais da entidade que estão sob a responsabilidade do usuário logado','Aspectos Jurídicos'),(10,'Consulta_DEN_1000_registro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(10,'Consulta_DEN_1100_cat',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(10,'consulta_gerencial_CMP_1610_ol_agenda','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Aspectos Jurídicos / Acompanhamento de Obrigações Legais: Acesso ao painel de acompanhamento do status das obrigações legais da entidade','Aspectos Jurídicos'),(10,'consulta_gerencial_LGPD_4000_atividades','',NULL,NULL,NULL,NULL,NULL,'[Item de menu] - Atividades e Ações / Acompanhamento de Atividades e Ações: Acesso ao painel de acompanhamento do status das obrigações legais da entidade','Atividades e Ações'),(10,'Consulta_LGPD_3000_riscos_assistant',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(10,'Consulta_LGPD_4000_atividades_assistant',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(10,'Consulta_PAC_1000_user_portal',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(10,'Consulta_PAC_1100_sol_portal',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(10,'consulta_PAC_1200_sla_sol_portal',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(10,'Consulta_PAC_1400_titulares',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(10,'Consulta_PAC_1410_dados_tit',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(10,'Consulta_PAC_2000_incidentes',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(10,'Consulta_PAC_3100_env_consent',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(10,'Consulta_PAC_4000_notificacao',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(10,'Consulta_PAG_lote_1000',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(10,'Consulta_public_LGPD_3000_riscos',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(10,'control_calendar',NULL,NULL,NULL,NULL,NULL,NULL,'Meu calendário de atividades de adequação',NULL),(10,'control_login',NULL,NULL,NULL,NULL,NULL,NULL,'Login','Painel'),(10,'control_login_diligence',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(10,'esqueci_senha',NULL,NULL,NULL,NULL,NULL,NULL,'Esqueceu a senha','Painel'),(10,'extrato_pdca',NULL,NULL,NULL,NULL,NULL,NULL,'Extrato PDCA','Painel'),(10,'Finalidades','',NULL,NULL,NULL,NULL,NULL,'[Item de menu] - Painel / Finalidades de Tratamento de Dados Pessoais: Acesso à exibição dos principais indicadores sobre Finalidades de Tratamento de Dados Pessoais','Painel'),(10,'form_aval_7000','Y',NULL,NULL,NULL,'Y','Y','Formulários de due diligence: Acesso à criação de formulários (e suas questões) para auto avaliação de terceiros','Gestão de Terceiros'),(10,'form_CMP_1000_mecanismos','Y','','','',NULL,NULL,'Cadastro de mecanismos de auditoria ','Formulário'),(10,'form_CMP_1100_componentes','Y','','','',NULL,NULL,'Cadastro de componentes de auditoria','Formulário'),(10,'form_CMP_1200_questoes','Y','','','',NULL,NULL,'Cadastro de questões de auditoria','Formulário'),(10,'form_CMP_1300_formularios','Y','','','',NULL,NULL,'Cadatro de formulários de auditoria ','Formulário'),(10,'form_CMP_1300_formularios_edit','Y','','','',NULL,NULL,'Edição de formulários de auditoria','Formulário'),(10,'form_CMP_1400_formulas_mestre','Y','','','',NULL,NULL,'Parametrização de Setup de Auditoria','Formulário'),(10,'form_CMP_1400_formulas_view','Y','','','',NULL,NULL,'Visualizar setup de auditoria','Formulário'),(10,'form_CMP_1410_formulas_det_mec','Y','','','',NULL,NULL,'Parametrizar mecanismos de auditoria no setup','Formulário'),(10,'form_CMP_1420_formulas_det_niv_ad','Y','','','',NULL,NULL,'Parametrizar níveis de aderência do setup de auditoria ','Formulário'),(10,'form_CMP_1430_formulas_det_lim','Y','','','',NULL,NULL,'Parametrizar faixas do setup de auditoria','Formulário'),(10,'form_CMP_1500_acao','Y','','','',NULL,NULL,'Recomendações de auditorias','Formulário'),(10,'form_CMP_1600_OL','Y','','','',NULL,NULL,'Cadastro de Obrigações Legais ','Formulário'),(10,'form_CMP_2000_ciclos','Y','','','',NULL,NULL,'Cadastro de ciclos de auditoria','Formulário'),(10,'form_CMP_2500_conf_entrevistados','Y','','','',NULL,NULL,'Cadastro de entrevistados do ciclo de auditoria ','Formulário'),(10,'form_CMP_2500_conf_entrevistados_1','Y','','','',NULL,NULL,'Cadastro de entrevistados ','Formulário'),(10,'form_CMP_2500_conf_param_entrevistados','Y','','','',NULL,NULL,'Parametrizar relação de entrevistados de um ciclo de auditoria','Formulário'),(10,'form_CMP_3000_aplic_pesq','Y','','','',NULL,NULL,'Cadastro de aplicação de pesquisa de auditorias ','Formulário'),(10,'form_CMP_resultados_pesquisas','Y','','','',NULL,NULL,'Cadastro de resultado de pesquisas de auditoria','Formulário'),(10,'form_conf_quest_7100','Y','','','',NULL,NULL,'Configurar questionário de fornecedores','Formulário'),(10,'form_diligence',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(10,'form_DOM_tp_ol_1600','Y','','','',NULL,NULL,'Cadastro de tipos de obrigações ','Formulário'),(10,'form_kanban_atividades','Y','','','Y',NULL,NULL,'Kanban de  atividades','Formulário'),(10,'form_kanban_atividades_add_registro','Y','','','Y',NULL,NULL,'Cadastrar atividades pelo kanban','Formulário'),(10,'form_LGPD_0002_conf_smpt','',NULL,NULL,NULL,NULL,NULL,'[Item de menu] - Configurações / Configuração de envio de e-mails: Acesso à configuração do endereço de de SMTP para envio de e-mails da plataforma','Formulário'),(10,'form_LGPD_2001_form_entr_prc','Y',NULL,NULL,NULL,'Y','Y',NULL,'Fluxo de Informação'),(10,'form_LGPD_2003_envio_entr_prc','Y',NULL,NULL,NULL,'Y','Y',NULL,'Fluxo de Informação'),(10,'form_LGPD_2087_ndas','Y',NULL,NULL,NULL,'Y','Y',NULL,'Fluxo de Informação'),(10,'form_LGPD_2097_assoc_med_atv',NULL,NULL,NULL,NULL,NULL,NULL,'Cadastro de Medidas Técnicas - > Cadastro da especificação da associação entre medida técnica e ativo','Painel'),(10,'form_LGPD_3500_checklist_risk_padrao','Y','','','','Y','Y','[Item de menu] - Riscos / Checklist padrão de identificação de riscos e atividades','Riscos'),(10,'form_LGPD_3600_chklst_risk_area_mestre','Y','','','','Y','Y','Formulário de checklist por área de identificação de riscos e atividades','Riscos'),(10,'form_LGPD_4000_atividades','Y','','','Y',NULL,NULL,'Cadastro de atividades de adequação','Formulário'),(10,'form_LGPD_4000_atividades_calendar',NULL,NULL,NULL,NULL,NULL,NULL,'Cadastro de atividades de adequação','Formulário'),(10,'form_minhas_obr_CMP_1610_ol_agenda',NULL,NULL,NULL,NULL,NULL,NULL,'Edição das minhas obrigações legais ','Painel'),(10,'form_new_pln_acao','Y','','','',NULL,NULL,'Cadastrar plano de ação','Formulário'),(10,'form_PAC_1100_sol_portal',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(10,'form_pcp_9100_LIA','Y',NULL,NULL,NULL,'Y','Y',NULL,'Fluxo de Informação'),(10,'form_public_LGPD_0100_diagnostico','','','','',NULL,NULL,'Parametrizar etapa de diagnóstico','Formulário'),(10,'form_public_LGPD_0200_implement','','','','',NULL,NULL,'Parametrizar etapa de implementação','Formulário'),(10,'form_public_LGPD_0300_operacao','','','','',NULL,NULL,'Parametrizar etapa de operação','Formulário'),(10,'form_public_LGPD_0400_etapas','','','','',NULL,NULL,'Parametrizar etapas','Formulário'),(10,'form_public_LGPD_1000_controlador','Y','','','',NULL,NULL,'Cadastro de controlador','Formulário'),(10,'form_public_LGPD_1001_diretoria','Y','','','',NULL,NULL,'Cadastro de diretoria','Formulário'),(10,'form_public_LGPD_1002_area','Y','','','',NULL,NULL,'Cadastro de área','Formulário'),(10,'form_public_LGPD_1003_departamento','Y','','','',NULL,NULL,'Cadastro de departamentos','Formulário'),(10,'form_public_LGPD_1004_cargos','Y','','','',NULL,NULL,'Cadastro de cargos','Formulário'),(10,'form_public_LGPD_1050_organograma','Y','','','',NULL,NULL,'Cadastro de organograma','Formulário'),(10,'form_public_LGPD_1051_comite','Y','Y','Y','Y',NULL,NULL,'Cadastro de comitê','Formulário'),(10,'form_public_LGPD_1053_eventos_comite','Y','Y','Y','Y',NULL,NULL,'Agenda de eventos do comitê','Formulário'),(10,'form_public_LGPD_1100_equipe','Y','','','',NULL,NULL,'Cadastro de equipe','Formulário'),(10,'form_public_LGPD_1100_equipe_1','Y','','','',NULL,NULL,'Cadastro de equipe','Formulário'),(10,'form_public_LGPD_2000_processos','Y','','','',NULL,NULL,'Cadastro de processos','Formulário'),(10,'form_public_LGPD_2010_ativos','','','','',NULL,NULL,'Cadastro de ativos','Formulário'),(10,'form_public_LGPD_2020_artefatos','','','','',NULL,NULL,'Cadastro de artefatos','Formulário'),(10,'form_public_LGPD_2030_dados','','','','',NULL,NULL,'Cadastro de metadados','Formulário'),(10,'form_public_LGPD_2060_config_assoc',NULL,NULL,NULL,NULL,NULL,NULL,'Associação artefato x metadados','Formulário'),(10,'form_public_LGPD_2065_fund_legal','Y','','','',NULL,NULL,'Cadastro de fundamentos legais','Formulário'),(10,'form_public_LGPD_2066_ambiente_reg','Y','','','',NULL,NULL,'Cadastro de ambientes regulatórios','Formulário'),(10,'form_public_LGPD_2070_finalidades','','','','',NULL,NULL,'Parametrizar finalidades','Formulário'),(10,'form_public_LGPD_2070_registrar_finalidades','','','','',NULL,NULL,'Registrar finalidades','Formulário'),(10,'form_public_LGPD_2075_param_assoc_funcional_fin',NULL,NULL,NULL,NULL,NULL,NULL,'Associação funcional da finalidade','Formulário'),(10,'form_public_LGPD_2080_politicas','Y','','','',NULL,NULL,'Cadastro de políticas','Formulário'),(10,'form_public_LGPD_2085_contratos','Y','','','',NULL,NULL,'Cadastro de contratos','Formulário'),(10,'form_public_LGPD_2090_terceiros','Y','','','',NULL,NULL,'Cadastro de terceiros','Formulário'),(10,'form_public_LGPD_2093_ocorr_terc','Y','','','',NULL,NULL,'Cadastro de ocorrência de terceiros','Formulário'),(10,'form_public_LGPD_2095_med_tec','','','','',NULL,NULL,'Cadastro de medidas técnicas','Formulário'),(10,'form_public_LGPD_2097_config_assoc_med_atv',NULL,NULL,NULL,NULL,NULL,NULL,'Associar medidas técnicas aos ativos','Formulário'),(10,'form_public_LGPD_2100_prz_aprv_proc','',NULL,NULL,NULL,NULL,NULL,'[Item de menu] - Configurações / SLA de aprovação de Processos de Negócio: Acesso à configuração do prazo limite para aprovação de Processos de Negócio cadastrados','Formulário'),(10,'form_public_LGPD_3000_riscos','Y','Y','Y','Y',NULL,NULL,'Cadastro de riscos','Formulário'),(10,'form_public_LGPD_4000_atividades','Y','','','Y',NULL,NULL,'Cadastro de atividades','Formulário'),(10,'form_public_LGPD_5000_cod_etica','Y','Y','Y','Y',NULL,NULL,'Cadastro de código de ética','Formulário'),(10,'form_public_LGPD_5100_cod_conduta',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(10,'form_public_LGPD_6000_PDCA','Y','','','',NULL,NULL,'PDCA','Formulário'),(10,'form_public_LGPD_6100_catalog_treinamentos','Y','','','',NULL,NULL,'Cadastro de catalogo de treinamentos','Formulário'),(10,'form_public_LGPD_6200_agenda_treina','Y','Y','Y','Y',NULL,NULL,'Agenda de treinamentos','Formulário'),(10,'form_public_LGPD_7300_envio_aval_forne','Y','','','',NULL,NULL,'Cadastro de questionários (Due Diligence)','Formulário'),(10,'form_public_LGPD_assoc_contr_6500',NULL,NULL,NULL,NULL,NULL,NULL,'Associação de contratos','Formulário'),(10,'form_public_LGPD_assoc_medtec_6700',NULL,NULL,NULL,NULL,NULL,NULL,'Associação de medidas técnicas','Formulário'),(10,'form_public_LGPD_assoc_pdca_risk_6400',NULL,NULL,NULL,NULL,NULL,NULL,'Associação de riscos ao PDCA','Formulário'),(10,'form_public_LGPD_assoc_pol_6300',NULL,NULL,NULL,NULL,NULL,NULL,'Associação de políticas','Formulário'),(10,'form_public_LGPD_assoc_proc_6600',NULL,NULL,NULL,NULL,NULL,NULL,'Associação de processos','Formulário'),(10,'form_public_LGPD_assoc_treina_6500',NULL,NULL,NULL,NULL,NULL,NULL,'Associação de treinamentos','Formulário'),(10,'form_public_LGPD_config_det_opt_7200','Y','','','',NULL,NULL,'Parametrizar opções do questionário de fornecedores','Formulário'),(10,'form_public_PAC_1000_user_portal',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(10,'Governance_menu',NULL,NULL,NULL,NULL,NULL,NULL,'Menu',NULL),(10,'grid_CMP_0100_faixas',NULL,NULL,NULL,NULL,NULL,NULL,'Consultar faixas de setup de auditoria','Painel'),(10,'grid_CMP_1000_mecanismos','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Pilares do Compliance / Mecanismos de Auditoria: Acesso ao cadastro de Mecanismos de Auditoria para projetos de Compliance','Pilares de Compliance'),(10,'grid_CMP_1100_componentes','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Pilares do Compliance / Componentes de Auditoria: Acesso ao cadastro de Componentes de Auditoria, que compõem os Mecanismos cadastrados','Pilares de Compliance'),(10,'grid_CMP_1100_entrevistados_desassociados',NULL,NULL,NULL,NULL,NULL,NULL,'Consultas candidatos a entrevistas de ciclo de auditoria ','Painel'),(10,'grid_CMP_1200_questoes','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Pilares do Compliance / Questões de Auditoria: Acesso ao cadastro de perguntas que são utilizadas para a realização de auditorias de Compliance','Pilares de Compliance'),(10,'grid_CMP_1300_formularios','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Pilares do Compliance / Formulários de Auditoria: Acesso ao cadastro e configuração de Formulários compostos por perguntas para a realização de auditorias de Compliance','Pilares de Compliance'),(10,'grid_CMP_1310_formulario_det',NULL,NULL,NULL,NULL,NULL,NULL,'Consulta detalhes do formulário de auditoria ','Painel'),(10,'grid_CMP_1400_formulas_mestre','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Pilares do Compliance / Parâmetros de Ciclos de Auditoria: Acesso à configuração de parâmetros quantitativos utilizados nos Ciclos de Auditoria de Compliance','Pilares de Compliance'),(10,'grid_CMP_1410_formulas_det_mec',NULL,NULL,NULL,NULL,NULL,NULL,'Sub Consulta mecanismos do setup de auditoria','Painel'),(10,'grid_CMP_1500_acao','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Pilares do Compliance / Ações de Auditoria: Acesso ao cadastro de ações pré-determinadas para serem sugeridas a partir do levantamento de determinada Questão cadastrada','Pilares de Compliance'),(10,'grid_CMP_1550_ger_acao','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Auditoria de Compliance / Recomendações de Auditoria: Acesso à geração automática de recomendações pós Ciclo de Auditoria de Compliance','Auditoria de Compliance'),(10,'grid_CMP_1600_OL','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Aspectos Jurídicos / Obrigações Legais: Acesso ao cadastro das obrigações legais que a entidade deve atender em um determinado exercício','Aspectos Jurídicos'),(10,'grid_CMP_2000_ciclos','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Auditoria de Compliance / Ciclos de Auditoria: Acesso à gestão de Ciclos de Auditoria de Compliance','Auditoria de Compliance'),(10,'grid_CMP_2500_conf_entrevistados','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Auditoria de Compliance / Entrevistados: Acesso à seleção de entrevistados que estarão associados a um Ciclo de Auditoria de Compliance','Auditoria de Compliance'),(10,'grid_CMP_2510_entrevistados_associados',NULL,NULL,NULL,NULL,NULL,NULL,'Relação de entrevistados de um ciclo de auditoria','Painel'),(10,'grid_CMP_3000_aplic_pesq','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Auditoria de Compliance / Pesquisas de Auditoria: Acesso à aplicação de Pesquisas de Auditoria de Compliance','Auditoria de Compliance'),(10,'grid_CMP_acompanhar_pesquisas',NULL,NULL,NULL,NULL,NULL,NULL,'Consulta acompanhamento do andamento de pesquisas de auditorias','Painel'),(10,'grid_CMP_resultado_pesquisa','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Auditoria de Compliance / Resultados de Auditoria: Acesso à gestão do resultado de Pesquisas de Auditoria de Compliance','Auditoria de Compliance'),(10,'grid_CMP_resultado_pesquisa_questoes',NULL,NULL,NULL,NULL,NULL,NULL,'Consulta resultado da pesquisa de auditoria ','Painel'),(10,'grid_CMP_resultado_pesquisa_status_mecanismo',NULL,NULL,NULL,NULL,NULL,NULL,'Consulta resultado da pesquisa por mecanismos de auditoria ','Painel'),(10,'grid_conf_quest_7100',NULL,NULL,NULL,NULL,NULL,NULL,'Cofiguração de questionário para fornecedores','Painel'),(10,'grid_DOM_tp_ol_1600','',NULL,NULL,NULL,NULL,NULL,'[Item de menu] - Aspectos Jurídicos / Tipos de Obrigações Legais: Acesso ao cadastro de tipos de obrigações legais','Aspectos Jurídicos'),(10,'grid_kanban_atividades',NULL,NULL,NULL,NULL,NULL,NULL,'Kanban de  atividades','Painel'),(10,'grid_kanban_atividades_add_registro',NULL,NULL,NULL,NULL,NULL,NULL,'Kanban de  atividades','Painel'),(10,'grid_LGPD_2001_form_entr_prc','Y',NULL,NULL,NULL,'Y','Y',NULL,'Fluxo de Informação'),(10,'grid_LGPD_2003_envio_entr_prc','Y',NULL,NULL,NULL,'Y','Y',NULL,'Fluxo de Informação'),(10,'grid_LGPD_2040_assoc_prc_atv','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Fluxo de Informação / Associações do Fluxo de Informação: Acesso à consulta das associações entre Processos de Negócio x Ativos de Informação x Artefatos x Metadados Pessoais','Fluxo de Informação'),(10,'grid_LGPD_2075_assoc_funcional_dados_fin',NULL,NULL,NULL,NULL,NULL,NULL,'Consulta associação de metadados','Painel'),(10,'grid_LGPD_2087_ndas','Y',NULL,NULL,NULL,'Y','Y',NULL,'Políticas e Regulamentos'),(10,'grid_LGPD_2097_assoc_med_atv','',NULL,NULL,NULL,NULL,NULL,'[Item de menu] - Medidas Técnicas de Segurança / Associações com Ativos de Informação: Acesso à configuração da associação entre Medidas Técnicas de Segurança e Ativos de Informação utilizados pela entidade','Medidas Técnicas de Segurança'),(10,'grid_LGPD_3100_assoc_risc_atv','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Riscos / Associações de Riscos: Acesso à associações entre Riscos e outras informações cadastradas','Riscos'),(10,'grid_LGPD_3600_chklst_risk_area_mestre','Y','','','','Y','Y','[Item de menu] - Riscos / Checklist por área de identificação de riscos e atividades','Riscos'),(10,'grid_LGPD_6300_aluno_treina',NULL,NULL,NULL,NULL,NULL,NULL,'Consulta de lista de treinamentos realizados por colaborador','Painel'),(10,'grid_LGPD_7400_resp_aval_forne',NULL,NULL,NULL,NULL,NULL,NULL,'Consulta respostas de questionários  (Due Diligence)','Painel'),(10,'grid_new_pln_acao','',NULL,NULL,NULL,NULL,NULL,'[Item de menu] - Atividades e Ações / Plano de Ação LGPD: Acesso ao cadastro do documento \"Plano de Ação\" de adequação à LGPD','Atividades e Ações'),(10,'grid_public_LGPD_0100_diagnostico','',NULL,NULL,NULL,NULL,NULL,'[Item de menu] - Configurações / Projeto de Diagnóstico da LGPD: Acesso à configuração das informações sobre o projeto de Diagnóstico da LGPD','Configurações'),(10,'grid_public_LGPD_0200_implement','',NULL,NULL,NULL,NULL,NULL,'[Item de menu] - Configurações / Projeto de Adequação da LGPD: Acesso à configuração das informações sobre o projeto de Adequação da LGPD','Configurações'),(10,'grid_public_LGPD_0300_operacao','',NULL,NULL,NULL,NULL,NULL,'[Item de menu] - Configurações / Projeto de Operação da LGPD: Acesso à configuração das informações sobre a fase de Operação da LGPD','Configurações'),(10,'grid_public_LGPD_0400_etapas','',NULL,NULL,NULL,NULL,NULL,'[Item de menu] - Configurações / Etapas do Diagnóstico da LGPD: Acesso à configuração das etapas do projeto de Diagnóstico de um projeto de adequação à LGPD','Configurações'),(10,'grid_public_LGPD_1000_controlador','',NULL,NULL,NULL,NULL,NULL,'[Item de menu] - Configurações / Entidade: Acesso à configuração dos dados da entidade','Configurações'),(10,'grid_public_LGPD_1001_diretoria','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Estrutura Organizacional / Diretoria: Acesso ao cadastro de Diretorias, que é o nível mais alto da hierarquia organizacional da entidade','Estrutura Organizacional'),(10,'grid_public_LGPD_1002_area','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Estrutura Organizacional / Área: Acesso ao cadastro de Áreas, que dividem uma determinada Diretoria na estrutura hierárquica da entidade','Estrutura Organizacional'),(10,'grid_public_LGPD_1003_departamento','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Estrutura Organizacional / Departamentos: Acesso ao cadastro de Departamentos, que dividem uma determinada Área na estrutura hierárquica da entidade','Estrutura Organizacional'),(10,'grid_public_LGPD_1004_cargos','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Estrutura Organizacional / Cargos: Acesso ao cadastro de Cargos a serem ocupados por pessoas da equipe que ocupem espaço na estrutura hierárquica da entidade','Estrutura Organizacional'),(10,'grid_public_LGPD_1050_organograma','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Estrutura Organizacional / Lotação: Acesso ao cadastro de unidades de trabalho, onde é possível alocar as equipes da entidade','Estrutura Organizacional'),(10,'grid_public_LGPD_1051_comite','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Estrutura Organizacional / Comitês: Acesso ao cadastro de comitês da entidade, que congregam uma ou mais pessoas previamente cadastradas','Estrutura Organizacional'),(10,'grid_public_LGPD_1053_eventos_comite','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Atividades e Ações / Eventos de Comitê: Acesso ao cadastro de eventos associados aos Comitês da entidade','Atividades e Ações'),(10,'grid_public_LGPD_1053_sub_eventos_comite',NULL,NULL,NULL,NULL,NULL,NULL,'Sub Consulta de Eventos','Painel'),(10,'grid_public_LGPD_1100_equipe','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Estrutura Organizacional / Equipe: Acesso ao cadastro de pessoas que podem ocupar cargos na estrutura hierárquica da entidade. Essas pessoas serão associadas a diversas outras entidades tratadas na plataforma','Estrutura Organizacional'),(10,'grid_public_LGPD_2000_proc_aprv_prz_expirado','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Atividades e Ações / Processos de Negócio Pendentes: Acesso à gestão de Processos de Negócio com SLA de aprovação expirado','Atividades e Ações'),(10,'grid_public_LGPD_2000_processos','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Fluxo de Informação / Processos de Negócio: Acesso ao cadastro de Processos de Negócio que definem as rotinas operacionais da entidade','Fluxo de Informação'),(10,'grid_public_LGPD_2000_sub_proc_pessoa',NULL,NULL,NULL,NULL,NULL,NULL,'Consulta processo por responsável','Painel'),(10,'grid_public_LGPD_2000_sub_processos_atv',NULL,NULL,NULL,NULL,NULL,NULL,'Consulta processos por ativos','Painel'),(10,'grid_public_LGPD_2010_ativos','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Fluxo de Informação / Ativos de Informação: Acesso ao cadastro de Ativos de Informação utilizados pela entidade na execução de seus Processos de Negócio','Fluxo de Informação'),(10,'grid_public_LGPD_2010_ativos_1',NULL,NULL,NULL,NULL,NULL,NULL,'Consulta Ativos','Painel'),(10,'grid_public_LGPD_2010_ativos_n_utlz_fin',NULL,NULL,NULL,NULL,NULL,NULL,'Processos disponivel para associação com finalidades','Painel'),(10,'grid_public_LGPD_2010_ativos_utlz_fin',NULL,NULL,NULL,NULL,NULL,NULL,'Processos associados a finalidade','Painel'),(10,'grid_public_LGPD_2010_sub_ativos',NULL,NULL,NULL,NULL,NULL,NULL,'Sub Consulta de Ativos','Painel'),(10,'grid_public_LGPD_2020_artefatos','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Fluxo de Informação / Artefatos: Acesso ao cadastro de Artefatos e Documentos tratados nos Ativos de Informação utilizados pela entidade','Fluxo de Informação'),(10,'grid_public_LGPD_2020_artefatos_n_utlz_fin',NULL,NULL,NULL,NULL,NULL,NULL,'Artefatos disponiveis para associação com finalidades','Painel'),(10,'grid_public_LGPD_2020_artefatos_utlz_fin',NULL,NULL,NULL,NULL,NULL,NULL,'Artefatos associados a finalidades','Painel'),(10,'grid_public_LGPD_2030_assoc_art_metadados',NULL,NULL,NULL,NULL,NULL,NULL,'Associação de Artefatos e metadados','Painel'),(10,'grid_public_LGPD_2030_dados','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Fluxo de Informação / Metadados Pessoais: Acesso ao cadastro de Metadados Pessoais presentes nos diferentes Artefatos utilizados pela entidade','Fluxo de Informação'),(10,'grid_public_LGPD_2065_fund_legal','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Aspectos Jurídicos / Fundamentos Legais: Acesso ao cadastro de Fundamentos Legais utilizados pela entidade','Aspectos Jurídicos'),(10,'grid_public_LGPD_2066_ambiente_reg','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Aspectos Jurídicos / Ambientes regulatórios: Acesso ao cadastro de Ambientes Regulatórios a serem associados a Fundamentos Legais utilizados pela entidade','Aspectos Jurídicos'),(10,'grid_public_LGPD_2070_finalidades','',NULL,NULL,NULL,NULL,NULL,'[Item de menu] - Tratamento de Dados Pessoais / Parametrizar Finalidades de Tratamentos: Acesso à configuração dos aspectos e detalhes das Finalidades de Tratamento de Dados Pessoais previamente cadastradas','Tratamento de Dados Pessoais'),(10,'grid_public_LGPD_2070_registrar_finalidades','',NULL,NULL,NULL,NULL,NULL,'[Item de menu] - Tratamento de Dados Pessoais / Registrar Finalidade de Tratamento: Acesso ao cadastro de Finalidades de Tratamento de Dados Pessoais executadas pela entidade','Tratamento de Dados Pessoais'),(10,'grid_public_LGPD_2070_sub_contratos_finalidades',NULL,NULL,NULL,NULL,NULL,NULL,'Sub consulta de contratos dentro da finalidade','Painel'),(10,'grid_public_LGPD_2070_sub_finalidades',NULL,NULL,NULL,NULL,NULL,NULL,'Sub consulta de finalidades','Painel'),(10,'grid_public_LGPD_2073_assoc_ativos_fin',NULL,NULL,NULL,NULL,NULL,NULL,'Associação de ativos na finalidade','Painel'),(10,'grid_public_LGPD_2075_assoc_metadados_fin',NULL,NULL,NULL,NULL,NULL,NULL,'Associação de metadados na finalidade','Painel'),(10,'grid_public_LGPD_2080_politicas','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Políticas e Regulamentos / Políticas: Acesso ao cadastro de políticas associadas à Governança de Privacidade da entidade','Políticas e Regulamentos'),(10,'grid_public_LGPD_2085_contratos','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Políticas e Regulamentos / Contratos: Acesso ao cadastro de contratos e modelos de contratos utilizados pela entidade','Políticas e Regulamentos'),(10,'grid_public_LGPD_2090_terceiros','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Gestão de terceiros / Terceiros: Acesso ao cadastro de entidades terceiras (PJ ou PF) associadas à entidade','Gestão de Terceiros'),(10,'grid_public_LGPD_2093_ocorr_terc','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Gestão de terceiros / Ocorrências: Acesso ao cadastro de ocorrências relacionadas à Terceiros associados à entidade','Gestão de Terceiros'),(10,'grid_public_LGPD_2095_med_tec','',NULL,NULL,NULL,NULL,NULL,'[Item de menu] - Medidas Técnicas de Segurança / Medidas Técnicas de Segurança: Acesso ao cadastro de Medidas Técnicas de Segurança da Informação que podem ser associadas a Ativos cadastrados','Medidas Técnicas de Segurança'),(10,'grid_public_LGPD_2095_sub_med_tec',NULL,NULL,NULL,NULL,NULL,NULL,'Sub Consulta de medidas técnicas','Painel'),(10,'grid_public_LGPD_3000_riscos','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Riscos / Riscos: Acesso ao cadastro de Riscos de Privacidade e Compliance','Riscos'),(10,'grid_public_LGPD_3000_sub_consulta_riscos',NULL,NULL,NULL,NULL,NULL,NULL,'Sub consulta de riscos','Painel'),(10,'grid_public_LGPD_3300_assoc_risc_prc',NULL,NULL,NULL,NULL,NULL,NULL,'Associar risco a processos','Painel'),(10,'grid_public_LGPD_4000_atividades','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Atividades e Ações / Atividades e Ações: Acesso ao cadastro de atividades e ações de governança e compliance','Atividades e Ações'),(10,'grid_public_LGPD_5000_cod_etica','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Políticas e Regulamentos / Códigos e Regulamentos Internos: Acesso ao cadastro de documentos que definem as regras internas de Compliance da entidade','Políticas e Regulamentos'),(10,'grid_public_LGPD_5100_cod_conduta',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(10,'grid_public_LGPD_6000_PDCA','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Atividades e Ações / Gestão de ciclo de PDCA de Compliance: Acesso ao planejamento e gestão de ciclos de PDCA de Compliance','Atividades e Ações'),(10,'grid_public_LGPD_6000_SUB_PDCA',NULL,NULL,NULL,NULL,NULL,NULL,'Sub consulta PDCA','Painel'),(10,'grid_public_LGPD_6100_catalog_treinamentos','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Atividades e Ações / Catálogo de treinamentos: Acesso ao cadastro dos tipos de treinamentos que a entidade pode executar para suas equipes','Atividades e Ações'),(10,'grid_public_LGPD_6200_agenda_treina','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Atividades e Ações / Agenda de Treinamentos: Acesso à gestão de agenda de treinamentos e capacitações internas da entidade','Atividades e Ações'),(10,'grid_public_LGPD_7300_envio_aval_forne',NULL,NULL,NULL,NULL,NULL,NULL,'Consulta de questionários (Due Diligence)','Painel'),(10,'grid_public_LGPD_7300_envio_aval_forne_gerencial','Y',NULL,NULL,NULL,'Y','Y',NULL,'Gestão de Terceiros'),(10,'grid_public_LGPD_cons_rev_contr_6500',NULL,NULL,NULL,NULL,NULL,NULL,'Consulta revisões de contrato','Painel'),(10,'grid_public_LGPD_cons_rev_medtec_6700',NULL,NULL,NULL,NULL,NULL,NULL,'Consulta revisões de medidas técnicas','Painel'),(10,'grid_public_LGPD_cons_rev_pol_6300',NULL,NULL,NULL,NULL,NULL,NULL,'Consulta revisão de políticas','Painel'),(10,'grid_public_LGPD_cons_rev_proc_6600',NULL,NULL,NULL,NULL,NULL,NULL,'Consulta revisão de processos','Painel'),(10,'grid_public_LGPD_cons_rev_risk_6400',NULL,NULL,NULL,NULL,NULL,NULL,'Consulta revisão de riscos','Painel'),(10,'grid_public_PAC_9000_DPIA',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(10,'grid_public_PAC_9100_LIA',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(10,'grid_public_PCP_9000_DPIA',NULL,NULL,NULL,NULL,NULL,NULL,'Consulta DPIA',NULL),(10,'grid_public_pcp_9100_LIA',NULL,NULL,NULL,NULL,NULL,NULL,'Consulta LIA ',NULL),(10,'grid_public_subconsulta_sec_users',NULL,NULL,NULL,NULL,NULL,NULL,'Sub consulta de usuarios','Painel'),(10,'grid_sc_log','',NULL,NULL,NULL,NULL,NULL,'[Item de menu] - Segurança / Histórico de acessos: Acesso à consulta à histórico de acessos de usuários à plataforma','Segurança'),(10,'help_cadastro_titulares',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(10,'help_ciclo_de_vida',NULL,NULL,NULL,NULL,NULL,NULL,'Help Ciclo de vida','Painel'),(10,'help_finalidades_fundamentos',NULL,NULL,NULL,NULL,NULL,NULL,'Help Finalidades','Painel'),(10,'help_geracao_atividades',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(10,'help_geracao_riscos',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(10,'help_gestao_consentimentos',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(10,'help_gestao_incidentes',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(10,'help_gestao_notificacao',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(10,'help_integracao_portais',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(10,'help_lotes_validacao',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(10,'help_medidas_administrativas',NULL,NULL,NULL,NULL,NULL,NULL,'Help medidas administrativas','Painel'),(10,'help_medidas_tecnicas',NULL,NULL,NULL,NULL,NULL,NULL,'Help para medidas técnicas','Painel'),(10,'help_plano_acao_atividades',NULL,NULL,NULL,NULL,NULL,NULL,'Help Atividades','Painel'),(10,'help_relatorios',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(10,'help_riscos_e_impactos',NULL,NULL,NULL,NULL,NULL,NULL,'Help Riscos','Painel'),(10,'homepage',NULL,NULL,NULL,NULL,NULL,NULL,'Home Page (Responsábilidades e Atividades)','Painel'),(10,'homepage_help',NULL,NULL,NULL,NULL,NULL,NULL,'Help','Painel'),(10,'mapa_calor_risco',NULL,NULL,NULL,NULL,NULL,NULL,'Mapa de risco','Painel'),(10,'Mapa_Calor_Riscos',NULL,NULL,NULL,NULL,NULL,NULL,'Mapa de calor de riscos ','Painel'),(10,'menu',NULL,NULL,NULL,NULL,NULL,NULL,'Menu PCP','Painel'),(10,'menu_dinamico',NULL,NULL,NULL,NULL,NULL,NULL,'Menu','Painel'),(10,'Menu_Pac',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(10,'Metadados','',NULL,NULL,NULL,NULL,NULL,'[Item de menu] - Painel / Metadados Pessoais: Acesso à exibição dos principais indicadores sobre Metadados Pessoais','Painel'),(10,'novo_menu',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(10,'pac_app_change_pswd','Y','','','','','','[Item de menu] - SeguranÃ§a / AlteraÃ§Ã£o de senha: Acesso Ã  gestÃ£o de senhas de usuÃ¡rios da plataforma','SeguranÃ§a'),(10,'pac_app_form_sec_groups_apps','',NULL,NULL,NULL,NULL,NULL,'[Item de menu] - SeguranÃ§a / AssociaÃ§Ã£o de perfis a aplicaÃ§Ãµes: Acesso Ã  configuraÃ§Ã£o da associaÃ§Ã£o de perfis de acesso com as aplicaÃ§Ãµes da plataforma','SeguranÃ§a'),(10,'pac_app_grid_sec_apps','',NULL,NULL,NULL,NULL,NULL,'[Item de menu] - SeguranÃ§a / AplicaÃ§Ãµes: Acesso ao cadastro de aplicaÃ§Ãµes da plataforma','SeguranÃ§a'),(10,'pac_app_grid_sec_groups','',NULL,NULL,NULL,NULL,NULL,'[Item de menu] - SeguranÃ§a / Perfis: Acesso ao cadastro de perfis de acesso dos usuÃ¡rios da plataforma','SeguranÃ§a'),(10,'pac_app_grid_sec_users','',NULL,NULL,NULL,NULL,NULL,'[Item de menu] - SeguranÃ§a / UsuÃ¡rios: Acesso ao cadastro de usuÃ¡rios da plataforma','SeguranÃ§a'),(10,'pac_app_grid_sec_users_groups','',NULL,NULL,NULL,NULL,NULL,'[Item de menu] - SeguranÃ§a / AssociaÃ§Ã£o de usuÃ¡rios a perfis: Acesso Ã  configuraÃ§Ã£o da associaÃ§Ã£o de usuÃ¡rios a perfis de acesso','SeguranÃ§a'),(10,'pac_app_search_sec_groups','',NULL,NULL,NULL,NULL,NULL,'[Item de menu] - SeguranÃ§a / AssociaÃ§Ã£o de perfis a aplicaÃ§Ãµes: Acesso Ã  configuraÃ§Ã£o da associaÃ§Ã£o de perfis de acesso com as aplicaÃ§Ãµes da plataforma','SeguranÃ§a'),(10,'pac_menu',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(10,'PAG_menu',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(10,'param_aval_mestre_7000','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Gestão de terceiros / Formulários de due diligence: Acesso à criação de formulários (e suas questões) para auto avaliação de terceiros','Gestão de Terceiros'),(10,'PDCA','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Painel / Ciclos de PDCA: Acesso à exibição dos principais indicadores sobre Ciclos de PDCA de Compliance','Painel'),(10,'pdfreport_LGPD_7300_envio_aval_forne',NULL,NULL,NULL,NULL,NULL,NULL,'geração de PDF - questionário (Due Diligence)','Painel'),(10,'popup_confirm_action',NULL,NULL,NULL,NULL,NULL,NULL,'Pop-up ( não se aplica ao módulo de segirança)','Painel'),(10,'popup_confirm_action_status',NULL,NULL,NULL,NULL,NULL,NULL,'Pop_Up ( Não se plaica ao módulo de segurança ) ','Painel'),(10,'Processos','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Painel / Processos de Negócio: Acesso à exibição dos principais indicadores sobre Processos de Negócio','Painel'),(10,'relatorio_ciclos_complience',NULL,NULL,NULL,NULL,NULL,NULL,'Extrato de cilco de auditoria ','Painel'),(10,'relatorio_dpia',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(10,'relatorio_dpia_1',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(10,'relatorio_finalidades',NULL,NULL,NULL,NULL,NULL,NULL,'Relatório de finalidades','Painel'),(10,'relatorio_lia',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(10,'relatorio_notificacao',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(10,'relatorio_resp_aval',NULL,NULL,NULL,NULL,NULL,NULL,'Relatório Avaliações','Painel'),(10,'resumo_finalidade',NULL,NULL,NULL,NULL,NULL,NULL,'Resumo de finalidade','Painel'),(10,'Riscos','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Painel / Riscos: Acesso à exibição dos principais indicadores sobre Gestão de Riscos de Privacidade e Compliance','Painel'),(10,'risk_heat_map','Y',NULL,NULL,NULL,'Y','Y','[Item de menu] - Riscos / Mapa de Calor: Acesso à exibição do Mapa de Calor dos Riscos cadastrados','Riscos'),(10,'search_public_LGPD_4000_atividades',NULL,NULL,NULL,NULL,NULL,NULL,'Filtro de atividades','Painel'),(10,'sec_change_pswd',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(10,'sec_form_add_users',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(10,'sec_form_edit_users',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(10,'sec_form_sec_apps',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(10,'sec_form_sec_groups',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(10,'sec_form_sec_groups_apps',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(10,'sec_grid_sec_apps',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(10,'sec_grid_sec_groups',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(10,'sec_grid_sec_users',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(10,'sec_grid_sec_users_groups',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(10,'sec_Login',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(10,'sec_menu',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(10,'sec_retrieve_pswd',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(10,'sec_search_sec_groups',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(10,'sec_settings',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(10,'sec_sync_apps',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(10,'sub_consulta_3000_riscos_incidente',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(10,'sub_consulta_3100_assoc_risc_atv',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(10,'sub_consulta_3300_assoc_risc_prc',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(10,'sub_consulta_3400_assoc_risc_fin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(10,'sub_consulta_CMP_1610_ol_agenda',NULL,NULL,NULL,NULL,NULL,NULL,'Sub consulta de agenda de obrigações legais por obrigação','Painel'),(10,'sub_consulta_CMP_2510_det_conf_entrevistados',NULL,NULL,NULL,NULL,NULL,NULL,'Entrevitados em presquisa de auditoria --> Sub Consulta de configuração de entrevidados de pesquisa de auditoria ','Painel'),(10,'sub_consulta_CMP_3000_aplic',NULL,NULL,NULL,NULL,NULL,NULL,'Sub consulta status da aplicação de pesquisa de auditoria','Painel'),(10,'sub_consulta_CMP_4000_respostas_mestre',NULL,NULL,NULL,NULL,NULL,NULL,'Sub consulta status de respostas dos formulários de auditoria dentro de um ciclo ','Painel'),(10,'sub_consulta_configurar_metadados',NULL,NULL,NULL,NULL,NULL,NULL,'Sub consulta configuração de metadados','Painel'),(10,'sub_consulta_LGPD_2097_assoc_med_atv',NULL,NULL,NULL,NULL,NULL,NULL,'Sub consulta de associação entre medidas técnicas e ativos','Painel'),(10,'sub_consulta_LGPD_6200_agenda_treina',NULL,NULL,NULL,NULL,NULL,NULL,'Sub consulta de agenda de treinamentos ','Painel'),(10,'sub_consulta_PAC_1100_sol_portal',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(10,'sub_consulta_PAC_3200_tit_consent',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(10,'sub_consulta_PAC_4000_notificacao',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(10,'sub_consulta_PAG_ocorr_lote_1100',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(10,'sub_form_configurar_metados',NULL,NULL,NULL,NULL,NULL,NULL,'Configurar metadados','Painel'),(10,'sub_grid_CMP_1550_ger_acao',NULL,NULL,NULL,NULL,NULL,NULL,'Sub grid de recomendaçoes de auditoria por ciclo','Painel'),(10,'sub_grid_LGPD_2050_assoc_atv_art',NULL,NULL,NULL,NULL,NULL,NULL,'Sub consulta de associação entre ativos e artefatos',NULL),(10,'sub_grid_PAC_1400_tit_afet_inc',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(10,'sub_grid_public_LGPD_2093_ocorr_terc',NULL,NULL,NULL,NULL,NULL,NULL,'Sub consulta ocorrência de terceiros','Painel');
/*!40000 ALTER TABLE `sec_groups_apps` ENABLE KEYS */;
-- UNLOCK TABLES;

--
-- Table structure for table `sec_log_tetantivas`
--

DROP TABLE IF EXISTS `sec_log_tetantivas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sec_log_tetantivas` (
  `login` varchar(255) NOT NULL,
  `nr_tentativas` int DEFAULT NULL,
  PRIMARY KEY (`login`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sec_log_tetantivas`
--

-- LOCK TABLES `sec_log_tetantivas` WRITE;
/*!40000 ALTER TABLE `sec_log_tetantivas` DISABLE KEYS */;
/*!40000 ALTER TABLE `sec_log_tetantivas` ENABLE KEYS */;
-- UNLOCK TABLES;

--
-- Table structure for table `sec_node_menu`
--

DROP TABLE IF EXISTS `sec_node_menu`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sec_node_menu` (
  `id_node` int NOT NULL AUTO_INCREMENT,
  `desc_node` char(100) DEFAULT NULL,
  `product_acronym` char(10) DEFAULT NULL,
  `order_node` int DEFAULT NULL,
  `name_img_node` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id_node`)
) ENGINE=InnoDB AUTO_INCREMENT=38 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sec_node_menu`
--

-- LOCK TABLES `sec_node_menu` WRITE;
/*!40000 ALTER TABLE `sec_node_menu` DISABLE KEYS */;
INSERT INTO `sec_node_menu` VALUES (1,'Painel','PCP',1,'painel-branco.png'),(2,'Configurações','PCP',13,'setup.png'),(3,'Auditoria de Compliance','PCP',10,'auditoria-compliance-branco.png'),(4,'Estrutura Organizacional','PCP',2,'estrutura.png'),(5,'Fluxo de Informação','PCP',3,'fluxo-informacao-branco.png'),(6,'Tratamento de Dados Pessoais','PCP',4,'dados.png'),(7,'Políticas e Regulamentos','PCP',5,'administrativas.png'),(8,'Medidas Técnicas de Segurança','PCP',7,'tatica.png'),(9,'Atividades e Ações','PCP',12,'atividades-acoes-branco.png'),(10,'Segurança','PCP',14,'seguranca.png'),(11,'Riscos','PCP',11,'riscos-branco.png'),(13,'Gestão de Terceiros','PCP',6,'gestao-terceiros-branco.png'),(14,'Aspectos Jurídicos','PCP',8,'aspecto-juridicos-branco.png'),(15,'Pilares de Compliance','PCP',9,'compliance.png'),(16,'Portal do Titular','PAC',1,'portal.png'),(17,'Portal de Denúncias','PAC',2,'denuncias.png'),(18,'Titulares','PAC',3,'titulares.png'),(19,'Incidentes','PAC',4,'incidentes.png'),(20,'Notificações','PAC',5,'notificacoes.png'),(21,'Consentimento','PAC',6,'consentimentos.png'),(22,'Relatórios','PAC',7,'relatorios.png'),(37,'Relatórios de Conformidade','PCP',14,'auditoria-compliance-branco.png');
/*!40000 ALTER TABLE `sec_node_menu` ENABLE KEYS */;
-- UNLOCK TABLES;

--
-- Table structure for table `sec_node_niv2_menu`
--

DROP TABLE IF EXISTS `sec_node_niv2_menu`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sec_node_niv2_menu` (
  `id_node_niv2` int NOT NULL AUTO_INCREMENT,
  `id_node` int DEFAULT NULL,
  `desc_node_niv2` varchar(150) DEFAULT NULL,
  `ordem_node_niv2` int DEFAULT NULL,
  PRIMARY KEY (`id_node_niv2`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sec_node_niv2_menu`
--

-- LOCK TABLES `sec_node_niv2_menu` WRITE;
/*!40000 ALTER TABLE `sec_node_niv2_menu` DISABLE KEYS */;
/*!40000 ALTER TABLE `sec_node_niv2_menu` ENABLE KEYS */;
-- UNLOCK TABLES;

--
-- Table structure for table `sec_settings`
--

DROP TABLE IF EXISTS `sec_settings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sec_settings` (
  `set_name` varchar(255) NOT NULL,
  `set_value` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`set_name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sec_settings`
--

-- LOCK TABLES `sec_settings` WRITE;
/*!40000 ALTER TABLE `sec_settings` DISABLE KEYS */;
INSERT INTO `sec_settings` VALUES ('brute_force','N'),('brute_force_attempts','10'),('brute_force_time_block','10'),('cookie_expiration_time','30'),('enable_2fa','N'),('enable_2fa_expiration_time','300'),('new_users','Y'),('remember_me','Y'),('retrieve_password','Y'),('session_expire','R');
/*!40000 ALTER TABLE `sec_settings` ENABLE KEYS */;
-- UNLOCK TABLES;

--
-- Table structure for table `sec_users`
--

DROP TABLE IF EXISTS `sec_users`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sec_users` (
  `login` varchar(255) NOT NULL,
  `pswd` varchar(255) NOT NULL,
  `name` varchar(64) DEFAULT NULL,
  `email` varchar(64) DEFAULT NULL,
  `active` varchar(1) DEFAULT NULL,
  `activation_code` varchar(32) DEFAULT NULL,
  `priv_admin` varchar(1) DEFAULT NULL,
  `mfa` varchar(255) DEFAULT NULL,
  `picture` blob,
  `cpf` char(11) DEFAULT NULL,
  `telefone` char(20) DEFAULT NULL,
  `controlador` int DEFAULT NULL,
  `cargo` int DEFAULT NULL,
  `organograma` int DEFAULT NULL,
  `nome` text,
  `id_user` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`id_user`),
  UNIQUE KEY `ixsec_users_01` (`login`)
) ENGINE=InnoDB AUTO_INCREMENT=1531 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sec_users`
--

-- LOCK TABLES `sec_users` WRITE;
/*!40000 ALTER TABLE `sec_users` DISABLE KEYS */;
INSERT INTO `sec_users` VALUES ('admin','21232f297a57a5a743894a0e4a801fc3','Admin','anderson.mattiuci@omnisblue.com','Y','','Y',NULL,_binary '����\0�Exif\0\0II*\0\0\0\0\0\0\0\0\0\0\0\0\Z\0\0\0\0b\0\0\0\0\0\0\0j\0\0\0(\0\0\0\0\0\0\01\0\0\0\0r\0\0\02\0\0\0\0�\0\0\0i�\0\0\0\0�\0\0\0cati`\0\0\0\0\0\0`\0\0\0\0\0\0PhotoFiltre Studio X\02020:10:21 13:05:37\0\0\0�\0\0\0\00210�\0\0\0\0e\0\0\0�\0\0\0\0x\0\0\0��\0C\0\n\n\n\r\r��\0C		\r\r��\0\0x\0e\"\0��\0\0\0\0\0\0\0\0\0\0\0	\n��\0�\0\0\0}\0!1AQa\"q2���#B��R��$3br�	\n\Z%&\'()*456789:CDEFGHIJSTUVWXYZcdefghijstuvwxyz���������������������������������������������������������������������������\0\0\0\0\0\0\0\0	\n��\0�\0\0w\0!1AQaq\"2�B����	#3R�br�\n$4�%�\Z&\'()*56789:CDEFGHIJSTUVWXYZcdefghijstuvwxyz��������������������������������������������������������������������������\0\0\0?\0�R�)?\n?\Z0h\0�(\'ڑ����^S�Hk�;��=WY�,�|w:|/=ѻ��*£,�s�r����q�*\'5N.O��\ZN�H�M&��c��J�K�����;h�^y�TE�py���S�(���;�i�0�l���%a_�>/���O����Z���>w)���S?�^��Ps��������]��?@�J����Jߝ�\0#�kL��~j�,Px��6\'�����5�GC���X�Z�vo�n,�Yco�) ��I�]7�~%��ᆶ������2�0ޱ���G�nqE<�W��t�~����Q��_���O�����h��~u�4��O`���l����,��\' �ʞU\'��k��ԍX���3�+Щ����V����h�kC�_OƊ\0_})?\Z1�@�Ҿh���$O�߄Q��2�7�\"��1C��2��c�O���\\������\0��o�OJ-��m1��e*N?툯?Q��ɯC���*��5%���Z~\'�^����\0��K�_l|\Z�/�����Y�b��Z�n�A��|Ѩa�ڻO��Xz��g�ˉ��sQ�S�*L�}��������L�W봔�_C�<�J3��W����g\'��2�\r<?2�m?b�1��jS�������}����\0�<�?ċ��?�G+Em��|���w�e��9꧵~��۰A�>�\Z�k���K��.���Ham��4G�p	ϱ� �z����Q�φ��dm�^i�ǒKS_[���R�Mψ�P~��_��N����i\Z�C�C�Ɗ\0L�F=�ǽ.=�N����y<e�OxWEV1��n� �\'�.G�A?�}��t����GU��<\'��DPAs��?x��@ߏ����^qQC��oO��p�9�����ω~�[ice�]�s@���\ZY���������o���E��R���r�}��b�\nOPĎzЈ�����)o�?.@S!\0�Rޙ��\\w�_x��v��Ǌ<;q�Ȣ�x�دJ���\n>yI\nrN0O������y���)�^닻�m��ǺWíj�����2¢��1�>���\'L��<�\\�W�iK#\0&��+O�.���`�I�s�J�^\'�o���Y<m�i|?smpЪJQ�e��$�`!���-�h�S����\ntգ(���?l_	�wg�x��Ѫ���s#=��O���~\n[5����뇏A�V����c���ƫ�$�-�B���Z��L�q��_Y|4�[�i����d���,l����\rH���m=�����)?�S�j_Əƾ��p�(��h����u�׆�\\�f����F0��5�n��Ȇ6u �?�{�=��:l���5h|�*��X6?J�34q4������zD���OG��<jշ[Dq��jG�b�����$����s��NS� ��I�Vk���M$�T.ۖ�o+�����J*��M�2�H��s�`O���G$q��G����Oq-��j�o���`	��Ԁ��#>��\0?Z���I�i�]	�R5���1n�|}��Y,o#ZM�������ѿ�4x,�������\0>����i�}SP�|�A\n9�N?�^������	RX��=>G�f��N��胏CG��Ɨ�<8�4R�4P(��K����`zR�zw�G��x�����&�����-�D�����W�	.�{�b8h�2Q�q�}@ǩ���ڴZ��.��;�$��+�\\n��n��Y�WO��ih����E�fRT*j���\0�6zT6m��.>����$�\0J�<?����o��O�Z����:��J�t�7^ծm���+Xwa�3�Nx�5�%i����q����Y|1��J��?���3t��B���ȫ���%�v���N�u\'Ԟ�`{с�K����*	F*�ۓ��LJ\\\n?\Z?\Z�~4P�I��Apy��_ŝ/��Mo�Z�<��t`��g<��R0{e���2{SI�d&�Sl�_���^#����m�f��K�uY�z�\r�V�	�d$1�/Pp[>ƿ6~1~���-y�q���Z4�_���,���g�n:�B���x&��<s��ˬ��q9;�~��O���W�l�r�l�(�����?m4�C@��~�&�	.��#���*���$\n�[�,4}\Z�Sԧ�\r:�&��yP\"�I=s����`8��\0=+���k�\0���\'��_��E]3R��͒\"��g�(PlV���I�#<�u1��R�ޭj��lj~��o��\\���i����2�;夵,Do�~\0`8�*���MC�;�^�Xo�G~سӦ$�PF�d\0� �q�	u��CJ��<cp�����+V6w,Ԣ�5�W��j�0����Z���P���p���(��������My�;�l*\\�%�+-ϩ�</�FiR��n�k��~��?\r?�~\r���oh���l����=��/��;�����~$�<_�Yj�5�:��y��v܎�u�\0�u�~	��e�?�~����/x��&���x�PЦ$KiO�)7�~G��B�?cC���D�{��O�<\n0+��w�\"���t���=����M�(2�M���aܔ+��)�E-�\"��)��e�U�#d:���5�N���x�iW�ex2|\n)0=h��� _\Z�S�����؆\"[�C��L��\r��N����\0i����(�uo/�O��#?���z���>Z?<�v4n��9���^����|.`�����_��\r���\0`}JL���WP}2ҁ����F��p�.�q���M�\\}��	�~��c�O�����b톓��>��৚т�(���#aK��2�4߰G����\0�W��\'H~&�����X��O���G�;q�|Uա<	4y14?����-V��_�c~?�sy��w�+������}ω���o�/�/��뛃u3H���{T|Ƥ�#�l�8�2�����N����W�5�Y�S�+���C,�Z�bNs��y!������s_���MG�߲�����yo�L�����J�����Z��\0#�(����,�0n��~L�\0�P<C���F�iᲚN�mnW�����������|g��?��ϐ�(��E�#��`�<G��#�k�����\0��-�ZiS��G�����?�9�?ɟU�QO=�/���\0J���\\y�9���p�_���-|U�vQį\Z?Lk��=袼����>��D���y�~l�;ر�X�Q_N~:.�_���J}G���[\"r��!���o�V�����\0�p�^��S�+�>���','18274869885','1180782875',1,4,0,'Admin',1);
/*!40000 ALTER TABLE `sec_users` ENABLE KEYS */;
-- UNLOCK TABLES;

--
-- Table structure for table `sec_users_groups`
--

DROP TABLE IF EXISTS `sec_users_groups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sec_users_groups` (
  `login` varchar(255) NOT NULL,
  `group_id` int NOT NULL,
  PRIMARY KEY (`login`,`group_id`),
  CONSTRAINT `users_groups_ibfk_1` FOREIGN KEY (`login`) REFERENCES `sec_users` (`login`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sec_users_groups`
--

-- LOCK TABLES `sec_users_groups` WRITE;
/*!40000 ALTER TABLE `sec_users_groups` DISABLE KEYS */;
INSERT INTO `sec_users_groups` VALUES ('admin',1);
/*!40000 ALTER TABLE `sec_users_groups` ENABLE KEYS */;
-- UNLOCK TABLES;

--
-- Final view structure for view `CMP_VIEW_1600`
--

/*!50001 DROP VIEW IF EXISTS `CMP_VIEW_1600`*/;
/*!50001 SET @saved_cs_client          = @@character_set_client */;
/*!50001 SET @saved_cs_results         = @@character_set_results */;
/*!50001 SET @saved_col_connection     = @@collation_connection */;
/*!50001 SET character_set_client      = utf8mb4 */;
/*!50001 SET character_set_results     = utf8mb4 */;
/*!50001 SET collation_connection      = utf8mb4_0900_ai_ci */;
/*!50001 CREATE ALGORITHM=UNDEFINED */
/*!50013 DEFINER=`anderson`@`%` SQL SECURITY DEFINER */
/*!50001 VIEW `CMP_VIEW_1600` AS select `t2`.`id_CMP_1610_ol_agenda` AS `id_CMP_1610_ol_agenda`,`t3`.`email_1100` AS `email_1100`,`t2`.`data_ol_1610` AS `data_ol_1610`,`t1`.`desc_ol_1600` AS `desc_ol_1600`,`t1`.`ano_ol_1600` AS `ano_ol_1600`,`t1`.`desc_penalidade_ol_1600` AS `desc_penalidade_ol_1600`,`t1`.`dia_ol_1600` AS `dia_ol_1600`,`t1`.`dia_semana_ol_1600` AS `dia_semana_ol_1600`,`t6`.`titulo_fund_leg_2065` AS `titulo_fund_leg_2065`,`t1`.`mes_ol_1600` AS `mes_ol_1600`,`t4`.`desc_tp_ol_1600` AS `desc_tp_ol_1600`,`t5`.`desc_per_ol_1600` AS `desc_per_ol_1600` from (((((`CMP_1600_OL` `t1` join `CMP_1610_ol_agenda` `t2` on((`t2`.`id_ol_1600` = `t1`.`id_ol_1600`))) join `LGPD_1100_equipe` `t3` on((`t3`.`cod_pessoa_1100` = `t1`.`resp_ol_1600`))) join `DOM_tp_ol_1600` `t4` on((`t4`.`id_tp_ol_1600` = `t1`.`tipo_ol_1600`))) join `DOM_per_ol_1600` `t5` on((`t5`.`id_per_ol_1600` = `t1`.`perdiodicidade_ol_1600`))) left join `LGPD_2065_fund_legal` `t6` on((`t6`.`cod_fund_leg_2065` = `t1`.`id_tp_fund_leg_2065`))) */;
/*!50001 SET character_set_client      = @saved_cs_client */;
/*!50001 SET character_set_results     = @saved_cs_results */;
/*!50001 SET collation_connection      = @saved_col_connection */;

/*!40103 SET TIME_ZONE=@OLD_TIME_ZONE */;

/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
/*!40111 SET SQL_NOTES=@OLD_SQL_NOTES */;

-- Dump completed on 2025-12-12 17:07:34
