<?php
// Cabeçalhos da resposta
header('Content-Type: application/json');

require_once '../src/OdooClient.php';
require_once '../src/EmailService.php';
require_once '../src/Logger.php';
require_once '../src/WebhookNotifier.php';

use Src\OdooClient;
use Src\EmailService;
use Src\Logger;

$config = require '../src/config.php';
define('API_TOKEN', $config['api_token']);

$headers = getallheaders();
$authHeader = $headers['Authorization'] ?? '';

if (!$authHeader || !preg_match('/Bearer\s(\S+)/', $authHeader, $matches)) {
    http_response_code(401);
    echo json_encode(["error" => "Token ausente ou inválido"]);
    exit;
}

$incomingToken = $matches[1];
if ($incomingToken !== API_TOKEN) {
    http_response_code(401);
    echo json_encode(["error" => "Token inválido"]);
    exit;
}

$input = json_decode(file_get_contents('php://input'), true);
$email = $input['email'] ?? '';
$campo = $input['campo'] ?? '';
$valor = $input['valor'] ?? '';
$manyField = $input['manyField'] ?? '';
$extraFields = $input['fields'] ?? [];
$acao = $input['acao'] ?? '';
$dados = $input['dados'] ?? [];

$odoo = new OdooClient();
$emailService = new EmailService($odoo);

try {
    if ($acao === 'adicionar_usuario_aba' && isset($input['empresa']) && isset($input['usuario']) && isset($input['nome'])) {
        $status = $input['status'] ?? 'Ativo';
        $resultado = $emailService->adicionarOuAtualizarVinculoPlataformaPorEmail($input['empresa'], $input['usuario'], $input['nome'], $status);
        
        echo json_encode(["status" => $resultado ? "ok" : "erro"]);
        Logger::log("Ação 'adicionar_usuario_aba' executada para empresa {$input['empresa']} e usuário {$input['usuario']}");
        return;
    }

    if (isset($input['acao']) && $input['acao'] === 'buscarPorCNPJ') {
        echo json_encode($emailService->buscarPorCNPJ($input['cnpj']));
        exit;
    }



    if ($acao && $email && is_array($dados)) {
        $resultado = $emailService->criarOuAtualizarContato($acao, $email, $dados);
        echo json_encode(["status" => "ok", "dados" => $resultado]);
        Logger::log("Ação '$acao' executada com sucesso para o e-mail $email");

    } elseif ($email) {
        $resultado = $emailService->buscarPorEmail($email);

        // Tratamento seguro de JSON
        if (isset($resultado['status']) && isset($resultado['dados'])) {
            $json = json_encode($resultado, JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES | JSON_PARTIAL_OUTPUT_ON_ERROR);
        } else {
            $json = json_encode([
                "status" => "ok",
                "dados" => $resultado
            ], JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES | JSON_PARTIAL_OUTPUT_ON_ERROR);
        }

        if ($json === false) {
            echo json_encode([
                "status" => "erro",
                "mensagem" => "Erro ao gerar JSON",
                "json_error" => json_last_error_msg()
            ]);
        } else {
            echo $json;
        }

        Logger::log("Consulta por e-mail realizada com sucesso");

    } elseif ($manyField) {
        $dados = $emailService->buscarDetalhesMany2Many($campo, $valor, $manyField, $extraFields);
        echo json_encode(["status" => "ok", "dados" => $dados]);
        Logger::log("Consulta many2many realizada com sucesso");

    } else {
        $dados = $emailService->buscarPorCampo($campo, $valor, $extraFields);
        echo json_encode(["status" => "ok", "dados" => $dados]);
        Logger::log("Consulta genérica realizada com sucesso");
    }
} catch (Exception $e) {
    Logger::log("Erro ao processar requisição: " . $e->getMessage());
    http_response_code(500);
    echo json_encode(["error" => "Erro interno ao processar requisição"]);
}
