<?php
namespace Src;

class Logger
{
    public static function log($message)
    {
        // Definindo o caminho com timestamp diário
        $logDirectory = __DIR__ . '/../logs/';
        if (!is_dir($logDirectory)) {
            mkdir($logDirectory, 0777, true);
        }

        // Formato do arquivo: api-YYYY-MM-DD.log
        $date = date('Y-m-d');
        $logFile = $logDirectory . 'api-' . $date . '.log';

        // Formato da mensagem no log
        $timestamp = date('Y-m-d H:i:s');
        $logMessage = "[$timestamp] - $message" . PHP_EOL;

        // Gravando no arquivo
        file_put_contents($logFile, $logMessage, FILE_APPEND);
    }
}
?>
