<?php
namespace Src;

class OdooClient
{
    private $url;
    private $db;
    private $login;
    private $token;
    private $userId;

    public function __construct()
    {
        $config = require '../src/config.php';
        $this->url = $config['url'];
        $this->db = $config['db'];
        $this->login = $config['login'];
        $this->token = $config['token'];
    }

    public function getUserId()
    {
        if ($this->userId) {
            return $this->userId;
        }

        $authUrl = $this->url . "/jsonrpc";

        $data = json_encode([
            "jsonrpc" => "2.0",
            "method" => "call",
            "params" => [
                "service" => "common",
                "method" => "authenticate",
                "args" => [
                    $this->db,
                    $this->login,
                    $this->token,
                    []
                ]
            ],
            "id" => 1
        ]);

        $ch = curl_init($authUrl);
        curl_setopt_array($ch, [
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_POST => true,
            CURLOPT_POSTFIELDS => $data,
            CURLOPT_HTTPHEADER => [
                'Content-Type: application/json',
                'Accept: application/json',
                'User-Agent: Odoo-Client/1.0'
            ],
        ]);

        $response = curl_exec($ch);

        if ($response === false) {
            $error = curl_error($ch);
            curl_close($ch);
            Logger::log("Erro cURL na autenticação: " . $error);
            return false;
        }

        curl_close($ch);

        $result = json_decode($response, true);

        if (isset($result['result']) && is_numeric($result['result'])) {
            $this->userId = $result['result'];
            Logger::log("Autenticação bem-sucedida. User ID: " . $this->userId);
            return $this->userId;
        }

        Logger::log("Erro ao obter User ID do Odoo: " . json_encode($result));
        return false;
    }

    public function request($model, $method, $args = [], $fields = [])
    {
        $userId = $this->getUserId();

        if (!$userId) {
            Logger::log("Tentativa de requisição sem usuário autenticado.");
            return false;
        }

        // Ajuste no payload para usar o serviço e método corretos
        $payload = json_encode([
            "jsonrpc" => "2.0",
            "method" => "call",
            "params" => [
                "service" => "object",
                "method" => "execute_kw",
                "args" => [
                    $this->db,
                    $userId,
                    $this->token,
                    $model,
                    $method,
                    $args
                ],
                "kwargs" => ["fields" => $fields]
            ],
            "id" => 1
        ]);

        $ch = curl_init($this->url . "/jsonrpc");
        curl_setopt_array($ch, [
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_POST => true,
            CURLOPT_POSTFIELDS => $payload,
            CURLOPT_HTTPHEADER => [
                'Content-Type: application/json',
                'Accept: application/json',
                'User-Agent: Odoo-Client/1.0'
            ],
        ]);

        $response = curl_exec($ch);

        if ($response === false) {
            $error = curl_error($ch);
            curl_close($ch);
            Logger::log("Erro cURL na requisição: " . $error);
            return false;
        }

        curl_close($ch);

        $result = json_decode($response, true);

        if (isset($result['error'])) {
            Logger::log("Erro na requisição Odoo: " . json_encode($result['error']));
            return false;
        }

        Logger::log("Requisição Odoo bem-sucedida. Resultado: " . json_encode($result['result']));
        return $result['result'] ?? [];
    }
}
?>
