<?php
namespace Src;

class WebhookNotifier
{
    private static $webhookUrl = 'https://meuservidor.com/webhook';

    public static function send($event, $data)
    {
        $payload = json_encode([
            "action" => "send-email",
            "email-config" => [
                "to" => "notificacao@empresa.com",
                "subject" => $event,
                "body" => json_encode($data)
            ]
        ]);

        $ch = curl_init(self::$webhookUrl);
        curl_setopt_array($ch, [
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_POST => true,
            CURLOPT_POSTFIELDS => $payload,
            CURLOPT_HTTPHEADER => [
                'Content-Type: application/json'
            ],
        ]);

        $response = curl_exec($ch);
        curl_close($ch);

        return $response;
    }
}
?>
