<?php

use Src\Logger;

error_reporting(E_ALL);

require_once __DIR__ . '/../src/Logger.php';
require_once __DIR__ . '/src/Config.php';
require_once __DIR__ . '/src/Mailer.php';
require_once __DIR__ . '/src/Webhook.php';
require_once __DIR__ . '/src/WebhookResponse.php';
require_once __DIR__ . '/src/Actions/SendEmailAction.php';
require_once __DIR__ . '/src/Actions/WebhookActionInterface.php';
require_once __DIR__ . '/libs/phpmailer/PHPMailer.php';
require_once __DIR__ . '/libs/phpmailer/SMTP.php';
require_once __DIR__ . '/libs/phpmailer/Exception.php';

use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;

header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json; charset=UTF-8");
header("Access-Control-Allow-Methods: POST");
header("Access-Control-Max-Age: 3600");
header("Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With");
header("Cache-Control: no-cache, must-revalidate, max-age=0");

//use Src\Logger;

$logger = new Logger();

try{

    Config::load(__DIR__ . '/Config.ini');

    $headers = getallheaders();

    $data = file_get_contents('php://input');
    $data = json_decode($data, true);

    $webhook = new Webhook($logger, $data, $headers, $_SERVER['REQUEST_METHOD']);
    $webhook->handle();

}catch(\Throwable $e){
    http_response_code(500);
    echo json_encode([
        "success" => false,
        "message" => "Internal Server Error"
    ]);
    Logger::log($e->getMessage());
    //$logger->logError($e->getMessage());
}
