<?php

use PHPMailer\PHPMailer\PHPMailer;

require_once __DIR__ . '/WebhookActionInterface.php';
require_once __DIR__ . '/../Mailer.php';
require_once __DIR__ . '/../Webhook.php';
require_once __DIR__ . '/../../libs/phpmailer/PHPMailer.php';

class SendEmailAction implements WebhookActionInterface {

    public function handle(Webhook $webhook, array $payload) {

        if (!array_key_exists('email-config', $payload)) {
            $webhook->errorResponse("The field 'email-config' is required for action 'send-email'");
        }

        $email_conf = $payload['email-config'];
        $required_email_conf_fields = ['to', 'subject', 'body'];

        foreach ($required_email_conf_fields as $field) {
            if (empty($email_conf[$field])) {
                $webhook->errorResponse("The field '$field' is required in 'email-config'");
            }
        }

        $mailer = new PHPMailer(false);

        $send = Mailer::sendEmail(
            $mailer,
            $email_conf['to'],
            $email_conf['subject'],
            $email_conf['body']
        );

        if ($send) {
            $webhook->successResponse("Email sent successfully");
        }
    }
}
