<?php

//namespace App;

use \Exception;

class Config {
    private static $config = [];

    public static function load($file) {
        if (!file_exists($file)) {
            throw new Exception("Arquivo de configuração não encontrado: $file");
        }

        $ext = pathinfo($file, PATHINFO_EXTENSION);
        if ($ext === 'ini') {
            self::$config = parse_ini_file($file, true);
        } elseif ($ext === 'json') {
            self::$config = json_decode(file_get_contents($file), true);
        } else {
            throw new Exception("Formato de configuração inválido.");
        }
    }

    public static function get($section, $key) {
        return self::$config[$section][$key] ?? null;
    }
}