<?php

    namespace App;
    
    use \DateTimeZone;
    use \DateTime;
use Exception;

    class Logger{

        private string $log_path = '/logs/';


        public function __construct() {
            $this->log_path = dirname(__FILE__, 2) . $this->log_path;

            if(!is_dir($this->log_path)){
               if(!mkdir($this->log_path, 0777)){
                    throw new Exception('Failed to create the log folder');
               }
            }

        }

        private function getCurrentDateTime() : string{
            $timezone = new DateTimeZone('America/Fortaleza');
            $date = new DateTime('now', $timezone);
            return $date->format('Y-m-d H:i:s');
        }

        private function filePath($filename): string{
            return $this->log_path . $filename;
        }

        public function logResponse(WebhookResponse $response, ?array $payload) : void{

            $date = $this->getCurrentDateTime();
            $filename = $this->filePath('webhook.log');

            if($payload != NULL && !empty($payload)){
                $payload = json_encode($payload, JSON_UNESCAPED_UNICODE);
            }else{
                $payload = 'null';
            }
            
            $success = $response->success ? 'true' : 'false';

            $log_line = "timestamp=\"$date\" | payload=$payload | http_status=$response->http_code | success=$success | message=\"$response->message\"" . PHP_EOL;

            file_put_contents($filename, $log_line, FILE_APPEND);

        }

        public function logError(string $message){
            $date = $this->getCurrentDateTime();
            $filename = $this->filePath('webhook_error.log');

            $logMessage = "timestamp=\"$date\" | message=\"$message\"" . PHP_EOL;

            file_put_contents($filename, $logMessage, FILE_APPEND);

        }

    }
