<?php

require_once __DIR__ . '/../libs/phpmailer/PHPMailer.php';
require_once __DIR__ . '/../libs/phpmailer/SMTP.php';
require_once __DIR__ . '/../libs/phpmailer/Exception.php';
require_once __DIR__ . '/../src/Logger.php';


use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;
use Src\Logger;

$logger = new Logger();

class Mailer{
    
    public static function sendEmail(
        PHPMailer $mailer,
        string|array $emailsDeDestino, 
        string $assunto = '', 
        string $corpoDoEmail = '') : bool
    {

        $host = Config::get('smtp', 'host');
        $username = Config::get('smtp', 'username');
        $password = Config::get('smtp', 'password');
        $port = Config::get('smtp', 'port');
        $from = Config::get('smtp', 'from');
        $from_name = Config::get('smtp', 'fromName');

        if(!$host || !$username || !$password || !$port || !$from || !$from_name){
            throw new \Exception("SMTP settings are not properly defined in the configuration file.");
        }
        
        try {

            $mailer->SMTPDebug = 2;
            $mailer->Debugoutput = function($str, $level) {
                //Logger::log("[SMTP DEBUG] $str");
            };



            $mailer->SMTPSecure = PHPMailer::ENCRYPTION_STARTTLS;
            $mailer->SMTPAuth = true;
            $mailer->CharSet = "UTF-8";
            $mailer->isSMTP();

            $mailer->Host = $host;
            $mailer->Username = $username;
            $mailer->Password = $password;
            $mailer->Port = $port;

            $mailer->setFrom($from, $from_name);

            $mailer->SMTPOptions = [
                'ssl' => [
                    'verify_peer' => false,
                    'verify_peer_name' => false,
                    'allow_self_signed' => true
                ]
            ];

            if(is_string($emailsDeDestino)){
                $emailsDeDestino = explode(';', $emailsDeDestino);
            }

            foreach ($emailsDeDestino as $emailDestinatario) {
                if(filter_var($emailDestinatario, FILTER_VALIDATE_EMAIL)){
                    $mailer->addAddress($emailDestinatario);
                }
            }

            if (empty($mailer->getToAddresses())) {
                throw new Exception("No valid email address was provided.");
            }

            $mailer->Subject = $assunto;
            $mailer->Body = $corpoDoEmail;

            if(!$mailer->send()){
                throw new Exception("Email failed to send: " . $mailer->ErrorInfo);

            }

            return true;
            
        } catch (\Throwable $e) {
            throw new \Exception("Email failed to send: " . $e->getMessage());
        }
    }
}